<?php
namespace App\Models;
use CodeIgniter\Model;

class LegalesModel extends Model
{
    protected $table      = 'legales';
    protected $primaryKey = 'IDLegal';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['Titulo', 'Texto', 'Acta', 'Elementos', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function buscarLegalXactaXelementos($acta, $elementos)
    {
        $this->select('Titulo,
            Texto,
            Acta,
            Elementos');
        
        if(!empty($elementos))
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            foreach ($elementos as $termino) {
                $this->orWhere('Elementos LIKE "%' . $termino . '%"');
            }
            $this->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        if($acta != '')
        {
            $this->where('Acta', $acta);
        }
        
        $datos = $this->findAll();
        // echo $this->getLastQuery();
        
        return $datos;
    }
}