<?php
namespace App\Models;
use CodeIgniter\Model;

class AccesoriosITModel extends Model
{
    protected $table      = 'accesorios_it';
    protected $primaryKey = 'IDAccesorio';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['Accesorio', 'IDModelo', 'IDSubtipo', 'Observacion', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listarAccesorios($estado)
    {
        $this->select('accesorios_it.IDAccesorio,
            accesorios_it.Accesorio,
            accesorios_it.IDModelo,
            marcas_dispositivos.Modelo,
            marcas.Marca,
            subtipo.nombre_subtipo,
            tipo.nombre_tipo,
            categoria.nombre_categoria,
            accesorios_it.Estado');
        $this->join('marcas_dispositivos', 'accesorios_it.IDModelo = marcas_dispositivos.IDDispositivo', 'left');
        $this->join('marcas', 'marcas_dispositivos.IDMarca = marcas.IDMarca', 'left');
        $this->join('subtipo', 'accesorios_it.IDSubtipo = subtipo.id_subtipo', 'left');
        $this->join('tipo', 'subtipo.id_tipo = tipo.id_tipo', 'left');
        $this->join('categoria', 'tipo.id_categoria = categoria.id_categoria', 'left');
        
        if($estado != '')
        {
            $this->where('accesorios_it.Estado', $estado);
        }
        
        $datos = $this->findAll();
        return $datos;
    }

    public function obtenerAccesorio($idAccesorio)
    {
        $this->select('accesorios_it.IDAccesorio,
            accesorios_it.Accesorio,
            accesorios_it.IDModelo,
            accesorios_it.Observacion,
            marcas_dispositivos.Modelo,
            marcas_dispositivos.IDMarca,
            marcas.Marca,
            accesorios_it.IDSubtipo,
            subtipo.nombre_subtipo,
            subtipo.id_tipo,
            tipo.nombre_tipo,
            tipo.id_categoria,
            categoria.nombre_categoria,
            accesorios_it.Estado');
        $this->join('marcas_dispositivos', 'accesorios_it.IDModelo = marcas_dispositivos.IDDispositivo', 'left');
        $this->join('marcas', 'marcas_dispositivos.IDMarca = marcas.IDMarca', 'left');
        $this->join('subtipo', 'accesorios_it.IDSubtipo = subtipo.id_subtipo', 'left');
        $this->join('tipo', 'subtipo.id_tipo = tipo.id_tipo', 'left');
        $this->join('categoria', 'tipo.id_categoria = categoria.id_categoria', 'left');
        
        $this->where('accesorios_it.IDAccesorio', $idAccesorio);
        
        $datos = $this->first();
        return $datos;
    }
}