<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

class Usuarios extends BaseController
{
	public function __construct(){
		$this->modulo = new \App\Models\ModuloModel();
		$this->usuarioModelo = new \App\Models\UsuarioModelo();
        $this->usuarioPerfil = new \App\Models\UsuarioPerfilModelo();
        $this->usuarioPermisos = new \App\Models\UsuarioPermisosModelo();
        $this->usuarioRutas = new \App\Models\UsuarioRutasModelo();
	}

    public function listarUsuarioDataTable(){
        $orderBy = " ORDER BY ";

        foreach ($this->request->getGet('order') as $order) {
            $orderBy .= $order['column'] + 1 . " {$order['dir']}, ";
        }

        $orderBy = substr($orderBy, 0, -2);
        $columns = $this->request->getGet('columns');
        $fields = ['tblusuario.IdUsuario','nombre_usuario','tblusuario.Matricula','tblusuario.NumeroDoc','perfil_usuario','tblusuario.Usuario','tblusuario.Estado','acciones_usuario'];
        $where = '';

        foreach ($columns as $k => $column) {
            if ($this->request->getGet('search')['value']!="") {
                if($k == 1)
                {
                    $where .= "CONCAT(tblusuario.Nombres, ' ', tblusuario.Apellidos) LIKE '%".$this->request->getGet('search')['value']."%' OR ";
                }
                else if($k == 4 || $k == 7){}
                else
                {
                    $where .= $fields[$k]." LIKE '%".$this->request->getGet('search')['value']."%' OR ";
                }
                
            }
        }

        $where = substr($where, 0, -5);
        $length = $this->request->getGet('length');
        $start = $this->request->getGet('start'); 

        /* LISTAR ORDEN DE COMPRA */
        $listaUsuarios = $this->usuarioModelo->listaGeneralUsuario($orderBy,$where,$length,$start);
        echo json_encode($listaUsuarios, JSON_NUMERIC_CHECK);
    }

	public function listar(){
		if($this->session->get('sesionUsuario')['accesoTmpId'] && in_array(1, $this->items['permisos']) && in_array(2, $this->items['permisos'])){

			/* BUSCAR USUARIOS */
			$whereUsuarios = array(
				'usuarios.eliminacion_logica' => 1
			);
			$listaUsuarios = $this->usuarioModelo
				->where($whereUsuarios)
				->orderBy('fecha_registro','DESC')
				->findAll();

            /* LISTAR MANAGERS */
			$whereManagers = array(
				'usuarios.eliminacion_logica' => 1
			);
			$listaManagers = $this->usuarioModelo
                ->join('usuarios as u', 'u.id_usuario = usuarios.matricula_responsable')
				->where($whereManagers)
				->orderBy('usuarios.apellido_paterno','ASC')
				->findAll();
                
            /* LISTAR ÁREAS */
			$whereAreas = array(
				'areas.eliminacion_logica' => 1
			);
			$listaAreas = $this->areasModelo
                ->where($whereAreas)
                ->join('departamentos', 'departamentos.id_departamento = areas.departamento_id')
                ->orderBy('departamentos.nombre_departamento','ASC')
				->findAll();

            /* LISTAR ROLES */
			$whereRoles = array(
				'roles.eliminacion_logica' => 1
			);
			$listaRoles = $this->rolesModelo
				->where($whereRoles)
				->orderBy('fecha_registro','DESC')
				->findAll();            

			$data = array (
				'session'           => 'on',
				'titulo'            => 'Usuarios | Don Bosco',
				'breadcrumb'        => $this->items['modulo'],
				'listaUsuarios'     => $listaUsuarios,
                'listaAreas'        => $listaAreas,
                'listaRoles'        => $listaRoles,
                'listaManagers'     => $listaManagers
			);
			$data = array_merge($data, $this->items);
			return view('usuarios/listar',$data);			
		} else {			
			return view('errors/500');	
		}
	}

    public function obtenerDatosUsuario()
    {
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idUsuario = $this->request->getPost("idUsuario");

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idUsuario, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
// 			echo $this->alertas->alertaError($message);

			$resultado = array(
				'descripcion' => 0,
				'mensaje'   => $this->alertas->alertaError($message)
			);
			
			echo json_encode($resultado);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosUsuario = $this->usuarioModelo->obtenerUsuario($idUsuario);

		if(!empty($datosUsuario))
		{
		    if($datosUsuario['Area'] == '' || $datosUsuario['Area'] == null || $datosUsuario['Direccion'] == '' || $datosUsuario['Direccion'] == null || $datosUsuario['Cargo'] == '' || $datosUsuario['Cargo'] == null)
		    {
		        $message = sprintf($this->mensajeError->msg201, "La información del usuario no se encuentra actualizada, por lo que no se le puede asignar dispositivos. Contáctese con Soporte IT.");
    		    $resultado = array(
    				'descripcion' => 2,
    				'mensaje'   => $message
    			);
		    }
		    else
		    {
		        $fechaCese = $datosUsuario['FechaCese'] != '' && $datosUsuario['FechaCese'] != null ? date("d-m-Y", strtotime($datosUsuario['FechaCese'])) : null;
		        $resultado = array(
    				'idusuario'     => (string) $idUsuario,
    				'matricula'     => (string) $datosUsuario['Matricula'],
    				'nombres'       => (string) $datosUsuario['Nombres'],
    				'apellidos'     => (string) $datosUsuario['Apellidos'],
    				'tipodoc'       => (string) $datosUsuario['TipoDocumento'],
    				'documento'     => (string) $datosUsuario['NumeroDoc'],
    				'idmanager'     => (string) $datosUsuario['IDManager'],
    				'fechaingreso'  => (string) $datosUsuario['FechaIngreso'],
    				'fte'           => (string) $datosUsuario['FTE'],
    				'correo'        => (string) $datosUsuario['Correo'],
    				'usuario'       => (string) $datosUsuario['Usuario'],
    				'idcargo'       => (string) $datosUsuario['IDCargo'],
    				'idsubarea'     => (string) $datosUsuario['IDSubarea'],
    				'idarea'        => (string) $datosUsuario['IDArea'],
    				'iddireccion'   => (string) $datosUsuario['IDDireccion'],
    				'iddelegacion'  => (string) $datosUsuario['IDDelegacion'],
    				'area'          => (string) $datosUsuario['Area'],
    				'direccion'     => (string) $datosUsuario['Direccion'],
    				'cargo'         => (string) $datosUsuario['Cargo'],
    				'fechacese'     => (string) $fechaCese
    			);
		    }
		} 
		else {
		    $message = sprintf($this->mensajeError->msg201, "No se encontró la información solicitada.");
		    $resultado = array(
				'descripcion' => 0,
				'mensaje'   => $this->alertas->alertaError($message)
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);	
    }

    public function modificarUsuario($idUsuario){

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $perfil = $this->request->getPost('txtPerfilUsuario');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($perfil, 'required|trim', 'Perfil');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * ACTUALIZACIÓN DE DATOS
        * ----------------------------
        */

        $data = array (
            'IdUsuario'         => $idUsuario,
            'IDPerfil'          => $perfil,
            'UsuarioRegistra'   => $this->items['id'],
            'FechaRegistra'     => $fechaActual
        );
        
        $lastId = $this->usuarioPerfil->save($data);
        
		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idUsuario);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

	public function listarPermisosUsuario($idUsuario)
    {
		if(isset($this->items['id'])){
			/* BUSCAR PERMISOS*/
            
			$listaPermisos = $this->usuarioPermisos->listarPermisosUsuario($idUsuario);
            $usuario = $this->usuarioModelo->where("IdUsuario",$idUsuario)->first();
			$listaModulos = $this->modulo->findAll();

			$data = array (
				'session'               => 'on',
				'titulo'                => 'Permisos | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Permisos de Usuario',
                'previo'                => 'listar-usuarios',
				'listaPermisos'         => $listaPermisos,
                'listaModulos'          => $listaModulos,
                'usuarioSeleccionado'   => $usuario,
                'idUsuario'             => $idUsuario
			);
			$data = array_merge($data, $this->items);
			return view('administracion/listar_permisos_usuario',$data);			
		} else {
			return view('errors/500');
		}
	}

	public function listarRutasUsuario($idUsuario)
    {
		if(isset($this->items['id'])){
			/* BUSCAR PERMISOS*/
            
			$listaRutas = $this->usuarioRutas->listarRutasUsuario($idUsuario);
            $usuario = $this->usuarioModelo->where("IdUsuario",$idUsuario)->first();
			$listaModulos = $this->modulo->findAll();

			$data = array (
				'session'               => 'on',
				'titulo'                => 'Rutas | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Rutas de Usuario',
                'previo'                => 'listar-usuarios',
				'listaRutas'            => $listaRutas,
                'listaModulos'          => $listaModulos,
                'usuarioSeleccionado'   => $usuario,
                'idUsuario'             => $idUsuario
			);
			$data = array_merge($data, $this->items);
			return view('administracion/listar_rutas_usuario',$data);			
		} else {
			return view('errors/500');
		}
	}
    
    public function guardarPermisosUsuario($idUsuario)
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $permisos = $this->request->getPost('permisos') ;
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';

        if(isset($permisos) && empty($permisos))
        {
            $error .= "<li>No hay permisos seleccionados.</li>";
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        /*
        * ----------------------------
        * LIMPIAR EXISTENCIA PREVIA
        * ----------------------------
        */

        $listadoPermisosPrev = $this->usuarioPermisos->where("IdUsuario", $idUsuario)->findAll();

        if(count($listadoPermisosPrev) > 0)
        {
            $this->usuarioPermisos->delete($idUsuario);
        }

        /*
        * ----------------------------
        * GENERAR NUEVA DATA
        * ----------------------------
        */

        $dataPermisos = array();

        foreach($permisos as $key => $value)
        {
            $dataPermisos[] = array (
                'IdUsuario'         => $idUsuario, 
                'IDAccionModulo'    => $key,
                'UsuarioRegistra'   => $this->items['id'],
                'FechaRegistra'     => $fechaActual
            );
        }
        $lastId = $this->usuarioPermisos->insertBatch($dataPermisos, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $idUsuario);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function guardarRutasUsuario($idUsuario)
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $rutas = $this->request->getPost('rutas') ;
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';

        if(isset($rutas) && empty($rutas))
        {
            $error .= "<li>No hay rutas seleccionados.</li>";
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        /*
        * ----------------------------
        * LIMPIAR EXISTENCIA PREVIA
        * ----------------------------
        */

        $listadoRutasPrev = $this->usuarioRutas->where("IdUsuario", $idUsuario)->findAll();

        if(count($listadoRutasPrev) > 0)
        {
            $this->usuarioRutas->delete($idUsuario);
        }

        /*
        * ----------------------------
        * GENERAR NUEVA DATA
        * ----------------------------
        */

        $dataRutas = array();

        foreach($rutas as $key => $value)
        {
            $dataRutas[] = array (
                'IdUsuario'         => $idUsuario, 
                'IDRuta'            => $key,
                'UsuarioRegistra'   => $this->items['id'],
                'FechaRegistra'     => $fechaActual
            );
        }
        $lastId = $this->usuarioRutas->insertBatch($dataRutas, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $idUsuario);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
	public function obtenerUsuarios(){
    	/*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        $listadoUsuarios = $this->usuarios->findAll();
        
        $usuarios=array();

		if (!empty($listadoUsuarios)) {
            foreach ($listadoUsuarios as $items) {
                $usuarios[] = array(
					'id' => (string) $items['IdDpto'],
         	        'usuario' => (string) $items['Nombres'].' '.$items['Apellidos'],
                );
            }

            $resultado = array(
				'listadoUsuarios' => json_encode($usuarios)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
	}

    public function listadoUsuariosSelect()
    {
        $elemento = $this->request->getPost('term');
        
        $listado = $this->usuarioModelo->listadoUsuariosSelect($elemento['term']);
        
        $elementos=array();

        foreach ($listado as $items) {
            $elementos[] = array(
                'id' => (string) $items['IdUsuario'],
                'text' => (string) $items['Matricula']." | ".$items['Nombres']." ".$items['Apellidos']
            );
        }

        echo json_encode($elementos);
    }

}