<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;
class Cargos extends BaseController
{
	public function __construct(){
	    
        $this->usuarios = new \App\Models\UsuarioModelo();
        
        $this->estructuraDirecciones = new \App\Models\EstructuraDireccionModel();
        $this->estructuraAreas = new \App\Models\EstructuraAreaModel();
        $this->estructuraSubareas = new \App\Models\EstructuraSubareaModel();
        $this->estructuraDelegaciones = new \App\Models\EstructuraDelegacionModel();
        
        $this->elementosDemo = new \App\Models\ElementosDemoModel();
        
        $this->moviles = new \App\Models\VAMovilesModel();
        $this->lineas = new \App\Models\VALineasModel();
        $this->contratos = new \App\Models\VALineasContratoModel();
        $this->tarjetasAcceso = new \App\Models\VATarjetasAccesoModel();
        $this->hardware = new \App\Models\VAHardwareModel();
        $this->kitsDemo = new \App\Models\KitsDemoModel();
        $this->accesoriosit = new \App\Models\AccesoriosITModel();
        
        $this->legales = new \App\Models\LegalesModel();
        
        $this->asignaciones = new \App\Models\VAAsignacionesModel();
        $this->detalleasignaciones = new \App\Models\VAAsignacionesDetalleModel();
        $this->asignacionesAdjuntos = new \App\Models\VAAsignacionesAdjuntosModel();
        $this->reposiciones = new \App\Models\VAReposicionesModel();
        $this->reposicionesDetalle = new \App\Models\VAReposicionesDetalleModel();
        $this->reposicionesAdjuntos = new \App\Models\VAReposicionesAdjuntosModel();
        $this->reposicionesCronogramaPago = new \App\Models\VAReposicionesCronogramaPagoModel();
        $this->devoluciones = new \App\Models\VADevolucionesModel();
        $this->devolucionesDetalle = new \App\Models\VADevolucionesDetalleModel();
        $this->devolucionesAdjuntos = new \App\Models\VADevolucionesAdjuntosModel();


        $this->correoStatusAsignacion = new \App\Models\CorreoStatusAsignacionModel();
        $this->correoStatusDevolucion = new \App\Models\CorreoStatusDevolucionModel();
        $this->correoStatusReposicion = new \App\Models\CorreoStatusReposicionModel();
	}
	
	private function devolverInformacionElemento($tipoElemento, $idElemento)
	{
	    $informacion = array();
	    
	    //Obtener elemento
        if($tipoElemento=='MOVIL')
        {
            $dataElemento = $this->moviles->obtenerMovil($idElemento);
            
            $informacion['TIPO'] = $tipoElemento;
            $informacion['Marca'] = $dataElemento['Marca'];
            $informacion['Modelo'] = $dataElemento['Modelo'];
            $informacion['Serie'] = $dataElemento['IMEI'];
            $informacion['NombreCategoria'] = "MOVIL";
        }
        else if($tipoElemento=='LINEA')
        {
            $dataElemento = $this->lineas->obtenerLinea($idElemento);
            
            $informacion['TIPO'] = $tipoElemento.' - '.$dataElemento['Numero'];
            $informacion['Marca'] = $dataElemento['Operador'];
            $informacion['Modelo'] = $dataElemento['Plan'];
            $informacion['Serie'] = $dataElemento['ICCID'];
            $informacion['NombreCategoria'] = "LINEA";
        }
        else if($tipoElemento=='HARDWARE')
        {
            $dataElemento = $this->hardware->obtenerHardware($idElemento);
            
            if($dataElemento['id_categoria'] == '3')
            {
                $informacion['TIPO'] = $dataElemento['nombre_tipo'];
            }
            else
            {
                $informacion['TIPO'] = $dataElemento['nombre_tipo'].' - '.$dataElemento['Hostname'];
            }
            
            $informacion['NombreCategoria'] = $dataElemento['nombre_categoria'];
            $informacion['Marca'] = $dataElemento['Marca'];
            $informacion['Modelo'] = $dataElemento['Modelo'];
            $informacion['Serie'] = $dataElemento['Serie'];
            $informacion['CPU'] = $dataElemento['Procesador'] != '' && $dataElemento['Procesador'] != null && $dataElemento['Procesador'] != '0' ? $dataElemento['Procesador'] : '';
            $informacion['Memoria'] = $dataElemento['RAM'] != '' && $dataElemento['RAM'] != null && $dataElemento['RAM'] != '0' ? $dataElemento['RAM'].' GB' : '';
            // $informacion['DiscoDuro'] = $totalDiscoDuro != null && $totalDiscoDuro != '0' ? $totalDiscoDuro.' GB' : '';
        }
        else if($tipoElemento=='TARJETA')
        {
            $dataElemento = $this->tarjetasAcceso->where("IDTarjetaAcceso", $idElemento)->first();
            
            $informacion['NombreCategoria'] = "TARJETA";
            $informacion['TIPO'] = $tipoElemento;
            $informacion['Marca'] = "--";
            $informacion['Modelo'] = "--";
            $informacion['Serie'] = $dataElemento['Serie'];
        }
        else if($tipoElemento=='KITDEMO')
        {
            $dataElemento = $this->kitsDemo->obtenerItemKitDemo($idElemento);
            
            $informacion['NombreCategoria'] = $tipoElemento;
            $informacion['TIPO'] = 'KIT DEMO - '.$dataElemento['CodigoKitDemo'];
            $informacion['Marca'] = $dataElemento['Nombre'];
            $informacion['Modelo'] = $dataElemento['SKU'];
            $informacion['Serie'] = $dataElemento['Serie'];
        }
        
        return $informacion;
	}
	

//     public function listarAsignacionesURES(){
//          if($this->items['id'] == '4373')
        // {
// 		if(isset($this->items['id'])){
            
// 			/* ACCIONES */
			
// // 			if($this->items['idPerfil'] == 3)
// // 			{
// // 			    $cccordinador = $this->globales->listadoCentroCostoCoordinador();
			
// // 			    if(array_key_exists($this->items['id'], $cccordinador))
// // 			    {
// // 			        $centroscosto = $cccordinador[$this->items['id']];
// // 			        $listaAsignaciones = $this->asignaciones->listarAsignaciones($centroscosto);
// // 			    }
// // 			    else
// // 			    {
// // 			        $listaAsignaciones = array();
// // 			    }
			    
// // 			}
// // 			else
// // 			{
// // 			    $centroscosto = array();
// // 			    $listaAsignaciones = $this->asignaciones->listarAsignaciones($centroscosto);
// // 			}
// 			$listaAsignaciones = array();
// 			$data = array (
// 				'session'               => 'on',
// 				'titulo'                => 'Asignaciones URES | Verisure',
// 				'breadcrumb'            => $this->items['modulo'],
// 				'breadcrumb_alias'      => 'Actas de asignación',
// 				'listaAsignaciones'     => $listaAsignaciones
// 			);
// 			$data = array_merge($data, $this->items);
// 			return view('cargos/asignaciones/ures/listar_asignaciones',$data);			
// 		} else {
// 			return view('errors/500');
// 		}
//          }
//         else
//         {
//             return view('errors/html/error_mantenimiento');
//         }
// 	}

    /************************* ASIGNACIONES ***********************************/

    public function listarAsignaciones()
    {
        if(isset($this->items['id'])){
            
			/* ACCIONES */
			
			if($this->items['idPerfil'] == 3)
			{
			    $cccordinador = $this->globales->listadoCentroCostoCoordinador();
			
			    if(array_key_exists($this->items['id'], $cccordinador))
			    {
			        $centroscosto = $cccordinador[$this->items['id']];
			        $listaAsignaciones = $this->asignaciones->listarAsignaciones($centroscosto);
			    }
			    else
			    {
			        $listaAsignaciones = array();
			    }
			    
			}
			else
			{
			    $centroscosto = array();
			    $listaAsignaciones = $this->asignaciones->listarAsignaciones($centroscosto);
			}
			/*echo $this->items['idPerfil'];
			var_dump($centroscosto);
			exit;*/
            

            /*foreach($listaAsignaciones as $key=>$value)
            {
                //Obtener Usuario Asignado
			    $asignado = $this->usuarios->where("IdUsuario ", $value['UsuarioAsignado'])->first();
			    $remitente = $this->usuarios->where("IdUsuario ", $value['UsuarioRemitente'])->first();

                $listaAsignaciones[$key]['NombreAsignado'] = strtoupper($asignado['Nombres'].' '.$asignado['Apellidos']);
                $listaAsignaciones[$key]['MatriculaAsignado'] = $asignado['Matricula'];
                $listaAsignaciones[$key]['NombreRemitente'] = strtoupper($asignado['Nombres'].' '.$asignado['Apellidos']);
            }*/

			$data = array (
				'session'               => 'on',
				'titulo'                => 'Asignaciones | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Actas de asignación',
				'listaAsignaciones'     => $listaAsignaciones
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/asignaciones/listar_asignaciones',$data);
            
		} else {
			return view('errors/500');
		}
	}

    public function obtenerElementosAsignacion()
    {
        /*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        
        $post = $this->request->getPost('term');
        //var_dump($this->request->getPost());exit;
        $elementos=array();


        if($post['elemento'] == 'MOVIL')
        {
            $listado = $this->moviles->listarMovilesDisponibles($post['term']);

            foreach ($listado as $items) {
                $elementos[] = array(
                    'id' => (string) $items['IDMovil'],
                    'text' => (string) $items['IMEI']." | ".$items['Marca']." ".$items['Modelo']
                );
            }
            
        }
        else if($post['elemento'] == 'LINEA')
        {
            $listado = $this->lineas->listarLineasDisponibles($post['term']);

            foreach ($listado as $items) {
                $elementos[] = array(
                    'id' => (string) $items['IDLinea'],
                    'text' => (string) $items['Numero']." | ".$items['Operador']." ".$items['Plan']
                );
            }
        }
        else if($post['elemento'] == 'TARJETA')
        {
            $listado = $this->tarjetasAcceso->listarTarjetasAccesoDisponibles($post['term']);

            foreach ($listado as $items) {
                $elementos[] = array(
                    'id' => (string) $items['IDTarjetaAcceso'],
                    'text' => (string) $items['Serie']
                );
            }
        }
        else if($post['elemento'] == 'HARDWARE')
        {
            //var_dump($post);exit;
            $infoUsuario = $this->usuarios->buscarUsuario($post['usuario']);
            
            $listado = $this->hardware->listarHardwareDisponibles($post['term'], $infoUsuario['IDSubarea']);
            foreach ($listado as $items) {
                $elementos[] = array(
                    'id' => (string) $items['IDHardware'],
                    'text' => (string) $items['Modelo'].' | '.$items['Serie'].' '.$items['nombre_subtipo'].' '.$items['nombre_tipo'].' '.$items['nombre_categoria']
                );
            }
        }
        else if($post['elemento'] == 'ACCESORIOIT')
        {
            $listado = $this->accesoriosit->listarAccesorios("A");
            foreach ($listado as $items) {
                $elementos[] = array(
                    'id' => (string) $items['IDAccesorio'],
                    'text' => (string) $items['Accesorio'].' | '.$items['Marca'].' '.$items['Modelo'].' '.$items['nombre_categoria'].' '.$items['nombre_tipo'].' '.$items['nombre_subtipo']
                );
            }
        }
        else if($post['elemento'] == 'KITDEMO')
        {
            $demoAsignado = $this->kitsDemo->obtenerKitDemoAsignadoUsuario($post['usuario']);
            
            if(!empty($demoAsignado))
            {
                foreach ($demoAsignado as $items) {
                    $elementos[] = array(
                        'id' => (string) $items['CodigoKitDemo'],
                        'text' => (string) $items['CodigoKitDemo']
                    );
                }
            }
            else
            {
                $listado = $this->kitsDemo->listarKitDemoDisponibles($post['term']);
                foreach ($listado as $items) {
                    $elementos[] = array(
                        'id' => (string) $items['CodigoKitDemo'],
                        'text' => (string) $items['CodigoKitDemo']
                    );
                }
            }
            
            
        }
        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($elementos);		
    }
	
    public function obtenerElementoAsignar()
    {
        $idItem = $this->request->getPost('itemElemento');
        $elemento = $this->request->getPost('tipoElemento');
        $seleccionados = json_decode($this->request->getPost('seleccionados'));
        
        $dataReposicion = array();
        
        // $totalReposicion = 0;
        // $moneda = "PEN";
        // $simbolo = "S/";

        if($elemento == "LINEA")
        {
            $informacionLinea = $this->lineas->obtenerLinea($idItem);
            
            $dataReposicion[] = array(
                "ELEMENTO"  => $elemento,
                "IDITEM"    => $idItem,
                "ITEM"      => $informacionLinea['Operador']." - ".$informacionLinea['Numero'].' | '.$informacionLinea['ICCID'],
                "TOTAL"     => 1,
                "MONEDA"    => "PEN",
                "SIMBOLO"   => "S/",
                "PRECIOEDITABLE"    => false
            );
        }
        else if($elemento == "MOVIL")
        {
            $informacionMovil = $this->moviles->obtenerMovil($idItem);
            
            if($informacionMovil['EquipoStock'] == "N")
            {
                $contrato = $this->contratos->obtenerContratosXEquipo($idItem);
                $montoTotal = $this->complementos->calculoPenalidadMovil($contrato);
            }
            else
            {
                $montoTotal = $informacionMovil['PrecioLista'];
            }
            
            $dataReposicion[] = array(
                "ELEMENTO"  => $elemento,
                "IDITEM"    => $idItem,
                "ITEM"      => $informacionMovil['Marca']." - ".$informacionMovil['Modelo'].' | '.$informacionMovil['IMEI'],
                "TOTAL"     => $montoTotal,
                "MONEDA"    => "PEN",
                "SIMBOLO"   => "S/",
                "PRECIOEDITABLE"    => false
            );
        }
        else if($elemento == "HARDWARE")
        {
            $informacionHardware = $this->hardware->obtenerHardware($idItem);
            
            $dataReposicion[] = array(
                "ELEMENTO"  => $elemento,
                "IDITEM"    => $idItem,
                "ITEM"      => $informacionHardware['nombre_categoria']." - ".$informacionHardware['Modelo'].' | '.$informacionHardware['Serie'],
                "TOTAL"     => $informacionHardware['PrecioCompra'],
                "MONEDA"    => $informacionHardware['MonedaCompra'],
                "SIMBOLO"   => ($informacionHardware['MonedaCompra'] == 'USD' ? '$' : ($informacionHardware['MonedaCompra'] == 'EUR' ? '€' : 'S/')),
                "PRECIOEDITABLE"    => false
            );
        }
        else if($elemento == "ACCESORIOIT")
        {
            $informacionAccesorio = $this->accesoriosit->obtenerAccesorio($idItem);
            
            $dataReposicion[] = array(
                "ELEMENTO"  => $elemento,
                "IDITEM"    => $idItem,
                "ITEM"      => $informacionAccesorio['Accesorio']." | ".$informacionAccesorio['Marca'].' - '.$informacionAccesorio['Modelo'].' | '.$informacionAccesorio['nombre_categoria'].' - '.$informacionAccesorio['nombre_tipo'].' - '.$informacionAccesorio['nombre_subtipo'],
                "TOTAL"     => "1",
                "MONEDA"    => "PEN",
                "SIMBOLO"   => "S/",
                "PRECIOEDITABLE"    => true
            );
        }
        else if($elemento == "TARJETA")
        {
            $informacionTarjeta = $this->tarjetasAcceso->where("IDTarjetaAcceso", $idItem)->first();
            
            $dataReposicion[] = array(
                "ELEMENTO"  => $elemento,
                "IDITEM"    => $idItem,
                "ITEM"      => $informacionTarjeta['Serie'],
                "TOTAL"     => $informacionTarjeta['PrecioCompra'],
                "MONEDA"    => "PEN",
                "SIMBOLO"   => "S/",
                "PRECIOEDITABLE"    => false
            );
        }
        else if($elemento == "KITDEMO")
        {
            $informacionKit = $this->kitsDemo->listarKitDemoXCodigoKitXNoAsignado($idItem);
            
            if(!empty($informacionKit))
            {
                foreach($informacionKit as $item)
                {
                    $dataReposicion[] = array(
                        "ELEMENTO"  => $elemento,
                        "IDITEM"    => $item['IDItemKitDemo'],
                        "ITEM"      => $item['CodigoKitDemo'].' - '.$item['Nombre'].' | '.$item['SKU'],
                        "TOTAL"     => $item['PrecioReposicion'],
                        "MONEDA"    => $item['MonedaReposicion'] == '' || $item['MonedaReposicion'] == null ? 'PEN' : $item['MonedaReposicion'],
                        "SIMBOLO"   => ($item['MonedaReposicion'] == 'USD' ? '$' : ($item['MonedaReposicion'] == 'EUR' ? '€' : 'S/')),
                        "PRECIOEDITABLE"    => false
                    );
                }
            }
        }
        
	    $html = '';
	    
	    if(empty($dataReposicion))
	    {
            $aleatorio = $this->complementos->generar_string_aleatorio(5);
    	        
	        $html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px" id="itemasignar'.$aleatorio.'" style="border-radius: 10px;">
	            <div class="col-xxl-10 col-md-10 col-10 ">
        	        <div class="alert alert-warning alert-border-left alert-dismissible fade show mb-xl-0" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SIN INFORMACIÓN</strong> - No se encontró información sobre el item seleccionado.
                    </div>
                </div>
        		<div class="col-xxl-2 col-md-2 col-2 d-flex justify-content-end align-items-center">
        			<button type="button" class="btn bg-danger px-2 py-1" onclick="return eliminarBloqueDinamico(\'itemasignar'.$aleatorio.'\');" data-tooltip="tooltip" aria-label="Eliminar Item a Asignar">
                        <i class="mdi mdi-trash-can" style="font-size: 24px; color: #FFF"></i>
                    </button>
        		</div>
        	</div>';
	    }
	    else
	    {
    	    foreach($dataReposicion as $item)
    	    {
    	        if($item['ELEMENTO'] != 'KITDEMO' || ($item['ELEMENTO'] == 'KITDEMO' && !in_array($item['ELEMENTO'].'-'.$item['IDITEM'] , $seleccionados)))
    	        {
                    $aleatorio = $this->complementos->generar_string_aleatorio(5);
        	        
        	        $html.='<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px" id="itemasignar'.$aleatorio.'" style="border-radius: 10px;">
        	            <input type="hidden" name="item['.$aleatorio.']" value="'.$item['IDITEM'].'">
        	            <input type="hidden" name="itemAsignacion[]" value="'.$item['ELEMENTO'].'-'.$item['IDITEM'].'">
                		<div class="col-xxl-6 col-md-12 col-12 mb-2">
                			<div>
                				<label class="form-label">Elemento:</label>
                			    <input type="hidden" name="elemento['.$aleatorio.']" value="'.$item['ELEMENTO'].'">
                				<input type="text" class="form-control" value="'.$item['ELEMENTO'].'" disabled>
                			</div>
                		</div>
                		<div class="col-xxl-6 col-md-12 col-12 mb-2">
                		    <label class="form-label">Reposición</label>
                			<div class="input-group">
                			    <input type="hidden" name="moneda['.$aleatorio.']" value="'.$item['MONEDA'].'">
                                <span class="input-group-text">'.$item['SIMBOLO'].'</span>
                                <input type="number" class="form-control" name="reposicion['.$aleatorio.']" step="0.01" min="1" value="'.$item['TOTAL'].'" '.($item['PRECIOEDITABLE'] === true ? '' : 'style="pointer-events: none; background:#AAA; color:#F5F5F5;"').'>
                            </div>
                		</div>
                		<div class="col-xxl-12 col-md-12 col-12 mb-2">
                			<div>
                				<label class="form-label">ITEM:</label>
                				<input type="text" class="form-control" value="'.$item['ITEM'].'" disabled>
                			</div>
                		</div>
                		
                		<div class="col-xxl-10 col-md-10 col-10 ">
                		    <div class="form-floating">
                                <textarea class="form-control" id="detalle'.$aleatorio.'" name="obselemento['.$aleatorio.']" rows="3"></textarea>
                                <label for="detalle'.$aleatorio.'">Detalle</label>
                            </div>
                		</div>
                		<div class="col-xxl-2 col-md-2 col-2 d-flex justify-content-end align-items-center">
                			<button type="button" class="btn bg-danger px-2 py-1" onclick="return eliminarBloqueDinamico(\'itemasignar'.$aleatorio.'\');" data-tooltip="tooltip" aria-label="Eliminar Item a Asignar">
                                <i class="mdi mdi-trash-can" style="font-size: 24px; color: #FFF"></i>
                            </button>
                		</div>
                	</div>';
    	        }
    	    }
	    }
	    
	    echo $html;
    }

    public function guardarAsignacion()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        // $asignado = $this->request->getPost('txtAsignado');
        $asignado = $this->request->getPost('txtUsuarioAsignacion');
        $fechaasignado = $this->request->getPost('txtFechaAsignado');
        $tipoasignado = $this->request->getPost('txtTipoAsignado');
        // $remitente = $this->request->getPost('txtRemitenteAsignacion');
        $remitente = $this->items['id'];
        $observacion = $this->request->getPost('txtObservacionAsignacion');
        
        $elementoDetalle = $this->request->getPost('elemento');
        $itemDetalle = $this->request->getPost('item');
        $observacionDetalle = $this->request->getPost('obselemento');
        $reposicionDetalle = $this->request->getPost('reposicion');
        $monedaDetalle = $this->request->getPost('moneda');
        
        $remitente = ($remitente == '' || $remitente == null ? $this->items['id'] : $remitente );
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        $error = '';
        $error .= $this->complementos->validaCampo($asignado, 'required|trim', 'Usuario asignado');
        $error .= $this->complementos->validaCampo($fechaasignado, 'required|dateDos', 'Fecha de asignación');
        $error .= $this->complementos->validaCampo($tipoasignado, 'required|alphabet|trim', 'Tipo de asignación');
        $error .= $this->complementos->validaCampo($remitente, 'required|trim', 'Usuario remitente');
        
        if(empty($elementoDetalle) || empty($itemDetalle))
        {
            $error .= "<li>Debe registrar un item en la asignación.</li>";
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
    
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        foreach($elementoDetalle as $key=>$detalle)
        {
            $itemAsignado = $this->detalleasignaciones->validarElementoAsignado($detalle, $itemDetalle[$key]);
            if(count($itemAsignado)>0)
            {
                $msgExistencia .= "<li>El ".$etiquetaitem[$key]." ya fue asignado.</li>";
            }
        }
		
        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
       */
        $datosAsignado = $this->usuarios->buscarUsuario($asignado);
        $tokenAsignacion = $this->complementos->generar_string_aleatorio(15);
        
        $textoLegal = '';
        
        $infolegales = $this->legales->buscarLegalXactaXelementos("ASIGNACIÓN", array_unique($elementoDetalle));
        
        if(!empty($infolegales))
        {
            foreach($infolegales as $key=>$value)
            {
                $textoLegal.=$value['Titulo'];
                $textoLegal.="\n";
                $textoLegal.=$value['Texto'];
                $textoLegal.="\n";
            }
        }
        // echo $textoLegal;exit;
        
        $dataAsignacion = array (
            'UsuarioAsignado'       => $asignado, 
            'CargoAsignado'         => $datosAsignado['Cargo'], 
            'DireccionAsignado'     => $datosAsignado['IDDireccion'], 
            'AreaAsignado'          => $datosAsignado['IDArea'], 
            'SubareaAsignado'       => $datosAsignado['IDSubarea'], 
            'DelegacionAsignado'    => $datosAsignado['IDDelegacion'], 
            'FechaAsignado'         => $fechaasignado, 
            'TipoAsignado'          => $tipoasignado, 
            'Observacion'           => $observacion, 
            'UsuarioRemitente'      => $remitente, 
            'CargoRemitente'        => $this->items['cargo'], 
            'DireccionRemitente'    => $this->items['dpto'], 
            'AreaRemitente'         => $this->items['idArea'], 
            'SubareaRemitente'      => $this->items['idSubarea'], 
            'DelegacionRemitente'   => $this->items['idDelegacionLog'], 
            'Legales'               => $textoLegal,
            'TokenLinkFirma'        => $tokenAsignacion,
            'LiberadoFirma'         => 'Y',
            'UsuarioCrea'           => $this->items['id'],
            'FechaCrea'             => $fechaActual,    
            'Localhost'             => $this->request->getIPAddress()
        );

        $lastIdAsignacion = $this->asignaciones->insert($dataAsignacion, TRUE);
        
        if($lastIdAsignacion !== FALSE){
            $idAsignacion = $lastIdAsignacion;
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar la asignación. Inténtelo luego.</li>");
            echo $this->alertas->alertaError($message);
            EXIT;
        }
            
        $dataDetalle = array();

        foreach($elementoDetalle as $key=>$detalle)
        {
            $dataDetalle[] = array (
                'IDAsignacion'      => $idAsignacion, 
                'TipoElemento'      => $detalle,  
                'IDElemento'        => $itemDetalle[$key], 
                'Observacion'       => $observacionDetalle[$key], 
                'MonedaReposicion'  => $monedaDetalle[$key], 
                'MontoReposicion'   => $reposicionDetalle[$key], 
                'UsuarioCrea'       => $this->items['id'],
                'FechaCrea'         => $fechaActual,    
                'Localhost'         => $this->request->getIPAddress()
            );
        }
        $lastId = $this->detalleasignaciones->insertBatch($dataDetalle);
        
		if($lastId !== FALSE){
            
            /*
            * ----------------------------
            * PREPARACIÓN DE CUERPO DE CORREO
            * ----------------------------
            */

            $arrayCuerpo = array(
                "TITULO" => "ACTA DE ASIGNACIÓN",
                "ACTA" => "ACTA DE ASIGNACIÓN",
                "USUARIO" => ucwords(mb_strtolower($datosAsignado['Nombres'].' '.$datosAsignado['Apellidos'])),
                "URL_ACTA" => base_url()."/acta-asignacion/".$idAsignacion."/".$tokenAsignacion
            );

            $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActas($arrayCuerpo);
            
            /*
            * ----------------------------
            * PREPARACIÓN DE PARAMETROS PARA EL CORREO
            * ----------------------------
            */

            $asunto='ACTA DE ASIGNACIÓN: '.$idAsignacion.' - '.$datosAsignado['Nombres'].' '.$datosAsignado['Apellidos'];
            //$correoDestino = array($asignado['Correo']);
            $configCorreo = array(
                "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
                "CORREO_ORIGEN" => $this->items['correoElectronico'],
                "CORREOS_DESTINOS" => array($datosAsignado['Correo']),
                "CORREOS_COPIA" => array("soporteit@verisure.pe"),
                "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe"),
                // "CORREOS_DESTINOS" => array("josejesus.cuadros@verisure.pe"),
                // "CORREOS_COPIA" => array(),
                // "CORREOS_OCULTO" => array(),
                "ASUNTO" => $asunto,
                "MENSAJE" => $cuerpo
            );

            $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);

            $dataCorreo = array(
                "IDAsignacion"  => $idAsignacion,
                "Response"      => $estadoCorreo['RESPUESTA'],
                "Error"         => $estadoCorreo['ERROR'],
                'UsuarioCrea'   => $this->items['id'],
                'FechaCrea'     => $fechaActual,    
                'Localhost'     => $this->request->getIPAddress()
            );

            $this->correoStatusAsignacion->insert($dataCorreo, TRUE);
            
			$message = sprintf($this->mensajeError->msg502, $idAsignacion);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->reDireccion(base_url()."/documento-asignado/".$idAsignacion, 1);
		} 
    }

    public function documentoAsociado($idAsignado)
    {
        if(isset($this->items['id'])){

			/* ACCIONES */

            $asignacion = $this->asignaciones->where("IDAsignacion",$idAsignado)->first();
            $remitente = $this->usuarios->where("IdUsuario ", $asignacion['UsuarioRemitente'])->first();
            $asignado = $this->usuarios->buscarUsuario($asignacion['UsuarioAsignado']);
            $depaAsignacion = $this->estructuraDirecciones->where("IDDireccion", $asignacion['DireccionAsignado'])->first();
            $areaAsignacion = $this->estructuraAreas->where("IDArea", $asignacion['AreaAsignado'])->first();

            $whereFirma = array(
                "IDAsignacion"  => $idAsignado,
                "Firma"         => "Y"
            );
            $firmaAsignacion = $this->asignacionesAdjuntos->where($whereFirma)->first();

            $asignacion['NombreRemitente'] = strtoupper($remitente['Nombres'].' '.$remitente['Apellidos']);
            $asignacion['NombreAsignado'] = $asignado['Nombres'];
            $asignacion['ApellidosAsignado'] = $asignado['Apellidos'];
            $asignacion['MatriculaAsignado'] = $asignado['Matricula'];
            $asignacion['DocumentoAsignado'] = $asignado['NumeroDoc'];
            $asignacion['GerenciaAsignado'] = $depaAsignacion['Direccion'];
            $asignacion['AreaAsignado'] = $areaAsignacion['Area'];
            $asignacion['FechaAsignacion'] = "Lima, ".date('d', strtotime($asignacion['FechaAsignado']))." de ".$this->complementos->parseoMes(date('m', strtotime($asignacion['FechaAsignado'])))." de ".date('Y', strtotime($asignacion['FechaAsignado']));

			$detalleAsignacion = $this->detalleasignaciones->where("IDAsignacion", $idAsignado)->findAll();
            
            foreach($detalleAsignacion as $key=>$value)
            {
                //Obtener elemento
                if($value['TipoElemento']=='MOVIL')
                {
                    $dataElemento = $this->moviles->obtenerMovil($value['IDElemento']);
                    $detalleAsignacion[$key]['TIPO'] = $value['TipoElemento'];
                    $detalleAsignacion[$key]['Marca'] = $dataElemento['Marca'];
                    $detalleAsignacion[$key]['Modelo'] = $dataElemento['Modelo'];
                    $detalleAsignacion[$key]['Serie'] = $dataElemento['IMEI'];
                    $detalleAsignacion[$key]['NombreCategoria'] = "MOVIL";
                }
                else if($value['TipoElemento']=='LINEA')
                {
                    $dataElemento = $this->lineas->obtenerLinea($value['IDElemento']);
                    $detalleAsignacion[$key]['TIPO'] = $value['TipoElemento'].' - '.$dataElemento['Numero'];
                    $detalleAsignacion[$key]['Marca'] = $dataElemento['Operador'];
                    $detalleAsignacion[$key]['Modelo'] = $dataElemento['Plan'];
                    $detalleAsignacion[$key]['Serie'] = $dataElemento['ICCID'];
                    $detalleAsignacion[$key]['NombreCategoria'] = "LINEA";
                }
                else if($value['TipoElemento']=='HARDWARE')
                {
                    $dataElemento = $this->hardware->obtenerHardware($value['IDElemento']);
                    $totalDiscoDuro = ($dataElemento['SSD'] + $dataElemento['HDD']);
                    
                    if($dataElemento['id_categoria'] == '3')
                    {
                        $detalleAsignacion[$key]['TIPO'] = $dataElemento['nombre_tipo'];
                    }
                    else
                    {
                        if($dataElemento['Hostname'] == '')
                        {
                            $detalleAsignacion[$key]['TIPO'] = $dataElemento['nombre_tipo'];
                        }
                        else
                        {
                            $detalleAsignacion[$key]['TIPO'] = $dataElemento['nombre_tipo'].' - '.$dataElemento['Hostname'];
                        }
                        
                    }
                    
                    $detalleAsignacion[$key]['NombreCategoria'] = "HARDWARE";
                    $detalleAsignacion[$key]['Marca'] = $dataElemento['Marca'];
                    $detalleAsignacion[$key]['Modelo'] = $dataElemento['Modelo'];
                    $detalleAsignacion[$key]['Serie'] = $dataElemento['Serie'];
                    $detalleAsignacion[$key]['CPU'] = $dataElemento['Procesador'] != '' && $dataElemento['Procesador'] != null && $dataElemento['Procesador'] != '0' ? $dataElemento['Procesador'] : '';
                    $detalleAsignacion[$key]['Memoria'] = $dataElemento['RAM'] != '' && $dataElemento['RAM'] != null && $dataElemento['RAM'] != '0' ? $dataElemento['RAM'].' GB' : '';
                    $detalleAsignacion[$key]['DiscoDuro'] = $totalDiscoDuro != null && $totalDiscoDuro != '0' ? $totalDiscoDuro.' GB' : '';
                }
                else if($value['TipoElemento']=='TARJETA')
                {
                    $dataElemento = $this->tarjetasAcceso->where("IDTarjetaAcceso", $value['IDElemento'])->first();
                    $detalleAsignacion[$key]['NombreCategoria'] = "TARJETA";
                    $detalleAsignacion[$key]['TIPO'] = $value['TipoElemento'];
                    $detalleAsignacion[$key]['Marca'] = "--";
                    $detalleAsignacion[$key]['Modelo'] = "--";
                    $detalleAsignacion[$key]['Serie'] = $dataElemento['Serie'];
                }
                else if($value['TipoElemento']=='KITDEMO')
                {
                    $dataElemento = $this->kitsDemo->obtenerItemKitDemo($value['IDElemento']);
                    $detalleAsignacion[$key]['NombreCategoria'] = $value['TipoElemento'];
                    $detalleAsignacion[$key]['TIPO'] = 'KIT DEMO - '.$dataElemento['CodigoKitDemo'];
                    $detalleAsignacion[$key]['Marca'] = $dataElemento['Nombre'];
                    $detalleAsignacion[$key]['Modelo'] = $dataElemento['SKU'];
                    $detalleAsignacion[$key]['Serie'] = $dataElemento['Serie'];
                }
                else
                {
                    $informacionElemento = "SIN INFORMACIÓN";
                }
                
            }

			$data = array (
				'session'               => 'on',
				'titulo'                => 'Asignaciones | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Acta de Asignación',
                'previo'                => 'listar-asignaciones',
				'asignacion'            => $asignacion,
                'detalle'               => $detalleAsignacion,
                'firmaAsignacion'       => $firmaAsignacion
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/asignaciones/documento_asignado',$data);			
		} else {
			return view('errors/500');
		}
    }

    public function enviarCorreoAsignacion()
    {
        $fechaActual = date("Y-m-d H:i:s");

        $idAsignacion = $this->request->getPost('idAsignacion');
        $asignacion = $this->asignaciones->where("IDAsignacion", $idAsignacion)->first();
        $asignado = $this->usuarios->buscarUsuario($asignacion['UsuarioAsignado']);
        
		/*
        * ----------------------------
        * PREPARACIÓN DE CUERPO DE CORREO
        * ----------------------------
		*/

        $arrayCuerpo = array(
            "TITULO" => "ACTA DE ASIGNACIÓN",
            "ACTA" => "ACTA DE ASIGNACIÓN",
            "USUARIO" => ucwords(mb_strtolower($asignado['Nombres'].' '.$asignado['Apellidos'])),
            "URL_ACTA" => base_url()."/acta-asignacion/".$idAsignacion."/".$asignacion['TokenLinkFirma']
        );

        $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActas($arrayCuerpo);
        
		/*
        * ----------------------------
        * PREPARACIÓN DE PARAMETROS PARA EL CORREO
        * ----------------------------
		*/

        $asunto='ACTA DE ASIGNACIÓN: '.$idAsignacion.' - '.$asignado['Nombres'].' '.$asignado['Apellidos'];
        //$correoDestino = array($asignado['Correo']);
        $configCorreo = array(
            "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
            "CORREO_ORIGEN" => $this->items['correoElectronico'],
            "CORREOS_DESTINOS" => array($asignado['Correo']),
            "CORREOS_COPIA" => array("soporteit@verisure.pe"),
            "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe"),
            "ASUNTO" => $asunto,
            "MENSAJE" => $cuerpo
        );

        $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);

        $dataCorreo = array(
            "IDAsignacion"  => $idAsignacion,
            "Response"      => $estadoCorreo['RESPUESTA'],
            "Error"         => $estadoCorreo['ERROR'],
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $this->correoStatusAsignacion->insert($dataCorreo, TRUE);

        if($estadoCorreo['ERROR'] != '')
        {
            $message = sprintf($this->mensajeError->msg201, "No se pudo enviar el correo. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "Se envió el correo correctamente.");
            echo $this->alertas->alertaExito($message);
        }
        
    }
    
    public function actaAsignacion($idAsignacion, $token)
    {
        $asignacion = $this->asignaciones->where("IDAsignacion", $idAsignacion)->first();

        $whereFirma = array(
            "IDAsignacion"  => $idAsignacion,
            "Firma"         => "Y"
        );
        $firmaAsignacion = $this->asignacionesAdjuntos->where($whereFirma)->first();

        if($token == $asignacion['TokenLinkFirma'])
        {
			/* ACCIONES */

            $remitente = $this->usuarios->where("IdUsuario ", $asignacion['UsuarioRemitente'])->first();
            $asignado = $this->usuarios->buscarUsuario($asignacion['UsuarioAsignado']);
            $depaAsignacion = $this->estructuraDirecciones->where("IDDireccion", $asignacion['DireccionAsignado'])->first();
            $areaAsignacion = $this->estructuraAreas->where("IDArea", $asignacion['AreaAsignado'])->first();

            $asignacion['NombreRemitente'] = strtoupper($remitente['Nombres'].' '.$remitente['Apellidos']);
            $asignacion['NombreAsignado'] = $asignado['Nombres'];
            $asignacion['ApellidosAsignado'] = $asignado['Apellidos'];
            $asignacion['MatriculaAsignado'] = $asignado['Matricula'];
            $asignacion['DocumentoAsignado'] = $asignado['NumeroDoc'];
            $asignacion['GerenciaAsignado'] = $depaAsignacion['Direccion'];
            $asignacion['AreaAsignado'] = $areaAsignacion['Area'];
            $asignacion['FechaAsignacion'] = "Lima, ".date('d', strtotime($asignacion['FechaAsignado']))." de ".$this->complementos->parseoMes(date('m', strtotime($asignacion['FechaAsignado'])))." de ".date('Y', strtotime($asignacion['FechaAsignado']));

			$detalleAsignacion = $this->detalleasignaciones->where("IDAsignacion", $idAsignacion)->findAll();
            
            foreach($detalleAsignacion as $key=>$value)
            {
                //Obtener elemento
                if($value['TipoElemento']=='MOVIL')
                {
                    $dataElemento = $this->moviles->obtenerMovil($value['IDElemento']);
                    $detalleAsignacion[$key]['NombreCategoria'] = "MOVIL";
                    $detalleAsignacion[$key]['TIPO'] = $value['TipoElemento'];
                    $detalleAsignacion[$key]['Marca'] = $dataElemento['Marca'];
                    $detalleAsignacion[$key]['Modelo'] = $dataElemento['Modelo'];
                    $detalleAsignacion[$key]['Serie'] = $dataElemento['IMEI'];
                }
                else if($value['TipoElemento']=='LINEA')
                {
                    $dataElemento = $this->lineas->obtenerLinea($value['IDElemento']);
                    $detalleAsignacion[$key]['NombreCategoria'] = "LINEA";
                    $detalleAsignacion[$key]['TIPO'] = $value['TipoElemento'].' - '.$dataElemento['Numero'];
                    $detalleAsignacion[$key]['Marca'] = $dataElemento['Operador'];
                    $detalleAsignacion[$key]['Modelo'] = $dataElemento['Plan'];
                    $detalleAsignacion[$key]['Serie'] = $dataElemento['ICCID'];
                }
                else if($value['TipoElemento']=='HARDWARE')
                {
                    $dataElemento = $this->hardware->obtenerHardware($value['IDElemento']);
                    $totalDiscoDuro = ($dataElemento['SSD'] + $dataElemento['HDD']);
                    
                    if($dataElemento['id_categoria'] == '3')
                    {
                        $detalleAsignacion[$key]['TIPO'] = $dataElemento['nombre_tipo'];
                    }
                    else
                    {
                        if($dataElemento['Hostname'] == '')
                        {
                            $detalleAsignacion[$key]['TIPO'] = $dataElemento['nombre_tipo'];
                        }
                        else
                        {
                            $detalleAsignacion[$key]['TIPO'] = $dataElemento['nombre_tipo'].' - '.$dataElemento['Hostname'];
                        }
                    }
                    
                    $detalleAsignacion[$key]['NombreCategoria'] = $dataElemento['nombre_categoria'];
                    $detalleAsignacion[$key]['Marca'] = $dataElemento['Marca'];
                    $detalleAsignacion[$key]['Modelo'] = $dataElemento['Modelo'];
                    $detalleAsignacion[$key]['Serie'] = $dataElemento['Serie'];
                    $detalleAsignacion[$key]['CPU'] = $dataElemento['Procesador'] != '' && $dataElemento['Procesador'] != null && $dataElemento['Procesador'] != '0' ? $dataElemento['Procesador'] : '';
                    $detalleAsignacion[$key]['Memoria'] = $dataElemento['RAM'] != '' && $dataElemento['RAM'] != null && $dataElemento['RAM'] != '0' ? $dataElemento['RAM'].' GB' : '';
                    $detalleAsignacion[$key]['DiscoDuro'] = $totalDiscoDuro != null && $totalDiscoDuro != '0' ? $totalDiscoDuro.' GB' : '';
                }
                else if($value['TipoElemento']=='TARJETA')
                {
                    $dataElemento = $this->tarjetasAcceso->where("IDTarjetaAcceso", $value['IDElemento'])->first();
                    $detalleAsignacion[$key]['NombreCategoria'] = $dataElemento['TARJETA'];
                    $detalleAsignacion[$key]['TIPO'] = $value['TipoElemento'];
                    $detalleAsignacion[$key]['Marca'] = "--";
                    $detalleAsignacion[$key]['Modelo'] = "--";
                    $detalleAsignacion[$key]['Serie'] = $dataElemento['Serie'];
                }
                else if($value['TipoElemento']=='KITDEMO')
                {
                    $dataElemento = $this->kitsDemo->obtenerItemKitDemo($value['IDElemento']);
                    $detalleAsignacion[$key]['NombreCategoria'] = $value['TipoElemento'];
                    $detalleAsignacion[$key]['TIPO'] = 'KIT DEMO - '.$dataElemento['CodigoKitDemo'];
                    $detalleAsignacion[$key]['Marca'] = $dataElemento['Nombre'];
                    $detalleAsignacion[$key]['Modelo'] = $dataElemento['SKU'];
                    $detalleAsignacion[$key]['Serie'] = $dataElemento['Serie'];
                }
                else
                {
                    $informacionElemento = "SIN INFORMACIÓN";
                }
                
            }

			$data = array (
				'titulo'                => 'Asignaciones | Verisure',
				'asignacion'            => $asignacion,
                'detalle'               => $detalleAsignacion,
                'firmaAsignacion'       => $firmaAsignacion
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/asignaciones/acta_asignacion',$data);	
        }
        else
        {
            return view('errors/500');
        }
    }

    public function detalleActaAsignacion($idAsignacion)
    {
        if(isset($this->items['id'])){

			// ACCIONES
            $asignacion = $this->asignaciones->where("IDAsignacion",$idAsignacion)->first();
            $listaDetalle = $this->detalleasignaciones->listarDetalleAsignacion($idAsignacion);
            $listaAdjunto = $this->asignacionesAdjuntos->where("IDAsignacion", $idAsignacion)->findAll();    

            foreach($listaDetalle as $key=>$value)
            {
                //Obtener elemento
                if($value['TipoElemento']=='MOVIL')
                {
                    $dataElemento = $this->moviles->obtenerMovil($value['IDElemento']);
                    $listaDetalle[$key]['TIPO'] = $value['TipoElemento'];
                    $listaDetalle[$key]['Marca'] = $dataElemento['Marca'];
                    $listaDetalle[$key]['Modelo'] = $dataElemento['Modelo'];
                    $listaDetalle[$key]['Serie'] = $dataElemento['IMEI'];
                    $listaDetalle[$key]['NombreCategoria'] = "MOVIL";
                }
                else if($value['TipoElemento']=='LINEA')
                {
                    $dataElemento = $this->lineas->obtenerLinea($value['IDElemento']);
                    $listaDetalle[$key]['TIPO'] = $value['TipoElemento'].' - '.$dataElemento['Numero'];
                    $listaDetalle[$key]['Marca'] = $dataElemento['Operador'];
                    $listaDetalle[$key]['Modelo'] = $dataElemento['Plan'];
                    $listaDetalle[$key]['Serie'] = $dataElemento['ICCID'];
                    $listaDetalle[$key]['NombreCategoria'] = "LINEA";
                }
                else if($value['TipoElemento']=='HARDWARE')
                {
                    $dataElemento = $this->hardware->obtenerHardware($value['IDElemento']);
                    $totalDiscoDuro = ($dataElemento['SSD'] + $dataElemento['HDD']);
                    
                    if($dataElemento['id_categoria'] == '3')
                    {
                        $listaDetalle[$key]['TIPO'] = $dataElemento['nombre_tipo'];
                    }
                    else
                    {
                        if($dataElemento['Hostname'] == '')
                        {
                            $listaDetalle[$key]['TIPO'] = $dataElemento['nombre_tipo'];
                        }
                        else
                        {
                            $listaDetalle[$key]['TIPO'] = $dataElemento['nombre_tipo'].' - '.$dataElemento['Hostname'];
                        }
                        
                    }
                    
                    $listaDetalle[$key]['NombreCategoria'] = $dataElemento['nombre_categoria'];
                    $listaDetalle[$key]['Marca'] = $dataElemento['Marca'];
                    $listaDetalle[$key]['Modelo'] = $dataElemento['Modelo'];
                    $listaDetalle[$key]['Serie'] = $dataElemento['Serie'];
                    $listaDetalle[$key]['CPU'] = $dataElemento['Procesador'] != '' && $dataElemento['Procesador'] != null && $dataElemento['Procesador'] != '0' ? $dataElemento['Procesador'] : '';
                    $listaDetalle[$key]['Memoria'] = $dataElemento['RAM'] != '' && $dataElemento['RAM'] != null && $dataElemento['RAM'] != '0' ? $dataElemento['RAM'].' GB' : '';
                    $listaDetalle[$key]['DiscoDuro'] = $totalDiscoDuro != null && $totalDiscoDuro != '0' ? $totalDiscoDuro.' GB' : '';
                }
                else if($value['TipoElemento']=='TARJETA')
                {
                    $dataElemento = $this->tarjetasAcceso->where("IDTarjetaAcceso", $value['IDElemento'])->first();
                    $listaDetalle[$key]['TIPO'] = $value['TipoElemento'];
                    $listaDetalle[$key]['Marca'] = "--";
                    $listaDetalle[$key]['Modelo'] = "--";
                    $listaDetalle[$key]['Serie'] = $dataElemento['Serie'];
                    $listaDetalle[$key]['NombreCategoria'] = "TARJETA";
                }
                else if($value['TipoElemento']=='KITDEMO')
                {
                    $dataElemento = $this->kitsDemo->obtenerItemKitDemo($value['IDElemento']);
                    $listaDetalle[$key]['NombreCategoria'] = $value['TipoElemento'];
                    $listaDetalle[$key]['TIPO'] = 'KIT DEMO - '.$dataElemento['CodigoKitDemo'];
                    $listaDetalle[$key]['Marca'] = $dataElemento['Nombre'];
                    $listaDetalle[$key]['Modelo'] = $dataElemento['SKU'];
                    $listaDetalle[$key]['Serie'] = $dataElemento['Serie'];
                }
                else
                {
                    $informacionElemento = "SIN INFORMACIÓN";
                }
                
            }

			$data = array (
				'session'               => 'on',
				'titulo'                => 'Detalle de Asignación | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Detalle de asignación | '.$asignacion['IDAsignacion'],
                'previo'                => 'listar-asignaciones',
				'listaDetalle'          => $listaDetalle,
                'listaAdjunto'          => $listaAdjunto,
                'idAsignacion'          => $idAsignacion
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/asignaciones/listar_detalle_asignacion',$data);			
		} else {
			return view('errors/500');
		}
    }

    public function subirFirmaActaAsignacion()
    {
        $fechaActual = date("Y-m-d H:i:s");

        $idAsignacion = $this->request->getPost("txtIDAsignacion");
        $canvasFirma = $this->request->getPost("firmaActaAsignacion");
        
        $adjunto = $this->request->getFile("fileFotoDNI");
        
        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $adjunto->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $adjunto->getErrorString().'-'.$adjunto->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'fileFotoDNI' => [
                'mime_in[fileFotoDNI,image/png,image/jpg,image/jpeg,image/gif,application/pdf]',
                'ext_in[fileFotoDNI,png,jpg,jpeg,gif,pdf]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        if($adjunto->guessExtension() != null)
        {
            $extensionDoc = $adjunto->guessExtension();
        }
        else
        {
            $nombre_original = $adjunto->getBasename();
            $fileNameCmps = explode(".", $nombre_original);
            $extensionDoc = strtolower(end($fileNameCmps));
        }

        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */

        $asignacion = $this->asignaciones->where("IDAsignacion", $idAsignacion)->first();

        $data = array (
            'IDAsignacion'      => $idAsignacion, 
            'Nombre'            => "DOCUMENTO DE IDENTIDAD", 
            'Extension'         => $extensionDoc,
            'Observacion'       => "DOCUMENTO DE IDENTIDAD ADJUNTADO EN LA FIRMA.",
            'ReemplazoFirma'    => 'N',  
            'UsuarioCrea'       => $asignacion['UsuarioAsignado'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->asignacionesAdjuntos->insert($data, TRUE);

		if($lastId === FALSE){
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
			exit;
		}

        /*
        * ----------------------------
        * GUARDAR ARCHIVO ADJUNTO
        * ----------------------------
        */
        $ruta = "public/docs/ActaAsignacion/";
        $nombreArchivo = $idAsignacion."-".$lastId;

        if(!file_exists($ruta))
        {
            @mkdir($ruta, 0777, true);
        }

		# si exsite la carpeta o se ha creado
		if (file_exists($ruta) || @mkdir($ruta)) 
        {
            $nuevonombre = $nombreArchivo.'.'.$extensionDoc;
            
            $estadoMove = $adjunto->move($ruta, $nuevonombre);
            
            if (!$estadoMove) {
                $this->asignacionesAdjuntos->delete(["IDAdjuntoAsignacion", $lastId]);
                $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[SAVEDOC]");
                echo $this->alertas->alertaError($message);
                exit;
            }
        }
        else
        {
            $this->asignacionesAdjuntos->delete(["IDAdjuntoAsignacion", $lastId]);
            $message = sprintf($this->mensajeError->msg201, "No existe ruta. Inténtelo luego.[SAVEDOC]");
            echo $this->alertas->alertaError($message);
        }
        
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */

        $dataFirma = array (
            'IDAsignacion'      => $idAsignacion, 
            'Nombre'            => "FIRMA", 
            'Extension'         => "png",
            'Observacion'       => "FIRMA DEL ASIGNADO.",
            'ReemplazoFirma'    => 'N',  
            'Firma'             => 'Y',  
            'UsuarioCrea'       => $asignacion['UsuarioAsignado'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastIdFirma = $this->asignacionesAdjuntos->insert($dataFirma, TRUE);

		if($lastIdFirma === FALSE){
            unlink($ruta.$nombreArchivo.'.'.$extensionDoc);
            $this->asignacionesAdjuntos->delete(["IDAdjuntoAsignacion", $lastId]);
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la firma. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
			exit;
		}

        /*
        * ----------------------------
        * GUARDAR FIRMA
        * ----------------------------
        */

        $ruta = "public/docs/ActaAsignacion/";
        $nombreArchivoFirma = $idAsignacion."-".$lastIdFirma;

        if(!file_exists($ruta))
        {
            @mkdir($ruta, 0777, true);
        }

		# si exsite la carpeta o se ha creado
		if (file_exists($ruta) || @mkdir($ruta)) 
        {
            $nuevonombreFirma = $nombreArchivoFirma.'.png';
            
            $datos = base64_decode(
                preg_replace('/^[^,]*,/', '', $canvasFirma)
            );

            $estadoFirma = file_put_contents($ruta.$nuevonombreFirma, $datos);
            
            if ($estadoFirma===FALSE) {
                unlink($ruta.$nombreArchivo.'.'.$extensionDoc);
                $this->asignacionesAdjuntos->delete(["IDAdjuntoAsignacion", $lastId]);
                $this->asignacionesAdjuntos->delete(["IDAdjuntoAsignacion", $lastIdFirma]);
                $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la firma. Inténtelo luego.[SAVEDOC]");
                echo $this->alertas->alertaError($message);
                exit;
            }
        }
        else
        {
            unlink($ruta.$nombreArchivo.'.'.$extensionDoc);
            $this->asignacionesAdjuntos->delete(["IDAdjuntoAsignacion", $lastId]);
            $this->asignacionesAdjuntos->delete(["IDAdjuntoAsignacion", $lastIdFirma]);
            $message = sprintf($this->mensajeError->msg201, "No existe ruta. Inténtelo luego.[SAVEDOC]");
            echo $this->alertas->alertaError($message);
        }

        /*
        * ----------------------------
        * PREPARACIÓN DE CUERPO DE CORREO
        * ----------------------------
        */
        
        $usuarioRemitente = $this->usuarios->where("IdUsuario", $asignacion['UsuarioRemitente'])->first();
        
        $usuarioAsignado = $this->usuarios->where("IdUsuario", $asignacion['UsuarioAsignado'])->first();
        
        $arrayCuerpo = array(
            "TITULO" => "FIRMA DE ACTA DE ASIGNACIÓN",
            "ACTA" => "ACTA DE ASIGNACIÓN",
            "USUARIO" => ucwords(mb_strtolower($usuarioRemitente['Nombres'].' '.$usuarioRemitente['Apellidos'])),
            "CODIGO" => $idAsignacion
        );

        $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActasConfirmacion($arrayCuerpo);
        
        /*
        * ----------------------------
        * PREPARACIÓN DE PARAMETROS PARA EL CORREO
        * ----------------------------
        */

        $asunto='FIRMA DE ACTA DE ASIGNACIÓN: '.$idAsignacion.' - '.$usuarioAsignado['Nombres'].' '.$usuarioAsignado['Apellidos'];
        //$correoDestino = array($asignado['Correo']);
        $configCorreo = array(
            "NOMBRE_ORIGEN" => $usuarioAsignado['Nombres'].' '.$usuarioAsignado['Apellidos'],
            "CORREO_ORIGEN" => $usuarioAsignado['Correo'],
            "CORREOS_DESTINOS" => array($usuarioRemitente['Correo']),
            "CORREOS_COPIA" => array("soporteit@verisure.pe"),
            "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe"),
            "ASUNTO" => $asunto,
            "MENSAJE" => $cuerpo
        );

        $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);

        $dataCorreo = array(
            "IDAsignacion"  => $idAsignacion,
            "Response"      => $estadoCorreo['RESPUESTA'],
            "Error"         => $estadoCorreo['ERROR'],
            'UsuarioCrea'   => $reposicion['UsuarioAdjudicado'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $this->correoStatusAsignacion->insert($dataCorreo, TRUE);

        $message = sprintf($this->mensajeError->msg201, "La firma fue registrada exitosamente.");
        echo $this->alertas->alertaExito($message);
        echo $this->alertas->refrescar(1);
    }

    public function adjuntarDocumentoAsignacion($idAsignacion)
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $nombre = $this->request->getPost('txtNombreAdjunto_i');
        $observacion = $this->request->getPost('txtObservacionAdjunto_i');
        $reemplazafirma = $this->request->getPost('chkAdjuntoFirma');
        $adjunto = $this->request->getFile("fileAdjuntoAsignacion");

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($nombre, 'required|trim|minlength[9]|maxlength[15]', 'Nombre');
        $error .= $this->complementos->validaCampo($observacion, 'trim', 'Observación');
        

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $adjunto->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $adjunto->getErrorString().'-'.$adjunto->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'fileAdjuntoAsignacion' => [
                'mime_in[fileAdjuntoAsignacion,image/png,image/jpg,image/jpeg,image/gif,application/pdf]',
                'ext_in[fileAdjuntoAsignacion,pdf]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        if($adjunto->guessExtension() != null)
        {
            $extensionDoc = $adjunto->guessExtension();
        }
        else
        {
            $nombre_original = $adjunto->getBasename();
            $fileNameCmps = explode(".", $nombre_original);
            $extensionDoc = strtolower(end($fileNameCmps));
        }
        
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */

        $data = array (
            'IDAsignacion'      => $idAsignacion, 
            'Nombre'            => $nombre, 
            'Extension'         => $extensionDoc,
            'Observacion'       => $observacion,
            'ReemplazoFirma'    => ((isset($reemplazafirma) && $reemplazafirma != null) ? 'Y' : 'N'),  
            'UsuarioCrea'       => $this->items['id'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->asignacionesAdjuntos->insert($data, TRUE);

		if($lastId === FALSE){
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
			exit;
		}

        /*
        * ----------------------------
        * GUARDAR ARCHIVO ADJUNTO
        * ----------------------------
        */
        $ruta = "public/docs/ActaAsignacion/";
        $nombreArchivo = $idAsignacion."-".$lastId;

        if(!file_exists($ruta))
        {
            @mkdir($ruta, 0777, true);
        }

		# si exsite la carpeta o se ha creado
		if (file_exists($ruta) || @mkdir($ruta)) 
        {
            $nuevonombre = $nombreArchivo.'.'.$extensionDoc;
            
            $estadoMove = $adjunto->move($ruta, $nuevonombre);
            
            if (!$estadoMove) {
                $this->asignacionesAdjuntos->delete(["IDAdjuntoAsignacion", $lastId]);
                $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[SAVEDOC]");
                echo $this->alertas->alertaError($message);
                exit;
            }
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "No existe ruta. Inténtelo luego.[SAVEDOC]");
            echo $this->alertas->alertaError($message);
        }
        
        $message = sprintf($this->mensajeError->msg201, "El archivo adjunto fue registrado exitosamente.");
        echo $this->alertas->alertaExito($message);
        echo $this->alertas->refrescar(1);
    }
    
    public function subirCSVAsignacion()
    {
        $fechaActual = date("Y-m-d H:i:s");
        $fechaActualAdd = date("Y-m-d H:i:s", strtotime($fechaActual)+1);
        
        /*
        * ----------------------------
        * DECLARAR Y ASIGNAR VARIABLE A ARCHIVO OBTENIDO
        * ----------------------------
        */
        
        $csv = $this->request->getFile("fileCSVAsignacion");

        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $csv->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $csv->getErrorString().'-'.$csv->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'fileCSVLinea' => [
                'mime_in[fileCSVAsignacion,text/csv,text/plain]',
                'ext_in[fileCSVAsignacion,csv]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        /*
        * ----------------------------
        * VALIDAR SEPARADOR CSV
        * ----------------------------
        */
        
        $separadorCSV = $this->complementos->validarSeparadorCSV($csv, 7);
        
        if (!$separadorCSV) {
            $message = sprintf($this->mensajeError->msg201, "No se encontró separador de CSV autorizado. Debe usar coma (,) o punto y coma (;) y eliminar celdas vacías a la derecha de la última columna.");
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y VALIDAR DATOS CORRECTOS
        * ----------------------------
        */
        
        //Declaramos variables
        $fila = 0;
        $filasError = array();
        $arrayElementos = array();
        $ejecutarInsert = true;
        //Abrimos el archivo
        $handle = fopen($csv, "r");

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handle, 0, $separadorCSV)) !== FALSE)
        {
            $fila++;

            if($fila>1)
            {
                $data = array_map("utf8_encode", $data);
                //Asignamos valores de CSV a variables locales
                $tipo           = $data[0];
                $referencia     = $data[1];
                $usuario        = $data[2];
                
                if($tipo == 'LINEA')
                {
                    $disponible = $this->lineas->listarLineasDisponibles($referencia);
                    
                    if(empty($disponible))
                    {
                        $filasError[$fila]['REFERENCIA'] = "ELEMENTO SE ENCUENTRA ASIGNADO";
                        $ejecutarInsert = false;
                    }
                    //Validamos existencia de Linea:
                    $datosLinea = $this->lineas->where("Numero",trim($referencia))->first();
                    if(empty($datosLinea))
                    {
                        $filasError[$fila]['REFERENCIA'] = "ELEMENTO NO EXISTE";
                        $ejecutarInsert = false;
                    }
                }
                else if($tipo == 'MOVIL')
                {
                    $disponible = $this->moviles->listarMovilesDisponibles($referencia);
                    
                    if(empty($disponible))
                    {
                        $filasError[$fila]['REFERENCIA'] = "ELEMENTO SE ENCUENTRA ASIGNADO";
                        $ejecutarInsert = false;
                    }
                    //Validamos existencia de IMEI:
                    $datosImei = $this->moviles->where('IMEI', trim($referencia))->first();
                    if(empty($datosImei))
                    {
                        $filasError[$fila]['REFERENCIA'] = "IMEI NO EXISTE";
                        $ejecutarInsert = false;
                    }
                }
                else if($tipo == 'HARDWARE')
                {
                    $disponible = $this->hardware->listarHardwareDisponibles($referencia,'');
                    
                    if(empty($disponible))
                    {
                        $filasError[$fila]['REFERENCIA'] = "ELEMENTO SE ENCUENTRA ASIGNADO";
                        $ejecutarInsert = false;
                    }
                    //Validamos existencia de IMEI:
                    // $datosImei = $this->moviles->where('IMEI', trim($referencia))->first();
                    // if(empty($datosImei))
                    // {
                    //     $filasError[$fila]['REFERENCIA'] = "IMEI NO EXISTE";
                    //     $ejecutarInsert = false;
                    // }
                }
                else if($tipo == 'TARJETA')
                {
                    $disponible = $this->tarjetasAcceso->listarTarjetasAccesoDisponibles($referencia);
                    
                    if(empty($disponible))
                    {
                        $filasError[$fila]['REFERENCIA'] = "ELEMENTO SE ENCUENTRA ASIGNADO";
                        $ejecutarInsert = false;
                    }
                }
                else
                {
                    $filasError[$fila]['TIPO'] = "TIPO NO DECLARADO";
                    $ejecutarInsert = false;
                }
                
                //Validamos usuario correcto:
                if($usuario != '' && $usuario != null)
                {
                    $datosUsuario = $this->usuarios->where("Matricula", $usuario)->first();

                    if(empty($datosUsuario) || $datosUsuario['Usuario'] == null)
                    {
                        $filasError[$fila]['USUARIO'] = "USUARIO NO VÁLIDO-".$usuario;
                        $ejecutarInsert = false;
                    }
                }
                
                //Validamos repetición de elementos
                $filaRepetida = array_search($referencia, $arrayElementos);
                if($filaRepetida !== FALSE)
                {
                    $filasError[$fila]['REFERENCIA'] = "VALOR REPETIDO-FILA ".$filaRepetida;
                    $ejecutarInsert = false;
                }
                
                $arrayElementos[$fila] = $referencia;
                
            }
        }

        fclose($handle);

        if(!$ejecutarInsert)
        {
            $raiz = 'public/';
            $nombre = 'error.txt';
            $file = 'public/error.txt';
            
            if (file_exists($file)) {
                unlink($file);
            }
            
            $txt= fopen($file, 'a') or die ('Problemas al crear el archivo');
            #  Se establecen los datos que va a conterner el archivo
            foreach($filasError as $key=>$value)
            {
                fwrite($txt, "FILA: ".$key."\n");
                foreach($value as $celda=>$error)
                {
                    fwrite($txt, $celda.": ".$error."\n");
                }
            }
            #  Se hace el ciere para no sobre escribir datos 
            fclose($txt);

            $message = sprintf($this->mensajeError->msg201, "Se detectaron diversas inconsistencias.");
            $salida1 = $this->alertas->alertaError($message);
            $salida2 = $this->alertas->descargaArchivoTXT($nombre);
			echo $salida1.$salida2;
			//echo $salida1;
            
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y EJECUTAR INSERTS
        * ----------------------------
        */
            
        //Declaramos variables
        $arrayAsignacionInsert = array();
        $arrayAsignacionDetalleInsert = array();
        $filainsert = 0;
        //Abrimos el archivo
        $handleInsert = fopen($csv, "r");
        $arrayAsig = array();
        $arrayDetalleAsig = array();
        
        //Recorremos las filas del CSV
        while (($data = fgetcsv($handleInsert, 0, $separadorCSV)) !== FALSE)
        {
            $data = array_map("utf8_encode", $data);
            $filainsert++;
            if($filainsert > 1)
            {
                $a = trim($data[3]);
                //Asignamos valores de CSV a variables locales
                $tipo = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $referencia = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");
                $usuario = trim($data[2]," \t\n\r\0\x0B\xc2\xa0");
                $tipoAsignado = trim($data[3]," \t\n\r\0\x0B\xc2\xa0");
                $obsAsignado = trim($data[4]," \t\n\r\0\x0B\xc2\xa0");
                $fechaAsignado = trim($data[5]," \t\n\r\0\x0B\xc2\xa0");
                $obsElemento = trim($data[6]," \t\n\r\0\x0B\xc2\xa0");
                
                if(!array_key_exists($usuario, $arrayAsig)) 
                {
                    $arrayAsig[$usuario] = array(
                        "TIPO"          => $tipoAsignado,
                        "OBSERVACION"   => $obsAsignado,
                        "FECHA"         => $fechaAsignado);
                }
                
                $arrayDetalleAsig[$usuario][] = array(
                    "TIPOELEMENTO"  => $tipo,
                    "ELEMENTO"      => $referencia,
                    "OBSERVACION"   => $obsElemento);
            }
        }

        fclose($handleInsert);
        
        $arrayInsertAsign=array();
        
        foreach($arrayAsig as $usuario => $valor)
        {
            
            $datosAsignado = $this->usuarios->buscarUsuarioXmatricula($usuario);
            $tokenAsignacion = $this->complementos->generar_string_aleatorio(15);
    
            $dataAsignacion = array (
                'UsuarioAsignado'       => $datosAsignado['IdUsuario'], 
                'CargoAsignado'         => $datosAsignado['Cargo'], 
                'AreaAsignado'          => $datosAsignado['IDArea'], 
                'DepartamentoAsignado'  => $datosAsignado['IDDireccion'], 
                'DelegacionAsignado'    => $datosAsignado['IDDelegacion'], 
                'FechaAsignado'         => $valor['FECHA'], 
                'TipoAsignado'          => $valor['TIPO'], 
                'Observacion'           => $valor['OBSERVACION'], 
                'UsuarioRemitente'      => $this->items['id'], 
                'CargoRemitente'        => $this->items['cargo'], 
                'AreaRemitente'         => $this->items['idArea'], 
                'DepartamentoRemitente' => $this->items['dpto'], 
                'TokenLinkFirma'        => $tokenAsignacion,
                'LiberadoFirma'         => 'Y',
                'UsuarioCrea'           => $this->items['id'],
                'FechaCrea'             => $fechaActual,    
                'Localhost'             => $this->request->getIPAddress()
            );
    
            $lastIdAsignacion = $this->asignaciones->insert($dataAsignacion, TRUE);
            
            if($lastIdAsignacion !== FALSE){
                $arrayInsertAsign[] = $lastIdAsignacion;
                
                $dataDetalle = array();
                
                foreach($arrayDetalleAsig[$usuario] as $detalle)
                {
                    $totalReposicion = 0;
        
                    if($detalle['TIPOELEMENTO'] == "LINEA")
                    {
                        $infolinea = $this->lineas->where("Numero", trim($detalle['ELEMENTO']))->first();
                        $elemento = $infolinea['IDLinea'];
                        $totalReposicion = 1;
                    }
                    else if($detalle['TIPOELEMENTO'] == "MOVIL")
                    {
                        $infomovil = $this->moviles->where('IMEI', trim($detalle['ELEMENTO']))->first();
                        $elemento = $infomovil['IDMovil'];
                        $contrato = $this->contratos->obtenerContratosXEquipo($infomovil['IDMovil']);
                        $montoTotal = $this->complementos->calculoPenalidadMovil($contrato);
            
                        $totalReposicion = $montoTotal;
                    }
                    else if($detalle['TIPOELEMENTO'] == "HARDWARE")
                    {
                        $infohardware = $this->hardware->where("Hostname", trim($detalle['ELEMENTO']))->first();
                        $totalReposicion = $infohardware['PrecioCompra'];
                    }
                    else if($detalle['TIPOELEMENTO'] == "TARJETA")
                    {
                        $infotarjeta = $this->tarjetasAcceso->where("Serie", trim($detalle['ELEMENTO']))->first();
                        $totalReposicion = $infotarjeta['PrecioCompra'];
                    }
                    
                    $dataDetalle[] = array (
                        'IDAsignacion'      => $lastIdAsignacion, 
                        'TipoElemento'      => $detalle['TIPOELEMENTO'],  
                        'IDElemento'        => $elemento, 
                        'Observacion'       => $detalle['OBSERVACION'], 
                        'MontoReposicion'   => $totalReposicion, 
                        'UsuarioCrea'       => $this->items['id'],
                        'FechaCrea'         => $fechaActual,    
                        'Localhost'         => $this->request->getIPAddress()
                    );
                }
                $lastId = $this->detalleasignaciones->insertBatch($dataDetalle);
                
        		if($lastId !== FALSE){
                    
                    /*
                    * ----------------------------
                    * PREPARACIÓN DE CUERPO DE CORREO
                    * ----------------------------
                    */
        
                    $arrayCuerpo = array(
                        "TITULO" => "ACTA DE ASIGNACIÓN",
                        "ACTA" => "ACTA DE ASIGNACIÓN",
                        "USUARIO" => ucwords(mb_strtolower($datosAsignado['Nombres'].' '.$datosAsignado['Apellidos'])),
                        "URL_ACTA" => base_url()."/acta-asignacion/".$lastIdAsignacion."/".$tokenAsignacion
                    );
        
                    $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActas($arrayCuerpo);
                    
                    /*
                    * ----------------------------
                    * PREPARACIÓN DE PARAMETROS PARA EL CORREO
                    * ----------------------------
                    */
                    
                    $asunto='ACTA DE ASIGNACIÓN: '.$lastIdAsignacion.' - '.$datosAsignado['Nombres'].' '.$datosAsignado['Apellidos'];
                    //$correoDestino = array($asignado['Correo']);
                    $configCorreo = array(
                        "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
                        "CORREO_ORIGEN" => $this->items['correoElectronico'],
                        // "CORREOS_DESTINOS" => array("soporteit@verisure.pe"),
                        // "CORREOS_COPIA" => array(),
                        // "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe"),
                        "CORREOS_DESTINOS" => array($datosAsignado['Correo']),
                        "CORREOS_COPIA" => array("soporteit@verisure.pe"),
                        "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe"),
                        "ASUNTO" => $asunto,
                        "MENSAJE" => $cuerpo
                    );
        
                    $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);
        
                    $dataCorreo = array(
                        "IDAsignacion"  => $lastIdAsignacion,
                        "Response"      => $estadoCorreo['RESPUESTA'],
                        "Error"         => $estadoCorreo['ERROR'],
                        'UsuarioCrea'   => $this->items['id'],
                        'FechaCrea'     => $fechaActual,    
                        'Localhost'     => $this->request->getIPAddress()
                    );
        
                    $this->correoStatusAsignacion->insert($dataCorreo, TRUE);
                    
        		}
        		else
                {
                    $this->detalleasignaciones->whereIn('IDAsignacion', $arrayInsertAsign)->delete();
                    $this->asignaciones->whereIn('IDAsignacion', $arrayInsertAsign)->delete();
                    $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar la asignación. Inténtelo luego.</li>");
                    echo $this->alertas->alertaError($message);
                    EXIT;
                }
            }
            else
            {
                $this->detalleasignaciones->whereIn('IDAsignacion', $arrayInsertAsign)->delete();
                $this->asignaciones->whereIn('IDAsignacion', $arrayInsertAsign)->delete();
                $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar la asignación. Inténtelo luego.</li>");
                echo $this->alertas->alertaError($message);
                EXIT;
            }
                
        }

        $message = sprintf($this->mensajeError->msg201, "Se insertaron el total de ".count($arrayAsig)." asignaciones.");
        echo $this->alertas->alertaExito($message);
        echo $this->alertas->refrescar(1);

    }
	
	/**************************************************************************/
	
    /************************* REPOSICIONES ***********************************/
    
    public function listarReposiciones()
    {
		if(isset($this->items['id'])){

			/* ACCIONES */

			if($this->items['idPerfil'] == 3)
			{
			    $cccordinador = $this->globales->listadoCentroCostoCoordinador();
			
			    if(array_key_exists($this->items['id'], $cccordinador))
			    {
			        $centroscosto = $cccordinador[$this->items['id']];
			        $listadoReposicion = $this->reposiciones->listarReposiciones($centroscosto);
			    }
			    else
			    {
			        $listadoReposicion = array();
			    }
			    
			}
			else
			{
			    $centroscosto = array();
			    $listadoReposicion = $this->reposiciones->listarReposiciones($centroscosto);
			}
            
            foreach($listadoReposicion as $key=>$item)
            {
                $detalleReposicion = $this->reposicionesDetalle->listarDetalleReposicion($item['IDReposicion']);
                $montosTrabajador = array_sum(array_column($detalleReposicion, 'TotalTrabajador'));

                $listadoReposicion[$key]['TotalDescuentoTrabajador'] = $montosTrabajador;
                $listadoReposicion[$key]['TotalElementos'] = (empty($detalleReposicion) ? 0 : count($detalleReposicion));
            }
            
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Actas de Reposición | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Actas de Reposición',
				'listaReposiciones'     => $listadoReposicion
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/reposiciones/listar_reposiciones',$data);			
		} else {
			return view('errors/500');
		}
	}

    public function documentoReposicion($idReposicion)
    {
        if(isset($this->items['id'])){

			/* ACCIONES */

            $reposicion = $this->reposiciones->where("IDReposicion",$idReposicion)->first();
            $remitente = $this->usuarios->where("IdUsuario ", $reposicion['UsuarioCrea'])->first();
            $adjudicado = $this->usuarios->buscarUsuario($reposicion['UsuarioAdjudicado']);

            $depaReposicion = $this->estructuraDirecciones->where("IDDireccion", $reposicion['DireccionAdjudicado'])->first();
            $areaReposicion = $this->estructuraAreas->where("IDArea", $reposicion['AreaAdjudicado'])->first();
            
            $whereFirma = array(
                "IDReposicion"  => $idReposicion,
                "Firma"         => "Y"
            );
            $firmaReposicion = $this->reposicionesAdjuntos->where($whereFirma)->first();

            $reposicion['NombreRemitente'] = strtoupper($remitente['Nombres'].' '.$remitente['Apellidos']);
            $reposicion['NombreAdjudicado'] = $adjudicado['Nombres'];
            $reposicion['ApellidosAdjudicado'] = $adjudicado['Apellidos'];
            $reposicion['DocumentoAdjudicado'] = $adjudicado['NumeroDoc'];
            $reposicion['GerenciaAdjudicado'] = $depaReposicion['Direccion'];
            $reposicion['AreaAdjudicado'] = $areaReposicion['Area'];
            $reposicion['MatriculaAdjudicado'] = $adjudicado['Matricula'];
            $reposicion['FechaAdjudicado'] = "Lima, ".date('d', strtotime($reposicion['FechaCrea']))." de ".$this->complementos->parseoMes(date('m', strtotime($reposicion['FechaCrea'])))." de ".date('Y', strtotime($reposicion['FechaCrea']));

			$detalleReposicion = $this->reposicionesDetalle->listarDetalleReposicion($idReposicion);
            
            //$asumeTotalTrabajador = 0;
            foreach($detalleReposicion as $key=>$value)
            {
                $elemento = $this->devolverInformacionElemento($value['TipoElemento'], $value['IDElemento']);
                
                $detalleReposicion[$key]['TIPO'] = $value['TipoElemento'];
                $detalleReposicion[$key]['TipoElemento'] = $elemento['TIPO'];
                $detalleReposicion[$key]['ELEMENTO'] = $elemento['Marca'].' '.$elemento['Modelo'].' '.$elemento['Serie'];
                
                $cronograma = $this->reposicionesCronogramaPago->where("IDDetalleReposicion", $value['IDDetalleReposicion'])->findAll();
    
                foreach($cronograma as $keyC=>$valueC)
                {
                    $cronograma[$keyC]['MesDescontado'] = $this->complementos->parseoMes($valueC['MesCuota'], FALSE);
                }
                
                $detalleReposicion[$key]['CRONOGRAMA'] = $cronograma;
                
            }
            
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Reposiciones | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Acta de descuento',
                'previo'                => 'listar-reposiciones',
                'idReposicion'          => $idReposicion,
				'reposicion'            => $reposicion,
                'detalle'               => $detalleReposicion,
                'firmaReposicion'       => $firmaReposicion
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/reposiciones/documento_reposicion',$data);			
		} else {
			return view('errors/500');
		}
    }

    public function enviarCorreoReposicion()
    {
        $fechaActual = date("Y-m-d H:i:s");

        $idReposicion = $this->request->getPost('idReposicion');
        $reposicion = $this->reposiciones->where("IDReposicion", $idReposicion)->first();
        $adjudicado = $this->usuarios->buscarUsuario($reposicion['UsuarioAdjudicado']);
        
		/*
        * ----------------------------
        * PREPARACIÓN DE CUERPO DE CORREO
        * ----------------------------
		*/

        $arrayCuerpo = array(
            "TITULO" => "ACTA DE REPOSICIÓN",
            "ACTA" => "ACTA DE REPOSICIÓN",
            "USUARIO" => ucwords(mb_strtolower($adjudicado['Nombres'].' '.$adjudicado['Apellidos'])),
            "URL_ACTA" => base_url()."/acta-reposicion/".$idReposicion."/".$reposicion['TokenLinkFirma']
        );

        $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActas($arrayCuerpo);
		/*
        * ----------------------------
        * PREPARACIÓN DE PARAMETROS PARA EL CORREO
        * ----------------------------
		*/

        $asunto='ACTA DE REPOSICIÓN: '.$idReposicion.' - '.$adjudicado['Nombres'].' '.$adjudicado['Apellidos'];
        //$correoDestino = array($asignado['Correo']);
        $configCorreo = array(
            "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
            "CORREO_ORIGEN" => $this->items['correoElectronico'],
            "CORREOS_DESTINOS" => array($this->items['correoElectronico']),
            "CORREOS_COPIA" => array("soporteit@verisure.pe"),
            "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe"),
            "ASUNTO" => $asunto,
            "MENSAJE" => $cuerpo
        );

        $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);

        $dataCorreo = array(
            "IDReposicion"  => $idReposicion,
            "Response"      => $estadoCorreo['RESPUESTA'],
            "Error"         => $estadoCorreo['ERROR'],
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $this->correoStatusReposicion->insert($dataCorreo, TRUE);

        if($estadoCorreo['ERROR'] != '')
        {
            $message = sprintf($this->mensajeError->msg201, "No se pudo enviar el correo. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "Se envió el correo correctamente.");
            echo $this->alertas->alertaExito($message);
        }
        
    }
    
    public function actaReposicion($idReposicion, $token)
    {
        $reposicion = $this->reposiciones->where("IDReposicion", $idReposicion)->first();

        $whereFirma = array(
            "IDReposicion"  => $idReposicion,
            "Firma"         => "Y"
        );
        $firmaReposicion = $this->reposicionesAdjuntos->where($whereFirma)->first();

        if($token == $reposicion['TokenLinkFirma'])
        {
			/* ACCIONES */
            $remitente = $this->usuarios->where("IdUsuario ", $reposicion['UsuarioCrea'])->first();
            $adjudicado = $this->usuarios->buscarUsuario($reposicion['UsuarioAdjudicado']);

            $depaReposicion = $this->estructuraDirecciones->where("IDDireccion", $reposicion['DireccionAdjudicado'])->first();
            $areaReposicion = $this->estructuraAreas->where("IDArea", $reposicion['AreaAdjudicado'])->first();
            
            $reposicion['NombreRemitente'] = strtoupper($remitente['Nombres'].' '.$remitente['Apellidos']);
            $reposicion['NombreAdjudicado'] = $adjudicado['Nombres'];
            $reposicion['ApellidosAdjudicado'] = $adjudicado['Apellidos'];
            $reposicion['DocumentoAdjudicado'] = $adjudicado['NumeroDoc'];
            $reposicion['GerenciaAdjudicado'] = $depaReposicion['Direccion'];
            $reposicion['AreaAdjudicado'] = $areaReposicion['Area'];
            $reposicion['MatriculaAdjudicado'] = $adjudicado['Matricula'];
            $reposicion['FechaAdjudicado'] = "Lima, ".date('d', strtotime($reposicion['FechaCrea']))." de ".$this->complementos->parseoMes(date('m', strtotime($reposicion['FechaCrea'])))." de ".date('Y', strtotime($reposicion['FechaCrea']));

			$detalleReposicion = $this->reposicionesDetalle->listarDetalleReposicion($idReposicion);
            
            foreach($detalleReposicion as $key=>$value)
            {
                $elemento = $this->devolverInformacionElemento($value['TipoElemento'], $value['IDElemento']);
                $detalleReposicion[$key]['TIPO'] = $value['TipoElemento'];
                $detalleReposicion[$key]['TipoElemento'] = $elemento['TIPO'];
                $detalleReposicion[$key]['ELEMENTO'] = $elemento['Marca'].' '.$elemento['Modelo'].' '.$elemento['Serie'];
                
                $cronograma = $this->reposicionesCronogramaPago->where("IDDetalleReposicion", $value['IDDetalleReposicion'])->findAll();
    
                foreach($cronograma as $keyC=>$valueC)
                {
                    $cronograma[$keyC]['MesDescontado'] = $this->complementos->parseoMes($valueC['MesCuota'], FALSE);
                }
                
                $detalleReposicion[$key]['CRONOGRAMA'] = $cronograma;
            }

			$data = array (
				'titulo'                => 'Reposiciones | Verisure',
                'idReposicion'          => $idReposicion,
				'reposicion'            => $reposicion,
                'cronograma'            => $cronograma,
                'detalle'               => $detalleReposicion,
                'firmaReposicion'       => $firmaReposicion
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/reposiciones/acta_reposicion',$data);	
        }
        else
        {
            return view('errors/500');
        }
    }

    public function detalleActaReposicion($idReposicion)
    {
        if(isset($this->items['id'])){

			/* ACCIONES */
            $reposicion = $this->reposiciones->where("IDReposicion",$idReposicion)->first();
            $listaDetalle = $this->reposicionesDetalle->listarDetalleReposicion($idReposicion);
            $listaAdjunto = $this->reposicionesAdjuntos->where("IDReposicion", $idReposicion)->findAll();    

            foreach($listaDetalle as $key=>$value)
            {
                $elemento = $this->devolverInformacionElemento($value['TipoElemento'], $value['IDElemento']);
                
                $listaDetalle[$key]['TIPO'] = $value['TipoElemento'];
                $listaDetalle[$key]['TipoElemento'] = $elemento['TIPO'];
                $listaDetalle[$key]['Elemento'] = $elemento['Marca'].' '.$elemento['Modelo'].' '.$elemento['Serie'];
            }

			$data = array (
				'session'               => 'on',
				'titulo'                => 'Detalle de Reposición | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Detalle de Reposición | '.$reposicion['IDReposicion'],
                'previo'                => 'listar-reposiciones',
				'listaDetalle'          => $listaDetalle,
                'listaAdjunto'          => $listaAdjunto,
                'idReposicion'          => $idReposicion
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/reposiciones/listar_detalle_reposicion',$data);			
		} else {
			return view('errors/500');
		}
    }
    
    public function subirFirmaActaReposicion()
    {
        $fechaActual = date("Y-m-d H:i:s");

        $idReposicion = $this->request->getPost("txtIDReposicion");
        $canvasFirma = $this->request->getPost("firmaActaReposicion");
        
        $adjunto = $this->request->getFile("fileFotoDNI");
        
        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $adjunto->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $adjunto->getErrorString().'-'.$adjunto->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'fileFotoDNI' => [
                'mime_in[fileFotoDNI,image/png,image/jpg,image/jpeg,image/gif,application/pdf]',
                'ext_in[fileFotoDNI,png,jpg,jpeg,gif,pdf]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        if($adjunto->guessExtension() != null)
        {
            $extensionDoc = $adjunto->guessExtension();
        }
        else
        {
            $nombre_original = $adjunto->getBasename();
            $fileNameCmps = explode(".", $nombre_original);
            $extensionDoc = strtolower(end($fileNameCmps));
        }

        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */

        $reposicion = $this->reposiciones->where("IDReposicion", $idReposicion)->first();

        $data = array (
            'IDReposicion'      => $idReposicion, 
            'Nombre'            => "DOCUMENTO DE IDENTIDAD", 
            'Extension'         => $extensionDoc,
            'Observacion'       => "DOCUMENTO DE IDENTIDAD ADJUNTADO EN LA FIRMA.",
            'ReemplazoFirma'    => 'N',  
            'UsuarioCrea'       => $reposicion['UsuarioAdjudicado'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->reposicionesAdjuntos->insert($data, TRUE);

		if($lastId === FALSE){
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
			exit;
		}

        /*
        * ----------------------------
        * GUARDAR ARCHIVO ADJUNTO
        * ----------------------------
        */
        $ruta = "public/docs/ActaReposicion/";
        $nombreArchivo = $idReposicion."-".$lastId;

        if(!file_exists($ruta))
        {
            @mkdir($ruta, 0777, true);
        }

		# si exsite la carpeta o se ha creado
		if (file_exists($ruta) || @mkdir($ruta)) 
        {
            $nuevonombre = $nombreArchivo.'.'.$extensionDoc;
            
            $estadoMove = $adjunto->move($ruta, $nuevonombre);
            
            if (!$estadoMove) {
                $this->reposicionesAdjuntos->delete(["IDAdjuntoReposicion", $lastId]);
                $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[SAVEDOC]");
                echo $this->alertas->alertaError($message);
                exit;
            }
        }
        else
        {
            $this->reposicionesAdjuntos->delete(["IDAdjuntoReposicion", $lastId]);
            $message = sprintf($this->mensajeError->msg201, "No existe ruta. Inténtelo luego.[SAVEDOC]");
            echo $this->alertas->alertaError($message);
        }
        
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */

        $dataFirma = array (
            'IDReposicion'      => $idReposicion, 
            'Nombre'            => "FIRMA", 
            'Extension'         => "png",
            'Observacion'       => "FIRMA DE USUARIO DE REPOSICIÓN.",
            'ReemplazoFirma'    => 'N',  
            'Firma'             => 'Y',  
            'UsuarioCrea'       => $reposicion['UsuarioAdjudicado'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastIdFirma = $this->reposicionesAdjuntos->insert($dataFirma, TRUE);

		if($lastIdFirma === FALSE){
            unlink($ruta.$nombreArchivo.'.'.$extensionDoc);
            $this->reposicionesAdjuntos->delete(["IDAdjuntoReposicion", $lastId]);
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la firma. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
			exit;
		}

        /*
        * ----------------------------
        * GUARDAR FIRMA
        * ----------------------------
        */

        $nombreArchivoFirma = $idReposicion."-".$lastIdFirma;

        if(!file_exists($ruta))
        {
            @mkdir($ruta, 0777, true);
        }

		# si exsite la carpeta o se ha creado
		if (file_exists($ruta) || @mkdir($ruta)) 
        {
            $nuevonombreFirma = $nombreArchivoFirma.'.png';
            
            $datos = base64_decode(
                preg_replace('/^[^,]*,/', '', $canvasFirma)
            );

            $estadoFirma = file_put_contents($ruta.$nuevonombreFirma, $datos);
            
            if ($estadoFirma===FALSE) {
                unlink($ruta.$nombreArchivo.'.'.$extensionDoc);
                $this->reposicionesAdjuntos->delete(["IDAdjuntoReposicion", $lastId]);
                $this->reposicionesAdjuntos->delete(["IDAdjuntoReposicion", $lastIdFirma]);
                $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la firma. Inténtelo luego.[SAVEDOC]");
                echo $this->alertas->alertaError($message);
                exit;
            }
        }
        else
        {
            unlink($ruta.$nombreArchivo.'.'.$extensionDoc);
            $this->reposicionesAdjuntos->delete(["IDAdjuntoReposicion", $lastId]);
            $this->reposicionesAdjuntos->delete(["IDAdjuntoReposicion", $lastIdFirma]);
            $message = sprintf($this->mensajeError->msg201, "No existe ruta. Inténtelo luego.[SAVEDOC]");
            echo $this->alertas->alertaError($message);
        }
        
        /*
        * ----------------------------
        * PREPARACIÓN DE CUERPO DE CORREO
        * ----------------------------
        */
        
        $usuarioRemitente = $this->usuarios->where("IdUsuario", $reposicion['UsuarioCrea'])->first();
        
        $usuarioAdjudicado = $this->usuarios->where("IdUsuario", $reposicion['UsuarioAdjudicado'])->first();
        
        $arrayCuerpo = array(
            "TITULO" => "FIRMA DE ACTA DE REPOSICIÓN",
            "ACTA" => "ACTA DE REPOSICIÓN",
            "USUARIO" => ucwords(mb_strtolower($usuarioRemitente['Nombres'].' '.$usuarioRemitente['Apellidos'])),
            "CODIGO" => $reposicion['IDReposicion']
        );

        $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActasConfirmacion($arrayCuerpo);
        
        /*
        * ----------------------------
        * PREPARACIÓN DE PARAMETROS PARA EL CORREO
        * ----------------------------
        */

        $asunto='FIRMA DE ACTA DE REPOSICIÓN: '.$reposicion['IDReposicion'].' - '.$usuarioAdjudicado['Nombres'].' '.$usuarioAdjudicado['Apellidos'];
        //$correoDestino = array($asignado['Correo']);
        $configCorreo = array(
            "NOMBRE_ORIGEN" => $usuarioAdjudicado['Nombres'].' '.$usuarioAdjudicado['Apellidos'],
            "CORREO_ORIGEN" => $usuarioAdjudicado['Correo'],
            "CORREOS_DESTINOS" => array($usuarioRemitente['Correo']),
            "CORREOS_COPIA" => array("soporteit@verisure.pe"),
            "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe"),
            "ASUNTO" => $asunto,
            "MENSAJE" => $cuerpo
        );

        $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);

        $dataCorreo = array(
            "IDReposicion"  => $reposicion['IDReposicion'],
            "Response"      => $estadoCorreo['RESPUESTA'],
            "Error"         => $estadoCorreo['ERROR'],
            'UsuarioCrea'   => $reposicion['UsuarioAdjudicado'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $this->correoStatusReposicion->insert($dataCorreo, TRUE);

        $message = sprintf($this->mensajeError->msg201, "La firma fue registrada exitosamente.");
        echo $this->alertas->alertaExito($message);
        echo $this->alertas->refrescar(1);
    }

	/**************************************************************************/
	
    /************************* DEVOLUCIONES ***********************************/
    
    public function listarDevoluciones()
    {
        if(isset($this->items['id'])){

			/* ACCIONES */
            
			if($this->items['idPerfil'] == 3)
			{
			    $cccordinador = $this->globales->listadoCentroCostoCoordinador();
			
			    if(array_key_exists($this->items['id'], $cccordinador))
			    {
			        $centroscosto = $cccordinador[$this->items['id']];
			        $listadoDevolucion = $this->devoluciones->listarDevoluciones($centroscosto);
			    }
			    else
			    {
			        $listadoDevolucion = array();
			    }
			    
			}
			else
			{
			    $centroscosto = array();
			    $listadoDevolucion = $this->devoluciones->listarDevoluciones($centroscosto);
			}
            
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Actas de Devolución | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Actas de Devolución',
				'listadoDevolucion'     => $listadoDevolucion
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/devoluciones/listar_devoluciones',$data);			
		} else {
			return view('errors/500');
		}
    }

    public function nuevaDevolucion()
    {
        if(isset($this->items['id'])){

			/* ACCIONES */
			
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Nueva Devolución | Verisure',
                'previo'                => 'listar-devoluciones',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Nueva Devolución'
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/devoluciones/nueva_devolucion',$data);			
		} else {
			return view('errors/500');
		}
    }

    public function listadoPendientesDevolucionUsuario()
    {
		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idUsuario = $this->request->getPost('idUsuario');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idUsuario, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$listadoItems = $this->detalleasignaciones->listarDetalleAsignadosUsuario($idUsuario);
        $items = array();

        if (!empty($listadoItems)) {
            foreach($listadoItems as $value)
            {
                //Obtener elemento
                if($value['TipoElemento']=='MOVIL')
                {
                    $dataElemento = $this->moviles->obtenerMovil($value['IDElemento']);
                    $elemento = $value['TipoElemento'].' | '.$dataElemento['IMEI'].' '.$dataElemento['Marca'].' '.$dataElemento['Modelo'];
                }
                else if($value['TipoElemento']=='LINEA')
                {
                    $dataElemento = $this->lineas->obtenerLinea($value['IDElemento']);
                    $elemento = $value['TipoElemento'].' | '.$dataElemento['Numero'].' '.$dataElemento['Operador'].' '.$dataElemento['Plan'].' '.$dataElemento['ICCID'];
                }
                else if($value['TipoElemento']=='HARDWARE')
                {
                    $dataElemento = $this->hardware->obtenerHardware($value['IDElemento']);
                    
                    if($dataElemento['id_categoria'] == '3')
                    {
                        $elemento = $dataElemento['nombre_tipo'].' | '.$dataElemento['Marca'].' '.$dataElemento['Modelo'].' '.$dataElemento['Serie'];
                    }
                    else
                    {
                        $elemento = $dataElemento['nombre_tipo'].' | '.$dataElemento['Hostname'].' '.$dataElemento['Marca'].' '.$dataElemento['Modelo'].' '.$dataElemento['Serie'];
                    }
                }
                else if($value['TipoElemento']=='TARJETA')
                {
                    $dataElemento = $this->tarjetasAcceso->where("IDTarjetaAcceso", $value['IDElemento'])->first();
                    $elemento = $value['TipoElemento'].' | '.$dataElemento['Serie'];
                }
                else if($value['TipoElemento']=='KITDEMO')
                {
                    $dataElemento = $this->kitsDemo->obtenerItemKitDemo($value['IDElemento']);
                    $elemento = $value['TipoElemento'].' - '.$dataElemento['CodigoKitDemo'].' | '.$dataElemento['Nombre'].' '.$dataElemento['SKU'].' '.$dataElemento['Serie'];
                }
                else
                {
                    $elemento = '';
                }
                //var_dump($items);
            
                $items[] = array(
					'idDetalleAsignacion' => (string) $value['IDDetalleAsignacion'],
         	        'item' => (string) $elemento
                );
            }

            $resultado = array(
				'listadoItems' => json_encode($items)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
    }
    
    public function registrarDevolucion()
    {
        $fechaActual = date("Y-m-d H:i:s");
        $fechaActualAdd = date("Y-m-d H:i:s", strtotime($fechaActual)+1);
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        

        $msjError = TRUE;
        $usuarioDevolucion = $this->request->getPost('txtUsuarioDevolucion');
        $observacion = $this->request->getPost('txtObservacion');
        $motivo = $this->request->getPost('txtMotivoDevolucion');
        
        $elemento = $this->request->getPost('elemento');
        $etiqueta = $this->request->getPost('etiqueta');
        $situacion = $this->request->getPost('txtSituacionElemento');
        $obsElemento = $this->request->getPost('txtObservacionElemento');
        
        $adjunto = $this->request->getFile("fileAdjuntoDevolucion");
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        $error = '';
        $error .= $this->complementos->validaCampo($usuarioDevolucion, 'required|trim', 'Usuario');
        $error .= $this->complementos->validaCampo($observacion, 'required|trim', 'Observación');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo de devolución');
        
        if(empty($situacion))
        {
            $error .= "<li>Debe seleccionar la situación del item mostrado.</li>";
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $arraySituacion = array_column($situacion, 'SITUACION');
        
        if(in_array("ROB", $arraySituacion) || in_array("PER", $arraySituacion))
        {
            /*
            * ----------------------------
            * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
            * ----------------------------
            */
            
            if (! $adjunto->isValid()) {
                $message = sprintf($this->mensajeError->msg201, $adjunto->getErrorString().'-'.$adjunto->getError());
                echo $this->alertas->alertaError($message);
                exit;
            }
            
            /*
            * ----------------------------
            * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
            * ----------------------------
            */
            
            $validationRule = [
                'fileAdjuntoDevolucion' => [
                    'mime_in[fileAdjuntoDevolucion,image/png,image/jpg,image/jpeg,image/gif,application/pdf]',
                    'ext_in[fileAdjuntoDevolucion,pdf]'
                ],
            ];

            if (! $this->validate($validationRule)) {
                $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
                echo $this->alertas->alertaError($message);
                exit;
            }
        }
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        foreach($elemento as $detalle)
        {
            $elementoDevuelto = $this->devolucionesDetalle->where("IDDetalleAsignacion", $detalle)->findAll();

            if(!empty($elementoDevuelto))
            {
                $msgExistencia .= "<li>El ".$etiquetaitem[$detalle]['ETIQUETA']." ya fue devuelto.</li>";
            }
        }
		
        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * INSERCIÓN DE DATOS DEVOLUCIÓN
        * ----------------------------
        */
        
        $datosUsuario = $this->usuarios->buscarUsuario($usuarioDevolucion);
        $tokenDevolucion = $this->complementos->generar_string_aleatorio(15);

        $dataDevolucion = array (
            'UsuarioDevolucion'         => $usuarioDevolucion, 
            'CargoDevolucion'           => $datosUsuario['Cargo'], 
            'DireccionDevolucion'       => $datosUsuario['IDDireccion'], 
            'AreaDevolucion'            => $datosUsuario['IDArea'], 
            'SubareaDevolucion'         => $datosUsuario['IDSubarea'], 
            'DelegacionDevolucion'      => $datosUsuario['IDDelegacion'], 
            'Motivo'                    => $motivo, 
            'Observacion'               => $observacion, 
            'TokenLinkFirma'            => $tokenDevolucion, 
            'UsuarioCrea'               => $this->items['id'],
            'CargoCrea'                 => $this->items['cargo'], 
            'DireccionCrea'             => $this->items['dpto'], 
            'AreaCrea'                  => $this->items['idArea'], 
            'SubareaCrea'               => $this->items['idSubarea'],
            'DelegacionCrea'            => $this->items['idDelegacionLog'],
            'FechaCrea'                 => $fechaActual,
            'Localhost'                 => $this->request->getIPAddress()
        );

        $lastIdDevolucion = $this->devoluciones->insert($dataDevolucion, TRUE);
        
        if($lastIdDevolucion !== FALSE){
            $idDevolucion = $lastIdDevolucion;
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar la devolución. Inténtelo luego.[AD]</li>");
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $dataDetalleDevolucion = array();

        foreach($elemento as $detalle)
        {
            $dataDetalleDevolucion[] = array (
                'IDDevolucion'          => $idDevolucion, 
                'IDDetalleAsignacion'   => $detalle,  
                'MotivoDevolucion'      => $situacion[$detalle]['SITUACION'],
                'Observacion'           => $obsElemento[$detalle]['OBSERVACION'],
                'UsuarioCrea'           => $this->items['id'],
                'FechaCrea'             => $fechaActual,    
                'Localhost'             => $this->request->getIPAddress()
            );
        }
        $lastIdDetalleDevolucion = $this->devolucionesDetalle->insertBatch($dataDetalleDevolucion);
        
		if($lastIdDetalleDevolucion === FALSE){
            $this->devoluciones->where('IDDevolucion', $idDevolucion)->delete();
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la devolución. Inténtelo luego.[ADD]");
			echo $this->alertas->alertaError($message);
			exit;
		} 

        $situacionesReposicion = array_diff($arraySituacion, array("DEV", "FVU", "REN"));

        if(!empty($situacionesReposicion))
        {
            /*
            * ----------------------------
            * INSERCIÓN DE DATOS REPOSICIÓN
            * ----------------------------
            */

            $datosAdjudicado = $this->usuarios->buscarUsuario($usuarioDevolucion);
            $tokenReposicion = $this->complementos->generar_string_aleatorio(15);

            $dataReposicion = array (
                'UsuarioAdjudicado'         => $usuarioDevolucion, 
                'CargoAdjudicado'           => $datosAdjudicado['Cargo'], 
                'DireccionAdjudicado'       => $datosAdjudicado['IDDireccion'], 
                'AreaAdjudicado'            => $datosAdjudicado['IDArea'], 
                'SubareaAdjudicado'         => $datosAdjudicado['IDSubarea'], 
                'DelegacionAdjudicado'      => $datosAdjudicado['IDDelegacion'], 
                'TokenLinkFirma'            => $tokenReposicion, 
                'LiberadoFirma'             => "Y", 
                'Motivo'                    => "REPOSICIÓN POR ACTA DE DEVOLUCIÓN", 
                'Observacion'               => $observacion, 
                'Cuotas'                    => 'N', 
                'UsuarioCrea'               => $this->items['id'],
                'CargoCrea'                 => $this->items['cargo'], 
                'DireccionCrea'             => $this->items['dpto'],
                'AreaCrea'                  => $this->items['idArea'],
                'SubareaCrea'               => $this->items['idSubarea'],
                'DelegacionCrea'            => $this->items['idDelegacionLog'],
                'FechaCrea'                 => $fechaActualAdd,    
                'Localhost'                 => $this->request->getIPAddress()
            );

            $lastIdReposicion = $this->reposiciones->insert($dataReposicion, TRUE);
            
            if($lastIdReposicion !== FALSE){
                $idReposicion = $lastIdReposicion;
            }
            else
            {
                $this->devolucionesDetalle->where('IDDevolucion', $idDevolucion)->delete();
                $this->devoluciones->where('IDDevolucion', $idDevolucion)->delete();
                $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar la devolución. Inténtelo luego[AR].</li>");
                echo $this->alertas->alertaError($message);
                EXIT;
            }

            $dataDetalle = array();
            // $totalSumaTrabajador = 0;

            foreach($elemento as $detalle)
            {
                if($situacion[$detalle]['SITUACION'] != 'DEV' && $situacion[$detalle]['SITUACION'] != 'FVU' && $situacion[$detalle]['SITUACION'] != 'REN')
                {
                    $detalleAsignacion = $this->detalleasignaciones->obtenerDetalleAsignacion($detalle);

                    if($detalleAsignacion['TipoElemento']=="LINEA")
                    {
                        $totalDescuento = 1;
                        $totalVerisure = 0;
                        $totalTrabajador = 1;
                        
                        $cuotasTrabajador = 1;
                        $bolsa = "IT";
                    }
                    else if($detalleAsignacion['TipoElemento']=="MOVIL")
                    {
                        $informacionMovil = $this->moviles->obtenerMovil($detalleAsignacion['IDElemento']);
                        $contrato = $this->contratos->obtenerContratosXEquipo($detalleAsignacion['IDElemento']);
                        
                        if($informacionMovil['EquipoStock'] == 'Y' || empty($contrato))
                        {
                            $fechaReferencia = $detalleAsignacion['FechaAsignado'] != '' && $detalleAsignacion['FechaAsignado'] != null && $detalleAsignacion['FechaAsignado'] != "0000-00-00" ? $detalleAsignacion['FechaAsignado'] : $detalleAsignacion['FechaCrea'];
                            
                            $contrato['Permanencia'] = 'Y';
                            $contrato['PrecioCompra'] = $informacionMovil['PrecioCompra'];
                            $contrato['MontoCuota'] = number_format(round($informacionMovil['PrecioCompra']/18, 8), 8, '.', '');
                            $contrato['DiaFacturacion'] = date("d", strtotime($fechaReferencia."- 1 days"));
                            $contrato['PeriodoPermanencia'] = '18';
                            $contrato['InicioContrato'] = date("Y-m-d", strtotime($fechaReferencia));
                        }
            
                        $montoTotal = $this->complementos->calculoPenalidadMovil($contrato);
                        $cantidadRobo = $this->detalleasignaciones->obtenerDispositivosRobadosUsuario($usuarioDevolucion, "MOVIL");
                        $porcentajes = $this->complementos->calculoPorcentajeResponsabilidadMovil(count($cantidadRobo), $montoTotal, $situacion[$detalle]['SITUACION']);

                        $totalDescuento = $montoTotal;
                        $totalVerisure = $porcentajes['VERISURE'];
                        $totalTrabajador = $porcentajes['TRABAJADOR'];
                        
                        $cuotasTrabajador = ($motivo == 'CESE' ? 1 : $this->complementos->rangoDescuentosMoviles($totalTrabajador));
                        $bolsa = "IT";
                    }
                    else if($detalleAsignacion['TipoElemento']=="HARDWARE")
                    {
                        $infohardware = $this->hardware->where("IDHardware", trim($detalleAsignacion['IDElemento']))->first();
                        $montoTotal = $infohardware['PrecioCompra'];
                        $cantidadRobo = $this->detalleasignaciones->obtenerDispositivosRobadosUsuario($usuarioDevolucion,"HARDWARE");
                        $porcentajes = $this->complementos->calculoPorcentajeResponsabilidadMovil(count($cantidadRobo), $montoTotal, $situacion[$detalle]['SITUACION']);
                        $totalDescuento = $montoTotal;
                        $totalVerisure = $porcentajes['VERISURE'];
                        $totalTrabajador = $porcentajes['TRABAJADOR'];
                        
                        $cuotasTrabajador = ($motivo == 'CESE' ? 1 : $this->complementos->rangoDescuentosHardware($totalTrabajador));
                        $bolsa = "IT";
                    }
                    else if($detalleAsignacion['TipoElemento']=="TARJETA")
                    {
                        $tarjeta = $this->tarjetasAcceso->where("IDTarjetaAcceso", $detalleAsignacion['IDElemento'])->first();
            
                        $totalDescuento = $tarjeta['PrecioCompra'];
                        $totalVerisure = 0;
                        $totalTrabajador = $tarjeta['PrecioCompra'];
                        
                        $cuotasTrabajador = 1;
                        $bolsa = "IT";
                    }
                    else if($detalleAsignacion['TipoElemento']=="KITDEMO")
                    {
                        $infoItem = $this->kitsDemo->obtenerItemKitDemo($detalleAsignacion['IDElemento']);
                        $montoTotal = $infoItem['PrecioReposicion'];
                        $cantidadRobo = $this->detalleasignaciones->obtenerDispositivosRobadosUsuario($usuarioDevolucion,"KITDEMO",$detalleAsignacion['IDElemento']);
                        $porcentajes = $this->complementos->calculoPorcentajeResponsabilidadKitDemo(count($cantidadRobo), $montoTotal, $situacion[$detalle]['SITUACION']);
                        $totalDescuento = $montoTotal;
                        $totalVerisure = $porcentajes['VERISURE'];
                        $totalTrabajador = $porcentajes['TRABAJADOR'];
                        
                        $cuotasTrabajador = ($motivo == 'CESE' ? 1 : $this->complementos->rangoDescuentosKitDemo($totalTrabajador));
                        $bolsa = "URES";
                    }
                    else
                    {
                        $totalDescuento = "0";
                        $totalVerisure = "0";
                        $totalTrabajador = "0";
                        
                        $cuotasTrabajador = 1;
                        $bolsa = "IT";
                    }
                    
                    $dataDetalle = array (
                        'IDReposicion'          => $idReposicion, 
                        'IDDetalleAsignacion'   => $detalle,  
                        'TotalDescuento'        => $totalDescuento, 
                        'TotalVerisure'         => $totalVerisure, 
                        'TotalTrabajador'       => $totalTrabajador, 
                        'Observacion'           => $obsElemento[$detalle]['OBSERVACION'], 
                        'TotalCuotas'           => $cuotasTrabajador,
                        'Bolsa'                 => $bolsa,
                        'Cobrado'               => 'N',
                        'UsuarioCrea'           => $this->items['id'],
                        'FechaCrea'             => $fechaActualAdd,    
                        'Localhost'             => $this->request->getIPAddress()
                    );
                    
                    $lastIdDetalleReposicion = $this->reposicionesDetalle->insert($dataDetalle, TRUE);
                    
                    if($lastIdDetalleReposicion === FALSE){
                        $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la reposición de un item. Inténtelo luego.[ARD]");
                        echo $this->alertas->alertaError($message);
                        exit;
                    } 
                    
                    /*
                    * ----------------------------
                    * INSERCIÓN DE DATOS REPOSICIÓN - CRONOGRAMA DE PAGOS
                    * ----------------------------
                    */
                    
                    $diaPlanilla = $this->globales->diaCortePlanilla();
        
                    $fechaPlanillaActual = date("Y-m-".$diaPlanilla);
        
                    $timePlanilla = strtotime($fechaPlanillaActual);
                    $timeActual = strtotime($fechaActual);
        
                    $mesInicioCuotas=0;
                    $anioInicioCuotas=0;
        
                    if($timePlanilla > $timeActual)
                    {
                        $mesInicioCuotas = date("m");
                        $anioInicioCuotas = date("Y");
                    }
                    else
                    {
                        $mesActual = date("m");
                        $anioActual = date("Y");
        
                        if($mesActual == 12)
                        {
                            $mesInicioCuotas = 1;
                            $anioInicioCuotas = $anioActual +1 ;
                        }
                        else
                        {
                            $mesInicioCuotas = $mesActual + 1;
                            $anioInicioCuotas = $anioActual;
                        }
                    }
        
                    $dataCronogramaPago = array();
                    
                    $descuentoMensual = number_format(round($totalTrabajador / $cuotasTrabajador, 2), 2, '.', '');
        
                    for($i=1; $i<=$cuotasTrabajador;$i++)
                    {
                        if($i == ($cuotasTrabajador))
                        {
                            $montoCuota = ($totalTrabajador - (($cuotasTrabajador - 1)*$descuentoMensual));
                        }
                        else
                        {
                            $montoCuota = $descuentoMensual;
                        }
        
                        $dataCronogramaPago[] = array (
                            'IDDetalleReposicion'   => $lastIdDetalleReposicion, 
                            'NroCuota'              => $i, 
                            'MesCuota'              => $mesInicioCuotas, 
                            'AnioCuota'             => $anioInicioCuotas, 
                            'MontoCuota'            => $montoCuota, 
                            'Observacion'           => 'Cuota generada automáticamente', 
                            'UsuarioCrea'           => $this->items['id'],
                            'FechaCrea'             => $fechaActual,    
                            'Localhost'             => $this->request->getIPAddress()
                        );
        
                        $mesInicioCuotas++;
        
                        if($mesInicioCuotas > 12)
                        {
                            $mesInicioCuotas = 1;
                            $anioInicioCuotas = $anioInicioCuotas + 1;
                        }
                    }
        
                    $lastIdCronograma = $this->reposicionesCronogramaPago->insertBatch($dataCronogramaPago);
                    
                    if($lastIdCronograma === FALSE){
                        // $this->devolucionesDetalle->where('IDDetalleReposicion', $lastIdDetalleReposicion)->delete();
                        $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la reposición. Inténtelo luego.[INSERTCRP]");
                        echo $this->alertas->alertaError($message);
                        exit;
                    } 

                }
            }

            /*
            * ----------------------------
            * GUARDAR ARCHIVO ADJUNTO
            * ----------------------------
            */
            
            
            if($adjunto->guessExtension() != null)
            {
                $extensionDoc = $adjunto->guessExtension();
            }
            else
            {
                $nombre_original = $adjunto->getBasename();
                $fileNameCmps = explode(".", $nombre_original);
                $extensionDoc = strtolower(end($fileNameCmps));
            }

            if(in_array("ROB", $arraySituacion) || in_array("PER", $arraySituacion))
            {
                /*
                * ----------------------------
                * INSERCIÓN DE DATOS ADJUNTOS
                * ----------------------------
                */

                $dataAdjuntoReposicion = array (
                    'IDReposicion'      => $idReposicion, 
                    'Nombre'            => "Denuncia Reposición", 
                    'Extension'         => $extensionDoc,
                    'Observacion'       => "Reporte de denuncia de equipos.",
                    'ReemplazoFirma'    => "N",  
                    'UsuarioCrea'       => $this->items['id'],
                    'FechaCrea'         => $fechaActualAdd,    
                    'Localhost'         => $this->request->getIPAddress()
                );

                $lastIdAdjuntosReposiciones = $this->reposicionesAdjuntos->insert($dataAdjuntoReposicion, TRUE);

                if($lastIdAdjuntosReposiciones === FALSE){
                    $this->reposicionesCronogramaPago->where('IDReposicion', $idReposicion)->delete();
                    $this->reposicionesDetalle->where('IDReposicion', $idReposicion)->delete();
                    $this->reposiciones->where('IDReposicion', $idReposicion)->delete();
                    $this->devolucionesDetalle->where('IDDevolucion', $idDevolucion)->delete();
                    $this->devoluciones->where('IDDevolucion', $idDevolucion)->delete();
                    $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el acta de devolución. Inténtelo luego.[ARA]");
                    echo $this->alertas->alertaError($message);
                    exit;
                }

                /*
                * ----------------------------
                * GUARDAR ARCHIVO ADJUNTO REPOSICIÓN
                * ----------------------------
                */
                $ruta = "public/docs/ActaReposicion/";
                $nombreArchivo = $idReposicion."-".$lastIdAdjuntosReposiciones;

                if(!file_exists($ruta))
                {
                    @mkdir($ruta, 0777, true);
                }

                # si exsite la carpeta o se ha creado
                if (file_exists($ruta) || @mkdir($ruta)) 
                {
                    $nuevonombre = $nombreArchivo.'.'.$extensionDoc;
                    
                    $estadoMove = $adjunto->move($ruta, $nuevonombre);
                    
                    if (!$estadoMove) {
                        $this->reposicionesCronogramaPago->where('IDReposicion', $idReposicion)->delete();
                        $this->reposicionesAdjuntos->where('IDAdjuntoReposicion', $lastIdAdjuntosReposiciones)->delete();
                        $this->reposicionesDetalle->where('IDReposicion', $idReposicion)->delete();
                        $this->reposiciones->where('IDReposicion', $idReposicion)->delete();
                        $this->devolucionesDetalle->where('IDDevolucion', $idDevolucion)->delete();
                        $this->devoluciones->where('IDDevolucion', $idDevolucion)->delete();
                        $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el acta de devolución. Inténtelo luego.[SAVEDOC]");
                        echo $this->alertas->alertaError($message);
                        exit;
                    }
                }
                else
                {
                    $this->reposicionesCronogramaPago->where('IDReposicion', $idReposicion)->delete();
                    $this->reposicionesAdjuntos->where('IDAdjuntoReposicion', $lastIdAdjuntosReposiciones)->delete();
                    $this->reposicionesDetalle->where('IDReposicion', $idReposicion)->delete();
                    $this->reposiciones->where('IDReposicion', $idReposicion)->delete();
                    $this->devolucionesDetalle->where('IDDevolucion', $idDevolucion)->delete();
                    $this->devoluciones->where('IDDevolucion', $idDevolucion)->delete();
                    $message = sprintf($this->mensajeError->msg201, "No existe ruta. Inténtelo luego.[SAVEDOC]");
                    echo $this->alertas->alertaError($message);
                    exit;
                }
            }

            
            /*
            * ----------------------------
            * PREPARACIÓN DE CUERPO DE CORREO DE REPOSICIÓN
            * ----------------------------
            */

            $arrayCuerpo = array(
                "TITULO" => "ACTA DE REPOSICIÓN",
                "ACTA" => "ACTA DE REPOSICIÓN",
                "USUARIO" => ucwords(mb_strtolower($datosAdjudicado['Nombres'].' '.$datosAdjudicado['Apellidos'])),
                "URL_ACTA" => base_url()."/acta-reposicion/".$idReposicion."/".$tokenReposicion
            );

            $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActas($arrayCuerpo);
            
            /*
            * ----------------------------
            * PREPARACIÓN DE PARAMETROS PARA EL CORREO
            * ----------------------------
            */

            $asunto='ACTA DE REPOSICIÓN: '.$idReposicion.' - '.$datosAdjudicado['Nombres'].' '.$datosAdjudicado['Apellidos'];
            //$correoDestino = array($asignado['Correo']);
            $configCorreo = array(
                "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
                "CORREO_ORIGEN" => $this->items['correoElectronico'],
                "CORREOS_DESTINOS" => array($this->items['correoElectronico']),
                "CORREOS_COPIA" => array("soporteit@verisure.pe"),
                "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe"),
                "ASUNTO" => $asunto,
                "MENSAJE" => $cuerpo
            );

            $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);

            $dataCorreo = array(
                "IDReposicion"  => $idReposicion,
                "Response"      => $estadoCorreo['RESPUESTA'],
                "Error"         => $estadoCorreo['ERROR'],
                'UsuarioCrea'   => $this->items['id'],
                'FechaCrea'     => $fechaActual,    
                'Localhost'     => $this->request->getIPAddress()
            );

            $this->correoStatusReposicion->insert($dataCorreo, TRUE);
            
        }
        
        /*
        * ----------------------------
        * PREPARACIÓN DE CUERPO DE CORREO DE DEVOLUCIÓN
        * ----------------------------
        */

        $arrayCuerpo = array(
            "TITULO" => "ACTA DE DEVOLUCIÓN",
            "ACTA" => "ACTA DE DEVOLUCIÓN",
            "USUARIO" => ucwords(mb_strtolower($datosUsuario['Nombres'].' '.$datosUsuario['Apellidos'])),
            "URL_ACTA" => base_url()."/acta-devolucion/".$idDevolucion."/".$tokenDevolucion
        );

        $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActas($arrayCuerpo);
        
        /*
        * ----------------------------
        * PREPARACIÓN DE PARAMETROS PARA EL CORREO
        * ----------------------------
        */

        $asunto='ACTA DE DEVOLUCIÓN: '.$idDevolucion.' - '.$datosUsuario['Nombres'].' '.$datosUsuario['Apellidos'];
        //$correoDestino = array($asignado['Correo']);
        $configCorreo = array(
            "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
            "CORREO_ORIGEN" => $this->items['correoElectronico'],
            "CORREOS_DESTINOS" => array($this->items['correoElectronico']),
            "CORREOS_COPIA" => array("soporteit@verisure.pe"),
            "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe"),
            "ASUNTO" => $asunto,
            "MENSAJE" => $cuerpo
        );

        $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);

        $dataCorreo = array(
            "IDDevolucion"  => $idDevolucion,
            "Response"      => $estadoCorreo['RESPUESTA'],
            "Error"         => $estadoCorreo['ERROR'],
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $this->correoStatusDevolucion->insert($dataCorreo, TRUE);
        
        $message = sprintf($this->mensajeError->msg201, "La devolución fue solicitada exitosamente.");
        echo $this->alertas->alertaExito($message);
        echo $this->alertas->reDireccion(base_url()."/documento-devolucion/".$idDevolucion, 1);
        
    }

    public function documentoDevolucion($idDevolucion)
    {
        if(isset($this->items['id'])){

			/* ACCIONES */

            $devolucion = $this->devoluciones->where("IDDevolucion",$idDevolucion)->first();
            $remitente = $this->usuarios->where("IdUsuario ", $devolucion['UsuarioCrea'])->first();
            $usuarioDevuelto = $this->usuarios->buscarUsuario($devolucion['UsuarioDevolucion']);
            
            $whereFirma = array(
                "IDDevolucion"  => $idDevolucion,
                "Firma"         => "Y"
            );
            $firmaDevolucion = $this->devolucionesAdjuntos->where($whereFirma)->first();

            $devolucion['NombreRemitente'] = strtoupper($remitente['Nombres'].' '.$remitente['Apellidos']);
            $devolucion['NombreUsuario'] = $usuarioDevuelto['Nombres'];
            $devolucion['ApellidosUsuario'] = $usuarioDevuelto['Apellidos'];
            $devolucion['DocumentoUsuario'] = $usuarioDevuelto['NumeroDoc'];
            $devolucion['GerenciaUsuario'] = $usuarioDevuelto['Direccion'];
            $devolucion['AreaUsuario'] = $usuarioDevuelto['Area'];
            $devolucion['CargoUsuario'] = $usuarioDevuelto['Cargo'];
            $devolucion['MatriculaUsuario'] = $usuarioDevuelto['Matricula'];
            $devolucion['FechaDevolucion'] = "Lima, ".date('d', strtotime($devolucion['FechaCrea']))." de ".$this->complementos->parseoMes(date('m', strtotime($devolucion['FechaCrea'])))." de ".date('Y', strtotime($devolucion['FechaCrea']));

			$detalleDevolucion = $this->devolucionesDetalle->listarDetalleDevolucion($idDevolucion);
            
            foreach($detalleDevolucion as $key=>$value)
            {
                $elemento = $this->devolverInformacionElemento($value['TipoElemento'], $value['IDElemento']);
                
                $detalleDevolucion[$key]['TIPO'] = $value['TipoElemento'];
                $detalleDevolucion[$key]['TipoElemento'] = $elemento['TIPO'];
                $detalleDevolucion[$key]['Elemento'] = $elemento['Marca'].' '.$elemento['Modelo'].' '.$elemento['Serie'];
            }

            $situacionMovil = $this->globales->motivoEstadoMovil('');

			$data = array (
				'session'               => 'on',
				'titulo'                => 'Devoluciones | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Acta de Devolución',
                'previo'                => 'listar-devoluciones',
                'idDevolucion'          => $idDevolucion,
				'devolucion'            => $devolucion,
                'detalle'               => $detalleDevolucion,
                'situacionMovil'        => $situacionMovil,
                'firmaDevolucion'       => $firmaDevolucion
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/devoluciones/documento_devolucion',$data);			
		} else {
			return view('errors/500');
		}
    }
    
    public function enviarCorreoDevolucion()
    {
        $fechaActual = date("Y-m-d H:i:s");

        $idDevolucion = $this->request->getPost('idDevolucion');
        $devolucion = $this->devoluciones->where("IDDevolucion", $idDevolucion)->first();
        $usuarioDevolucion = $this->usuarios->buscarUsuario($devolucion['UsuarioDevolucion']);
        
		/*
        * ----------------------------
        * PREPARACIÓN DE CUERPO DE CORREO
        * ----------------------------
		*/

        $arrayCuerpo = array(
            "TITULO" => "ACTA DE DEVOLUCIÓN",
            "ACTA" => "ACTA DE DEVOLUCIÓN",
            "USUARIO" => ucwords(mb_strtolower($usuarioDevolucion['Nombres'].' '.$usuarioDevolucion['Apellidos'])),
            "URL_ACTA" => base_url()."/acta-devolucion/".$idDevolucion."/".$devolucion['TokenLinkFirma']
        );

        $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActas($arrayCuerpo);
		/*
        * ----------------------------
        * PREPARACIÓN DE PARAMETROS PARA EL CORREO
        * ----------------------------
		*/

        $asunto='ACTA DE DEVOLUCIÓN: '.$idDevolucion.' - '.$usuarioDevolucion['Nombres'].' '.$usuarioDevolucion['Apellidos'];
        //$correoDestino = array($asignado['Correo']);
        $configCorreo = array(
            "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
            "CORREO_ORIGEN" => $this->items['correoElectronico'],
            "CORREOS_DESTINOS" => array($this->items['correoElectronico']),
            "CORREOS_COPIA" => array("soporteit@verisure.pe"),
            "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe"),
            "ASUNTO" => $asunto,
            "MENSAJE" => $cuerpo
        );

        $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);

        $dataCorreo = array(
            "IDDevolucion"  => $idDevolucion,
            "Response"      => $estadoCorreo['RESPUESTA'],
            "Error"         => $estadoCorreo['ERROR'],
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $this->correoStatusDevolucion->insert($dataCorreo, TRUE);

        if($estadoCorreo['ERROR'] != '')
        {
            $message = sprintf($this->mensajeError->msg201, "No se pudo enviar el correo. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "Se envió el correo correctamente.");
            echo $this->alertas->alertaExito($message);
        }
        
    }
    
    public function actaDevolucion($idDevolucion, $token)
    {
        $devolucion = $this->devoluciones->where("IDDevolucion", $idDevolucion)->first();

        $whereFirma = array(
            "IDDevolucion"  => $idDevolucion,
            "Firma"         => "Y"
        );
        $firmaDevolucion = $this->devolucionesAdjuntos->where($whereFirma)->first();

        if($token == $devolucion['TokenLinkFirma'])
        {
			/* ACCIONES */

            $remitente = $this->usuarios->where("IdUsuario ", $devolucion['UsuarioCrea'])->first();
            $usuarioDevuelto = $this->usuarios->buscarUsuario($devolucion['UsuarioDevolucion']);
            
            $depaDevuelto = $this->estructuraDirecciones->where("IDDireccion", $devolucion['DireccionDevolucion'])->first();
            $areaDevuelto = $this->estructuraAreas->where("IDArea", $devolucion['AreaDevolucion'])->first();

            $devolucion['NombreRemitente'] = strtoupper($remitente['Nombres'].' '.$remitente['Apellidos']);
            $devolucion['NombreUsuario'] = $usuarioDevuelto['Nombres'];
            $devolucion['ApellidosUsuario'] = $usuarioDevuelto['Apellidos'];
            $devolucion['DocumentoUsuario'] = $usuarioDevuelto['NumeroDoc'];
            $devolucion['GerenciaUsuario'] = $depaDevuelto['Direccion'];
            $devolucion['AreaUsuario'] = $areaDevuelto['Area'];
            $devolucion['CargoUsuario'] = $devolucion['CargoDevolucion'];
            $devolucion['MatriculaUsuario'] = $usuarioDevuelto['Matricula'];
            $devolucion['FechaDevolucion'] = "Lima, ".date('d', strtotime($devolucion['FechaCrea']))." de ".$this->complementos->parseoMes(date('m', strtotime($devolucion['FechaCrea'])))." de ".date('Y', strtotime($devolucion['FechaCrea']));

			$detalleDevolucion = $this->devolucionesDetalle->listarDetalleDevolucion($idDevolucion);
            
            foreach($detalleDevolucion as $key=>$value)
            {
                $elemento = $this->devolverInformacionElemento($value['TipoElemento'], $value['IDElemento']);
                
                $detalleDevolucion[$key]['TIPO'] = $value['TipoElemento'];
                $detalleDevolucion[$key]['TipoElemento'] = $elemento['TIPO'];
                $detalleDevolucion[$key]['Elemento'] = $elemento['Marca'].' '.$elemento['Modelo'].' '.$elemento['Serie'];
            }

            $situacionMovil = $this->globales->motivoEstadoMovil('');

			$data = array (
				'titulo'                => 'Devoluciones | Verisure',
                'idDevolucion'          => $idDevolucion,
				'devolucion'            => $devolucion,
                'detalle'               => $detalleDevolucion,
                'situacionMovil'        => $situacionMovil,
                'firmaDevolucion'       => $firmaDevolucion
			);
            
			$data = array_merge($data, $this->items);
			return view('veriactivos/devoluciones/acta_devolucion',$data);	
        }
        else
        {
            return view('errors/500');
        }
    }

    public function detalleActaDevolucion($idDevolucion)
    {
        if(isset($this->items['id'])){

			/* ACCIONES */
            $devolucion = $this->devoluciones->where("IDDevolucion",$idDevolucion)->first();
            $listaDetalle = $this->devolucionesDetalle->listarDetalleDevolucion($idDevolucion);
            $listaAdjunto = $this->devolucionesAdjuntos->where("IDDevolucion", $idDevolucion)->findAll();    

            foreach($listaDetalle as $key=>$value)
            {
                $elemento = $this->devolverInformacionElemento($value['TipoElemento'], $value['IDElemento']);
                
                $listaDetalle[$key]['TIPO'] = $value['TipoElemento'];
                $listaDetalle[$key]['TipoElemento'] = $elemento['TIPO'];
                $listaDetalle[$key]['Elemento'] = $elemento['Marca'].' '.$elemento['Modelo'].' '.$elemento['Serie'];
                
            }

            $situacionMovil = $this->globales->motivoEstadoMovil('');

			$data = array (
				'session'               => 'on',
				'titulo'                => 'Detalle de Devolución | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Detalle de Devolución | '.$idDevolucion,
                'previo'                => 'listar-devoluciones',
				'listaDetalle'          => $listaDetalle,
                'situacionMovil'        => $situacionMovil,
                'idDevolucion'          => $idDevolucion,
                'listaAdjunto'          => $listaAdjunto
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/devoluciones/listar_detalle_devolucion',$data);			
		} else {
			return view('errors/500');
		}
    }

    public function subirFirmaActaDevolucion()
    {
        $fechaActual = date("Y-m-d H:i:s");

        $idDevolucion = $this->request->getPost("txtIDDevolucion");
        $canvasFirma = $this->request->getPost("firmaActaDevolucion");
        
        $adjunto = $this->request->getFile("fileFotoDNI");
        
        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $adjunto->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $adjunto->getErrorString().'-'.$adjunto->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'fileFotoDNI' => [
                'mime_in[fileFotoDNI,image/png,image/jpg,image/jpeg,image/gif,application/pdf]',
                'ext_in[fileFotoDNI,png,jpg,jpeg,gif,pdf]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        if($adjunto->guessExtension() != null)
        {
            $extensionDoc = $adjunto->guessExtension();
        }
        else
        {
            $nombre_original = $adjunto->getBasename();
            $fileNameCmps = explode(".", $nombre_original);
            $extensionDoc = strtolower(end($fileNameCmps));
        }

        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */

        $devolucion = $this->devoluciones->where("IDDevolucion", $idDevolucion)->first();

        $data = array (
            'IDDevolucion'      => $idDevolucion, 
            'Nombre'            => "DOCUMENTO DE IDENTIDAD", 
            'Extension'         => $extensionDoc,
            'Observacion'       => "DOCUMENTO DE IDENTIDAD ADJUNTADO EN LA FIRMA.",
            'ReemplazoFirma'    => 'N',  
            'UsuarioCrea'       => $devolucion['UsuarioDevolucion'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->devolucionesAdjuntos->insert($data, TRUE);

		if($lastId === FALSE){
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
			exit;
		}

        /*
        * ----------------------------
        * GUARDAR ARCHIVO ADJUNTO
        * ----------------------------
        */
        $ruta = "public/docs/ActaDevolucion/";
        $nombreArchivo = $idDevolucion."-".$lastId;

        if(!file_exists($ruta))
        {
            @mkdir($ruta, 0777, true);
        }

		# si exsite la carpeta o se ha creado
		if (file_exists($ruta) || @mkdir($ruta)) 
        {
            $nuevonombre = $nombreArchivo.'.'.$extensionDoc;
            
            $estadoMove = $adjunto->move($ruta, $nuevonombre);
            
            if (!$estadoMove) {
                $this->devolucionesAdjuntos->delete(["IDAdjuntoDevolucion", $lastId]);
                $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[SAVEDOC]");
                echo $this->alertas->alertaError($message);
                exit;
            }
        }
        else
        {
            $this->devolucionesAdjuntos->delete(["IDAdjuntoDevolucion", $lastId]);
            $message = sprintf($this->mensajeError->msg201, "No existe ruta. Inténtelo luego.[SAVEDOC]");
            echo $this->alertas->alertaError($message);
        }
        
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */

        $dataFirma = array (
            'IDDevolucion'      => $idDevolucion, 
            'Nombre'            => "FIRMA", 
            'Extension'         => "png",
            'Observacion'       => "FIRMA DE USUARIO QUE DEVUELVE DISPOSITIVOS.",
            'ReemplazoFirma'    => 'N',  
            'Firma'             => 'Y',  
            'UsuarioCrea'       => $devolucion['UsuarioDevolucion'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastIdFirma = $this->devolucionesAdjuntos->insert($dataFirma, TRUE);

		if($lastIdFirma === FALSE){
            unlink($ruta.$nombreArchivo.'.'.$extensionDoc);
            $this->devolucionesAdjuntos->delete(["IDAdjuntoDevolucion", $lastId]);
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la firma. Inténtelo luego.[INSERT]-".$lastIdFirma."-");
			echo $this->alertas->alertaError($message);
			exit;
		}

        /*
        * ----------------------------
        * GUARDAR FIRMA
        * ----------------------------
        */

        $nombreArchivoFirma = $idDevolucion."-".$lastIdFirma;

        if(!file_exists($ruta))
        {
            @mkdir($ruta, 0777, true);
        }

		# si exsite la carpeta o se ha creado
		if (file_exists($ruta) || @mkdir($ruta)) 
        {
            $nuevonombreFirma = $nombreArchivoFirma.'.png';
            
            $datos = base64_decode(
                preg_replace('/^[^,]*,/', '', $canvasFirma)
            );

            $estadoFirma = file_put_contents($ruta.$nuevonombreFirma, $datos);
            
            if ($estadoFirma===FALSE) {
                unlink($ruta.$nombreArchivo.'.'.$extensionDoc);
                $this->devolucionesAdjuntos->delete(["IDAdjuntoDevolucion", $lastId]);
                $this->devolucionesAdjuntos->delete(["IDAdjuntoDevolucion", $lastIdFirma]);
                $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la firma. Inténtelo luego.[SAVEDOC]-");
                echo $this->alertas->alertaError($message);
                exit;
            }
        }
        else
        {
            unlink($ruta.$nombreArchivo.'.'.$extensionDoc);
            $this->devolucionesAdjuntos->delete(["IDAdjuntoDevolucion", $lastId]);
            $this->devolucionesAdjuntos->delete(["IDAdjuntoDevolucion", $lastIdFirma]);
            $message = sprintf($this->mensajeError->msg201, "No existe ruta. Inténtelo luego.[SAVEDOC]");
            echo $this->alertas->alertaError($message);
        }

        /*
        * ----------------------------
        * PREPARACIÓN DE CUERPO DE CORREO
        * ----------------------------
        */
        
        $usuarioRemitente = $this->usuarios->where("IdUsuario", $devolucion['UsuarioCrea'])->first();
        
        $usuarioDevolucion = $this->usuarios->where("IdUsuario", $devolucion['UsuarioDevolucion'])->first();
        
        $arrayCuerpo = array(
            "TITULO" => "FIRMA DE ACTA DE DEVOLUCIÓN",
            "ACTA" => "ACTA DE DEVOLUCIÓN",
            "USUARIO" => ucwords(mb_strtolower($usuarioRemitente['Nombres'].' '.$usuarioRemitente['Apellidos'])),
            "CODIGO" => $idDevolucion
        );

        $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActasConfirmacion($arrayCuerpo);
        
        /*
        * ----------------------------
        * PREPARACIÓN DE PARAMETROS PARA EL CORREO
        * ----------------------------
        */

        $asunto='FIRMA DE ACTA DE DEVOLUCIÓN: '.$idDevolucion.' - '.$usuarioDevolucion['Nombres'].' '.$usuarioDevolucion['Apellidos'];
        //$correoDestino = array($asignado['Correo']);
        $configCorreo = array(
            "NOMBRE_ORIGEN" => $usuarioDevolucion['Nombres'].' '.$usuarioDevolucion['Apellidos'],
            "CORREO_ORIGEN" => $usuarioDevolucion['Correo'],
            "CORREOS_DESTINOS" => array($usuarioRemitente['Correo']),
            "CORREOS_COPIA" => array("soporteit@verisure.pe"),
            "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe"),
            "ASUNTO" => $asunto,
            "MENSAJE" => $cuerpo
        );

        $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);

        $dataCorreo = array(
            "IDDevolucion"  => $idDevolucion,
            "Response"      => $estadoCorreo['RESPUESTA'],
            "Error"         => $estadoCorreo['ERROR'],
            'UsuarioCrea'   => $devolucion['UsuarioDevolucion'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $this->correoStatusDevolucion->insert($dataCorreo, TRUE);

        $message = sprintf($this->mensajeError->msg201, "La firma fue registrada exitosamente.");
        echo $this->alertas->alertaExito($message);
        echo $this->alertas->refrescar(1);
    }

    public function adjuntarDocumentoDevolucion($idDevolucion)
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $nombre = $this->request->getPost('txtNombreAdjunto_i');
        $observacion = $this->request->getPost('txtObservacionAdjunto_i');
        $reemplazafirma = $this->request->getPost('chkAdjuntoFirma');
        $adjunto = $this->request->getFile("fileAdjuntoDevolucion");

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($nombre, 'required|trim|minlength[9]|maxlength[50]', 'Nombre');
        $error .= $this->complementos->validaCampo($observacion, 'trim', 'Observación');
        

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $adjunto->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $adjunto->getErrorString().'-'.$adjunto->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'fileAdjuntoDevolucion' => [
                'mime_in[fileAdjuntoDevolucion,image/png,image/jpg,image/jpeg,image/gif,application/pdf]',
                'ext_in[fileAdjuntoDevolucion,pdf]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        if($adjunto->guessExtension() != null)
        {
            $extensionDoc = $adjunto->guessExtension();
        }
        else
        {
            $nombre_original = $adjunto->getBasename();
            $fileNameCmps = explode(".", $nombre_original);
            $extensionDoc = strtolower(end($fileNameCmps));
        }
        
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */

        $data = array (
            'IDDevolucion'      => $idDevolucion, 
            'Nombre'            => $nombre, 
            'Extension'         => $extensionDoc,
            'Observacion'       => $observacion,
            'ReemplazoFirma'    => ((isset($reemplazafirma) && $reemplazafirma != null) ? 'Y' : 'N'),  
            'UsuarioCrea'       => $this->items['id'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->devolucionesAdjuntos->insert($data, TRUE);

		if($lastId === FALSE){
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
			exit;
		}

        /*
        * ----------------------------
        * GUARDAR ARCHIVO ADJUNTO
        * ----------------------------
        */
        $ruta = "public/docs/ActaDevolucion/";
        $nombreArchivo = $idDevolucion."-".$lastId;

        if(!file_exists($ruta))
        {
            @mkdir($ruta, 0777, true);
        }

		# si exsite la carpeta o se ha creado
		if (file_exists($ruta) || @mkdir($ruta)) 
        {
            $nuevonombre = $nombreArchivo.'.'.$extensionDoc;
            
            $estadoMove = $adjunto->move($ruta, $nuevonombre);
            
            if (!$estadoMove) {
                $this->devolucionesAdjuntos->delete(["IDAdjuntoDevolucion", $lastId]);
                $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[SAVEDOC]");
                echo $this->alertas->alertaError($message);
                exit;
            }
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "No existe ruta. Inténtelo luego.[SAVEDOC]");
            echo $this->alertas->alertaError($message);
        }
        
        $message = sprintf($this->mensajeError->msg201, "El archivo adjunto fue registrado exitosamente.");
        echo $this->alertas->alertaExito($message);
        echo $this->alertas->refrescar(1);
    }
    
	/**************************************************************************/
	
	/********************** DESCUENTOS MENSUALES ******************************/
	
    public function listarDescuentosMensual()
    {
        if(isset($this->items['id'])){

			/* ACCIONES */
            
            $listadoMensual = $this->reposicionesDetalle->listarDescuentosMes(date("m"), date("Y"));
            
            foreach($listadoMensual as $key=>$item)
            {
                $usuario = $this->usuarios->where("IdUsuario ", $item['UsuarioAdjudicado'])->first();
                $listadoMensual[$key]['NombreUsuario'] = $usuario['Nombres'].' '.$usuario['Apellidos'];
                $listadoMensual[$key]['MatriculaUsuario'] = $usuario['Matricula'];
                $listadoMensual[$key]['Periodo'] = $this->complementos->parseoMes(date("m"), FALSE).' '.date("Y");
                
                $elemento = $this->devolverInformacionElemento($item['TipoElemento'], $item['IDElemento']);
                
                $listadoMensual[$key]['Elemento'] = $elemento['TIPO'].' '.$elemento['Marca'].' '.$elemento['Modelo'];
            }
            
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Descuentos por Reposición | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Descuentos del mes',
				'subtitulo'             => 'Descuentos '.$this->complementos->parseoMes(date("m"), FALSE).' '.date("Y"),
				'listadoMensual'        => $listadoMensual
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/reposiciones/listar_descuentos_mensual',$data);
		} else {
			return view('errors/500');
		}
    }
    
    public function recargarTablaDescuentoMensual()
    {
        $resultado['data'] = array();
        
        $listadoMensual = $this->reposicionesDetalle->listarDescuentosMes($this->request->getPost("mes"), $this->request->getPost("anio"));
        
        foreach($listadoMensual as $key=>$item)
        {
            $usuario = $this->usuarios->where("IdUsuario ", $item['UsuarioAdjudicado'])->first();
            $elemento = $this->devolverInformacionElemento($item['TipoElemento'], $item['IDElemento']);
                
            
            $resultado['data'][$key] = array(
				'matricula' => (string) $usuario['Matricula'],
				'usuario' => (string) $usuario['Nombres'].' '.$usuario['Apellidos'],
                'periodo' => $this->complementos->parseoMes($this->request->getPost("mes"), FALSE).' '.$this->request->getPost("anio"),
				'elemento' => (string) $elemento['TIPO'].' '.$elemento['Marca'].' '.$elemento['Modelo'],
				'monto_descuento' => (string) $item['TotalTrabajador'],
				'cuotas' => (string) $item['TotalCuotas'],
				'cobrado' => (string) $item['Cobrado'],
				'monto_cobrado' => (string) $item['MontoCobro'],
				'fecha_cobro' => (string) ($item['FechaCobro'] != '' && $item['FechaCobro'] != null ? date("d-m-Y", strtotime($item['FechaCobro'])) : ''),
				'observacion_cobro' => (string) $item['ObservacionCobro']
			);
        }
        
        $resultado['subtitulo'] = 'Descuentos '.$this->complementos->parseoMes($this->request->getPost("mes"), FALSE).' '.$this->request->getPost("anio");
		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado, JSON_NUMERIC_CHECK);		
    }
    
    public function exportarDescuentoMensual($mes, $anio)
    {
        $listadoMensual = $this->reposicionesDetalle->obtenerDescuentosPendientesMes($mes, $anio);
        
        $filename = "Descuentos por reposición ".$mes." - ".$anio.".csv";
        $writer = WriterEntityFactory::createCSVWriter();
        $writer->setFieldDelimiter(';');
        $writer->openToBrowser($filename);
        
        $cells = [
            WriterEntityFactory::createCell("Código"),
            WriterEntityFactory::createCell("Matrícula"),
            WriterEntityFactory::createCell("Usuario"),
            WriterEntityFactory::createCell("Periodo"),
            WriterEntityFactory::createCell("Elemento"),
            WriterEntityFactory::createCell("Monto Descuento"),
            WriterEntityFactory::createCell("Cuotas"),
            WriterEntityFactory::createCell("Monto Cobrado"),
            WriterEntityFactory::createCell("Fecha Cobro"),
            WriterEntityFactory::createCell("Observación Cobro")
        ];
        
        /** add a row at a time */
        $singleRow = WriterEntityFactory::createRow($cells);
        $writer->addRow($singleRow);
        
        foreach($listadoMensual as $key=>$item)
        {
            $usuario = $this->usuarios->where("IdUsuario ", $item['UsuarioAdjudicado'])->first();
            $elemento = $this->devolverInformacionElemento($item['TipoElemento'], $item['IDElemento']);
            
            $periodo = (string) $this->complementos->parseoMes($mes, FALSE).' | '.$anio;
			$cells = [
                WriterEntityFactory::createCell($item['IDDetalleReposicion']),
                WriterEntityFactory::createCell($usuario['Matricula']),
                WriterEntityFactory::createCell($usuario['Nombres'].' '.$usuario['Apellidos']),
                WriterEntityFactory::createCell($periodo),
                WriterEntityFactory::createCell($elemento['TIPO'].' '.$elemento['Marca'].' '.$elemento['Modelo']),
                WriterEntityFactory::createCell($item['TotalTrabajador']),
                WriterEntityFactory::createCell($item['TotalCuotas']),
                WriterEntityFactory::createCell(""),
                WriterEntityFactory::createCell(""),
                WriterEntityFactory::createCell("")
            ];
            
            /** add a row at a time */
            $singleRow = WriterEntityFactory::createRow($cells);
            $writer->addRow($singleRow);

        }
        
        $writer->close();
    }

    public function importarDescuentosMensual()
    {
        $fechaActual = date("Y-m-d H:i:s");
        $fechaActualAdd = date("Y-m-d H:i:s", strtotime($fechaActual)+1);
        
        /*
        * ----------------------------
        * DECLARAR Y ASIGNAR VARIABLE A ARCHIVO OBTENIDO
        * ----------------------------
        */
        
        $csv = $this->request->getFile("file");

        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $csv->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $csv->getErrorString().'-'.$csv->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'file' => [
                'mime_in[file,text/csv,text/plain]',
                'ext_in[file,csv]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        /*
        * ----------------------------
        * VALIDAR SEPARADOR CSV
        * ----------------------------
        */
        
        $separadorCSV = $this->complementos->validarSeparadorCSV($csv, 10);
        
        if (!$separadorCSV) {
            $message = sprintf($this->mensajeError->msg201, "No se encontró separador de CSV autorizado. Debe usar coma (,) o punto y coma (;) y eliminar celdas vacías a la derecha de la última columna.");
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y VALIDAR DATOS CORRECTOS
        * ----------------------------
        */
        
        //Declaramos variables
        $fila = 0;
        $filasError = array();
        $arrayElementos = array();
        $ejecutarInsert = true;
        //Abrimos el archivo
        $handle = fopen($csv, "r");

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handle, 0, $separadorCSV)) !== FALSE)
        {
            $fila++;

            if($fila>1)
            {
                $data = array_map("utf8_encode", $data);
                //Asignamos valores de CSV a variables locales
                $id = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $montoCobrado = trim($data[7]," \t\n\r\0\x0B\xc2\xa0");
                $fechaCobro = trim($data[8]," \t\n\r\0\x0B\xc2\xa0");
                
                if($id == '' || $id == null)
                {
                    $filasError[$fila]['CÓDIGO'] = "EL CÓDIGO SE ENCUENTRA VACÍO.";
                    $ejecutarInsert = false;
                }
                
                $detectaFormatoFC = strpos($fechaCobro, "/");
                    
                if($detectaFormatoFC === false)
                {
                    if(strtotime($fechaCobro)=='' || strtotime($fechaCobro)==0 || strtotime($fechaCobro) == false)
                    {
                        $filasError[$fila]['FECHA COBRO'] = "LA FECHA NO CUENTA CON EL FORMATO ADECUADO (YYYY-MM-DD).";
                        $ejecutarInsert = false;
                    }
                }
                else
                {
                    try {
                        $fechaCobro = date_create_from_format('j/m/Y', $fechaCobro);
                        $fechaCobro = date_format($fechaCobro, 'Y-m-d');
                    } catch (Exception $e) {
                        $filasError[$fila]['FECHA COBRO'] = "LA FECHA NO CUENTA CON EL FORMATO ADECUADO (DD/MM/YYYY).";
                        $ejecutarInsert = false;
                    }
                }
                
                // $fechaEvaluar = explode("-", $fechaCobro);
                
                // if(count($fechaEvaluar) > 1)
                // {
                //     if(strtotime($fechaCobro)=='' || strtotime($fechaCobro)==0 || strtotime($fechaCobro) == false)
                //     {
                //         $filasError[$fila]['FECHA COBRO'] = "LA FECHA NO CUENTA CON EL FORMATO ADECUADO (YYYY-MM-DD).";
                //         $ejecutarInsert = false;
                //     }
                // }
                // else
                // {
                //     try {
                //         $fechaCobroVal = date_create_from_format('j/m/Y', $fechaCobro);
                //         $fechaCobroVal = date_format($fechaCobroVal, 'Y-m-j');
                //     } catch (Exception $e) {
                //         $filasError[$fila]['FECHA COBRO'] = "LA FECHA NO CUENTA CON EL FORMATO ADECUADO (DD/MM/YYYY).";
                //         $ejecutarInsert = false;
                //     }
                // }
                
                if(!is_numeric($montoCobrado) && $montoCobrado != null && $montoCobrado != '')
                {
                    $filasError[$fila]['MONTO COBRADO'] = "EL MONTO INGRESADO NO ES UN NÚMERO.";
                    $ejecutarInsert = false;
                }
                else if($montoCobrado != null && $montoCobrado != '')
                {
                    if(strtotime($fechaCobro) == '')
                    {
                        $detectaFormatoFC = strpos($fechaCobro, "/");
                    
                        if($detectaFormatoFC === false)
                        {
                            if(strtotime($fechaCobro)=='' || strtotime($fechaCobro)==0 || strtotime($fechaCobro) == false)
                            {
                                $filasError[$fila]['FECHA COBRO'] = "LA FECHA NO CUENTA CON EL FORMATO ADECUADO (YYYY-MM-DD).";
                                $ejecutarInsert = false;
                            }
                        }
                        else
                        {
                            try {
                                $fechaCobro = date_create_from_format('j/m/Y', $fechaCobro);
                                $fechaCobro = date_format($fechaCobro, 'Y-m-d');
                            } catch (Exception $e) {
                                $filasError[$fila]['FECHA COBRO'] = "LA FECHA NO CUENTA CON EL FORMATO ADECUADO (DD/MM/YYYY).";
                                $ejecutarInsert = false;
                            }
                        }
                    }
                }
                
            }
        }

        fclose($handle);

        if(!$ejecutarInsert)
        {
            $raiz = 'public/';
            $nombre = 'error.txt';
            $file = 'public/error.txt';
            
            if (file_exists($file)) {
                unlink($file);
            }
            
            $txt= fopen($file, 'a') or die ('Problemas al crear el archivo');
            #  Se establecen los datos que va a conterner el archivo
            foreach($filasError as $key=>$value)
            {
                fwrite($txt, "FILA: ".$key."\n");
                foreach($value as $celda=>$error)
                {
                    fwrite($txt, $celda.": ".$error."\n");
                }
            }
            #  Se hace el ciere para no sobre escribir datos 
            fclose($txt);

            $message = sprintf($this->mensajeError->msg201, "Se detectaron diversas inconsistencias.");
            $salida1 = $this->alertas->alertaError($message);
            $salida2 = $this->alertas->descargaArchivoTXT($nombre);
			echo $salida1.$salida2;
			//echo $salida1;
            
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y EJECUTAR INSERTS
        * ----------------------------
        */
            
        //Declaramos variables
        $arrayUpdateDescuento = [];
        
        $filainsert = 0;
        //Abrimos el archivo
        $handleInsert = fopen($csv, "r");
        
        //Recorremos las filas del CSV
        while (($data = fgetcsv($handleInsert, 0, $separadorCSV)) !== FALSE)
        {
            $data = array_map("utf8_encode", $data);
            $filainsert++;
            if($filainsert > 1)
            {
                //Asignamos valores de CSV a variables locales
                $idDetalle = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $montoCobrado = trim($data[7]," \t\n\r\0\x0B\xc2\xa0");
                $fechaCobro = trim($data[8]," \t\n\r\0\x0B\xc2\xa0");
                $observacionCobro = trim($data[9]," \t\n\r\0\x0B\xc2\xa0");
                
                
                $detectaFormatoFC = strpos($fechaCobro, "/");
                    
                if($detectaFormatoFC === false)
                {
                    $fechaCobro = date("Y-m-d", strtotime($fechaCobro));
                }
                else
                {
                    $fechaCobro = date_create_from_format('j/m/Y', $fechaCobro);
                    $fechaCobro = date_format($fechaCobro, 'Y-m-d');
                }
                
                // $fechaEvaluar = explode("-", $fechaCobro);
                
                // if(count($fechaEvaluar) > 1)
                // {
                //     $fechaCobro = date("Y-m-d", strtotime($fechaCobro));
                // }
                // else
                // {
                //     $fechaCobro = date_create_from_format('j/m/Y', $fechaCobro);
                //     $fechaCobro = date_format($fechaCobro, 'Y-m-j');
                // }
                
                if($montoCobrado != ''  && $montoCobrado != null)
                {
                    $arrayUpdateDescuento[] = array(
                        "IDDetalleReposicion"   => $idDetalle,
                        "Cobrado"               => "Y",
                        "FechaCobro"            => $fechaCobro,
                        "MontoCobro"            => $montoCobrado,
                        "ObservacionCobro"      => $observacionCobro,
                        "UsuarioModifica"       => $this->items['id'],
                        'FechaModifica'         => $fechaActual,    
                        'Localhost'             => $this->request->getIPAddress());
                }
                
            }
        }

        fclose($handleInsert);
        
        $lastId = $this->reposicionesDetalle->updateBatch($arrayUpdateDescuento, 'IDDetalleReposicion');

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg201, "Cobros registrados correctamente.");
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
        
    }

	/**************************************************************************/
	
}