<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>

<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
                                <li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                   <div class="row">
                      <div class="col-xl-3">
                         <div class="card card-h-100">
                            <div class="card-body overflow-auto" style="max-height: 300px;">
                               <h5 class="mb-1">Tus Eventos</h5>
                               <div id="external-events">
                                  <?//= $htmlHorarios; ?>
                               </div>
                            </div>
                         </div>
                         <div class="card">
                            <div class="card-body bg-info-subtle">
                               <div class="d-flex">
                                  <div class="flex-shrink-0">
                                     <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-calendar text-info icon-dual-info">
                                        <rect x="3" y="4" width="18" height="18" rx="2" ry="2"></rect>
                                        <line x1="16" y1="2" x2="16" y2="6"></line>
                                        <line x1="8" y1="2" x2="8" y2="6"></line>
                                        <line x1="3" y1="10" x2="21" y2="10"></line>
                                     </svg>
                                  </div>
                                  <div class="flex-grow-1 ms-3">
                                     <h6 class="fs-15">¡Bienvenido a tu Calendario!</h6>
                                     <p class="text-muted mb-0">Aquí puedes ver tus horarios de trabajo y registrar tu hora de inicio y finalización.</p>
                                  </div>
                               </div>
                            </div>
                         </div>
                      </div>
                      <div class="col-xl-9">
                         <div class="card card-h-100">
                            <div class="card-body">
                                
                                <div id="calendar"></div>
                                
                                <!--<div class="card card-h-100 text-center shadow-lg mt-5 p-4">-->
                                <!--    <h2>Control de Asistencia</h2>-->
                                <!--     Reloj Digital -->
                                <!--    <div id="clock" class="mb-3">00:00:00</div>-->
                                <!--     Botones de Entrada/Salida -->
                                <!--    <div id="actions">-->
                                <!--        <button id="btn-start" class="btn btn-success btn-lg w-100 mb-3">Marcar Entrada</button>-->
                                <!--        <button id="btn-end" class="btn btn-danger btn-lg w-100 d-none">Marcar Salida</button>-->
                                <!--    </div>-->
                                <!--</div>-->
                                
                                <!-- Historial del Día -->
                                <!--<div class="history card mt-4 shadow-lg p-3">-->
                                <!--    <h4>Historial de Asistencia</h4>-->
                                <!--    <ul id="attendance-history" class="list-group list-group-flush">-->
                                <!--         Aquí se llenará dinámicamente con los registros -->
                                <!--    </ul>-->
                                <!--</div>-->



                            </div>
                         </div>
                      </div>
                   </div>
                   <div style="clear:both"></div>
                </div>
			</div>
			<br>
            <br>
            <br>
            <br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>
            <div class="floating-menu z-1">
                <div class="menu-header">
                    <span>Marcaje Web</span>
                </div>
                <div class="menu-body">
                    <!-- Reloj Digital -->
                    <div class="d-flex justify-content-center align-items-center">
                        <div class="mb-2">
                            <lord-icon src="https://cdn.lordicon.com/kbtmbyzy.json" trigger="loop" colors="primary:#405189,secondary:#02a8b5" style="width:90px;height:90px"></lord-icon>
                        </div>
                        <!--<span class="mdi mdi-clock-outline mx-2" style="font-size:xx-large"></span>-->
                        <div id="digital-clock" class="clock-display m-0 mx-2">00:00:00</div>  
                    </div>
                    
                    <!-- Botones -->
                    <div class="menu-buttons">
                        <button id="btn-start" class="btn btn-success btn-sm">Marcar Entrada</button>
                        <button id="btn-end" class="btn btn-danger btn-sm d-none">Marcar Salida</button>
                    </div>
                </div>
            </div>
            
            <!--<div class="row">-->
            <!--    <div class="card">-->
            <!--        <div class="card-body text-center">-->
            <!--            <h6 class="card-title mb-3 flex-grow-1 text-start">Time Tracking</h6>-->
            <!--            <div class="mb-2">-->
            <!--                <lord-icon src="https://cdn.lordicon.com/kbtmbyzy.json" trigger="loop" colors="primary:#405189,secondary:#02a8b5" style="width:90px;height:90px"></lord-icon>-->
            <!--            </div>-->
            <!--            <h3 class="mb-1">9 hrs 13 min</h3>-->
            <!--            <h5 class="fs-14 mb-4">Profile Page Structure</h5>-->
            <!--            <div class="hstack gap-2 justify-content-center">-->
            <!--                <button class="btn btn-danger btn-sm"><i class="ri-stop-circle-line align-bottom me-1"></i> Stop</button>-->
            <!--                <button class="btn btn-success btn-sm"><i class="ri-play-circle-line align-bottom me-1"></i> Start</button>-->
            <!--            </div>-->
            <!--        </div>-->
            <!--    </div>-->
            <!--</div>-->

			<span class="respuesta_global"></span>
		</div>
	</div>
</div>

<?= $this->section('js'); ?>
<script>
$(document).ready(function() {
    var selectedEventIdHorario = null;
    var estadoEventos = {};       
    var calendarEl = document.getElementById('calendar');
    var idUsuarioPlanificacion = <?= $idUsuarioPlanificacion ?>;
    var selectedEventId = null;
    var selectedEventTitle = null;

    var calendar = new FullCalendar.Calendar(calendarEl, {
        initialView: 'dayGridMonth',
        locale: 'es', // Cambiar idioma a español 
        editable: false, // Deshabilitar edición
        droppable: false, // Deshabilitar arrastrar eventos
        events: function(info, successCallback, failureCallback) {
            $.ajax({
                url: baseUrl + "/calendario-planificacion",
                type: 'POST',
                dataType: 'json',
                data: {
                    idUsuarioPlanificacion: idUsuarioPlanificacion,
                    start: info.startStr,
                    end: info.endStr
                },
                success: function(res) {
                    if (Array.isArray(res)) {
                        var events = [];
                        
                        // Array de colores predefinidos
                        var classes = [
                            'bg-success-subtle text-success',
                            'bg-info-subtle text-info',
                            'bg-warning-subtle text-warning',
                            'bg-danger-subtle text-danger',
                            'bg-secondary-subtle text-secondary',
                            'bg-primary-subtle text-primary'
                        ];
                        var classIndex = 0;
                    
                        res.forEach(function(evt) {
                            
                            // Asignar color aleatorio
                            var className = classes[classIndex];
                            classIndex = (classIndex + 1) % classes.length;

                            
                            events.push({
                                id: evt.id_planificacion,
                                title: evt.title,
                                start: evt.start,
                                end: evt.end,
                                // backgroundColor: color, // Forzamos el color de fondo con !important
                                // borderColor: color, // Forzamos el color del borde con !important
                                // textColor: '#ffffff', // Aseguramos que el texto sea visible con !important
                                classNames: [className],
                                extendedProps: {
                                    grupoTrabajo: evt.grupoTrabajo,
                                    jefeGrupoTrabajo: evt.jefeGrupoTrabajo,
                                    id_horario: evt.id_horario,
                                    id_planificacion : evt.id_planificacion,
                                    fechaTrabajo: evt.fechaTrabajo
                                }
                            });
                        });
                        successCallback(events);
                    } else {
                        console.error('La respuesta no es un array:', res);
                        alert('Hubo un error al cargar los eventos.');
                        failureCallback();
                    }
                    
                     // Detectar evento del día actual
                        const today = new Date().toISOString().split("T")[0]; // Formato YYYY-MM-DD
                        const eventoHoy = res.find(event => event.start.startsWith(today));
                    
                        console.log("Fecha actual:", today);
                        console.log("Evento encontrado:", eventoHoy);
                        console.log(eventoHoy.estadoAsistencia);
                        console.log(eventoHoy.id_horario);
                        selectedEventIdHorario = eventoHoy.id_horario;
                        if (eventoHoy && eventoHoy.estadoAsistencia) {
                            configurarBotones(eventoHoy.estadoAsistencia); // Configurar botones
                            
                        } else {
                            configurarBotones(null); // Si no hay evento, mostrar estado inicial
                        }
                    
                    
                        successCallback(res); // Renderizar eventos

                },
                error: function(xhr, status, error) {
                    console.error('Error:', error);
                    console.error('Detalles:', xhr.responseText);
                    alert('Hubo un error al cargar los eventos.');
                }
            });
            console.log({
            idUsuarioPlanificacion: idUsuarioPlanificacion,
            start: info.startStr,
            end: info.endStr
        });
        },
        eventDidMount: function(info) {
            // Aplicar los estilos directamente sobre el DOM del evento
            // info.el.style.backgroundColor = info.event.backgroundColor;
            // info.el.style.borderColor = info.event.borderColor;
            // info.el.style.color = info.event.textColor;
            
            // Aquí se aplican las clases de Bootstrap a los eventos
            $(info.el).addClass(info.event.classNames.join(' '));
        }
        ,
        eventClick: function(info) { 
            info.jsEvent.preventDefault();
            // console.log(info.event.extendedProps);
            // // Obtener datos del evento seleccionado
            // const estadoAsistencia = info.event.extendedProps.estadoAsistencia;
    
            // // Actualizar botones según el estado de la asistencia
            // if (estadoAsistencia === "inicio") {
            //     $("#btn-start").addClass("d-none");
            //     $("#btn-end").removeClass("d-none");
            // } else if (estadoAsistencia === "fin" || estadoAsistencia === null) {
            //     $("#btn-start").removeClass("d-none");
            //     $("#btn-end").addClass("d-none");
            // }

        }
    });
    
    
    
    // Función para configurar los botones según el estado de asistencia
    function configurarBotones(estadoAsistencia) {
        if (estadoAsistencia === "inicio") {
            $("#btn-start").addClass("d-none");
            $("#btn-end").removeClass("d-none");
        } else if (estadoAsistencia === "fin") {
            $("#btn-start").addClass("d-none");
            $("#btn-end").addClass("d-none"); // Ambas acciones completadas
        } else {
            $("#btn-start").removeClass("d-none");
            $("#btn-end").addClass("d-none");
        }
    }

    calendar.render();
    
    /*****************/
    const btnStart = $("#btn-start");
    const btnEnd = $("#btn-end");
    const timeTracker = $("#digital-clock");

    let isWorking = false; // Estado actual (entrada/salida)
    let startTime = null; // Hora de entrada
    let timerInterval = null; // Intervalo del reloj

    // Manejar Marcaje de Entrada
    btnStart.on("click", function () {
        const now = new Date();
        startTime = now; // Guardar hora de inicio

        // Registrar asistencia
        registerAttendance("inicio", now.toISOString().slice(0, 19).replace("T", " "),startTime);

        // Cambiar estado y botones
        isWorking = true;
        // toggleButtons();

        // Iniciar el conteo del reloj
        // startTimer(now);
    });

    // Manejar Marcaje de Salida
    btnEnd.on("click", function () {
        const now = new Date();

        // Detener el reloj
        stopTimer();

        // Registrar asistencia
        registerAttendance("fin", now.toISOString().slice(0, 19).replace("T", " "),now);

        // Cambiar estado y botones
        isWorking = false;
        // toggleButtons();
    });

    // Alternar botones
    function toggleButtons(type) {
        if (isWorking) {
            btnStart.addClass("d-none");
            btnEnd.removeClass("d-none");
        } else if(type == 'fin'){
            btnStart.addClass("d-none");
            btnEnd.addClass("d-none");
        }
        else {
            btnStart.removeClass("d-none");
            btnEnd.addClass("d-none");
        }
        
        
    }

    // Iniciar el temporizador
    function startTimer(startTime) {
        stopTimer(); // Asegurarse de no tener múltiples intervalos
        timerInterval = setInterval(() => {
            const now = new Date();
            const elapsed = new Date(now - startTime); // Calcular tiempo transcurrido
            const hours = String(elapsed.getUTCHours()).padStart(2, "0");
            const minutes = String(elapsed.getUTCMinutes()).padStart(2, "0");
            const seconds = String(elapsed.getUTCSeconds()).padStart(2, "0");
            timeTracker.text(`${hours}:${minutes}:${seconds}`);
        }, 1000);
    }

    // Detener el temporizador
    function stopTimer() {
        clearInterval(timerInterval);
        timerInterval = null;
    }

    // Registrar en el servidor
    function registerAttendance(type, time,tiempo) {
        $.ajax({
            url: baseUrl + "/registrar-hora-trabajo",
            type: "POST",
            data: {
                idUsuario: <?= $idUsuarioPlanificacion ?>,
                tipo: type,
                fechaHora: time,
                id_horario: selectedEventIdHorario
            },
            success: function (response) {
                console.log("Registro exitoso:", response);
                toggleButtons(type);
                if(type == "inicio"){
                    startTimer(tiempo)
                }else{
                    timeTracker.text(`00:00:00`);
                }
                
            },
            error: function () {
                alert("Hubo un error al registrar la asistencia.");
            },
        });
    }
 
    /*****************/
    // // Variables para manejar los estados
    // let isWorking = false; // Estado actual (si está trabajando o no)
    // const history = []; // Historial de registros
    // const timerDisplay = $("#clock");
    // const btnStart = $("#btn-start");
    // const btnEnd = $("#btn-end");
    // const attendanceHistory = $("#attendance-history");

    // // Actualizar el reloj cada segundo
    // function updateClock() {
    //     const now = new Date();
    //     const timeString = now.toLocaleTimeString("es-ES", { hour12: false });
    //     timerDisplay.text(timeString);
    // }
    // setInterval(updateClock, 1000);

    // // Manejar el botón de marcar entrada
    // btnStart.on("click", function () {
    //     const now = new Date();
    //     const formattedTime = now.toISOString().slice(0, 19).replace("T", " ");

    //     // Registrar en el servidor
    //     registerAttendance("inicio", formattedTime);

    //     // Cambiar botones
    //     isWorking = true;
    //     toggleButtons();

    //     // Agregar al historial
    //     history.push(`Entrada: ${formattedTime}`);
    //     updateHistory();
    // });

    // // Manejar el botón de marcar salida
    // btnEnd.on("click", function () {
    //     const now = new Date();
    //     const formattedTime = now.toISOString().slice(0, 19).replace("T", " ");

    //     // Registrar en el servidor
    //     registerAttendance("fin", formattedTime);

    //     // Cambiar botones
    //     isWorking = false;
    //     toggleButtons();

    //     // Agregar al historial
    //     history.push(`Salida: ${formattedTime}`);
    //     updateHistory();
    // });

    // // Actualizar el historial
    // function updateHistory() {
    //     attendanceHistory.empty();
    //     history.forEach((record) => {
    //         attendanceHistory.append(`<li class="list-group-item">${record}</li>`);
    //     });
    // }

    // // Cambiar entre botones de entrada y salida
    // function toggleButtons() {
    //     if (isWorking) {
    //         btnStart.addClass("d-none");
    //         btnEnd.removeClass("d-none");
    //     } else {
    //         btnStart.removeClass("d-none");
    //         btnEnd.addClass("d-none");
    //     }
    // }

    // // Registrar en el servidor
    // function registerAttendance(type, time) { console.log(selectedEventIdHorario);
    //     $.ajax({
    //         url: baseUrl + "/registrar-hora-trabajo",
    //         type: "POST",
    //         data: {
    //             idUsuario: <?= $idUsuarioPlanificacion ?>, // Variable PHP que debes pasar
    //             tipo: type,
    //             fechaHora: time,
    //             id_horario: selectedEventIdHorario
    //         },
    //         success: function (response) {
    //             $('.respuesta_global').html(response);
    //             // console.log("Registro exitoso:", response);
    //         },
    //         error: function () {
    //             alert("Hubo un error al registrar la asistencia.");
    //         },
    //     });
    // }
});


</script>
<?php $this->endSection(); ?>

<?= $this->endSection(); ?>
