<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= '' ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $breadcrumb_alias ?></h5>
                            <div>
								<a href="<?= $baseUrl.'/'.$previo ?>" class="btn px-2 py-0" style="border-radius: 45%; background-color: red;"><i class="mdi mdi-arrow-left-circle" style="font-size: 24px; color: #FFF"></i></a>
                            </div>
                        </div>
                        
                    </div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-12">
                   <div class="row">
                      <div class="col-xl-3">
                         <div class="card card-h-100">
                            <div class="card-body overflow-auto <?= $deshabilitar ?>" style="max-height: 300px;">
                               <button class="btn btn-primary w-100 d-none" id="btn-new-event"><i class="mdi mdi-plus"></i> Crear nuevo Evento</button>
                               <div id="external-events"> <!-- Listar los horarios -->
                                  <br>
                                  <p class="text-muted">Arrastra y suelta tu evento o haz clic en el calendario</p>
                                  <?= $htmlHorarios; ?>
                               </div>
                            </div>
                         </div>
                         <div>
                            <h5 class="mb-1">Tardanzas | HE | Faltas</h5> <!-- Posible plantilla para mostrar dias con tardanzas, permisos, etc -->
                            <p class="text-muted">No te pierdas los eventos programados</p>
                            <div class="pe-2 me-n1 mb-3 simplebar-scrollable-y" data-simplebar="init" style="height: 400px">
                               <div class="simplebar-wrapper" style="margin: 0px -8px 0px 0px;">
                                  <div class="simplebar-height-auto-observer-wrapper">
                                     <div class="simplebar-height-auto-observer"></div>
                                  </div>
                                  <div class="simplebar-mask">
                                     <div class="simplebar-offset" style="right: 0px; bottom: 0px;">
                                        <div class="simplebar-content-wrapper" tabindex="0" role="region" aria-label="scrollable content" style="height: 100%; overflow: hidden scroll;">
                                           <div class="simplebar-content" style="padding: 0px 8px 0px 0px;">
                                              <div id="upcoming-event-list-asistencia">
                                                    <?php foreach ($dataMetricas as $metrica): ?>
                                                    <?php 
                                                    // Verificar si el día tiene tardanza, horas extras o faltas
                                                    $tieneIncidencia = $metrica['tardanza'] !== "00:00:00" || $metrica['horas_extras'] !== "00:00:00" || $metrica['total_faltas'] > 0;
                                           
                                                    ?>
                                    
                                                    <?php if ($tieneIncidencia): ?>
                                                        <div class="card mb-3 event-card" data-fecha="<?= $metrica['FechaTrabajo'] ?>" data-idusuario="<?= $metrica['idUsuario'] ?>" data-inicio-asistencia="<?=$metrica['inicio_asistencia'] ?>" data-motivo="<?= $metrica['motivo_cambio'] ?>"  data-inicio="<?= $metrica['InicioTrabajo'] ?>">
                                                            <div class="card-body">
                                                                <div class="d-flex mb-3">
                                                                    <div class="flex-grow-1">
                                                                        <i class="mdi mdi-checkbox-blank-circle me-2 text-info"></i>
                                                                        <span class="fw-medium"><?= $metrica['FechaTrabajo'] ?></span>
                                                                    </div>
                                                                </div>
                                                                <h6 class="card-title fs-16">Horas Trabajadas: <?= $metrica['horas_trabajadas'] ?? '00:00:00' ?></h6>
                                                                <p class="text-muted mb-1">Tardanza: <?= $metrica['tardanza'] ?></p>
                                                                <p class="text-muted mb-1">Horas Extras: <?= $metrica['horas_extras'] ?></p>
                                                                <p class="text-muted mb-0">Faltas: <?= $metrica['total_faltas']  ?></p>
                                                            </div>
                                                        </div>
                                                    <?php endif; ?>
                                                <?php endforeach; ?>
                                     
                                               
                                              </div>
                                           </div>
                                        </div>
                                     </div>
                                  </div>
                                  <div class="simplebar-placeholder" style="width: 250px; height: 2531px;"></div>
                               </div>
                               <div class="simplebar-track simplebar-horizontal" style="visibility: hidden;">
                                  <div class="simplebar-scrollbar" style="width: 0px; display: none;"></div>
                               </div>
                               <div class="simplebar-track simplebar-vertical" style="visibility: visible;">
                                  <div class="simplebar-scrollbar" style="height: 63px; display: block; transform: translate3d(0px, 0px, 0px);"></div>
                               </div>
                            </div>
                         </div>
                         <div class="card">
                            <div class="card-body bg-info-subtle">
                               <div class="d-flex">
                                  <div class="flex-shrink-0">
                                     <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-calendar text-info icon-dual-info">
                                        <rect x="3" y="4" width="18" height="18" rx="2" ry="2"></rect>
                                        <line x1="16" y1="2" x2="16" y2="6"></line>
                                        <line x1="8" y1="2" x2="8" y2="6"></line>
                                        <line x1="3" y1="10" x2="21" y2="10"></line>
                                     </svg>
                                  </div>
                                  <div class="flex-grow-1 ms-3">
                                     <h6 class="fs-15">¡Bienvenido a tu Calendario!</h6>
                                     <p class="text-muted mb-0">En caso de que el libro de aplicaciones aparezca aquí. Haga clic en un evento para ver los detalles y administrar el evento de los solicitantes.</p>
                                  </div>
                               </div>
                            </div>
                         </div>
                         <!--end card-->
                      </div>
                      <!-- end col-->
                      <div class="col-xl-9">
                         <div class="card card-h-100">
                            <div class="card-body">
                                <div id="calendar"></div>
                             
                            </div>
                         </div>
                      </div>
                      
                      <!-- end col -->
                   </div>
                   <!--end row-->
                   <div style="clear:both"></div>

                </div>

			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>

</div>

                   <!-- Add New Event MODAL -->
                   <div class="modal fade" id="event-modal" tabindex="-1">
                      <div class="modal-dialog modal-dialog-centered">
                         <div class="modal-content border-0">
                            <div class="modal-header p-3 bg-info-subtle">
                               <h5 class="modal-title" id="modal-title">Evento</h5>
                               <button type="button" class="btn-close" data-bs-dismiss="modal" aria-hidden="true"></button>
                            </div>
                            <div class="modal-body p-4">
                               <form class="formulario view-event" name="event-form" action="<?=$baseUrl ?>/actualizar-planificacion-horaria" id="form-event" novalidate="" autocomplete="off" method="POST">
                                   <span class="respuesta"></span>
                                  <div class="text-end">
                                     <a href="#" class="btn btn-sm btn-soft-primary" id="edit-event-btn" data-id="edit-event" onclick="editEvent(this)" role="button">Editar</a>
                                  </div>
                                  <div class="event-details">
                                     <div class="d-flex mb-2">
                                        <div class="flex-grow-1 d-flex align-items-center">
                                           <div class="flex-shrink-0 me-3">
                                              <i class="ri-calendar-event-line text-muted fs-16"></i>
                                           </div>
                                           <div class="flex-grow-1">
                                              <h6 class="d-block fw-semibold mb-0" id="event-start-date-tag"></h6>
                                           </div>
                                        </div>
                                     </div>
                                     <div class="d-flex align-items-center mb-2">
                                        <div class="flex-shrink-0 me-3">
                                           <i class="ri-time-line text-muted fs-16"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                           <h6 class="d-block fw-semibold mb-0"><span id="event-timepicker1-tag"></span> - <span id="event-timepicker2-tag"></span></h6>
                                        </div>
                                     </div>
                                     <div class="d-flex align-items-center mb-2">
                                        <div class="flex-shrink-0 me-3">
                                           <i class="ri-bookmark-line text-muted fs-16"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                           <h6 class="d-block fw-semibold mb-0"> <span id="event-grupo-trabajo-tag"></span></h6>
                                        </div>
                                     </div>
                                     <div class="d-flex mb-3">
                                        <div class="flex-shrink-0 me-3">
                                           <i class="ri-shield-user-line text-muted fs-16"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                           <p class="d-block text-muted mb-0" id="event-jefe-grupo-trabajo-tag"></p>
                                        </div>
                                     </div>
                                  </div>
                                  <div class="row event-form">
                                     <div class="col-12">
                                        <div class="mb-3">
                                           <label for="lista_horarios" class="form-label">Horarios</label>
                                           <!--<div class="choices" data-type="select-one" tabindex="0" role="listbox" aria-haspopup="true" aria-expanded="false">-->
                                              <!--<div class="choices__inner">-->
                                                 <select class="form-select" name="lista_horarios" id="lista_horarios" required="" tabindex="-1" data-choice="active">
                                                    <option value="bg-danger-subtle" data-custom-properties=""></option>
                                                 </select>
                                                 <!--<div class="choices__list choices__list--single">-->
                                                 <!--   <div class="choices__item choices__item--selectable" data-item="" data-id="1" data-value="bg-danger-subtle" data-custom-properties="[object Object]" aria-selected="true">Danger</div>-->
                                                 <!--</div>-->
                                              <!--</div>-->
                                              <!--<div class="choices__list choices__list--dropdown" aria-expanded="false">-->
                                              <!--   <div class="choices__list" role="listbox">-->
                                              <!--      <div id="choices--event-category-item-choice-1" class="choices__item choices__item--choice is-selected choices__item--selectable is-highlighted" role="option" data-choice="" data-id="1" data-value="bg-danger-subtle" data-select-text="Press to select" data-choice-selectable="" aria-selected="true">Danger</div>-->
                                              <!--      <div id="choices--event-category-item-choice-2" class="choices__item choices__item--choice choices__item--selectable" role="option" data-choice="" data-id="2" data-value="bg-dark-subtle" data-select-text="Press to select" data-choice-selectable="">Dark</div>-->
                                              <!--      <div id="choices--event-category-item-choice-3" class="choices__item choices__item--choice choices__item--selectable" role="option" data-choice="" data-id="3" data-value="bg-info-subtle" data-select-text="Press to select" data-choice-selectable="">Info</div>-->
                                              <!--      <div id="choices--event-category-item-choice-4" class="choices__item choices__item--choice choices__item--selectable" role="option" data-choice="" data-id="4" data-value="bg-primary-subtle" data-select-text="Press to select" data-choice-selectable="">Primary</div>-->
                                              <!--      <div id="choices--event-category-item-choice-5" class="choices__item choices__item--choice choices__item--selectable" role="option" data-choice="" data-id="5" data-value="bg-success-subtle" data-select-text="Press to select" data-choice-selectable="">Success</div>-->
                                              <!--      <div id="choices--event-category-item-choice-6" class="choices__item choices__item--choice choices__item--selectable" role="option" data-choice="" data-id="6" data-value="bg-warning-subtle" data-select-text="Press to select" data-choice-selectable="">Warning</div>-->
                                              <!--   </div>-->
                                              <!--</div>-->
                                              
                                           <!--</div>-->
                                           <div class="invalid-feedback">Por favor seleccione una categoría de evento válida</div>
                                        </div>
                                     </div>
                                     <!--end col-->
                                     <div class="col-12">
                                        <div class="mb-3">
                                           <label for="codigo_horario" class="form-label">Código Horario</label>
                                           <input class="form-control" placeholder="Código Horario" type="text" name="codigo_horario" id="codigo_horario" required="" value="" disabled>
                                           <div class="invalid-feedback">Por favor proporcione un nombre de evento válido</div>
                                        </div>
                                     </div>
                                     <!--end col-->
                                     <div class="col-12">
                                        <div class="mb-3">
                                           <label for="fecha_horario">Fecha del evento</label>
                                           <div class="input-group">
                                              <input type="text" id="fecha_horario" name="fecha_horario" class="form-control flatpickr flatpickr-input" placeholder="Select date" required="" disabled>
                                              <span class="input-group-text"><i class="ri-calendar-event-line"></i></span>
                                           </div>
                                        </div>
                                     </div>
                                     <!--end col-->
                                     <div class="col-12" id="event-time">
                                        <div class="row">
                                           <div class="col-6">
                                              <div class="mb-3">
                                                 <label for="hora_inicio" class="form-label">Hora de inicio</label>
                                                 <div class="input-group">
                                                    <input id="hora_inicio" name="hora_inicio" type="text" class="form-control flatpickr flatpickr-input" placeholder="Hora de Inicio" disabled>
                                                    <span class="input-group-text"><i class="ri-time-line"></i></span>
                                                 </div>
                                              </div>
                                           </div>
                                           <div class="col-6">
                                              <div class="mb-3">
                                                 <label for="hora_finalizacion" class="form-label">Hora de finalización</label>
                                                 <div class="input-group">
                                                    <input id="hora_finalizacion" name="hora_finalizacion" type="text" class="form-control flatpickr flatpickr-input" placeholder="Hora de finalización" disabled>
                                                    <span class="input-group-text"><i class="ri-time-line"></i></span>
                                                 </div>
                                              </div>
                                           </div>
                                        </div>
                                     </div>
                                     <!--end col-->
                                     <div class="col-12">
                                        <div class="mb-3">
                                           <label for="grupo_trabajo">Grupo de Trabajo</label>
                                           <div>
                                              <input type="text" class="form-control" name="grupo_trabajo" id="grupo_trabajo" placeholder="Grupo de Trabajo" disabled>
                                           </div>
                                        </div>
                                     </div>
                                     <!--end col-->
                                     <input type="hidden" id="idUsuarioPlanificacion" name="idUsuarioPlanificacion" value="<?= $idUsuarioPlanificacion ?>">
                                     <input type="hidden" id="idUsuarioSession" name="idUsuarioSession" value="<?= $idUsuarioSession ?>">
                                     <input type="hidden" id="idPlanificacion" name="idPlanificacion" value="">
                                     <input type="hidden" id="idHorario" name="idHorario" value="">
                                     <input type="hidden" id="eventid" name="eventid" value="">
                                     <div class="col-12">
                                        <div class="mb-3">
                                           <label for="jefe_grupo_trabajo" class="form-label">Lider Grupo Trabajo</label>
                                           <div>
                                              <input type="text" class="form-control" name="jefe_grupo_trabajo" id="jefe_grupo_trabajo" placeholder="Jefe Grupo Trabajo" disabled>
                                           </div>
                                           <!--<textarea class="form-control d-none" id="event-description" placeholder="Enter a description" rows="3" spellcheck="false"></textarea>-->
                                        </div>
                                     </div>
                                     <div class="col-12">
                                        <div class="mb-3">
                                            <label for="motivo_cambio" class="form-label">Motivo</label>
                                            <textarea class="form-control" id="motivo_cambio" name="motivo_cambio" placeholder="Motivo del cambio" rows="3" spellcheck="false"></textarea>
                                        </div>
                                     </div>
                                     <!--end col-->
                                  </div>
                                  <!--end row-->
                                  <div class="hstack gap-2 justify-content-end">
                                     <button type="button" class="btn btn-soft-danger" id="btn-delete-event"><i class="ri-close-line align-bottom"></i> Borrar</button>
                                     <button type="submit" class="btn btn-success" id="btn-save-event" hidden>Guardar Cambios</button>
                                  </div>
                               </form>
                            </div>
                         </div>
                         <!-- end modal-content-->
                      </div>
                      <!-- end modal dialog-->
                   </div>
                   <!-- end modal-->
                 
                   
        <!-- Modal para editar la hora de ingreso -->
        <div class="modal fade" id="editHoraIngresoModal" tabindex="-1" aria-labelledby="editHoraIngresoLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content border-0">
                    <div class="modal-header p-3 bg-info-subtle">
                        <h5 class="modal-title" id="editHoraIngresoLabel">Modificar Hora de Ingreso</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body p-4">
                        <form class="formulario view-event" id="editHoraIngresoForm">
                            <span class="respuesta"></span>   
                            <div class="mb-3">
                                <label for="fechaTrabajo" class="form-label">Fecha</label>
                                <input type="text" class="form-control" disabled id="fechaTrabajo" readonly>
                            </div>
                            <div class="mb-3">
                                <label for="horaIngreso" class="form-label">Hora de Ingreso</label>
                                <input type="text" class="form-control flatpickr flatpickr-input" id="horaIngreso" required>
                            </div>
                            <div class="mb-3">
                                <label for="motivo_cambio_hora_inicio" class="form-label">Motivo</label>
                                <textarea class="form-control" id="motivo_cambio_hora_inicio" name="motivo_cambio_hora_inicio" placeholder="Motivo del cambio" rows="3" spellcheck="false"></textarea>
                            </div>
                            <input type="hidden" id="idUsuario" name="idUsuario">
                            <input type="hidden" id="fecha" name="fecha">
                            <input type="hidden" id="inicioAsistencia" name="inicioAsistencia">
                        </form>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="button" class="btn btn-primary" id="saveHoraIngreso">Guardar cambios</button>
                    </div>
                </div>
            </div>
        </div>
                   
                   
<?= $this->section('js'); ?>
    <script>
        $(document).ready(function() {
   
            var calendarEl = document.getElementById('calendar');
            var idUsuarioPlanificacion = <?= $idUsuarioPlanificacion ?>;
        
            var calendar = new FullCalendar.Calendar(calendarEl, {
                initialView: 'dayGridMonth',
                locale: 'es', // Cambiar idioma a español
                editable: true,
                droppable: true,
                events: function(info, successCallback, failureCallback) {
                    $.ajax({
                        url: baseUrl + "/calendario-planificacion",
                        type: 'POST',
                        dataType: 'json', // Asegura que la respuesta se interprete como JSON
                        data: {
                            idUsuarioPlanificacion: idUsuarioPlanificacion,
                            start: info.startStr, // Fecha de inicio de la vista actual
                            end: info.endStr // Fecha de fin de la vista actual
                        },
                        success: function(res) {
                         
                             if (Array.isArray(res)) { // Verifica si res es un array
                                var events = [];
                                
                                // Array de colores predefinidos
                                var classes = [
                                    'bg-success-subtle text-success',
                                    'bg-info-subtle text-info',
                                    'bg-warning-subtle text-warning',
                                    'bg-danger-subtle text-danger',
                                    'bg-secondary-subtle text-secondary',
                                    'bg-primary-subtle text-primary'
                                ];
                                var classIndex = 0;
                        
                                res.forEach(function(evt) {
                                    
                                    // Asignar color aleatorio
                                    var className = classes[classIndex];
                                    // classIndex = (classIndex + 1) % classes.length;
                                    classIndex = Math.floor(Math.random() * (classes.length - 1 - 0 + 1)) + 0;
                            
                                    events.push({
                                        id:evt.id_planificacion,
                                        title: evt.title,
                                        start: evt.start,
                                        end: evt.end,
                                        classNames: [className],
                                        extendedProps: {
                                            grupoTrabajo: evt.grupoTrabajo,
                                            jefeGrupoTrabajo: evt.jefeGrupoTrabajo,
                                            id_horario: evt.id_horario,
                                            id_planificacion : evt.id_planificacion,
                                            fechaTrabajo: evt.fechaTrabajo
                                        }
                                    });
                                });
                                successCallback(events); // Llama al callback con los eventos
                            } else {
                                console.error('La respuesta no es un array:', res);
                                alert('Hubo un error al cargar los eventos.');
                                failureCallback(); // Llama al callback de fallo
                            }
                            // successCallback(events); // Llama al callback con los eventos
                        },
                        error: function() {
                            alert('Hubo un error al cargar los eventos.');
                            failureCallback(); // Llama al callback de fallo
                        }
                    });
                },
                eventDidMount: function(info) {
                    // Aplicar los estilos directamente sobre el DOM del evento
                    // info.el.style.backgroundColor = info.event.backgroundColor;
                    // info.el.style.borderColor = info.event.borderColor;
                    // info.el.style.color = info.event.textColor;
                    
                    // Aquí se aplican las clases de Bootstrap a los eventos
                    $(info.el).addClass(info.event.classNames.join(' '));
                }
                ,
                eventClick: function(info) { 
                    console.log(info.event.start.toLocaleDateString());
                    // Evitar que se abra el enlace predeterminado si el evento tiene un URL
                    info.jsEvent.preventDefault();
                    $('#eventid').val(info.event.id);
                    
                    // // Guardar id_horario en el campo oculto
                    // $('#idHorario').value = info.event.extendedProps.id_horario;
                    // $('#idPlanificacion').value = info.event.extendedProps.id_planificacion; console.log(info.event.extendedProps.id_planificacion);
                    
                    // $('#event-start-date-tag').value = info.event.start.toLocaleDateString();
                    
                    // Actualiza el contenido del modal con los detalles del evento
                    $('#modal-title').text(info.event.title);
                    $('#event-start-date-tag').text(info.event.start.toLocaleDateString());
                    $('#event-timepicker1-tag').text(info.event.start.toLocaleTimeString());
                    $('#event-timepicker2-tag').text(info.event.end ? info.event.end.toLocaleTimeString() : '');
                    $('#event-grupo-trabajo-tag').text(info.event.extendedProps.grupoTrabajo || 'No especificado');
                    $('#event-jefe-grupo-trabajo-tag').text(info.event.extendedProps.jefeGrupoTrabajo || 'No disponible');
                   
                    // Guardar id_horario en el campo oculto
                    $('#idHorario').val(info.event.extendedProps.id_horario);
                    $('#idPlanificacion').val(info.event.extendedProps.id_planificacion); 
                    
        
                    // Abre el modal
                    var eventModal = new bootstrap.Modal(document.getElementById('event-modal'), {
                        keyboard: true
                    });
                    
                    eventModal.show();
                },
                drop: function(info) { 
                    var eventEl = info.draggedEl;
                    var eventId = $(info.draggedEl).data('id');
                    var idHorario = $(eventEl).data('id');
                    var codigo = $(eventEl).data('codigo');
                    var grupoTrabajo = $(eventEl).data('grupo-trabajo');
                    var horaInicio = $(eventEl).data('hora-inicio');
                    var horaFin = $(eventEl).data('hora-fin');
                    var multiHorario = $(eventEl).data('multi-horario');
                    
                    var start = info.date;
                    var end = info.date;
                    
                    var existingEvents = calendar.getEvents();
                    
                    // Filtrar los eventos que ya existen en el mismo día
                    var eventsInDay = existingEvents.filter(function(event) {
                        var eventStart = new Date(event.start);
                        eventStart.setHours(0, 0, 0, 0);
                        return eventStart.getTime() === start.getTime();
                    });
                    
                    // Verificar si ya hay 2 o más eventos en ese día
                    if (eventsInDay.length >= 2) {
                        Swal.fire({
                            title: 'Límite de Eventos Alcanzado',
                            text: 'Solo se pueden crear hasta 2 eventos por día.',
                            icon: 'warning',
                            confirmButtonColor: '#282e38',
                            confirmButtonText: 'Entendido'
                        }).then(() => {
                            // Remover visualmente el evento que fue arrastrado si se excede el límite
                            calendar.getEventById(eventId)?.remove(); // Asegúrate de removerlo manualmente del calendario si es necesario
                        });
                        return false;
                    }
                    
                    
                    start.setHours(0, 0, 0, 0);
                    end.setHours(23, 59, 59, 999);
                    

                    
                    /////////////////////////////////////////////////////
                    var conflict = existingEvents.some(function(event) {
                        var eventStart = new Date(event.start);
                        var eventEnd = new Date(event.end);
                
                        eventStart.setHours(0, 0, 0, 0);
                        eventEnd.setHours(23, 59, 59, 999);
                
                        return (eventStart <= end && eventEnd >= start);
                    });
                
                    let mensaje;
                    let urlPlanificacionHorario;
                    let parametros;
                
                    if (conflict) {
                        if (multiHorario === "SI") {
                            Swal.fire({
                                title: 'Multiples Horarios',
                                text: '¿Deseas agregar un nuevo horario o actualizar el existente?',
                                icon: 'warning',
                                showCancelButton: true,
                                confirmButtonText: 'Actualizar',
                                cancelButtonText: 'Insertar nuevo',
                                confirmButtonColor: '#282e38',
                                cancelButtonColor: '#f35d5d',
                                input: 'textarea',
                                inputAttributes: {
                                    autocapitalize: 'on'
                                },
                                inputValidator: obs => {
                                    // Si el valor es válido, debes regresar undefined. Si no, una cadena
                                    if (!obs) {
                                        return "Por favor escribe el motivo";
                                    } else {
                                        return undefined;
                                    }
                                }
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    var motivo = result.value;
                                    mensaje = 'Esta Seguro de Actualizar el horario';
                                    urlPlanificacionHorario = baseUrl + '/calendario-planificacion-actualizar';
                                    parametros = {
                                        "idUsuario": idUsuarioPlanificacion,
                                        "idHorario": idHorario,
                                        "fecha": info.date,
                                        "motivo": motivo
                                    };
                                    ejecutarAccion(mensaje, urlPlanificacionHorario, parametros);

                                } else if (result.dismiss === Swal.DismissReason.cancel) {
                                    
                                    // Validación de las horas antes de crear el nuevo horario
                                    let canInsert = true;
                                
                                    // Iterar sobre los eventos existentes del mismo día y validar las horas
                                    eventsInDay.forEach(function(event) {
                                        var eventEnd = new Date(event.end);
                                        var eventHoraFin = eventEnd.getHours() + ':' + eventEnd.getMinutes();
                                        
                                        
                                        // Convertir ambas horas a minutos totales
                                        const eventHoraFinMinutes = timeToMinutes(eventHoraFin);
                                        const horaInicioMinutes = timeToMinutes(horaInicio);
                                        
                                      
                                        // Validar que la hora de fin del evento existente es menor o igual a la hora de inicio del nuevo evento
                                        if (eventHoraFinMinutes > horaInicioMinutes) {
                                            canInsert = false;
                                        }
                                    });
                                
                                    if (canInsert === false) {
                                        Swal.fire({
                                            title: 'Conflicto de Horas',
                                            text: 'La hora de inicio del nuevo evento debe ser posterior a la hora de fin del evento existente.',
                                            icon: 'error',
                                            confirmButtonColor: '#282e38',
                                            confirmButtonText: 'Entendido'
                                        });
                                        calendar.getEventById(eventId)?.remove(); // Remover visualmente el evento si hay un conflicto de horas
                                        return;
                                    }
                                    // FIN Validación de las horas antes de crear el nuevo horario
                                    mensaje = 'Esta Seguro de Crear el horario';
                                    urlPlanificacionHorario = baseUrl + '/calendario-planificacion-crear';
                                    parametros = {
                                        "idUsuario": idUsuarioPlanificacion,
                                        "idHorario": idHorario,
                                        "fecha": info.date,
                                        "grupoTrabajo": grupoTrabajo
                                    };
                                    
                                    ejecutarAccion(mensaje, urlPlanificacionHorario, parametros);
                                    // Swal.fire({
                                    //     title: mensaje,
                                    //     icon: 'warning',
                                    //     showCancelButton: true,
                                    //     confirmButtonColor: '#282e38',
                                    //     cancelButtonColor: '#f35d5d',
                                    //     confirmButtonText: 'Confirmar'
                                    // }).then((result) => {
                                    //     if (result.isConfirmed) {
                                    //         ejecutarAccion(mensaje, urlPlanificacionHorario, parametros);
                                    //     } else {
                                    //         // Revierte el evento si no se confirma
                                    //         calendar.getEventById(eventId)?.remove();
                                    //     }
                                    // });
                                } else {
                                    // Si no elige ninguna opción, revertir el evento
                                    calendar.getEventById(eventId)?.remove();
                                }
                            });
                        } else {
                            mensaje = 'Esta Seguro de Actualizar el horario';
                            urlPlanificacionHorario = baseUrl + '/calendario-planificacion-actualizar';
                            
                            Swal.fire({
                                title: mensaje,
                                icon: 'warning',
                                showCancelButton: true,
                                confirmButtonColor: '#282e38',
                                cancelButtonColor: '#f35d5d',
                                confirmButtonText: 'Confirmar',
                                input: 'textarea',
                                inputAttributes: {
                                    autocapitalize: 'on'
                                },
                                inputValidator: obs => {
                                    // Si el valor es válido, debes regresar undefined. Si no, una cadena
                                    if (!obs) {
                                        return "Por favor escribe el motivo";
                                    } else {
                                        return undefined;
                                    }
                                }
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    var motivo = result.value;
                                    parametros = {
                                        "idUsuario": idUsuarioPlanificacion,
                                        "idHorario": idHorario,
                                        "fecha": info.date,
                                        "motivo" : motivo
                                    };
                                    // ejecutarAccion(mensaje, urlPlanificacionHorario, parametros);
                                    $.ajax({
                                        url: urlPlanificacionHorario,
                                        type: "POST",
                                        data: parametros,
                                        success: function(response) {
                                            $('.respuesta').html(response);
                                        },
                                        error: function(jqXHR, textStatus, errorThrown) {
                                            Swal.close();
                                            alert('Ha ocurrido un error interno.');
                                            console.log(jqXHR);
                                            console.log(textStatus);
                                            console.log(errorThrown);
                                        }
                                    });
                                } else {
                                    // Revierte el evento si no se confirma
                                    calendar.getEventById(eventId)?.remove();
                                }
                            });
                        
                        }
                    } else {
                        mensaje = 'Esta Seguro de Crear el horario';
                        urlPlanificacionHorario = baseUrl + '/calendario-planificacion-crear';
                        parametros = {
                            "idUsuario": idUsuarioPlanificacion,
                            "idHorario": idHorario,
                            "fecha": info.date,
                            "grupoTrabajo": grupoTrabajo
                        };
                       
                        Swal.fire({
                            title: mensaje,
                            icon: 'warning',
                            showCancelButton: true,
                            confirmButtonColor: '#282e38',
                            cancelButtonColor: '#f35d5d',
                            confirmButtonText: 'Confirmar'
                        }).then((result) => {
                            if (result.isConfirmed) {
                                // ejecutarAccion(mensaje, urlPlanificacionHorario, parametros);
                                $.ajax({
                                    url: urlPlanificacionHorario,
                                    type: "POST",
                                    data: parametros,
                                    success: function(response) {
                                        $('.respuesta').html(response);
                                    },
                                    error: function(jqXHR, textStatus, errorThrown) {
                                        Swal.close();
                                        alert('Ha ocurrido un error interno.');
                                        console.log(jqXHR);
                                        console.log(textStatus);
                                        console.log(errorThrown);
                                    }
                                });
                            } else {
                                // Revierte el evento si no se confirma
                                calendar.getEventById(eventId)?.remove();
                            }
                        });
                        
                    }
                },
                eventDrop: function(info) {
                    // Aquí puedes manejar el caso donde el evento se mueve dentro del calendario
                    console.log('Evento movido:', info);
                }

            });
        
            // Configurar Draggable para eventos externos
            var externalEventsEl = document.getElementById('external-events');
            new FullCalendar.Draggable(externalEventsEl, {
                itemSelector: '.external-event',
                eventData: function(eventEl) {
                    return {
                        id: $(eventEl).data('id'),
                        title: eventEl.innerText,
                        className: $(eventEl).data('class')
                    };
                }
            });
        
            calendar.render();
        
            // Función para ejecutar la acción de Swal y AJAX
            function ejecutarAccion(mensaje, url, parametros) {
                Swal.fire({
                    title: mensaje,
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#282e38',
                    cancelButtonColor: '#f35d5d',
                    confirmButtonText: 'Confirmar'
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            url: url,
                            type: "POST",
                            data: parametros,
                            success: function(response) {
                                $('.respuesta').html(response);
                            },
                            error: function(jqXHR, textStatus, errorThrown) {
                                Swal.close();
                                alert('Ha ocurrido un error interno.');
                                console.log(jqXHR);
                                console.log(textStatus);
                                console.log(errorThrown);
                            }
                        });
                    } else {
                        
                        calendar.getEventById(eventId)?.remove();
                    }
                });
            }
        
            // Evento click para el botón de borrar
            $('#btn-delete-event').on('click', function() {
                // Obtener el ID del evento actual desde el campo oculto o la variable global
                var eventId = $('#eventid').val();
                
                console.log(eventId);
                if (eventId) {
                    // Confirmación antes de borrar
                    Swal.fire({
                        title: '¿Estás seguro?',
                        text: "Este cambio no se puede deshacer.",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#282e38',
                        cancelButtonColor: '#f35d5d',
                        confirmButtonText: 'Sí, borrar',
                        cancelButtonText: 'Cancelar'
                    }).then((result) => {
                        if (result.isConfirmed) { console.log(eventId);
                            // Llamada AJAX al servidor para borrar el evento en el backend
                            $.ajax({
                                url: baseUrl + '/borrar-evento', // Cambia a la URL de tu endpoint para borrar
                                type: 'POST',
                                data: {
                                    id: eventId
                                },
                                success: function(response) {
                                    $('.respuesta').html(response);
                                    // Eliminar el evento del calendario en el frontend
                                    var event = calendar.getEventById(eventId);
                                    if (event) {
                                        event.remove();
                                    }
                                    // Cerrar el modal
                                    $('#event-modal').modal('hide');
                                    Swal.fire(
                                        'Eliminado',
                                        'El evento ha sido eliminado.',
                                        'success'
                                    );
                                },
                                error: function() {
                                    Swal.fire(
                                        'Error',
                                        'Hubo un problema al intentar borrar el evento.',
                                        'error'
                                    );
                                }
                            });
                        }
                    });
                }
            });
        
        
            // Manejar el clic en una tarjeta para abrir el modal
            $('.event-card').on('click', function() {
                var fechaTrabajo = $(this).data('fecha');
                var idUsuario = $(this).data('idusuario');
                var inicioTrabajo = $(this).data('inicio');
                var inicioAsistencia = $(this).data('inicio-asistencia');
                var motivoCambio = $(this).data('motivo');
                
                var UsuarioPlanificacion = $("#idUsuarioPlanificacion").val();
                var UsuarioSession = $("#idUsuarioSession").val();
        
                // Llenar el modal con los datos seleccionados
                $('#fechaTrabajo').val(fechaTrabajo);
                $('#horaIngreso').val(inicioTrabajo);
                $('#idUsuario').val(idUsuario);
                $('#fecha').val(fechaTrabajo);
                $('#inicioAsistencia').val(inicioAsistencia);
                $('#motivo_cambio_hora_inicio').val(motivoCambio);
    
                if (UsuarioSession == UsuarioPlanificacion) {
                    $("#horaIngreso").prop("disabled", true);
                    $("#motivo_cambio_hora_inicio").prop("disabled", true);
                    $("#saveHoraIngreso").prop("disabled", true);
                } else {
                    $("#horaIngreso").prop("disabled", false);
                    $("#motivo_cambio_hora_inicio").prop("disabled", false);
                    $("#saveHoraIngreso").prop("disabled", false);
                }
    
     
                
                // Mostrar el modal
                $('#editHoraIngresoModal').modal('show');
            });
    
            
    
            // Guardar cambios cuando se hace clic en el botón de guardar
            $('#saveHoraIngreso').on('click', function() {
                var idUsuario = $('#idUsuario').val();
                var fecha = $('#fecha').val();
                var motivo = $("#motivo_cambio_hora_inicio").val();
                var nuevaHoraIngreso = $('#horaIngreso').val();
                var inicioAsistencia = $('#inicioAsistencia').val();
        
                // Realizar la solicitud AJAX para actualizar la hora de ingreso
                $.ajax({
                    url: baseUrl + '/actualizar-hora-ingreso', // Ruta del backend
                    type: 'POST',
                    data: {
                        idUsuario: idUsuario,
                        fecha: fecha,
                        motivo: motivo,
                        inicioAsistencia: inicioAsistencia,
                        nuevaHoraIngreso: nuevaHoraIngreso
                    },
                    success: function(response) { console.log(response);
                        $('.respuesta').html(response);
                        $('#editHoraIngresoModal').modal('hide');
                    
                    },
                    error: function(xhr, status, error) {
                        console.error('Error en la solicitud:', error);
                        console.log('Hubo un problema al actualizar la hora de ingreso.');
                    }
                });
            });
        
            // Función para convertir una hora (HH:mm o HH:mm:ss) a minutos totales
            function timeToMinutes(timeString) {
                const parts = timeString.split(':');
                const hours = parseInt(parts[0], 10);
                const minutes = parseInt(parts[1], 10);
                return (hours * 60) + minutes; // Solo considera horas y minutos
            }
        
        });

    </script>
<?php $this->endSection(); ?>

<!-- end main content-->

<div class="flatpickr-calendar rangeMode animate" tabindex="-1">
   <div class="flatpickr-months">
      <span class="flatpickr-prev-month flatpickr-disabled">
         <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 17 17">
            <g></g>
            <path d="M5.207 8.471l7.146 7.147-0.707 0.707-7.853-7.854 7.854-7.853 0.707 0.707-7.147 7.146z"></path>
         </svg>
      </span>
      <div class="flatpickr-month">
         <div class="flatpickr-current-month">
            <select class="flatpickr-monthDropdown-months" aria-label="Month" tabindex="-1">
               <option class="flatpickr-monthDropdown-month" value="6" tabindex="-1">July</option>
               <option class="flatpickr-monthDropdown-month" value="7" tabindex="-1">August</option>
               <option class="flatpickr-monthDropdown-month" value="8" tabindex="-1">September</option>
               <option class="flatpickr-monthDropdown-month" value="9" tabindex="-1">October</option>
               <option class="flatpickr-monthDropdown-month" value="10" tabindex="-1">November</option>
               <option class="flatpickr-monthDropdown-month" value="11" tabindex="-1">December</option>
            </select>
            <div class="numInputWrapper"><input class="numInput cur-year" type="number" tabindex="-1" aria-label="Year" min="2024"><span class="arrowUp"></span><span class="arrowDown"></span></div>
         </div>
      </div>
      <span class="flatpickr-next-month">
         <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 17 17">
            <g></g>
            <path d="M13.207 8.472l-7.854 7.854-0.707-0.707 7.146-7.146-7.146-7.148 0.707-0.707 7.854 7.854z"></path>
         </svg>
      </span>
   </div>
   <div class="flatpickr-innerContainer">
      <div class="flatpickr-rContainer">
         <div class="flatpickr-weekdays">
            <div class="flatpickr-weekdaycontainer">
               <span class="flatpickr-weekday">
               Sun</span><span class="flatpickr-weekday">Mon</span><span class="flatpickr-weekday">Tue</span><span class="flatpickr-weekday">Wed</span><span class="flatpickr-weekday">Thu</span><span class="flatpickr-weekday">Fri</span><span class="flatpickr-weekday">Sat
               </span>
            </div>
         </div>
         <div class="flatpickr-days" tabindex="-1">
            <div class="dayContainer"><span class="flatpickr-day prevMonthDay flatpickr-disabled" aria-label="June 30, 2024">30</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 1, 2024">1</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 2, 2024">2</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 3, 2024">3</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 4, 2024">4</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 5, 2024">5</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 6, 2024">6</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 7, 2024">7</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 8, 2024">8</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 9, 2024">9</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 10, 2024">10</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 11, 2024">11</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 12, 2024">12</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 13, 2024">13</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 14, 2024">14</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 15, 2024">15</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 16, 2024">16</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 17, 2024">17</span><span class="flatpickr-day flatpickr-disabled" aria-label="July 18, 2024">18</span><span class="flatpickr-day today" aria-label="July 19, 2024" aria-current="date" tabindex="-1">19</span><span class="flatpickr-day" aria-label="July 20, 2024" tabindex="-1">20</span><span class="flatpickr-day" aria-label="July 21, 2024" tabindex="-1">21</span><span class="flatpickr-day" aria-label="July 22, 2024" tabindex="-1">22</span><span class="flatpickr-day" aria-label="July 23, 2024" tabindex="-1">23</span><span class="flatpickr-day" aria-label="July 24, 2024" tabindex="-1">24</span><span class="flatpickr-day" aria-label="July 25, 2024" tabindex="-1">25</span><span class="flatpickr-day" aria-label="July 26, 2024" tabindex="-1">26</span><span class="flatpickr-day" aria-label="July 27, 2024" tabindex="-1">27</span><span class="flatpickr-day" aria-label="July 28, 2024" tabindex="-1">28</span><span class="flatpickr-day" aria-label="July 29, 2024" tabindex="-1">29</span><span class="flatpickr-day" aria-label="July 30, 2024" tabindex="-1">30</span><span class="flatpickr-day" aria-label="July 31, 2024" tabindex="-1">31</span><span class="flatpickr-day nextMonthDay" aria-label="August 1, 2024" tabindex="-1">1</span><span class="flatpickr-day nextMonthDay" aria-label="August 2, 2024" tabindex="-1">2</span><span class="flatpickr-day nextMonthDay" aria-label="August 3, 2024" tabindex="-1">3</span><span class="flatpickr-day nextMonthDay" aria-label="August 4, 2024" tabindex="-1">4</span><span class="flatpickr-day nextMonthDay" aria-label="August 5, 2024" tabindex="-1">5</span><span class="flatpickr-day nextMonthDay" aria-label="August 6, 2024" tabindex="-1">6</span><span class="flatpickr-day nextMonthDay" aria-label="August 7, 2024" tabindex="-1">7</span><span class="flatpickr-day nextMonthDay" aria-label="August 8, 2024" tabindex="-1">8</span><span class="flatpickr-day nextMonthDay" aria-label="August 9, 2024" tabindex="-1">9</span><span class="flatpickr-day nextMonthDay" aria-label="August 10, 2024" tabindex="-1">10</span></div>
         </div>
      </div>
   </div>
</div>
<div class="flatpickr-calendar hasTime noCalendar animate" tabindex="-1">
   <div class="flatpickr-time" tabindex="-1">
      <div class="numInputWrapper"><input class="numInput flatpickr-hour" type="number" aria-label="Hour" tabindex="-1" step="1" min="1" max="12" maxlength="2"><span class="arrowUp"></span><span class="arrowDown"></span></div>
      <span class="flatpickr-time-separator">:</span>
      <div class="numInputWrapper"><input class="numInput flatpickr-minute" type="number" aria-label="Minute" tabindex="-1" step="5" min="0" max="59" maxlength="2"><span class="arrowUp"></span><span class="arrowDown"></span></div>
      <span class="flatpickr-am-pm" title="Click to toggle" tabindex="-1">PM</span>
   </div>
</div>
<div class="flatpickr-calendar hasTime noCalendar animate" tabindex="-1">
   <div class="flatpickr-time" tabindex="-1">
      <div class="numInputWrapper"><input class="numInput flatpickr-hour" type="number" aria-label="Hour" tabindex="-1" step="1" min="1" max="12" maxlength="2"><span class="arrowUp"></span><span class="arrowDown"></span></div>
      <span class="flatpickr-time-separator">:</span>
      <div class="numInputWrapper"><input class="numInput flatpickr-minute" type="number" aria-label="Minute" tabindex="-1" step="5" min="0" max="59" maxlength="2"><span class="arrowUp"></span><span class="arrowDown"></span></div>
      <span class="flatpickr-am-pm" title="Click to toggle" tabindex="-1">PM</span>
   </div>
</div>

<?php $this->endSection(); ?>