<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>

<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">crea
						<h4 class="mb-sm-0"><?= $breadcrumb ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
            <div class="row">
                <?php foreach ($grupoTrabajo as $grupo): ?>
                    <div class="col-sm-2">
                        <div class="card text-center text-white bg-warning">
                            <div class="card-body">
                                <h5 class="card-title"><?= $grupo['GrupoTrabajo']; ?></h5>
                                <p class="card-text"><?= $grupo['Observacion']; ?></p>
                                <a href="#" class="btn btn-primary grupo-trabajo" data-grupoTrabajo="<?= $grupo['IDGrupoTrabajo']; ?>">Seleccionar Grupo</a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $breadcrumb_alias ?></h5>
                            <div class="d-flex">
								<?php
								if(in_array("VERPLA", $permisos))
								{
								?>
                                <!--<button class="btn btn-info mx-1 d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#importarCSVUsuarioFlota">-->
								<!--	<i class='mdi mdi-routes-clock align-bottom me-2 text-muted' style='font-size: 18px;'></i> Ver Planificación-->
								<!--</button>-->
								<a href='#' class='btn btn-info mx-1 d-flex align-items-center ver-planificacion d-none' data-idplanificacion=''>
                                    <i class="mdi mdi-plus-circle mr-1" style="font-size: 18px;"></i> Ver Planificacion
                                </a>
								<?php
								}
								
								if(in_array("GRUPUS", $permisos))
								{
								?>
                                <button class="btn btn-danger mx-1 d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#importarCSVUsuarioDesempeno">
									<i class="mdi mdi-plus-circle mr-1" style="font-size: 18px;"></i> Importar Desempeño
								</button>
								<?php
								}
								
								if(in_array("HORAPL", $permisos))
								{
								?>
                                <button class="btn btn-success mx-1 d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#importarPlanificacion">
									<i class="mdi mdi-plus-circle mr-1" style="font-size: 18px;"></i> Importar Planificación
								</button>
								<?php
								}
								
								if (in_array("TESTEO", $permisos)) 
								{
								?>
                                <button class="btn btn-primary mx-1 d-flex align-items-center datos-planificacion" data-bs-toggle="modal" data-bs-target="#informacionPlanificacion" data-id="0" data-accion="crear" id="crear-usuario">
									<i class="mdi mdi-plus-circle mr-1" style="font-size: 18px;"></i> Crear Planificación 
								</button>
								<?php
								}
								?>
                            </div>
                        </div>
						<div class="card-body">
							<table id="planificacionDataTable" class="table table-bordered nowrap table-striped align-middle" style="width:100%">
							</table>
						</div>
					</div>
				</div>
			</div>
			
		</div>
		
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<?= $this->section('js'); ?>
<script>
let dt2 = null;

function recargarDataTableHorarios(idGrupoTrabajoSeleccionado, mostrarEliminar = false) {
    /*** SERVERSIDE HORARIOS ***/
    assetListVM2 = {
        init: function () {
            // Si ya existe un DataTable inicializado, destrúyelo primero
            if ($.fn.DataTable.isDataTable('#tblHorarios')) {
                $('#tblHorarios').DataTable().destroy();
            }

            // Inicializa el DataTable nuevamente
            dt2 = $('#tblHorarios').DataTable({
                "serverSide": true,
                "processing": true,
                "ajax": {
                    "url": baseUrl + "/horarioDataTableModal",
                    "type": 'GET',
                    "data": function (d) {
                        d.idGrupoTrabajo = idGrupoTrabajoSeleccionado; // Pasar el ID del grupo de trabajo seleccionado
                    }
                },
                "columns": [
                    {"title": "ID Horario", "data": "horarioEleccion", "class": "text-center", "searchable": true },
                    {"title": "Horario", "data": "horario", "class": "text-center", "searchable": true },
                    {"title": "Código", "data": "codigo", "class": "text-center", "searchable": true },
                    {"title": "Usuario Registra", "data": "nombresCompletos", "class": "text-center", "searchable": true },
                    {"title": "Fecha Registra", "data": "FechaRegistra", "class": "text-center", "searchable": true },
                    {"title": "Estado", "data": "EstadoHorario", "class": "text-center", "searchable": true },
                    {
                        "title": "Acciones",
                        "data": null,
                        "class": "text-center",
                        "orderable": false,
                        "render": function (data, type, row) {
                            let buttons = '';
                            if (mostrarEliminar) {
                                // Botón de eliminar
                                buttons += `<button class="btn btn-danger btn-sm eliminar-horario" data-id="${row.id_horario}">Eliminar</button> `;
                            }
                            // Botón para ver detalles
                            buttons += `<button class="btn btn-info btn-sm ver-detalles" data-id="${row.id_horario}">Ver Detalles</button> `;
                            // Botón de editar
                            buttons += `<button class="btn btn-warning btn-sm editar-horario" data-id="${row.id_horario}">Editar</button>`;
                            return buttons;
                        }
                    }
                ],
                "lengthMenu": [[5, 10, 25, 50], [5, 10, 25, 50]],
                responsive: true,
                autoWidth: false,
                'pageLength': 5,
                "aaSorting": [[0, 'desc']],
                "rowCallback": function (row, data) {
                    $(row).addClass('form-check-all');
                }
            });

            // Manejar el evento del botón de eliminar
            $('#tblHorarios').on('click', '.eliminar-horario', function () {
                const idHorario = $(this).data('id');
                eliminarHorario(idHorario);
            });

            // Manejar el evento del botón de ver detalles
            $('#tblHorarios').on('click', '.ver-detalles', function () {
                const idHorario = $(this).data('id');
                mostrarDetallesHorario(idHorario);
            });

            // Manejar el evento del botón de editar
            $('#tblHorarios').on('click', '.editar-horario', function () {
                const idHorario = $(this).data('id');
                editarHorario(idHorario);
            });
        }
    };

    assetListVM2.init();
}
 
/* ----------------------------------------------------------------------------------------------------- */

        $(function () {
            let idGrupoTrabajoSeleccionado = null; // Almacena el ID del grupo de trabajo seleccionado
        
            // Inicialización del DataTable
            const dt = $('#planificacionDataTable').DataTable({
                "serverSide": true,
                "processing": true,
                "ajax": {
                    "url": baseUrl + "/planificacion-data-table",
                    "type": 'GET',
                    "data": function (d) {
                        d.idGrupoTrabajo = idGrupoTrabajoSeleccionado; // Pasar el ID del grupo de trabajo seleccionado
                    }
                },
                "columns": [
                    {"title": "Matrícula", "data": "Matricula", "class": "text-center", "searchable": true},
                    {"title": "Nombre y Apellido", "data": "nombresCompletos", "class": "text-center", "searchable": true},
                    {"title": "Descripción Horaria", "data": "horario", "class": "text-center", "searchable": true},
                    {"title": "Código Horario", "data": "codigo", "class": "text-center", "searchable": true},
                    {"title": "Grupo Trabajo", "data": "GrupoTrabajo", "class": "text-center", "searchable": true},
                    {"title": "Estado Usuario", "data": "EstadoUsuario", "class": "text-center", "searchable": true},
                    {"title": "Acciones", "data": "Acciones", "class": "text-center", "searchable": true}
                ],
                "lengthMenu": [[10, 25, 50], [10, 25, 50]],
                responsive: true,
                autoWidth: false,
                "aaSorting": [[1, 'asc']],
            });
        
            // Manejar el clic en los botones "Seleccionar Grupo de Trabajo"
            $('.grupo-trabajo').on('click', function (e) {
                e.preventDefault();
        
                // Obtener el ID del grupo de trabajo seleccionado
                const idGrupoTrabajo = $(this).data('grupotrabajo');
        
                // Si ya está seleccionado el mismo grupo, no recargar la tabla
                if (idGrupoTrabajoSeleccionado === idGrupoTrabajo) {
                    return; // No hace nada si es el mismo grupo
                }
        
                // Asigna el nuevo grupo de trabajo
                idGrupoTrabajoSeleccionado = idGrupoTrabajo;
                
                // Recargar dataTable Horarios
                recargarDataTableHorarios(idGrupoTrabajoSeleccionado)

                // Recargar el DataTable con la nueva información del grupo de trabajo
                dt.ajax.reload(null, false); // Recarga la tabla sin reiniciar la paginación
                
                $('.ver-planificacion').removeClass('d-none'); // Quita la clase d-none
                $('.ver-planificacion').attr('href', `${baseUrl}/ver-planificacion-horaria/${idGrupoTrabajo}`); // Actualiza el href con el ID del grupo
        
            });
        });

</script>
<?php $this->endSection(); ?>
<!-- Modal Perfil Usuario -->
<div class="modal fade" id="editarPerfilUsuario" tabindex="-1" role="dialog" aria-labelledby="exampleEditarPerfilUsuario" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleEditarPerfilUsuario">Editar Usuario</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formEditarPerfilUsuario" class="formulario" autocomplete="off" action="" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
                            <div>
                                <label for="txtPerfilUsuario" class="form-label">Perfil*</label>
								<select class="form-select" aria-label="Perfil" id="txtPerfilUsuario" name="txtPerfilUsuario">
									<option selected="" value="">Seleccione una opción</option>
								</select>
                            </div>
                        </div>
						<span style="color: red;">* Si procede a realizar el cambio, todos los permisos y rutas personalizadas serán eliminadas y se asignarán los permisos y rutas por defecto del perfil.</span>
						<!--<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtPassword" class="form-label">Contraseña</label>
                            <div class="input-group">
                                <input type="text" class="form-control" aria-label="Password" id="txtPassword" name="txtPassword">
                            </div>
                        </div>-->
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" id="btnEjecutarOperador" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Actualizar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<!-- end main content-->

<!-- Modal Sistemas Usuario -->
<div class="modal fade" id="editarSistemasUsuario" tabindex="-1" role="dialog" aria-labelledby="exampleEditarSistemasUsuario" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleEditarSistemasUsuario">Editar Sistemas</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formEditarSistemasUsuario" class="formulario" autocomplete="off" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body d-flex justify-content-center">
					<input type="hidden" id="txtIDUsuario" name="txtIDUsuario">
					<div class="card text-dark col-7 bg-info" style="border: 1px solid #299CDB;">
						<div class="card-header" style="background-color: transparent; color: #FFF;">Sistemas</div>
						<div class="card-body" style="background-color: #FFF;" id="ctnSistemasUsuario">
							
					
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<!-- end main content-->
<!-- Modal Sistemas Grupo Usuarios -->
<div class="modal fade" id="informacionPlanificacion" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionPlanificacion" aria-hidden="true">
	<div class="modal-dialog modal-xl modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleinformacionPlanificacion">Planificación de Horarios</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			
			<div class="card-body form-steps">
            	<form id="forminformacionPlanificacion" class="formulario" autocomplete="off" method="POST">
            	    <span class="respuesta"></span>
            	    <div class="modal-body row d-flex m-0">
                	    <input type="hidden" id="txtIDUsuario_i" name="txtIDUsuario_i">

                		<div class="step-arrow-nav mb-4">
                			<ul class="nav nav-pills custom-nav nav-justified" role="tablist">
                				<li class="nav-item" role="presentation">
                					<button class="nav-link active" id="steparrow-gen-info-tab" data-bs-toggle="pill" data-bs-target="#steparrow-gen-info" type="button" role="tab" aria-controls="steparrow-gen-info" aria-selected="true" data-position="0">Usuarios</button>
                				</li>
                				<li class="nav-item" role="presentation">
                					<button class="nav-link" id="steparrow-description-info-tab" data-bs-toggle="pill" data-bs-target="#steparrow-description-info" type="button" role="tab" aria-controls="steparrow-description-info" aria-selected="false" data-position="1" tabindex="-1">Horarios</button>
                				</li>
                				<li class="nav-item" role="presentation">
                					<button class="nav-link" id="pills-experience-tab" data-bs-toggle="pill" data-bs-target="#pills-experience" type="button" role="tab" aria-controls="pills-experience" aria-selected="false" data-position="2" tabindex="-1">Planificador</button>
                				</li>
                			</ul>
                		</div>
                
                		<div class="tab-content">
                			<div class="tab-pane fade active show" id="steparrow-gen-info" role="tabpanel" aria-labelledby="steparrow-gen-info-tab">
                				<div>
                					<div class="row">
                					
                						<div class="col-lg-12 d-flex justify-content-center">
                						    
                							<div class="col-xl-8">
                							    <div class="mb-3">
                    								<label for="txtGrupoUsuario_i" class="form-label">Grupo Usuario</label>
                    								<select class="form-select" aria-label="Grupo Usuario" id="txtGrupoUsuario_i" name="txtGrupoUsuario_i">
                    									<option value="">Seleccione una opción</option>
                    								</select>
                    								<div class="invalid-feedback">Please enter an email address</div>
                							    </div>
                                            	<div class="card">
                                                	<div class="card-header">
                                                		<h4 class="card-title mb-0" id="nombreGrupoTrabajo">Data Attributes + Custom</h4>
                                                	</div>
                                                	<!-- end card header -->
                                                
                                                	<div class="card-body">
                                                		<div id="users">
                                                
                                                			<div data-simplebar="init" style="height: 242px;" class="mx-n3 simplebar-scrollable-y">
                                                				<div class="simplebar-wrapper" style="margin: 0px;">
                                                					<div class="simplebar-height-auto-observer-wrapper">
                                                						<div class="simplebar-height-auto-observer"></div>
                                                					</div>
                                                					<div class="simplebar-mask">
                                                						<div class="simplebar-offset" style="right: 0px; bottom: 0px;">
                                                							<div class="simplebar-content-wrapper" tabindex="0" role="region" aria-label="scrollable content" style="height: 100%; overflow: hidden scroll;">
                                                								<div class="simplebar-content" style="padding: 0px;">
                                                									<ul class="list list-group list-group-flush mb-0" id="listadoUsuariosGrupoTrabajo">
                                                										<li class="list-group-item" data-id="1">
                                                											<div class="d-flex">
                                                												<div class="flex-grow-1">
                                                													<h5 class="fs-13 mb-1"><a href="#" class="link name text-body">Jonny Stromberg</a></h5>
                                                													<p class="born timestamp text-muted mb-0" data-timestamp="12345">1986</p>
                                                												</div>
                                                												<div class="flex-shrink-0">
                                                													<div>
                                                														<img class="image avatar-xs rounded-circle" alt="" src="<?= $baseUrl ?>/public/images/users/user-dummy-img.jpg">
                                                													</div>
                                                												</div>
                                                											</div>
                                                										</li>
                                                									</ul>
                                                									<!-- end ul list -->
                                                								</div>
                                                							</div>
                                                						</div>
                                                					</div>
                                                					<div class="simplebar-placeholder" style="width: 292px; height: 312px;"></div>
                                                				</div>
                                                				<div class="simplebar-track simplebar-horizontal" style="visibility: hidden;">
                                                					<div class="simplebar-scrollbar" style="width: 0px; display: none;"></div>
                                                				</div>
                                                				<div class="simplebar-track simplebar-vertical" style="visibility: visible;">
                                                					<div class="simplebar-scrollbar" style="height: 187px; transform: translate3d(0px, 0px, 0px); display: block;"></div>
                                                				</div>
                                                			</div>
                                                		</div>
                                                	</div>
                                                	<!-- end card body -->
                                                </div>
                                            	<!-- end col -->
                                            </div>
                						</div>
                					</div>
                				</div>
                				<div class="d-flex align-items-start gap-3 mt-4">
                					<button type="button" class="btn btn-success btn-label right ms-auto nexttab nexttab" data-nexttab="steparrow-description-info-tab"><i class="ri-arrow-right-line label-icon align-middle fs-16 ms-2"></i>Siguiente</button>
                				</div>
                			</div>
                			<!-- end tab pane -->
                
                			<div class="tab-pane fade" id="steparrow-description-info" role="tabpanel" aria-labelledby="steparrow-description-info-tab">
                				<div>
                					<div class="mb-3">
                					    
                                        
                                        <div class="row">
                                        	<div class="col-lg-12">
                                        		<div class="card">
                            						<div class="card-header d-flex align-items-center">
                                                        <h5 class="card-title mb-0 flex-grow-1"><?= $breadcrumb_alias ?></h5>
                                                        <div>
                            								<a href="<?= $baseUrl ?>" class="btn px-2 py-0" style="border-radius: 45%; background-color: red;"><i class="mdi mdi-arrow-left-circle" style="font-size: 24px; color: #FFF"></i></a>
                                                        </div>
                                                    </div>
                            						<div class="card-body">
                            						
                            							<table id="tblHorarios" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
                                                            
                            							</table>
                            						</div>
                            					</div>
                                        		<!-- end col -->
                                        	</div>
                                        	<!-- end col -->
                                        	<div></div>
                                        </div>


                					</div>
                				</div>
                				<div class="d-flex align-items-start gap-3 mt-4">
                					<button type="button" class="btn btn-light btn-label previestab" data-previous="steparrow-gen-info-tab"><i class="ri-arrow-left-line label-icon align-middle fs-16 me-2"></i> Atras</button>
                					<button type="button" class="btn btn-success btn-label right ms-auto nexttab nexttab" data-nexttab="pills-experience-tab"><i class="ri-arrow-right-line label-icon align-middle fs-16 ms-2"></i>Siguiente</button>
                				</div>
                            </div>
                			<!-- end tab pane -->
                
                			<div class="tab-pane fade" id="pills-experience" role="tabpanel" aria-labelledby="pills-experience-tab">
                				<div class="text-center">
                
                					<div class="avatar-md mt-5 mb-4 mx-auto">
                						<div class="avatar-title bg-light text-success display-4 rounded-circle">
                							<i class="ri-checkbox-circle-fill"></i>
                						</div>
                					</div>
                					<h5>Well Done !</h5>
                					<p class="text-muted">You have Successfully Signed Up</p>
                				</div>
                				<div class="d-flex align-items-start gap-3 mt-4">
                					<button type="button" class="btn btn-light btn-label previestab" data-previous="steparrow-description-info-tab"><i class="ri-arrow-left-line label-icon align-middle fs-16 me-2"></i> Atras</button>
                					<button type="button" class="btn btn-success btn-label right ms-auto nexttab nexttab" data-nexttab="pills-experience-tab"><i class="ri-arrow-right-line label-icon align-middle fs-16 ms-2"></i>Submit</button>
                				</div>
                			</div>
                			<!-- end tab pane -->
                		</div>
                		<!-- end tab content -->
                	</div>
            	</form>
            </div>
            
		</div>
	</div>
</div>
<!-- end main content-->
<!-- Modal Importar Planificación -->
<div class="modal fade bd-example-modal-lg" id="importarPlanificacion" tabindex="-1" role="dialog" aria-labelledby="exampleimportarPlanificacion" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleimportarPlanificacion">Importar CSV Planificación </h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formulario" id="formImportarPlanificacion" autocomplete="off" action="<?= $baseUrl ?>/importar-csv-planificacion" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="row modal-body">
					<div class="col-12 mb-3">
						<h4>Consideraciones:</h4>
						<p>1.- La columna A solo recibirá matriculas</p>
						<p>2.- Evitar espacios en blanco al inicio y al final del campo</p>
						<p>3.- Las matriculas deberán estar vinculadas a un Grupo de Usuarios</p>
						<p>4.- La primera fila solo recibirá fecha con el formato "DD-MM-YYYY".</p>
						<p>5.- Los horarios deberán ser nombrados mediante su código </p>
						<p>6.- Los horarios deberán estar vinculados a un Grupo de Usuarios</p>
					</div>

					<div class="col-6 mb-3 d-flex justify-content-end">
						
						<a class='btn btn-info border-0 texto-indicador' style="color: #FFF" href='<?= base_url().'/public/docs/Plantillas/Plantilla CSV Planificacion.csv' ?>' download='Plantilla CSV Planificacion'>Descargar Plantilla</a>
						
					</div>
					<div class="mb-3">
						<label for="fileCSVPlanificacion" class="form-label">Seleccione CSV:</label>
						<input class="form-control" type="file" id="fileCSVPlanificacion" name="fileCSVPlanificacion">
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" class="btn btn-success"><i class="mdi mdi-content-save"></i> Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<!-- Modal Importar Metricas Desempeño Usuarios -->
<div class="modal fade bd-example-modal-lg" id="importarCSVUsuarioDesempeno" tabindex="-1" role="dialog" aria-labelledby="exampleimportarCSVUsuarioDesempeno" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleimportarCSVUsuarioDesempeno">Importar Desempeño </h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formulario" id="formImportarCSVUsuarioDesempeno" autocomplete="off" action="<?= $baseUrl ?>/importar-csv-desempeno" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="row modal-body">
					<div class="col-12 mb-3">
						<h4>Consideraciones:</h4>
						<p>1.- Las fechas deben contar con el formato "YYYY-MM-DD".</p>
						<p>2.- Evitar espacios en blanco al inicio y al final del campo</p>
						<p>3.- Formato de las columnas [ATC, TMO, WP] son dos decimales y separado por "."</p>
						<p>4.- Formato de la columna [PROD] son valores enteros.</p>
					</div>

					<div class="col-6 mb-3 d-flex justify-content-end">
						
						<a class='btn btn-info border-0 texto-indicador' style="color: #FFF" href='<?= base_url().'/public/docs/Plantillas/plantilla csv metricas desempeno.csv' ?>' download='Plantilla CSV Metricas'>Descargar Plantilla</a>
						
					</div>
					<div class="mb-3">
						<label for="fileCSVDesempeno" class="form-label">Seleccione CSV:</label>
						<input class="form-control" type="file" id="fileCSVDesempeno" name="fileCSVDesempeno">
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" class="btn btn-success"><i class="mdi mdi-content-save"></i> Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<!-- Modal Importar Usuarios IT-->
<div class="modal fade bd-example-modal-lg" id="importarCSVUsuarioFlota" tabindex="-1" role="dialog" aria-labelledby="exampleimportarCSVUsuarioFlota" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleimportarCSVUsuarioFlota">Actualizar Placa y Brevete - Flota</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formulario" id="formImportarCSVUsuarioFlota" autocomplete="off" action="<?= $baseUrl ?>/importar-csv-usuario-flota" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="col-12 mb-3">
						<h4>Consideraciones:</h4>
						<p>1.- El campo BREVETE es obligatorio.</p>
						<p>2.- El campo PLACA es obligatorio, sin guión.</p>
					</div>
					<div class="col-12 mb-3 d-flex justify-content-end">
						
							<a class='btn btn-info border-0 texto-indicador' style="color: #FFF" href='<?= base_url().'/public/docs/Plantillas/plantilla csv usuarios flota.csv' ?>' download='Plantilla CSV Usuarios Flota'>Descargar Plantilla</a>
						
					</div>
					<div class="mb-3">
						<label for="fileCSVUsuarioFlota" class="form-label">Seleccione CSV:</label>
						<input class="form-control" type="file" id="fileCSVUsuarioFlota" name="fileCSVUsuarioFlota">
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" class="btn btn-success"><i class="mdi mdi-content-save"></i> Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>

<?= $this->section('js'); ?>
<script>
$(function () {
    
});


		</script>
<?php $this->endSection(); ?>