<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $breadcrumb_alias ?></h5>
                            <div>
								<a href="<?= $baseUrl.'/'.$previo ?>" class="btn px-2 py-0" style="border-radius: 45%; background-color: red;"><i class="mdi mdi-arrow-left-circle" style="font-size: 24px; color: #FFF"></i></a>
                            </div>
                        </div>
						<div class="card-body">
						    <?php
							if (in_array("ASUSGT", $permisos)) 
							{
							?>
							<div class="row col-12 m-0 mb-3 p-3 bg-sistema-25" style="border-radius: 20px;">
                                <div class="col-xxl-9 col-md-12 col-12 mb-3">
                                    <div>
                                        <label for="txtUsuarioAsociarGrupoTrabajo" class="form-label">Usuario</label>
                                        <select class="form-select" aria-label="Delegacion" id="txtUsuarioAsociarGrupoTrabajo" name="txtUsuarioAsociarGrupoTrabajo">
                                            <option selected="" value="">Seleccione una opcion</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-xxl-3 col-md-12 col-12 mb-3 d-flex flex-row-reverse align-items-center">
                                    <div>
                                        <button type="button" class="btn btn-success" id="btnAgregarUsuarioGrupoTrabajo" data-grupotrabajo="<?= $idGrupoTrabajo ?>">
                                        <i class="mdi mdi-plus-circle"></i> Agregar
                                    </button>
                                    </div>
                                </div>
                            </div>
							<?php
							}
							?>
							<table id="tblUsuariosGrupoTrabajo" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">

							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> - Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>

<?= $this->section('js'); ?>
<script>
        $(function () {
            var idGrupoTrabajoSeleccionado = <?= $idGrupoTrabajo ?>; // Almacena el ID del grupo de trabajo seleccionado
        console.log(idGrupoTrabajoSeleccionado);
            // Inicializaci贸n del DataTable
            const dt = $('#tblUsuariosGrupoTrabajo').DataTable({
                "serverSide": true,
                "processing": true,
                "ajax": {
                    "url": baseUrl + "/listar-usuario-grupo-data-table",
                    "type": 'GET',
                    "data": function (d) {
                        d.idGrupoTrabajo = idGrupoTrabajoSeleccionado; // Pasar el ID del grupo de trabajo seleccionado
                    }
                },
                "columns": [
                    {"title": "Matr铆cula", "data": "Matricula", "class": "text-center", "searchable": true},
                    {"title": "Nombres", "data": "Nombres", "class": "text-center", "searchable": true},
                    {"title": "Apellidos", "data": "Apellidos", "class": "text-center", "searchable": true},
                    {"title": "Fecha Ingreso", "data": "Ingreso", "class": "text-center", "searchable": true},
                    {"title": "Fecha Cese", "data": "Cese", "class": "text-center", "searchable": true},
                    {"title": "Eliminar", "data": "Eliminar", "class": "text-center", "searchable": true}
                ],
                "lengthMenu": [[10, 25, 50], [10, 25, 50]],
                "responsive": true,
                "autoWidth": false,
                "aaSorting": [[1, 'asc']],
            });
        
            // dt.ajax.reload(null, false); // Recarga la tabla sin reiniciar la paginaci贸n
        });

</script>
<?php $this->endSection(); ?>

<!-- end main content-->
<?php $this->endSection(); ?>