<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $elementoSeleccionadoModulo ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $subtitulo ?></h5>
                            <div class="d-flex">
                                <?php
								if(in_array("CSVUCM", $permisos))
								{
								?>
                                <button type="button" class="btn bg-danger d-flex justify-content-center align-items-center mx-1 color-white" data-bs-toggle="modal" data-bs-target="#importarCSVUsuarioEstado" id="btnImportarCSVUsuariosEstado" data-toggle="tooltip" data-placement="top" title="Importar CSV de Cambio de Estado" aria-label="Importar CSV de Cambio de Estado">
									<i class="mdi mdi-file-upload me-1" style="font-size: 14px;"></i> Cambio de Estado
								</button>
								<?php
								}
								?>
								
                                <?php
								if(in_array("CSVUCU", $permisos))
								{
								?>
                                <button type="button" class="btn btn-info d-flex justify-content-center align-items-center mx-1 color-white" data-bs-toggle="modal" data-bs-target="#importarCSVUsuarioCU" data-toggle="tooltip" data-placement="top" title="Importar CSV Insertar/Actualizar a la vez" aria-label="Importar CSV Insertar/Actualizar a la vez">
									<i class="mdi mdi-file-upload mr-1" style="font-size: 14px;"></i> Insertar y Actualizar
								</button>
								<?php
								}
								?>
								
								<?php
								if(in_array("CSVUFL", $permisos))
								{
								?>
                                <button type="button" class="btn btn-info d-flex justify-content-center align-items-center mx-1 color-white" data-bs-toggle="modal" data-bs-target="#importarCSVUsuarioFlota" data-toggle="tooltip" data-placement="top" title="Importar CSV Información de Flota" aria-label="Importar CSV Información de Flota">
									<i class="mdi mdi-file-upload mr-1" style="font-size: 14px;"></i> Importar Flota
								</button>
								<?php
								}
								
								if(in_array("CSVITU", $permisos))
								{
								?>
                                <button type="button" class="btn btn-danger d-flex justify-content-center align-items-center mx-1 color-white" data-bs-toggle="modal" data-bs-target="#importarCSVUsuarioIT" data-toggle="tooltip" data-placement="top" title="Importar CSV Información de IT" aria-label="Importar CSV Información de IT">
									<i class="mdi mdi-file-upload mr-1" style="font-size: 14px;"></i> Importar IT
								</button>
								<?php
								}
								
								if(in_array("CSVUSU", $permisos))
								{
								?>
                                <button type="button" class="btn btn-info d-flex justify-content-center align-items-center mx-1 color-white" data-bs-toggle="modal" data-bs-target="#importarCSVUsuario" data-toggle="tooltip" data-placement="top" title="Importar CSV Usuarios" aria-label="Importar CSV Usuarios">
									<i class="mdi mdi-file-upload mr-1" style="font-size: 14px;"></i> Importar Usuarios
								</button>
								<?php
								}
								
								if (in_array("ADDUSU", $permisos)) 
								{
								?>
                                <button type="button" class="btn bg-sistema d-flex justify-content-center align-items-center mx-1 color-white datos-usuario" data-bs-target="#informacionUsuario" data-form="#formInformacionUsuario" data-id="0" data-accion="crear" id="crear-usuario" data-toggle="tooltip" data-placement="top" title="Registrar Usuario" aria-label="Registrar Usuario">
									<i class="mdi mdi-plus-circle me-1" style="font-size: 14px;"></i>Nuevo
								</button>
								<?php
								}
								?>
								<button type="button" class="btn bg-filtros color-white px-2 py-1 mx-1 waves-effect waves-light layout-rightside-btn" data-bs-toggle="offcanvas" data-bs-target="#theme-settings-offcanvas" aria-controls="theme-settings-offcanvas">
                                    <i class="mdi mdi-filter" style="font-size: 18px;"></i>
                                </button>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblUsuarios" class="table table-bordered nowrap table-striped align-middle" style="width:100%">
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->

<?= $this->section('js'); ?>
<script>
	$(function () {
		/***SERVERSIDE USUARIOS***/
		assetListVM = {
			dt: null,
			init: function () {
				dt = $('#tblUsuarios').DataTable({
					"serverSide": true,
					"processing": true,
					"ajax": {
						"url": baseUrl + "/usuarios-serverside",
						type: 'POST',
						data: function(d) {
						    let rutavista = window.location.href;
						    let arrayrutavista = rutavista.split("/");
						    d.url_vista = arrayrutavista[arrayrutavista.length-1];
						}
					},
					"columns": [
						{"title": "Código", "data": "IdUsuario", "class": "text-center", "searchable": true },
						{"title": "Nombre y Apellido", "data": "NombreUsuario", "class": "text-center", "searchable": true },
						{"title": "Matrícula", "data": "Matricula", "class": "text-center", "searchable": true },
						{"title": "Documento de Identidad", "data": "NumeroDoc", "class": "text-center", "searchable": true },
						{"title": "Perfil", "data": "Perfil", "class": "text-center", "searchable": true },
						{"title": "Usuario", "data": "Usuario", "class": "text-center", "searchable": true },
						{"title": "Sistemas", "data": "Sistemas", "class": "text-center", "searchable": true },
						{"title": "Estado", "data": "EstadoUsuario", "class": 'text-center'},
						{"title":"Acciones", "data": "acciones", "class": 'text-center'},
					],
                    "drawCallback": function(settings) {
                        // Re-inicializar tooltips después de que los datos son cargados
                        $('[data-tooltip="tooltip"]').tooltip();
                        $('[data-toggle="tooltip"]').tooltip();
                    },
					"lengthMenu": [[10, 25, 50], [10, 25, 50]],
					responsive: true,
					autoWidth: false,
					"pageLength": 10,
					"paging": true,
					"aaSorting": [[0, 'desc']],
				});
			}
		}

		assetListVM.init();
		/****FIN SERVERSIDE USUARIOS****/
		
        $('#txtTipoDocumentoUsuario_i').select2({
            dropdownParent: $('#informacionUsuario .modal-body')
        });
        
        $('#txtTipoUsuario_i').select2({
            dropdownParent: $('#informacionUsuario .modal-body')
        });
        
        /**********************************************************************/
        
        pondImportarCSVUsuario = FilePond.create(
            document.querySelector("#fileCSVUsuario"), {
                labelIdle: 'Arrastre y suelte el archivo a subir o <span class="filepond--label-action">explore</span>',
                allowMultiple: false,
                instantUpload: false,
                allowProcess: false,
                acceptedFileTypes: ['text/csv'],
                onaddfile: (file) => {
                    console.log(file);
                    // Validación manual por extensión
                    const allowedExtensions = /(\.csv)$/i;
                    
                    if (!allowedExtensions.exec(file.name))
                    {
                        Swal.fire({
                            text: "El formato del archivo debe ser CSV.",
                            icon: 'warning',
                            showCancelButton: false,
                            cancelButtonText: 'No',
                            confirmButtonColor: '#282e38',
                            confirmButtonText: 'OK'
                        });
                        // Remover el archivo
                        pondImportarCSVUsuario.removeFile(file.id);
                        return false; // Detener el envío del archivo
                    }
                    return true; // Permitir el archivo
                }
            }
        );
        
        pondImportarCSVUsuarioIT = FilePond.create(
            document.querySelector("#fileCSVUsuarioIT"), {
                labelIdle: 'Arrastre y suelte el archivo a subir o <span class="filepond--label-action">explore</span>',
                allowMultiple: false,
                instantUpload: false,
                allowProcess: false,
                acceptedFileTypes: ['text/csv'],
                onaddfile: (file) => {
                    console.log(file);
                    // Validación manual por extensión
                    const allowedExtensions = /(\.csv)$/i;
                    
                    if (!allowedExtensions.exec(file.name))
                    {
                        Swal.fire({
                            text: "El formato del archivo debe ser CSV.",
                            icon: 'warning',
                            showCancelButton: false,
                            cancelButtonText: 'No',
                            confirmButtonColor: '#282e38',
                            confirmButtonText: 'OK'
                        });
                        // Remover el archivo
                        pondImportarCSVUsuarioIT.removeFile(file.id);
                        return false; // Detener el envío del archivo
                    }
                    return true; // Permitir el archivo
                }
            }
        );
        
        pondImportarCSVUsuarioFlota = FilePond.create(
            document.querySelector("#fileCSVUsuarioFlota"), {
                labelIdle: 'Arrastre y suelte el archivo a subir o <span class="filepond--label-action">explore</span>',
                allowMultiple: false,
                instantUpload: false,
                allowProcess: false,
                acceptedFileTypes: ['text/csv'],
                onaddfile: (file) => {
                    console.log(file);
                    // Validación manual por extensión
                    const allowedExtensions = /(\.csv)$/i;
                    
                    if (!allowedExtensions.exec(file.name))
                    {
                        Swal.fire({
                            text: "El formato del archivo debe ser CSV.",
                            icon: 'warning',
                            showCancelButton: false,
                            cancelButtonText: 'No',
                            confirmButtonColor: '#282e38',
                            confirmButtonText: 'OK'
                        });
                        // Remover el archivo
                        pondImportarCSVUsuarioFlota.removeFile(file.id);
                        return false; // Detener el envío del archivo
                    }
                    return true; // Permitir el archivo
                }
            }
        );
        
        pondImportCSVUsuariosEstado = FilePond.create(
            document.querySelector("#fileCSVUsuarioCambioEstado"), {
                labelIdle: 'Arrastre y suelte el archivo a subir o <span class="filepond--label-action">explore</span>',
                allowMultiple: false,
                instantUpload: false,
                allowProcess: false,
                acceptedFileTypes: ['text/csv'],
                onaddfile: (file) => {
                    console.log(file);
                    // Validación manual por extensión
                    const allowedExtensions = /(\.csv)$/i;
                    
                    if (!allowedExtensions.exec(file.name))
                    {
                        Swal.fire({
                            text: "El formato del archivo debe ser CSV.",
                            icon: 'warning',
                            showCancelButton: false,
                            cancelButtonText: 'No',
                            confirmButtonColor: '#282e38',
                            confirmButtonText: 'OK'
                        });
                        // Remover el archivo
                        pondImportCSVUsuariosEstado.removeFile(file.id);
                        return false; // Detener el envío del archivo
                    }
                    return true; // Permitir el archivo
                }
            }
        );
        
	});
	
    
	
	
</script>
<?php $this->endSection(); ?>

<!-- Filtros -->
<div class="offcanvas offcanvas-end border-0" tabindex="-1" id="theme-settings-offcanvas" aria-modal="true" role="dialog">
    <div class="d-flex align-items-center bg-filtros bg-gradient p-3 offcanvas-header">
        <h5 class="m-0 me-2 text-white">Filtros</h5>

        <button type="button" class="btn-close btn-close-white ms-auto" id="customizerclose-btn" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body p-0">
        <!--<div data-simplebar="init" class="h-100 simplebar-scrollable-y">-->
        <!--    <div class="simplebar-wrapper" style="margin: 0px;">-->
        <!--        <div class="simplebar-height-auto-observer-wrapper">-->
        <!--            <div class="simplebar-height-auto-observer">-->
                        
        <!--            </div>-->
        <!--        </div>-->
        <!--        <div class="simplebar-mask">-->
        <!--            <div class="simplebar-offset" style="right: 0px; bottom: 0px;">-->
        <!--                <div class="simplebar-content-wrapper" tabindex="0" role="region" aria-label="scrollable content" style="height: 100%; overflow: hidden scroll;">-->
        <!--                    <div class="simplebar-content" style="padding: 0px;">-->
            <div id="ctnFiltro" class="p-3">
				<div class="card border" style="border-top: 3px #536878 solid!important;">
					<div class="card-header">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <h6 class="card-title mb-0">Columnas</h6>
                            </div>
                            <div class="flex-shrink-0">
                                <ul class="list-inline card-toolbar-menu d-flex align-items-center mb-0">
                                    <li class="list-inline-item">
                                        <a class="align-middle minimize-card" data-bs-toggle="collapse" href="#collapseColumnasFiltros" role="button" aria-expanded="true" aria-controls="collapseColumnasFiltros">
                                            <i class="mdi mdi-plus align-middle plus"></i>
                                            <i class="mdi mdi-minus align-middle minus"></i>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
					<div class="card-body collapse show" id="collapseColumnasFiltros" style="">
						cxcvcxxvxcxcv
					</div>
				</div>
				<div class="panel">
                    <div class="panel-heading">
                        <h4>Columnas</h4>
                    </div>
                    <div class="panel-content">
                        <div class="row">
                            adasasads
                        </div>
                    </div>
                </div>
            </div>
        <!--                    </div>-->
        <!--                </div>-->
        <!--            </div>-->
        <!--        </div>-->
        <!--        <div class="simplebar-placeholder" style="width: 400px; height: 1978px;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--    <div class="simplebar-track simplebar-horizontal" style="visibility: hidden;">-->
        <!--        <div class="simplebar-scrollbar" style="width: 0px; display: none;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--    <div class="simplebar-track simplebar-vertical" style="visibility: visible;">-->
        <!--        <div class="simplebar-scrollbar" style="height: 314px; transform: translate3d(0px, 0px, 0px); display: block;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--</div>-->
    </div>
    <div class="offcanvas-footer border-top p-3 text-center">
        <div class="row">
            <div class="col-4">
                <button type="button" class="btn btn-light w-100" id="btnLimpiar">Limpiar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-danger w-100" id="btnCerrarFiltros" data-bs-dismiss="offcanvas" aria-label="Close">Cerrar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-primary w-100" id="btnBuscarFiltros">Buscar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Información Usuario -->
<div class="modal fade zoomIn" id="informacionUsuario" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionUsuario" aria-hidden="true">
	<div class="modal-dialog modal-xl modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleinformacionUsuario">Información de usuario</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formInformacionUsuario" class="formulario" autocomplete="off" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body row d-flex m-0">
					<input type="hidden" id="txtIDUsuario_i" name="txtIDUsuario_i">
					<div class="row col-12 m-0 p-0 mb-3 d-flex">
					    <div class="col-xxl-4 col-md-12 col-12 px-3">
							<label for="txtMatriculaUsuario_i" class="form-label">Matrícula</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Matrícula" id="txtMatriculaUsuario_i" name="txtMatriculaUsuario_i">
							</div>
						</div>
					    <div class="col-xxl-4 col-md-12 col-12 px-3">
							<label for="txtNombresUsuario_i" class="form-label">Nombres</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Nombres" id="txtNombresUsuario_i" name="txtNombresUsuario_i">
							</div>
						</div>
					    <div class="col-xxl-4 col-md-12 col-12 px-3">
							<label for="txtApellidosUsuario_i" class="form-label">Apellidos</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Apellidos" id="txtApellidosUsuario_i" name="txtApellidosUsuario_i">
							</div>
						</div>
					</div>
					<div class="row col-12 m-0 p-0 mb-3 d-flex">
					    <div class="col-xxl-4 col-md-12 col-12 px-3">
							<div>
								<label for="txtTipoDocumentoUsuario_i" class="form-label">Tipo Documento</label>
								<select class="form-select" aria-label="Tipo de Documento" id="txtTipoDocumentoUsuario_i" name="txtTipoDocumentoUsuario_i" data-modal="#informacionUsuario">
								    <option value="">Seleccione Tipo Documento</option>
									<option value="DNI">DNI</option>
									<option value="CE">CE</option>
								</select>
							</div>
						</div>
					    <div class="col-xxl-4 col-md-12 col-12 px-3">
							<label for="txtDocumentoUsuario_i" class="form-label">Documento</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Documento" id="txtDocumentoUsuario_i" name="txtDocumentoUsuario_i">
							</div>
						</div>
					    <div class="col-xxl-4 col-md-12 col-12 px-3">
							<div>
								<label for="txtCargoUsuario_i" class="form-label">Cargo</label>
								<select class="form-select select2-dinamico" aria-label="Cargo" id="txtCargoUsuario_i" name="txtCargoUsuario_i" data-modal="#informacionUsuario">
									<option value="">Seleccione una opción</option>
									
								</select>
							</div>
						</div>
					</div>
					<div class="row col-12 m-0 p-0 mb-3 d-flex">
					    <div class="col-xxl-4 col-md-12 col-12 px-3">
							<div>
								<label for="txtManagerUsuario_i" class="form-label">Jefe Directo</label>
								<select class="form-select select2-dinamico" aria-label="Jefe Directo" id="txtManagerUsuario_i" name="txtManagerUsuario_i" data-modal="#informacionUsuario">
									<option value="">Seleccione una opción</option>
									
								</select>
							</div>
						</div>
					    <div class="col-xxl-4 col-md-12 col-12 px-3">
							<label for="txtFechaIngresoUsuario_i" class="form-label">Fecha Ingreso</label>
							<div class="input-group">
								<input type="date" class="form-control" aria-label="Fecha de Ingreso" id="txtFechaIngresoUsuario_i" name="txtFechaIngresoUsuario_i">
							</div>
						</div>
					    <div class="col-xxl-4 col-md-12 col-12 px-3">
							<label for="txtFTEUsuario_i" class="form-label">FTE</label>
							<div class="input-group">
								<input type="number" step="0.01" class="form-control" aria-label="FTE" id="txtFTEUsuario_i" name="txtFTEUsuario_i">
							</div>
						</div>
					</div>
					<div class="row col-12 m-0 p-0 mb-3 d-flex">
					    <div class="col-xxl-4 col-md-12 col-12 px-3">
							<div>
								<label for="txtDireccionEstrucUsuario_i" class="form-label">Dirección</label>
								<select class="form-select select2-dinamico" aria-label="Dirección" id="txtDireccionEstrucUsuario_i" name="txtDireccionEstrucUsuario_i" data-modal="#informacionUsuario">
									<option value="">Seleccione una opción</option>
									
								</select>
							</div>
						</div>
					    <div class="col-xxl-4 col-md-12 col-12 px-3">
							<div>
								<label for="txtAreaEstrucUsuario_i" class="form-label">Área</label>
								<select class="form-select select2-dinamico" aria-label="Área" id="txtAreaEstrucUsuario_i" name="txtAreaEstrucUsuario_i" data-modal="#informacionUsuario">
									<option value="">Seleccione una opción</option>
									
								</select>
							</div>
						</div>
					    <div class="col-xxl-4 col-md-12 col-12 px-3">
							<div>
								<label for="txtSubareaEstrucUsuario_i" class="form-label">Subárea</label>
								<select class="form-select select2-dinamico" aria-label="Subárea" id="txtSubareaEstrucUsuario_i" name="txtSubareaEstrucUsuario_i" data-modal="#informacionUsuario">
									<option value="">Seleccione una opción</option>
									
								</select>
							</div>
						</div>
					</div>
					<div class="row col-12 m-0 p-0 mb-3 d-flex">
					    <div class="col-xxl-4 col-md-12 col-12 px-3">
							<div>
								<label for="txtDelegacionSubareaEstrucUsuario_i" class="form-label">CC - LN | Delegacion</label>
								<select class="form-select select2-dinamico" aria-label="CC-LN" id="txtDelegacionSubareaEstrucUsuario_i" name="txtDelegacionSubareaEstrucUsuario_i" data-modal="#informacionUsuario">
									<option value="">Seleccione una opción</option>
									
								</select>
							</div>
						</div>
					    <div class="col-xxl-4 col-md-12 col-12 px-3">
							<label for="txtCorreoUsuario_i" class="form-label">Correo Corporativo</label>
							<div class="input-group">
								<input type="email" class="form-control" aria-label="Correo Corporativo" id="txtCorreoUsuario_i" name="txtCorreoUsuario_i">
							</div>
						</div>
					    <div class="col-xxl-4 col-md-12 col-12 px-3">
							<label for="txtUsuarioIngreso_i" class="form-label">Usuario</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Usuario de Ingreso" id="txtUsuarioIngreso_i" name="txtUsuarioIngreso_i">
							</div>
						</div>
					</div>
					<div class="row col-12 m-0 p-0 mb-3 d-flex">
					    <div class="col-xxl-4 col-md-12 col-12 px-3">
							<div>
								<label for="txtTipoUsuario_i" class="form-label">Tipo de Usuario</label>
								<select class="form-select" aria-label="Tipo de Usuario" id="txtTipoUsuario_i" name="txtTipoUsuario_i" data-modal="#informacionUsuario">
								    <option value="">Seleccione Tipo de Usuario</option>
									<option value="STAFF">STAFF</option>
									<option value="OPERADOR">OPERADOR</option>
									<option value="TECNICO">TECNICO</option>
									<option value="CODIR">CODIR</option>
								</select>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-center align-items-center color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" id="btnEjecutarUsuario" class="btn bg-success d-flex justify-content-center align-items-center color-white"><i class="mdi mdi-content-save mx-1" style="font-size: 14px;"></i>Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<!-- end main content-->

<!-- Modal Importar Usuarios -->
<div class="modal fade zoomIn" id="importarCSVUsuario" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleimportarCSVUsuario" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleimportarCSVUsuario">Importar CSV de Usuarios</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formularioImportarCSVUsuario" id="formImportarCSVUsuario" autocomplete="off" action="<?= $baseUrl ?>/importar-csv-usuario" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="row modal-body">
					<div class="col-12 mb-3">
						<h4>Consideraciones:</h4>
						<ol>
						    <li>Información de columna [TIPO DE DOCUMENTO]: [DNI, CE]</li>
						</ol>
						<ul>
						    <li style="color: blue;">Las fechas deben contar con el formato "YYYY-MM-DD".</li>
						    <li style="color: blue;">Evitar espacios en blanco al inicio y al final del campo</li>
						    <li style="color: red;">Si tiene fecha cese, se va a cambiar el estado del usuario a "Cesado".</li>
						</ul>
					</div>
					<hr>
					<h4 class="mb-3">Plantillas:</h4>
					<div class="row col-12 m-0 p-0">
					    <?php
						if(in_array("EXPUSU", $permisos))
						{
						?>
					    <div class="col-lg-6 col-12 d-flex justify-content-center align-items-center">
					        <div class="card card-light">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-shrink-0">
                                            <span class="mdi mdi-download color-sistema" style="font-size: 48px;"></span>
                                        </div>
                                        <div class="flex-grow-1 ms-3">
                                            <p class="card-text">Si desea descargar la <strong class="fw-medium">Base de Usuarios</strong> presione el enlace de abajo.</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <div class="text-center">
                                        <a onclick="return descargarTotalUsuarios();" class="text-body" style="cursor: pointer;">Descargar Información <i class="ri-arrow-right-s-line align-middle lh-1"></i></a>
                                    </div>
                                </div>
                            </div>
					    </div>
					    <?php
						}
						?>
					    <div class="col-lg-6 col-12 d-flex justify-content-center align-items-center">
					        <div class="card card-light">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-shrink-0">
                                            <span class="mdi mdi-download color-sistema" style="font-size: 48px;"></span>
                                        </div>
                                        <div class="flex-grow-1 ms-3">
                                            <p class="card-text">Si desea descargar la <strong class="fw-medium">Plantilla de Importación de Usuarios</strong> presione el enlace de abajo.</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <div class="text-center">
                                        <a class="text-body" href='<?= base_url().'/public/docs/Plantillas/plantilla csv usuarios.csv' ?>' download='Plantilla CSV Usuarios'>Descargar Plantilla <i class="ri-arrow-right-s-line align-middle lh-1"></i></a>
                                    </div>
                                </div>
                            </div>
					    </div>
					</div>
					<hr>
    				<h4 class="mb-3">Importar archivo:</h4>
					<div class="col-12 mb-0 d-flex justify-content-center">
					    <div class="col-7 m-0 p-0">
					        <input type="file" id="fileCSVUsuario" class="filepond" name="fileCSVUsuario" data-max-file-size="100MB" data-max-files="1" />
					    </div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-center align-items-center color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" class="btn bg-success d-flex justify-content-center align-items-center color-white"><i class="mdi mdi-import mx-1" style="font-size: 14px;"></i>Importar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Modal Importar Usuarios IT-->
<div class="modal fade zoomIn" id="importarCSVUsuarioIT" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleimportarCSVUsuarioIT" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleimportarCSVUsuarioIT">Actualizar Correo y Usuario - Soporte IT</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formularioImportarCSVUsuarioIT" id="formImportarCSVUsuarioIT" autocomplete="off" action="<?= $baseUrl ?>/importar-csv-usuario-it" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="row modal-body">
					<div class="col-12 mb-3">
						<h4>Consideraciones:</h4>
						<ul>
						    <li style="color: blue;">El campo MATRÍCULA es obligatorio.</li>
						    <li style="color: blue;">El campo USUARIO es obligatorio.</li>
						    <li style="color: red;">El correo se genera automáticamente de la siguiente forma: {campo USUARIO}@verisure.pe.</li>
						</ul>
					</div>
					<hr>
					<h4 class="mb-3">Plantillas:</h4>
					<div class="row col-12 m-0 p-0">
					    <?php
						if(in_array("EXPUSU", $permisos))
						{
						?>
					    <div class="col-lg-6 col-12 d-flex justify-content-center align-items-center">
					        <div class="card card-light">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-shrink-0">
                                            <span class="mdi mdi-download color-sistema" style="font-size: 48px;"></span>
                                        </div>
                                        <div class="flex-grow-1 ms-3">
                                            <p class="card-text">Si desea descargar la <strong class="fw-medium">Base de Usuarios Sin Correos</strong> presione el enlace de abajo.</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <div class="text-center">
                                        <a onclick="return descargarUsuariosSinCorreo();" class="text-body" style="cursor: pointer;">Descargar Información <i class="ri-arrow-right-s-line align-middle lh-1"></i></a>
                                    </div>
                                </div>
                            </div>
					    </div>
					    <?php
						}
						?>
					    <div class="col-lg-6 col-12 d-flex justify-content-center align-items-center">
					        <div class="card card-light">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-shrink-0">
                                            <span class="mdi mdi-download color-sistema" style="font-size: 48px;"></span>
                                        </div>
                                        <div class="flex-grow-1 ms-3">
                                            <p class="card-text">Si desea descargar la <strong class="fw-medium">Plantilla de Importación de Usuarios IT</strong> presione el enlace de abajo.</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <div class="text-center">
                                        <a class="text-body" href='<?= base_url().'/public/docs/Plantillas/plantilla csv usuarios it.csv' ?>' download='Plantilla CSV Usuarios IT'>Descargar Plantilla <i class="ri-arrow-right-s-line align-middle lh-1"></i></a>
                                    </div>
                                </div>
                            </div>
					    </div>
					</div>
					<hr>
    				<h4 class="mb-3">Importar archivo:</h4>
					<div class="col-12 mb-0 d-flex justify-content-center">
					    <div class="col-7 m-0 p-0">
					        <input type="file" id="fileCSVUsuarioIT" class="filepond" name="fileCSVUsuarioIT" data-max-file-size="100MB" data-max-files="1" />
					    </div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-center align-items-center color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" class="btn bg-success d-flex justify-content-center align-items-center color-white"><i class="mdi mdi-import mx-1" style="font-size: 14px;"></i>Importar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Modal Importar Usuarios Flota-->
<div class="modal fade zoomIn" id="importarCSVUsuarioFlota" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleimportarCSVUsuarioFlota" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleimportarCSVUsuarioFlota">Actualizar Placa y Brevete - Flota</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formularioImportarCSVUsuarioFlota" id="formImportarCSVUsuarioFlota" autocomplete="off" action="<?= $baseUrl ?>/importar-csv-usuario-flota" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="col-12 mb-3">
						<h4>Consideraciones:</h4>
						<ul>
						    <li style="color: blue;">El campo BREVETE es obligatorio.</li>
						    <li style="color: blue;">El campo PLACA es obligatorio, sin guión.</li>
						</ul>
					</div>
					<hr>
					<h4 class="mb-3">Plantillas:</h4>
					<div class="row col-12 m-0 p-0 d-flex justify-content-center align-items-center">
					    <div class="col-lg-8 col-12 d-flex justify-content-center align-items-center">
					        <div class="card card-light">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-shrink-0">
                                            <span class="mdi mdi-download color-sistema" style="font-size: 48px;"></span>
                                        </div>
                                        <div class="flex-grow-1 ms-3">
                                            <p class="card-text">Si desea descargar la <strong class="fw-medium">Plantilla de Importación de Usuarios Flota</strong> presione el enlace de abajo.</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <div class="text-center">
                                        <a class="text-body" href='<?= base_url().'/public/docs/Plantillas/plantilla csv usuarios flota.csv' ?>' download='Plantilla CSV Usuarios Flota'>Descargar Plantilla <i class="ri-arrow-right-s-line align-middle lh-1"></i></a>
                                    </div>
                                </div>
                            </div>
					    </div>
					</div>
					<hr>
    				<h4 class="mb-3">Importar archivo:</h4>
					<div class="col-12 mb-0 d-flex justify-content-center">
					    <div class="col-7 m-0 p-0">
					        <input type="file" id="fileCSVUsuarioFlota" class="filepond" name="fileCSVUsuarioFlota" data-max-file-size="100MB" data-max-files="1" />
					    </div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-center align-items-center color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" class="btn bg-success d-flex justify-content-center align-items-center color-white"><i class="mdi mdi-import mx-1" style="font-size: 14px;"></i>Importar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Modal Importar Usuarios Cesados -->
<div class="modal fade zoomIn" id="importarCSVUsuarioEstado" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleimportarCSVUsuarioEstado" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h4 class="modal-title color-white" id="exampleimportarCSVUsuarioEstado">Actualizar Usuarios | Cambios de Estado</h4>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formularioImportarCambioEstadoUsuario" id="formImportarCambioEstadoUsuario" autocomplete="off" action="<?= $baseUrl ?>/importar-csv-cambio-estado-usuario" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="col-12 mb-3">
						<h4>Consideraciones:</h4>
						<ol>
						    <li>Información de columna [ESTADO]: [Activo, Cesado]</li>
						    <li class="text-danger mb-0">Si el estado es Activo, solo se requiere la fecha de ingreso y el motivo.</li>
						    <li class="text-danger mb-0">Si el estado es Cesado, solo se requiere la fecha de cese y el motivo.</li>
						</ol>
					</div>
    				<hr>
    				<h4 class="mb-3">Plantillas:</h4>
					<div class="row col-12 m-0 p-0">
					    <div class="col-lg-12 col-12 d-flex justify-content-center align-items-center">
					        <div class="card card-light">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-shrink-0">
                                            <span class="mdi mdi-download color-sistema" style="font-size: 48px;"></span>
                                        </div>
                                        <div class="flex-grow-1 ms-3">
                                            <p class="card-text">Si desea descargar la <strong class="fw-medium">Plantilla de Importación de Cambios de Estado</strong> presione el enlace de abajo.</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <div class="text-center">
                                        <a class="text-body" href='<?= base_url().'/public/docs/Plantillas/plantilla csv usuarios cambio estado.csv' ?>' download='Plantilla CSV Cambio Estado Usuarios'>Descargar Plantilla <i class="ri-arrow-right-s-line align-middle lh-1"></i></a>
                                    </div>
                                </div>
                            </div>
					    </div>
					</div>
    				<hr>
    				<h4 class="mb-3">Importar archivo:</h4>
					<div class="col-12 mb-0 d-flex justify-content-center">
					    <div class="col-12 m-0 p-0">
					        <input type="file" id="fileCSVUsuarioCambioEstado" class="filepond" name="fileCSVUsuarioCambioEstado" data-max-file-size="100MB" data-max-files="1" />
					    </div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-end align-items-center color-white" data-bs-dismiss="modal"><span class="mdi mdi-close-thick me-2" style="font-size: 14px;"></span>Cerrar</button>
					<button type="submit" class="btn bg-success d-flex justify-content-end align-items-center color-white"><i class="mdi mdi-content-save me-2 color-white" style="font-size: 14px;"></i>Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<?php $this->endSection(); ?>