<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $elementoSeleccionadoModulo ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $subtitulo ?></h5>
                            <div class="d-flex">
								<?php
								if (in_array("ADDSIS", $permisos)) 
								{
								?>
                                <button class="btn bg-sistema d-flex justify-content-center align-items-center mx-1 color-white datos-sistema" data-bs-target="#informacionSistema" data-form="#formInformacionSistema" data-id="0" data-accion="crear" id="crear-sistema" data-toggle="tooltip" data-placement="top" title="Registrar Nuevo Sistema" aria-label="Registrar Nuevo Sistema">
									<i class="mdi mdi-plus-circle me-1" style="font-size: 14px;"></i>Nuevo
								</button>
								<?php
								}
								?>
								<button type="button" class="btn bg-filtros color-white px-2 py-1 mx-1 waves-effect waves-light layout-rightside-btn" data-bs-toggle="offcanvas" data-bs-target="#theme-settings-offcanvas" aria-controls="theme-settings-offcanvas">
                                    <i class="mdi mdi-filter" style="font-size: 18px;"></i>
                                </button>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblSistemas" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								<thead>
									<tr>
										<th class="text-center align-middle">Código</th>
										<th class="text-center align-middle">Sistema</th>
										<th class="text-center align-middle">Subdominio</th>
										<th class="text-center align-middle">Dominio</th>
										<th class="text-center align-middle">Subcarpeta</th>
										<th class="text-center align-middle">Observación</th>
										<th class="text-center align-middle">Estado</th>
										<th class="text-center align-middle">Acciones</th>
									</tr>
								</thead>
								<tbody>
									<?php foreach($listadoSistemas as $items){ ?>
									<tr>
										<td class="text-center align-middle"><?= $items['IDSistema'] ?></td>
										<td class="text-center align-middle"><?= $items['Sistema'] ?></td>
										<td class="text-center align-middle"><?= $items['Subdominio'] ?></td>
										<td class="text-center align-middle"><?= $items['Dominio'] ?></td>
										<td class="text-center align-middle"><?= $items['Subcarpeta'] ?></td>
										<td class="text-center align-middle"><?= $items['Observacion'] ?></td>
										<td class="text-center align-middle">
											<?php
											if (in_array("ESTSIS", $permisos)) 
											{
											?>
											<button class="badge <?= $items['Estado'] == 'A' ? 'bg-success' : 'bg-warning' ?> border-0 cambiar-estado-sistema" data-estado="<?= $items['Estado'] ?>" data-id="<?= $items['IDSistema'] ?>">
												<?= $items['Estado'] == 'A' ? 'ACTIVO' : 'INACTIVO' ?>
											</button>
											<?php
											}
											else
											{
											?>
											<span class="badge <?= $items['Estado'] == 'A' ? 'bg-success' : 'bg-warning' ?> border-0">
												<?= $items['Estado'] == 'A' ? 'ACTIVO' : 'INACTIVO' ?>
											</span>
											<?php
											}
											?>
										</td>
										<td class="text-center align-middle">
										    <button class="badge bg-info border-0 p-2 mx-1 datos-sistema" data-bs-target="#informacionSistema" data-form="#formInformacionSistema" data-id="<?= $items['IDSistema'] ?>" data-accion="ver" id="ver-sistema" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" title="Ver Información Sistema" aria-label="Ver Información Sistema">
                                				<i class="mdi mdi-eye align-bottom" style="font-size: 20px; color: #FFF;"></i>
                                			</button>
										    <?php
											if (in_array("UPDSIS", $permisos)) 
											{
											?>
											<button class="badge bg-warning border-0 p-2 mx-1 datos-sistema" data-bs-target="#informacionSistema" data-form="#formInformacionSistema" data-id="<?= $items['IDSistema'] ?>" data-accion="editar" id="editar-sistema" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" title="Editar Información Sistema" aria-label="Editar Información Sistema">
											    <i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i>
											</button>
											<?php
											}
											?>
										</td>
									</tr>
									<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->

<!-- Filtros -->
<div class="offcanvas offcanvas-end border-0" tabindex="-1" id="theme-settings-offcanvas" aria-modal="true" role="dialog">
    <div class="d-flex align-items-center bg-filtros bg-gradient p-3 offcanvas-header">
        <h5 class="m-0 me-2 text-white">Filtros</h5>

        <button type="button" class="btn-close btn-close-white ms-auto" id="customizerclose-btn" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body p-0">
        <!--<div data-simplebar="init" class="h-100 simplebar-scrollable-y">-->
        <!--    <div class="simplebar-wrapper" style="margin: 0px;">-->
        <!--        <div class="simplebar-height-auto-observer-wrapper">-->
        <!--            <div class="simplebar-height-auto-observer">-->
                        
        <!--            </div>-->
        <!--        </div>-->
        <!--        <div class="simplebar-mask">-->
        <!--            <div class="simplebar-offset" style="right: 0px; bottom: 0px;">-->
        <!--                <div class="simplebar-content-wrapper" tabindex="0" role="region" aria-label="scrollable content" style="height: 100%; overflow: hidden scroll;">-->
        <!--                    <div class="simplebar-content" style="padding: 0px;">-->
            <div id="ctnFiltro" class="p-3">
				<div class="card border" style="border-top: 3px #536878 solid!important;">
					<div class="card-header">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <h6 class="card-title mb-0">Columnas</h6>
                            </div>
                            <div class="flex-shrink-0">
                                <ul class="list-inline card-toolbar-menu d-flex align-items-center mb-0">
                                    <li class="list-inline-item">
                                        <a class="align-middle minimize-card" data-bs-toggle="collapse" href="#collapseColumnasFiltros" role="button" aria-expanded="true" aria-controls="collapseColumnasFiltros">
                                            <i class="mdi mdi-plus align-middle plus"></i>
                                            <i class="mdi mdi-minus align-middle minus"></i>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
					<div class="card-body collapse show" id="collapseColumnasFiltros" style="">
						cxcvcxxvxcxcv
					</div>
				</div>
				<div class="panel">
                    <div class="panel-heading">
                        <h4>Columnas</h4>
                    </div>
                    <div class="panel-content">
                        <div class="row">
                            adasasads
                        </div>
                    </div>
                </div>
            </div>
        <!--                    </div>-->
        <!--                </div>-->
        <!--            </div>-->
        <!--        </div>-->
        <!--        <div class="simplebar-placeholder" style="width: 400px; height: 1978px;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--    <div class="simplebar-track simplebar-horizontal" style="visibility: hidden;">-->
        <!--        <div class="simplebar-scrollbar" style="width: 0px; display: none;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--    <div class="simplebar-track simplebar-vertical" style="visibility: visible;">-->
        <!--        <div class="simplebar-scrollbar" style="height: 314px; transform: translate3d(0px, 0px, 0px); display: block;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--</div>-->
    </div>
    <div class="offcanvas-footer border-top p-3 text-center">
        <div class="row">
            <div class="col-4">
                <button type="button" class="btn btn-light w-100" id="btnLimpiar">Limpiar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-danger w-100" id="btnCerrarFiltros" data-bs-dismiss="offcanvas" aria-label="Close">Cerrar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-primary w-100" id="btnBuscarFiltros">Buscar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Información Sistema -->
<div class="modal fade zoomIn" id="informacionSistema" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionSistema" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleinformacionSistema">Información de Sistema</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formInformacionSistema" class="formulario" autocomplete="off" action="" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtIDSistema_i" name="txtIDSistema_i">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtSistema_i" class="form-label">Nombre</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Nombre Sistema" id="txtSistema_i" name="txtSistema_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtDominioSistema_i" class="form-label">Dominio</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Dominio" placeholder="verismart.com.pe" id="txtDominioSistema_i" name="txtDominioSistema_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtSubdominioSistema_i" class="form-label">Subdominio</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Subdominio" placeholder="activos" id="txtSubdominioSistema_i" name="txtSubdominioSistema_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtSubcarpetaSistema_i" class="form-label">Subcarpeta</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Dominio" placeholder="landing" id="txtSubcarpetaSistema_i" name="txtSubcarpetaSistema_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtObservacion_i" class="form-label">Observación</label>
								<textarea class="form-control" id="txtObservacion_i" name="txtObservacion_i" rows="4"></textarea>
							</div>
						</div>
						<div class="col-12 mb-4 justify-content-center">
							<div class="col-xxl-12 col-md-12 col-12 border-sistema-2px p-2 d-flex justify-content-between align-items-center" style="border-radius: 15px;">
    						    <h5 class="color-sistema m-0" for="chkURLExterno">¿URL Externo?</h5>
    						    <div class="form-check form-switch form-switch-lg d-flex justify-content-start align-items-center" for="chkURLExterno">
    								<input class="form-check-input form-check-input-sistema" type="checkbox" role="switch" id="chkURLExterno" name="chkURLExterno">
    								<label class="form-check-label m-0" for="chkURLExterno"></label>
    							</div>
    						</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-center align-items-center color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" id="btnEjecutarSistema" class="btn bg-success d-flex justify-content-center align-items-center color-white"><i class="mdi mdi-import mx-1" style="font-size: 14px;"></i>Actualizar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>