<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $elementoSeleccionadoModulo ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $subtitulo ?></h5>
                            <div class="d-flex">
								<?php
								if (in_array("ADDIES", $permisos)) 
								{
								?>
                                <button class="btn bg-sistema d-flex justify-content-center align-items-center mx-1 color-white datos-direccion-estructura" data-bs-target="#informacionDireccionEstructura" data-form="#formInformacionDireccionEstructura" data-id="0" data-accion="crear" id="crear-direccion" data-toggle="tooltip" data-placement="top" title="Registrar Estructura Dirección" aria-label="Registrar Estructura Dirección">
									<i class="mdi mdi-plus-circle me-1" style="font-size: 14px;"></i>Nuevo
								</button>
								<?php
								}
								?>
								<button type="button" class="btn bg-filtros color-white px-2 py-1 mx-1 waves-effect waves-light layout-rightside-btn" data-bs-toggle="offcanvas" data-bs-target="#theme-settings-offcanvas" aria-controls="theme-settings-offcanvas">
                                    <i class="mdi mdi-filter" style="font-size: 18px;"></i>
                                </button>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblDireccionesEstructura" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->

<?= $this->section('js'); ?>
<script>
	$(function () {
		/***SERVERSIDE LISTADO ESTRUCTURA DIRECCIONES***/
		assetListVM = {
			dt: null,
			init: function () {
				dt = $('#tblDireccionesEstructura').DataTable({
					"serverSide": true,
					"processing": true,
					"ajax": {
						"url": baseUrl + "/direccion-estructura-serverside",
						type: 'POST',
						data: function(d) {
						    let rutavista = window.location.href;
						    let arrayrutavista = rutavista.split("/");
						    d.url_vista = arrayrutavista[arrayrutavista.length-1];
						}
					},
					"columns": [
						{"title": "Código", "data": "IDDireccion", "class": "text-center", "searchable": true },
						{"title": "Dirección", "data": "Direccion", "class": "text-center", "searchable": true },
						{"title": "Responsable Principal", "data": "ResponsableDireccion", "class": "text-center", "searchable": true },
						{"title": "Observación", "data": "Observacion", "class": "text-center", "searchable": true },
						{"title": "Estado", "data": "EstadoDireccion", "class": "text-center", "searchable": true },
						{"title": "Acciones", "data": "acciones", "class": "text-center", "searchable": false, "orderable": false },
					],
                    "drawCallback": function(settings) {
                        // Re-inicializar tooltips después de que los datos son cargados
                        $('[data-tooltip="tooltip"]').tooltip();
                        $('[data-toggle="tooltip"]').tooltip();
                    },
					"lengthMenu": [[10, 25, 50], [10, 25, 50]],
					responsive: true,
					autoWidth: false,
					"pageLength": 10,
					"paging": true,
					"aaSorting": [[0, 'desc']],
				});
			}
		}

		assetListVM.init();
		/****FIN SERVERSIDE LISTADO ESTRUCTURA DIRECCIONES****/
		
	});
</script>
<?php $this->endSection(); ?>

<!-- Filtros -->
<div class="offcanvas offcanvas-end border-0" tabindex="-1" id="theme-settings-offcanvas" aria-modal="true" role="dialog">
    <div class="d-flex align-items-center bg-filtros bg-gradient p-3 offcanvas-header">
        <h5 class="m-0 me-2 text-white">Filtros</h5>

        <button type="button" class="btn-close btn-close-white ms-auto" id="customizerclose-btn" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body p-0">
        <!--<div data-simplebar="init" class="h-100 simplebar-scrollable-y">-->
        <!--    <div class="simplebar-wrapper" style="margin: 0px;">-->
        <!--        <div class="simplebar-height-auto-observer-wrapper">-->
        <!--            <div class="simplebar-height-auto-observer">-->
                        
        <!--            </div>-->
        <!--        </div>-->
        <!--        <div class="simplebar-mask">-->
        <!--            <div class="simplebar-offset" style="right: 0px; bottom: 0px;">-->
        <!--                <div class="simplebar-content-wrapper" tabindex="0" role="region" aria-label="scrollable content" style="height: 100%; overflow: hidden scroll;">-->
        <!--                    <div class="simplebar-content" style="padding: 0px;">-->
            <div id="ctnFiltro" class="p-3">
				<div class="card border" style="border-top: 3px #536878 solid!important;">
					<div class="card-header">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <h6 class="card-title mb-0">Columnas</h6>
                            </div>
                            <div class="flex-shrink-0">
                                <ul class="list-inline card-toolbar-menu d-flex align-items-center mb-0">
                                    <li class="list-inline-item">
                                        <a class="align-middle minimize-card" data-bs-toggle="collapse" href="#collapseColumnasFiltros" role="button" aria-expanded="true" aria-controls="collapseColumnasFiltros">
                                            <i class="mdi mdi-plus align-middle plus"></i>
                                            <i class="mdi mdi-minus align-middle minus"></i>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
					<div class="card-body collapse show" id="collapseColumnasFiltros" style="">
						cxcvcxxvxcxcv
					</div>
				</div>
				<div class="panel">
                    <div class="panel-heading">
                        <h4>Columnas</h4>
                    </div>
                    <div class="panel-content">
                        <div class="row">
                            adasasads
                        </div>
                    </div>
                </div>
            </div>
        <!--                    </div>-->
        <!--                </div>-->
        <!--            </div>-->
        <!--        </div>-->
        <!--        <div class="simplebar-placeholder" style="width: 400px; height: 1978px;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--    <div class="simplebar-track simplebar-horizontal" style="visibility: hidden;">-->
        <!--        <div class="simplebar-scrollbar" style="width: 0px; display: none;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--    <div class="simplebar-track simplebar-vertical" style="visibility: visible;">-->
        <!--        <div class="simplebar-scrollbar" style="height: 314px; transform: translate3d(0px, 0px, 0px); display: block;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--</div>-->
    </div>
    <div class="offcanvas-footer border-top p-3 text-center">
        <div class="row">
            <div class="col-4">
                <button type="button" class="btn btn-light w-100" id="btnLimpiar">Limpiar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-danger w-100" id="btnCerrarFiltros" data-bs-dismiss="offcanvas" aria-label="Close">Cerrar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-primary w-100" id="btnBuscarFiltros">Buscar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Información Direccion -->
<div class="modal fade zoomIn" id="informacionDireccionEstructura" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionDireccionEstructura" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleinformacionDireccionEstructura">Información de Dirección</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formInformacionDireccionEstructura" class="formulario" autocomplete="off" action="" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtIDDireccion_i" name="txtIDDireccion_i">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtDireccionEstructura_i" class="form-label">Dirección</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Dirección" id="txtDireccionEstructura_i" name="txtDireccionEstructura_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtObservacionDireccionEstructura_i" class="form-label">Observación</label>
								<textarea class="form-control" id="txtObservacionDireccionEstructura_i" name="txtObservacionDireccionEstructura_i" rows="3"></textarea>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-center align-items-center color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" id="btnEjecutarDireccionEstructura" class="btn bg-success d-flex justify-content-center align-items-center color-white"><i class="mdi mdi-content-save mx-1" style="font-size: 14px;"></i>Actualizar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Modal Usuarios Responsables-->
<div class="modal fade zoomIn" id="usuariosResponsablesDireccionEstructura" data-bs-backdrop="static" data-bs-focus="false" tabindex="-1" role="dialog" aria-labelledby="exampleusuariosResponsablesDireccionEstructura" aria-hidden="true">
	<div class="modal-dialog modal-xl modal-dialog-centered">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h4 class="modal-title color-white" id="exampleusuariosResponsablesDireccionEstructura">Usuarios Responsables de Dirección</h4>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close">
				</button>
			</div>
			<span class="respuesta"></span>
			<div class="modal-body">
			    <h3 class="mb-3">Dirección</h3>
			    <div class="row m-0 mb-3">
					<div class="col-12 col-lg-12">
						<div class="form-group">
							<label for="txtDireccionEstructuraRD">Dirección</label>
							<input type="text" class="form-control" id="txtDireccionEstructuraRD" placeholder="txtDireccionEstructuraRD" disabled>
						</div>
					</div>
				</div>
				<hr>
				<h3 class="mb-3">Agregar Usuario Responsable</h3>
			    <div class="row m-0 mb-3 py-3" style="border-radius: 10px;">
    			    <form id="formResponsableDireccionEstructura" class="formularioResponsableDireccionEstructura" autocomplete="off" action="<?= $baseUrl ?>/registrar-responsable-direccion-estructura" method="POST">
    			        <span class="respuesta"></span>
                        <div class="card-text mb-3">
                            <input type="hidden" id="txtIDDireccionEstructuraRD" name="txtIDDireccionEstructuraRD">
							<div class="form-group row">
								<div class="col-5">
									<label for="txtResponsableDireccionEstructura">Usuario Responsable</label>
									<select class="form-select" id="txtResponsableDireccionEstructura" name="txtResponsableDireccionEstructura" data-modal="usuariosResponsablesDireccionEstructura">
									</select>
								</div>
								<div class="col-5">
									<label for="txtPrincipalRD">¿Principal?</label>
									<select class="form-select" id="txtPrincipalRD" name="txtPrincipalRD" data-modal="usuariosResponsablesDireccionEstructura">
									    <option value="">Seleccione una opción</option>
									    <option value="Y">SI</option>
									    <option value="N">NO</option>
									</select>
								</div>
								<div class="col-2 d-flex justify-content-end align-items-bottom">
									<button type="submit" class="btn bg-success px-2 py-1 ms-2 d-flex justify-content-center align-items-center color-white" >
                                        <i class="mdi mdi-plus" style="font-size: 24px; color: #FFF"></i> Agregar
                                    </button>
								</div>
							</div>
						</div>
    			    </form>
    		    </div>
				<hr>
			    <h3 class="mb-3">Listado de Usuarios Responsables</h3>
			    <div class="row m-0 p-0" id="ctnListadoResponsablesDireccionEstructura">
			        
			    </div>
			</div>
			<div class="modal-footer justify-content-end">
				<button type="button" class="btn bg-danger d-flex justify-content-center align-items-center color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
			</div>
		</div>
	</div>
</div>

<?php $this->endSection(); ?>