<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $elementoSeleccionadoModulo ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
            <div class="position-relative mx-n4 mt-n4">
                <div class="profile-wid-bg profile-setting-img" style="background-image: url('<?= $baseUrl ?>/public/images/img-footer4.png')">
                    <div class="overlay-content">
                        <div class="text-end p-3">
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-xxl-3">
                    <div class="card mt-n5">
                        <div class="card-body p-4">
                            <div class="text-center">
                                <div class="profile-user position-relative d-inline-block mx-auto  mb-4">
                                    <img src="<?= $baseUrl ?>/public/images/users/user-dummy-img.jpg" class="rounded-circle avatar-xl img-thumbnail user-profile-image" alt="user-profile-image">
                                    <div class="avatar-xs p-0 rounded-circle profile-photo-edit">
                                        <input id="profile-img-file-input" type="file" class="profile-img-file-input">
                                        <label for="profile-img-file-input" class="profile-photo-edit avatar-xs">
                                            <span class="avatar-title rounded-circle bg-light text-body">
                                                <i class="ri-camera-fill"></i>
                                            </span>
                                        </label>
                                    </div>
                                </div>
                                <h5 class="fs-16 mb-1"><?= ucwords(mb_strtolower($informacionUsuario['Nombres'].' '.$informacionUsuario['Apellidos'])) ?></h5>
                                <p class="text-muted mb-0"><?= ucwords(mb_strtolower($informacionUsuario['Perfil'])) ?> | <?= ucwords(mb_strtolower($informacionUsuario['Cargo'])) ?></p>
                            </div>
                        </div>
                    </div>
                    <!--end card-->
                    <div class="card">
                        <div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1">Acciones</h5>
                        </div><!-- end card header -->
                        <div class="card-body d-flex align-items-center justify content-center">
                            
                			<?php
                            if(in_array("UPPEUS", $permisos))
                            {
                            ?>
                			<button class="badge bg-orange border-0 p-2 mx-1 editar-perfil-usuario" data-bs-target="#editarPerfilUsuario" data-id="<?= $idUsuarioInfo ?>" data-tooltip="tooltip" title="Editar Perfil de Usuario">
                				<i class="mdi mdi-scale-balance align-bottom" style="font-size: 20px; color: #FFF;"></i>
                			</button>
                			<?php
                            }
                            ?>
                            
                            <?php
                        	if(in_array("PASUSU", $permisos))
                        	{
                            ?>
                            <button class="badge bg-morado border-0 p-2 mx-1 cambiar-password-usuario" data-id="<?= $idUsuarioInfo ?>" data-usuario="<?= ucwords(mb_strtolower($informacionUsuario['Nombres']))." ".ucwords(mb_strtolower($informacionUsuario['Apellidos'])) ?>" data-tooltip="tooltip" title="Cambiar Contraseña">
                        		<i class="mdi mdi-lock-reset align-bottom" style="font-size: 20px; color: #FFF;"></i>
                        	</button>
                			<?php
                        	}
                            ?>
                            <a href="<?= $baseUrl.'/'.$previo ?>" class="btn bg-red-verisure color-white px-2 py-1 mx-1 waves-effect waves-light layout-rightside-btn" data-tooltip="tooltip" title="Volver a página anterior">
							    <i class="mdi mdi-arrow-left" style="font-size: 18px;"></i>
							</a>
                        </div><!-- end card body -->
                    </div>
                    <!--end card-->
                </div>
                <!--end col-->
                <div class="col-xxl-9">
                    <div class="card mt-xxl-n5">
                        <div class="card-header">
                            <ul class="nav nav-tabs-custom rounded card-header-tabs border-bottom-0" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link active d-flex justify-content-center align-items-center" data-bs-toggle="tab" href="#informacionPersonal" role="tab" aria-selected="true">
                                        <i class="mdi mdi-badge-account-horizontal-outline align-bottom me-1" style="font-size: 14px;"></i> Información Personal
                                    </a>
                                </li>
                                <?php
                                if(in_array("SAPEUS", $permisos))
                                {
                                ?>
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link d-flex justify-content-center align-items-center listar-permisos-usuario" data-id="<?= $idUsuarioInfo ?>" data-bs-toggle="tab" href="#permisosUsuario" role="tab" aria-selected="false" tabindex="-1">
                                        <i class="mdi mdi-gesture-tap-button align-bottom me-1" style="font-size: 14px;"></i> Permisos
                                    </a>
                                </li>
                                <?php
                                }
                                ?>
                                
                                <?php
                                if(in_array("SARUUS", $permisos))
                                {
                                ?>
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link d-flex justify-content-center align-items-center listar-rutas-usuario" data-id="<?= $idUsuarioInfo ?>" data-bs-toggle="tab" href="#rutassUsuario" role="tab" aria-selected="false" tabindex="-1">
                                        <i class="mdi mdi-link align-bottom me-1" style="font-size: 14px;"></i> Rutas
                                    </a>
                                </li>
                                <?php
                                }
                                ?>
                                
                                <?php
                                if(in_array("SADEUS", $permisos))
                                {
                                ?>
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link d-flex justify-content-center align-items-center listar-delegaciones-usuario" data-id="<?= $idUsuarioInfo ?>" data-bs-toggle="tab" href="#delegacionesUsuario" role="tab" aria-selected="false" tabindex="-1">
                                        <i class="mdi mdi-domain align-bottom me-1" style="font-size: 14px;"></i> Delegaciones
                                    </a>
                                </li>
                                <?php
                                }
                                ?>
                                
                                <?php
                                if(in_array("SASIUS", $permisos))
                                {
                                ?>
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link d-flex justify-content-center align-items-center listar-sistemas-usuario" data-id="<?= $idUsuarioInfo ?>" data-bs-toggle="tab" href="#sistemasUsuario" role="tab" aria-selected="false" tabindex="-1">
                                        <i class="mdi mdi-database-cog align-bottom me-1" style="font-size: 14px;"></i> Sistemas
                                    </a>
                                </li>
                    			<?php
                                }
                                ?>
                                
                            </ul>
                        </div>
                        <div class="card-body p-4">
                            <div class="tab-content">
                                <div class="tab-pane active show" id="informacionPersonal" role="tabpanel">
                        			<form id="formInformacionUsuario" class="formulario" autocomplete="off" action="<?= $baseUrl ?>/actualizar-usuario/<?= $idUsuarioInfo ?>" method="POST">
                        				<span class="respuesta"></span>
                        				<div class="card">
                                            <div class="card-header d-flex align-items-center bg-sistema-75">
                                                <h5 class="card-title mb-0 flex-grow-1 color-white" style="">Información Personal</h5>
                                                <div class="d-flex">
                                                    <?php
                                        			if(in_array("UPDUSU", $permisos))
                                        			{
                                                    ?>
                                                    <button type="submit" class="badge bg-success border-0 p-2 mx-1 d-none" id="btnGuardarCambios" data-tooltip="tooltip" title="Guardar Cambios">
                                        				<i class="mdi mdi-content-save align-bottom" style="font-size: 20px; color: #FFF;"></i>
                                        			</button>
                                                    <button type="button" class="badge bg-danger border-0 p-2 mx-1 d-none" id="btnCancelarEditarUsuario" data-tooltip="tooltip" title="Cancelar Edición Usuario">
                                        				<i class="mdi mdi-cancel align-bottom" style="font-size: 20px; color: #FFF;"></i>
                                        			</button>
                                                    <button type="button" class="badge bg-warning border-0 p-2 mx-1" id="btnEditarUsuario" data-tooltip="tooltip" title="Editar Usuario">
                                        				<i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i>
                                        			</button>
                                                    <?php
                                        			}
                                                    ?>
                                                </div>
                                            </div>
                                            <!-- /.card-header -->
                                            <div class="card-body row m-0 p-0">
                                                <div class="row m-0 p-3">
                                                    <div class="col-lg-4">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="txtMatriculaUsuario_i">Matrícula</label>
                                                            <input type="text" class="form-control input-edit-usuario" placeholder="Matrícula..." value="<?= mb_strtoupper($informacionUsuario['Matricula']) ?>" id="txtMatriculaUsuario_i" name="txtMatriculaUsuario_i" disabled>
                                                        </div>
                                                    </div>
                                                    <!--end col-->
                                                    <div class="col-lg-4">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="txtNombresUsuario_i">Nombres</label>
                                                            <input type="text" class="form-control input-edit-usuario" placeholder="Nombres..." value="<?= ucwords(mb_strtolower($informacionUsuario['Nombres'])) ?>" id="txtNombresUsuario_i" name="txtNombresUsuario_i" disabled>
                                                        </div>
                                                    </div>
                                                    <!--end col-->
                                                    <div class="col-lg-4">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="txtApellidosUsuario_i">Apellidos</label>
                                                            <input type="text" class="form-control input-edit-usuario" placeholder="Apellidos..." value="<?= ucwords(mb_strtolower($informacionUsuario['Apellidos'])) ?>" id="txtApellidosUsuario_i" name="txtApellidosUsuario_i" disabled>
                                                        </div>
                                                    </div>
                                                    <!--end col-->
                                                    <div class="col-lg-4">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="txtTipoDocumentoUsuario_i">Tipo Documento</label>
                                                            <select class="form-select input-edit-usuario" aria-label="Tipo de Documento..." id="txtTipoDocumentoUsuario_i" name="txtTipoDocumentoUsuario_i" data-modal="" disabled>
                            								    <option value="">Seleccione Tipo Documento</option>
                            									<option value="DNI" <?= $informacionUsuario['TipoDocumento'] == "DNI" ? "selected" : "" ?> >DNI</option>
                            									<option value="CE" <?= $informacionUsuario['TipoDocumento'] == "CE" ? "selected" : "" ?> >CE</option>
                            								</select>
                                                        </div>
                                                    </div>
                                                    <!--end col-->
                                                    <div class="col-lg-4">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="txtDocumentoUsuario_i">Documento</label>
                                                            <input type="text" class="form-control input-edit-usuario" placeholder="Documento..." value="<?= $informacionUsuario['NumeroDoc'] ?>" id="txtDocumentoUsuario_i" name="txtDocumentoUsuario_i" disabled>
                                                        </div>
                                                    </div>
                                                    <!--end col-->
                                                    <div class="col-lg-4">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="txtCargoUsuario_i">Cargo</label>
                                                            <select class="form-select input-edit-usuario" aria-label="Cargo..." id="txtCargoUsuario_i" name="txtCargoUsuario_i" data-modal="" disabled>
                            								    <option value="">Seleccione una opción...</option>
                            								</select>
                                                        </div>
                                                    </div>
                                                    <!--end col-->
                                                    <div class="col-lg-4">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="txtManagerUsuario_i">Jefe Directo</label>
                                                            <select class="form-select input-edit-usuario" aria-label="Jefe Directo..." id="txtManagerUsuario_i" name="txtManagerUsuario_i" data-modal="" disabled>
                            								    <option value="">Seleccione una opción...</option>
                            								</select>
                                                        </div>
                                                    </div>
                                                    <!--end col-->
                                                    <div class="col-lg-4">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="txtFechaIngresoUsuario_i">Fecha de Ingreso</label>
                                                            <input type="date" class="form-control input-edit-usuario" placeholder="Fecha de Ingreso..." value="<?= date("Y-m-d", strtotime($informacionUsuario['FechaIngreso'])) ?>" id="txtFechaIngresoUsuario_i" name="txtFechaIngresoUsuario_i" disabled>
                                                        </div>
                                                    </div>
                                                    <!--end col-->
                                                    <div class="col-lg-4">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="txtFTEUsuario_i">FTE</label>
                                                            <input type="number" step="0.01" class="form-control input-edit-usuario" placeholder="FTE..." value="<?= $informacionUsuario['FTE'] ?>" id="txtFTEUsuario_i" name="txtFTEUsuario_i" disabled>
                                                        </div>
                                                    </div>
                                                    <!--end col-->
                                                    <div class="col-lg-4">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="txtDireccionEstrucUsuario_i">Dirección</label>
                                                            <select class="form-select input-edit-usuario" aria-label="Dirección..." id="txtDireccionEstrucUsuario_i" name="txtDireccionEstrucUsuario_i" data-modal="" disabled>
                            								    <option value="">Seleccione una opción...</option>
                            								</select>
                                                        </div>
                                                    </div>
                                                    <!--end col-->
                                                    <div class="col-lg-4">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="txtAreaEstrucUsuario_i">Área</label>
                                                            <select class="form-select input-edit-usuario" aria-label="Área..." id="txtAreaEstrucUsuario_i" name="txtAreaEstrucUsuario_i" data-modal="" disabled>
                            								    <option value="">Seleccione una opción...</option>
                            								</select>
                                                        </div>
                                                    </div>
                                                    <!--end col-->
                                                    <div class="col-lg-4">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="txtSubareaEstrucUsuario_i">Subárea</label>
                                                            <select class="form-select input-edit-usuario" aria-label="Subárea..." id="txtSubareaEstrucUsuario_i" name="txtSubareaEstrucUsuario_i" data-modal="" disabled>
                            								    <option value="">Seleccione una opción...</option>
                            								</select>
                                                        </div>
                                                    </div>
                                                    <!--end col-->
                                                    <div class="col-lg-4">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="txtDelegacionSubareaEstrucUsuario_i">CC - LN | Delegacion</label>
                                                            <select class="form-select input-edit-usuario" aria-label="Delegación..." id="txtDelegacionSubareaEstrucUsuario_i" name="txtDelegacionSubareaEstrucUsuario_i" data-modal="" disabled>
                            								    <option value="">Seleccione una opción...</option>
                            								</select>
                                                        </div>
                                                    </div>
                                                    <!--end col-->
                                                    <div class="col-lg-4">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="txtCorreoUsuario_i">Correo Corporativo</label>
                                                            <input type="email" class="form-control input-edit-usuario" placeholder="Correo Corporativo..." value="<?= $informacionUsuario['Correo'] ?>" id="txtCorreoUsuario_i" name="txtCorreoUsuario_i" disabled>
                                                        </div>
                                                    </div>
                                                    <!--end col-->
                                                    <div class="col-lg-4">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="txtUsuarioIngreso_i">Usuario</label>
                                                            <input type="text" class="form-control input-edit-usuario" placeholder="Usuario..." value="<?= $informacionUsuario['Usuario'] ?>" id="txtUsuarioIngreso_i" name="txtUsuarioIngreso_i" disabled>
                                                        </div>
                                                    </div>
                                                    <!--end col-->
                                                    <div class="col-lg-4">
                                                        <div class="mb-3">
                                                            <label class="form-label" for="txtTipoUsuario_i">Tipo de usuario</label>
                                                            <select class="form-select input-edit-usuario" aria-label="Tipo de usuario..." id="txtTipoUsuario_i" name="txtTipoUsuario_i"  data-modal="" disabled>
                            								    <option value="">Seleccione una opción</option>
                            									<option value="STAFF" <?= $informacionUsuario['TipoUsuario'] == "STAFF" ? "selected" : "" ?> >STAFF</option>
                            									<option value="OPERADOR" <?= $informacionUsuario['TipoUsuario'] == "OPERADOR" ? "selected" : "" ?> >OPERADOR</option>
                            									<option value="TECNICO" <?= $informacionUsuario['TipoUsuario'] == "TECNICO" ? "selected" : "" ?> >TECNICO</option>
                            									<option value="CODIR" <?= $informacionUsuario['TipoUsuario'] == "CODIR" ? "selected" : "" ?> >CODIR</option>
                            								</select>
                                                        </div>
                                                    </div>
                                                    <!--end col-->
                                                </div>
                                            </div>
                                        </div>
                                        <!--end row-->
                                    </form>
                                </div>
                                <!--end tab-pane-->
                                <?php
                                if(in_array("SAPEUS", $permisos))
                                {
                                ?>
                                <div class="tab-pane" id="permisosUsuario" role="tabpanel">
                                    
                                </div>
                                <!--end tab-pane-->
                                <?php
                                }
                                ?>
                                
                                <?php
                                if(in_array("SARUUS", $permisos))
                                {
                                ?>
                                <div class="tab-pane" id="rutassUsuario" role="tabpanel">
                                    
                                </div>
                                <!--end tab-pane-->
                                <?php
                                }
                                ?>
                                
                                <?php
                                if(in_array("SADEUS", $permisos))
                                {
                                ?>
                                <div class="tab-pane" id="delegacionesUsuario" role="tabpanel">
                                    
                                </div>
                                <!--end tab-pane-->
                                <?php
                                }
                                ?>
                                
                                <?php
                                if(in_array("SASIUS", $permisos))
                                {
                                ?>
                                <div class="tab-pane" id="sistemasUsuario" role="tabpanel">
                                    
                                </div>
                                <!--end tab-pane-->
                                <?php
                                }
                                ?>
                                
                            </div>
                        </div>
                    </div>
                </div>
                <!--end col-->
            </div>
            <!--end row-->

        </div>
		<span class="respuesta_global"></span>
        <!-- container-fluid -->
    </div><!-- End Page-content -->

    <footer class="footer">
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-6">
                    <script>document.write(new Date().getFullYear())</script> © Verisure Peru.
                </div>
                <div class="col-sm-6">
                    <div class="text-sm-end d-none d-sm-block">
                        Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
                    </div>
                </div>
            </div>
        </div>
    </footer>
</div>
<!-- end main content-->

<?= $this->section('js'); ?>
<script>
	$(function () {
		selectPerfil("txtPerfilUsuario", "", "editarPerfilUsuario");
		
		$('#txtTipoDocumentoUsuario_i').select2({
        });
        
		selectCargos("txtCargoUsuario_i", "<?= $informacionUsuario['IDCargo'] ?>", "");
		selectUsuarios("txtManagerUsuario_i", "<?= $informacionUsuario['IDManager'] ?>", "");
		selectDireccionEstructura("txtDireccionEstrucUsuario_i", "<?= $informacionUsuario['IDDireccion'] ?>", "");
		selectAreaEstructura("txtAreaEstrucUsuario_i", "<?= $informacionUsuario['IDDireccion'] ?>", "<?= $informacionUsuario['IDArea'] ?>", "");
		selectSubareaEstructura("txtSubareaEstrucUsuario_i", "<?= $informacionUsuario['IDArea'] ?>", "<?= $informacionUsuario['IDSubarea'] ?>", "");
		selectDelegacionesSubareaEstructura("txtDelegacionSubareaEstrucUsuario_i", "<?= $informacionUsuario['IDSubarea'] ?>", "<?= $informacionUsuario['IDDelegacion'] ?>", "");
		
		$('#txtTipoUsuario_i').select2({
        });
        
	});
</script>
<?php $this->endSection(); ?>

<!-- Modal Perfil Usuario -->
<div class="modal fade zoomIn" id="editarPerfilUsuario" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleEditarPerfilUsuario" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleEditarPerfilUsuario">Editar Perfil de Usuario</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formEditarPerfilUsuario" class="formulario" autocomplete="off" action="<?= $baseUrl ?>/modificar-perfil-usuario" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="row">
					    <input type="hidden" id="txtIDUsuario_mpu" name="txtIDUsuario_mpu" value="<?= $idUsuarioInfo ?>">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
                            <div>
                                <label for="txtPerfilUsuario" class="form-label">Perfil*</label>
								<select class="form-select" aria-label="Perfil" id="txtPerfilUsuario" name="txtPerfilUsuario">
									<option selected="" value="">Seleccione una opción</option>
								</select>
                            </div>
                        </div>
						<span style="color: red;">* Si procede a realizar el cambio, todos los permisos y rutas personalizadas serán eliminadas y se asignarán los permisos y rutas por defecto del perfil.</span>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-center align-items-center color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" id="btnEjecutarOperador" class="btn bg-success d-flex justify-content-center align-items-center color-white"><i class="mdi mdi-import mx-1" style="font-size: 14px;"></i>Actualizar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>