<?php namespace App\Models;

use CodeIgniter\Model;

class UsuarioSistemasModel extends Model 
{
    protected $table            = 'usuario_sistemas';
    protected $primaryKey       = 'IdUsuario';
    protected $allowedFields    = ['IdUsuario', 'IDSistema', 'UsuarioRegistra', 'FechaRegistra'];
    protected $useAutoIncrement = false;
    protected $useSoftDeletes   = false;
    
    public function listarSistemasUsuario($idUsuario)
    {
        $this->select('sistemas.IDSistema,
            sistemas.Sistema,
            sistemas.Dominio,
            sistemas.Subdominio,
            sistemas.Subcarpeta,
            IF(usuario_sistemas.IdUsuario IS NULL, 0, 1) AS "ACTIVO"');
        $this->join('sistemas', 'usuario_sistemas.IDSistema = sistemas.IDSistema AND usuario_sistemas.IdUsuario = "'.$idUsuario.'"', 'right');
        
        $datos = $this->findAll();
        return $datos;
    }
    
    public function validarSistemaUsuario($array)
    {
        $this->select('usuario_sistemas.IDSistema,
            sistemas.Sistema,
            sistemas.Subdominio,
            sistemas.Dominio,
            sistemas.Subcarpeta,
            sistemas.Estado');
        $this->join('sistemas', 'usuario_sistemas.IDSistema = sistemas.IDSistema', 'left');
        
        if(!empty($array))
        {
            if(isset($array['IDUsuario']) && !empty($array['IDUsuario']))
            {
                $this->where('usuario_sistemas.IdUsuario', $array['IDUsuario']);
            }
            
            if(isset($array['Subdominio']) && !empty($array['Subdominio']))
            {
                $this->where('sistemas.Subdominio', $array['Subdominio']);
            }
            
            if(isset($array['Dominio']) && !empty($array['Dominio']))
            {
                $this->where('sistemas.Dominio', $array['Dominio']);
            }
            
            if(isset($array['Subcarpeta']) && !empty($array['Subcarpeta']))
            {
                $this->where('sistemas.Subcarpeta', $array['Subcarpeta']);
            }
        }
        
        $datos = $this->first();
        return $datos;
    }
    
    //   public function listarUsuarioPerfil()
    //   {
    //       $this->select('usuario_perfil.IdUsuario,
    //         usuario_perfil.IDPerfil, 
    //         perfil.Perfil');
    //       $this->join('perfil', 'usuario_perfil.IDPerfil = perfil.IDPerfil', 'left');
          
    //       $datos = $this->findAll();
    //       return $datos;
    //   }
      
    //   public function obtenerPerfilUsuario($idUsuario)
    //   {
    //       $this->select('usuario_perfil.IdUsuario,
    //         usuario_perfil.IDPerfil, 
    //         perfil.Perfil,
    //         perfil.URLBase');
    //       $this->join('perfil', 'usuario_perfil.IDPerfil = perfil.IDPerfil', 'left');
    //       $this->where('usuario_perfil.IdUsuario', $idUsuario);
          
    //       $datos = $this->first();
    //       return $datos;
    //   }
    
    //   public function obtenerRutaUsuario($array)
    //   {
    //     $this->select('
    //       (SELECT 
    //         IF(usuario_rutas.IdUsuario IS NULL, 0, 1)
    //       FROM 
    //         usuario_rutas 
    //       INNER JOIN 
    //         modulos_rutas ON usuario_rutas.IDRuta = modulos_rutas.IDRuta
    //       WHERE
    //         usuario_rutas.IdUsuario = "'.$array['idusuario'].'" AND
    //         modulos_rutas.Ruta = "'.$array['ruta'].'") AS "AUTORIZADO",
    //       perfil.Perfil,
    //       perfil.URLBase');
    //     $this->join('perfil', 'usuario_perfil.IDPerfil = perfil.IDPerfil', 'left');
    //     $this->where('usuario_perfil.IdUsuario', $array['idusuario']);
    
    //     $datos = $this->first();
    //     return $datos;
    //   }
}
