<?php namespace App\Models;

use CodeIgniter\Model;

class UsuarioModel extends Model 
{
    protected $table = 'tblusuario';
    protected $primaryKey = 'IdUsuario';
    protected $allowedFields = ['IdArea','IdPerfil','Matricula','Nombres','Apellidos','TipoDocumento','NumeroDoc','Telefono','Demo','Cargo','Categoria','Instalador','CC','LN','Manager','TipoUsuario','Correo','Usuario','Password','FechaIngreso','FechaCese','Estado','FTE','Foto','FechaHoraREG','FechaHoraMODIF','RMKT','Token','Estrellas','TCTV','RemarketingTV','TC','Push','Pull','Equipo','RemarketingTC', 'IDCargo', 'IDManager', 'IDSubarea','IDDelegacion', 'brevete', 'numero_placa','UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    public function listaGeneralUsuario($get, $adicionales) 
    {
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
        
        $fields = array(
            0 => 'tblusuario.IdUsuario', 
            2 => 'tblusuario.Matricula', 
            3 => 'tblusuario.NumeroDoc', 
            4 => 'perfil.Perfil', 
            5 => 'tblusuario.Usuario',
            7 => 'tblusuario.Estado');
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS (NUEVO)
        * ----------------------------
        */
        
        $this->select("COUNT(*) AS total");
        $totalQuery = $this->get();
        $totalRecords = $totalQuery->getRow()->total;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $this->select('
            tblusuario.IdUsuario,
            tblusuario.Nombres,
            tblusuario.Apellidos,
            tblusuario.Matricula,
            tblusuario.NumeroDoc,
            perfil.Perfil,
            (SELECT GROUP_CONCAT(DISTINCT sistemas.Sistema SEPARATOR "<br>") 
                FROM sistemas 
                LEFT JOIN usuario_sistemas ON usuario_sistemas.IDSistema = sistemas.IDSistema 
                WHERE usuario_sistemas.IdUsuario = tblusuario.IdUsuario) AS "Sistemas",
            tblusuario.Usuario,
            tblusuario.Estado');
        
        $this->join('usuario_perfil', 'tblusuario.IdUsuario = usuario_perfil.IdUsuario', 'left');
        $this->join('perfil', 'usuario_perfil.IDPerfil = perfil.IDPerfil', 'left');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if($k == 1)
                {
                    $this->orLike("CONCAT(tblusuario.Nombres, ' ', tblusuario.Apellidos)", $get['search']['value']);
                }
                else if($k == 6)
                {
                    $this->orLike('(SELECT GROUP_CONCAT(DISTINCT sistemas.Sistema SEPARATOR "<br>") 
                FROM sistemas 
                LEFT JOIN usuario_sistemas ON usuario_sistemas.IDSistema = sistemas.IDSistema 
                WHERE usuario_sistemas.IdUsuario = tblusuario.IdUsuario)', $get['search']['value']);
                }
                else 
                {
                    if(array_key_exists($k, $fields))
                    {
                        $this->orLike($fields[$k], $get['search']['value']);
                    }
                }
            }
            
            $this->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS FILTRADOS (NUEVO)
        * ----------------------------
        */
        
        $this->select("COUNT(*) AS filtered");
        $filteredQuery = $this->get();
        
        if ($filteredQuery === false) {
            // echo $this->getLastQuery();
            // return [];
            $filteredRecords = $totalRecords;
        }
        $filteredRecords = $filteredQuery->getRow()->filtered;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY (NUEVAMENTE PARA ENVIAR LA DATA)
        * ----------------------------
        */
        
        $this->select('
            tblusuario.IdUsuario,
            tblusuario.Nombres,
            tblusuario.Apellidos,
            tblusuario.Matricula,
            tblusuario.NumeroDoc,
            perfil.Perfil,
            (SELECT GROUP_CONCAT(DISTINCT sistemas.Sistema SEPARATOR "<br>") 
                FROM sistemas 
                LEFT JOIN usuario_sistemas ON usuario_sistemas.IDSistema = sistemas.IDSistema 
                WHERE usuario_sistemas.IdUsuario = tblusuario.IdUsuario) AS "Sistemas",
            tblusuario.Usuario,
            tblusuario.Estado');
        
        $this->join('usuario_perfil', 'tblusuario.IdUsuario = usuario_perfil.IdUsuario', 'left');
        $this->join('perfil', 'usuario_perfil.IDPerfil = perfil.IDPerfil', 'left');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if($k == 1)
                {
                    $this->orLike("CONCAT(tblusuario.Nombres, ' ', tblusuario.Apellidos)", $get['search']['value']);
                }
                else if($k == 6)
                {
                    $this->orLike('(SELECT GROUP_CONCAT(DISTINCT sistemas.Sistema SEPARATOR "<br>") 
                FROM sistemas 
                LEFT JOIN usuario_sistemas ON usuario_sistemas.IDSistema = sistemas.IDSistema 
                WHERE usuario_sistemas.IdUsuario = tblusuario.IdUsuario)', $get['search']['value']);
                }
                else 
                {
                    if(array_key_exists($k, $fields))
                    {
                        $this->orLike($fields[$k], $get['search']['value']);
                    }
                }
            }
            
            $this->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        
        foreach ($get['order'] as $order) 
        {
            if ($order['column'] == 1) 
            {
                $this->orderBy("CONCAT(tblusuario.Nombres, ' ', tblusuario.Apellidos)", $order['dir']);
            } 
            else if ($order['column'] == 6) 
            {
                $this->orderBy('(SELECT GROUP_CONCAT(DISTINCT sistemas.Sistema SEPARATOR "<br>") 
                FROM sistemas 
                LEFT JOIN usuario_sistemas ON usuario_sistemas.IDSistema = sistemas.IDSistema 
                WHERE usuario_sistemas.IdUsuario = tblusuario.IdUsuario)', $order['dir']);
            } 
            else 
            {
                if(array_key_exists($order['column'], $fields))
                {
                    $field = $fields[$order['column']];
                    
                    // Para las otras columnas, aplica el orden normal
                    $this->orderBy($field, $order['dir']);
                }
            }
        }
        
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        
        /* Antes de Codeiginiter 4.5.4*/
        // $this->limit($get['length'], $get['start']);
        
        /*
        * ----------------------------
        * EJECUTAR CONSULTA, LIMITAR CANTIDAD DE RESULTADOS DE QUERY Y DEVOLVER VALORES
        * ----------------------------
        */
        
        /* Antes de Codeiginiter 4.5.4*/
        // $this->get();
        // return $this->getLastQuery();
        
        // $result = $this->get()->getResultArray();
        // return $result;
        
        /* Despues de Codeiginiter 4.5.4*/
        $result = $this->findAll($get['length'], $get['start']);
        
        // echo $this->getLastQuery();
        // exit;
        
        // return $result;
        
        /*
        * ----------------------------
        * DEVOLVER RESULTADOS Y LOS DATOS DE PAGINACIÓN
        * ----------------------------
        */
        
        return [
            'draw'              => $get['draw'], // Número de la petición para sincronizar
            'recordsTotal'      => $totalRecords, // Total de registros sin filtrar
            'recordsFiltered'   => $filteredRecords, // Total de registros después de aplicar filtros
            'data'              => $result // Los datos actuales para mostrar
        ];
    }

    public function validarIngresoUsuario($usuario)
    {
        $this->select('tblusuario.IdUsuario,
            tblusuario.Usuario,
            tblusuario.Nombres,
            tblusuario.Matricula,
            tblusuario.Apellidos,
            tblusuario.TipoDocumento,
            tblusuario.NumeroDoc,
            tblusuario.Correo,
            tblusuario.Estado,
            tblusuario.Password,
            tblusuario.IDDelegacion,
            tblusuario.IDSubarea,
            estructura_area.IDArea,
            estructura_area.Area,
            estructura_direccion.IDDireccion,
            estructura_direccion.Direccion,
            estructura_delegacion.CC,
            tblusuario.IDCargo,
            cargos.Cargo');
        $this->join('estructura_delegacion', 'tblusuario.IDDelegacion = estructura_delegacion.IDDelegacion', 'left');
        $this->join('estructura_subarea', 'tblusuario.IDSubarea = estructura_subarea.IDSubarea', 'left');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->join('cargos', 'tblusuario.IDCargo = cargos.IDCargo', 'left');
        $this->where('tblusuario.Usuario', $usuario);
        $datos = $this->first();
        return $datos;
    }

    public function validarSistemaUsuario($idUsuario, $raiz)
    {
        $this->select('tblusuario.IdUsuario,
            usuario_sistemas.IDSistema,
            sistemas.Sistema,
            sistemas.Estado');
        $this->join('usuario_sistemas', 'tblusuario.IdUsuario = usuario_sistemas.IdUsuario');
        $this->join('sistemas', 'usuario_sistemas.IDSistema = sistemas.IDSistema');
        $this->where('usuario_sistemas.IdUsuario', $idUsuario);
        $this->where('sistemas.Raiz', $raiz);
        $datos = $this->first();
        return $datos;
    }
    
    public function listadoUsuarios($array) 
    {
        $this->select('
        tblusuario.IdUsuario,
        tblusuario.Matricula,
        tblusuario.Usuario,
        tblusuario.Nombres,
        tblusuario.Apellidos,
        tblusuario.TipoDocumento,
        tblusuario.NumeroDoc,
        tblusuario.TipoUsuario,
        tblusuario.FechaIngreso,
        tblusuario.FechaCese,
        tblusuario.FTE,
        estructura_subarea.Subarea,
        estructura_area.Area,
        estructura_direccion.Direccion,
        cargos.Cargo,
        estructura_delegacion.CC,
        estructura_delegacion.LN,
        estructura_delegacion.Delegacion,
        UM.Matricula AS "Matricula_Manager",
        tblusuario.Estado');
        $this->join('estructura_delegacion', 'tblusuario.IDDelegacion = estructura_delegacion.IDDelegacion', 'left');
        $this->join('estructura_subarea', 'tblusuario.IDSubarea = estructura_subarea.IDSubarea', 'left');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->join('cargos', 'tblusuario.IDCargo = cargos.IDCargo', 'left');
        $this->join('tblusuario AS UM', 'tblusuario.IDManager = UM.IdUsuario', 'left');

        if(isset($array['estado']) && $array['estado'] != '')
        {
            $this->where("tblusuario.Estado", $array['estado']);
        }
        
        if(isset($array['correo']))
        {
            if($array['correo'] == '')
            {
                $this->where("tblusuario.Correo = '' OR tblusuario.Correo IS NULL");
            }
            else
            {
                $this->where("tblusuario.Correo", $array['correo']);
            }
        }
        
        $datos = $this->findAll();
        return $datos;
    }
    
    public function buscarUsuario($idUsuario)
    {
        $this->select('tblusuario.IdUsuario,
            tblusuario.Matricula,
            tblusuario.Usuario,
            tblusuario.Nombres,
            tblusuario.Apellidos,
            tblusuario.TipoDocumento,
            tblusuario.NumeroDoc,
            tblusuario.FTE,
            tblusuario.Usuario,
            tblusuario.Correo,
            tblusuario.Estado,
            tblusuario.MotivoEstado,
            tblusuario.TipoUsuario,
            tblusuario.IDManager,
            tblusuario.IDDelegacion,
            tblusuario.FechaIngreso,
            tblusuario.FechaCese,
            tblusuario.IDSubarea,
            estructura_subarea.Subarea,
            estructura_area.IDArea,
            estructura_area.Area,
            estructura_direccion.IDDireccion,
            estructura_direccion.Direccion,
            estructura_delegacion.Delegacion,
            estructura_delegacion.CC,
            estructura_delegacion.LN,
            tblusuario.IDCargo,
            cargos.Cargo,
            perfil.Perfil');
        $this->join('estructura_delegacion', 'tblusuario.IDDelegacion = estructura_delegacion.IDDelegacion', 'left');
        $this->join('estructura_subarea', 'tblusuario.IDSubarea = estructura_subarea.IDSubarea', 'left');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->join('cargos', 'tblusuario.IDCargo = cargos.IDCargo', 'left');
        $this->join('usuario_perfil', 'tblusuario.IdUsuario = usuario_perfil.IdUsuario', 'left');
        $this->join('perfil', 'usuario_perfil.IDPerfil = perfil.IDPerfil', 'left');
        $this->where('tblusuario.IdUsuario', $idUsuario);
        $datos = $this->first();
        return $datos;
    }

    public function buscarUsuarioXusuario($usuario)
    {
        $this->select('tblusuario.IdUsuario,
            tblusuario.Matricula,
            tblusuario.Usuario,
            tblusuario.Nombres,
            tblusuario.Apellidos,
            tblusuario.TipoDocumento,
            tblusuario.NumeroDoc,
            tblusuario.Correo,
            tblusuario.Estado,
            tblusuario.IDSubarea,
            tblusuario.IDDelegacion,
            estructura_area.IDArea,
            estructura_area.Area,
            estructura_direccion.IDDireccion,
            estructura_direccion.Direccion,
            estructura_delegacion.CC,
            cargos.Cargo');
        $this->join('estructura_delegacion', 'tblusuario.IDDelegacion = estructura_delegacion.IDDelegacion', 'left');
        $this->join('estructura_subarea', 'tblusuario.IDSubarea = estructura_subarea.IDSubarea', 'left');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->join('cargos', 'tblusuario.IDCargo = cargos.IDCargo', 'left');
        $this->where('tblusuario.Usuario', $usuario);
        $datos = $this->first();
        return $datos;
    }

    public function buscarUsuarioXmatricula($matricula)
    {
        $this->select('tblusuario.IdUsuario,
            tblusuario.Matricula,
            tblusuario.Usuario,
            tblusuario.Nombres,
            tblusuario.Apellidos,
            tblusuario.TipoDocumento,
            tblusuario.NumeroDoc,
            tblusuario.Correo,
            tblusuario.Estado,
            tblusuario.IDSubarea,
            tblusuario.IDDelegacion,
            tblusuario.brevete,
            tblusuario.numero_placa,
            estructura_area.IDArea,
            estructura_area.Area,
            estructura_direccion.IDDireccion,
            estructura_direccion.Direccion,
            estructura_delegacion.CC,
            cargos.Cargo');
        $this->join('estructura_delegacion', 'tblusuario.IDDelegacion = estructura_delegacion.IDDelegacion', 'left');
        $this->join('estructura_subarea', 'tblusuario.IDSubarea = estructura_subarea.IDSubarea', 'left');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->join('cargos', 'tblusuario.IDCargo = cargos.IDCargo', 'left');
        $this->where('tblusuario.Matricula', $matricula);
        $datos = $this->first();
        return $datos;
    }

    public function listadoUsuariosSelect($variable, $cc = '', $estado = '')
    {
        $this->select('
        tblusuario.IdUsuario,
        tblusuario.Matricula,
        tblusuario.Nombres,
        tblusuario.Apellidos,
        tblusuario.NumeroDoc,
        estructura_delegacion.CC');
        $this->join('estructura_delegacion', 'tblusuario.IDDelegacion = estructura_delegacion.IDDelegacion', 'left');
        $this->join('estructura_subarea', 'tblusuario.IDSubarea = estructura_subarea.IDSubarea', 'left');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->join('cargos', 'tblusuario.IDCargo = cargos.IDCargo', 'left');
        $this->where("(tblusuario.Matricula LIKE '%".$variable."%' OR 
            tblusuario.Nombres LIKE '%".$variable."%' OR
            tblusuario.Apellidos LIKE '%".$variable."%' OR 
            tblusuario.Usuario LIKE '%".$variable."%' OR 
            CONCAT(tblusuario.Nombres, ' ',tblusuario.Apellidos) LIKE '%".$variable."%' OR 
            tblusuario.NumeroDoc LIKE '%".$variable."%')");

        if($cc != '')
        {
            $this->where('estructura_delegacion.CC', $cc);
        }
        
        if($estado != '')
        {
            $this->where('tblusuario.Estado', $estado);
        }
        
        $datos = $this->findAll();
        return $datos;
    }

    public function listaGeneralUsuarios($array) 
    {
        $this->select('
        tblusuario.IdUsuario,
        tblusuario.Matricula,
        tblusuario.Nombres,
        tblusuario.Apellidos,
        CONCAT(tblusuario.Nombres, " ", tblusuario.Apellidos) AS "NombreCompleto",
        tblusuario.NumeroDoc,
        estructura_delegacion.CC,
        tblusuario.Estado');
        $this->join('estructura_delegacion', 'tblusuario.IDDelegacion = estructura_delegacion.IDDelegacion', 'left');
        $this->join('estructura_subarea', 'tblusuario.IDSubarea = estructura_subarea.IDSubarea', 'left');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->join('cargos', 'tblusuario.IDCargo = cargos.IDCargo', 'left');

        if(isset($array['estado']) && $array['estado'] != '')
        {
            $this->where("tblusuario.Estado", $array['estado']);
        }
        
        $datos = $this->findAll();
        return $datos;
    }
    
    public function listaMetricasCalculadasServerSide($get, $adicionales, $grupoTrabajoIds, $tipofuncion)
    {
        
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
        // $this->globales = new Globales();
        $fields = array(
            0 => 'tblusuario.idUsuario',                  // ID Usuario
            1 => 'tblusuario.Nombres',                    // Nombres
            2 => 'tblusuario.Apellidos',                  // Apellidos
            3 => 'md.categoria',                          // Categoría
            4 => 'horas_trabajadas',                      // Horas Trabajadas
            5 => 'tardanza',                              // Tardanza
            6 => 'horas_extras',                          // Horas Extras
            7 => 'total_faltas',                          // Total Faltas
            8 => 'bono_desempeno',                        // Bono Desempeño
            9 => 'comision_total',                        // Comisión Total
        );

        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        $this->select('
                    gt.GrupoTrabajo,
                    tblusuario.idUsuario, 
                    tblusuario.Nombres, 
                    tblusuario.Apellidos,
                    DATEDIFF(CURDATE(), tblusuario.FechaIngreso) / 30 AS meses_en_empresa,
                    md.categoria, 
                    md.cumplimiento_procesos, md.atencion_cliente, md.tmo, md.productividad, md.wp,
                    k1.kpi_dia AS kpi_cumplimiento_procesos, k2.kpi_dia AS kpi_atencion_cliente, k3.kpi_dia AS kpi_tmo, 
                    k4.kpi_dia AS kpi_productividad, k5.kpi_dia AS kpi_wp,
                    p1.pago_above AS pago_above_cp, p1.pago_target AS pago_target_cp, p1.pago_over AS pago_over_cp,
                    p2.pago_above AS pago_above_ac, p2.pago_target AS pago_target_ac, p2.pago_over AS pago_over_ac,
                    p3.pago_above AS pago_above_tmo, p3.pago_target AS pago_target_tmo, p3.pago_over AS pago_over_tmo,
                    p4.pago_above AS pago_above_product, p4.pago_target AS pago_target_product, p4.pago_over AS pago_over_product,
                    p5.pago_above AS pago_above_wp, p5.pago_target AS pago_target_wp, p5.pago_over AS pago_over_wp,
                    
                    (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END),"DIA", "NOCHE")) as TipoTurnoEvaluado,
                        -- Contar turnos Día y Noche
                    SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) AS cantidad_dia,
                    SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END) AS cantidad_noche,
        
                    
                        -- Cálculo de bonificación para Cumplimiento de Procesos
                    ROUND(
                        CASE 
                            WHEN md.cumplimiento_procesos * 10 < (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k1.kpi_dia, k1.kpi_noche)) * k1.porcentaje_above THEN 0
                            WHEN md.cumplimiento_procesos * 10 >= (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k1.kpi_dia, k1.kpi_noche)) * k1.porcentaje_above AND md.cumplimiento_procesos * 10 < (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k1.kpi_dia, k1.kpi_noche)) THEN (p1.pago_above * k1.peso) / 100
                            WHEN md.cumplimiento_procesos * 10 >= (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k1.kpi_dia, k1.kpi_noche)) AND md.cumplimiento_procesos * 10 < (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k1.kpi_dia, k1.kpi_noche)) * k1.porcentaje_over THEN (p1.pago_target * k1.peso) / 100
                            ELSE (p1.pago_over * k1.peso) / 100
                        END) AS bonificacion_cumplimiento_procesos,
                    
                        -- Cálculo de % de Cumplimiento de Procesos
                    ROUND(
                        CASE 
                            WHEN (md.cumplimiento_procesos * 10 / (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k1.kpi_dia, k1.kpi_noche)))*100 >= 110 THEN 110
                            ELSE (md.cumplimiento_procesos * 10 / (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k1.kpi_dia, k1.kpi_noche))) * 100
                        END) AS cumplimiento_cumplimiento_procesos,
                    
                    
                        -- Cálculo de bonificación para Atención al Cliente
                    ROUND(
                        CASE 
                            WHEN md.atencion_cliente * 10 < (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k2.kpi_dia, k2.kpi_noche)) * k2.porcentaje_above THEN 0
                            WHEN md.atencion_cliente * 10 >= (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k2.kpi_dia, k2.kpi_noche)) * k2.porcentaje_above AND md.atencion_cliente * 10 < (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k2.kpi_dia, k2.kpi_noche)) THEN (p2.pago_above * k2.peso) / 100
                            WHEN md.atencion_cliente * 10 >= (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k2.kpi_dia, k2.kpi_noche)) AND md.atencion_cliente * 10 < (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k2.kpi_dia, k2.kpi_noche)) * k2.porcentaje_over THEN (p2.pago_target * k2.peso) / 100
                            ELSE (p2.pago_over * k2.peso) / 100
                        END) AS bonificacion_atencion_cliente,
                    
                        -- Cálculo de % de Cumplimiento de Atención al Cliente
                    ROUND(
                        CASE 
                            WHEN (md.atencion_cliente * 10 / (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k2.kpi_dia, k2.kpi_noche))) >= 110 THEN 110
                            ELSE (md.atencion_cliente * 10 / (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k2.kpi_dia, k2.kpi_noche))) * 100
                        END) AS cumplimiento_atencion_cliente,
                    
                
                    
                    
                        -- Cálculo de bonificación para TMO
                    ROUND(
                        CASE 
                            WHEN md.tmo > (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k3.kpi_dia, k3.kpi_noche)) * k3.porcentaje_above THEN 0
                            WHEN md.tmo > (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k3.kpi_dia, k3.kpi_noche)) AND md.tmo <= (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k3.kpi_dia, k3.kpi_noche)) * k3.porcentaje_above THEN (p3.pago_above * k3.peso) / 100
                            WHEN md.tmo > (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k3.kpi_dia, k3.kpi_noche)) * k3.porcentaje_over AND md.tmo <= (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k3.kpi_dia, k3.kpi_noche)) THEN (p3.pago_target * k3.peso) / 100
                            ELSE (p3.pago_over * k3.peso) / 100
                        END) AS bonificacion_tmo,
                    
                        -- Cálculo de % de Cumplimiento de TMO
                    ROUND(
                        CASE 
                            WHEN ((IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k3.kpi_dia, k3.kpi_noche)) / md.tmo) * 100 >= 110 THEN 110
                            ELSE ((IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k3.kpi_dia, k3.kpi_noche)) / md.tmo) * 100
                        END) AS cumplimiento_tmo,
                    
                    
                    
                        -- Cálculo de bonificación para Productividad
                    ROUND(
                        CASE 
                            WHEN md.productividad < (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k4.kpi_dia, k4.kpi_noche)) * k4.porcentaje_above THEN 0
                            WHEN md.productividad >= (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k4.kpi_dia, k4.kpi_noche)) * k4.porcentaje_above AND md.productividad < (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k4.kpi_dia, k4.kpi_noche)) THEN (p4.pago_above * k4.peso) / 100
                            WHEN md.productividad >= (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k4.kpi_dia, k4.kpi_noche)) AND md.productividad < (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k4.kpi_dia, k4.kpi_noche)) * k4.porcentaje_over THEN (p4.pago_target * k4.peso) / 100
                            ELSE (p4.pago_over * k4.peso) / 100
                        END) AS bonificacion_productividad,
                    
                        -- Cálculo de % de Cumplimiento de Productividad
                    ROUND(
                        CASE 
                            WHEN (md.productividad / (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k4.kpi_dia, k4.kpi_noche))) * 100 >= 110 THEN 110
                            ELSE (md.productividad / (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k4.kpi_dia, k4.kpi_noche))) * 100
                        END) AS cumplimiento_productividad,
                    
                    
                        -- Cálculo de bonificación para WP
                    ROUND(
                        CASE 
                            WHEN md.wp > (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k5.kpi_dia, k5.kpi_noche)) * k5.porcentaje_above THEN 0
                            WHEN md.wp > (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k5.kpi_dia, k5.kpi_noche)) AND md.wp <=(IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k5.kpi_dia, k5.kpi_noche)) * k5.porcentaje_above THEN (p5.pago_above * k5.peso) / 100     
                            WHEN md.wp > (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k5.kpi_dia, k5.kpi_noche)) * k5.porcentaje_over AND md.wp <= (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k5.kpi_dia, k5.kpi_noche)) THEN (p5.pago_target * k5.peso) / 100 
                            ELSE (p5.pago_over * k5.peso) / 100
                        END) AS bonificacion_wp,
                    
                        -- Cálculo de % de Cumplimiento de WP
                    ROUND(
                        CASE 
                            WHEN ((IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k5.kpi_dia, k5.kpi_noche)) / md.wp) * 100 >= 110 THEN 110
                            ELSE ((IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k5.kpi_dia, k5.kpi_noche)) / md.wp) * 100
                        END) AS cumplimiento_wp,
                    
                -- Cálculo del desempeño final basado en la suma de cumplimientos
                    ROUND
                        (ROUND(
                            CASE 
                                WHEN (md.cumplimiento_procesos * 10 / (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k1.kpi_dia, k1.kpi_noche)))*100 >= 110 THEN 110
                                ELSE (md.cumplimiento_procesos * 10 / (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k1.kpi_dia, k1.kpi_noche))) * 100
                            END,2) * 0.30 + 
                        ROUND(
                            CASE 
                                WHEN (md.atencion_cliente * 10 / (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k2.kpi_dia, k2.kpi_noche))) >= 110 THEN 110
                                ELSE (md.atencion_cliente * 10 / (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k2.kpi_dia, k2.kpi_noche))) * 100
                            END,2) * 0.30 + 
                        ROUND(
                            CASE 
                                WHEN ((IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k3.kpi_dia, k3.kpi_noche)) / md.tmo) * 100 >= 110 THEN 110
                                ELSE ((IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k3.kpi_dia, k3.kpi_noche)) / md.tmo) * 100
                            END,2) * 0.15 + 
                        ROUND(
                            CASE 
                                WHEN (md.productividad / (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k4.kpi_dia, k4.kpi_noche))) * 100 >= 110 THEN 110
                                ELSE (md.productividad / (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k4.kpi_dia, k4.kpi_noche))) * 100
                            END,2) * 0.15 + 
                        ROUND(
                            CASE 
                                WHEN ((IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k5.kpi_dia, k5.kpi_noche)) / md.wp) * 100 >= 110 THEN 110
                                ELSE ((IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k5.kpi_dia, k5.kpi_noche)) / md.wp) * 100
                            END,2) * 0.10)  AS desempeno_final,

                    -- Horas trabajadas
                    CASE
                        -- Horarios que cruzan la medianoche
                        WHEN h.HoraFin < h.HoraInicio THEN 
                            TIME_FORMAT(SEC_TO_TIME(SUM(TIME_TO_SEC(
                                TIMEDIFF(
                                    -- Si la hora de salida es al día siguiente, ajustamos el cálculo
                                    IF(a_fin.FechaHoraRegistro < CONCAT(p.FechaTrabajo, " ", h.HoraInicio), 
                                        CONCAT(DATE_ADD(p.FechaTrabajo, INTERVAL 1 DAY), " ", h.HoraFin), 
                                        a_fin.FechaHoraRegistro), 
                                    a_inicio.FechaHoraRegistro)
                            ))), "%H:%i:%s")
                        ELSE 
                            -- Horarios normales
                            TIME_FORMAT(SEC_TO_TIME(SUM(TIME_TO_SEC(TIMEDIFF(a_fin.FechaHoraRegistro, a_inicio.FechaHoraRegistro)))), "%H:%i:%s")
                    END AS horas_trabajadas,
                    
                    -- Tardanzas
                    CASE
                        -- Horarios que cruzan la medianoche
                        WHEN h.HoraFin < h.HoraInicio THEN 
                            CASE 
                               
                                WHEN a_inicio.FechaHoraRegistro > CONCAT(p.FechaTrabajo, " ", h.HoraInicio) THEN 
                                    TIME_FORMAT(SEC_TO_TIME(SUM(TIME_TO_SEC(TIMEDIFF(a_inicio.FechaHoraRegistro, CONCAT(p.FechaTrabajo, " ", h.HoraInicio))))), "%H:%i:%s")
                                
                                WHEN a_inicio.FechaHoraRegistro > CONCAT(DATE_ADD(p.FechaTrabajo, INTERVAL 1 DAY), " ", h.HoraFin) THEN 
                                    TIME_FORMAT(SEC_TO_TIME(SUM(TIME_TO_SEC(TIMEDIFF(a_inicio.FechaHoraRegistro, CONCAT(DATE_ADD(p.FechaTrabajo, INTERVAL 1 DAY), " ", h.HoraFin))))), "%H:%i:%s")
                                ELSE "00:00:00"
                            END
                        ELSE
                            -- Horarios normales que no cruzan la medianoche
                            CASE 
                                WHEN a_inicio.FechaHoraRegistro > CONCAT(p.FechaTrabajo, " ", h.HoraInicio) THEN 
                                    TIME_FORMAT(SEC_TO_TIME(SUM(TIME_TO_SEC(TIMEDIFF(a_inicio.FechaHoraRegistro, CONCAT(p.FechaTrabajo, " ", h.HoraInicio))))), "%H:%i:%s")
                                ELSE "00:00:00"
                            END
                    END AS tardanza,
                    
                    -- Horas extras
                    CASE
                        -- Horarios que cruzan la medianoche
                        WHEN h.HoraFin < h.HoraInicio THEN
                            CASE
                                -- Si la hora de salida es mayor que la hora fin al día siguiente
                                WHEN a_fin.FechaHoraRegistro > CONCAT(DATE_ADD(p.FechaTrabajo, INTERVAL 1 DAY), " ", h.HoraFin) THEN 
                                    TIMEDIFF(a_fin.FechaHoraRegistro, CONCAT(DATE_ADD(p.FechaTrabajo, INTERVAL 1 DAY), " ", h.HoraFin))
                                ELSE "00:00:00"
                            END
                        ELSE
                            -- Horarios normales
                            CASE
                                WHEN a_fin.FechaHoraRegistro > CONCAT(p.FechaTrabajo, " ", h.HoraFin) THEN 
                                    TIMEDIFF(a_fin.FechaHoraRegistro, CONCAT(p.FechaTrabajo, " ", h.HoraFin))
                                ELSE "00:00:00"
                            END
                    END AS horas_extras,
                    
                    -- Faltas
                    COUNT(CASE 
                        -- Si no hay registro de inicio ni fin
                        WHEN a_inicio.FechaHoraRegistro IS NULL AND a_fin.FechaHoraRegistro IS NULL THEN 1
                        -- Horarios que cruzan la medianoche
                        WHEN h.HoraFin < h.HoraInicio AND 
                             a_inicio.FechaHoraRegistro IS NULL AND a_fin.FechaHoraRegistro IS NULL THEN 1
                    END) AS total_faltas
                ');
                $this->join('usuario_grupostrabajo ug', 'tblusuario.IdUsuario = ug.IdUsuario');
                $this->join('grupostrabajo gt', 'ug.IDGrupoTrabajo = gt.IDGrupoTrabajo');
        $this->join('tbl_metricas_desempeno md', 'tblusuario.idUsuario = md.idUsuario');
        // LEFT JOIN con `temp_metricas_complementarias`
                
        $this->join('planificacion p', 'p.IdUsuario = tblusuario.idUsuario');
        $this->join('horarios h', 'p.id_horario = h.id_horario');
        $this->join('asistencia a_inicio', 'p.IdUsuario = a_inicio.IdUsuario AND a_inicio.TipoRegistro = "inicio" AND a_inicio.FechaHoraRegistro LIKE CONCAT(p.FechaTrabajo, "%") AND a_inicio.id_horario = p.id_horario','left');
        $this->join('asistencia a_fin', 'p.IdUsuario = a_fin.IdUsuario AND a_fin.TipoRegistro = "fin" AND a_fin.FechaHoraRegistro LIKE CONCAT(p.FechaTrabajo, "%") AND a_fin.id_horario = p.id_horario','left');
                
        $this->join('tbl_categoria_metrica c', 'md.categoria = c.nombre_categoria');
                
                // -- Uniones con las métricas de cada subcriterio
        $this->join('tbl_kpi_metrica k1', 'c.id_categoria = k1.id_categoria AND k1.id_subcriterio = 1');
        $this->join('tbl_pagos_metrica p1', 'c.id_categoria = p1.id_categoria AND p1.id_subcriterio = 1');
                
        $this->join('tbl_kpi_metrica k2', 'c.id_categoria = k2.id_categoria AND k2.id_subcriterio = 2');
        $this->join('tbl_pagos_metrica p2', 'c.id_categoria = p2.id_categoria AND p2.id_subcriterio = 2');
            
        $this->join('tbl_kpi_metrica k3', 'c.id_categoria = k3.id_categoria AND k3.id_subcriterio = 3');
        $this->join('tbl_pagos_metrica p3', 'c.id_categoria = p3.id_categoria AND p3.id_subcriterio = 3');
            
        $this->join('tbl_kpi_metrica k4', 'c.id_categoria = k4.id_categoria AND k4.id_subcriterio = 4');
        $this->join('tbl_pagos_metrica p4', 'c.id_categoria = p4.id_categoria AND p4.id_subcriterio = 4');
            
        $this->join('tbl_kpi_metrica k5', 'c.id_categoria = k5.id_categoria AND k5.id_subcriterio = 5');
        $this->join('tbl_pagos_metrica p5', 'c.id_categoria = p5.id_categoria AND p5.id_subcriterio = 5');
        $this->groupBy('tblusuario.idUsuario');
        $this->whereIn('ug.IDGrupoTrabajo', $grupoTrabajoIds);
        $this->where($adicionales);
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        if($tipofuncion == 'dataTable'){
            if (isset($get['search']) &&  $get['search']['value'] != "") 
            {
                $this->groupStart(); // Inicia un grupo de condiciones
                foreach ($get['columns'] as $k => $column) 
                {
                    if(array_key_exists($k, $fields))
                    {
                        $this->orLike($fields[$k], $get['search']['value']);
                    }
                }
                $this->groupEnd(); // Finaliza el grupo de condiciones
            }
            
            /*
            * ----------------------------
            * ORDENAMIENTO DE QUERY
            * ----------------------------
            */
            if (isset($get['order'])) {
                foreach ($get['order'] as $order) {
                    if(array_key_exists($order['column'], $fields))
                    {
                        $this->orderBy($fields[$order['column']], $order['dir']);
                    }
                }
            }
            /*
            * ----------------------------
            * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
            * ----------------------------
            */
            if (isset($get['length']) && isset($get['start'])) {
                $this->limit(intval($get['length']), intval($get['start']));
            }
        }    
        /*
        * ----------------------------
        * EJECUTAR CONSULTA Y DEVOLVER VALORES
        * ----------------------------
        */
        // $this->get();
        // return $this->getLastQuery();
        $result = $this->get()->getResultArray(); 
        
        // Retornar datos y totales
        return   $result;  

    }  
    
    public function listaMetricasServerSide($get, $adicionales, $grupoTrabajoIds, $tipofuncion)
    {
        
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
        // $this->globales = new Globales();
        $fields = array(
            0 => 'tblusuario.idUsuario',                  // ID Usuario
            1 => 'tblusuario.Nombres',                    // Nombres
            2 => 'tblusuario.Apellidos',                  // Apellidos
            3 => 'md.categoria',                          // Categoría
            4 => 'horas_trabajadas',                      // Horas Trabajadas
            5 => 'tardanza',                              // Tardanza
            6 => 'horas_extras',                          // Horas Extras
            7 => 'total_faltas',                          // Total Faltas
            8 => 'bono_desempeno',                        // Bono Desempeño
            9 => 'comision_total',                        // Comisión Total
        );

        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        $this->select('
                    tblusuario.idUsuario, 
                    tblusuario.Nombres, 
                    tblusuario.Apellidos,
                    tmc.dias_trabajo_efectivo,
                    tmc.fechas_trabajo_efectivo,
                    tmc.dias_teletrabajo,
                    tmc.fechas_teletrabajo,
                    tmc.HHEE25,
                    tmc.HHEE35,
                    tmc.HHEE_dominical_100,
                    tmc.HHEE_feriado,
                    tmc.HHEE_1ro_de_mayo,
                    tmc.HHEE_nocturnas,
                    tmc.bono_productividad,
                    tmc.otros_bonos,
                    tmc.bono_de_carrera,
                    tmc.bonificacion_por_desempeno,
                    tmc.bono_responsabilidad,
                    tmc.bono_inicio,
                    tmc.bono_veritombola,
                    tmc.comisiones_upselling,
                    tmc.reintegro_afecto,
                    tmc.gift_card,
                    tmc.gift_card_upselling,
                    tmc.obsequios_upselling,
                    tmc.obsequios_al_personal,
                    tmc.descuento_por_equipo_celular,
                    tmc.descuento_uniforme_materiales,
                    tmc.descuento_por_demos,
                    tmc.descuento_eps,
                    tmc.descuento_alarma_verisure,
                    tmc.descuento_seguro_rimac,
                    tmc.observaciones,
                    tmc.matricula,
                    DATEDIFF(CURDATE(), tblusuario.FechaIngreso) / 30 AS meses_en_empresa,
                    md.categoria, 
                    md.cumplimiento_procesos, md.atencion_cliente, md.tmo, md.productividad, md.wp,
                    k1.kpi_dia AS kpi_cumplimiento_procesos, k2.kpi_dia AS kpi_atencion_cliente, k3.kpi_dia AS kpi_tmo, 
                    k4.kpi_dia AS kpi_productividad, k5.kpi_dia AS kpi_wp,
                    p1.pago_above AS pago_above_cp, p1.pago_target AS pago_target_cp, p1.pago_over AS pago_over_cp,
                    p2.pago_above AS pago_above_ac, p2.pago_target AS pago_target_ac, p2.pago_over AS pago_over_ac,
                    p3.pago_above AS pago_above_tmo, p3.pago_target AS pago_target_tmo, p3.pago_over AS pago_over_tmo,
                    p4.pago_above AS pago_above_product, p4.pago_target AS pago_target_product, p4.pago_over AS pago_over_product,
                    p5.pago_above AS pago_above_wp, p5.pago_target AS pago_target_wp, p5.pago_over AS pago_over_wp,
                    
                    (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END),"DIA", "NOCHE")) as TipoTurnoEvaluado,
                        -- Contar turnos Día y Noche
                    SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) AS cantidad_dia,
                    SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END) AS cantidad_noche,
        
                    
                        -- Cálculo de bonificación para Cumplimiento de Procesos
                    ROUND(
                        CASE 
                            WHEN md.cumplimiento_procesos * 10 < (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k1.kpi_dia, k1.kpi_noche)) * k1.porcentaje_above THEN 0
                            WHEN md.cumplimiento_procesos * 10 >= (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k1.kpi_dia, k1.kpi_noche)) * k1.porcentaje_above AND md.cumplimiento_procesos * 10 < (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k1.kpi_dia, k1.kpi_noche)) THEN (p1.pago_above * k1.peso) / 100
                            WHEN md.cumplimiento_procesos * 10 >= (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k1.kpi_dia, k1.kpi_noche)) AND md.cumplimiento_procesos * 10 < (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k1.kpi_dia, k1.kpi_noche)) * k1.porcentaje_over THEN (p1.pago_target * k1.peso) / 100
                            ELSE (p1.pago_over * k1.peso) / 100
                        END) AS bonificacion_cumplimiento_procesos,
                    
                        -- Cálculo de % de Cumplimiento de Procesos
                    ROUND(
                        CASE 
                            WHEN (md.cumplimiento_procesos * 10 / (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k1.kpi_dia, k1.kpi_noche)))*100 >= 110 THEN 110
                            ELSE (md.cumplimiento_procesos * 10 / (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k1.kpi_dia, k1.kpi_noche))) * 100
                        END) AS cumplimiento_cumplimiento_procesos,
                    
                    
                        -- Cálculo de bonificación para Atención al Cliente
                    ROUND(
                        CASE 
                            WHEN md.atencion_cliente * 10 < (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k2.kpi_dia, k2.kpi_noche)) * k2.porcentaje_above THEN 0
                            WHEN md.atencion_cliente * 10 >= (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k2.kpi_dia, k2.kpi_noche)) * k2.porcentaje_above AND md.atencion_cliente * 10 < (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k2.kpi_dia, k2.kpi_noche)) THEN (p2.pago_above * k2.peso) / 100
                            WHEN md.atencion_cliente * 10 >= (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k2.kpi_dia, k2.kpi_noche)) AND md.atencion_cliente * 10 < (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k2.kpi_dia, k2.kpi_noche)) * k2.porcentaje_over THEN (p2.pago_target * k2.peso) / 100
                            ELSE (p2.pago_over * k2.peso) / 100
                        END) AS bonificacion_atencion_cliente,
                    
                        -- Cálculo de % de Cumplimiento de Atención al Cliente
                    ROUND(
                        CASE 
                            WHEN (md.atencion_cliente * 10 / (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k2.kpi_dia, k2.kpi_noche))) >= 110 THEN 110
                            ELSE (md.atencion_cliente * 10 / (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k2.kpi_dia, k2.kpi_noche))) * 100
                        END) AS cumplimiento_atencion_cliente,
                    
                
                    
                    
                        -- Cálculo de bonificación para TMO
                    ROUND(
                        CASE 
                            WHEN md.tmo > (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k3.kpi_dia, k3.kpi_noche)) * k3.porcentaje_above THEN 0
                            WHEN md.tmo > (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k3.kpi_dia, k3.kpi_noche)) AND md.tmo <= (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k3.kpi_dia, k3.kpi_noche)) * k3.porcentaje_above THEN (p3.pago_above * k3.peso) / 100
                            WHEN md.tmo > (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k3.kpi_dia, k3.kpi_noche)) * k3.porcentaje_over AND md.tmo <= (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k3.kpi_dia, k3.kpi_noche)) THEN (p3.pago_target * k3.peso) / 100
                            ELSE (p3.pago_over * k3.peso) / 100
                        END) AS bonificacion_tmo,
                    
                        -- Cálculo de % de Cumplimiento de TMO
                    ROUND(
                        CASE 
                            WHEN ((IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k3.kpi_dia, k3.kpi_noche)) / md.tmo) * 100 >= 110 THEN 110
                            ELSE ((IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k3.kpi_dia, k3.kpi_noche)) / md.tmo) * 100
                        END) AS cumplimiento_tmo,
                    
                    
                    
                        -- Cálculo de bonificación para Productividad
                    ROUND(
                        CASE 
                            WHEN md.productividad < (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k4.kpi_dia, k4.kpi_noche)) * k4.porcentaje_above THEN 0
                            WHEN md.productividad >= (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k4.kpi_dia, k4.kpi_noche)) * k4.porcentaje_above AND md.productividad < (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k4.kpi_dia, k4.kpi_noche)) THEN (p4.pago_above * k4.peso) / 100
                            WHEN md.productividad >= (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k4.kpi_dia, k4.kpi_noche)) AND md.productividad < (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k4.kpi_dia, k4.kpi_noche)) * k4.porcentaje_over THEN (p4.pago_target * k4.peso) / 100
                            ELSE (p4.pago_over * k4.peso) / 100
                        END) AS bonificacion_productividad,
                    
                        -- Cálculo de % de Cumplimiento de Productividad
                    ROUND(
                        CASE 
                            WHEN (md.productividad / (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k4.kpi_dia, k4.kpi_noche))) * 100 >= 110 THEN 110
                            ELSE (md.productividad / (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k4.kpi_dia, k4.kpi_noche))) * 100
                        END) AS cumplimiento_productividad,
                    
                    
                        -- Cálculo de bonificación para WP
                    ROUND(
                        CASE 
                            WHEN md.wp > (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k5.kpi_dia, k5.kpi_noche)) * k5.porcentaje_above THEN 0
                            WHEN md.wp > (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k5.kpi_dia, k5.kpi_noche)) AND md.wp <=(IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k5.kpi_dia, k5.kpi_noche)) * k5.porcentaje_above THEN (p5.pago_above * k5.peso) / 100     
                            WHEN md.wp > (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k5.kpi_dia, k5.kpi_noche)) * k5.porcentaje_over AND md.wp <= (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k5.kpi_dia, k5.kpi_noche)) THEN (p5.pago_target * k5.peso) / 100 
                            ELSE (p5.pago_over * k5.peso) / 100
                        END) AS bonificacion_wp,
                    
                        -- Cálculo de % de Cumplimiento de WP
                    ROUND(
                        CASE 
                            WHEN ((IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k5.kpi_dia, k5.kpi_noche)) / md.wp) * 100 >= 110 THEN 110
                            ELSE ((IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k5.kpi_dia, k5.kpi_noche)) / md.wp) * 100
                        END) AS cumplimiento_wp,
                    
                -- Cálculo del desempeño final basado en la suma de cumplimientos
                    ROUND
                        (ROUND(
                            CASE 
                                WHEN (md.cumplimiento_procesos * 10 / (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k1.kpi_dia, k1.kpi_noche)))*100 >= 110 THEN 110
                                ELSE (md.cumplimiento_procesos * 10 / (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k1.kpi_dia, k1.kpi_noche))) * 100
                            END,2) * 0.30 + 
                        ROUND(
                            CASE 
                                WHEN (md.atencion_cliente * 10 / (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k2.kpi_dia, k2.kpi_noche))) >= 110 THEN 110
                                ELSE (md.atencion_cliente * 10 / (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k2.kpi_dia, k2.kpi_noche))) * 100
                            END,2) * 0.30 + 
                        ROUND(
                            CASE 
                                WHEN ((IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k3.kpi_dia, k3.kpi_noche)) / md.tmo) * 100 >= 110 THEN 110
                                ELSE ((IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k3.kpi_dia, k3.kpi_noche)) / md.tmo) * 100
                            END,2) * 0.15 + 
                        ROUND(
                            CASE 
                                WHEN (md.productividad / (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k4.kpi_dia, k4.kpi_noche))) * 100 >= 110 THEN 110
                                ELSE (md.productividad / (IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k4.kpi_dia, k4.kpi_noche))) * 100
                            END,2) * 0.15 + 
                        ROUND(
                            CASE 
                                WHEN ((IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k5.kpi_dia, k5.kpi_noche)) / md.wp) * 100 >= 110 THEN 110
                                ELSE ((IF(SUM(CASE WHEN h.tipoTurno = "D" THEN 1 ELSE 0 END) >= SUM(CASE WHEN h.tipoTurno = "N" THEN 1 ELSE 0 END), k5.kpi_dia, k5.kpi_noche)) / md.wp) * 100
                            END,2) * 0.10)  AS desempeno_final,
                            
                    -- Horas trabajadas
                    CASE
                        -- Horarios que cruzan la medianoche
                        WHEN h.HoraFin < h.HoraInicio THEN 
                            TIME_FORMAT(SEC_TO_TIME(SUM(TIME_TO_SEC(
                                TIMEDIFF(
                                    -- Si la hora de salida es al día siguiente, ajustamos el cálculo
                                    IF(a_fin.FechaHoraRegistro < CONCAT(p.FechaTrabajo, " ", h.HoraInicio), 
                                        CONCAT(DATE_ADD(p.FechaTrabajo, INTERVAL 1 DAY), " ", h.HoraFin), 
                                        a_fin.FechaHoraRegistro), 
                                    a_inicio.FechaHoraRegistro)
                            ))), "%H:%i:%s")
                        ELSE 
                            -- Horarios normales
                            TIME_FORMAT(SEC_TO_TIME(SUM(TIME_TO_SEC(TIMEDIFF(a_fin.FechaHoraRegistro, a_inicio.FechaHoraRegistro)))), "%H:%i:%s")
                    END AS horas_trabajadas,
                    
                    -- Tardanzas
                    CASE
                        -- Horarios que cruzan la medianoche
                        WHEN h.HoraFin < h.HoraInicio THEN 
                            CASE 
                               
                                WHEN a_inicio.FechaHoraRegistro > CONCAT(p.FechaTrabajo, " ", h.HoraInicio) THEN 
                                    TIME_FORMAT(SEC_TO_TIME(SUM(TIME_TO_SEC(TIMEDIFF(a_inicio.FechaHoraRegistro, CONCAT(p.FechaTrabajo, " ", h.HoraInicio))))), "%H:%i:%s")
                                
                                WHEN a_inicio.FechaHoraRegistro > CONCAT(DATE_ADD(p.FechaTrabajo, INTERVAL 1 DAY), " ", h.HoraFin) THEN 
                                    TIME_FORMAT(SEC_TO_TIME(SUM(TIME_TO_SEC(TIMEDIFF(a_inicio.FechaHoraRegistro, CONCAT(DATE_ADD(p.FechaTrabajo, INTERVAL 1 DAY), " ", h.HoraFin))))), "%H:%i:%s")
                                ELSE "00:00:00"
                            END
                        ELSE
                            -- Horarios normales que no cruzan la medianoche
                            CASE 
                                WHEN a_inicio.FechaHoraRegistro > CONCAT(p.FechaTrabajo, " ", h.HoraInicio) THEN 
                                    TIME_FORMAT(SEC_TO_TIME(SUM(TIME_TO_SEC(TIMEDIFF(a_inicio.FechaHoraRegistro, CONCAT(p.FechaTrabajo, " ", h.HoraInicio))))), "%H:%i:%s")
                                ELSE "00:00:00"
                            END
                    END AS tardanza,
                    
                    -- Horas extras
                    CASE
                        -- Horarios que cruzan la medianoche
                        WHEN h.HoraFin < h.HoraInicio THEN
                            CASE
                                -- Si la hora de salida es mayor que la hora fin al día siguiente
                                WHEN a_fin.FechaHoraRegistro > CONCAT(DATE_ADD(p.FechaTrabajo, INTERVAL 1 DAY), " ", h.HoraFin) THEN 
                                    TIMEDIFF(a_fin.FechaHoraRegistro, CONCAT(DATE_ADD(p.FechaTrabajo, INTERVAL 1 DAY), " ", h.HoraFin))
                                ELSE "00:00:00"
                            END
                        ELSE
                            -- Horarios normales
                            CASE
                                WHEN a_fin.FechaHoraRegistro > CONCAT(p.FechaTrabajo, " ", h.HoraFin) THEN 
                                    TIMEDIFF(a_fin.FechaHoraRegistro, CONCAT(p.FechaTrabajo, " ", h.HoraFin))
                                ELSE "00:00:00"
                            END
                    END AS horas_extras,
                    
                    -- Faltas
                    COUNT(CASE 
                        -- Si no hay registro de inicio ni fin
                        WHEN a_inicio.FechaHoraRegistro IS NULL AND a_fin.FechaHoraRegistro IS NULL THEN 1
                        -- Horarios que cruzan la medianoche
                        WHEN h.HoraFin < h.HoraInicio AND 
                             a_inicio.FechaHoraRegistro IS NULL AND a_fin.FechaHoraRegistro IS NULL THEN 1
                    END) AS total_faltas
                ');
        $this->join('tbl_metricas_desempeno md', 'tblusuario.idUsuario = md.idUsuario');
        // LEFT JOIN con `temp_metricas_complementarias`
        $this->join('temp_metricas_complementarias tmc', 'tmc.matricula = tblusuario.Matricula');
                
        $this->join('planificacion p', 'p.IdUsuario = tblusuario.idUsuario');
        $this->join('horarios h', 'p.id_horario = h.id_horario');
        $this->join('asistencia a_inicio', 'p.IdUsuario = a_inicio.IdUsuario AND a_inicio.TipoRegistro = "inicio" AND a_inicio.FechaHoraRegistro LIKE CONCAT(p.FechaTrabajo, "%") AND a_inicio.id_horario = p.id_horario','left');
        $this->join('asistencia a_fin', 'p.IdUsuario = a_fin.IdUsuario AND a_fin.TipoRegistro = "fin" AND a_fin.FechaHoraRegistro LIKE CONCAT(p.FechaTrabajo, "%") AND a_fin.id_horario = p.id_horario','left');
                
        $this->join('tbl_categoria_metrica c', 'md.categoria = c.nombre_categoria');
                
                // -- Uniones con las métricas de cada subcriterio
        $this->join('tbl_kpi_metrica k1', 'c.id_categoria = k1.id_categoria AND k1.id_subcriterio = 1');
        $this->join('tbl_pagos_metrica p1', 'c.id_categoria = p1.id_categoria AND p1.id_subcriterio = 1');
                
        $this->join('tbl_kpi_metrica k2', 'c.id_categoria = k2.id_categoria AND k2.id_subcriterio = 2');
        $this->join('tbl_pagos_metrica p2', 'c.id_categoria = p2.id_categoria AND p2.id_subcriterio = 2');
            
        $this->join('tbl_kpi_metrica k3', 'c.id_categoria = k3.id_categoria AND k3.id_subcriterio = 3');
        $this->join('tbl_pagos_metrica p3', 'c.id_categoria = p3.id_categoria AND p3.id_subcriterio = 3');
            
        $this->join('tbl_kpi_metrica k4', 'c.id_categoria = k4.id_categoria AND k4.id_subcriterio = 4');
        $this->join('tbl_pagos_metrica p4', 'c.id_categoria = p4.id_categoria AND p4.id_subcriterio = 4');
            
        $this->join('tbl_kpi_metrica k5', 'c.id_categoria = k5.id_categoria AND k5.id_subcriterio = 5');
        $this->join('tbl_pagos_metrica p5', 'c.id_categoria = p5.id_categoria AND p5.id_subcriterio = 5');
        $this->groupBy('tblusuario.idUsuario');
        $this->whereIn('p.IDGrupoTrabajo', $grupoTrabajoIds);
        $this->where($adicionales);
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        if($tipofuncion == 'dataTable'){
            if (isset($get['search']) &&  $get['search']['value'] != "") 
            {
                $this->groupStart(); // Inicia un grupo de condiciones
                foreach ($get['columns'] as $k => $column) 
                {
                    if(array_key_exists($k, $fields))
                    {
                        $this->orLike($fields[$k], $get['search']['value']);
                    }
                }
                $this->groupEnd(); // Finaliza el grupo de condiciones
            }
            
            /*
            * ----------------------------
            * ORDENAMIENTO DE QUERY
            * ----------------------------
            */
            if (isset($get['order'])) {
                foreach ($get['order'] as $order) {
                    if(array_key_exists($order['column'], $fields))
                    {
                        $this->orderBy($fields[$order['column']], $order['dir']);
                    }
                }
            }
            /*
            * ----------------------------
            * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
            * ----------------------------
            */
            if (isset($get['length']) && isset($get['start'])) {
                $this->limit(intval($get['length']), intval($get['start']));
            }
        }    
        /*
        * ----------------------------
        * EJECUTAR CONSULTA Y DEVOLVER VALORES
        * ----------------------------
        */
        // $this->get();
        // return $this->getLastQuery();
        $result = $this->get()->getResultArray(); 
        
        // Retornar datos y totales
        return   $result;  

    }
    
}
