<?php namespace App\Models;

use CodeIgniter\Model;

class UsuarioGruposTrabajoModel extends Model {
    protected $table = 'usuario_grupostrabajo';
    protected $primaryKey = 'IdUsuario';
    protected $allowedFields = ['IdUsuario', 'IDGrupoTrabajo', 'UsuarioRegistra', 'FechaRegistra'];
    protected $useAutoIncrement = false;
    protected $useSoftDeletes = false;
    
    public function listarUsuariosGrupoTrabajo($array)
    {
        $builder = $this->db->table('vista_usuarios_grupostrabajo');
        
        if(isset($array['idusuario']) && $array['idusuario'] != '' && $array['idusuario'] != null)
        {
            $builder->where('IdUsuario', $array['idusuario']);
        }
        
        if(isset($array['idgrupotrabajo']) && $array['idgrupotrabajo'] != '' && $array['idgrupotrabajo'] != null)
        {
            $builder->where('IDGrupoTrabajo', $array['idgrupotrabajo']);
        }
        
        if(isset($array['like']) && $array['like'] != '' && $array['like'] != null)
        {
            $builder->where("(Matricula LIKE '%".$array['like']."%' OR 
            Nombres LIKE '%".$array['like']."%' OR
            Apellidos LIKE '%".$array['like']."%' OR 
            Usuario LIKE '%".$array['like']."%' OR 
            CONCAT(Nombres, ' ',Apellidos) LIKE '%".$array['like']."%' OR 
            NumeroDoc LIKE '%".$array['like']."%')");
        }
        
        $sql = $builder->getCompiledSelect();
        $datos = $this->db->query($sql)->getResultArray();
        
        return $datos;
    }

    public function listarUsuariosGrupoTrabajoServerSide($get, $adicionales)
    {
        
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
        
        $fields = array(
            0 => 'vista_usuarios_grupostrabajo.Matricula',
            1 => 'vista_usuarios_grupostrabajo.Nombres',
            2 => 'vista_usuarios_grupostrabajo.Apellidos',
            3 => 'tblusuario.FechaIngreso',
            4 => 'tblusuario.FechaCese');
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $builder = $this->db->table('vista_usuarios_grupostrabajo')
                    ->select('vista_usuarios_grupostrabajo.IdGrupoTrabajo,vista_usuarios_grupostrabajo.Nombres, vista_usuarios_grupostrabajo.Apellidos, vista_usuarios_grupostrabajo.Matricula, tblusuario.FechaIngreso, tblusuario.FechaCese,vista_usuarios_grupostrabajo.IdUsuario')
                    ->join('tblusuario', 'tblusuario.IdUsuario = vista_usuarios_grupostrabajo.IdUsuario','left')
                    ->groupBy('vista_usuarios_grupostrabajo.IdUsuario') // Agregar GROUP BY para evitar duplicados
                    ->where($adicionales);
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        if ($get['search']['value'] != "") 
        {
            $builder->groupStart(); // Inicia un grupo de condiciones
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $this->orLike($fields[$k], $get['search']['value']);
                }
            }
            $builder->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        // $this->where('horarios.EliminacionLogica',1);
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        foreach ($get['order'] as $order) {
            if(array_key_exists($order['column'], $fields))
            {
                $builder->orderBy($fields[$order['column']], $order['dir']);
            }
        }
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        $builder->limit($get['length'], $get['start']);
        /*
        * ----------------------------
        * EJECUTAR CONSULTA Y DEVOLVER VALORES
        * ----------------------------
        */
        // $this->get();
        // return $this->getLastQuery();
        $result = $builder->get()->getResultArray(); 
        
        // Retornar datos y totales
        return   $result;         
        
    }
    
    public function contarUsuariosGrupoTrabajoServerSide($adicionales)
    {
        $builder = $this->db->table('vista_usuarios_grupostrabajo')
                    ->select('vista_usuarios_grupostrabajo.Nombres, vista_usuarios_grupostrabajo.Apellidos, vista_usuarios_grupostrabajo.Matricula, tblusuario.FechaIngreso, tblusuario.FechaCese,vista_usuarios_grupostrabajo.IdUsuario')
                    ->join('tblusuario', 'tblusuario.IdUsuario = vista_usuarios_grupostrabajo.IdUsuario')
                    ->groupBy('vista_usuarios_grupostrabajo.IdUsuario') // Agregar GROUP BY para evitar duplicados
                    ->where($adicionales);
        
        $result = $builder->get()->getResultArray(); 
        
        // Retornar datos y totales
        return   $result;   
    }
    
}
