<?php
namespace App\Models;
use CodeIgniter\Model;

class UsuarioDelegacionesModel extends Model
{
    protected $table      = 'usuario_delegaciones';
    protected $primaryKey = 'IDUsuario';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDUsuario', 'IDDelegacion', 'UsuarioRegistra', 'FechaRegistra', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listarDelegacionesXUsuario($idUsuario)
    {
        $this->select('usuario_delegaciones.IDUsuario,
            usuario_delegaciones.IDDelegacion,
            estructura_delegacion.Delegacion,
            estructura_delegacion.CC,
            estructura_delegacion.LN');
        $this->join('estructura_delegacion', 'usuario_delegaciones.IDDelegacion = estructura_delegacion.IDDelegacion');
        $this->where('usuario_delegaciones.IDUsuario', $idUsuario);

        $datos = $this->findAll();
        return $datos;
    }
    
}