<?php
namespace App\Models;
use CodeIgniter\Model;

class RegionProvinciaModel extends Model
{
    protected $table        = 'region_provincia';
    protected $primaryKey   = 'IDProvincia';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['Provincia', 'IDDepartamento', 'CodigoINEI', 'CodUbigeoReniec', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listaGeneralRegionProvincia($get, $adicionales) 
    {
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
        
        $fields = array(
            0 => 'region_provincia.IDProvincia', 
            1 => 'region_pais.Pais', 
            2 => 'region_departamento.Departamento',
            3 => 'region_provincia.Provincia',
            4 => 'region_provincia.CodigoINEI',
            5 => 'region_provincia.CodUbigeoReniec',
            6 => 'region_provincia.Estado');
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS (NUEVO)
        * ----------------------------
        */
        
        $this->select("COUNT(*) AS total");
        $totalQuery = $this->get();
        $totalRecords = $totalQuery->getRow()->total;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $this->select('
            region_provincia.IDProvincia,
            region_pais.Pais,
            region_departamento.Departamento,
            region_provincia.Provincia,
            region_provincia.CodigoINEI,
            region_provincia.CodUbigeoReniec,
            region_provincia.Estado');
            
        $this->join('region_departamento', 'region_provincia.IDDepartamento = region_departamento.IDDepartamento', 'left');
        $this->join('region_pais', 'region_departamento.IDPais = region_pais.IDPais', 'left');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $this->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $this->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        if(isset($adicionales['IDDepartamento']) && $adicionales['IDDepartamento'] != "TOTAL")
        {
            $this->where("region_provincia.IDDepartamento", $adicionales['IDDepartamento']);
        }
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS FILTRADOS (NUEVO)
        * ----------------------------
        */
        
        $this->select("COUNT(*) AS filtered");
        $filteredQuery = $this->get();
        if ($filteredQuery === false) {
            // echo $this->getLastQuery();
            // return [];
            $filteredRecords = $totalRecords;
        }
        $filteredRecords = $filteredQuery->getRow()->filtered;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY (NUEVAMENTE PARA ENVIAR LA DATA)
        * ----------------------------
        */
        
        $this->select('
            region_provincia.IDProvincia,
            region_pais.Pais,
            region_departamento.Departamento,
            region_provincia.Provincia,
            region_provincia.CodigoINEI,
            region_provincia.CodUbigeoReniec,
            region_provincia.Estado');
            
        $this->join('region_departamento', 'region_provincia.IDDepartamento = region_departamento.IDDepartamento', 'left');
        $this->join('region_pais', 'region_departamento.IDPais = region_pais.IDPais', 'left');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $this->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $this->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        if(isset($adicionales['IDDepartamento']) && $adicionales['IDDepartamento'] != "TOTAL")
        {
            $this->where("region_provincia.IDDepartamento", $adicionales['IDDepartamento']);
        }
        
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        
        foreach ($get['order'] as $order) {
            if(array_key_exists($order['column'], $fields))
            {
                $this->orderBy($fields[$order['column']], $order['dir']);
            }
        }
        
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        
        /* Antes de Codeiginiter 4.5.4*/
        // $this->limit($get['length'], $get['start']);
        
        /*
        * ----------------------------
        * EJECUTAR CONSULTA, LIMITAR CANTIDAD DE RESULTADOS DE QUERY Y DEVOLVER VALORES
        * ----------------------------
        */
        
        /* Antes de Codeiginiter 4.5.4*/
        // $this->get();
        // return $this->getLastQuery();
        
        // $result = $this->get()->getResultArray();
        // return $result;
        
        /* Despues de Codeiginiter 4.5.4*/
        $result = $this->findAll($get['length'], $get['start']);
        
        // echo $this->getLastQuery();
        // exit;
        
        // return $result;
        
        /*
        * ----------------------------
        * DEVOLVER RESULTADOS Y LOS DATOS DE PAGINACIÓN
        * ----------------------------
        */
        
        return [
            'draw'              => $get['draw'], // Número de la petición para sincronizar
            'recordsTotal'      => $totalRecords, // Total de registros sin filtrar
            'recordsFiltered'   => $filteredRecords, // Total de registros después de aplicar filtros
            'data'              => $result // Los datos actuales para mostrar
        ];
    }

    public function obtenerProvincia($idProvincia)
    {
        $this->select('region_provincia.IDProvincia,
            region_provincia.Provincia,
            region_departamento.IDDepartamento,
            region_departamento.Departamento,
            region_departamento.IDPais,
            region_pais.Pais');
        $this->join('region_departamento', 'region_provincia.IDDepartamento = region_departamento.IDDepartamento', 'left');
        $this->join('region_pais', 'region_departamento.IDPais = region_pais.IDPais', 'left');
        $this->where('region_provincia.IDProvincia', $idProvincia);

        $datos = $this->first();
        return $datos;
    }
    
}