<?php
namespace App\Models;
use CodeIgniter\Model;

class RegionDistritoModel extends Model
{
    protected $table        = 'region_distrito';
    protected $primaryKey   = 'IDDistrito';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['Distrito', 'IDProvincia', 'CodigoINEI', 'CodUbigeoReniec', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listaGeneralRegionDistrito($get, $adicionales) 
    {
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
        
        $fields = array(
            0 => 'region_distrito.IDDistrito', 
            1 => 'region_pais.Pais', 
            2 => 'region_departamento.Departamento',
            3 => 'region_provincia.Provincia',
            4 => 'region_distrito.Distrito',
            5 => 'region_distrito.CodigoINEI',
            6 => 'region_distrito.CodUbigeoReniec',
            7 => 'region_distrito.Estado');
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS (NUEVO)
        * ----------------------------
        */
        
        $this->select("COUNT(*) AS total");
        $totalQuery = $this->get();
        $totalRecords = $totalQuery->getRow()->total;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $this->select('
            region_distrito.IDDistrito,
            region_pais.Pais,
            region_departamento.Departamento,
            region_provincia.Provincia,
            region_distrito.Distrito,
            region_distrito.CodigoINEI,
            region_distrito.CodUbigeoReniec,
            region_distrito.Estado');
            
        $this->join('region_provincia', 'region_distrito.IDProvincia = region_provincia.IDProvincia', 'left');
        $this->join('region_departamento', 'region_provincia.IDDepartamento = region_departamento.IDDepartamento', 'left');
        $this->join('region_pais', 'region_departamento.IDPais = region_pais.IDPais', 'left');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $this->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $this->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        if(isset($adicionales['IDProvincia']) && $adicionales['IDProvincia'] != "TOTAL")
        {
            $this->where("region_distrito.IDProvincia", $adicionales['IDProvincia']);
        }
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS FILTRADOS (NUEVO)
        * ----------------------------
        */
        
        $this->select("COUNT(*) AS filtered");
        $filteredQuery = $this->get();
        if ($filteredQuery === false) {
            // echo $this->getLastQuery();
            // return [];
            $filteredRecords = $totalRecords;
        }
        $filteredRecords = $filteredQuery->getRow()->filtered;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY (NUEVAMENTE PARA ENVIAR LA DATA)
        * ----------------------------
        */
        
        $this->select('
            region_distrito.IDDistrito,
            region_pais.Pais,
            region_departamento.Departamento,
            region_provincia.Provincia,
            region_distrito.Distrito,
            region_distrito.CodigoINEI,
            region_distrito.CodUbigeoReniec,
            region_distrito.Estado');
            
        $this->join('region_provincia', 'region_distrito.IDProvincia = region_provincia.IDProvincia', 'left');
        $this->join('region_departamento', 'region_provincia.IDDepartamento = region_departamento.IDDepartamento', 'left');
        $this->join('region_pais', 'region_departamento.IDPais = region_pais.IDPais', 'left');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $this->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $this->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        if(isset($adicionales['IDProvincia']) && $adicionales['IDProvincia'] != "TOTAL")
        {
            $this->where("region_distrito.IDProvincia", $adicionales['IDProvincia']);
        }
        
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        
        foreach ($get['order'] as $order) {
            if(array_key_exists($order['column'], $fields))
            {
                $this->orderBy($fields[$order['column']], $order['dir']);
            }
        }
        
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        
        /* Antes de Codeiginiter 4.5.4*/
        // $this->limit($get['length'], $get['start']);
        
        /*
        * ----------------------------
        * EJECUTAR CONSULTA, LIMITAR CANTIDAD DE RESULTADOS DE QUERY Y DEVOLVER VALORES
        * ----------------------------
        */
        
        /* Antes de Codeiginiter 4.5.4*/
        // $this->get();
        // return $this->getLastQuery();
        
        // $result = $this->get()->getResultArray();
        // return $result;
        
        /* Despues de Codeiginiter 4.5.4*/
        $result = $this->findAll($get['length'], $get['start']);
        
        // echo $this->getLastQuery();
        // exit;
        
        // return $result;
        
        /*
        * ----------------------------
        * DEVOLVER RESULTADOS Y LOS DATOS DE PAGINACIÓN
        * ----------------------------
        */
        
        return [
            'draw'              => $get['draw'], // Número de la petición para sincronizar
            'recordsTotal'      => $totalRecords, // Total de registros sin filtrar
            'recordsFiltered'   => $filteredRecords, // Total de registros después de aplicar filtros
            'data'              => $result // Los datos actuales para mostrar
        ];
    }

    public function obtenerRegionxIDDistrito($idDistrito)
    {
        $this->select('region_distrito.IDDistrito,
            region_distrito.Distrito,
            region_distrito.Distrito AS "desc_ubigeo_inei",
            region_distrito.CodigoINEI AS "cod_ubigeo",
            region_distrito.IDProvincia,
            region_provincia.Provincia,
            region_provincia.IDDepartamento,
            region_departamento.Departamento,
            region_departamento.Departamento AS "desc_dep_inei",
            region_departamento.IDPais,
            region_pais.Pais,
            region_pais.CodigoInternacional');
        
        $this->join('region_provincia', 'region_distrito.IDProvincia = region_provincia.IDProvincia', 'left');
        $this->join('region_departamento', 'region_provincia.IDDepartamento = region_departamento.IDDepartamento', 'left');
        $this->join('region_pais', 'region_departamento.IDPais = region_pais.IDPais', 'left');
        
        $this->where('region_distrito.IDDistrito', $idDistrito);
        
        $datos = $this->first();
        return $datos;
    }
    
}