<?php
namespace App\Models;
use CodeIgniter\Model;

class EstructuraSubareaModel extends Model
{
    protected $table        = 'estructura_subarea';
    protected $primaryKey   = 'IDSubarea';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDArea', 'Subarea', 'Observacion', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listaGeneralEstructuraSubarea($get, $adicionales) 
    {
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
        
        $fields = array(
            0 => 'estructura_subarea.IDSubarea', 
            1 => 'estructura_direccion.Direccion', 
            2 => 'estructura_area.Area', 
            3 => 'estructura_subarea.Subarea', 
            5 => 'estructura_subarea.Observacion',
            6 => 'estructura_subarea.Estado');
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS (NUEVO)
        * ----------------------------
        */
        
        $this->select("COUNT(*) AS total");
        $totalQuery = $this->get();
        $totalRecords = $totalQuery->getRow()->total;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $this->select('
            estructura_subarea.IDSubarea,
            estructura_subarea.Subarea,
            estructura_area.Area,
            estructura_direccion.Direccion,
            estructura_subarea.Observacion,
            estructura_subarea.Estado,
            tblusuario.Nombres AS "NombreResponsablePrincipal",
            tblusuario.Apellidos AS "ApellidoResponsablePrincipal",
            tblusuario.Matricula AS "MatriculaResponsablePrincipal"');
        
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->join('estructura_subarea_responsable', 'estructura_subarea.IDSubarea = estructura_subarea_responsable.IDSubarea AND estructura_subarea_responsable.Principal = "Y"', 'left');
        $this->join('tblusuario', 'estructura_subarea_responsable.IDResponsable = tblusuario.IdUsuario', 'left');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if($k == 4)
                {
                    $this->orLike("CONCAT(tblusuario.Matricula, ' | ', tblusuario.Nombres, ' ', tblusuario.Apellidos)", $get['search']['value']);
                }
                else 
                {
                    if(array_key_exists($k, $fields))
                    {
                        $this->orLike($fields[$k], $get['search']['value']);
                    }
                }
            }
            
            $this->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        if(isset($adicionales['IDArea']) && $adicionales['IDArea'] != "TOTAL")
        {
            $this->where("estructura_subarea.IDArea", $adicionales['IDArea']);
        }
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS FILTRADOS (NUEVO)
        * ----------------------------
        */
        
        $this->select("COUNT(*) AS filtered");
        $filteredQuery = $this->get();
        if ($filteredQuery === false) {
            // echo $this->getLastQuery();
            // return [];
            $filteredRecords = $totalRecords;
        }
        $filteredRecords = $filteredQuery->getRow()->filtered;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY (NUEVAMENTE PARA ENVIAR LA DATA)
        * ----------------------------
        */
        
        $this->select('
            estructura_subarea.IDSubarea,
            estructura_subarea.Subarea,
            estructura_area.Area,
            estructura_direccion.Direccion,
            estructura_subarea.Observacion,
            estructura_subarea.Estado,
            tblusuario.Nombres AS "NombreResponsablePrincipal",
            tblusuario.Apellidos AS "ApellidoResponsablePrincipal",
            tblusuario.Matricula AS "MatriculaResponsablePrincipal"');
        
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->join('estructura_subarea_responsable', 'estructura_subarea.IDSubarea = estructura_subarea_responsable.IDSubarea AND estructura_subarea_responsable.Principal = "Y"', 'left');
        $this->join('tblusuario', 'estructura_subarea_responsable.IDResponsable = tblusuario.IdUsuario', 'left');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if($k == 4)
                {
                    $this->orLike("CONCAT(tblusuario.Matricula, ' | ', tblusuario.Nombres, ' ', tblusuario.Apellidos)", $get['search']['value']);
                }
                else 
                {
                    if(array_key_exists($k, $fields))
                    {
                        $this->orLike($fields[$k], $get['search']['value']);
                    }
                }
            }
            
            $this->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        if(isset($adicionales['IDArea']) && $adicionales['IDArea'] != "TOTAL")
        {
            $this->where("estructura_subarea.IDArea", $adicionales['IDArea']);
        }
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        
        foreach ($get['order'] as $order) 
        {
            if ($order['column'] == 4) 
            {
                $this->orderBy("CONCAT(tblusuario.Matricula, ' | ', tblusuario.Nombres, ' ', tblusuario.Apellidos)", $order['dir']);
            } 
            else 
            {
                if(array_key_exists($order['column'], $fields))
                {
                    $field = $fields[$order['column']];
                    
                    // Para las otras columnas, aplica el orden normal
                    $this->orderBy($field, $order['dir']);
                }
            }
        }
        
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        
        /* Antes de Codeiginiter 4.5.4*/
        // $this->limit($get['length'], $get['start']);
        
        /*
        * ----------------------------
        * EJECUTAR CONSULTA, LIMITAR CANTIDAD DE RESULTADOS DE QUERY Y DEVOLVER VALORES
        * ----------------------------
        */
        
        /* Antes de Codeiginiter 4.5.4*/
        // $this->get();
        // return $this->getLastQuery();
        
        // $result = $this->get()->getResultArray();
        // return $result;
        
        /* Despues de Codeiginiter 4.5.4*/
        $result = $this->findAll($get['length'], $get['start']);
        
        // echo $this->getLastQuery();
        // exit;
        
        // return $result;
        
        /*
        * ----------------------------
        * DEVOLVER RESULTADOS Y LOS DATOS DE PAGINACIÓN
        * ----------------------------
        */
        
        return [
            'draw'              => $get['draw'], // Número de la petición para sincronizar
            'recordsTotal'      => $totalRecords, // Total de registros sin filtrar
            'recordsFiltered'   => $filteredRecords, // Total de registros después de aplicar filtros
            'data'              => $result // Los datos actuales para mostrar
        ];
    }

    public function obtenerSubareaXNombres($subarea, $area, $direccion)
    {
        $this->select('estructura_subarea.IDSubarea,
            estructura_subarea.Subarea,
            estructura_subarea_responsable.IDResponsable AS "Responsable_Subarea",
            estructura_subarea.IDArea,
            estructura_area.Area,
            estructura_area_responsable.IDResponsable AS "Responsable_Area",
            estructura_area.IDDireccion,
            estructura_direccion.Direccion,
            estructura_direccion_responsable.IDResponsable AS "Responsable_Direccion"');
        $this->join('estructura_subarea_responsable', 'estructura_subarea.IDSubarea = estructura_subarea_responsable.IDSubarea AND estructura_subarea_responsable.Principal="Y"', 'left');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_area_responsable', 'estructura_area.IDArea = estructura_area_responsable.IDArea AND estructura_area_responsable.Principal="Y"', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->join('estructura_direccion_responsable', 'estructura_direccion.IDDireccion = estructura_direccion_responsable.IDDireccion AND estructura_direccion_responsable.Principal="Y"', 'left');
        $this->where('estructura_subarea.Subarea', $subarea);
        $this->where('estructura_area.Area', $area);
        $this->where('estructura_direccion.Direccion', $direccion);

        $datos = $this->first();
        return $datos;
    }
    
    public function obtenerSubarea($idSubarea)
    {
        $this->select('estructura_subarea.IDSubarea,
            estructura_subarea.Subarea,
            estructura_subarea_responsable.IDResponsable AS "Responsable_Subarea",
            estructura_subarea.IDArea,
            estructura_area.Area,
            estructura_area_responsable.IDResponsable AS "Responsable_Area",
            estructura_area.IDDireccion,
            estructura_direccion.Direccion,
            estructura_direccion_responsable.IDResponsable AS "Responsable_Direccion"');
        $this->join('estructura_subarea_responsable', 'estructura_subarea.IDSubarea = estructura_subarea_responsable.IDSubarea AND estructura_subarea_responsable.Principal="Y"', 'left');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_area_responsable', 'estructura_area.IDArea = estructura_area_responsable.IDArea AND estructura_area_responsable.Principal="Y"', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->join('estructura_direccion_responsable', 'estructura_direccion.IDDireccion = estructura_direccion_responsable.IDDireccion AND estructura_direccion_responsable.Principal="Y"', 'left');
        $this->where('estructura_subarea.IDSubarea', $idSubarea);

        $datos = $this->first();
        return $datos;
    }
    
    public function listadoEstructuraDepartamentalTotal()
    {
        $this->select('estructura_subarea.IDSubarea,
            estructura_subarea.Subarea,
            estructura_subarea.IDArea,
            estructura_area.Area,
            estructura_area.IDDireccion,
            estructura_direccion.Direccion,
            GROUP_CONCAT(DISTINCT (CONCAT("[",CC,"-",LN,"]")) SEPARATOR "<br>") AS "Delegaciones"');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->join('estructura_subarea_delegacion', 'estructura_subarea.IDSubarea = estructura_subarea_delegacion.IDSubarea', 'left');
        $this->join('estructura_delegacion', 'estructura_subarea_delegacion.IDDelegacion = estructura_delegacion.IDDelegacion AND estructura_delegacion.Estado = "A"', 'left');
        
        $this->where('estructura_subarea.Estado', "A");
        $this->where('estructura_area.Estado', "A");
        $this->where('estructura_direccion.Estado', "A");
        
        $this->groupBy('estructura_subarea.IDSubarea');
        
        $datos = $this->findAll();
        return $datos;
    }
    
    // public function listadoCargosSelect($variable)
    // {
    //     $this->select('IDCargo,
    //         Cargo,
    //         Categoria');
    //     $this->like("Cargo", $variable);
    //     $this->orLike("Categoria", $variable);
        
    //     $datos = $this->findAll();
    //     return $datos;
    // }
}