<?php
namespace App\Models;
use CodeIgniter\Model;

class EstructuraSubareaDelegacionesModel extends Model
{
    protected $table        = 'estructura_subarea_delegacion';
    protected $primaryKey   = 'IDSubarea';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDSubarea', 'IDDelegacion', 'UsuarioRegistra', 'FechaRegistra', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listarDelegacionesXSubarea($idSubarea)
    {
        $this->select('estructura_subarea_delegacion.IDSubarea,
            estructura_subarea_delegacion.IDDelegacion,
            estructura_delegacion.Delegacion,
            estructura_delegacion.CC,
            estructura_delegacion.LN');
        $this->join('estructura_delegacion', 'estructura_subarea_delegacion.IDDelegacion = estructura_delegacion.IDDelegacion');
        $this->where('estructura_subarea_delegacion.IDSubarea', $idSubarea);

        $datos = $this->findAll();
        return $datos;
    }
    
    public function listarEstructuraXDelegacion($idDelegacion)
    {
        $this->select('estructura_subarea_delegacion.IDDelegacion,
            estructura_subarea_delegacion.IDSubarea,
            estructura_subarea.Subarea,
            estructura_subarea.Correo,
            estructura_subarea.IDArea,
            estructura_area.Area,
            estructura_area.IDDireccion,
            estructura_direccion.Direccion,
            estructura_delegacion.Delegacion,
            estructura_delegacion.CC,
            estructura_delegacion.LN,
            estructura_subarea_responsable.IDResponsable AS "Responsable_Subarea",
            estructura_area_responsable.IDResponsable AS "Responsable_Area",
            estructura_direccion_responsable.IDResponsable AS "Responsable_Direccion"');
        $this->join('estructura_subarea', 'estructura_subarea_delegacion.IDSubarea = estructura_subarea.IDSubarea', 'left');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->join('estructura_subarea_responsable', 'estructura_subarea.IDSubarea = estructura_subarea_responsable.IDSubarea AND estructura_subarea_responsable.Principal="Y"', 'left');
        $this->join('estructura_area_responsable', 'estructura_area.IDArea = estructura_area_responsable.IDArea AND estructura_area_responsable.Principal="Y"', 'left');
        $this->join('estructura_direccion_responsable', 'estructura_direccion.IDDireccion = estructura_direccion_responsable.IDDireccion AND estructura_direccion_responsable.Principal="Y"', 'left');
        $this->join('estructura_delegacion', 'estructura_subarea_delegacion.IDDelegacion = estructura_delegacion.IDDelegacion');
        
        if($idDelegacion != "")
        {
            $this->where('estructura_subarea_delegacion.IDDelegacion', $idDelegacion);
        }
        
        $this->where('estructura_subarea.Estado', "A");
        
        $datos = $this->findAll();
        return $datos;
    }
}