<?php
namespace App\Models;
use CodeIgniter\Model;

class EstructuraDelegacionModel extends Model
{
    protected $table        = 'estructura_delegacion';
    protected $primaryKey   = 'IDDelegacion';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['CC', 'LN', 'Delegacion', 'Observacion', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listaGeneralDelegaciones($get, $adicionales) 
    {
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
        
        $fields = array(
            0 => 'IDDelegacion', 
            1 => 'Delegacion', 
            2 => 'CC',
            3 => 'LN',
            4 => 'Observacion',
            5 => 'Estado');
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS (NUEVO)
        * ----------------------------
        */
        
        $this->select("COUNT(*) AS total");
        $totalQuery = $this->get();
        $totalRecords = $totalQuery->getRow()->total;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $this->select('
            IDDelegacion, 
            Delegacion, 
            CC, 
            LN, 
            Observacion, 
            Estado');
            
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $this->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $this->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS FILTRADOS (NUEVO)
        * ----------------------------
        */
        
        $this->select("COUNT(*) AS filtered");
        $filteredQuery = $this->get();
        if ($filteredQuery === false) {
            // echo $this->getLastQuery();
            // return [];
            $filteredRecords = $totalRecords;
        }
        $filteredRecords = $filteredQuery->getRow()->filtered;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY (NUEVAMENTE PARA ENVIAR LA DATA)
        * ----------------------------
        */
        
        $this->select('
            IDDelegacion, 
            Delegacion, 
            CC, 
            LN, 
            Observacion, 
            Estado');
            
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $this->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $this->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        
        foreach ($get['order'] as $order) {
            if(array_key_exists($order['column'], $fields))
            {
                $this->orderBy($fields[$order['column']], $order['dir']);
            }
        }
        
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        
        /* Antes de Codeiginiter 4.5.4*/
        // $this->limit($get['length'], $get['start']);
        
        /*
        * ----------------------------
        * EJECUTAR CONSULTA, LIMITAR CANTIDAD DE RESULTADOS DE QUERY Y DEVOLVER VALORES
        * ----------------------------
        */
        
        /* Antes de Codeiginiter 4.5.4*/
        // $this->get();
        // return $this->getLastQuery();
        
        // $result = $this->get()->getResultArray();
        // return $result;
        
        /* Despues de Codeiginiter 4.5.4*/
        $result = $this->findAll($get['length'], $get['start']);
        
        // echo $this->getLastQuery();
        // exit;
        
        // return $result;
        
        /*
        * ----------------------------
        * DEVOLVER RESULTADOS Y LOS DATOS DE PAGINACIÓN
        * ----------------------------
        */
        
        return [
            'draw'              => $get['draw'], // Número de la petición para sincronizar
            'recordsTotal'      => $totalRecords, // Total de registros sin filtrar
            'recordsFiltered'   => $filteredRecords, // Total de registros después de aplicar filtros
            'data'              => $result // Los datos actuales para mostrar
        ];
    }

    public function listadoDelegacionesBusqueda($array)
    {
        $this->select('
            IDDelegacion,
            CC,
            LN,
            Delegacion');
            
        if(isset($array['variable']) && $array['variable'] != '')
        {
            $this->where("(CC LIKE '%".$array['variable']."%' OR 
                LN LIKE '%".$array['variable']."%' OR
                Delegacion LIKE '%".$array['variable']."%')");
        }
        
        $this->where("Estado", "A");
        
        $datos = $this->findAll();
        return $datos;
    }
    
    public function listadoCCDelegacionesEstructura($array)
    {
        $this->select('
            CC,
            COUNT(*),
            IF(CC="910", "SSCC", IF(CC="920", "SSRR", Delegacion)) AS "Delegacion"');
            
        $this->groupBy('CC');
        
        $datos = $this->findAll();
        return $datos;
    }
    // public function listadoCargosSelect($variable)
    // {
    //     $this->select('IDCargo,
    //         Cargo,
    //         Categoria');
    //     $this->like("Cargo", $variable);
    //     $this->orLike("Categoria", $variable);
        
    //     $datos = $this->findAll();
    //     return $datos;
    // }
}