<?php
namespace App\Models;
use CodeIgniter\Model;

class DireccionModel extends Model
{
    protected $table        = 'direccion';
    protected $primaryKey   = 'id_direccion';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['Nombre', 'Direccion', 'id_distrito', 'fechahorareg', 'fija', 'eliminacion_logica', 'codigoSunat'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listaGeneralDireccion($get, $adicionales) 
    {
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
        
        $fields = array(
            0 => 'direccion.id_direccion', 
            1 => 'direccion.Nombre', 
            2 => 'direccion.Direccion',
            4 => 'direccion.codigoSunat',
            5 => 'direccion.eliminacion_logica');
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS (NUEVO)
        * ----------------------------
        */
        
        $this->select("COUNT(*) AS total");
        $totalQuery = $this->get();
        $totalRecords = $totalQuery->getRow()->total;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $this->select('
            direccion.id_direccion,
            direccion.Nombre,
            direccion.Direccion,
            direccion.codigoSunat,
            direccion.eliminacion_logica,
            region_distrito.Distrito,
            region_provincia.Provincia,
            region_departamento.Departamento');
        $this->join('region_distrito', 'direccion.id_distrito = region_distrito.IDDistrito', 'left');
        $this->join('region_provincia', 'region_distrito.IDProvincia = region_provincia.IDProvincia', 'left');
        $this->join('region_departamento', 'region_provincia.IDDepartamento = region_departamento.IDDepartamento', 'left');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if($k == 3)
                {
                    $this->orLike("CONCAT(region_departamento.Departamento, ' - ', region_provincia.Provincia, ' - ', region_distrito.Distrito)", $get['search']['value']);
                }
                else 
                {
                    if(array_key_exists($k, $fields))
                    {
                        $this->orLike($fields[$k], $get['search']['value']);
                    }
                }
            }
            
            $this->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS FILTRADOS (NUEVO)
        * ----------------------------
        */
        
        $this->select("COUNT(*) AS filtered");
        $filteredQuery = $this->get();
        if ($filteredQuery === false) {
            // echo $this->getLastQuery();
            // return [];
            $filteredRecords = $totalRecords;
        }
        $filteredRecords = $filteredQuery->getRow()->filtered;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY (NUEVAMENTE PARA ENVIAR LA DATA)
        * ----------------------------
        */
        
        $this->select('
            direccion.id_direccion,
            direccion.Nombre,
            direccion.Direccion,
            direccion.codigoSunat,
            direccion.eliminacion_logica,
            region_distrito.Distrito,
            region_provincia.Provincia,
            region_departamento.Departamento');
        $this->join('region_distrito', 'direccion.id_distrito = region_distrito.IDDistrito', 'left');
        $this->join('region_provincia', 'region_distrito.IDProvincia = region_provincia.IDProvincia', 'left');
        $this->join('region_departamento', 'region_provincia.IDDepartamento = region_departamento.IDDepartamento', 'left');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if($k == 3)
                {
                    $this->orLike("CONCAT(region_departamento.Departamento, ' - ', region_provincia.Provincia, ' - ', region_distrito.Distrito)", $get['search']['value']);
                }
                else 
                {
                    if(array_key_exists($k, $fields))
                    {
                        $this->orLike($fields[$k], $get['search']['value']);
                    }
                }
            }
            
            $this->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        
        foreach ($get['order'] as $order) 
        {
            if ($order['column'] == 3) 
            {
                $this->orderBy("CONCAT(region_departamento.Departamento, ' - ', region_provincia.Provincia, ' - ', region_distrito.Distrito)", $order['dir']);
            } 
            else 
            {
                if(array_key_exists($order['column'], $fields))
                {
                    $field = $fields[$order['column']];
                    
                    // Para las otras columnas, aplica el orden normal
                    $this->orderBy($field, $order['dir']);
                }
            }
        }
        
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        
        /* Antes de Codeiginiter 4.5.4*/
        // $this->limit($get['length'], $get['start']);
        
        /*
        * ----------------------------
        * EJECUTAR CONSULTA, LIMITAR CANTIDAD DE RESULTADOS DE QUERY Y DEVOLVER VALORES
        * ----------------------------
        */
        
        /* Antes de Codeiginiter 4.5.4*/
        // $this->get();
        // return $this->getLastQuery();
        
        // $result = $this->get()->getResultArray();
        // return $result;
        
        /* Despues de Codeiginiter 4.5.4*/
        $result = $this->findAll($get['length'], $get['start']);
        
        // echo $this->getLastQuery();
        // exit;
        
        // return $result;
        
        /*
        * ----------------------------
        * DEVOLVER RESULTADOS Y LOS DATOS DE PAGINACIÓN
        * ----------------------------
        */
        
        return [
            'draw'              => $get['draw'], // Número de la petición para sincronizar
            'recordsTotal'      => $totalRecords, // Total de registros sin filtrar
            'recordsFiltered'   => $filteredRecords, // Total de registros después de aplicar filtros
            'data'              => $result // Los datos actuales para mostrar
        ];
    }

    public function obtenerDireccion($idDireccion)
    {
        $this->select('
            direccion.id_direccion,
            direccion.Nombre,
            direccion.Direccion,
            direccion.codigoSunat,
            direccion.eliminacion_logica,
            direccion.id_distrito,
            region_distrito.Distrito,
            region_distrito.CodigoINEI,
            region_provincia.IDProvincia,
            region_provincia.Provincia,
            region_departamento.IDDepartamento,
            region_departamento.Departamento');
        $this->join('region_distrito', 'direccion.id_distrito = region_distrito.IDDistrito', 'left');
        $this->join('region_provincia', 'region_distrito.IDProvincia = region_provincia.IDProvincia', 'left');
        $this->join('region_departamento', 'region_provincia.IDDepartamento = region_departamento.IDDepartamento', 'left');
        $this->where("direccion.id_direccion", $idDireccion);
        $datos = $this->first();
        return $datos;
    }
    
    public function listadoDireccion()
    {
        $this->select('
            direccion.id_direccion,
            direccion.Nombre,
            direccion.Direccion,
            direccion.codigoSunat,
            direccion.eliminacion_logica,
            region_distrito.Distrito AS "desc_ubigeo_inei",
            region_provincia.Provincia AS "desc_prov_inei",
            region_departamento.Departamento AS "desc_dep_inei"');
        $this->join('region_distrito', 'direccion.id_distrito = region_distrito.IDDistrito', 'left');
        $this->join('region_provincia', 'region_distrito.IDProvincia = region_provincia.IDProvincia', 'left');
        $this->join('region_departamento', 'region_provincia.IDDepartamento = region_departamento.IDDepartamento', 'left');
        $datos = $this->findAll();
        return $datos;
    }
    
    public function listadoDireccionBusqueda($array)
    {
        $this->select('
            direccion.id_direccion,
            direccion.Nombre,
            direccion.Direccion,
            direccion.id_distrito,
            direccion.codigoSunat,
            region_distrito.Distrito,
            region_distrito.CodUbigeoReniec AS "UbigeoDistrito",
            region_distrito.IDProvincia,
            region_provincia.Provincia,
            region_provincia.IDDepartamento,
            region_departamento.Departamento');
            
        $this->join('region_distrito', 'direccion.id_distrito = region_distrito.IDDistrito', 'left');
        $this->join('region_provincia', 'region_distrito.IDProvincia = region_provincia.IDProvincia', 'left');
        $this->join('region_departamento', 'region_provincia.IDDepartamento = region_departamento.IDDepartamento', 'left');
        
        $this->groupStart(); // Inicia un grupo de condiciones
            $this->orLike("direccion.Direccion", $array['variable']);
            $this->orLike("region_distrito.Distrito", $array['variable']);
            $this->orLike("region_provincia.Provincia", $array['variable']);
            $this->orLike("region_departamento.Departamento", $array['variable']);
        $this->groupEnd();
        // $this->get();
        // return $this->getLastQuery();
        $datos = $this->findAll();
        
        return $datos;
    }
}