<?php
namespace App\Models;
use CodeIgniter\Model;

class CategoriaMetricaModel extends Model
{
    protected $table      = 'tbl_categoria_metrica';
    protected $primaryKey = 'id_categoria';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['id_categoria', 'nombre_categoria', 'bono_90', 'bono_100'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listaControlIndicadoresServerSide($get, $adicionales, $categoria = "cumplimiento_procesos")
    {
        
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
        // $this->globales = new Globales();
        $fields = array(
            0 => 'tbl_categoria_metrica.nombre_categoria',
            1 => 'tbl_categoria_metrica.bono_90',
            2 => 'tbl_categoria_metrica.bono_100',
            3 => 'tbl_kpi_metrica.kpi_dia',
            4 => 'tbl_kpi_metrica.kpi_noche',
            5 => 'tbl_kpi_metrica.peso');
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        $this->select('tbl_categoria_metrica.nombre_categoria, tbl_categoria_metrica.bono_90, tbl_categoria_metrica.bono_100, 
                    p1.id_pago AS id_pago_cumplimiento_procesos,p1.pago_above AS pago_above_cumplimiento_procesos,p1.pago_target AS pago_target_cumplimiento_procesos, p1.pago_over AS pago_over_cumplimiento_procesos,
                    p2.id_pago AS id_pago_atencion_cliente,p2.pago_above AS pago_above_atencion_cliente,p2.pago_target AS pago_target_atencion_cliente, p2.pago_over AS pago_over_atencion_cliente,
                    p3.id_pago AS id_pago_tmo,p3.pago_above AS pago_above_tmo,p3.pago_target AS pago_target_tmo, p3.pago_over AS pago_over_tmo,
                    p4.id_pago AS id_pago_productividad,p4.pago_above AS pago_above_productividad,p4.pago_target AS pago_target_productividad, p4.pago_over AS pago_over_productividad,
                    p5.id_pago AS id_pago_wp,p5.pago_above AS pago_above_wp,p5.pago_target AS pago_target_wp, p5.pago_over AS pago_over_wp,
                    k1.id_kpi AS id_kpi_cumplimiento_procesos,k1.kpi_dia AS kpi_dia_cumplimiento_procesos, k1.kpi_noche AS kpi_noche_cumplimiento_procesos, k1.porcentaje_above AS kpi_porcentaje_above_cumplimiento_procesos, k1.porcentaje_over AS kpi_porcentaje_over_cumplimiento_procesos, k1.peso AS kpi_peso_cumplimiento_procesos, 
                    k2.id_kpi AS id_kpi_atencion_cliente,k2.kpi_dia AS kpi_dia_atencion_cliente, k2.kpi_noche AS kpi_noche_atencion_cliente, k2.porcentaje_above AS kpi_porcentaje_above_atencion_cliente, k2.porcentaje_over AS kpi_porcentaje_over_atencion_cliente, k2.peso AS kpi_peso_atencion_cliente, 
                    k3.id_kpi AS id_kpi_tmo,k3.kpi_dia AS kpi_dia_tmo, k3.kpi_noche AS kpi_noche_tmo, k3.porcentaje_above AS kpi_porcentaje_above_tmo, k3.porcentaje_over AS kpi_porcentaje_over_tmo, k3.peso AS kpi_peso_tmo, 
                    k4.id_kpi AS id_kpi_productividad,k4.kpi_dia AS kpi_dia_productividad, k4.kpi_noche AS kpi_noche_productividad, k4.porcentaje_above AS kpi_porcentaje_above_productividad, k4.porcentaje_over AS kpi_porcentaje_over_productividad, k4.peso AS kpi_peso_productividad,
                    k5.id_kpi AS id_kpi_wp,k5.kpi_dia AS kpi_dia_wp, k5.kpi_noche AS kpi_noche_wp, k5.porcentaje_above AS kpi_porcentaje_above_wp, k5.porcentaje_over AS kpi_porcentaje_over_wp, k5.peso AS kpi_peso_wp');
                    
        $this->join('tbl_kpi_metrica k1', 'tbl_categoria_metrica.id_categoria = k1.id_categoria AND k1.id_subcriterio = 1');
        $this->join('tbl_pagos_metrica p1', 'tbl_categoria_metrica.id_categoria = p1.id_categoria AND p1.id_subcriterio = 1');
                
        $this->join('tbl_kpi_metrica k2', 'tbl_categoria_metrica.id_categoria = k2.id_categoria AND k2.id_subcriterio = 2');
        $this->join('tbl_pagos_metrica p2', 'tbl_categoria_metrica.id_categoria = p2.id_categoria AND p2.id_subcriterio = 2');
            
        $this->join('tbl_kpi_metrica k3', 'tbl_categoria_metrica.id_categoria = k3.id_categoria AND k3.id_subcriterio = 3');
        $this->join('tbl_pagos_metrica p3', 'tbl_categoria_metrica.id_categoria = p3.id_categoria AND p3.id_subcriterio = 3');
            
        $this->join('tbl_kpi_metrica k4', 'tbl_categoria_metrica.id_categoria = k4.id_categoria AND k4.id_subcriterio = 4');
        $this->join('tbl_pagos_metrica p4', 'tbl_categoria_metrica.id_categoria = p4.id_categoria AND p4.id_subcriterio = 4');
            
        $this->join('tbl_kpi_metrica k5', 'tbl_categoria_metrica.id_categoria = k5.id_categoria AND k5.id_subcriterio = 5');
        $this->join('tbl_pagos_metrica p5', 'tbl_categoria_metrica.id_categoria = p5.id_categoria AND p5.id_subcriterio = 5');    
        
        // $this->where($adicionales);
        
        // Aplicar filtro por categoría
        if ($categoria !== "todos") {
            $this->groupStart();
            $this->orWhere("k1.id_subcriterio", $categoria === "cumplimiento_procesos" ? 1 : null);
            $this->orWhere("k2.id_subcriterio", $categoria === "atencion_cliente" ? 2 : null);
            $this->orWhere("k3.id_subcriterio", $categoria === "tmo" ? 3 : null);
            $this->orWhere("k4.id_subcriterio", $categoria === "productividad" ? 4 : null);
            $this->orWhere("k5.id_subcriterio", $categoria === "wp" ? 5 : null);
            $this->groupEnd();
        }
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $this->orLike($fields[$k], $get['search']['value']);
                }
            }
            $this->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        // $this->where('horarios.EliminacionLogica',1);
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        foreach ($get['order'] as $order) {
            if(array_key_exists($order['column'], $fields))
            {
                $this->orderBy($fields[$order['column']], $order['dir']);
            }
        }
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        $this->limit(intval($get['length']), intval($get['start']));
        /*
        * ----------------------------
        * EJECUTAR CONSULTA Y DEVOLVER VALORES
        * ----------------------------
        */

        $result = $this->get()->getResultArray(); 
        
        // Retornar datos y totales
        return   $result;  

    }
    
    public function listaControlIndicadores($whereControlIndicadores)
    {
        $this->select('tbl_categoria_metrica.nombre_categoria, tbl_categoria_metrica.bono_90, tbl_categoria_metrica.bono_100, k1.kpi_dia AS kpi_dia_cumplimiento_procesos, 
                    k1.kpi_noche AS kpi_noche_cumplimiento_procesos, k1.porcentaje_above AS kpi_porcentaje_above_cumplimiento_procesos, k1.porcentaje_over AS kpi_porcentaje_over_cumplimiento_procesos, k1.peso AS kpi_peso_cumplimiento_procesos, 
                    k2.kpi_dia AS kpi_dia_atencion_cliente, k2.kpi_noche AS kpi_noche_atencion_cliente, k2.porcentaje_above AS kpi_porcentaje_above_atencion_cliente, k2.porcentaje_over AS kpi_porcentaje_over_atencion_cliente, k2.peso AS kpi_peso_atencion_cliente, 
                    k3.kpi_dia AS kpi_dia_tmo, k3.kpi_noche AS kpi_noche_tmo, k3.porcentaje_above AS kpi_porcentaje_above_tmo, k3.porcentaje_over AS kpi_porcentaje_over_tmo, k3.peso AS kpi_peso_tmo, 
                    k4.kpi_dia AS kpi_dia_productividad, k4.kpi_noche AS kpi_noche_productividad, k4.porcentaje_above AS kpi_porcentaje_above_productividad, k4.porcentaje_over AS kpi_porcentaje_over_productividad, k4.peso AS kpi_peso_productividad,
                    k5.kpi_dia AS kpi_dia_wp, k5.kpi_noche AS kpi_noche_wp, k5.porcentaje_above AS kpi_porcentaje_above_wp, k5.porcentaje_over AS kpi_porcentaje_over_wp, k5.peso AS kpi_peso_wp');
                    
        $this->join('tbl_kpi_metrica k1', 'tbl_categoria_metrica.id_categoria = k1.id_categoria AND k1.id_subcriterio = 1');
        $this->join('tbl_pagos_metrica p1', 'tbl_categoria_metrica.id_categoria = p1.id_categoria AND p1.id_subcriterio = 1');
                
        $this->join('tbl_kpi_metrica k2', 'tbl_categoria_metrica.id_categoria = k2.id_categoria AND k2.id_subcriterio = 2');
        $this->join('tbl_pagos_metrica p2', 'tbl_categoria_metrica.id_categoria = p2.id_categoria AND p2.id_subcriterio = 2');
            
        $this->join('tbl_kpi_metrica k3', 'tbl_categoria_metrica.id_categoria = k3.id_categoria AND k3.id_subcriterio = 3');
        $this->join('tbl_pagos_metrica p3', 'tbl_categoria_metrica.id_categoria = p3.id_categoria AND p3.id_subcriterio = 3');
            
        $this->join('tbl_kpi_metrica k4', 'tbl_categoria_metrica.id_categoria = k4.id_categoria AND k4.id_subcriterio = 4');
        $this->join('tbl_pagos_metrica p4', 'tbl_categoria_metrica.id_categoria = p4.id_categoria AND p4.id_subcriterio = 4');
            
        $this->join('tbl_kpi_metrica k5', 'tbl_categoria_metrica.id_categoria = k5.id_categoria AND k5.id_subcriterio = 5');
        $this->join('tbl_pagos_metrica p5', 'tbl_categoria_metrica.id_categoria = p5.id_categoria AND p5.id_subcriterio = 5');    
        
        // $this->where($whereControlIndicadores);
        
        $result = $this->get()->getResultArray(); 
        
        // Retornar datos y totales
        return   $result;
    }
    
}