<?php

namespace App\Libraries;
use \App\Libraries\Error;
use \App\Libraries\Alertas;

class Globales 
{
    public function urlExternos()
    {
        return array(
            'prueba-verismart',
            'referidos',
            'guardar-referido-field',
            'referidostctv',
            'guardar-referido-tctv',
            'afiliacion',
            'afiliar-cuenta-bancaria',
            'afiliar-diners',
            'afiliar-visa-mastercard'
        );
    }
    
    public function urlLibres()
    {
        $libres = array(
            'descargatxt',
            'test-controller',
            'cambiar-password',
            'cantidad-notificaciones-header', 
            'registrar-vista-notificacion', 
            'cargar-notificaciones-header',
            'listado-region-pais', 
            'listado-region-departamentos', 
            'listado-region-provincias', 
            'listado-region-distritos', 
            'listado-monedas', 
            'listado-tipos-documento',
            'listado-tipos-documento-sunat',
            'listado-direccion-busqueda',
            'listado-direccion-estructura',
            'listado-area-estructura',
            'listado-subarea-estructura',
            'listado-delegacion-estructura',
            'listado-cc-delegacion-estructura',
            'listado-estructura-delegacion',
            'listado-usuarios',
            'exportar-estructura-departamental',
            'cargos-serverside',
            'delegaciones-serverside',
            'direcciones-sunat-serverside',
            'region-departamento-serverside',
            'region-provincia-serverside',
            'region-distrito-serverside',
            'direccion-estructura-serverside',
            'area-estructura-serverside',
            'subarea-estructura-serverside',
            'usuarios-serverside',
            'listado-perfiles'
            );
            
        return array_merge($libres, $this->urlExternos());
    }
    
    function iconosExtension() {
        return array(
            'xlsx' => "mdi mdi-file-excel",
            'xls' => "mdi mdi-file-excel",
            'csv' => "mdi mdi-file-delimited",
            'jpeg' => "mdi mdi-file-image-outline",
            'jpg' => "mdi mdi-file-image-outline",
            'png' => "mdi mdi-file-image-outline",
            'pdf' => "mdi mdi-file-pdf-box",
            'docx' => "mdi mdi-file-word-outline",
            'doc' => "mdi mdi-file-word-outline"
        );
    }  
    
    function  diaCortePlanilla()
    {
        $anioActual = date("Y");
        $mesActual = date("m");
    
        if ($anioActual == "2024") {
            if (in_array($mesActual, array("01", "04"))) {
                return 12;
            } elseif (in_array($mesActual, array("02", "08", "10"))) {
                return 14;
            } elseif (in_array($mesActual, array("03", "06", "09", "11"))) {
                return 13;
            } elseif (in_array($mesActual, array("05", "07"))) {
                return 15;
            } else {
                return 9;
            }
        }else if($anioActual == "2025"){
            if (in_array($mesActual, array("01", "04"))) {
                return 12;
            } elseif (in_array($mesActual, array("02", "08", "10"))) {
                return 14;
            } elseif (in_array($mesActual, array("03", "06", "09", "11"))) {
                return 13;
            } elseif (in_array($mesActual, array("05", "07"))) {
                return 15;
            } else {
                return 9;
            }
        } else {
            return 13;
        }
    }
    
    function obtenerFechasCierre()
    {
        $diaCorte = $this->diaCortePlanilla();
    
        // Convertir a enteros para operaciones aritméticas
        $anioActual = (int) date("Y");
        $mesActual  = (int) date("m");
        $diaActual  = (int) date("d");
    
        if ($diaActual < $diaCorte) {
            // Si la fecha actual es menor que el día de corte, el "desde" es el mes pasado
            if ($mesActual == 1) {
                // Si estamos en enero, el mes anterior es diciembre del año anterior
                $anioDesde = $anioActual - 1;
                $mesDesde  = 12;
            } else {
                $anioDesde = $anioActual;
                $mesDesde  = $mesActual - 1;
            }
            // La fecha "desde" será el día siguiente al día de corte en el mes anterior
            $fechaDesde = sprintf("%04d-%02d-%02d", $anioDesde, $mesDesde, $diaCorte + 1);
            // La fecha "hasta" es en el mes actual, con el día de corte
            $fechaHasta = sprintf("%04d-%02d-%02d", $anioActual, $mesActual, $diaCorte);
        } else {
            // Si la fecha actual es mayor o igual al día de corte, el "desde" es en el mes actual
            $fechaDesde = sprintf("%04d-%02d-%02d", $anioActual, $mesActual, $diaCorte + 1);
            // Y el "hasta" es en el mes siguiente
            if ($mesActual == 12) {
                $anioHasta = $anioActual + 1;
                $mesHasta  = 1;
            } else {
                $anioHasta = $anioActual;
                $mesHasta  = $mesActual + 1;
            }
            $fechaHasta = sprintf("%04d-%02d-%02d", $anioHasta, $mesHasta, $diaCorte);
        }
    
        return [
            'desde' => $fechaDesde,
            'hasta' => $fechaHasta
        ];
    }
}
