<?php

namespace App\Controllers;

use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;

class Usuarios extends BaseController
{
	public function __construct(){
        $this->sistemas     = new \App\Models\SistemasModel();
        
		$this->modulo               = new \App\Models\ModuloModel();
		$this->usuarioModelo        = new \App\Models\UsuarioModel();
        $this->usuarioPerfil        = new \App\Models\UsuarioPerfilModel();
        $this->usuarioPermisos      = new \App\Models\UsuarioPermisosModel();
        $this->usuarioRutas         = new \App\Models\UsuarioRutasModel();
        $this->usuarioDelegaciones  = new \App\Models\UsuarioDelegacionesModel();
        
        $this->correoStatusUsuario = new \App\Models\CorreoStatusUsuarioModel();
        
	}
	
    /******************************** USUARIOS ********************************/
    
	public function listarUsuarios()
	{
		if(isset($this->items['id']))
		{
			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Usuarios | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Sistemas',
				'elementoSeleccionadoModulo'=> "Listado de Usuarios",
				'subtitulo'                 => 'Usuarios'
			);
			
			$data = array_merge($data, $this->items);
			
			return view('administracion/listar_usuarios',$data);			
		} 
		else 
		{
			return view('errors/500');	
		}
	}

	public function usuariosServerside()
	{
	    if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"      => $this->items['idPerfil'],
                "IDUsuario"     => $this->items['id']
            );
            
            /* LISTAR USUARIO */
            $dataServerside = $this->usuarioModelo->listaGeneralUsuario($this->request->getPost(), $adicionales);
            
            foreach($dataServerside["data"] as $key=>$value)
            {
    			if(in_array("ESTUSU", $this->items['permisos']))
    			{
        			$dataServerside["data"][$key]['EstadoUsuario'] = '<button class="badge '.($value['Estado'] == "Activo" ? 'bg-success' : 'bg-danger').' border-0 cambiar-estado-usuario" data-estado="'.$value['Estado'].'" data-id="'.$value['IdUsuario'].'" data-usuario="'.ucwords(mb_strtolower($value['Nombres']))." ".ucwords(mb_strtolower($value['Apellidos'])).'">'.$value['Estado'].'</button>';
    			}
    			else
    			{
    			    $dataServerside["data"][$key]['EstadoUsuario'] = '<span class="badge '.($value['Estado'] == "Activo" ? 'bg-success' : 'bg-danger').' border-0" >'.$value['Estado'].'</span>';
    			}
    			
    			$dataServerside["data"][$key]['NombreUsuario'] = ucwords(mb_strtolower($value['Nombres']))." ".ucwords(mb_strtolower($value['Apellidos']));
    			
                $acciones = '';
                
                $acciones .= '<button class="badge bg-info border-0 p-2 mx-1 datos-usuario" data-bs-target="#informacionUsuario" data-form="#formInformacionUsuario" data-id="'.$value['IdUsuario'].'" data-accion="ver" id="ver-usuario" data-tooltip="tooltip" title="Ver Usuario">
    				<i class="mdi mdi-eye align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
    			if(in_array("PASUSU", $this->items['permisos']))
    			{
    			$acciones .= '<button class="badge bg-morado border-0 p-2 mx-1 cambiar-password-usuario" data-id="'.$value['IdUsuario'].'" data-usuario="'.ucwords(mb_strtolower($value['Nombres']))." ".ucwords(mb_strtolower($value['Apellidos'])).'" data-tooltip="tooltip" title="Cambiar Contraseña">
    				<i class="mdi mdi-lock-reset align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			}
    										
				if (in_array("PROREI", $this->items['permisos']))
				{
					if($value['Estado'] == "Cesado")
					{
					$acciones .= '<button class="badge bg-danger border-0 p-2 mx-1 reingreso-usuario" data-id="'.$value['IdUsuario'].'" data-usuario="'.ucwords(mb_strtolower($value['Nombres']))." ".ucwords(mb_strtolower($value['Apellidos'])).'" data-tooltip="tooltip" title="Registrar Reingreso">
        				<i class="mdi mdi-location-enter align-bottom" style="font-size: 20px; color: #FFF;"></i>
        			</button>';
					}
				}
				
				$acciones .= '<a href="'.$this->items['baseUrl'].'/informacion-usuario/'.$value['IdUsuario'].'" class="badge bg-sistema border-0 p-2 mx-1" data-tooltip="tooltip" title="Información de Usuario">
    				<i class="mdi mdi-badge-account-horizontal-outline align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</a>';
    					
                $dataServerside["data"][$key]['acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    	else
    	{
    	    $datos = [
                'draw'              => 1,
                'data'              => array(),
                'recordsTotal'      => 0,
                'recordsFiltered'   => (int) 0
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
	}
	
	public function registrarUsuario()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $matricula      = mb_strtoupper($this->request->getPost('txtMatriculaUsuario_i'));
        $nombre         = ucwords(mb_strtolower($this->request->getPost('txtNombresUsuario_i')));
        $apellido       = ucwords(mb_strtolower($this->request->getPost('txtApellidosUsuario_i')));
        $tipoDocumento  = $this->request->getPost('txtTipoDocumentoUsuario_i') ;
        $documento      = $this->request->getPost('txtDocumentoUsuario_i');
        $cargo          = $this->request->getPost('txtCargoUsuario_i');
        $manager        = $this->request->getPost('txtManagerUsuario_i') ;
        $fechaIngreso   = $this->request->getPost('txtFechaIngresoUsuario_i');
        $fte            = $this->request->getPost('txtFTEUsuario_i');
        //$area           = $this->request->getPost('txtAreaUsuario_i') ;
        $subarea        = $this->request->getPost('txtSubareaEstrucUsuario_i') ;
        $delegacion     = $this->request->getPost('txtDelegacionSubareaEstrucUsuario_i') ;
        $correo         = mb_strtolower($this->request->getPost('txtCorreoUsuario_i'));
        $usuario        = mb_strtolower($this->request->getPost('txtUsuarioIngreso_i'));
        $tipoUsuario    = $this->request->getPost('txtTipoUsuario_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        if($tipoDocumento == 'DNI')
        {
            $minCaracteres = '8';
            $maxCaracteres = '8';
        }
        else
        {
            $minCaracteres = '8';
            $maxCaracteres = '12';
        }
        
        $error = '';
        $error .= $this->complementos->validaCampo($matricula, 'required|trim|minlength[1]|maxlength[7]', 'Matrícula');
        $error .= $this->complementos->validaCampo($nombre, 'required|trim|alphaspace|minlength[1]|maxlength[200]', 'Nombres');
        $error .= $this->complementos->validaCampo($apellido, 'required|trim|alphaspace|minlength[1]|maxlength[200]', 'Apellidos');
        $error .= $this->complementos->validaCampo($tipoDocumento, 'required|trim|alpha|minlength[1]|maxlength[4]', 'Tipo de Documento');
        $error .= $this->complementos->validaCampo($documento, 'required|trim|numeric|minlength['.$minCaracteres.']|maxlength['.$maxCaracteres.']', 'Documento');
        $error .= $this->complementos->validaCampo($cargo, 'required|trim|numeric', 'Cargo');
        $error .= $this->complementos->validaCampo($manager, 'trim|numeric', 'Jefe Directo');
        $error .= $this->complementos->validaCampo($fechaIngreso, 'required|trim|dateDos', 'Fecha de Ingreso');
        $error .= $this->complementos->validaCampo($fte, 'required|trim|decimal', 'FTE');
        //$error .= $this->complementos->validaCampo($area, 'required|trim|numeric', 'Área');
        $error .= $this->complementos->validaCampo($subarea, 'required|trim|numeric', 'Subárea');
        $error .= $this->complementos->validaCampo($delegacion, 'required|trim|numeric', 'Delegación');
        $error .= $this->complementos->validaCampo($correo, 'required|trim|email|minlength[1]|maxlength[200]', 'Correo Corporativo');
        $error .= $this->complementos->validaCampo($usuario, 'required|trim|minlength[1]|maxlength[150]', 'Usuario');
        $error .= $this->complementos->validaCampo($tipoUsuario, 'trim|minlength[1]|maxlength[10]', 'Tipo de Usuario');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
		$matriculaExistente = $this->usuarioModelo->where('Matricula', $matricula)->findAll();
		$documentoExistente = $this->usuarioModelo->where('NumeroDoc', $documento)->findAll();
		$usuarioExistente = $this->usuarioModelo->where('Usuario', $usuario)->findAll();
        
        if(count($matriculaExistente)>0)
        {
            $msgExistencia .= "<li>La matrícula ya fue registrada. [CAMPO] <small>MATRÍCULA</small></li>";
        }

        if(count($documentoExistente)>0)
        {
            $msgExistencia .= "<li>El Nro Documento ya fue registrado. [CAMPO] <small>DOCUMENTO</small></li>";
        }

        if(count($usuarioExistente)>0)
        {
            $msgExistencia .= "<li>El usuario ya fue registrado. [CAMPO] <small>USUARIO</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
        
		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
        $data = array (
            'Matricula'     => $matricula,
            'Nombres'       => $nombre,
            'Apellidos'     => $apellido,
            'TipoDocumento' => $tipoDocumento,
            'NumeroDoc'     => $documento,
            'TipoUsuario'   => $tipoUsuario,
            'Correo'        => $correo,
            'Usuario'       => $usuario,
            'FechaIngreso'  => $fechaIngreso,
            'FTE'           => $fte,
            'IDCargo'       => $cargo,
            'IDManager'     => $manager,
            'IDSubarea'     => $subarea,
            'IDDelegacion'  => $delegacion,
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress(),
            'UsuarioEstado' => $this->items['id'],
            'FechaEstado'   => $fechaActual,    
            'MotivoEstado'  => "Alta de usuario.",    
            'Estado'        => 'Activo'
        );

        $lastId = $this->usuarioModelo->insert($data, TRUE);

		if($lastId !== FALSE)
		{
			$message = sprintf($this->mensajeError->msg502, $matricula);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
	
	public function informacionUsuario($idUsuario)
	{
	    if(isset($this->items['id']))
		{
		    $usuario = $this->usuarioModelo->buscarUsuario($idUsuario);
		    
			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Información de Usuario | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Usuario',
                'previo'                    => 'listar-usuarios',
				'elementoSeleccionadoModulo'=> "Usuario",
				'subtitulo'                 => 'Usuario',
				'informacionUsuario'        => $usuario,
				'idUsuarioInfo'             => $idUsuario
			);
			
			$data = array_merge($data, $this->items);
			
			return view('administracion/informacion_usuario',$data);			
		} 
		else 
		{
			return view('errors/500');
		}
	}
	
    public function obtenerDatosUsuario()
    {
        if (isset($this->items['id']))
	    {
            /*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
    		*/
    
    		$msjError = TRUE;
    		$idUsuario = $this->request->getPost("idUsuario");
    
    		/*
            * ----------------------------
            * VALIDACIÓN DE REQUERIMIENTOS
            * ----------------------------
            */
    
    		$error = '';
    		$error .= $this->complementos->validaCampo($idUsuario, 'trim', 'ID');
    
    		if ($error != '') {
    			$message = sprintf($this->mensajeError->msg201, $error);
    			echo $this->alertas->alertaError($message);
    			exit;
    		}
    
    		/*
            * -------------
            * BASE DE DATOS
            * -------------
            */
    		
    		$datosUsuario = $this->usuarioModelo->buscarUsuario($idUsuario);
    
    		if(!empty($datosUsuario)){
    			$resultado = array(
    				'idusuario'     => (string) $idUsuario,
    				'matricula'     => (string) $datosUsuario['Matricula'],
    				'nombres'       => (string) $datosUsuario['Nombres'],
    				'apellidos'     => (string) $datosUsuario['Apellidos'],
    				'tipodoc'       => (string) $datosUsuario['TipoDocumento'],
    				'documento'     => (string) $datosUsuario['NumeroDoc'],
    				'tipousuario'   => (string) $datosUsuario['TipoUsuario'],
    				'idmanager'     => (string) $datosUsuario['IDManager'],
    				'fechaingreso'  => (string) $datosUsuario['FechaIngreso'],
    				'fte'           => (string) $datosUsuario['FTE'],
    				'correo'        => (string) $datosUsuario['Correo'],
    				'usuario'       => (string) $datosUsuario['Usuario'],
    				'idcargo'       => (string) $datosUsuario['IDCargo'],
    				'idsubarea'     => (string) $datosUsuario['IDSubarea'],
    				'idarea'        => (string) $datosUsuario['IDArea'],
    				'iddireccion'   => (string) $datosUsuario['IDDireccion'],
    				'iddelegacion'  => (string) $datosUsuario['IDDelegacion'],
    				'fechacese'     => (string) date("Y-m-d", strtotime($datosUsuario['FechaCese'])),
    				'motivo'        => (string) $datosUsuario['MotivoEstado']
    			);
    		} else {
    			$resultado = array(
    				'descripcion' => 0
    			);
    		}
    
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado);
	    }
	    else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
    }
    
    public function modificarUsuario($idUsuario)
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $matricula      = mb_strtoupper($this->request->getPost('txtMatriculaUsuario_i'));
        $nombre         = mb_strtoupper($this->request->getPost('txtNombresUsuario_i'));
        $apellido       = mb_strtoupper($this->request->getPost('txtApellidosUsuario_i'));
        $tipoDocumento  = $this->request->getPost('txtTipoDocumentoUsuario_i') ;
        $documento      = $this->request->getPost('txtDocumentoUsuario_i');
        $cargo          = $this->request->getPost('txtCargoUsuario_i');
        $manager        = $this->request->getPost('txtManagerUsuario_i') ;
        $fechaIngreso   = $this->request->getPost('txtFechaIngresoUsuario_i');
        $fte            = $this->request->getPost('txtFTEUsuario_i');
        //$area           = $this->request->getPost('txtAreaUsuario_i') ;
        $subarea        = $this->request->getPost('txtSubareaEstrucUsuario_i') ;
        $delegacion     = $this->request->getPost('txtDelegacionSubareaEstrucUsuario_i') ;
        $correo         = mb_strtolower($this->request->getPost('txtCorreoUsuario_i'));
        $usuario        = mb_strtolower($this->request->getPost('txtUsuarioIngreso_i'));
        $tipoUsuario    = $this->request->getPost('txtTipoUsuario_i');

        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        if($tipoDocumento == 'DNI')
        {
            $minCaracteres = '8';
            $maxCaracteres = '8';
        }
        else
        {
            $minCaracteres = '8';
            $maxCaracteres = '12';
        }
        
        $error = '';
        $error .= $this->complementos->validaCampo($matricula, 'required|trim|minlength[1]|maxlength[7]', 'Matrícula');
        $error .= $this->complementos->validaCampo($nombre, 'required|trim|alphaspace|minlength[1]|maxlength[200]', 'Nombres');
        $error .= $this->complementos->validaCampo($apellido, 'required|trim|alphaspecial|minlength[1]|maxlength[200]', 'Apellidos');
        $error .= $this->complementos->validaCampo($tipoDocumento, 'required|trim|alpha|minlength[1]|maxlength[4]', 'Tipo de Documento');
        $error .= $this->complementos->validaCampo($documento, 'required|trim|minlength['.$minCaracteres.']|maxlength['.$maxCaracteres.']', 'Documento');
        $error .= $this->complementos->validaCampo($cargo, 'required|trim|numeric', 'Cargo');
        // $error .= $this->complementos->validaCampo($manager, 'required|trim|numeric', 'Jefe Directo');
        $error .= $this->complementos->validaCampo($fechaIngreso, 'required|trim|dateDos', 'Fecha de Ingreso');
        $error .= $this->complementos->validaCampo($fte, 'required|trim|decimal', 'FTE');
        //$error .= $this->complementos->validaCampo($area, 'required|trim|numeric', 'Área');
        $error .= $this->complementos->validaCampo($subarea, 'required|trim|numeric', 'Subárea');
        $error .= $this->complementos->validaCampo($delegacion, 'required|trim|numeric', 'Delegación');
        $error .= $this->complementos->validaCampo($correo, 'required|trim|email|minlength[1]|maxlength[200]', 'Correo Corporativo');
        $error .= $this->complementos->validaCampo($usuario, 'required|trim|minlength[1]|maxlength[150]', 'Usuario');
        $error .= $this->complementos->validaCampo($tipoUsuario, 'trim|minlength[1]|maxlength[10]', 'Tipo de Usuario');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'Matricula'         => $matricula,
            'Nombres'           => $nombre,
            'Apellidos'         => $apellido,
            'TipoDocumento'     => $tipoDocumento,
            'NumeroDoc'         => $documento,
            'Correo'            => $correo,
            'TipoUsuario'       => $tipoUsuario,
            'Usuario'           => $usuario,
            'FechaIngreso'      => $fechaIngreso,
            'FTE'               => $fte,
            'IDCargo'           => $cargo,
            'IDManager'         => $manager,
            'IDSubarea'         => $subarea,
            'IDDelegacion'      => $delegacion,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->usuarioModelo->update([$idUsuario], $data);

        if($lastId !== FALSE)
        {
            $message = sprintf($this->mensajeError->msg503, $nombre);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }		
    }
    
    public function modificarPasswordUsuario()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idUsuario = $this->request->getPost('idUsuario');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idUsuario, 'required|trim|numeric', 'ID Usuario');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * -------------
        * GENERAR CONTRASEÑA
        * -------------
        */
		
		$infoUsuario = $this->usuarioModelo->where('IdUsuario', $idUsuario)->first();
		
		$stringPass = "";
		
		if($infoUsuario['NumeroDoc'] != '' && $infoUsuario['NumeroDoc'] != null)
		{
		    $stringPass = substr($infoUsuario['NumeroDoc'],-4);
		}
		else
		{
		    $stringPass = substr($infoUsuario['Matricula'],-4);
		}
    	
        $passwordxdni="Verisure".$stringPass.date("Y")."*";
        // $passwordxdni="Verisure2024*";
        $user_password_hash=password_hash($passwordxdni,PASSWORD_DEFAULT);
        
        $data = array (
            'Password'          => $user_password_hash,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->usuarioModelo->update([$idUsuario], $data);

		if($lastId !== FALSE){
		    /*
            * ----------------------------
            * PREPARACIÓN DE CUERPO DE CORREO
            * ----------------------------
            */
            
            $arrayCuerpo = array(
                "TITULO"        => "CAMBIO DE CONTRASEÑA",
                "USUARIO"       => ucwords(mb_strtolower($infoUsuario['Nombres'].' '.$infoUsuario['Apellidos'])),
                "USER"          => $infoUsuario['Usuario'],
                "PASSWORD"      => $passwordxdni
            );
    
            $cuerpo = $this->plantillasCorreo->cuerpoCambioPasswordGenerado($arrayCuerpo);
            
            /*
            * ----------------------------
            * PREPARACIÓN DE PARAMETROS PARA EL CORREO
            * ----------------------------
            */
    
            $asunto='CAMBIO DE CONTRASEÑA - SISTEMAS VERISURE';
            //$correoDestino = array($asignado['Correo']);
            $configCorreo = array(
                "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
                "CORREO_ORIGEN" => 'desarrollo@verisure.pe',
                "CORREOS_DESTINOS" => array($infoUsuario['Correo']),
                "CORREOS_COPIA" => array(),
                "CORREOS_OCULTO" => array('josejesus.cuadros@verisure.pe', 'joseenrique.nanquen@verisure.pe'),
                "ASUNTO" => $asunto,
                "MENSAJE" => $cuerpo
            );
    
            $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);
    
            $dataCorreo = array(
                "IDUsuario"     => $idUsuario,
                "Asunto"        => $asunto,
                "Response"      => $estadoCorreo['RESPUESTA'],
                "Error"         => $estadoCorreo['ERROR'],
                'UsuarioCrea'   => $this->items['id'],
                'FechaCrea'     => $fechaActual,    
                'Localhost'     => $this->request->getIPAddress()
            );
    
            $this->correoStatusUsuario->insert($dataCorreo, TRUE);
			$message = sprintf($this->mensajeError->msg503, $idUsuario);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function modificarPerfilUsuario()
    {

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $perfil     = $this->request->getPost('txtPerfilUsuario');
        $idUsuario  = $this->request->getPost('txtIDUsuario_mpu');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($perfil, 'required|trim', 'Perfil');
        $error .= $this->complementos->validaCampo($idUsuario, 'required|trim|numeric', 'ID Usuario');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * ACTUALIZACIÓN DE DATOS
        * ----------------------------
        */

        $data = array (
            'IdUsuario'         => $idUsuario,
            'IDPerfil'          => $perfil,
            'UsuarioRegistra'   => $this->items['id'],
            'FechaRegistra'     => $fechaActual
        );
        
        $lastId = $this->usuarioPerfil->save($data);
        
		if($lastId !== FALSE)
		{
			$message = sprintf($this->mensajeError->msg503, $idUsuario);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

    public function modificarEstadoUsuario()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idUsuario = $this->request->getPost('idUsuario');
        $fechacese = $this->request->getPost('fechacese');
        $fechaingreso = $this->request->getPost('fechaingreso');
        $estado = $this->request->getPost('estado');
        $motivo = $this->request->getPost('motivo');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idUsuario, 'required|trim|numeric', 'ID Usuario');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[6]|maxlength[6]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');
        
        if($estado == "Activo")
        {
            $error .= $this->complementos->validaCampo($fechaingreso, 'required|trim|dateDos', 'Fecha Ingreso');
        }
        else
        {
            $error .= $this->complementos->validaCampo($fechacese, 'required|trim|dateDos', 'Fecha Cese');
        }
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,
            'MotivoEstado'      => $motivo,
            'Estado'            => $estado
        );
        
        if($estado == "Activo")
        {
            $data['FechaIngreso'] = $fechaingreso;
            $data['FechaCese'] = NULL;
        }
        else
        {
            $data['FechaCese'] = $fechacese;
        }
        
        
        $lastId = $this->usuarioModelo->update([$idUsuario], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idUsuario);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function actualizarCeseUsuario()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idUsuario = $this->request->getPost('idUsuario');
        $fechacese = $this->request->getPost('fechacese');
        $motivo = $this->request->getPost('motivo');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idUsuario, 'required|trim|numeric', 'ID Usuario');
        $error .= $this->complementos->validaCampo($fechacese, 'required|trim|dateDos', 'Fecha Cese');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'FechaCese'         => $fechacese,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'MotivoEstado'      => $motivo
        );
        
        $lastId = $this->usuarioModelo->update([$idUsuario], $data);

		if($lastId !== FALSE)
		{
			$message = sprintf($this->mensajeError->msg503, $idUsuario);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
	public function listadoUsuarios()
	{
	    if (isset($this->items['id'])) 
    	{
        	/*
            * ----------------------
            * OBTIENE Y VALIDA DATOS
            * ----------------------
            */
            $listadoUsuarios = $this->usuarioModelo->findAll();
            
            $usuarios=array();
    
    		if (!empty($listadoUsuarios)) 
    		{
                foreach ($listadoUsuarios as $items) 
                {
                    $usuarios[] = array(
    					'id'    => (string) $items['IdUsuario'],
             	        'text'  => (string) $items['Matricula'].' | '.$items['Nombres'].' '.$items['Apellidos'],
                    );
                }
    
                $resultado = array(
    				'listadoUsuarios' => json_encode($usuarios)
    			);
            } 
            else 
            {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
    
            /*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
            echo json_encode($resultado, JSON_NUMERIC_CHECK);
    	}
    	else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}
	
    /**************************************************************************/
    
    /************************** PERMISOS DE USUARIOS **************************/
    
	public function listarPermisosUsuario()
    {
        $html = '';
        
		if(isset($this->items['id']))
		{
		    $idUsuario = $this->request->getPost('idUsuario');
            
			$listaPermisos = $this->usuarioPermisos->listarPermisosUsuario($idUsuario);
			$listaModulos = $this->modulo->findAll();
			
			$html .= '<form id="formPermisosUsuario" class="formulario" autocomplete="off" method="POST" action="'.$this->items['baseUrl'].'/grabar-permisos-usuario/'.$idUsuario.'">
                <span class="respuesta"></span>
    			<div class="card">
                    <div class="card-header d-flex align-items-center bg-sistema-75">
                        <h5 class="card-title mb-0 flex-grow-1 color-white" style="">Listado de Permisos</h5>
    					<div class="d-flex">
    					    <button type="submit" class="btn btn-success">
    					        <i class="mdi mdi-content-save"></i> Guardar
    					    </button>
    					</div>
    				</div>
    				<!-- /.card-header -->
    				<div class="card-body row m-0 p-0">';
    				
    				foreach($listaModulos as $modulos)
    				{
    				    $html .= '<div class="col-6 p-3 m-0">
    				        <div class="card text-dark bg-info">
    				            <div class="card-header" style="background-color: transparent; color: #FFF;">'.$modulos['Modulo'].'</div>
    			                <div class="card-body" style="background-color: #FFF;">';
    							
    							foreach($listaPermisos as $permisos)
    							{
    							    if($permisos['IDModulo'] == $modulos['IDModulo'])
    							    {
    							    
    							    $html .= '<div class="row col-12 m-0 p-0">
    							        <div class="form-check form-switch form-switch-lg">
    							            <input class="form-check-input" type="checkbox" role="switch" name="permisos['.$permisos['IDAccionModulo'].']" id="chk'.$permisos['Codigo'].'" '.($permisos['ACTIVO']==1 ? 'checked' : '').' >
    							            <label class="form-check-label" for="chk'.$permisos['Codigo'].'">'.$permisos['Accion'].'</label>
    							        </div>
    								</div>';
    								
    								}
    							}
    								
    							$html .= '</div>
    						</div>
    					</div>';
    							
    				}
    							
                    $html .= '</div>
                    <!-- /.card-body -->
                </div>
            </form>';
		
		} 
		else 
		{
			$html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
	            <div class="col-xxl-10 col-md-10 col-10 ">
        	        <div class="alert alert-danger alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SESIÓN CERRADA</strong> - Inicie sesión nuevamente.
                    </div>
                </div>
        	</div>';
		}
		
		echo $html;
	}

    public function guardarPermisosUsuario($idUsuario)
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $permisos = $this->request->getPost('permisos') ;
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';

        if(isset($permisos) && empty($permisos))
        {
            $error .= "<li>No hay permisos seleccionados.</li>";
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        /*
        * ----------------------------
        * LIMPIAR EXISTENCIA PREVIA
        * ----------------------------
        */

        $listadoPermisosPrev = $this->usuarioPermisos->where("IdUsuario", $idUsuario)->findAll();

        if(count($listadoPermisosPrev) > 0)
        {
            $this->usuarioPermisos->delete($idUsuario);
        }

        /*
        * ----------------------------
        * GENERAR NUEVA DATA
        * ----------------------------
        */

        $dataPermisos = array();

        foreach($permisos as $key => $value)
        {
            $dataPermisos[] = array (
                'IdUsuario'         => $idUsuario, 
                'IDAccionModulo'    => $key,
                'UsuarioRegistra'   => $this->items['id'],
                'FechaRegistra'     => $fechaActual
            );
        }
        $lastId = $this->usuarioPermisos->insertBatch($dataPermisos, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $idUsuario);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    /**************************************************************************/
    
    /**************************** RUTAS DE USUARIOS ***************************/
    
	public function listarRutasUsuario()
    {
        $html = '';
        
		if(isset($this->items['id']))
		{
		    $idUsuario = $this->request->getPost('idUsuario');
		    
			$listaRutas = $this->usuarioRutas->listarRutasUsuario($idUsuario);
			$listaModulos = $this->modulo->findAll();
			
			$html .= '<form id="formPermisosPerfil" class="formulario" autocomplete="off" method="POST" action="'.$this->items['baseUrl'].'/grabar-rutas-usuario/'.$idUsuario.'">
                <span class="respuesta"></span>
                <!-- Horizontal Form -->
                <div class="card">
                    <div class="card-header d-flex align-items-center bg-sistema-75">
                        <h5 class="card-title mb-0 flex-grow-1 color-white" style="">Listado de Rutas</h5>
                        <div class="d-flex">
							<button type="submit" class="btn btn-success">
                                <i class="mdi mdi-content-save"></i> Guardar
                            </button>
                        </div>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body row m-0 p-0">';
					foreach($listaModulos as $modulos)
					{
					    
    					$html .= '<div class="col-6 p-3 m-0">
    						<div class="card text-dark bg-info">
    							<div class="card-header" style="background-color: transparent; color: #FFF;">'.$modulos['Modulo'].'</div>
    							<div class="card-body" style="background-color: #FFF;">';
    							
    							foreach($listaRutas as $ruta)
    							{
    								if($ruta['RaizModulo'] == 'Y')
    								{
    									$classAdicional = "form-check-input-green";
    								}
    								else if($ruta['TipoRuta'] == 'ACCION')
    								{
    									$classAdicional = "form-check-input-red";
    								}
    								else
    								{
    									$classAdicional = "form-check-input-orange";
    								}
    								
    								if($ruta['IDModulo'] == $modulos['IDModulo'])
    								{
    								    
            							$html .= '<div class="row col-12 m-0 p-0">
            								<div class="form-check form-switch form-switch-lg">
            									<input class="form-check-input '.$classAdicional.'" type="checkbox" role="switch" name="rutas['.$ruta['IDRuta'].']" id="chkRuta'.$ruta['IDRuta'].'" '.($ruta['ACTIVO']==1 ? 'checked' : '').' >
            									<label class="form-check-label" for="chkRuta'.$ruta['IDRuta'].'">'.$ruta['Ruta'].'</label>
            								</div>
            							</div>';
            							
    								}
    							}
    							
    							$html .= '</div>
    						</div>
    					</div>';
    					
					}
					
                    $html .= '</div>
                    <!-- /.card-body -->
                </div>
            </form>';

		} 
		else 
		{
			$html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
	            <div class="col-xxl-10 col-md-10 col-10 ">
        	        <div class="alert alert-danger alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SESIÓN CERRADA</strong> - Inicie sesión nuevamente.
                    </div>
                </div>
        	</div>';
		}
		
		echo $html;
	}
    
    public function guardarRutasUsuario($idUsuario)
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $rutas = $this->request->getPost('rutas') ;
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';

        if(isset($rutas) && empty($rutas))
        {
            $error .= "<li>No hay rutas seleccionados.</li>";
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        /*
        * ----------------------------
        * LIMPIAR EXISTENCIA PREVIA
        * ----------------------------
        */

        $listadoRutasPrev = $this->usuarioRutas->where("IdUsuario", $idUsuario)->findAll();

        if(count($listadoRutasPrev) > 0)
        {
            $this->usuarioRutas->delete($idUsuario);
        }

        /*
        * ----------------------------
        * GENERAR NUEVA DATA
        * ----------------------------
        */

        $dataRutas = array();

        foreach($rutas as $key => $value)
        {
            $dataRutas[] = array (
                'IdUsuario'         => $idUsuario, 
                'IDRuta'            => $key,
                'UsuarioRegistra'   => $this->items['id'],
                'FechaRegistra'     => $fechaActual
            );
        }
        $lastId = $this->usuarioRutas->insertBatch($dataRutas, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $idUsuario);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    /**************************************************************************/
    
    /************************ DELEGACIONES DE USUARIOS ************************/
    
    public function listarDelegacionesUsuario()
    {
        $html = '';
        
        if(isset($this->items['id']))
        {
            $idUsuario = $this->request->getPost('idUsuario');
            
			$listaDelegaciones = $this->usuarioDelegaciones->listarDelegacionesXUsuario($idUsuario);
			
			$html .= '<div class="card">
				<div class="card-header d-flex align-items-center bg-sistema-75">
                    <h5 class="card-title mb-0 flex-grow-1 color-white">Listado de Delegaciones</h5>
                </div>
				<div class="card-body">
					<div class="row col-12 m-0 mb-3 p-3 bg-red-verisure-25" style="border-radius: 20px;">
                        <div class="col-xxl-9 col-md-12 col-12 mb-3">
                            <div>
                                <label for="txtDelegacionAsociarUsuario" class="form-label">Delegación</label>
                                <select class="form-select" aria-label="Delegación" id="txtDelegacionAsociarUsuario" name="txtDelegacionAsociarUsuario">
                                    <option selected="" value="">Seleccione una opción</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-xxl-3 col-md-12 col-12 mb-3 d-flex flex-row-reverse align-items-center">
                            <div>
                                <button type="button" class="btn btn-success" id="btnAgregarDelegacionUsuario" data-usuario="'.$idUsuario.'">
                                <i class="mdi mdi-plus-circle"></i> Agregar
                            </button>
                            </div>
                        </div>
                    </div>
					<table id="tblDelegacionesUsuarioEstructura" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
						<thead>
							<tr>
								<th class="text-center align-middle">Delegación</th>
								<th class="text-center align-middle">CC</th>
								<th class="text-center align-middle">LN</th>
								<th class="text-center align-middle">Acciones</th>
							</tr>
						</thead>
						<tbody>';
						
						foreach($listaDelegaciones as $items)
						{
							$html .= '<tr>
								<td class="text-center align-middle">'.$items['Delegacion'].'</td>
								<td class="text-center align-middle">'.$items['CC'].'</td>
								<td class="text-center align-middle">'.$items['LN'].'</td>
								<td class="text-center align-middle">';
								if (in_array("DEDEUS", $this->items['permisos']))
								{
								    $html .= '<button class="badge bg-danger border-0 p-2 eliminar-delegacion-usuario" data-delegacion="'.$items['IDDelegacion'].'" data-usuario="'.$idUsuario.'">
										<i class="mdi mdi-trash-can-outline align-bottom" style="font-size: 20px; color: #FFF;"></i>
									</button>';
								}
								
								$html .= '</td>
							</tr>';
						}
						
						$html .= '</tbody>
					</table>
				</div>
				<script>
				    $(function () {
				        const tableDelegacionesUsuarioEstructura = new DataTable("#tblDelegacionesUsuarioEstructura");
    				    $("#txtDelegacionAsociarUsuario").select2({
                            minimumInputLength: 2,
                            placeholder: "Seleccione Delegación",
                            allowClear: true,
                            language: {
                                errorLoading: function() {
                                    return "La carga falló";
                                },
                                noResults: function() {
                                    return "No hay resultado";
                                },
                                searching: function() {
                                    return "Buscando..";
                                }
                            },
                            ajax: {
                                url: baseUrl + "/listado-delegacion-estructura-busqueda",
                                dataType: "json",
                                type: "POST",
                                quietMillis: 50,
                                data: function (term) {
                                    return {
                                        term: term
                                    };
                                },
                                processResults: function (data) {
                                    return {
                                        results: data
                                    };
                                }
                            }
                        });
				    });
				</script>
			</div>';
		} 
		else 
		{
			$html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
	            <div class="col-xxl-10 col-md-10 col-10 ">
        	        <div class="alert alert-danger alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SESIÓN CERRADA</strong> - Inicie sesión nuevamente.
                    </div>
                </div>
        	</div>';
		}
		
		echo $html;
    }
    
    public function asociarDelegacionUsuario()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $idDelegacion = $this->request->getPost('idDelegacion');
        $idUsuario = $this->request->getPost('idUsuario');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idDelegacion, 'required|trim|number', 'ID Delegación');
        $error .= $this->complementos->validaCampo($idUsuario, 'required|trim|number', 'ID Usuario');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $whereCC = array(
            'IDUsuario'     => $idUsuario,
            'IDDelegacion'  => $idDelegacion
        );
        
		$combinacionExistente = $this->usuarioDelegaciones->where($whereCC)->findAll();
		
        if(count($combinacionExistente)>0)
        {
            $msgExistencia .= "<li>La delegación ya está encargada al usuario. [CAMPO] <small>DELEGACIÓN</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'IDUsuario'         => $idUsuario, 
            'IDDelegacion'      => $idDelegacion,
            'UsuarioRegistra'   => $this->items['id'],
            'FechaRegistra'     => $fechaActual,
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->usuarioDelegaciones->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $idDelegacion);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function eliminarDelegacionUsuario()
    {
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $idUsuario = $this->request->getPost('idUsuario') ;
        $idDelegacion = $this->request->getPost('idDelegacion');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idUsuario, 'required|trim|number', 'ID Usuario');
        $error .= $this->complementos->validaCampo($idDelegacion, 'required|trim|number', 'ID Delegación');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $whereDelete = array (
            'IDUsuario'     => $idUsuario, 
            'IDDelegacion'  => $idDelegacion
        );

        $lastId = $this->usuarioDelegaciones->where($whereDelete)->delete();

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg504, $idDelegacion);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

    /**************************************************************************/
    
    /************************** SISTEMAS DE USUARIOS **************************/
    
    public function listarSistemasUsuario()
    {
        $html = '';
        
        if(isset($this->items['id']))
        {
            $idUsuario = $this->request->getPost('idUsuario');
            
			$listadoSistemas = $this->usuarioSistemas->listarSistemasUsuario($idUsuario);
			
			$html .= '<form id="formEditarSistemasUsuario" class="formulario" autocomplete="off" method="POST" action="'.$this->items['baseUrl'].'/grabar-sistemas-usuario/'.$idUsuario.'">
                <span class="respuesta"></span>
                <div class="col-12 d-flex justify-content-center">
                <!-- Horizontal Form -->
                    <div class="card">
                        <div class="card-header d-flex align-items-center bg-sistema-75" >
                            <h5 class="card-title mb-0 flex-grow-1 color-white" style="">Listado de Sistemas</h5>
                            <div class="d-flex">
    							<button type="submit" class="btn btn-success">
                                    <i class="mdi mdi-content-save"></i> Guardar
                                </button>
                            </div>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body row m-0 p-0">';
    					foreach($listadoSistemas as $sistemas)
    					{
    						$html .= '<div class="col-xxl-12 col-md-12 col-12 my-2 px-3">
            					<div class="form-check form-switch form-switch-lg" style="text-align: right;">
            						<input class="form-check-input" type="checkbox" role="switch" name="sistemas['.$sistemas['IDSistema'].']" id="chkSistema'.$sistemas['IDSistema'].'" '.($sistemas['ACTIVO'] == 1 ? "checked" : "").' >
            						<label class="form-check-label" for="chkSistema'.$sistemas['IDSistema'].'">'.$sistemas['Sistema'].'</label>
            					</div>
            					<input type="hidden" name="nombre['.$sistemas['IDSistema'].']" value="'.$sistemas['Sistema'].'">
            				</div>';
        							
    					}
    					
                        $html .= '</div>
                        <!-- /.card-body -->
                    </div>
                </div>
            </form>';
		} 
		else 
		{
			$html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
	            <div class="col-xxl-10 col-md-10 col-10 ">
        	        <div class="alert alert-danger alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SESIÓN CERRADA</strong> - Inicie sesión nuevamente.
                    </div>
                </div>
        	</div>';
		}
		
		echo $html;
    }
    
    public function guardarSistemasUsuario($idUsuario)
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $sistemas = $this->request->getPost('sistemas');
        $nombre = $this->request->getPost('nombre');
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        /*
        * ----------------------------
        * LIMPIAR EXISTENCIA PREVIA
        * ----------------------------
        */

        $listadoSistemasPrev = $this->usuarioSistemas->where("IdUsuario", $idUsuario)->findAll();

        if(count($listadoSistemasPrev) > 0)
        {
            $this->usuarioSistemas->delete($idUsuario);
        }

        /*
        * ----------------------------
        * GENERAR NUEVA DATA
        * ----------------------------
        */

        $dataSistemas = array();
        $sistemasAutorizados = array();

        foreach($sistemas as $key => $value)
        {
            $dataSistemas[] = array (
                'IdUsuario'         => $idUsuario, 
                'IDSistema'         => $key,
                'UsuarioRegistra'   => $this->items['id'],
                'FechaRegistra'     => $fechaActual
            );
            
            $infSistema = $this->sistemas->where("IDSistema", $key)->first();
            
            $subdom = $infSistema['Subdominio'];
            $dom = $infSistema['Dominio'];
            $subcar = $infSistema['Subcarpeta'];
            
            if(!empty($subdom) && !empty($dom) && !empty($subcar))
            {
                $urlSis = "https://".$subdom.".".$dom."/".$subcar;
            }
            else if(empty($subdom) && !empty($dom) && !empty($subcar))
            {
                $urlSis = "https://".$dom."/".$subcar;
            }
            else if(!empty($subdom) && !empty($dom) && empty($subcar))
            {
                $urlSis = "https://".$subdom.".".$dom;
            }
            else
            {
                $urlSis = "https://".$dom;
            }
            
            $sistemasAutorizados[$key] = array("NOMBRE" => $nombre[$key], "RAIZ" => $urlSis);
        }
        
        $lastId = $this->usuarioSistemas->insertBatch($dataSistemas, TRUE);

		if($lastId !== FALSE){
		    
    		/*
            * -------------
            * GENERAR CONTRASEÑA
            * -------------
            */
    		
    		$infoUsuario = $this->usuarioModelo->where('IdUsuario', $idUsuario)->first();
        	
        	if($infoUsuario['Password'] == '' || $infoUsuario['Password'] == null)
        	{
                $passwordxdni="Verisure".substr($infoUsuario['NumeroDoc'],-4);
                $user_password_hash=password_hash($passwordxdni,PASSWORD_DEFAULT);
                
                $data = array (
                    'Password'          => $user_password_hash,
                    'UsuarioModifica'   => $this->items['id'],
                    'FechaModifica'     => $fechaActual,    
                    'Localhost'         => $this->request->getIPAddress()
                );
        
                $this->usuarioModelo->update([$idUsuario], $data);
    
                /*
                * ----------------------------
                * PREPARACIÓN DE CUERPO DE CORREO
                * ----------------------------
                */
                
                $arrayCuerpo = array(
                    "TITULO"        => "ALTA DE USUARIO - SISTEMAS VERISURE",
                    "USUARIO"       => ucwords(mb_strtolower($infoUsuario['Nombres'].' '.$infoUsuario['Apellidos'])),
                    "MATRICULA"     => $infoUsuario['Matricula'],
                    "USER"          => $infoUsuario['Usuario'],
                    "PASSWORD"      => $passwordxdni,
                    "AUTORIZADOS"   => $sistemasAutorizados
                );
        
                $cuerpo = $this->plantillasCorreo->cuerpoAvisoAltaUsuario($arrayCuerpo);
                
                /*
                * ----------------------------
                * PREPARACIÓN DE PARAMETROS PARA EL CORREO
                * ----------------------------
                */
        
                $asunto='ALTA DE USUARIO - SISTEMAS VERISURE';
                //$correoDestino = array($asignado['Correo']);
                $configCorreo = array(
                    "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
                    "CORREO_ORIGEN" => 'desarrollo@verisure.pe',
                    "CORREOS_DESTINOS" => array($infoUsuario['Correo']),
                    "CORREOS_COPIA" => array(),
                    "CORREOS_OCULTO" => array('josejesus.cuadros@verisure.pe', 'joseenrique.nanquen@verisure.pe'),
                    "ASUNTO" => $asunto,
                    "MENSAJE" => $cuerpo
                );
        
                $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);
        
                $dataCorreo = array(
                    "IDUsuario"     => $idUsuario,
                    "Asunto"        => $asunto,
                    "Response"      => $estadoCorreo['RESPUESTA'],
                    "Error"         => $estadoCorreo['ERROR'],
                    'UsuarioCrea'   => $this->items['id'],
                    'FechaCrea'     => $fechaActual,    
                    'Localhost'     => $this->request->getIPAddress()
                );
        
                $this->correoStatusUsuario->insert($dataCorreo, TRUE);
		    }
			$message = sprintf($this->mensajeError->msg502, $idUsuario);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    /**************************************************************************/
    
    /******************************** IMPORTAR ********************************/
    
    public function importarCSVUsuario()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DECLARAR Y ASIGNAR VARIABLE A ARCHIVO OBTENIDO
        * ----------------------------
        */
        
        $csv = $this->request->getFile("itemsFile");

        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $csv->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $csv->getErrorString().'-'.$csv->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'itemsFile' => [
                'mime_in[itemsFile,text/csv,text/plain]',
                'ext_in[itemsFile,csv]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        /*
        * ----------------------------
        * VALIDAR SEPARADOR CSV
        * ----------------------------
        */
        
        $separadorCSV = $this->complementos->validarSeparadorCSV($csv, 15);
        
        if (!$separadorCSV) {
            $message = sprintf($this->mensajeError->msg201, "No se encontró separador de CSV autorizado. Debe usar coma (,) o punto y coma (;) y eliminar celdas vacías a la derecha de la última columna.");
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y VALIDAR DATOS CORRECTOS
        * ----------------------------
        */
        
        //Declaramos variables
        $fila = 0;
        $filasError = array();
        $ejecutarInsert = true;
        //Abrimos el archivo
        $handle = fopen($csv, "r");

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handle, 0, $separadorCSV)) !== FALSE)
        {
            $fila++;

            if($fila>1)
            {
                $data = array_map("utf8_encode", $data);
                //Asignamos valores de CSV a variables locales
                $matricula      = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $nombres        = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");
                $apellidos      = trim($data[2]," \t\n\r\0\x0B\xc2\xa0");
                $tipoDoc        = trim($data[3]," \t\n\r\0\x0B\xc2\xa0");
                $nroDoc         = trim($data[4]," \t\n\r\0\x0B\xc2\xa0");
                $cargo          = trim($data[5]," \t\n\r\0\x0B\xc2\xa0");
                $manager        = trim($data[6]," \t\n\r\0\x0B\xc2\xa0");
                $fechaIngreso   = trim($data[7]," \t\n\r\0\x0B\xc2\xa0");
                $fechaCese      = trim($data[8]," \t\n\r\0\x0B\xc2\xa0");
                $fte            = trim($data[9]," \t\n\r\0\x0B\xc2\xa0");
                $cc             = trim($data[10]," \t\n\r\0\x0B\xc2\xa0");
                $ln             = trim($data[11]," \t\n\r\0\x0B\xc2\xa0");
                $subarea        = trim($data[12]," \t\n\r\0\x0B\xc2\xa0");
                $area           = trim($data[13]," \t\n\r\0\x0B\xc2\xa0");
                $direccion      = trim($data[14]," \t\n\r\0\x0B\xc2\xa0");

                //Validamos existencia de matricula:
                $datosUsuario = $this->usuarioModelo->where("Matricula",trim($matricula))->first();
                if($matricula == '' && $matricula == null)
                {
                    $filasError[$fila]['MATRICULA'] = "EL CAMPO MATRICULA ES NECESARIO";
                    $ejecutarInsert = false;
                }
                else
                {
                    if(!empty($datosUsuario))
                    {
                        $filasError[$fila]['MATRICULA'] = "MATRICULA YA EXISTE";
                        $ejecutarInsert = false;
                    }
                }
                
                //Validamos Nombres:
                if($nombres == '' && $nombres == null)
                {
                    $filasError[$fila]['NOMBRES'] = "EL CAMPO NOMBRES ES NECESARIO";
                    $ejecutarInsert = false;
                }
                
                //Validamos Apellidos:
                if($apellidos == '' && $apellidos == null)
                {
                    $filasError[$fila]['APELLIDOS'] = "EL CAMPO APELLIDOS ES NECESARIO";
                    $ejecutarInsert = false;
                }
                
                
                //Validamos existencia de Cargo:
                $datoscargo = $this->cargos->where("Cargo",ucwords(mb_strtolower($cargo)))->first();
                if(empty($datoscargo))
                {
                    $filasError[$fila]['CARGO'] = "CARGO NO EXISTE";
                    $ejecutarInsert = false;
                }

                //Validamos existencia de manager:
                if($manager != '')
                {
                    $datosManager = $this->usuarioModelo->where("Matricula",trim($manager))->first();
                    if(empty($datosManager))
                    {
                        $filasError[$fila]['MATRICULA MANAGER'] = "MATRICULA DE MANAGER NO EXISTE";
                        $ejecutarInsert = false;
                    }
                }
                
                //Validamos Fecha ingreso:
                if($fechaIngreso == '')
                {
                    $filasError[$fila]['FECHA INGRESO'] = "LA FECHA DE INGRESO ES REQUERIDA.";
                    $ejecutarInsert = false;
                }
                
                //Validamos FTE:
                if(!is_numeric($fte) && $fte != null && $fte != '')
                {
                    $filasError[$fila]['FTE'] = "EL FTE INGRESADO NO ES UN NÚMERO.";
                    $ejecutarInsert = false;
                }
                
                //Validamos CC:
                if(!is_numeric($cc) && $cc != null && $cc != '')
                {
                    $filasError[$fila]['CC'] = "EL CC INGRESADO NO ES UN NÚMERO.";
                    $ejecutarInsert = false;
                }
                
                //Validamos LN:
                if(!is_numeric($ln) && $ln != null && $ln != '')
                {
                    $filasError[$fila]['LN'] = "LA LN INGRESADA NO ES UN NÚMERO.";
                    $ejecutarInsert = false;
                }
                
                //Validamos existencia delegacion:
                $whereDelegacion = array("CC" => $cc, "LN" => $ln);
                $datosDelegacion = $this->estructuraDelegaciones->where($whereDelegacion)->first();
                if(empty($datosDelegacion))
                {
                    $filasError[$fila]['CC - LN'] = "NO EXISTE DELEGACIÓN CON EL CC Y LA LN INGRESADA";
                    $ejecutarInsert = false;
                }
                
                //Validamos existencia subarea:
                $datosSubarea = $this->estructuraSubareas->obtenerSubareaXNombres($subarea, $area, $direccion);
                if(empty($datosSubarea))
                {
                    $filasError[$fila]['SUBAREA'] = "NO EXISTE LA SUBÁREA INGRESADA";
                    $ejecutarInsert = false;
                }
            }
        }

        fclose($handle);

        if(!$ejecutarInsert)
        {
            $raiz = 'public/';
            $nombre = 'error.txt';
            $file = 'public/error.txt';
            
            if (file_exists($file)) {
                unlink($file);
            }
            
            $txt= fopen($file, 'a') or die ('Problemas al crear el archivo');
            #  Se establecen los datos que va a conterner el archivo
            foreach($filasError as $key=>$value)
            {
                fwrite($txt, "FILA: ".$key."\n");
                foreach($value as $celda=>$error)
                {
                    fwrite($txt, $celda.": ".$error."\n");
                }
            }
            #  Se hace el ciere para no sobre escribir datos 
            fclose($txt);

            $message = sprintf($this->mensajeError->msg201, "Se detectaron diversas inconsistencias.");
            $salida1 = $this->alertas->alertaError($message);
            $salida2 = $this->alertas->descargaArchivoTXT($nombre);
			echo $salida1.$salida2;
			//echo $salida1;
            
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y EJECUTAR INSERTS
        * ----------------------------
        */
            
        //Declaramos variables
        $arrayInsert = array();
        $arrayUpdate = array();
        
        $fila = 0;
        $filainsert = 0;
        $filaupdate = 0;
        //Abrimos el archivo
        $handleInsert = fopen($csv, "r");

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handleInsert, 0, $separadorCSV)) !== FALSE)
        {
            $data = array_map("utf8_encode", $data);
            $fila++;
            if($fila > 1)
            {
                //Asignamos valores de CSV a variables locales
                $matricula      = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $nombres        = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");
                $apellidos      = trim($data[2]," \t\n\r\0\x0B\xc2\xa0");
                $tipoDoc        = trim($data[3]," \t\n\r\0\x0B\xc2\xa0");
                $nroDoc         = trim($data[4]," \t\n\r\0\x0B\xc2\xa0");
                $cargo          = trim($data[5]," \t\n\r\0\x0B\xc2\xa0");
                $manager        = trim($data[6]," \t\n\r\0\x0B\xc2\xa0");
                $fechaIngreso   = trim($data[7]," \t\n\r\0\x0B\xc2\xa0");
                $fechaCese      = trim($data[8]," \t\n\r\0\x0B\xc2\xa0");
                $fte            = trim($data[9]," \t\n\r\0\x0B\xc2\xa0");
                $cc             = trim($data[10]," \t\n\r\0\x0B\xc2\xa0");
                $ln             = trim($data[11]," \t\n\r\0\x0B\xc2\xa0");
                $subarea        = trim($data[12]," \t\n\r\0\x0B\xc2\xa0");
                $area           = trim($data[13]," \t\n\r\0\x0B\xc2\xa0");
                $direccion      = trim($data[14]," \t\n\r\0\x0B\xc2\xa0");
                
                //Obtenemos información relevante
                $whereDelegacion = array("CC" => $cc, "LN" => $ln);
                
                $datosCargo = $this->cargos->where("Cargo",$cargo)->first();
                $datosManager = $this->usuarioModelo->where("Matricula",trim($manager))->first();
                $datosSubarea = $this->estructuraSubareas->obtenerSubareaXNombres($subarea, $area, $direccion);
                $datosDelegacion = $this->estructuraDelegaciones->where($whereDelegacion)->first();
                
                $detectaFormatoFI = strpos($fechaIngreso, "/");
                    
                if($detectaFormatoFI === false)
                {
                    $fechaIngreso = date("Y-m-d", strtotime($fechaIngreso));
                }
                else
                {
                    $fechaIngreso_e = $this->complementos->myUrlEncode($fechaIngreso);
                    $fechaIngreso = date('Y-m-d', strtotime(str_replace('/', '-', $fechaIngreso_e)));
                }
                
                if($fechaCese != '' && $fechaCese != null)
                {
                    
                    $detectaFormatoFC = strpos($fechaCese, "/");
                        
                    if($detectaFormatoFC === false)
                    {
                        $fechaCese = date("Y-m-d", strtotime($fechaCese));
                    }
                    else
                    {
                        $fechaCese_e = $this->complementos->myUrlEncode($fechaCese);
                        $fechaCese = date('Y-m-d', strtotime(str_replace('/', '-', $fechaCese_e)));
                    }
                    
                }
                
                //Validamos existencia de matricula:
                $datosUsuario = $this->usuarioModelo->where("Matricula",trim($matricula))->first();
                // if(!empty($datosUsuario))
                // {
                //     if($fechaCese != '' && $fechaCese != null)
                //     {
                //         //Armar array de Usuario y modificar datos:
                //         $arrayUpdate[] = array (
                //             'IdUsuario'         => $datosUsuario['IdUsuario'], 
                //             'Matricula'         => $matricula, 
                //             'Nombres'           => $nombres, 
                //             'Apellidos'         => $apellidos, 
                //             'TipoDocumento'     => $tipoDoc, 
                //             'NumeroDoc'         => $nroDoc, 
                //             'Cargo'             => $cargo, 
                //             'CC'                => $cc, 
                //             'LN'                => $ln, 
                //             'Manager'           => $manager, 
                //             'FechaIngreso'      => $fechaIngreso, 
                //             'FechaCese'         => $fechaCese,
                //             'FTE'               => $fte, 
                //             'IDCargo'           => $datosCargo['IDCargo'], 
                //             'IDManager'         => $datosManager['IdUsuario'], 
                //             'IDSubarea'         => $datosSubarea['IDSubarea'], 
                //             'IDDelegacion'      => $datosDelegacion['IDDelegacion'], 
                //             'UsuarioModifica'   => $this->items['id'],
                //             'FechaModifica'     => $fechaActual,  
                //             'Localhost'         => $this->request->getIPAddress(),
                //             'Estado'            => 'Cesado',
                //             'UsuarioEstado'     => $this->items['id'],
                //             'FechaEstado'       => $fechaActual,
                //             'MotivoEstado'      => 'Cesado por CSV masivo.'
                //         );
                //     }
                //     else
                //     {
                //         //Armar array de Usuario y modificar datos:
                //         $arrayUpdate[] = array (
                //             'IdUsuario'         => $datosUsuario['IdUsuario'], 
                //             'Matricula'         => $matricula, 
                //             'Nombres'           => $nombres, 
                //             'Apellidos'         => $apellidos, 
                //             'TipoDocumento'     => $tipoDoc, 
                //             'NumeroDoc'         => $nroDoc, 
                //             'Cargo'             => $cargo, 
                //             'CC'                => $cc, 
                //             'LN'                => $ln, 
                //             'Manager'           => $manager, 
                //             'FechaIngreso'      => $fechaIngreso,
                //             'FTE'               => $fte, 
                //             'IDCargo'           => $datosCargo['IDCargo'], 
                //             'IDManager'         => $datosManager['IdUsuario'], 
                //             'IDSubarea'         => $datosSubarea['IDSubarea'], 
                //             'IDDelegacion'      => $datosDelegacion['IDDelegacion'], 
                //             'UsuarioModifica'   => $this->items['id'],
                //             'FechaModifica'     => $fechaActual,  
                //             'Localhost'         => $this->request->getIPAddress()
                //         );
                //     }
                    
                //     $filaupdate++;
                // }
                // else
                // {
                    //Armar array de Usuario e insertar datos:
                    $arrayInsert[] = array (
                        'Matricula'         => $matricula, 
                        'Nombres'           => $nombres, 
                        'Apellidos'         => $apellidos, 
                        'TipoDocumento'     => $tipoDoc, 
                        'NumeroDoc'         => $nroDoc, 
                        'Cargo'             => $cargo, 
                        'CC'                => $cc, 
                        'LN'                => $ln, 
                        'Manager'           => $manager, 
                        'FechaIngreso'      => $fechaIngreso, 
                        'FTE'               => $fte, 
                        'FechaHoraREG'      => $fechaActual,
                        'IDCargo'           => $datosCargo['IDCargo'], 
                        'IDManager'         => empty($datosManager) ? null : $datosManager['IdUsuario'], 
                        'IDSubarea'         => $datosSubarea['IDSubarea'], 
                        'IDDelegacion'      => $datosDelegacion['IDDelegacion'], 
                        'UsuarioCrea'       => $this->items['id'],
                        'FechaCrea'         => $fechaActual,  
                        'Localhost'         => $this->request->getIPAddress(),    
                        'UsuarioEstado'     => $this->items['id'],
                        'FechaEstado'       => $fechaActual,
                        'MotivoEstado'      => "Alta de usuario masivo.",
                        'Estado'            => 'Activo'
                    );
                    
                    $filainsert++;
                // }
            }
        }

        fclose($handleInsert);
        
        $mensajeConfirmacion = '';

        $statusInsert = $this->usuarioModelo->insertBatch($arrayInsert);
        // $statusUpdate = $this->usuarioModelo->updateBatch($arrayUpdate, 'IdUsuario');
        
        if($statusInsert !== FALSE){
            $mensajeConfirmacion .= "Se registraron el total de ".$filainsert." fila(s).<br>";
            
            $url = $this->complementos->obtenerURLactual();
            
            $aud = array(
                'IDUsuario'     => $this->items['id'],
                'FechaIngreso'  => $fechaActual,
                'Plataforma'    => $url['raiz'],
                'URL'           => $url['ruta'],
                'JSON'          => null,
                'Localhost'     => $this->request->getIPAddress()
            );
            
            $this->log->insert($aud);
            
        }
        else {
            $mensajeConfirmacion .= "No se pudo realizar el registro solicitado. Inténtelo luego.<br>";
        }
        
        // if($statusUpdate !== FALSE){
        //     $mensajeConfirmacion .= "Se actualizaron el total de ".$filaupdate." fila(s).";
        // }
        // else {
        //     $mensajeConfirmacion .= "No se pudo realizar la actualización de los registros. Inténtelo luego.";
        // }
        
        $message = sprintf($this->mensajeError->msg201, $mensajeConfirmacion);
        echo $this->alertas->alertaExito($message);
        //echo $this->alertas->refrescar(1);
        exit;
    }
    
    public function importarCSVUsuarioIT()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DECLARAR Y ASIGNAR VARIABLE A ARCHIVO OBTENIDO
        * ----------------------------
        */
        
        $csv = $this->request->getFile("itemsFile");

        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $csv->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $csv->getErrorString().'-'.$csv->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'itemsFile' => [
                'mime_in[itemsFile,text/csv,text/plain]',
                'ext_in[itemsFile,csv]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        /*
        * ----------------------------
        * VALIDAR SEPARADOR CSV
        * ----------------------------
        */
        
        $separadorCSV = $this->complementos->validarSeparadorCSV($csv, 2);
        
        if (!$separadorCSV) {
            $message = sprintf($this->mensajeError->msg201, "No se encontró separador de CSV autorizado. Debe usar coma (,) o punto y coma (;) y eliminar celdas vacías a la derecha de la última columna.");
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y VALIDAR DATOS CORRECTOS
        * ----------------------------
        */
        
        //Declaramos variables
        $fila = 0;
        $filasError = array();
        $ejecutarInsert = true;
        //Abrimos el archivo
        $handle = fopen($csv, "r");

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handle, 0, $separadorCSV)) !== FALSE)
        {
            $fila++;

            if($fila>1)
            {
                $data = array_map("utf8_encode", $data);
                //Asignamos valores de CSV a variables locales
                $matricula      = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $usuario        = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");

                //Validamos existencia de matricula:
                $datosUsuario = $this->usuarioModelo->where("Matricula",trim($matricula))->first();
                if($matricula == '' || $matricula == null)
                {
                    $filasError[$fila]['MATRICULA'] = "EL CAMPO MATRÍCULA ES NECESARIO";
                    $ejecutarInsert = false;
                }
                else
                {
                    if(empty($datosUsuario))
                    {
                        $filasError[$fila]['MATRICULA'] = "MATRICULA NO EXISTE";
                        $ejecutarInsert = false;
                    }
                }
                
                //Validamos Usuario:
                if($usuario == '' || $usuario == null)
                {
                    $filasError[$fila]['USUARIO'] = "EL CAMPO USUARIO ES NECESARIO";
                    $ejecutarInsert = false;
                }
                
            }
        }

        fclose($handle);

        if(!$ejecutarInsert)
        {
            $raiz = 'public/';
            $nombre = 'error.txt';
            $file = 'public/error.txt';
            
            if (file_exists($file)) {
                unlink($file);
            }
            
            $txt= fopen($file, 'a') or die ('Problemas al crear el archivo');
            #  Se establecen los datos que va a conterner el archivo
            foreach($filasError as $key=>$value)
            {
                fwrite($txt, "FILA: ".$key."\n");
                foreach($value as $celda=>$error)
                {
                    fwrite($txt, $celda.": ".$error."\n");
                }
            }
            #  Se hace el ciere para no sobre escribir datos 
            fclose($txt);

            $message = sprintf($this->mensajeError->msg201, "Se detectaron diversas inconsistencias.");
            $salida1 = $this->alertas->alertaError($message);
            $salida2 = $this->alertas->descargaArchivoTXT($nombre);
			echo $salida1.$salida2;
			//echo $salida1;
            
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y EJECUTAR INSERTS
        * ----------------------------
        */
            
        //Declaramos variables
        $arrayUpdate = array();
        
        $filaUpdate = 0;
        //Abrimos el archivo
        $handleInsert = fopen($csv, "r");

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handleInsert, 0, $separadorCSV)) !== FALSE)
        {
            $data = array_map("utf8_encode", $data);
            $filaUpdate++;
            if($filaUpdate > 1)
            {
                //Asignamos valores de CSV a variables locales
                $matricula  = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $usuario    = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");
                $correo     = $usuario."@verisure.pe";    
                
                //Validamos existencia de matricula:
                $datosUsuario = $this->usuarioModelo->where("Matricula",trim($matricula))->first();
                
                //Armar array de Usuario y modificar datos:
                $arrayUpdate[] = array (
                    'IdUsuario'         => $datosUsuario['IdUsuario'], 
                    'Usuario'           => $usuario, 
                    'Correo'            => $correo,
                    'UsuarioModifica'   => $this->items['id'],
                    'FechaModifica'     => $fechaActual,  
                    'Localhost'         => $this->request->getIPAddress()
                );

            }
        }

        fclose($handleInsert);

        $statusUpdate = $this->usuarioModelo->updateBatch($arrayUpdate, 'IdUsuario');
        
        if($statusUpdate !== FALSE){
            
            $url = $this->complementos->obtenerURLactual();
            
            $aud = array(
                'IDUsuario'     => $this->items['id'],
                'FechaIngreso'  => $fechaActual,
                'Plataforma'    => $url['raiz'],
                'URL'           => $url['ruta'],
                'JSON'          => null,
                'Localhost'     => $this->request->getIPAddress()
            );
            
            $this->log->insert($aud);
            
            $message = sprintf($this->mensajeError->msg201, "Se actualizacion el total de ".($filaUpdate - 1)." fila(s).");
            echo $this->alertas->alertaExito($message);
            echo $this->alertas->refrescar(1);
            exit;
        }
    }
	
    public function importarCSVUsuarioFlota()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DECLARAR Y ASIGNAR VARIABLE A ARCHIVO OBTENIDO
        * ----------------------------
        */
        
        $csv = $this->request->getFile("itemsFile");

        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $csv->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $csv->getErrorString().'-'.$csv->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'itemsFile' => [
                'mime_in[itemsFile,text/csv,text/plain]',
                'ext_in[itemsFile,csv]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        /*
        * ----------------------------
        * VALIDAR SEPARADOR CSV
        * ----------------------------
        */
        
        $separadorCSV = $this->complementos->validarSeparadorCSV($csv, 3);
        
        if (!$separadorCSV) {
            $message = sprintf($this->mensajeError->msg201, "No se encontró separador de CSV autorizado. Debe usar coma (,) o punto y coma (;) y eliminar celdas vacías a la derecha de la última columna.");
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y VALIDAR DATOS CORRECTOS
        * ----------------------------
        */
        
        //Declaramos variables
        $fila = 0;
        $filasError = array();
        $ejecutarInsert = true;
        //Abrimos el archivo
        $handle = fopen($csv, "r");
        //Recorremos las filas del CSV
        while (($data = fgetcsv($handle, 0, $separadorCSV)) !== FALSE)
        {
            $fila++;

            if($fila>1)
            {
                $data = array_map("utf8_encode", $data);
                //Asignamos valores de CSV a variables locales
                $matricula      = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $brevete        = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");
                $numplaca       = trim($data[2]," \t\n\r\0\x0B\xc2\xa0");

                //Validamos existencia de matricula:
                $datosUsuario = $this->usuarioModelo->where("Matricula",trim($matricula))->first();
                if($matricula == '' || $matricula == null)
                {
                    $filasError[$fila]['MATRICULA'] = "EL CAMPO MATRÍCULA ES NECESARIO";
                    $ejecutarInsert = false;
                }
                else
                {
                    if(empty($datosUsuario))
                    {
                        $filasError[$fila]['MATRICULA'] = "MATRICULA NO EXISTE";
                        $ejecutarInsert = false;
                    }
                }
                
                //Validamos Brevete:
                $datosUsuarioBrevete = $this->usuarioModelo->where("brevete",trim($brevete))->first();
                
                if($brevete == '' || $brevete == null)
                {
                    $filasError[$fila]['BREVETE'] = "EL CAMPO BREVETE ES NECESARIO";
                    $ejecutarInsert = false;
                }
                else
                {
                    if(!empty($datosUsuarioBrevete))
                    {
                        $filasError[$fila]['BREVETE'] = "BREVETE YA ASIGNADO";
                        $ejecutarInsert = false;
                    }
                }
                
                //Validamos Placa:
                if($numplaca == '' || $numplaca == null)
                {
                    $filasError[$fila]['PLACA'] = "EL CAMPO PLACA ES NECESARIO";
                    $ejecutarInsert = false;
                }
                else
                {
                    if(!preg_match('/[A-Z0-9]{3}[0-9]{3}/',$numplaca))
                    {
                        $filasError[$fila]['PLACA'] = "FORMATO DE PLACA NO VÁLIDO";
                        $ejecutarInsert = false;
                    }
                }
                
            }
        }

        fclose($handle);

        if(!$ejecutarInsert)
        {
            $raiz = 'public/';
            $nombre = 'error.txt';
            $file = 'public/error.txt';
            
            if (file_exists($file)) {
                unlink($file);
            }
            
            $txt= fopen($file, 'a') or die ('Problemas al crear el archivo');
            #  Se establecen los datos que va a conterner el archivo
            foreach($filasError as $key=>$value)
            {
                fwrite($txt, "FILA: ".$key."\n");
                foreach($value as $celda=>$error)
                {
                    fwrite($txt, $celda.": ".$error."\n");
                }
            }
            #  Se hace el ciere para no sobre escribir datos 
            fclose($txt);

            $message = sprintf($this->mensajeError->msg201, "Se detectaron diversas inconsistencias.");
            $salida1 = $this->alertas->alertaError($message);
            $salida2 = $this->alertas->descargaArchivoTXT($nombre);
			echo $salida1.$salida2;
			//echo $salida1;
            
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y EJECUTAR INSERTS
        * ----------------------------
        */
            
        //Declaramos variables
        $arrayUpdate = array();
        
        $filaUpdate = 0;
        //Abrimos el archivo
        $handleInsert = fopen($csv, "r");

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handleInsert, 0, $separadorCSV)) !== FALSE)
        {
            $data = array_map("utf8_encode", $data);
            $filaUpdate++;
            if($filaUpdate > 1)
            {
                //Asignamos valores de CSV a variables locales
                $matricula      = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $brevete        = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");
                $numplaca       = trim($data[2]," \t\n\r\0\x0B\xc2\xa0");
                
                //Validamos existencia de matricula:
                $datosUsuario = $this->usuarioModelo->where("Matricula",trim($matricula))->first();
                
                //Armar array de Usuario y modificar datos:
                $arrayUpdate[] = array (
                    'IdUsuario'         => $datosUsuario['IdUsuario'], 
                    'brevete'           => $brevete, 
                    'numero_placa'      => $numplaca,
                    'UsuarioModifica'   => $this->items['id'],
                    'FechaModifica'     => $fechaActual,  
                    'Localhost'         => $this->request->getIPAddress()
                );

            }
        }

        fclose($handleInsert);

        $statusUpdate = $this->usuarioModelo->updateBatch($arrayUpdate, 'IdUsuario');
        
        if($statusUpdate !== FALSE)
        {
            $url = $this->complementos->obtenerURLactual();
            
            $aud = array(
                'IDUsuario'     => $this->items['id'],
                'FechaIngreso'  => $fechaActual,
                'Plataforma'    => $url['raiz'],
                'URL'           => $url['ruta'],
                'JSON'          => null,
                'Localhost'     => $this->request->getIPAddress()
            );
            
            $this->log->insert($aud);
            
            $message = sprintf($this->mensajeError->msg201, "Se actualizacion el total de ".($filaUpdate - 1)." fila(s).");
            echo $this->alertas->alertaExito($message);
            echo $this->alertas->refrescar(1);
            exit;
        }
    }
	
    public function importarCSVCambioEstadoUsuarios()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DECLARAR Y ASIGNAR VARIABLE A ARCHIVO OBTENIDO
        * ----------------------------
        */
        
        $csv = $this->request->getFile("itemsFile");

        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $csv->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $csv->getErrorString().'-'.$csv->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'itemsFile' => [
                'mime_in[itemsFile,text/csv,text/plain]',
                'ext_in[itemsFile,csv]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        /*
        * ----------------------------
        * VALIDAR SEPARADOR CSV
        * ----------------------------
        */
        
        $separadorCSV = $this->complementos->validarSeparadorCSV($csv, 5);
        
        if (!$separadorCSV) {
            $message = sprintf($this->mensajeError->msg201, "No se encontró separador de CSV autorizado. Debe usar coma (,) o punto y coma (;) y eliminar celdas vacías a la derecha de la última columna.");
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y VALIDAR DATOS CORRECTOS
        * ----------------------------
        */
        
        //Declaramos variables
        $fila = 0;
        $filasError = array();
        $ejecutarInsert = true;
        //Abrimos el archivo
        $handle = fopen($csv, "r");

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handle, 0, $separadorCSV)) !== FALSE)
        {
            $fila++;

            if($fila>1)
            {
                $data = array_map("utf8_encode", $data);
                //Asignamos valores de CSV a variables locales
                $matricula      = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $estado         = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");
                $ingreso        = trim($data[2]," \t\n\r\0\x0B\xc2\xa0");
                $cese           = trim($data[3]," \t\n\r\0\x0B\xc2\xa0");
                $motivo         = trim($data[4]," \t\n\r\0\x0B\xc2\xa0");

                //Validamos existencia de matricula:
                $datosUsuario = $this->usuarioModelo->where("Matricula",trim($matricula))->first();
                if($matricula == '' || $matricula == null)
                {
                    $filasError[$fila]['MATRICULA'] = "EL CAMPO MATRÍCULA ES NECESARIO";
                    $ejecutarInsert = false;
                }
                else
                {
                    if(empty($datosUsuario))
                    {
                        $filasError[$fila]['MATRICULA'] = "MATRICULA NO EXISTE";
                        $ejecutarInsert = false;
                    }
                }
                
                //Validamos Estado:
                if($estado == '' || $estado == null)
                {
                    $filasError[$fila]['ESTADO'] = "EL CAMPO ESTADO ES NECESARIO";
                    $ejecutarInsert = false;
                }
                else if(!in_array($estado, array("Activo", "Cesado")))
                {
                    $filasError[$fila]['ESTADO'] = "EL CAMPO ESTADO SOLO ACEPTA LOS SIGUIENTES VALORES: ['Activo', 'Cesado']";
                    $ejecutarInsert = false;
                }
                else
                {
                    if($estado == "Activo")
                    {
                        if(empty($ingreso))
                        {
                            $filasError[$fila]['FECHA INGRESO'] = "EL CAMPO FECHA INGRESO ES NECESARIO CUANDO EL ESTADO ES 'Activo'";
                            $ejecutarInsert = false;
                        }
                    }
                    
                    if($estado == "Cesado")
                    {
                        if(empty($cese))
                        {
                            $filasError[$fila]['FECHA CESE'] = "EL CAMPO FECHA CESE ES NECESARIO CUANDO EL ESTADO ES 'Cesado'";
                            $ejecutarInsert = false;
                        }
                    }
                }
                
                //Validamos Motivo de estado
                if($motivo == '' || $motivo == null)
                {
                    $filasError[$fila]['MOTIVO ESTADO'] = "EL CAMPO MOTIVO ESTADO ES NECESARIO";
                    $ejecutarInsert = false;
                }
            }
        }

        fclose($handle);

        if(!$ejecutarInsert)
        {
            $raiz = 'public/';
            $nombre = 'error.txt';
            $file = 'public/error.txt';
            
            if (file_exists($file)) {
                unlink($file);
            }
            
            $txt= fopen($file, 'a') or die ('Problemas al crear el archivo');
            #  Se establecen los datos que va a conterner el archivo
            foreach($filasError as $key=>$value)
            {
                fwrite($txt, "FILA: ".$key."\n");
                foreach($value as $celda=>$error)
                {
                    fwrite($txt, $celda.": ".$error."\n");
                }
            }
            #  Se hace el ciere para no sobre escribir datos 
            fclose($txt);

            $message = sprintf($this->mensajeError->msg201, "Se detectaron diversas inconsistencias.");
            $salida1 = $this->alertas->alertaError($message);
            $salida2 = $this->alertas->descargaArchivoTXT($nombre);
			echo $salida1.$salida2;
			//echo $salida1;
            
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y EJECUTAR INSERTS
        * ----------------------------
        */
        
        //Declaramos variables
        $arrayUpdate = array();
        
        $filaUpdate = 0;
        //Abrimos el archivo
        $handleInsert = fopen($csv, "r");

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handleInsert, 0, $separadorCSV)) !== FALSE)
        {
            $data = array_map("utf8_encode", $data);
            $filaUpdate++;
            if($filaUpdate > 1)
            {
                //Asignamos valores de CSV a variables locales
                $matricula      = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $estado         = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");
                $ingreso        = trim($data[2]," \t\n\r\0\x0B\xc2\xa0");
                $cese           = trim($data[3]," \t\n\r\0\x0B\xc2\xa0");
                $motivo         = trim($data[4]," \t\n\r\0\x0B\xc2\xa0");

                //Validamos existencia de matricula:
                $datosUsuario = $this->usuarioModelo->where("Matricula",trim($matricula))->first();
                
                //Armar array de Usuario y modificar datos:
                
                if($estado == "Activo")
                {
                    $detectaFormatoFI = strpos($ingreso, "/");
                        
                    if($detectaFormatoFI === false)
                    {
                        $ingreso = date("Y-m-d", strtotime($ingreso));
                    }
                    else
                    {
                        $ingreso_e = $this->complementos->myUrlEncode($ingreso);
                        $ingreso = date('Y-m-d', strtotime(str_replace('/', '-', $ingreso_e)));
                    }
                    
                    $arrayUpdate[] = array (
                        'IdUsuario'         => $datosUsuario['IdUsuario'], 
                        'FechaIngreso'      => $ingreso,  
                        'FechaCese'         => NULL,  
                        'FechaHoraMODIF'    => $fechaActual,  
                        'Estado'            => $estado, 
                        'UsuarioEstado'     => $this->items['id'],
                        'FechaEstado'       => $fechaActual,  
                        'MotivoEstado'      => $motivo,
                        'UsuarioModifica'   => $this->items['id'],
                        'FechaModifica'     => $fechaActual,  
                        'Localhost'         => $this->request->getIPAddress()
                    );
                }
                else
                {
                    $detectaFormatoFC = strpos($cese, "/");
                        
                    if($detectaFormatoFC === false)
                    {
                        $cese = date("Y-m-d", strtotime($cese));
                    }
                    else
                    {
                        $cese_e = $this->complementos->myUrlEncode($cese);
                        $cese = date('Y-m-d', strtotime(str_replace('/', '-', $cese_e)));
                    }
                    
                    $arrayUpdate[] = array (
                        'IdUsuario'         => $datosUsuario['IdUsuario'],
                        'FechaCese'         => $cese,  
                        'FechaHoraMODIF'    => $fechaActual,  
                        'Estado'            => $estado, 
                        'UsuarioEstado'     => $this->items['id'],
                        'FechaEstado'       => $fechaActual,  
                        'MotivoEstado'      => $motivo,
                        'UsuarioModifica'   => $this->items['id'],
                        'FechaModifica'     => $fechaActual,  
                        'Localhost'         => $this->request->getIPAddress()
                    );
                }

            }
        }

        fclose($handleInsert);

        $statusUpdate = $this->usuarioModelo->updateBatch($arrayUpdate, 'IdUsuario');
        
        if($statusUpdate !== FALSE){
            
            $url = $this->complementos->obtenerURLactual();
            
            $aud = array(
                'IDUsuario'     => $this->items['id'],
                'FechaIngreso'  => $fechaActual,
                'Plataforma'    => $url['raiz'],
                'URL'           => $url['ruta'],
                'JSON'          => null,
                'Localhost'     => $this->request->getIPAddress()
            );
            
            $this->log->insert($aud);
            
            $message = sprintf($this->mensajeError->msg201, "Se actualizacion el total de ".($filaUpdate - 1)." fila(s).");
            echo $this->alertas->alertaExito($message);
            echo $this->alertas->refrescar(1);
            exit;
        }
    }
	
    /**************************************************************************/
    
    /******************************** EXPORTAR ********************************/
    
    public function exportarTotalUsuarios()
    {
        $listadoUsuario = $this->usuarioModelo->listadoUsuarios(array());
        
        $filename = "usuarios.xlsx";
        $writer = WriterEntityFactory::createXLSXWriter();
        //$writer->setFieldDelimiter(';');
        $writer->setShouldUseInlineStrings(true); // default (and recommended) value
        $writer->openToBrowser($filename);
        
        $cells = [
            WriterEntityFactory::createCell("Codigo"),
            WriterEntityFactory::createCell("Matrícula"),
            WriterEntityFactory::createCell("Usuario"),
            WriterEntityFactory::createCell("Nombres"),
            WriterEntityFactory::createCell("Apellidos"),
            WriterEntityFactory::createCell("Tipo de documento"),
            WriterEntityFactory::createCell("Nro de documento"),
            WriterEntityFactory::createCell("Cargo"),
            WriterEntityFactory::createCell("Matricula Jefe Inmediato"),
            WriterEntityFactory::createCell("Fecha Ingreso"),
            WriterEntityFactory::createCell("Fecha Cese"),
            WriterEntityFactory::createCell("FTE"),
            WriterEntityFactory::createCell("Delegación"),
            WriterEntityFactory::createCell("CC"),
            WriterEntityFactory::createCell("LN"),
            WriterEntityFactory::createCell("Subárea"),
            WriterEntityFactory::createCell("Área"),
            WriterEntityFactory::createCell("Dirección"),
            WriterEntityFactory::createCell("Estado")
        ];
        
        /** add a row at a time */
        $singleRow = WriterEntityFactory::createRow($cells);
        $writer->addRow($singleRow);
        
        foreach($listadoUsuario as $key=>$item)
        {
            $ingreso = $item['FechaIngreso'] != '' && $item['FechaIngreso'] != null ? date("Y-m-d", strtotime($item['FechaIngreso'])) : null;
            $cese = $item['FechaCese'] != '' && $item['FechaCese'] != null ? date("Y-m-d", strtotime($item['FechaCese'])) : null;
			$cells = [
                WriterEntityFactory::createCell($item['IdUsuario']),
                WriterEntityFactory::createCell($item['Matricula']),
                WriterEntityFactory::createCell($item['Usuario']),
                WriterEntityFactory::createCell($item['Nombres']),
                WriterEntityFactory::createCell($item['Apellidos']),
                WriterEntityFactory::createCell($item['TipoDocumento']),
                WriterEntityFactory::createCell($item['NumeroDoc']),
                WriterEntityFactory::createCell($item['Cargo']),
                WriterEntityFactory::createCell($item['Matricula_Manager']),
                WriterEntityFactory::createCell($ingreso),
                WriterEntityFactory::createCell($cese),
                WriterEntityFactory::createCell($item['FTE']),
                WriterEntityFactory::createCell($item['Delegacion']),
                WriterEntityFactory::createCell($item['CC']),
                WriterEntityFactory::createCell($item['LN']),
                WriterEntityFactory::createCell($item['Subarea']),
                WriterEntityFactory::createCell($item['Area']),
                WriterEntityFactory::createCell($item['Direccion']),
                WriterEntityFactory::createCell($item['Estado'])
            ];
            
            /** add a row at a time */
            $singleRow = WriterEntityFactory::createRow($cells);
            $writer->addRow($singleRow);

        }
        
        $writer->close();
    }
    
    public function exportarUsuariosSinCorreo()
    {
        $listadoUsuario = $this->usuarioModelo->listadoUsuarios(array("estado"=>"Activo","correo"=>""));
        
        $filename = "usuarios.xlsx";
        $writer = WriterEntityFactory::createXLSXWriter();
        //$writer->setFieldDelimiter(';');
        $writer->setShouldUseInlineStrings(true); // default (and recommended) value
        $writer->openToBrowser($filename);
        
        $cells = [
            WriterEntityFactory::createCell("Matrícula"),
            WriterEntityFactory::createCell("Usuario")
        ];
        
        /** add a row at a time */
        $singleRow = WriterEntityFactory::createRow($cells);
        $writer->addRow($singleRow);
        
        foreach($listadoUsuario as $key=>$item)
        {
			$cells = [
                WriterEntityFactory::createCell($item['Matricula']),
                WriterEntityFactory::createCell('')
            ];
            
            /** add a row at a time */
            $singleRow = WriterEntityFactory::createRow($cells);
            $writer->addRow($singleRow);

        }
        
        $writer->close();
    }
	
    /**************************************************************************/
    
    /******************************** USUARIOS ********************************/
    
    // public function listarUsuarioDataTable(){
    //     $orderBy = " ORDER BY ";

    //     foreach ($this->request->getGet('order') as $order) {
    //         $orderBy .= $order['column'] + 1 . " {$order['dir']}, ";
    //     }

    //     $orderBy = substr($orderBy, 0, -2);
    //     $columns = $this->request->getGet('columns');
    //     $fields = ['tblusuario.IdUsuario','nombre_usuario','tblusuario.Matricula','tblusuario.NumeroDoc','perfil_usuario','tblusuario.Usuario','tblusuario.Estado','acciones_usuario'];
    //     $where = '';

    //     foreach ($columns as $k => $column) {
    //         if ($this->request->getGet('search')['value']!="") {
    //             if($k == 1)
    //             {
    //                 $where .= "CONCAT(tblusuario.Nombres, ' ', tblusuario.Apellidos) LIKE '%".$this->request->getGet('search')['value']."%' OR ";
    //             }
    //             else if($k == 4 || $k == 7){}
    //             else
    //             {
    //                 $where .= $fields[$k]." LIKE '%".$this->request->getGet('search')['value']."%' OR ";
    //             }
                
    //         }
    //     }

    //     $where = substr($where, 0, -5);
    //     $length = $this->request->getGet('length');
    //     $start = $this->request->getGet('start'); 

    //     /* LISTAR ORDEN DE COMPRA */
    //     $listaUsuarios = $this->usuarioModelo->listaGeneralUsuario($orderBy,$where,$length,$start);
    //     echo json_encode($listaUsuarios, JSON_NUMERIC_CHECK);
    // }

// 	public function listar(){
// 	   // echo "Hola Mundo"; exit;
// 		if($this->session->get('sesionUsuario')['accesoTmpId'] && in_array(1, $this->items['permisos']) && in_array(2, $this->items['permisos'])){

// 			/* BUSCAR USUARIOS */
// 			$whereUsuarios = array(
// 				'usuarios.eliminacion_logica' => 1
// 			);
// 			$listaUsuarios = $this->usuarioModelo
// 				->where($whereUsuarios)
// 				->orderBy('fecha_registro','DESC')
// 				->findAll();

//             /* LISTAR MANAGERS */
// 			$whereManagers = array(
// 				'usuarios.eliminacion_logica' => 1
// 			);
// 			$listaManagers = $this->usuarioModelo
//                 ->join('usuarios as u', 'u.id_usuario = usuarios.matricula_responsable')
// 				->where($whereManagers)
// 				->orderBy('usuarios.apellido_paterno','ASC')
// 				->findAll();
                
//             /* LISTAR ÁREAS */
// 			$whereAreas = array(
// 				'areas.eliminacion_logica' => 1
// 			);
// 			$listaAreas = $this->areasModelo
//                 ->where($whereAreas)
//                 ->join('departamentos', 'departamentos.id_departamento = areas.departamento_id')
//                 ->orderBy('departamentos.nombre_departamento','ASC')
// 				->findAll();

//             /* LISTAR ROLES */
// 			$whereRoles = array(
// 				'roles.eliminacion_logica' => 1
// 			);
// 			$listaRoles = $this->rolesModelo
// 				->where($whereRoles)
// 				->orderBy('fecha_registro','DESC')
// 				->findAll();            

// 			$data = array (
// 				'session'           => 'on',
// 				'titulo'            => 'Usuarios | Don Bosco',
// 				'breadcrumb'        => $this->items['modulo'],
// 				'listaUsuarios'     => $listaUsuarios,
//                 'listaAreas'        => $listaAreas,
//                 'listaRoles'        => $listaRoles,
//                 'listaManagers'     => $listaManagers
// 			);
// 			$data = array_merge($data, $this->items);
// 			return view('usuarios/listar',$data);			
// 		} else {			
// 			return view('errors/500');	
// 		}
// 	}

//     public function modificarUsuario($idUsuario){
        
//         $fechaActual = date("Y-m-d H:i:s");
// // var_dump($this->items); exit;
//         /*
//         * ----------------------------
//         * DATOS DE AJAX PRE PROCESADOS
//         * ----------------------------
//         */

//         $msjError = TRUE;
//         $perfil = $this->request->getPost('txtPerfilUsuario');
        
//         /*
//         * ----------------------------
//         * VALIDACIÓN DE REQUERIMIENTOS
//         * ----------------------------
//         */

//         $error = '';
//         $error .= $this->complementos->validaCampo($perfil, 'required|trim', 'Perfil');

//         if ($error != '') {
//             $message = sprintf($this->mensajeError->msg201, $error);
//             echo $this->alertas->alertaError($message);
//             EXIT;
//         }

//         /*
//         * ----------------------------
//         * ACTUALIZACIÓN DE DATOS
//         * ----------------------------
//         */

//         $data = array (
//             'IdUsuario'         => $idUsuario,
//             'IDPerfil'          => $perfil,
//             'UsuarioRegistra'   => $this->items['id'],
//             'FechaRegistra'     => $fechaActual
//         );
        
//         $lastId = $this->usuarioPerfil->save($data);
        
// 		if($lastId !== FALSE){
// 			$message = sprintf($this->mensajeError->msg503, $idUsuario);
// 			echo $this->alertas->alertaExito($message);
// 			echo $this->alertas->refrescar(1);
// 		}
//     }

// 	public function listarPermisosUsuario($idUsuario)
//     {
// 		if(isset($this->items['id'])){
// 			/* BUSCAR PERMISOS*/
            
// 			$listaPermisos = $this->usuarioPermisos->listarPermisosUsuario($idUsuario);
//             $usuario = $this->usuarioModelo->where("IdUsuario",$idUsuario)->first();
// 			$listaModulos = $this->modulo->findAll();

// 			$data = array (
// 				'session'               => 'on',
// 				'titulo'                => 'Permisos | Verisure',
// 				'breadcrumb'            => $this->items['modulo'],
// 				'breadcrumb_alias'      => 'Permisos de Usuario',
//                 'previo'                => 'listar-usuarios',
// 				'listaPermisos'         => $listaPermisos,
//                 'listaModulos'          => $listaModulos,
//                 'usuarioSeleccionado'   => $usuario,
//                 'idUsuario'             => $idUsuario
// 			);
// 			$data = array_merge($data, $this->items);
// 			return view('administracion/listar_permisos_usuario',$data);			
// 		} else {
// 			return view('errors/500');
// 		}
// 	}

// 	public function listarRutasUsuario($idUsuario)
//     {
// 		if(isset($this->items['id'])){
// 			/* BUSCAR PERMISOS*/
            
// 			$listaRutas = $this->usuarioRutas->listarRutasUsuario($idUsuario);
//             $usuario = $this->usuarioModelo->where("IdUsuario",$idUsuario)->first();
// 			$listaModulos = $this->modulo->findAll();

// 			$data = array (
// 				'session'               => 'on',
// 				'titulo'                => 'Rutas | Verisure',
// 				'breadcrumb'            => $this->items['modulo'],
// 				'breadcrumb_alias'      => 'Rutas de Usuario',
//                 'previo'                => 'listar-usuarios',
// 				'listaRutas'            => $listaRutas,
//                 'listaModulos'          => $listaModulos,
//                 'usuarioSeleccionado'   => $usuario,
//                 'idUsuario'             => $idUsuario
// 			);
// 			$data = array_merge($data, $this->items);
// 			return view('administracion/listar_rutas_usuario',$data);			
// 		} else {
// 			return view('errors/500');
// 		}
// 	}
    
// 	public function obtenerUsuarios(){
//     	/*
//         * ----------------------
//         * OBTIENE Y VALIDA DATOS
//         * ----------------------
//         */
//         $listadoUsuarios = $this->usuarioModelo->findAll();
        
//         $usuarios=array();

// 		if (!empty($listadoUsuarios)) {
//             foreach ($listadoUsuarios as $items) {
//                 $usuarios[] = array(
// 					'id' => (string) $items['IdDpto'],
//          	        'usuario' => (string) $items['Nombres'].' '.$items['Apellidos'],
//                 );
//             }

//             $resultado = array(
// 				'listadoUsuarios' => json_encode($usuarios)
// 			);
//         } else {
// 			$resultado = array(
// 				'descripcion' => 0,
// 			);
// 		}

//         /*
//          * ----------------------------
//          * DATOS DE AJAX PRE PROCESADOS
//          * ----------------------------
//          */
//         echo json_encode($resultado, JSON_NUMERIC_CHECK);		
// 	}

    public function listadoUsuariosSelect()
    {
        $elemento = $this->request->getPost('term');
        
        $listado = $this->usuarioModelo->listadoUsuariosSelect($elemento['term'], '', 'Activo');
        
        $elementos=array();

        foreach ($listado as $items) {
            $elementos[] = array(
                'id' => (string) $items['IdUsuario'],
                'text' => (string) $items['Matricula']." | ".$items['Nombres']." ".$items['Apellidos']
            );
        }

        echo json_encode($elementos);
    }

}