<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Globales;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;


use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Cell\Coordinate;

use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;

class ReporteNovedades extends BaseController
{
	public function __construct(){
		$this->usuarioModelo = new \App\Models\UsuarioModel();
// 		$this->perfilModelo = new \App\Models\PerfilModel();
// 		$this->subAccionModelo = new \App\Models\SubAccionModel();
//         $this->direccionModelo = new \App\Models\DireccionModel();
//         $this->ubicacionAcceso = new \App\Models\DireccionUbicacionAccesoModel();
//         $this->departamentoINEI = new \App\Models\INEIDepartamentoModel();
//         $this->provinciaINEI = new \App\Models\INEIProvinciaModel();
//         $this->distritoINEI = new \App\Models\INEIDistritoModel();
//         $this->modulo = new \App\Models\ModuloModel();
//         $this->moduloAcciones = new \App\Models\ModulosAccionesModel();
//         $this->moduloRutas = new \App\Models\ModulosRutasModel();
//         $this->moduloCabecera = new \App\Models\ModulosCabeceraModel();
//         $this->perfilPermisos = new \App\Models\PerfilPermisosModel();
//         $this->perfilRutas = new \App\Models\PerfilRutasModel();
        
        $this->grupoTrabajo = new \App\Models\GruposTrabajoModel();
        $this->grupoTrabajoUsuarios = new \App\Models\UsuarioGruposTrabajoModel();
        $this->horarios = new \App\Models\HorariosModel();
        $this->asistencia = new \App\Models\AsistenciaModel();
        $this->planificacion = new \App\Models\PlanificacionModel();
        // $this->metricasDesempeno = new \App\Models\MetricasDesempenoModel();
        $this->categoriaMetrica = new \App\Models\CategoriaMetricaModel();
        // $this->kpiMetrica = new \App\Models\KpiMetricaModel();
        // $this->pagosMetrica = new \App\Models\PagosMetricaModel();
        $this->tempMetricasComplementarias = new \App\Models\TempMetricasComplementariasModel();
        $this->reporteNovedades = new \App\Models\ReporteNovedadesModel();
        
//         $this->sistemas = new \App\Models\SistemasModel();
// 		$this->departamentos = new \App\Models\DepartamentoModel();
//         $this->areas = new \App\Models\AreaModel();
//         $this->cargos = new \App\Models\CargosModel();
        
        // $this->estructuraDirecciones = new \App\Models\EstructuraDireccionModel();
        // $this->estructuraAreas = new \App\Models\EstructuraAreaModel();
        // $this->estructuraSubareas = new \App\Models\EstructuraSubareaModel();
        // $this->estructuraSubareaDelegaciones = new \App\Models\EstructuraSubareaDelegacionesModel();
        // $this->estructuraDelegaciones = new \App\Models\EstructuraDelegacionModel();
	}
	
	public function listarreporteNovedades(){
		if(isset($this->items['id'])){
		    $idUsuarioSession = $this->items['id'];
		    
            $fechaActual = date("Y-m-d");
    		
            $whereMetrica = array('p.FechaTrabajo >=' => '2024-09-02',
                                  'p.FechaTrabajo <=' => $fechaActual);   
                                  
            $dataMetricas = $this->usuarioModelo
                ->select('
                    tblusuario.idUsuario, 
                    tblusuario.Nombres, 
                    tblusuario.Apellidos, 
                    DATEDIFF(CURDATE(), tblusuario.FechaIngreso) / 30 AS meses_en_empresa,
                    md.categoria, 
                    md.cumplimiento_procesos, md.atencion_cliente, md.tmo, md.productividad, md.wp,
                    k1.kpi_dia AS kpi_cumplimiento_procesos, k2.kpi_dia AS kpi_atencion_cliente, k3.kpi_dia AS kpi_tmo, 
                    k4.kpi_dia AS kpi_productividad, k5.kpi_dia AS kpi_wp,
                    p1.pago_above AS pago_above_cp, p1.pago_target AS pago_target_cp, p1.pago_over AS pago_over_cp,
                    p2.pago_above AS pago_above_ac, p2.pago_target AS pago_target_ac, p2.pago_over AS pago_over_ac,
                    p3.pago_above AS pago_above_tmo, p3.pago_target AS pago_target_tmo, p3.pago_over AS pago_over_tmo,
                    p4.pago_above AS pago_above_product, p4.pago_target AS pago_target_product, p4.pago_over AS pago_over_product,
                    p5.pago_above AS pago_above_wp, p5.pago_target AS pago_target_wp, p5.pago_over AS pago_over_wp,
                    
                        -- Cálculo de bonificación para Cumplimiento de Procesos
                    ROUND(
                        CASE 
                            WHEN md.cumplimiento_procesos * 100 < k1.kpi_dia * k1.porcentaje_above THEN 0
                            WHEN md.cumplimiento_procesos * 100 >= k1.kpi_dia * k1.porcentaje_above AND md.cumplimiento_procesos * 100 < k1.kpi_dia THEN (p1.pago_above * k1.peso) / 100
                            WHEN md.cumplimiento_procesos * 100 >= k1.kpi_dia AND md.cumplimiento_procesos * 100 < k1.kpi_dia * k1.porcentaje_over THEN (p1.pago_target * k1.peso) / 100
                            ELSE (p1.pago_over * k1.peso) / 100
                        END) AS bonificacion_cumplimiento_procesos,
                    
                        -- Cálculo de % de Cumplimiento de Procesos
                    ROUND(
                        CASE 
                            WHEN (md.cumplimiento_procesos * 100 / k1.kpi_dia)*100 >= 110 THEN 110
                            ELSE (md.cumplimiento_procesos * 100 / k1.kpi_dia) * 100
                        END) AS cumplimiento_cumplimiento_procesos,
                    
                        -- Cálculo de bonificación para Atención al Cliente
                    ROUND(
                        CASE 
                            WHEN md.atencion_cliente * 100 < k2.kpi_dia * k2.porcentaje_above THEN 0
                            WHEN md.atencion_cliente * 100 >= k2.kpi_dia * k2.porcentaje_above AND md.atencion_cliente * 100 < k2.kpi_dia THEN (p2.pago_above * k2.peso) / 100
                            WHEN md.atencion_cliente * 100 >= k2.kpi_dia AND md.atencion_cliente * 100 < k2.kpi_dia * k2.porcentaje_over THEN (p2.pago_target * k2.peso) / 100
                            ELSE (p2.pago_over * k2.peso) / 100
                        END) AS bonificacion_atencion_cliente,
                    
                        -- Cálculo de % de Cumplimiento de Atención al Cliente
                    ROUND(
                        CASE 
                            WHEN (md.atencion_cliente * 100 / k2.kpi_dia) >= 110 THEN 110
                            ELSE (md.atencion_cliente * 100 / k2.kpi_dia) * 100
                        END) AS cumplimiento_atencion_cliente,
                    
                        -- Cálculo de bonificación para TMO
                    ROUND(
                        CASE 
                            WHEN md.tmo * 100 < k3.kpi_dia * k3.porcentaje_above THEN 0
                            WHEN md.tmo * 100 >= k3.kpi_dia * k3.porcentaje_above AND md.tmo * 100 < k3.kpi_dia THEN (p3.pago_above * k3.peso) / 100
                            WHEN md.tmo * 100 >= k3.kpi_dia AND md.tmo * 100 < k3.kpi_dia * k3.porcentaje_over THEN (p3.pago_target * k3.peso) / 100
                            ELSE (p3.pago_over * k3.peso) / 100
                        END) AS bonificacion_tmo,
                    
                        -- Cálculo de % de Cumplimiento de TMO
                    ROUND(
                        CASE 
                            WHEN (k3.kpi_dia / md.tmo) * 100 >= 110 THEN 110
                            ELSE (k3.kpi_dia / md.tmo) * 100
                        END) AS cumplimiento_tmo,
                    
                        -- Cálculo de bonificación para Productividad
                    ROUND(
                        CASE 
                            WHEN md.productividad < k4.kpi_dia * k4.porcentaje_above THEN 0
                            WHEN md.productividad >= k4.kpi_dia * k4.porcentaje_above AND md.productividad < k4.kpi_dia THEN (p4.pago_above * k4.peso) / 100
                            WHEN md.productividad >= k4.kpi_dia AND md.productividad < k4.kpi_dia * k4.porcentaje_over THEN (p4.pago_target * k4.peso) / 100
                            ELSE (p4.pago_over * k4.peso) / 100
                        END) AS bonificacion_productividad,
                    
                        -- Cálculo de % de Cumplimiento de Productividad
                    ROUND(
                        CASE 
                            WHEN (md.productividad / k4.kpi_dia) * 100 >= 110 THEN 110
                            ELSE (md.productividad / k4.kpi_dia) * 100
                        END) AS cumplimiento_productividad,
                    
                        -- Cálculo de bonificación para WP
                    ROUND(
                        CASE 
                            WHEN md.wp < k5.kpi_dia * k5.porcentaje_above THEN 0
                            WHEN md.wp >= k5.kpi_dia * k5.porcentaje_above AND md.wp < k5.kpi_dia THEN (p5.pago_above * k5.peso) / 100
                            WHEN md.wp >= k5.kpi_dia AND md.wp < k5.kpi_dia * k5.porcentaje_over THEN (p5.pago_target * k5.peso) / 100
                            ELSE (p5.pago_over * k5.peso) / 100
                        END) AS bonificacion_wp,
                    
                        -- Cálculo de % de Cumplimiento de WP
                    ROUND(
                        CASE 
                            WHEN (k5.kpi_noche / md.wp) * 100 >= 110 THEN 110
                            ELSE (k5.kpi_noche / md.wp) * 100
                        END) AS cumplimiento_wp,
                    
                        -- Cálculo del desempeño final basado en la suma de cumplimientos
                    ROUND
                        (ROUND(
                            CASE 
                                WHEN (md.cumplimiento_procesos * 100 / k1.kpi_dia)*100 >= 110 THEN 110
                                ELSE (md.cumplimiento_procesos * 100 / k1.kpi_dia) * 100
                            END,2) * 0.30 + 
                        ROUND(
                            CASE 
                                WHEN (md.atencion_cliente * 100 / k2.kpi_dia) >= 110 THEN 110
                                ELSE (md.atencion_cliente * 100 / k2.kpi_dia) * 100
                            END,2) * 0.30 + 
                        ROUND(
                            CASE 
                                WHEN (k3.kpi_dia / md.tmo) * 100 >= 110 THEN 110
                                ELSE (k3.kpi_dia / md.tmo) * 100
                            END,2) * 0.15 + 
                        ROUND(
                            CASE 
                                WHEN (md.productividad / k4.kpi_dia) * 100 >= 110 THEN 110
                                ELSE (md.productividad / k4.kpi_dia) * 100
                            END,2) * 0.15 + 
                        ROUND(
                            CASE 
                                WHEN (k5.kpi_noche / md.wp) * 100 >= 110 THEN 110
                                ELSE (k5.kpi_noche / md.wp) * 100
                            END,2) * 0.10)  AS desempeno_final,

                    -- Horas trabajadas
                    CASE
                        -- Horarios que cruzan la medianoche
                        WHEN h.HoraFin < h.HoraInicio THEN 
                            TIME_FORMAT(SEC_TO_TIME(SUM(TIME_TO_SEC(
                                TIMEDIFF(
                                    -- Si la hora de salida es al día siguiente, ajustamos el cálculo
                                    IF(a_fin.FechaHoraRegistro < CONCAT(p.FechaTrabajo, " ", h.HoraInicio), 
                                        CONCAT(DATE_ADD(p.FechaTrabajo, INTERVAL 1 DAY), " ", h.HoraFin), 
                                        a_fin.FechaHoraRegistro), 
                                    a_inicio.FechaHoraRegistro)
                            ))), "%H:%i:%s")
                        ELSE 
                            -- Horarios normales
                            TIME_FORMAT(SEC_TO_TIME(SUM(TIME_TO_SEC(TIMEDIFF(a_fin.FechaHoraRegistro, a_inicio.FechaHoraRegistro)))), "%H:%i:%s")
                    END AS horas_trabajadas,
                    
                    -- Tardanzas
                    CASE
                        -- Horarios que cruzan la medianoche
                        WHEN h.HoraFin < h.HoraInicio THEN 
                            CASE 
                               
                                WHEN a_inicio.FechaHoraRegistro > CONCAT(p.FechaTrabajo, " ", h.HoraInicio) THEN 
                                    TIME_FORMAT(SEC_TO_TIME(SUM(TIME_TO_SEC(TIMEDIFF(a_inicio.FechaHoraRegistro, CONCAT(p.FechaTrabajo, " ", h.HoraInicio))))), "%H:%i:%s")
                                
                                WHEN a_inicio.FechaHoraRegistro > CONCAT(DATE_ADD(p.FechaTrabajo, INTERVAL 1 DAY), " ", h.HoraFin) THEN 
                                    TIME_FORMAT(SEC_TO_TIME(SUM(TIME_TO_SEC(TIMEDIFF(a_inicio.FechaHoraRegistro, CONCAT(DATE_ADD(p.FechaTrabajo, INTERVAL 1 DAY), " ", h.HoraFin))))), "%H:%i:%s")
                                ELSE "00:00:00"
                            END
                        ELSE
                            -- Horarios normales que no cruzan la medianoche
                            CASE 
                                WHEN a_inicio.FechaHoraRegistro > CONCAT(p.FechaTrabajo, " ", h.HoraInicio) THEN 
                                    TIME_FORMAT(SEC_TO_TIME(SUM(TIME_TO_SEC(TIMEDIFF(a_inicio.FechaHoraRegistro, CONCAT(p.FechaTrabajo, " ", h.HoraInicio))))), "%H:%i:%s")
                                ELSE "00:00:00"
                            END
                    END AS tardanza,
                    
                    -- Horas extras
                    CASE
                        -- Horarios que cruzan la medianoche
                        WHEN h.HoraFin < h.HoraInicio THEN
                            CASE
                                -- Si la hora de salida es mayor que la hora fin al día siguiente
                                WHEN a_fin.FechaHoraRegistro > CONCAT(DATE_ADD(p.FechaTrabajo, INTERVAL 1 DAY), " ", h.HoraFin) THEN 
                                    TIMEDIFF(a_fin.FechaHoraRegistro, CONCAT(DATE_ADD(p.FechaTrabajo, INTERVAL 1 DAY), " ", h.HoraFin))
                                ELSE "00:00:00"
                            END
                        ELSE
                            -- Horarios normales
                            CASE
                                WHEN a_fin.FechaHoraRegistro > CONCAT(p.FechaTrabajo, " ", h.HoraFin) THEN 
                                    TIMEDIFF(a_fin.FechaHoraRegistro, CONCAT(p.FechaTrabajo, " ", h.HoraFin))
                                ELSE "00:00:00"
                            END
                    END AS horas_extras,
                    
                    -- Faltas
                    COUNT(CASE 
                        -- Si no hay registro de inicio ni fin
                        WHEN a_inicio.FechaHoraRegistro IS NULL AND a_fin.FechaHoraRegistro IS NULL THEN 1
                        -- Horarios que cruzan la medianoche
                        WHEN h.HoraFin < h.HoraInicio AND 
                             a_inicio.FechaHoraRegistro IS NULL AND a_fin.FechaHoraRegistro IS NULL THEN 1
                    END) AS total_faltas
                ')
                ->join('tbl_metricas_desempeno md', 'tblusuario.idUsuario = md.idUsuario')
                
                ->join('planificacion p', 'p.IdUsuario = tblusuario.idUsuario')
                ->join('horarios h', 'p.id_horario = h.id_horario')
                ->join('asistencia a_inicio', 'p.IdUsuario = a_inicio.IdUsuario AND a_inicio.TipoRegistro = "inicio" AND a_inicio.FechaHoraRegistro LIKE CONCAT(p.FechaTrabajo, "%") AND a_inicio.id_horario = p.id_horario','left')
                ->join('asistencia a_fin', 'p.IdUsuario = a_fin.IdUsuario AND a_fin.TipoRegistro = "fin" AND a_fin.FechaHoraRegistro LIKE CONCAT(p.FechaTrabajo, "%") AND a_fin.id_horario = p.id_horario','left')
                
                ->join('tbl_categoria_metrica c', 'md.categoria = c.nombre_categoria')
                
                // -- Uniones con las métricas de cada subcriterio
                ->join('tbl_kpi_metrica k1', 'c.id_categoria = k1.id_categoria AND k1.id_subcriterio = 1')
                ->join('tbl_pagos_metrica p1', 'c.id_categoria = p1.id_categoria AND p1.id_subcriterio = 1')
                
                ->join('tbl_kpi_metrica k2', 'c.id_categoria = k2.id_categoria AND k2.id_subcriterio = 2')
                ->join('tbl_pagos_metrica p2', 'c.id_categoria = p2.id_categoria AND p2.id_subcriterio = 2')
            
                ->join('tbl_kpi_metrica k3', 'c.id_categoria = k3.id_categoria AND k3.id_subcriterio = 3')
                ->join('tbl_pagos_metrica p3', 'c.id_categoria = p3.id_categoria AND p3.id_subcriterio = 3')
            
                ->join('tbl_kpi_metrica k4', 'c.id_categoria = k4.id_categoria AND k4.id_subcriterio = 4')
                ->join('tbl_pagos_metrica p4', 'c.id_categoria = p4.id_categoria AND p4.id_subcriterio = 4')
            
                ->join('tbl_kpi_metrica k5', 'c.id_categoria = k5.id_categoria AND k5.id_subcriterio = 5')
                ->join('tbl_pagos_metrica p5', 'c.id_categoria = p5.id_categoria AND p5.id_subcriterio = 5')
                ->groupBy('tblusuario.idUsuario')
                ->where($whereMetrica)
            
                ->findAll();
                
                
                /***************************** CALCULO PARA BONO DESEMPEÑO ************************************/
                foreach ($dataMetricas as &$usuario) {
                    $bonoDesempeno = 0;
                    if ($usuario['tardanza'] > '00:10:00') {
                        $bonoDesempeno = 0; // Si hay tardanza mayor a 10 minutos, el bono es 0
                    } else {
                        
                        $whereCategoriaMetrica = array('nombre_categoria' => $usuario['categoria']);
                        $dataBono = $this->categoriaMetrica->where($whereCategoriaMetrica)->first();
                            // Dependiendo de la categoría del usuario, calculamos el bono
                        if(!empty($dataBono)){
                            switch ($usuario['categoria']) {
                                case 'Elite':
                                    if ($usuario['desempeno_final'] >= 100) {
                                        $bonoDesempeno = $dataBono['bono_100']; // Valor para categoría Elite con desempeño >= 100
                                    } elseif ($usuario['desempeno_final'] >= 90) {
                                        $bonoDesempeno = $dataBono['bono_90']; // Valor para categoría Elite con desempeño >= 90
                                    }
                                    break;
                    
                                case 'Senior':
                                    if ($usuario['desempeno_final'] >= 100) {
                                        $bonoDesempeno = $dataBono['bono_100']; 
                                    } elseif ($usuario['desempeno_final'] >= 90) {
                                        $bonoDesempeno = $dataBono['bono_90'];
                                    }
                                    break;
                    
                                case 'Junior':
                                    if ($usuario['desempeno_final'] >= 100) {
                                        $bonoDesempeno = $dataBono['bono_100'];
                                    } elseif ($usuario['desempeno_final'] >= 90) {
                                        $bonoDesempeno = $dataBono['bono_90'];
                                    }
                                    break;
                    
                                case 'Trainee':
                                    if ($usuario['desempeno_final'] >= 100) {
                                        $bonoDesempeno = $dataBono['bono_100'];
                                    } elseif ($usuario['desempeno_final'] >= 90) {
                                        $bonoDesempeno = $dataBono['bono_90'];
                                    }
                                    break;
                    
                                default:
                                    $bonoDesempeno = 0; // Si no pertenece a ninguna categoría conocida, el bono es 0
                                    break;
                            }
                        }
                    }
                    // Añadir el bono de desempeño al arreglo del usuario
                    $usuario['bono_desempeno'] = $bonoDesempeno;
                    
                    /***************************** FIN CALCULO PARA BONO DESEMPEÑO ************************************/
                    
                    
                    /***************************** COMISION TOTAL ************************************/
                    
                    if($usuario['meses_en_empresa'] < 1 and $usuario['total_faltas'] <2 and $usuario['tardanza'] < 11 ){
                        $usuario['comision_total'] = 70;
                    }else if($usuario['meses_en_empresa'] >= 4){
                        $usuario['comision_total'] = $usuario['bonificacion_cumplimiento_procesos'] + $usuario['bonificacion_atencion_cliente'] + $usuario['bonificacion_tmo'] + $usuario['bonificacion_productividad'] + $usuario['bonificacion_wp'] + $bonoDesempeno;
                    }else{
                        $usuario['comision_total'] = 0;
                    }
                    
                    /***************************** FIN COMISION TOTAL ************************************/
                    
                    /*************************** VALIDACION HORAS TRABAJADAS ******************************/
                    
                    if($usuario['horas_trabajadas'] == NULL ){
                        $usuario['horas_trabajadas'] = 0;
                    }
                    
                    /*************************** VALIDACION HORAS TRABAJADAS ******************************/
                }
            // var_dump($dataMetricas); exit();
                
                $data = array (
				'session'               => 'on',
				'titulo'                => 'Planificación | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Listado de planificación',
				'idUsuarioSession'    => $idUsuarioSession,
				'dataMetricas' => $dataMetricas
    			);
    			
    			$data = array_merge($data, $this->items);
    			
    			return view('reporteNovedades/listar_reporte_novedades',$data);
    			
        	
		} else {
			return view('errors/500');	
		}
        
	}
	
    public function reporteNovedadesDataTable()
    {   
        $tipofuncion='dataTable';
        $fechaActual = date("Y-m-d");
    	$idUsuarioSession = $this->items['id'];	
    	$grupoTrabajoUsuarioSession = $this->grupoTrabajo->select('IDGrupoTrabajo')->where('JefeGrupoTrabajo',$idUsuarioSession)->findAll();
    	
    	// Extraer solo los valores de IDGrupoTrabajo
        $grupoTrabajoIds = array_column($grupoTrabajoUsuarioSession, 'IDGrupoTrabajo');
    
        // Validar si hay grupos asignados
        if (empty($grupoTrabajoIds)) {
            return $this->response->setJSON([
                'error' => 'No hay grupos de trabajo asignados para este usuario.'
            ]);
        }
    
        $adicionales = array('p.FechaTrabajo >=' => '2024-12-01',
                            'p.FechaTrabajo <=' => $fechaActual);   
        
        // Obtenemos los datos desde el modelo
        $dataServerside = $this->usuarioModelo->listaMetricasServerSide($this->request->getGet(), $adicionales, $grupoTrabajoIds,$tipofuncion);
    
        if (!$dataServerside) {
            $dataServerside = []; // Asegúrate de que sea un array vacío si no hay datos
        }
    
        $recordsTotal = count($dataServerside);
        $recordsFiltered = $recordsTotal; // Puedes ajustar esto si tienes filtros aplicados
        
                /***************************** CALCULO PARA BONO DESEMPEÑO ************************************/
                foreach ($dataServerside as &$usuario) {
                    $bonoDesempeno = 0;
                    if ($usuario['tardanza'] > '00:10:00') {
                        $bonoDesempeno = 0; // Si hay tardanza mayor a 10 minutos, el bono es 0
                    } else {
                        
                        $whereCategoriaMetrica = array('nombre_categoria' => $usuario['categoria']);
                        $dataBono = $this->categoriaMetrica->where($whereCategoriaMetrica)->first();
                            // Dependiendo de la categoría del usuario, calculamos el bono
                        if(!empty($dataBono)){
                            switch ($usuario['categoria']) {
                                case 'Elite':
                                    if ($usuario['desempeno_final'] >= 100) {
                                        $bonoDesempeno = $dataBono['bono_100']; // Valor para categoría Elite con desempeño >= 100
                                    } elseif ($usuario['desempeno_final'] >= 90) {
                                        $bonoDesempeno = $dataBono['bono_90']; // Valor para categoría Elite con desempeño >= 90
                                    }
                                    break;
                    
                                case 'Senior':
                                    if ($usuario['desempeno_final'] >= 100) {
                                        $bonoDesempeno = $dataBono['bono_100']; 
                                    } elseif ($usuario['desempeno_final'] >= 90) {
                                        $bonoDesempeno = $dataBono['bono_90'];
                                    }
                                    break;
                    
                                case 'Junior':
                                    if ($usuario['desempeno_final'] >= 100) {
                                        $bonoDesempeno = $dataBono['bono_100'];
                                    } elseif ($usuario['desempeno_final'] >= 90) {
                                        $bonoDesempeno = $dataBono['bono_90'];
                                    }
                                    break;
                    
                                case 'Trainee':
                                    if ($usuario['desempeno_final'] >= 100) {
                                        $bonoDesempeno = $dataBono['bono_100'];
                                    } elseif ($usuario['desempeno_final'] >= 90) {
                                        $bonoDesempeno = $dataBono['bono_90'];
                                    }
                                    break;
                    
                                default:
                                    $bonoDesempeno = 0; // Si no pertenece a ninguna categoría conocida, el bono es 0
                                    break;
                            }
                        }
                    }
                    // Añadir el bono de desempeño al arreglo del usuario
                    $usuario['bono_desempeno'] = $bonoDesempeno;
                    
                    /***************************** FIN CALCULO PARA BONO DESEMPEÑO ************************************/
                    
                    
                    /***************************** COMISION TOTAL ************************************/
                    
                    if($usuario['meses_en_empresa'] < 1 and $usuario['total_faltas'] <2 and $usuario['tardanza'] < 11 ){
                        $usuario['comision_total'] = 70;
                    }else if($usuario['meses_en_empresa'] >= 4){
                        $usuario['comision_total'] = $usuario['bonificacion_cumplimiento_procesos'] + $usuario['bonificacion_atencion_cliente'] + $usuario['bonificacion_tmo'] + $usuario['bonificacion_productividad'] + $usuario['bonificacion_wp'] + $bonoDesempeno;
                    }else{
                        $usuario['comision_total'] = 0;
                    }
                    
                    /***************************** FIN COMISION TOTAL ************************************/
                    
                    /*************************** VALIDACION HORAS TRABAJADAS ******************************/
                    
                    if($usuario['horas_trabajadas'] == NULL ){
                        $usuario['horas_trabajadas'] = 0;
                    }
                    
                    /*************************** VALIDACION HORAS TRABAJADAS ******************************/
                }
           
        $response = [
            'draw' => intval($this->request->getGet('draw')), // Valor del draw para DataTables
            'recordsTotal' => $recordsTotal,                // Total de registros sin filtro
            'recordsFiltered' => $recordsFiltered,          // Total de registros con filtro
            'data' => $dataServerside                       // Datos a mostrar
        ];
    
        // Devuelve la respuesta como JSON
        return $this->response->setJSON($response);

    } 
    
     public function metricasCalculadasDataTable()
    {   
        $tipofuncion='dataTable';
        $fechaActual = date("Y-m-d");
    	$idUsuarioSession = $this->items['id'];	
    	$grupoTrabajoUsuarioSession = $this->grupoTrabajo->select('IDGrupoTrabajo')->where('JefeGrupoTrabajo',$idUsuarioSession)->findAll();
    	
    	// Extraer solo los valores de IDGrupoTrabajo
        $grupoTrabajoIds = array_column($grupoTrabajoUsuarioSession, 'IDGrupoTrabajo');
    
        // Validar si hay grupos asignados
        if (empty($grupoTrabajoIds)) {
            return $this->response->setJSON([
                'error' => 'No hay grupos de trabajo asignados para este usuario.'
            ]);
        }
    
        $adicionales = array('p.FechaTrabajo >=' => '2024-12-01',
                            'p.FechaTrabajo <=' => $fechaActual);   

        // Obtenemos los datos desde el modelo
        $dataServerside = $this->usuarioModelo->listaMetricasCalculadasServerSide($this->request->getGet(), $adicionales, $grupoTrabajoIds,$tipofuncion);
    
        if (!$dataServerside) {
            $dataServerside = []; // Asegúrate de que sea un array vacío si no hay datos
        }
    
        $recordsTotal = count($dataServerside);
        $recordsFiltered = $recordsTotal; // Puedes ajustar esto si tienes filtros aplicados
        
                /***************************** CALCULO PARA BONO DESEMPEÑO ************************************/
                foreach ($dataServerside as &$usuario) {
                    $bonoDesempeno = 0;
                    if ($usuario['tardanza'] > '00:10:00') {
                        $bonoDesempeno = 0; // Si hay tardanza mayor a 10 minutos, el bono es 0
                    } else {
                        
                        $whereCategoriaMetrica = array('nombre_categoria' => $usuario['categoria']);
                        $dataBono = $this->categoriaMetrica->where($whereCategoriaMetrica)->first();
                            // Dependiendo de la categoría del usuario, calculamos el bono
                        if(!empty($dataBono)){
                            switch ($usuario['categoria']) {
                                case 'Elite':
                                    if ($usuario['desempeno_final'] >= 100) {
                                        $bonoDesempeno = $dataBono['bono_100']; // Valor para categoría Elite con desempeño >= 100
                                    } elseif ($usuario['desempeno_final'] >= 90) {
                                        $bonoDesempeno = $dataBono['bono_90']; // Valor para categoría Elite con desempeño >= 90
                                    }
                                    break;
                    
                                case 'Senior':
                                    if ($usuario['desempeno_final'] >= 100) {
                                        $bonoDesempeno = $dataBono['bono_100']; 
                                    } elseif ($usuario['desempeno_final'] >= 90) {
                                        $bonoDesempeno = $dataBono['bono_90'];
                                    }
                                    break;
                    
                                case 'Junior':
                                    if ($usuario['desempeno_final'] >= 100) {
                                        $bonoDesempeno = $dataBono['bono_100'];
                                    } elseif ($usuario['desempeno_final'] >= 90) {
                                        $bonoDesempeno = $dataBono['bono_90'];
                                    }
                                    break;
                    
                                case 'Trainee':
                                    if ($usuario['desempeno_final'] >= 100) {
                                        $bonoDesempeno = $dataBono['bono_100'];
                                    } elseif ($usuario['desempeno_final'] >= 90) {
                                        $bonoDesempeno = $dataBono['bono_90'];
                                    }
                                    break;
                    
                                default:
                                    $bonoDesempeno = 0; // Si no pertenece a ninguna categoría conocida, el bono es 0
                                    break;
                            }
                        }
                    }
                    // Añadir el bono de desempeño al arreglo del usuario
                    $usuario['bono_desempeno'] = $bonoDesempeno;
                    
                    /***************************** FIN CALCULO PARA BONO DESEMPEÑO ************************************/
                    
                    
                    /***************************** COMISION TOTAL ************************************/
                    
                    if($usuario['meses_en_empresa'] < 1 and $usuario['total_faltas'] <2 and $usuario['tardanza'] < 11 ){
                        $usuario['comision_total'] = 70;
                    }else if($usuario['meses_en_empresa'] >= 4){
                        $usuario['comision_total'] = $usuario['bonificacion_cumplimiento_procesos'] + $usuario['bonificacion_atencion_cliente'] + $usuario['bonificacion_tmo'] + $usuario['bonificacion_productividad'] + $usuario['bonificacion_wp'] + $bonoDesempeno;
                    }else{
                        $usuario['comision_total'] = 0;
                    }
                    
                    /***************************** FIN COMISION TOTAL ************************************/
                    
                    /*************************** VALIDACION HORAS TRABAJADAS ******************************/
                    
                    if($usuario['horas_trabajadas'] == NULL ){
                        $usuario['horas_trabajadas'] = 0;
                    }
                    
                    /*************************** VALIDACION HORAS TRABAJADAS ******************************/
                }
           
        $response = [
            'draw' => intval($this->request->getGet('draw')), // Valor del draw para DataTables
            'recordsTotal' => $recordsTotal,                // Total de registros sin filtro
            'recordsFiltered' => $recordsFiltered,          // Total de registros con filtro
            'data' => $dataServerside                       // Datos a mostrar
        ];
    
        // Devuelve la respuesta como JSON
        return $this->response->setJSON($response);

    }
    
    public function metricasComplementariasDataTable()
    {   
        $tipofuncion='dataTable';
        $fechaActual = date("Y-m-d");
    	$idUsuarioSession = $this->items['id'];	
    	$grupoTrabajoUsuarioSession = $this->grupoTrabajo->select('IDGrupoTrabajo')->where('JefeGrupoTrabajo',$idUsuarioSession)->findAll();
    	
    	// Extraer solo los valores de IDGrupoTrabajo
        $grupoTrabajoIds = array_column($grupoTrabajoUsuarioSession, 'IDGrupoTrabajo');
    
        // Validar si hay grupos asignados
        if (empty($grupoTrabajoIds)) {
            return $this->response->setJSON([
                'error' => 'No hay grupos de trabajo asignados para este usuario.'
            ]);
        }
    
        $adicionales = array('temp_metricas_complementarias.fecha_creacion' => $fechaActual);   

        // Obtenemos los datos desde el modelo
        $dataServerside = $this->grupoTrabajo->listaMetricasComplementariasServerSide($this->request->getGet(), $adicionales, $grupoTrabajoIds,$tipofuncion);

        if (!$dataServerside) {
            $dataServerside = []; // Asegúrate de que sea un array vacío si no hay datos
        }
    
        $recordsTotal = count($this->grupoTrabajoUsuarios->whereIn('IDGrupoTrabajo', $grupoTrabajoIds)->findAll()); // modificar script
        // $recordsFiltered = $recordsTotal; // Puedes ajustar esto si tienes filtros aplicados
        // $searchValue = $this->request->getGet('search')['value'] ?? '';
        // $filteredRecords = $this->grupoTrabajo->getFilteredRecords($adicionales, $grupoTrabajoIds, $searchValue, []);
           
        $response = [
            'draw' => intval($this->request->getGet('draw')), // Valor del draw para DataTables
            'recordsTotal' => $recordsTotal,                // Total de registros sin filtro
            'recordsFiltered' => $recordsTotal,          // Total de registros con filtro
            'data' => $dataServerside                       // Datos a mostrar
        ];
    
        // Devuelve la respuesta como JSON
        return $this->response->setJSON($response);

    }

    public function importarMetricasComplementarias()
    { 

        $fechaActual = date("Y-m-d H:i:s");
        $idUsuarioSession = $this->items['id'];
        $csv = $this->request->getFile("fileCSVMetricasComplementarias");
    
        if (!$csv->isValid()) {
            $this->mostrarError($csv->getErrorString() . '-' . $csv->getError());
            return;
        }
    
        $validationRule = [
            'fileCSVMetricasComplementarias' => [
                'mime_in[fileCSVMetricasComplementarias,text/csv,text/plain]',
                'ext_in[fileCSVMetricasComplementarias,csv]'
            ],
        ];
    
        if (!$this->validate($validationRule)) {
            $this->mostrarError(implode(",", $this->validator->getErrors()));
            return;
        }
    
        $separadorCSV = $this->complementos->validarSeparadorCSV($csv, 31);
        if (!$separadorCSV) {
            $this->mostrarError("Separador de CSV no autorizado. Use ',' o ';' y elimine celdas vacías a la derecha.");
            return;
        }
    
        $fila = 1;
        $filasError = [];
        $filasError = [];
        $lasidreplace = false;
        $camposEsperados = $this->obtenerCamposEsperados();
        $handle = fopen($csv, "r");
    
        while (($data = fgetcsv($handle, 0, $separadorCSV)) !== false) {
            $data = array_map("utf8_encode", $data);
    
            if ($fila > 1) {
                $erroresFila = $this->validarFila($data, $camposEsperados, $fila, $idUsuarioSession);
                if (!empty($erroresFila)) {
                    $filasError[$fila] = $erroresFila;
                } else {
                    $registro = [];
                    foreach ($camposEsperados as $campo => $indice) {
                        $registro[$campo] = trim($data[$indice], " \t\n\r\0\x0B\xc2\xa0");
            
                    }
                    $registro['fecha_creacion'] = $fechaActual;
                    $datosInsertar[] = $registro;
                }
                
                $dataInsertada = $this->tempMetricasComplementarias->replace($registro);
                
                // Validar si el REPLACE fue exitoso
                if (!$dataInsertada) {
                    $lasidreplace = true;
                }
            }
            $fila++;
        }

        fclose($handle);
        
        if (!empty($filasError)) {
            
            $this->generarArchivoErrores($filasError, 'public/error.txt');
            $mensaje2 = $this->mostrarError("Se detectaron diversas inconsistencias. Consulte el archivo de errores.");
            $mensaje1 = $this->alertas->descargaArchivoTXT('error.txt');
            echo $mensaje2.' '.$mensaje1;
            exit;
        }

        // Insertar los datos en la tabla temporal
        if (!$lasidreplace) { 
            // $this->tempMetricasComplementarias->insertBatch($datosInsertar);
            $this->mostrarExito("Datos importados correctamente a la tabla temporal.");
            
        } else {
            $this->mostrarError("No se encontraron datos válidos para importar.");
        }
    }

    
    /**
     * Obtener la lista de campos esperados.
     */
    private function obtenerCamposEsperados()
    {
        return [
            'matricula' => 0,
            'dias_trabajo_efectivo' => 1,
            'fechas_trabajo_efectivo' => 2,
            'dias_teletrabajo' => 3,
            'fechas_teletrabajo' => 4,
            'HHEE25' => 5,
            'HHEE35' => 6,
            'HHEE_dominical_100' => 7,
            'HHEE_feriado' => 8,
            'HHEE_1ro_de_mayo' => 9,
            'HHEE_nocturnas' => 10,
            'bono_productividad' => 11,
            'otros_bonos' => 12,
            'bono_de_carrera' => 13,
            'bonificacion_por_desempeno' => 14,
            'bono_responsabilidad' => 15,
            'bono_inicio' => 16,
            'bono_veritombola' => 17,
            'comisiones_upselling' => 18,
            'reintegro_afecto' => 19,
            'gift_card' => 20,
            'gift_card_upselling' => 21,
            'obsequios_upselling' => 22,
            'obsequios_al_personal' => 23,
            'descuento_por_equipo_celular' => 24,
            'descuento_uniforme_materiales' => 25,
            'descuento_por_demos' => 26,
            'descuento_eps' => 27,
            'descuento_alarma_verisure' => 28,
            'descuento_seguro_rimac' => 29,
            'observaciones' => 30
        ];
    }
    
    /**
     * Validar una fila de datos.
     */
    private function validarFila($data, $camposEsperados, $fila, $idUsuarioSession)
    {
        
        $errores = [];
        $grupoTrabajoValidado = null;
        
        $columnasParaValidar = array(5,6,7,8,10,11,12,13,14,15);
        foreach ($camposEsperados as $campo => $indice) {
            $valor = trim($data[$indice]," \t\n\r\0\x0B\xc2\xa0");
            
            if(in_array($fila, $columnasParaValidar)){
                if (empty($valor)) {
                    $errores[$campo] = "CAMPO " . strtoupper($campo) . " NO EXISTENTE O VACÍO";
                    continue;
                }
            }
    
            // Validar matrícula
            if ($campo === 'matricula') {
                
                $matricula = trim($data[$camposEsperados['matricula']], " \t\n\r\0\x0B\xc2\xa0");
                
                $whereMatricula = ['tblusuario.Matricula' => $valor];
                $idUsuario = $this->usuarioModelo->select('tblusuario.IdUsuario')->where($whereMatricula)->first();
    
                if (empty($idUsuario)) {
                    $errores[$campo] = "LA MATRÍCULA NO EXISTE";
                } else {
                    $grupoTrabajo = $this->usuarioModelo
                        ->select('tblusuario.IdUsuario,usuario_grupostrabajo.IDGrupoTrabajo')
                        ->join('usuario_grupostrabajo', 'usuario_grupostrabajo.IdUsuario = tblusuario.IdUsuario')
                        ->where($whereMatricula)
                        ->first();
    
                    if (empty($grupoTrabajo['IDGrupoTrabajo'])) {
                        $errores[$campo] = "LA MATRÍCULA ".$matricula." NO TIENE GRUPO DE TRABAJO ASOCIADO";
                        continue;
                    }
                    
                    // Validar que todos los grupos de trabajo sean iguales
                    if ($grupoTrabajoValidado === null) {
                        $grupoTrabajoValidado = $grupoTrabajo['IDGrupoTrabajo'];
                    } elseif ($grupoTrabajo['IDGrupoTrabajo'] !== $grupoTrabajoValidado) {
                        $errores[$filaNumero]['grupo_trabajo'] = "LA MATRÍCULA ".$matricula." PERTENECE A UN GRUPO DE TRABAJO DIFERENTE.";
                    }
        
                }
            }
        }
    
        return $errores;
    }
    
    /**
     * Generar un archivo con los errores.
     */
    private function generarArchivoErrores($filasError, $rutaArchivo)
    {
        if (file_exists($rutaArchivo)) {
            unlink($rutaArchivo);
        }
    
        $txt = fopen($rutaArchivo, 'a') or die('Problemas al crear el archivo');
        foreach ($filasError as $key => $value) {
            fwrite($txt, "FILA: " . $key . "\n");
            foreach ($value as $celda => $error) {
                fwrite($txt, strtoupper($celda) . ": " . $error . "\n");
            }
        }
        fclose($txt);
    }
    
    /**
     * Mostrar un mensaje de error.
     */
    private function mostrarError($mensaje)
    {
        return $this->alertas->alertaError(sprintf($this->mensajeError->msg201, $mensaje));
        // exit;
    }
    
    /**
     * Mostrar un mensaje de éxito.
     */
    private function mostrarExito($mensaje)
    {
        echo $this->alertas->alertaExito(sprintf($this->mensajeError->msg201, $mensaje));
        // echo $this->alertas->refrescar(1);
        // exit;
    }
	
	public function exportarReporteNovedades()
	{
	   // $arrayOrdenCompra = array(
	   //     "fechaInicio"  => $fechaInicio,
	   //     "fechaFin"  => $fechaFin
	   // );
	    
	    $listadoOrdenCompra = $this->tempMetricasComplementarias->findAll();
	   // var_dump($this->tempMetricasComplementarias->findAll()); exit;
        $filename = "reporteNovedades.xlsx";
        $writer = WriterEntityFactory::createXLSXWriter();
        //$writer->setFieldDelimiter(';');
        $writer->setShouldUseInlineStrings(true); // default (and recommended) value
        $writer->openToBrowser($filename);
        
        $cells = [
            WriterEntityFactory::createCell("matricula"),
            WriterEntityFactory::createCell("dias_trabajo_efectivo"),
            WriterEntityFactory::createCell("fechas_trabajo_efectivo"),
            WriterEntityFactory::createCell("dias_teletrabajo"),
            WriterEntityFactory::createCell("fechas_teletrabajo"),
            WriterEntityFactory::createCell("HHEE25"),
            WriterEntityFactory::createCell("HHEE35"),
            WriterEntityFactory::createCell("HHEE_dominical_100"),
            WriterEntityFactory::createCell("HHEE_feriado"),
            WriterEntityFactory::createCell("HHEE_1ro_de_mayo"),
            WriterEntityFactory::createCell("HHEE_nocturnas"),
            WriterEntityFactory::createCell("bono_productividad"),
            WriterEntityFactory::createCell("otros_bonos"),
            WriterEntityFactory::createCell("bono_de_carrera"),
            WriterEntityFactory::createCell("bonificacion_por_desempeno"),
            WriterEntityFactory::createCell("bono_responsabilidad"),
            WriterEntityFactory::createCell("bono_inicio"),
            WriterEntityFactory::createCell("bono_veritombola"),
            WriterEntityFactory::createCell("comisiones_upselling"),
            WriterEntityFactory::createCell("reintegro_afecto"),
            WriterEntityFactory::createCell("gift_card"),
            WriterEntityFactory::createCell("gift_card_upselling"),
            WriterEntityFactory::createCell("obsequios_upselling"),
            WriterEntityFactory::createCell("obsequios_al_personal"),
            WriterEntityFactory::createCell("descuento_por_equipo_celular"),
            WriterEntityFactory::createCell("descuento_uniforme_materiales"),
            WriterEntityFactory::createCell("descuento_por_demos"),
            WriterEntityFactory::createCell("descuento_eps"),
            WriterEntityFactory::createCell("descuento_alarma_verisure"),
            WriterEntityFactory::createCell("descuento_seguro_rimac"),
            WriterEntityFactory::createCell("observaciones")
            
        ];
        
        /** add a row at a time */
        $singleRow = WriterEntityFactory::createRow($cells);
        $writer->addRow($singleRow);
        
        foreach($listadoOrdenCompra as $key=>$item)
        {
            
			$cells = [
                WriterEntityFactory::createCell($item['matricula']),
                WriterEntityFactory::createCell($item['dias_trabajo_efectivo']),
                WriterEntityFactory::createCell($item['fechas_trabajo_efectivo']),
                WriterEntityFactory::createCell($item['dias_teletrabajo']),
                WriterEntityFactory::createCell($item['fechas_teletrabajo']),
                WriterEntityFactory::createCell($item['HHEE25']),
                WriterEntityFactory::createCell($item['HHEE35']),
                WriterEntityFactory::createCell($item['HHEE_dominical_100']),
                WriterEntityFactory::createCell($item['HHEE_feriado']),
                WriterEntityFactory::createCell($item['HHEE_1ro_de_mayo']),
                WriterEntityFactory::createCell($item['HHEE_nocturnas']),
                WriterEntityFactory::createCell($item['bono_productividad']),
                WriterEntityFactory::createCell($item['otros_bonos']),
                WriterEntityFactory::createCell($item['bono_de_carrera']),
                WriterEntityFactory::createCell($item['bonificacion_por_desempeno']),
                WriterEntityFactory::createCell($item['bono_responsabilidad']),
                WriterEntityFactory::createCell($item['bono_inicio']),
                WriterEntityFactory::createCell($item['bono_veritombola']),
                WriterEntityFactory::createCell($item['comisiones_upselling']),
                WriterEntityFactory::createCell($item['reintegro_afecto']),
                WriterEntityFactory::createCell($item['gift_card']),
                WriterEntityFactory::createCell($item['gift_card_upselling']),
                WriterEntityFactory::createCell($item['obsequios_upselling']),
                WriterEntityFactory::createCell($item['obsequios_al_personal']),
                WriterEntityFactory::createCell($item['descuento_por_equipo_celular']),
                WriterEntityFactory::createCell($item['descuento_uniforme_materiales']),
                WriterEntityFactory::createCell($item['descuento_por_demos']),
                WriterEntityFactory::createCell($item['descuento_eps']),
                WriterEntityFactory::createCell($item['descuento_alarma_verisure']),
                WriterEntityFactory::createCell($item['descuento_seguro_rimac']),
                WriterEntityFactory::createCell($item['observaciones']),
            ];
            
            /** add a row at a time */
            $singleRow = WriterEntityFactory::createRow($cells);
            $writer->addRow($singleRow);

        }
        
        $writer->close();
	   
	}
	
	public function exportarDatosReporteNovedades($idReporteNovedades)
	{ 
        
        // $idUsuarioSession = $this->items['id'];	
        
        // $grupoUsuario = $this->grupoTrabajo->select('IDGrupoTrabajo')->where('JefeGrupotrabajo',$idUsuarioSession)->findAll(); 
        
        // // Extraer solo los valores de IDGrupoTrabajo
        // $idGrupoTrabajoArray = array_column($grupoUsuario, 'IDGrupoTrabajo');
        
        // if ($idReporteNovedades == 'todos') {
        //     $adicionales = [
        //         'column' => 'reporte_novedades.IDGrupoTrabajo',
        //         'values' => $idGrupoTrabajoArray
        //     ];
        // } else {
        //     $adicionales = [
        //         'column' => 'reporte_novedades.id',
        //         'values' => [$idReporteNovedades] // Asegúrate de que siempre sea un arreglo
        //     ];
        // }
        
        
        /****/
        $dataReporteNovedades = $this->reporteNovedades->select('anioReporte, mesReporte, IDGrupoTrabajo')->where('id',$idReporteNovedades)->first();
        
        $idUsuarioSession = $this->items['id'];	
        
        $grupoUsuario = $this->grupoTrabajo->select('IDGrupoTrabajo')->where('JefeGrupotrabajo',$idUsuarioSession)->findAll(); 
        
        // Extraer solo los valores de IDGrupoTrabajo
        $idGrupoTrabajoArray = array_column($grupoUsuario, 'IDGrupoTrabajo');
        
        if ($idReporteNovedades == 'todos') {
            $adicionales = [
                'column' => 'reporte_novedades.IDGrupoTrabajo',
                'values' => $idGrupoTrabajoArray
            ];
        } else {
            $adicionales = [
                'column' => ['reporte_novedades.anioReporte', 'reporte_novedades.mesReporte', 'reporte_novedades.IDGrupoTrabajo'],
                'values' => [$dataReporteNovedades['anioReporte'], $dataReporteNovedades['mesReporte'], $dataReporteNovedades['IDGrupoTrabajo']] // Asegúrate de que siempre sea un arreglo
            ];
        }
        /****/
	    
	    $listadoDatosReporteNovedades = $this->reporteNovedades
	                                         ->select('
	                                            CONCAT(tu.Nombres," ",tu.Apellidos) AS NombreUsuarioRegistra,
                                                gt.GrupoTrabajo,
                                                UsuarioRegistra,
                                                reporte_novedades.categoria,
                                                horas_trabajadas,
                                                tardanza,
                                                horas_extras,
                                                total_faltas,
                                                bono_desempeno,
                                                comision_total,
                                                reporte_novedades.matricula,
                                                dias_trabajo_efectivo,
                                                fechas_trabajo_efectivo,
                                                dias_teletrabajo,
                                                fechas_teletrabajo,
                                                HHEE25,
                                                HHEE35,
                                                HHEE_dominical_100,
                                                HHEE_feriado,
                                                HHEE_1ro_de_mayo,
                                                HHEE_nocturnas,
                                                bono_productividad,
                                                otros_bonos,
                                                bono_de_carrera,
                                                bonificacion_por_desempeno,
                                                bono_responsabilidad,
                                                bono_inicio,
                                                bono_veritombola,
                                                comisiones_upselling,
                                                reintegro_afecto,
                                                gift_card,
                                                gift_card_upselling,
                                                obsequios_upselling,
                                                obsequios_al_personal,
                                                descuento_por_equipo_celular,
                                                descuento_uniforme_materiales,
                                                descuento_por_demos,
                                                descuento_eps,
                                                descuento_alarma_verisure,
                                                descuento_seguro_rimac,
                                                observaciones,
                                                fecha_creacion,
                                                mesReporte,
                                                anioReporte
                                             ')
	                                        ->join('grupostrabajo gt', 'reporte_novedades.IDGrupoTrabajo = gt.IDGrupoTrabajo', 'left')
	                                        ->join('tblusuario tu', 'reporte_novedades.UsuarioRegistra = tu.idUsuario');
	                                       // ->whereIn($adicionales['column'], $adicionales['values'])
	                                       // Aplica las condiciones basadas en $adicionales
                                            if (!empty($adicionales['values']) && isset($adicionales['column'])) {
                                                if (is_array($adicionales['column'])) {
                                                    // Si hay múltiples columnas, se aplica un where() para cada par columna-valor
                                                    foreach ($adicionales['column'] as $index => $columna) {
                                                        $listadoDatosReporteNovedades->where($columna, $adicionales['values'][$index]);
                                                    }
                                                } else {
                                                    // Si es una única columna, se usa whereIn()
                                                    $listadoDatosReporteNovedades->whereIn($adicionales['column'], $adicionales['values']);
                                                }
                                            }

	                                        // Ejecuta la consulta y obtiene los resultados
        $listadoDatosReporteNovedades = $listadoDatosReporteNovedades->findAll();
	   // var_dump($this->tempMetricasComplementarias->findAll()); exit;
        $filename = "reporteNovedades.xlsx";
        $writer = WriterEntityFactory::createXLSXWriter();
        //$writer->setFieldDelimiter(';');
        $writer->setShouldUseInlineStrings(true); // default (and recommended) value
        $writer->openToBrowser($filename);
        
        $cells = [
            WriterEntityFactory::createCell("GrupoTrabajo"),
            WriterEntityFactory::createCell("matricula"),
            WriterEntityFactory::createCell("NombreUsuarioRegistra"),
            WriterEntityFactory::createCell("categoria"),
            WriterEntityFactory::createCell("horas_trabajadas"),
            WriterEntityFactory::createCell("tardanza"),
            WriterEntityFactory::createCell("horas_extras"),
            WriterEntityFactory::createCell("total_faltas"),
            WriterEntityFactory::createCell("bono_desempeno"),
            WriterEntityFactory::createCell("comision_total"),
            WriterEntityFactory::createCell("dias_trabajo_efectivo"),
            WriterEntityFactory::createCell("fechas_trabajo_efectivo"),
            WriterEntityFactory::createCell("dias_teletrabajo"),
            WriterEntityFactory::createCell("fechas_teletrabajo"),
            WriterEntityFactory::createCell("HHEE25"),
            WriterEntityFactory::createCell("HHEE35"),
            WriterEntityFactory::createCell("HHEE_dominical_100"),
            WriterEntityFactory::createCell("HHEE_feriado"),
            WriterEntityFactory::createCell("HHEE_1ro_de_mayo"),
            WriterEntityFactory::createCell("HHEE_nocturnas"),
            WriterEntityFactory::createCell("bono_productividad"),
            WriterEntityFactory::createCell("otros_bonos"),
            WriterEntityFactory::createCell("bono_de_carrera"),
            WriterEntityFactory::createCell("bonificacion_por_desempeno"),
            WriterEntityFactory::createCell("bono_responsabilidad"),
            WriterEntityFactory::createCell("bono_inicio"),
            WriterEntityFactory::createCell("bono_veritombola"),
            WriterEntityFactory::createCell("comisiones_upselling"),
            WriterEntityFactory::createCell("reintegro_afecto"),
            WriterEntityFactory::createCell("gift_card"),
            WriterEntityFactory::createCell("gift_card_upselling"),
            WriterEntityFactory::createCell("obsequios_upselling"),
            WriterEntityFactory::createCell("obsequios_al_personal"),
            WriterEntityFactory::createCell("descuento_por_equipo_celular"),
            WriterEntityFactory::createCell("descuento_uniforme_materiales"),
            WriterEntityFactory::createCell("descuento_por_demos"),
            WriterEntityFactory::createCell("descuento_eps"),
            WriterEntityFactory::createCell("descuento_alarma_verisure"),
            WriterEntityFactory::createCell("descuento_seguro_rimac"),
            WriterEntityFactory::createCell("observaciones"),
            WriterEntityFactory::createCell("fecha_creacion"),
            WriterEntityFactory::createCell("mesReporte"),
            WriterEntityFactory::createCell("anioReporte")
        ];
        
        /** add a row at a time */
        $singleRow = WriterEntityFactory::createRow($cells);
        $writer->addRow($singleRow);
        
        foreach($listadoDatosReporteNovedades as $key=>$item)
        {
            
			$cells = [
			    WriterEntityFactory::createCell($item['GrupoTrabajo']),
                WriterEntityFactory::createCell($item['matricula']),
                WriterEntityFactory::createCell($item['NombreUsuarioRegistra']),
                WriterEntityFactory::createCell($item["categoria"]),
                WriterEntityFactory::createCell($item["horas_trabajadas"]),
                WriterEntityFactory::createCell($item["tardanza"]),
                WriterEntityFactory::createCell($item["horas_extras"]),
                WriterEntityFactory::createCell($item["total_faltas"]),
                WriterEntityFactory::createCell($item["bono_desempeno"]),
                WriterEntityFactory::createCell($item["comision_total"]),
                WriterEntityFactory::createCell($item['dias_trabajo_efectivo']),
                WriterEntityFactory::createCell($item['fechas_trabajo_efectivo']),
                WriterEntityFactory::createCell($item['dias_teletrabajo']),
                WriterEntityFactory::createCell($item['fechas_teletrabajo']),
                WriterEntityFactory::createCell($item['HHEE25']),
                WriterEntityFactory::createCell($item['HHEE35']),
                WriterEntityFactory::createCell($item['HHEE_dominical_100']),
                WriterEntityFactory::createCell($item['HHEE_feriado']),
                WriterEntityFactory::createCell($item['HHEE_1ro_de_mayo']),
                WriterEntityFactory::createCell($item['HHEE_nocturnas']),
                WriterEntityFactory::createCell($item['bono_productividad']),
                WriterEntityFactory::createCell($item['otros_bonos']),
                WriterEntityFactory::createCell($item['bono_de_carrera']),
                WriterEntityFactory::createCell($item['bonificacion_por_desempeno']),
                WriterEntityFactory::createCell($item['bono_responsabilidad']),
                WriterEntityFactory::createCell($item['bono_inicio']),
                WriterEntityFactory::createCell($item['bono_veritombola']),
                WriterEntityFactory::createCell($item['comisiones_upselling']),
                WriterEntityFactory::createCell($item['reintegro_afecto']),
                WriterEntityFactory::createCell($item['gift_card']),
                WriterEntityFactory::createCell($item['gift_card_upselling']),
                WriterEntityFactory::createCell($item['obsequios_upselling']),
                WriterEntityFactory::createCell($item['obsequios_al_personal']),
                WriterEntityFactory::createCell($item['descuento_por_equipo_celular']),
                WriterEntityFactory::createCell($item['descuento_uniforme_materiales']),
                WriterEntityFactory::createCell($item['descuento_por_demos']),
                WriterEntityFactory::createCell($item['descuento_eps']),
                WriterEntityFactory::createCell($item['descuento_alarma_verisure']),
                WriterEntityFactory::createCell($item['descuento_seguro_rimac']),
                WriterEntityFactory::createCell($item['observaciones']),
                WriterEntityFactory::createCell($item['fecha_creacion']),
                WriterEntityFactory::createCell($item['mesReporte']),
                WriterEntityFactory::createCell($item['anioReporte']),
            ];
            
            /** add a row at a time */
            $singleRow = WriterEntityFactory::createRow($cells);
            $writer->addRow($singleRow);

        }
        
        $writer->close();
	   
	}
	
    public function guardarReporteNovedades($idUsuarioSession)
    { 
        $tipofuncion = 'guardar';
        $fechaActual = date("Y-m-d");
    // 	$idUsuarioSession = $this->items['id'];	
    	$grupoTrabajoUsuarioSession = $this->grupoTrabajo->select('IDGrupoTrabajo')->where('JefeGrupoTrabajo',$idUsuarioSession)->findAll();
    	
    	// Extraer solo los valores de IDGrupoTrabajo
        $grupoTrabajoIds = array_column($grupoTrabajoUsuarioSession, 'IDGrupoTrabajo');
        
        // Validar si hay grupos asignados
        if (empty($grupoTrabajoIds)) {
            echo $this->alertas->alertaError("No hay grupos de trabajo asignados para este usuario ");
            // return $this->response->setJSON([
            //     'error' => 'No hay grupos de trabajo asignados para este usuario.'
            // ]);
        }

        $grupoMatriculaUsuarios = $this->usuarioModelo
                                    ->select('tblusuario.Matricula')
                                    ->join('usuario_grupostrabajo','usuario_grupostrabajo.IdUsuario = tblusuario.IdUsuario')
                                    ->whereIn('usuario_grupostrabajo.IDGrupoTrabajo',$grupoTrabajoIds)
                                    ->findAll();
                                    
        $matriculasGrupoTrabajo = array_column($grupoMatriculaUsuarios, 'Matricula');
        
        /***********************/
                                    
        $dataMetricasComplementarias = $this->tempMetricasComplementarias->select('matricula')->findAll();
       
        // Extraer todas las matrículas de la tabla temp_metricas_complementarias
        $matriculasEnTablaTemporal = array_column($dataMetricasComplementarias, 'matricula');
        
        /***********************/
        // Obtener matrículas que NO están en la tabla
        $matriculasNoEncontradas = array_diff($matriculasGrupoTrabajo, $matriculasEnTablaTemporal);
        
        if (!empty($matriculasNoEncontradas)) {
            $mensajeCreado = "Falta importar datos a las siguientes matrículas: " . implode(", ", $matriculasNoEncontradas);
            echo $this->alertas->alertaError($mensajeCreado);
        } else {
            
            $adicionales = array('p.FechaTrabajo >=' => '2024-12-01',
                                'p.FechaTrabajo <=' => $fechaActual);   
        
            // Obtenemos los datos desde el modelo
            $dataServerside = $this->usuarioModelo->listaMetricasServerSide($this->request->getGet(), $adicionales, $grupoTrabajoIds,$tipofuncion);
        
            if (!$dataServerside) {
                $dataServerside = []; // Asegúrate de que sea un array vacío si no hay datos
            }
            
            $recordsTotal = count($dataServerside);
            // $recordsFiltered = $recordsTotal; // Puedes ajustar esto si tienes filtros aplicados
        
            /***************************** CALCULO PARA BONO DESEMPEÑO ************************************/
                foreach ($dataServerside as &$usuario) {
                    $bonoDesempeno = 0;
                    if ($usuario['tardanza'] > '00:10:00') {
                        $bonoDesempeno = 0; // Si hay tardanza mayor a 10 minutos, el bono es 0
                    } else {
                        
                        $whereCategoriaMetrica = array('nombre_categoria' => $usuario['categoria']);
                        $dataBono = $this->categoriaMetrica->where($whereCategoriaMetrica)->first();
                            // Dependiendo de la categoría del usuario, calculamos el bono
                        if(!empty($dataBono)){
                            switch ($usuario['categoria']) {
                                case 'Elite':
                                    if ($usuario['desempeno_final'] >= 100) {
                                        $bonoDesempeno = $dataBono['bono_100']; // Valor para categoría Elite con desempeño >= 100
                                    } elseif ($usuario['desempeno_final'] >= 90) {
                                        $bonoDesempeno = $dataBono['bono_90']; // Valor para categoría Elite con desempeño >= 90
                                    }
                                    break;
                    
                                case 'Senior':
                                    if ($usuario['desempeno_final'] >= 100) {
                                        $bonoDesempeno = $dataBono['bono_100']; 
                                    } elseif ($usuario['desempeno_final'] >= 90) {
                                        $bonoDesempeno = $dataBono['bono_90'];
                                    }
                                    break;
                    
                                case 'Junior':
                                    if ($usuario['desempeno_final'] >= 100) {
                                        $bonoDesempeno = $dataBono['bono_100'];
                                    } elseif ($usuario['desempeno_final'] >= 90) {
                                        $bonoDesempeno = $dataBono['bono_90'];
                                    }
                                    break;
                    
                                case 'Trainee':
                                    if ($usuario['desempeno_final'] >= 100) {
                                        $bonoDesempeno = $dataBono['bono_100'];
                                    } elseif ($usuario['desempeno_final'] >= 90) {
                                        $bonoDesempeno = $dataBono['bono_90'];
                                    }
                                    break;
                    
                                default:
                                    $bonoDesempeno = 0; // Si no pertenece a ninguna categoría conocida, el bono es 0
                                    break;
                            }
                        }
                    }
                    // Añadir el bono de desempeño al arreglo del usuario
                    $usuario['bono_desempeno'] = $bonoDesempeno;
                    
                    /***************************** FIN CALCULO PARA BONO DESEMPEÑO ************************************/
                    
                    
                    /***************************** COMISION TOTAL ************************************/
                    
                    if($usuario['meses_en_empresa'] < 1 and $usuario['total_faltas'] <2 and $usuario['tardanza'] < 11 ){
                        $usuario['comision_total'] = 70;
                    }else if($usuario['meses_en_empresa'] >= 4){
                        $usuario['comision_total'] = $usuario['bonificacion_cumplimiento_procesos'] + $usuario['bonificacion_atencion_cliente'] + $usuario['bonificacion_tmo'] + $usuario['bonificacion_productividad'] + $usuario['bonificacion_wp'] + $bonoDesempeno;
                    }else{
                        $usuario['comision_total'] = 0;
                    }
                    
                    /***************************** FIN COMISION TOTAL ************************************/
                    
                    /*************************** VALIDACION HORAS TRABAJADAS ******************************/
                    
                    if($usuario['horas_trabajadas'] == NULL ){
                        $usuario['horas_trabajadas'] = 0;
                    }
                    
                    /*************************** FIN VALIDACION HORAS TRABAJADAS ******************************/
                    
                } 
                
                $dataRutas = [];
                foreach($dataServerside as $key => $value){
                    
                    $existe = $this->reporteNovedades
                                    ->where('matricula', $value['matricula'])
                                    ->where('mesReporte', date("m"))
                                    ->where('anioReporte', date("Y"))
                                    ->first();
                                    
                    if (!$existe) {                
                        $dataRutas[] = array (
                        'idUsuario'                     => $value['idUsuario'], 
                        'UsuarioRegistra'               => $idUsuarioSession,
                        'categoria'                     => $value['categoria'],
                        'horas_trabajadas'              => $value['horas_trabajadas'],
                        'tardanza'                      => $value['tardanza'],
                        'horas_extras'                  => $value['horas_extras'], 
                        'total_faltas'                  => $value['total_faltas'],
                        'bono_desempeno'                => $value['bono_desempeno'],
                        'comision_total'                => $value['comision_total'],
                        'matricula'                     => $value['matricula'],
                        'dias_trabajo_efectivo'         => $value['dias_trabajo_efectivo'], 
                        'fechas_trabajo_efectivo'       => $value['fechas_trabajo_efectivo'],
                        'dias_teletrabajo'              => $value['dias_teletrabajo'],
                        'fechas_teletrabajo'            => $value['fechas_teletrabajo'],
                        'HHEE25'                        => $value['HHEE25'],
                        'HHEE35'                        => $value['HHEE35'], 
                        'HHEE_dominical_100'            => $value['HHEE_dominical_100'],
                        'HHEE_feriado'                  => $value['HHEE_feriado'],
                        'HHEE_1ro_de_mayo'              => $value['HHEE_1ro_de_mayo'],
                        'HHEE_nocturnas'                => $value['HHEE_nocturnas'],
                        'bono_productividad'            => $value['bono_productividad'], 
                        'otros_bonos'                   => $value['otros_bonos'],
                        'bono_de_carrera'               => $value['bono_de_carrera'],
                        'bonificacion_por_desempeno'    => $value['bonificacion_por_desempeno'],
                        'bono_responsabilidad'          => $value['bono_responsabilidad'],
                        'bono_inicio'                   => $value['bono_inicio'], 
                        'bono_veritombola'              => $value['bono_veritombola'],
                        'comisiones_upselling'          => $value['comisiones_upselling'],
                        'reintegro_afecto'              => $value['reintegro_afecto'],
                        'gift_card'                     => $value['gift_card'],
                        'gift_card_upselling'           => $value['gift_card_upselling'], 
                        'obsequios_upselling'           => $value['obsequios_upselling'],
                        'obsequios_al_personal'         => $value['obsequios_al_personal'],
                        'descuento_por_equipo_celular'  => $value['descuento_por_equipo_celular'],
                        'descuento_uniforme_materiales' => $value['descuento_uniforme_materiales'],
                        'descuento_por_demos'           => $value['descuento_por_demos'], 
                        'descuento_eps'                 => $value['descuento_eps'],
                        'descuento_alarma_verisure'     => $value['descuento_alarma_verisure'],
                        'descuento_alarma_verisure'     => $value['descuento_alarma_verisure'],
                        'observaciones'                 => $value['observaciones'],
                        'descuento_seguro_rimac'        => $value['descuento_seguro_rimac'],
                        'fecha_creacion'                => $fechaActual,
                        'mesReporte'                    =>date("m"),
                        'anioReporte'                   =>date("Y")
                    );
                    }
                }
              
                $lastId = $this->reporteNovedades->insertBatch($dataRutas, TRUE);
        		
        		if ($lastId !== FALSE && $this->reporteNovedades->affectedRows() > 0) {
                    $matriculasEliminar = array_column($dataServerside, 'matricula');
                    if (!empty($matriculasEliminar)) {
                        $this->tempMetricasComplementarias->whereIn('matricula', $matriculasEliminar)->delete();
                    }
                    
                    $message = sprintf($this->mensajeError->msg502, "Reporte Novedades".date("Y")."-".date("m"));
                    echo $this->alertas->alertaExito($message);
                } else {
                    echo $this->alertas->alertaError("No se pudo guardar el Reporte Novedades. Comunicarse con el área de Desarrollo");
                }
        }

    }
    
    public function listadoReporteNovedadesSelect()
    { 
        $idUsuarioSession = $this->items['id'];	
        
        $grupoUsuario = $this->grupoTrabajo->select('IDGrupoTrabajo')->where('JefeGrupotrabajo',$idUsuarioSession)->findAll(); 
        
        // Extraer solo los valores de IDGrupoTrabajo
        $idGrupoTrabajoArray = array_column($grupoUsuario, 'IDGrupoTrabajo'); 

        // Obtener datos únicos
        $data = $this->reporteNovedades
                 ->distinct()  // Aplicar DISTINCT correctamente
                 ->select('anioReporte, mesReporte, MIN(id) as id')
                 ->whereIn('IDGrupoTrabajo', $idGrupoTrabajoArray)
                 ->groupBy('anioReporte, mesReporte')
                 ->findAll();
    
        // Formatea la respuesta como JSON
        $response = [];
        foreach ($data as $row) {
            $response[] = ['comboReporte' => $row['anioReporte'].'-'.$row['mesReporte'],
                            'idReporte'     => $row['id']
                            ];
        }

        return $this->response->setJSON($response);
    }
    
    public function borrarDataImportada ()
    {
        $idUsuarioSession = $this->request->getPost('usuarioSession');
        $fechaActual = date("Y-m-d");
    // 	$idUsuarioSession = $this->items['id'];	
    	$grupoTrabajoUsuarioSession = $this->grupoTrabajo->select('IDGrupoTrabajo')->where('JefeGrupoTrabajo',$idUsuarioSession)->findAll();
    	
    	// Extraer solo los valores de IDGrupoTrabajo
        $grupoTrabajoIds = array_column($grupoTrabajoUsuarioSession, 'IDGrupoTrabajo');
        
        // Validar si hay grupos asignados
        if (empty($grupoTrabajoIds)) {
            echo $this->alertas->alertaError("No hay grupos de trabajo asignados para este usuario ");
            // return $this->response->setJSON([
            //     'error' => 'No hay grupos de trabajo asignados para este usuario.'
            // ]);
        }

        $grupoMatriculaUsuarios = $this->usuarioModelo
                                    ->select('tblusuario.Matricula')
                                    ->join('usuario_grupostrabajo','usuario_grupostrabajo.IdUsuario = tblusuario.IdUsuario')
                                    ->whereIn('usuario_grupostrabajo.IDGrupoTrabajo',$grupoTrabajoIds)
                                    ->findAll();
                                    
        $matriculasGrupoTrabajo = array_column($grupoMatriculaUsuarios, 'Matricula');
        
        /******** Eliminar matriculas en Tabla Temporal  ***************/
        $RegistrosAntesDeEliminar = $this->tempMetricasComplementarias->whereIn('matricula', $matriculasGrupoTrabajo)->countAllResults();
        
        if (!empty($matriculasGrupoTrabajo)) {
            $this->tempMetricasComplementarias->whereIn('matricula', $matriculasGrupoTrabajo)->delete();
        } else {
            echo $this->alertas->alertaError("No hay registros importados para eliminar.");
        }

        $RegistrosDespuesDeEliminar = $this->tempMetricasComplementarias->whereIn('matricula', $matriculasGrupoTrabajo)->countAllResults();
        
        if ($RegistrosAntesDeEliminar > 0 && $RegistrosDespuesDeEliminar == 0) {
            
            echo $this->alertas->alertaExito("Los registros fueron eliminados correctamente.");
            
            echo $this->alertas->refrescar(1);
            
        } elseif ($RegistrosAntesDeEliminar > 0 && $RegistrosDespuesDeEliminar > 0) {
            
            echo $this->alertas->alertaError("Algunos registros no se eliminaron.");
            
            echo $this->alertas->refrescar(1);
            
        } else {
            echo $this->alertas->alertaError("No existen registros importados para eliminar.");
        }
        
    }

    public function obtenerReporteNovedadesSeleccionada()
    { 
        $idReporteNovedades = $this->request->getGet('idReporte'); 
        
        $idUsuarioSession = $this->items['id'];	
        
        $grupoUsuario = $this->grupoTrabajo->select('IDGrupoTrabajo')->where('JefeGrupotrabajo',$idUsuarioSession)->findAll();  
        
        // Extraer solo los valores de IDGrupoTrabajo
        $idGrupoTrabajoArray = array_column($grupoUsuario, 'IDGrupoTrabajo'); 
        
        if ($idReporteNovedades == 'todos') {
            $adicionales = [
                'column' => 'reporte_novedades.IDGrupoTrabajo',
                'values' => $idGrupoTrabajoArray
            ];
        } else {
            $dataReporteNovedades = $this->reporteNovedades->select('anioReporte, mesReporte, IDGrupoTrabajo')->where('id',$idReporteNovedades)->first();
            
            $adicionales = [
                'column' => ['reporte_novedades.anioReporte', 'reporte_novedades.mesReporte', 'reporte_novedades.IDGrupoTrabajo'],
                'values' => [$dataReporteNovedades['anioReporte'], $dataReporteNovedades['mesReporte'], $dataReporteNovedades['IDGrupoTrabajo']] // Asegúrate de que siempre sea un arreglo
            ];
        }
        
        /* LISTAR ORDEN DE COMPRA */
        $dataServerside = $this->reporteNovedades->listaReporteNovedadesServerSide($this->request->getGet(), $adicionales);
        
        $recordsTotal = !empty($dataServerside) ? count($dataServerside) : 0;
        
        $recordsFiltered = count($this->reporteNovedades->whereIn('IDGrupoTrabajo', $idGrupoTrabajoArray)->findAll());
        
        /*************************************************************/
        
        $dataGrafica = array();
        $dataGrafica['categorias'] = array_unique(array_column($dataServerside,'categoria'));
        
        $dataGrafica['total_faltas_grafica'] = $this->sumarDatosPorCategoria($dataServerside, 'total_faltas');   
        $dataGrafica['comisionTotalGrafica'] = $this->sumarDatosPorCategoria($dataServerside, 'comision_total');
        $dataGrafica['bono_desempeno_grafica'] = $this->sumarDatosPorCategoria($dataServerside, 'bonificacion_por_desempeno');
        $dataGrafica['desempeno_final_grafica'] = $this->sumarDatosPorCategoria($dataServerside, 'comision_total');        
        
        /*************************************************************/

        $datos = [
            'draw' => $this->request->getGet('draw'),
            'recordsTotal' => $recordsTotal,
            'recordsFiltered' => $recordsFiltered,
            'data' => $dataServerside,
            'dataGrafica'  =>  $dataGrafica 
        ];
        
        echo json_encode($datos, JSON_NUMERIC_CHECK);    
    }
    
	public function sumarDatosPorCategoria($data,$campo)
    {
        $sumatoriaPorCategoria = [];
    
        foreach ($data as $empleado) {
            $categoria = $empleado['categoria'];
            $campoData = intval($empleado[$campo]); // Convertimos a entero
    
            if (!isset($sumatoriaPorCategoria[$categoria])) {
                $sumatoriaPorCategoria[$categoria] = 0;
            }
    
            $sumatoriaPorCategoria[$categoria] += $campoData; // Sumamos las faltas
        }
    
        return $sumatoriaPorCategoria;
    }
    
}

