<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Globales;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Cell\Coordinate;

class ControlDeIndicadores extends BaseController
{
	public function __construct(){
// 		$this->usuarioModelo = new \App\Models\UsuarioModel();
// 		$this->perfilModelo = new \App\Models\PerfilModel();
// 		$this->subAccionModelo = new \App\Models\SubAccionModel();
//         $this->direccionModelo = new \App\Models\DireccionModel();
//         $this->departamentoINEI = new \App\Models\INEIDepartamentoModel();
//         $this->provinciaINEI = new \App\Models\INEIProvinciaModel();
//         $this->distritoINEI = new \App\Models\INEIDistritoModel();
//         $this->modulo = new \App\Models\ModuloModel();
//         $this->moduloAcciones = new \App\Models\ModulosAccionesModel();
//         $this->moduloRutas = new \App\Models\ModulosRutasModel();
//         $this->moduloCabecera = new \App\Models\ModulosCabeceraModel();
//         $this->perfilPermisos = new \App\Models\PerfilPermisosModel();
//         $this->perfilRutas = new \App\Models\PerfilRutasModelo();
        
        $this->grupoTrabajo = new \App\Models\GruposTrabajoModel();
        $this->grupoTrabajoUsuarios = new \App\Models\UsuarioGruposTrabajoModel();
        $this->horarios = new \App\Models\HorariosModel();
        $this->asistencia = new \App\Models\AsistenciaModel();
        $this->planificacion = new \App\Models\PlanificacionModel();
        $this->metricasDesempeno = new \App\Models\MetricasDesempenoModel();
        
//         $this->sistemas = new \App\Models\SistemasModel();
// 		$this->departamentos = new \App\Models\DepartamentoModel();
//         $this->areas = new \App\Models\AreaModel();
//         $this->cargos = new \App\Models\CargosModel();
        
        // $this->estructuraDirecciones = new \App\Models\EstructuraDireccionModel();
        // $this->estructuraAreas = new \App\Models\EstructuraAreaModel();
        // $this->estructuraSubareas = new \App\Models\EstructuraSubareaModel();
        // $this->estructuraSubareaDelegaciones = new \App\Models\EstructuraSubareaDelegacionesModel();
        // $this->estructuraDelegaciones = new \App\Models\EstructuraDelegacionModel();
        
        $this->categoriaMetrica = new \App\Models\CategoriaMetricaModel();
        $this->pagosMetrica = new \App\Models\PagosMetricaModel();
        $this->kpiMetrica = new \App\Models\KpiMetricaModel();
	}
	
	public function listarControlDeIndicadores(){
		if(isset($this->items['id'])){
		    
		    $idUsuarioPlanificacion = $this->items['id'];
		    
            // if(in_array('VIUSPL',$this->items['permisos'])){
                
                $fechaActual = date("Y-m-d");
    			
    			// Utiliza la funcion DATE() para comparar solo la fecha en tu consulta
                $asistenciaUsuario = $this->asistencia
                    ->where('IdUsuario', $idUsuarioPlanificacion)
                    ->where('DATE(FechaHoraRegistro)', $fechaActual)
                    // ->orderBy('FechaHoraRegistro', 'DESC')
                    ->findAll();
              
                // Inicializar un array para guardar el estado de cada evento (inicio o fin)
                $estadoEventos = [];
                foreach ($asistenciaUsuario as $asistencia) {
                    $estadoEventos[$asistencia['id_horario']] = $asistencia['TipoRegistro'];
                }

		    
		    $idUsuario = $this->items['id'];
			
			/* GRUPO DE TRABAJO */
			
			$whereUsuarioCrea = array(
				'JefeGrupoTrabajo' => $idUsuario
			);
			
		    $grupoTrabajo = $this->grupoTrabajo->where($whereUsuarioCrea)->findAll(); 
		
			/* USUARIOS GRUPO DE TRABAJO */
			
			$whereUsuarioRegistra = array(
				'UsuarioRegistra' => $idUsuario
			);
			
			$grupoTrabajoUsuarios = $this->grupoTrabajoUsuarios->where($whereUsuarioRegistra)->findAll();
			
           /* BUSCAR PERFILES  */
            
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Control de Indicadores | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Listado de Control de Indicadores',
				'grupoTrabajo'          => $grupoTrabajo,
				'grupoTrabajoUsuarios'  => $grupoTrabajoUsuarios,
				
			);
			$data = array_merge($data, $this->items);
			return view('controlDeIndicadores/listar_control_de_indicadores',$data);
			
		} else {
			return view('errors/500');	
		}
        
	}
	
	public function indicadoresDataTable(){
		if(isset($this->items['id'])){
		    
        $idUsuario = $this->items['id']; 
        $categoria = $this->request->getVar('categoria');
        $adicionales = array();

        /* LISTAR ORDEN DE COMPRA */
        $dataServerside = $this->categoriaMetrica->listaControlIndicadoresServerSide($this->request->getGet(), $adicionales, $categoria);
        // var_dump($dataServerside); exit();
        $recordsTotal = !empty($dataServerside) ? count($dataServerside) : 0;
        // $recordsFiltered = count($this->horarios->where('EliminacionLogica',1)->findAll());
        $whereControlIndicadores = array('UsuarioCreador' => $this->items['id']);
        $recordsFiltered = count($this->categoriaMetrica->listaControlIndicadores($whereControlIndicadores));

        $datos = [
            'draw' => $this->request->getGet('draw'),
            'recordsTotal' => $recordsTotal,
            'recordsFiltered' => $recordsFiltered,
            'data' => $dataServerside
        ];
        echo json_encode($datos, JSON_NUMERIC_CHECK); 
        	
		} else {
			return view('errors/500');	
		}
        
	}

    public function guardarIndicador()
    { 
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $idKpi  = $this->request->getPost('id'); 
        $bono90  = $this->request->getPost('bono90');
        $bono100  = $this->request->getPost('bono100'); 
        $kpi_dia  = $this->request->getPost('kpi_dia'); 
        $kpi_noche = $this->request->getPost('kpi_noche'); 
        $porcentajeAbove = $this->request->getPost('porcentajeAbove'); 
        $porcentajeOver = $this->request->getPost('porcentajeOver');
        $peso = $this->request->getPost('peso'); 
        $pagoAbove = $this->request->getPost('pagoAbove'); 
        $pagoTarget = $this->request->getPost('pagoTarget'); 
        $pagoOver = $this->request->getPost('pagoOver'); 

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idKpi, 'required|trim|numeric|minlength[1]|maxlength[11]', 'ID Kpi');
        $error .= $this->complementos->validaCampo($bono90, 'required|trim|decimal|minlength[1]|maxlength[4]', 'Bono 90');
        $error .= $this->complementos->validaCampo($bono100, 'required|trim|decimal|minlength[1]|maxlength[4]', 'Bono 100');
        $error .= $this->complementos->validaCampo($kpi_dia, 'required|trim|decimal|minlength[1]|maxlength[4]', 'Kpi Dia');
        $error .= $this->complementos->validaCampo($kpi_noche, 'required|trim|decimal|minlength[1]|maxlength[4]', 'Kpi Noche');
        $error .= $this->complementos->validaCampo($porcentajeAbove, 'required|trim|decimal|minlength[1]|maxlength[4]', 'Porcentaje Above');
        $error .= $this->complementos->validaCampo($porcentajeOver, 'required|trim|decimal|minlength[1]|maxlength[4]', 'Porcentaje Over');
        $error .= $this->complementos->validaCampo($peso, 'required|trim|decimal|minlength[1]|maxlength[4]', 'Peso');
        $error .= $this->complementos->validaCampo($pagoAbove, 'required|trim|decimal|minlength[1]|maxlength[4]', 'Pago Above');
        $error .= $this->complementos->validaCampo($pagoTarget, 'required|trim|decimal|minlength[1]|maxlength[4]', 'Pago Target');
        $error .= $this->complementos->validaCampo($pagoOver, 'required|trim|decimal|minlength[1]|maxlength[4]', 'Pago Over');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
		/* Traer id_categoria, id_subcriterio*/
		
		$dataKpiMetrica = $this->kpiMetrica->where('id_kpi', $idKpi)->first();
		
		$id_categoria = $dataKpiMetrica['id_categoria'];
		$id_subcriterio = $dataKpiMetrica['id_subcriterio'];
		
		/****  Update Tabla Kpi_metrica  ****/
        $dataKpi = array (
            'kpi_dia'           => $kpi_dia,
            'kpi_noche'         => $kpi_noche,
            'porcentaje_above'  => $porcentajeAbove,
            'porcentaje_over'   => $porcentajeOver,
            'peso'              => $peso
        );
        
        $lastIdUpdateKpiMetrica = $this->kpiMetrica->update([$idKpi], $dataKpi);
        
        /****  Update Tabla Categoria_metrica  ****/
        
        $dataCategoriaMetrica = array (
            'bono_90'       => $bono90,
            'bono_100'      => $bono100
        );
        
        $lastIdUpdateCategoriaMetrica = $this->categoriaMetrica->update([$id_categoria], $dataCategoriaMetrica);
        
        /*   Traer id_pago   */
        
        $wherePagoMetrica = array('id_categoria' => $id_categoria,
                                    'id_subcriterio' => $id_subcriterio);
                                    
        $datoPagoMetrica= $this->pagosMetrica->where($wherePagoMetrica)->first();
        
        /****  Update Tabla Categoria_metrica  ****/
        
        $idPago = $datoPagoMetrica['id_pago'];
        
        $dataPagosMetrica = array (
            'pago_above'        => $pagoAbove,
            'pago_target'       => $pagoTarget,
            'pago_over'         => $pagoOver
        );

        $lastIdUpdatePagosMetrica = $this->pagosMetrica->update([$idPago], $dataPagosMetrica);

        if($lastIdUpdateKpiMetrica !== FALSE || $lastIdUpdateCategoriaMetrica !== FALSE || $lastIdUpdatePagosMetrica !== FALSE){
            $message = sprintf($this->mensajeError->msg503, $idKpi);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }		
    }
	
}