<?php

namespace App\Controllers;

class Administracion extends BaseController
{

	public function __construct(){
        $this->auditoria = new \App\Models\AuditoriaModel();
        
        $this->sistemas         = new \App\Models\SistemasModel();
        $this->cargos           = new \App\Models\CargosModel();
        $this->direccion        = new \App\Models\DireccionModel();
        $this->ubicacionAcceso  = new \App\Models\DireccionUbicacionAccesoModel();
        
		$this->usuarioModelo = new \App\Models\UsuarioModel();
        $this->usuarioPerfil = new \App\Models\UsuarioPerfilModel();
        $this->usuarioPermisos = new \App\Models\UsuarioPermisosModel();
        $this->usuarioRutas = new \App\Models\UsuarioRutasModel();
        
		$this->perfilModelo = new \App\Models\PerfilModel();
		
        $this->modulo = new \App\Models\ModuloModel();
        $this->moduloAcciones = new \App\Models\ModulosAccionesModel();
        $this->moduloRutas = new \App\Models\ModulosRutasModel();
        $this->moduloCabecera = new \App\Models\ModulosCabeceraModel();
        $this->perfilPermisos = new \App\Models\PerfilPermisosModel();
        $this->perfilRutas = new \App\Models\PerfilRutasModel();
        
        $this->estructuraDirecciones            = new \App\Models\EstructuraDireccionModel();
        $this->estructuraDireccionesResponsable = new \App\Models\EstructuraDireccionResponsableModel();
        $this->estructuraAreas                  = new \App\Models\EstructuraAreaModel();
        $this->estructuraAreasResponsable       = new \App\Models\EstructuraAreaResponsableModel();
        $this->estructuraSubareas               = new \App\Models\EstructuraSubareaModel();
        $this->estructuraSubareasResponsable    = new \App\Models\EstructuraSubareaResponsableModel();
        $this->estructuraSubareaDelegaciones    = new \App\Models\EstructuraSubareaDelegacionesModel();
        $this->estructuraDelegaciones           = new \App\Models\EstructuraDelegacionModel();
        
        $this->regionPais           = new \App\Models\RegionPaisModel();
        $this->regionDepartamento   = new \App\Models\RegionDepartamentoModel();
        $this->regionProvincia      = new \App\Models\RegionProvinciaModel();
        $this->regionDistrito       = new \App\Models\RegionDistritoModel();
        
	}

    /**************************** FUNCIONES VARIAS ****************************/
    
    public function descargatxt($nombreTXT)
    {
        // Define el directorio igual que hiciste al crear el archivo
        //$directorio = base_url();
        $raiz = 'public/';
        // Valida el archivo recibido, eliminando caracteres no permitidos y diagonales para evitar retrocesos en ruta
        $file = (isset($nombreTXT)) ? str_replace('/', '', filter_var($nombreTXT, FILTER_SANITIZE_URL)) : '';
        
        // Separar para obtener extensión
        $partes = explode('.', $file);
        // No se especificó el archivo, no es .txt o no existe
        if($file == '' || end($partes) != 'txt' || !file_exists($raiz.$file)) {
            die('Archivo no encontrado');
        }

        header('Content-Description: File Transfer');
        header('Content-Disposition: attachment; filename='.$raiz.$file);
        header('Expires: 0');
        header('Cache-Control: must-revalidate');
        header('Pragma: public');
        header('Content-Length: ' . filesize($raiz.$file));
        header("Content-Type: text/plain");
        readfile($raiz.$file);
    }

	/**************************************************************************/
	
    /******************************** MÓDULOS *********************************/
    
	public function obtenerCabecera()
	{
    	/*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        $listadoCabeceras = $this->moduloCabecera->findAll();
        
        $cabeceras=array();

		if (!empty($listadoCabeceras)) {
            foreach ($listadoCabeceras as $items) {
                $cabeceras[] = array(
					'id' => (string) $items['IDCabecera'],
         	        'cabecera' => (string) $items['Cabecera'],
                );
            }

            $resultado = array(
				'listadoCabecera' => json_encode($cabeceras)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
	}

    public function listarModulos()
    {
        if(isset($this->items['id']))
        {
			/* BUSCAR USUARIOS */
			$listaModulos = $this->modulo->listarModulos();
            //$listaModulos = array();
            /* BUSCAR PERFILES */
            
			$data = array (
				'session'           => 'on',
				'titulo'            => 'Módulos | Verisure',
				'breadcrumb'        => $this->items['modulo'],
				'breadcrumb_alias'  => 'Listado de módulos',
				'listaModulos'      => $listaModulos
			);
			$data = array_merge($data, $this->items);
			return view('administracion/listar_modulos',$data);			
		} else {
			return view('errors/500');	
		}
    }

    public function registrarModulo()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $modulo = ucfirst(mb_strtolower($this->request->getPost('txtModulo_i')));
        $cabecera = $this->request->getPost('txtCabecera_i');
        $orden = $this->request->getPost('txtOrden_i');
        $icono = $this->request->getPost('txtIcono_i');
        $observacion = $this->request->getPost('txtObservacionModulo_i') ;
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($modulo, 'required|trim|alphaspecial|minlength[1]|maxlength[50]', 'Módulo');
        $error .= $this->complementos->validaCampo($cabecera, 'required|trim|numeric', 'Cabecera');
        $error .= $this->complementos->validaCampo($orden, 'required|trim|numeric', 'Orden');
        $error .= $this->complementos->validaCampo($icono, 'required|trim', 'Ícono');
        $error .= $this->complementos->validaCampo($observacion, 'required|trim', 'Observación');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
		$moduloExistente = $this->modulo->where('Modulo', $modulo)->findAll();
        
        if(count($moduloExistente)>0)
        {
            $msgExistencia .= "<li>El módulo ya fue registrado. [CAMPO] <small>MÓDULO</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }


        $data = array (
            'IDCabecera'    => $cabecera,
            'Modulo'        => $modulo,
            'Orden'         => $orden,
            'Icono'         => $icono,
            'Observacion'   => $observacion,
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress(),
            'Estado'        => 'A'
        );

        $lastId = $this->modulo->insert($data, TRUE);

		if($lastId !== FALSE){
		    /*$parametros = array("accion" => "ACTUALIZARPOSICIONESMODULOS", "idmodulo" => $lastId, "idcabecera" => $cabecera, "orden" => $orden);
		    $this->auditoria->spModulo($parametros);*/
			$message = sprintf($this->mensajeError->msg502, $modulo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

    public function modificarModulo($idModulo)
    {

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $modulo = ucfirst(mb_strtolower($this->request->getPost('txtModulo_i')));
        $cabecera = $this->request->getPost('txtCabecera_i');
        $orden = $this->request->getPost('txtOrden_i');
        $icono = $this->request->getPost('txtIcono_i');
        $observacion = $this->request->getPost('txtObservacionModulo_i');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($modulo, 'required|trim', 'Modulo');
        $error .= $this->complementos->validaCampo($cabecera, 'required|trim|numeric', 'Cabecera');
        $error .= $this->complementos->validaCampo($orden, 'required|trim|numeric', 'Orden');
        $error .= $this->complementos->validaCampo($icono, 'required|trim', 'Ícono');
        $error .= $this->complementos->validaCampo($observacion, 'required|trim', 'Observación');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'IDCabecera'        => $cabecera,
            'Modulo'            => $modulo,
            'Orden'             => $orden,
            'Icono'             => $icono,
            'Observacion'       => $observacion,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );
        $lastId = $this->modulo->update([$idModulo], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idModulo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function modificarEstadoModulo()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idModulo = $this->request->getPost('idModulo');
        $estado = $this->request->getPost('estado');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idModulo, 'required|trim|numeric', 'ID Módulo');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'Estado'            => $estado
        );
        $lastId = $this->modulo->update([$idModulo], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idModulo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
	public function obtenerDatosModulo()
	{
		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idModulo = $this->request->getPost('idModulo');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idModulo, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosModulo = $this->modulo->where('IDModulo', $idModulo)->first();

		if(!empty($datosModulo)){
			$resultado = array(
				'idmodulo' => (string) $idModulo,
				'cabecera' => (string) $datosModulo['IDCabecera'],
				'modulo' => (string) $datosModulo['Modulo'],
				'orden' => (string) $datosModulo['Orden'],
				'icono' => (string) $datosModulo['Icono'],
				'observacion' => (string) $datosModulo['Observacion']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);		
	}
    
    public function listarRutasModulo($idModulo)
    {
        if(isset($this->items['id'])){
			/* BUSCAR RUTAS */
			$listaRutas = $this->moduloRutas->where("IDModulo", $idModulo)->findAll();
            $modulo = $this->modulo->where('IDModulo', $idModulo)->first();

			$data = array (
				'session'           => 'on',
				'titulo'            => 'Rutas | Verisure',
				'breadcrumb'        => $this->items['modulo'],
				'breadcrumb_alias'  => 'Listado de rutas',
                'previo'            => 'listar-modulos',
				'listaRutas'        => $listaRutas,
                'moduloSeleccionado'=> $modulo,
                'idModulo'          => $idModulo
			);
			$data = array_merge($data, $this->items);
			return view('administracion/listar_rutas_modulos',$data);			
		} else {
			return view('errors/500');	
		}
    }

    public function guardarRutaModulo($idModulo)
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $ruta = $this->request->getPost('txtRutaModulo') ;
        $tipo = $this->request->getPost('txtTipoRuta_i') ;
        $raiz = $this->request->getPost('chkRutaRaiz') ;
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($ruta, 'required|trim', 'Ruta');
        $error .= $this->complementos->validaCampo($tipo, 'required|trim', 'Tipo de Ruta');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
		$rutaExistente = $this->moduloRutas->where('Ruta', $ruta)->findAll();
        
        if(count($rutaExistente)>0)
        {
            $msgExistencia .= "<li>La ruta ya fue registrada. [CAMPO] <small>RUTA</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }


        $data = array (
            'IDModulo'  => $idModulo, 
            'Ruta'      => $ruta,
            'TipoRuta'  => $tipo,
            'RaizModulo'=> (isset($raiz) ? 'Y' : 'N'),
            'Estado'    => 'A'
        );

        $lastId = $this->moduloRutas->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $ruta);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

	public function obtenerDatosRutaModulo() 
    {

		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idRutaModulo = $this->request->getPost('idRutaModulo');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idRutaModulo, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosRuta = $this->moduloRutas->where('IDRuta', $idRutaModulo)->first();

		if(!empty($datosRuta)){
			$resultado = array(
				'idruta' => (string) $idRutaModulo,
				'ruta' => (string) $datosRuta['Ruta'],
				'tipo' => (string) $datosRuta['TipoRuta'],
				'raiz' => (string) $datosRuta['RaizModulo']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);		
	}

    public function modificarRutaModulo($idRutaModulo)
    {

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $ruta = $this->request->getPost('txtRutaModulo');
        $tipo = $this->request->getPost('txtTipoRuta_i');
        $raiz = $this->request->getPost('chkRutaRaiz');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($ruta, 'required|trim', 'Ruta');
        $error .= $this->complementos->validaCampo($tipo, 'required|trim', 'Tipo de Ruta');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'Ruta'              => $ruta,
            'TipoRuta'          => $tipo,
            'RaizModulo'        => (isset($raiz) ? 'Y' : 'N')
        );
        $lastId = $this->moduloRutas->update([$idRutaModulo], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idRutaModulo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

    public function modificarEstadoRutaModulo()
    {

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idRutaModulo = $this->request->getPost('idRutaModulo');
        $estado = $this->request->getPost('estado');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idRutaModulo, 'required|trim|numeric', 'ID Ruta Módulo');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'Estado'            => $estado
        );
        $lastId = $this->moduloRutas->update([$idRutaModulo], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idRutaModulo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

    public function listarAccionesModulo($idModulo)
    {
        if(isset($this->items['id'])){
			/* BUSCAR ACCIONES */
			$listaAcciones = $this->moduloAcciones->where("IDModulo", $idModulo)->findAll();
            
			$data = array (
				'session'           => 'on',
				'titulo'            => 'Acciones | Verisure',
				'breadcrumb'        => $this->items['modulo'],
				'breadcrumb_alias'  => 'Listado de acciones',
                'previo'            => 'listar-modulos',
				'listaAcciones'     => $listaAcciones,
                'idModulo'          => $idModulo
			);
			$data = array_merge($data, $this->items);
			return view('administracion/listar_acciones_modulos',$data);			
		} else {
			return view('errors/500');	
		}
    }
    
    public function guardarAccionModulo($idModulo)
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $codigo = $this->request->getPost('txtCodigoAccionModulo') ;
        $accion = $this->request->getPost('txtAccionModulo') ;
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($accion, 'required|trim', 'Acción');
        $error .= $this->complementos->validaCampo($codigo, 'required|trim|minlength[6]|maxlength[6]', 'Código');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
		$accionExistente = $this->moduloAcciones->where('Accion', $accion)->findAll();
		$codigoExistente = $this->moduloAcciones->where('Codigo', $codigo)->findAll();
        
        if(count($accionExistente)>0)
        {
            $msgExistencia .= "<li>La acción ya fue registrada. [CAMPO] <small>ACCIÓN</small></li>";
        }

        if(count($codigoExistente)>0)
        {
            $msgExistencia .= "<li>El código ya fue registrada. [CAMPO] <small>CÓDIGO</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }


        $data = array (
            'IDModulo'  => $idModulo, 
            'Codigo'    => $codigo,
            'Accion'    => $accion,
            'Estado'    => 'A'
        );

        $lastId = $this->moduloAcciones->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $accion);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

	/**************************************************************************/
	
    /******************************** PERFILES ********************************/
    
	public function listarPerfiles()
	{
		if(isset($this->items['id'])){
			/* BUSCAR PERFILES */
			$wherePerfil = array(
				//'perfil.eliminacion_logica' => 1
			);

			$listaPerfiles = $this->perfilModelo
				->where($wherePerfil)
				->findAll();

			$data = array (
				'session'       => 'on',
				'titulo'        => 'Perfiles | Verisure',
				'breadcrumb'    => $this->items['modulo'],
				'listaPerfiles' => $listaPerfiles,
			);
			$data = array_merge($data, $this->items);
			return view('administracion/listar_perfiles',$data);			
		} else {
			return view('errors/500');
		}
	}

    public function listadoPerfilesSelect()
    {
        $elemento = $this->request->getPost('term');
        
        $listado = $this->perfilModelo->listadoPerfilesSelect($elemento['term']);

        $elementos=array();

        foreach ($listado as $items) {
            $elementos[] = array(
                'id' => (string) $items['IDPerfil'],
                'text' => (string) $items['Perfil']
            );
        }

        echo json_encode($elementos);
    }

    public function registrarPerfil()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $perfil = ucfirst(mb_strtolower($this->request->getPost('txtPerfil')));
        $url = $this->request->getPost('txtURLBasePerfil');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($perfil, 'required|trim|minlength[1]|maxlength[50]', 'Perfil');
        $error .= $this->complementos->validaCampo($url, 'required|trim|minlength[1]|maxlength[200]', 'URL');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
		$perfilExistente = $this->perfilModelo->where('Perfil', $perfil)->findAll();
        
        if(count($perfilExistente)>0)
        {
            $msgExistencia .= "<li>El perfil ya fue registrado. [CAMPO] <small>PERFIL</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }


        $data = array (
            'Perfil'        => $perfil,
            'URLBase'       => $url,
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress(),
            'Estado'        => 'A'
        );

        $lastId = $this->perfilModelo->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $perfil);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

	public function obtenerDatosPerfil()
	{
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idPerfil = $this->request->getPost('idPerfil');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idPerfil, 'required|trim|numeric', 'ID Perfil');
                
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
        $datosPerfil = $this->perfilModelo->where("IDPerfil", $idPerfil)->first();

        if(!empty($datosPerfil)){
			$resultado = array(
				'idperfil' => (string) $idPerfil,
				'perfil' => (string) $datosPerfil['Perfil'],
				'url' => (string) $datosPerfil['URLBase']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        
        echo json_encode($resultado, JSON_NUMERIC_CHECK);	
    }

	public function actualizarPerfil($idPerfil)
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $perfil = $this->request->getPost('txtPerfil');
        $url = $this->request->getPost('txtURLBasePerfil');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($perfil, 'required|trim|minlength[1]|maxlength[50]', 'Perfil');
        $error .= $this->complementos->validaCampo($url, 'required|trim|minlength[1]|maxlength[200]', 'URL');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'Perfil'            => $perfil,
            'URLBase'           => $url,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->perfilModelo->update([$idPerfil], $data);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg503, $perfil);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }		
	}

    public function modificarEstadoPerfil()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idPerfil = $this->request->getPost('idPerfil');
        $estado = $this->request->getPost('estado');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idPerfil, 'required|trim|numeric', 'ID Perfil');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'Estado'            => $estado
        );
        $lastId = $this->perfilModelo->update([$idPerfil], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idPerfil);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
	public function listarPermisosPerfil($idPerfil)
    {
		if(isset($this->items['id'])){
			/* BUSCAR PERMISOS*/
            
			$listaPermisos = $this->perfilPermisos->listarPermisosPerfil($idPerfil);
            $perfil = $this->perfilModelo->where("IDPerfil", $idPerfil)->first();
			$listaModulos = $this->modulo->findAll();

			$data = array (
				'session'           => 'on',
				'titulo'            => 'Permisos | Verisure',
				'breadcrumb'        => $this->items['modulo'],
				'breadcrumb_alias'  => 'Permisos de Perfil',
                'previo'            => 'listar-perfiles',
				'listaPermisos'     => $listaPermisos,
                'listaModulos'      => $listaModulos,
                'perfilSeleccionado'=> $perfil,
                'idPerfilSeleccionado'  => $idPerfil
			);
			$data = array_merge($data, $this->items);
			return view('administracion/listar_permisos_perfil',$data);			
		} else {
			return view('errors/500');
		}
	}

	public function listarRutasPerfil($idPerfil)
    {
		if(isset($this->items['id'])){
			/* BUSCAR PERMISOS*/
            
			$listaRutas = $this->perfilRutas->listarRutasPerfil($idPerfil);
            $perfil = $this->perfilModelo->where("IDPerfil", $idPerfil)->first();
			$listaModulos = $this->modulo->findAll();

			$data = array (
				'session'           => 'on',
				'titulo'            => 'Rutas | Verisure',
				'breadcrumb'        => $this->items['modulo'],
				'breadcrumb_alias'  => 'Rutas de Perfil',
                'previo'            => 'listar-perfiles',
				'listaRutas'        => $listaRutas,
                'listaModulos'      => $listaModulos,
                'perfilSeleccionado'=> $perfil,
                'idPerfilSeleccionado'  => $idPerfil
			);
			$data = array_merge($data, $this->items);
			return view('administracion/listar_rutas_perfil',$data);			
		} else {
			return view('errors/500');
		}
	}
	
    public function guardarPermisosPerfil($idPerfil)
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $permisos = $this->request->getPost('permisos') ;
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';

        if(isset($permisos) && empty($permisos))
        {
            $error .= "<li>No hay permisos seleccionados.</li>";
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * OBTENER PERMISOS EXISTENTES Y EVALUAR NUEVOS PERMISOS Y PERMISOS RETIRADOS
        * ----------------------------
        */
        
        $listadoPermisosPrev = $this->perfilPermisos->where("IDPerfil", $idPerfil)->findAll();
        $arrayPermisosExistentes = array_column($listadoPermisosPrev, "IDAccionModulo");
        
        $arrayNuevosPermisos = array_keys($permisos);
        
        $agregarPermisos = array_diff($arrayNuevosPermisos, $arrayPermisosExistentes);
        $quitarPermisos = array_diff($arrayPermisosExistentes, $arrayNuevosPermisos);
        
        /*
        * ----------------------------
        * LIMPIAR EXISTENCIA PREVIA
        * ----------------------------
        */

        if(count($listadoPermisosPrev) > 0)
        {
            $this->perfilPermisos->delete($idPerfil);
        }

        /*
        * ----------------------------
        * GENERAR NUEVA DATA
        * ----------------------------
        */

        $dataPermisos = array();

        foreach($permisos as $key => $value)
        {
            $dataPermisos[] = array (
                'IDPerfil'          => $idPerfil, 
                'IDAccionModulo'    => $key,
                'UsuarioRegistra'   => $this->items['id'],
                'FechaRegistra'     => $fechaActual
            );
        }
        $lastId = $this->perfilPermisos->insertBatch($dataPermisos, TRUE);

		if($lastId !== FALSE){
		    $usuariosPerfil = $this->usuarioPerfil->where("IDPerfil", $idPerfil)->findAll();
		    $listadoUsuariosPerfil = array_column($usuariosPerfil, "IdUsuario");;
		    
		    if(!empty($listadoUsuariosPerfil))
		    {
    		    //ELIMINAR PERMISOS DESACTIVADOS
    		    
    		    if(!empty($quitarPermisos))
    		    {
    		        $this->usuarioPermisos->whereIn('IdUsuario', $listadoUsuariosPerfil)->whereIn('IDAccionModulo', $quitarPermisos)->delete();
    		    }
    		    
    		    //INSERTAR PERMISOS ACTIVADOS NUEVOS
    		    
    		    if(!empty($agregarPermisos))
    		    {
    		        $dataPermisosNuevos = array();
    		    
    		        foreach($listadoUsuariosPerfil as $usuarios)
    		        {
    		            foreach($agregarPermisos as $new)
        		        {
        		            $wherePermisos = array(
        		                "IdUsuario"         => $usuarios,
        		                "IDAccionModulo"    => $new
        		            );
        		            
        		            $existe = $this->usuarioPermisos->where($wherePermisos)->countAllResults();
        		            
        		            if($existe == 0)
        		            {
        		                $dataPermisosNuevos[] = array (
                                    'IdUsuario'         => $usuarios, 
                                    'IDAccionModulo'    => $new,
                                    'UsuarioRegistra'   => $this->items['id'],
                                    'FechaRegistra'     => $fechaActual
                                );
        		            }
        		        }
    		        }
    		        
    		        $this->usuarioPermisos->insertBatch($dataPermisosNuevos, TRUE);
    		    }
		    }
		    
			$message = sprintf($this->mensajeError->msg502, $idPerfil);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function guardarRutasPerfil($idPerfil)
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $rutas = $this->request->getPost('rutas') ;
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';

        if(isset($rutas) && empty($rutas))
        {
            $error .= "<li>No hay rutas seleccionados.</li>";
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * OBTENER RUTAS EXISTENTES Y EVALUAR NUEVAS RUTAS Y RUTAS RETIRADAS
        * ----------------------------
        */
        
        $listadoRutasPrev = $this->perfilRutas->where("IDPerfil", $idPerfil)->findAll();
        $arrayRutasExistentes = array_column($listadoRutasPrev, "IDRuta");
        
        $arrayNuevasRutas = array_keys($rutas);
        
        $agregarRutas = array_diff($arrayNuevasRutas, $arrayRutasExistentes);
        $quitarRutas = array_diff($arrayRutasExistentes, $arrayNuevasRutas);
        
        /*
        * ----------------------------
        * LIMPIAR EXISTENCIA PREVIA
        * ----------------------------
        */

        if(count($listadoRutasPrev) > 0)
        {
            $this->perfilRutas->delete($idPerfil);
        }

        /*
        * ----------------------------
        * GENERAR NUEVA DATA
        * ----------------------------
        */

        $dataRutas = array();

        foreach($rutas as $key => $value)
        {
            $dataRutas[] = array (
                'IDPerfil'          => $idPerfil, 
                'IDRuta'            => $key,
                'UsuarioRegistra'   => $this->items['id'],
                'FechaRegistra'     => $fechaActual
            );
        }
        $lastId = $this->perfilRutas->insertBatch($dataRutas, TRUE);

		if($lastId !== FALSE){
		    $usuariosPerfil = $this->usuarioPerfil->where("IDPerfil", $idPerfil)->findAll();
		    $listadoUsuariosPerfil = array_column($usuariosPerfil, "IdUsuario");;
		    
		    if(!empty($listadoUsuariosPerfil))
		    {
    		    //ELIMINAR RUTAS DESACTIVADOS
    		    
    		    if(!empty($quitarRutas))
    		    {
    		        $this->usuarioRutas->whereIn('IdUsuario', $listadoUsuariosPerfil)->whereIn('IDRuta', $quitarRutas)->delete();
    		    }
    		    
    		    //INSERTAR PERMISOS ACTIVADOS NUEVOS
    		    
    		    if(!empty($agregarRutas))
    		    {
    		        $dataRutasNuevas = array();
    		    
    		        foreach($listadoUsuariosPerfil as $usuarios)
    		        {
    		            foreach($agregarRutas as $new)
        		        {
        		            $whereRutas = array(
        		                "IdUsuario" => $usuarios,
        		                "IDRuta"    => $new
        		            );
        		            
        		            $existe = $this->usuarioRutas->where($whereRutas)->countAllResults();
        		            
        		            if($existe == 0)
        		            {
        		                $dataRutasNuevas[] = array (
                                    'IdUsuario'         => $usuarios, 
                                    'IDRuta'            => $new,
                                    'UsuarioRegistra'   => $this->items['id'],
                                    'FechaRegistra'     => $fechaActual
                                );
        		            }
        		        }
    		        }
    		        
    		        $this->usuarioRutas->insertBatch($dataRutasNuevas, TRUE);
    		    }
		    }
		    
			$message = sprintf($this->mensajeError->msg502, $idPerfil);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function listadoPerfiles()
    {
        if (isset($this->items['id'])) 
    	{
            $listado = $this->perfilModelo->where("Estado", "A")->findAll();
            
            $elementos=array();
    
    		if (!empty($listado)) 
    		{
                foreach ($listado as $items) 
                {
                    $elementos[] = array(
    					'id'    => (string) $items['IDPerfil'],
                        'text'  => (string) $items['Perfil']
                    );
                }
    
                $resultado = array(
    				'listadoPerfiles' => json_encode($elementos)
    			);
            } 
            else 
            {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
    
            /*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
            echo json_encode($resultado, JSON_NUMERIC_CHECK);
    	}
    	else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
    }

	/**************************************************************************/
	
    /******************************** SISTEMAS ********************************/
    
    public function listarSistemas()
    {
		if(isset($this->items['id']))
		{
			/* ACCIONES */
			$listadoSistemas = $this->sistemas->findAll();
			
			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Sistemas | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Sistemas',
				'elementoSeleccionadoModulo'=> "Listado de Sistemas",
				'subtitulo'                 => 'Sistemas',
				'listadoSistemas'           => $listadoSistemas
			);
			
			$data = array_merge($data, $this->items);
			
			return view('administracion/listar_sistemas',$data);			
		} 
		else 
		{
			return view('errors/500');
		}
	}
	
	public function registrarSistema()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $sistema        = $this->request->getPost('txtSistema_i') ;
        $dominio        = $this->request->getPost('txtDominioSistema_i');
        $subdominio     = $this->request->getPost('txtSubdominioSistema_i');
        $subcarpeta     = $this->request->getPost('txtSubcarpetaSistema_i');
        $externo        = $this->request->getPost('chkURLExterno');
        $observacion = $this->request->getPost('txtObservacion_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($sistema, 'required|trim|minlength[1]|maxlength[50]', 'Nombre Sistema');
        $error .= $this->complementos->validaCampo($dominio, 'required|trim|minlength[1]|maxlength[70]', 'Dominio');
        $error .= $this->complementos->validaCampo($subdominio, 'trim|minlength[1]|maxlength[50]', 'Subdominio');
        $error .= $this->complementos->validaCampo($subcarpeta, 'trim|minlength[1]|maxlength[200]', 'Subcarpeta');
        $error .= $this->complementos->validaCampo($observacion, 'trim', 'Observación');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
		$sistemaExistente = $this->sistemas->where('Sistema', $sistema)->findAll();
        
        if(count($sistemaExistente)>0)
        {
            $msgExistencia .= "<li>El sistema ya fue registrado. [CAMPO] <small>SISTEMA</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }


        $data = array (
            'Sistema'       => $sistema,
            'Externo'       => !empty($externo) ? "Y" : "N",
            'Subdominio'    => $subdominio,
            'Dominio'       => $dominio,
            'Subcarpeta'    => $subcarpeta,
            'Observacion'   => $observacion,
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress(),
            'UsuarioEstado' => $this->items['id'],
            'FechaEstado'   => $fechaActual,    
            'MotivoEstado'  => "Creación de sistema.",    
            'Estado'        => 'A'
        );

        $lastId = $this->sistemas->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $sistema);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
	
	public function obtenerDatosSistema()
	{
	    if (isset($this->items['id'])) 
    	{
    		/*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
    		*/
    
    		$msjError = TRUE;
    		$idSistema = $this->request->getPost('idSistema');
    
    		/*
            * ----------------------------
            * VALIDACIÓN DE REQUERIMIENTOS
            * ----------------------------
            */
    
    		$error = '';
    		$error .= $this->complementos->validaCampo($idSistema, 'trim', 'ID');
    
    		if ($error != '') {
    			$message = sprintf($this->mensajeError->msg201, $error);
    			echo $this->alertas->alertaError($message);
    			exit;
    		}
    
    		/*
            * -------------
            * BASE DE DATOS
            * -------------
            */
    		
    		$datosSistema = $this->sistemas->where('IDSistema', $idSistema)->first();
    
    		if(!empty($datosSistema)){
    			$resultado = array(
    				'idsistema'     => (string) $idSistema,
    				'sistema'       => (string) $datosSistema['Sistema'],
    				'externo'       => (string) $datosSistema['Externo'],
    				'subdominio'    => (string) $datosSistema['Subdominio'],
    				'dominio'       => (string) $datosSistema['Dominio'],
    				'subcarpeta'    => (string) $datosSistema['Subcarpeta'],
    				'observacion'   => (string) $datosSistema['Observacion']
    			);
    		} else {
    			$resultado = array(
    				'descripcion' => 0
    			);
    		}
    
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado);
    	}
    	else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}
	
	public function actualizarSistema($idSistema)
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $sistema = $this->request->getPost('txtSistema_i') ;
        $dominio        = $this->request->getPost('txtDominioSistema_i');
        $subdominio     = $this->request->getPost('txtSubdominioSistema_i');
        $subcarpeta     = $this->request->getPost('txtSubcarpetaSistema_i');
        $externo        = $this->request->getPost('chkURLExterno');
        $observacion = $this->request->getPost('txtObservacion_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($sistema, 'required|trim|minlength[1]|maxlength[50]', 'Nombre Sistema');
        $error .= $this->complementos->validaCampo($dominio, 'required|trim|minlength[1]|maxlength[70]', 'Dominio');
        $error .= $this->complementos->validaCampo($subdominio, 'trim|minlength[1]|maxlength[50]', 'Subdominio');
        $error .= $this->complementos->validaCampo($subcarpeta, 'trim|minlength[1]|maxlength[200]', 'Subcarpeta');
        $error .= $this->complementos->validaCampo($observacion, 'trim', 'Observación');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'Sistema'           => $sistema,
            'Externo'           => !empty($externo) ? "Y" : "N",
            'Subdominio'        => $subdominio,
            'Dominio'           => $dominio,
            'Subcarpeta'        => $subcarpeta,
            'Observacion'       => $observacion,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->sistemas->update([$idSistema], $data);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg503, $sistema);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }		
	}
	
    public function modificarEstadoSistema()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idSistema = $this->request->getPost('idSistema');
        $estado = $this->request->getPost('estado');
        $motivo = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idSistema, 'required|trim|numeric', 'ID Sistema');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,
            'MotivoEstado'      => $motivo,
            'Estado'            => $estado
        );
        
        $lastId = $this->sistemas->update([$idSistema], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idSistema);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
	/**************************************************************************/
	
    /********************************* CARGOS *********************************/
    
    public function listarCargos()
    {
        if(isset($this->items['id']))
        {
			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Listado de Cargos | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Cargos',
				'elementoSeleccionadoModulo'=> "Listado de Cargos",
				'subtitulo'                 => 'Cargos'
			);
			
			$data = array_merge($data, $this->items);
			
			return view('administracion/listar_cargos',$data);			
		} 
		else 
		{
			return view('errors/500');
		}
    }
    
    public function cargosServerside()
    {
        if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"  => $this->items['idPerfil'],
                "IDUsuario" => $this->items['id']
            );
            
            /* LISTAR CARGOS */
            $dataServerside = $this->cargos->listaGeneralCargos($this->request->getPost(), $adicionales);
            
            foreach($dataServerside["data"] as $key=>$value)
            {
    			if(in_array("ESTCAR", $this->items['permisos']))
    			{
        			$dataServerside["data"][$key]['EstadoCargo'] = '<button class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0 cambiar-estado-cargo" data-estado="'.$value['Estado'].'" data-id="'.$value['IDCargo'].'">'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</button>';
    			}
    			else
    			{
    			    $dataServerside["data"][$key]['EstadoCargo'] = '<span class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0" >'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</span>';
    			}
    			
                $acciones = '';
                
                $acciones .= '<button class="badge bg-info border-0 p-2 mx-1 datos-cargo" data-bs-target="#informacionCargo" data-form="#formInformacionCargo" data-id="'.$value['IDCargo'].'" data-accion="ver" id="ver-cargo" data-tooltip="tooltip" title="Ver Cargo">
    				<i class="mdi mdi-eye align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
    			if(in_array("UPDCAR", $this->items['permisos']))
    			{
    			$acciones .= '<button class="badge bg-warning border-0 p-2 mx-1 datos-cargo" data-bs-target="#informacionCargo" data-form="#formInformacionCargo" data-id="'.$value['IDCargo'].'" data-accion="editar" id="editar-cargo" data-tooltip="tooltip" title="Editar Cargo">
    				<i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			}
    			
                $dataServerside["data"][$key]['acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    	else
    	{
    	    $datos = [
                'draw'              => 1,
                'data'              => array(),
                'recordsTotal'      => 0,
                'recordsFiltered'   => (int) 0
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    }
    
	public function registrarCargo()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $cargo = $this->request->getPost('txtCargo_i') ;
        $categoria = $this->request->getPost('txtCategoria_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($cargo, 'required|trim|minlength[1]|maxlength[100]', 'Cargo');
        // $error .= $this->complementos->validaCampo($categoria, 'required|trim|minlength[1]|maxlength[4]', 'Categoría');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
		$cargoExistente = $this->cargos->where('Cargo', $cargo)->findAll();
        
        if(count($cargoExistente)>0)
        {
            $msgExistencia .= "<li>El cargo ya fue registrado. [CAMPO] <small>CARGO</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }


        $data = array (
            'Cargo'         => $cargo,
            'Categoria'     => $categoria,
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress(),
            'UsuarioEstado' => $this->items['id'],
            'FechaEstado'   => $fechaActual,    
            'MotivoEstado'  => "Creación de cargo.",    
            'Estado'        => 'A'
        );

        $lastId = $this->cargos->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $cargo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
	
	public function obtenerDatosCargo()
	{
	    if (isset($this->items['id'])) 
    	{
    		/*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
    		*/
    
    		$msjError = TRUE;
    		$idCargo = $this->request->getPost('idCargo');
    
    		/*
            * ----------------------------
            * VALIDACIÓN DE REQUERIMIENTOS
            * ----------------------------
            */
    
    		$error = '';
    		$error .= $this->complementos->validaCampo($idCargo, 'trim', 'ID');
    
    		if ($error != '') {
    			$message = sprintf($this->mensajeError->msg201, $error);
    			echo $this->alertas->alertaError($message);
    			exit;
    		}
    
    		/*
            * -------------
            * BASE DE DATOS
            * -------------
            */
    		
    		$datosCargo = $this->cargos->where('IDCargo', $idCargo)->first();
    
    		if(!empty($datosCargo)){
    			$resultado = array(
    				'idcargo'   => (string) $idCargo,
    				'cargo'     => (string) $datosCargo['Cargo'],
    				'categoria' => (string) $datosCargo['Categoria']
    			);
    		} else {
    			$resultado = array(
    				'descripcion' => 0
    			);
    		}
    
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado);
    	}
    	else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}
	
	public function actualizarCargo($idCargo)
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $cargo = $this->request->getPost('txtCargo_i') ;
        $categoria = $this->request->getPost('txtCategoria_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($cargo, 'required|trim|minlength[1]|maxlength[100]', 'Cargo');
        $error .= $this->complementos->validaCampo($categoria, 'required|trim|minlength[1]|maxlength[4]', 'Categoría');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'Cargo'             => $cargo,
            'Categoria'         => $categoria,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->cargos->update([$idCargo], $data);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg503, $cargo);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }		
	}
	
    public function modificarEstadoCargo()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idCargo = $this->request->getPost('idCargo');
        $estado = $this->request->getPost('estado');
        $motivo = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idCargo, 'required|trim|numeric', 'ID Cargo');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,
            'MotivoEstado'      => $motivo,
            'Estado'            => $estado
        );
        
        $lastId = $this->cargos->update([$idCargo], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idCargo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function listadoCargos()
    {
        if (isset($this->items['id'])) 
    	{
            $listado = $this->cargos->findAll();
            
            $elementos=array();
    
    		if (!empty($listado)) {
                foreach ($listado as $items) {
                    $elementos[] = array(
    					'id' => (string) $items['IDCargo'],
                        'text' => (string) $items['Cargo']
                    );
                }
    
                $resultado = array(
    				'listadoCargos' => json_encode($elementos)
    			);
            } else {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
    
            /*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
            echo json_encode($resultado, JSON_NUMERIC_CHECK);
    	}
    	else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
    }

	/**************************************************************************/
	
    /****************************** DELEGACIONES ******************************/
    
    public function listarDelegacionessEstructura()
    {
        if(isset($this->items['id']))
        {
			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Delegaciones | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Delegaciones',
				'elementoSeleccionadoModulo'=> "Listado de Delegaciones",
				'subtitulo'                 => 'Delegaciones'
			);
			
			$data = array_merge($data, $this->items);
			
			return view('administracion/listar_estructura_delegaciones',$data);			
		} 
		else 
		{
			return view('errors/500');
		}
    }
    
    public function delegacionEstructuraServerside()
    {
        if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"  => $this->items['idPerfil'],
                "IDUsuario" => $this->items['id']
            );
            
            /* LISTAR DELEGACIONES */
            $dataServerside = $this->estructuraDelegaciones->listaGeneralDelegaciones($this->request->getPost(), $adicionales);
            
            foreach($dataServerside["data"] as $key=>$value)
            {
    			if(in_array("ESTDEL", $this->items['permisos']))
    			{
        			$dataServerside["data"][$key]['EstadoDelegacion'] = '<button class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0 cambiar-estado-delegacion-estructura" data-estado="'.$value['Estado'].'" data-id="'.$value['IDDelegacion'].'">'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</button>';
    			}
    			else
    			{
    			    $dataServerside["data"][$key]['EstadoDelegacion'] = '<span class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0" >'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</span>';
    			}
    			
                $acciones = '';
                
                $acciones .= '<button class="badge bg-info border-0 p-2 mx-1 datos-delegacion-estructura" data-bs-target="#informacionDelegacionEstructura" data-form="#formInformacionDelegacionEstructura" data-id="'.$value['IDDelegacion'].'" data-accion="ver" id="ver-delegacion" data-tooltip="tooltip" title="Ver Delegación">
    				<i class="mdi mdi-eye align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
    			if(in_array("UPDDEL", $this->items['permisos']))
    			{
    			$acciones .= '<button class="badge bg-warning border-0 p-2 mx-1 datos-delegacion-estructura" data-bs-target="#informacionDelegacionEstructura" data-form="#formInformacionDelegacionEstructura" data-id="'.$value['IDDelegacion'].'" data-accion="editar" id="editar-delegacion" data-tooltip="tooltip" title="Editar Delegación">
    				<i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			}
    			
                $dataServerside["data"][$key]['acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    	else
    	{
    	    $datos = [
                'draw'              => 1,
                'data'              => array(),
                'recordsTotal'      => 0,
                'recordsFiltered'   => (int) 0
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    }
    
	public function registrarDelegacionEstructura()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $delegacion = ucwords(mb_strtolower($this->request->getPost('txtDelegacionEstructura_i'))) ;
        $cc = $this->request->getPost('txtCCDelegacionEstructura_i');
        $ln = $this->request->getPost('txtLNDelegacionEstructura_i');
        $observacion = $this->request->getPost('txtObservacionDelegacionEstructura_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($delegacion, 'required|trim|minlength[1]|maxlength[100]', 'Delegación');
        $error .= $this->complementos->validaCampo($cc, 'required|trim|numeric', 'CC');
        $error .= $this->complementos->validaCampo($ln, 'required|trim|numeric', 'LN');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $whereDelegaciones = array(
            'CC'        => $cc,
            'LN'        => $ln
        );
        
		$combinacionExistente = $this->estructuraDelegaciones->where($whereDelegaciones)->findAll();
		
        if(count($combinacionExistente)>0)
        {
            $msgExistencia .= "<li>La combinación de CC y LN ya fue agregada. [CAMPO] <small>CC-LN</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }


        $data = array (
            'Delegacion'    => $delegacion,
            'CC'            => $cc,
            'LN'            => $ln,
            'Observacion'   => $observacion,
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress(),
            'UsuarioEstado' => $this->items['id'],
            'FechaEstado'   => $fechaActual,    
            'MotivoEstado'  => "Creación de delegación.",    
            'Estado'        => 'A'
        );

        $lastId = $this->estructuraDelegaciones->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $delegacion);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
	
	public function obtenerDatosDelegacionEstructura()
	{
	    if (isset($this->items['id'])) 
    	{
    		/*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
    		*/
    
    		$msjError = TRUE;
    		$idDelegacion = $this->request->getPost('idDelegacion');
    
    		/*
            * ----------------------------
            * VALIDACIÓN DE REQUERIMIENTOS
            * ----------------------------
            */
    
    		$error = '';
    		$error .= $this->complementos->validaCampo($idDelegacion, 'trim', 'ID');
    
    		if ($error != '') {
    			$message = sprintf($this->mensajeError->msg201, $error);
    			echo $this->alertas->alertaError($message);
    			exit;
    		}
    
    		/*
            * -------------
            * BASE DE DATOS
            * -------------
            */
    		
    		$datosDelegacion = $this->estructuraDelegaciones->where('IDDelegacion', $idDelegacion)->first();
    
    		if(!empty($datosDelegacion))
    		{
    			$resultado = array(
    				'iddelegacion'  => (string) $idDelegacion,
    				'delegacion'    => (string) $datosDelegacion['Delegacion'],
    				'cc'            => (string) $datosDelegacion['CC'],
    				'ln'            => (string) $datosDelegacion['LN'],
    				'observacion'   => (string) $datosDelegacion['Observacion']
    			);
    		} 
    		else 
    		{
    			$resultado = array(
    				'descripcion' => 0
    			);
    		}
    
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado);
    	}
    	else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}
	
	public function modificarDelegacionEstructura($idDelegacion)
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $delegacion = ucwords(mb_strtolower($this->request->getPost('txtDelegacionEstructura_i'))) ;
        $cc = $this->request->getPost('txtCCDelegacionEstructura_i');
        $ln = $this->request->getPost('txtLNDelegacionEstructura_i');
        $observacion = $this->request->getPost('txtObservacionDelegacionEstructura_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($delegacion, 'required|trim|minlength[1]|maxlength[100]', 'Delegación');
        $error .= $this->complementos->validaCampo($cc, 'required|trim|numeric', 'CC');
        $error .= $this->complementos->validaCampo($ln, 'required|trim|numeric', 'LN');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'Delegacion'        => $delegacion,
            'CC'                => $cc,
            'LN'                => $ln,
            'Observacion'       => $observacion,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->estructuraDelegaciones->update([$idDelegacion], $data);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg503, $delegacion);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }		
	}
	
    public function modificarEstadoDelegacionEstructura()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idDelegacion = $this->request->getPost('idDelegacion');
        $estado = $this->request->getPost('estado');
        $motivo = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idDelegacion, 'required|trim|numeric', 'ID Delegación');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,
            'MotivoEstado'      => $motivo,
            'Estado'            => $estado
        );
        
        $lastId = $this->estructuraDelegaciones->update([$idDelegacion], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idDelegacion);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
	public function listadoDelegacionesEstructura()
	{
	    if (isset($this->items['id'])) 
    	{
        	/*
            * ----------------------
            * OBTIENE Y VALIDA DATOS
            * ----------------------
            */
            $listadoDelegaciones = $this->estructuraDelegaciones->findAll();
            
            $delegaciones=array();
    
    		if (!empty($listadoDelegaciones)) {
                foreach ($listadoDelegaciones as $items) {
                    $delegaciones[] = array(
    					'id' => (string) $items['IDDelegacion'],
             	        'text' => (string) $items['Delegacion'].' | '.$items['CC'].' | '.$items['LN'],
                    );
                }
    
                $resultado = array(
    				'listadoDelegaciones' => json_encode($delegaciones)
    			);
            } else {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
    
            /*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
            echo json_encode($resultado, JSON_NUMERIC_CHECK);
	    }
	    else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}
	
	public function busquedaDelegacionesEstructura()
	{
	    if (isset($this->items['id'])) 
    	{
    	    $elemento = $this->request->getPost('term');
    	    
    	    $array = array("variable" => $elemento['term']);
            
            $listado = $this->estructuraDelegaciones->listadoDelegacionesBusqueda($array);
            
            $elementos=array();
    
            foreach ($listado as $items) {
                $elementos[] = array(
                    'id' => (string) $items['IDDelegacion'],
                    'text' => (string) $items['CC'].'-'.$items['LN'].'|'.$items['Delegacion']
                );
            }
    
            echo json_encode($elementos);
    	}
    	else 
    	{
            $elementos=array();
            
            $elementos[] = array(
                'id' => (string) "",
                'text' => (string) "Inicie sesión nuevamente"
            );
			
			echo json_encode($elementos);
        }
	}

	/**************************************************************************/
	
    /******************************* DIRECCIONES ******************************/
        
    public function listarDirecciones()
    {
        if(isset($this->items['id']))
        {
			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Direcciones | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Direcciones',
				'elementoSeleccionadoModulo'=> "Listado de Direcciones",
				'subtitulo'                 => 'Direcciones'
			);
			
			$data = array_merge($data, $this->items);
			
			return view('administracion/listar_direcciones',$data);			
		} 
		else 
		{
			return view('errors/500');
		}
    }
    
    public function direccionServerside()
    {
        if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"  => $this->items['idPerfil'],
                "IDUsuario" => $this->items['id']
            );
            
            /* LISTAR DIRECCIONES */
            $dataServerside = $this->direccion->listaGeneralDireccion($this->request->getPost(), $adicionales);
            
            foreach($dataServerside["data"] as $key=>$value)
            {
    			if(in_array("ESTDIR", $this->items['permisos']))
    			{
        			$dataServerside["data"][$key]['EstadoDireccion'] = '<button class="badge '.($value['eliminacion_logica'] == "1" ? 'bg-success' : 'bg-danger').' border-0 cambiar-estado-direccion" data-estado="'.$value['eliminacion_logica'].'" data-id="'.$value['id_direccion'].'">'.($value['eliminacion_logica'] == "1" ? 'ACTIVO' : 'INACTIVO').'</button>';
    			}
    			else
    			{
    			    $dataServerside["data"][$key]['EstadoDireccion'] = '<span class="badge '.($value['eliminacion_logica'] == "1" ? 'bg-success' : 'bg-danger').' border-0" >'.($value['eliminacion_logica'] == "1" ? 'ACTIVO' : 'INACTIVO').'</span>';
    			}
    			
    			$dataServerside["data"][$key]['Distrito'] = ucwords(mb_strtolower($value['Departamento'].' - '.$value['Provincia'].' - '.$value['Distrito']));
    			
                $acciones = '';
                
                $acciones .= '<button class="badge bg-info border-0 p-2 mx-1 datos-direccion" data-bs-target="#informacionDireccion" data-form="#formInformacionDireccion" data-id="'.$value['id_direccion'].'" data-accion="ver" id="ver-direccion" data-tooltip="tooltip" title="Ver Dirección">
    				<i class="mdi mdi-eye align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
    			if(in_array("UPDDIR", $this->items['permisos']))
    			{
    			$acciones .= '<button class="badge bg-warning border-0 p-2 mx-1 datos-direccion" data-bs-target="#informacionDireccion" data-form="#formInformacionDireccion" data-id="'.$value['id_direccion'].'" data-accion="editar" id="editar-direccion" data-tooltip="tooltip" title="Editar Dirección">
    				<i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			}
    			
    			if(in_array("UPDDIR", $this->items['permisos']))
    			{
    			$acciones .= '<a href="'.$this->items['baseUrl'].'/listar-ubicaciones-acceso/'.$value['id_direccion'].'" class="badge bg-sistema border-0 p-2 mx-1" data-tooltip="tooltip" title="Ver Ubicaciones de Acceso">
    				<i class="mdi mdi-access-point align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</a>';
    			}
    			
                $dataServerside["data"][$key]['acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    	else
    	{
    	    $datos = [
                'draw'              => 1,
                'data'              => array(),
                'recordsTotal'      => 0,
                'recordsFiltered'   => (int) 0
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    }
    
	public function registrarDireccion()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $nombre = ucfirst(mb_strtolower($this->request->getPost('txtNombreDireccion_i')));
        $direccion = $this->request->getPost('txtDireccion_i') ;
        $sunat = $this->request->getPost('txtCodigoSunat_i');
        $distrito = $this->request->getPost('txtDistritoDireccion_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($nombre, 'required|trim|minlength[1]|maxlength[200]', 'Nombre');
        $error .= $this->complementos->validaCampo($direccion, 'required|trim|minlength[1]|maxlength[255]', 'Dirección');
        // $error .= $this->complementos->validaCampo($sunat, 'required|trim|numeric', 'Código Sunat');
        $error .= $this->complementos->validaCampo($distrito, 'required|trim|numeric', 'Distrito');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
		$direccionExistente = $this->direccion->where('Direccion', $direccion)->findAll();
        
        if(count($direccionExistente)>0)
        {
            $msgExistencia .= "<li>La dirección ya fue registrada. [CAMPO] <small>DIRECCIÓN</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }


        $data = array (
            'Nombre'                => $nombre,
            'Direccion'             => $direccion,
            'id_distrito'           => $distrito,
            'fechahorareg'          => $fechaActual,
            'fija'                  => 1,
            'eliminacion_logica'    => 1,    
            'codigoSunat'           => $sunat
        );

        $lastId = $this->direccion->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $direccion);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
	
	public function obtenerDatosDireccion()
	{
	    if (isset($this->items['id'])) 
    	{
    		/*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
    		*/
    
    		$msjError = TRUE;
    		$idDireccion = $this->request->getPost('idDireccion');
    
    		/*
            * ----------------------------
            * VALIDACIÓN DE REQUERIMIENTOS
            * ----------------------------
            */
    
    		$error = '';
    		$error .= $this->complementos->validaCampo($idDireccion, 'trim', 'ID');
    
    		if ($error != '') {
    			$message = sprintf($this->mensajeError->msg201, $error);
    			echo $this->alertas->alertaError($message);
    			exit;
    		}
    
    		/*
            * -------------
            * BASE DE DATOS
            * -------------
            */
    		
    		$datosDireccion = $this->direccion->obtenerDireccion($idDireccion);
    
    		if(!empty($datosDireccion))
    		{
    			$resultado = array(
    				'iddireccion'   => (string) $idDireccion,
    				'nombre'        => (string) $datosDireccion['Nombre'],
    				'direccion'     => (string) $datosDireccion['Direccion'],
    				'sunat'         => (string) $datosDireccion['codigoSunat'],
    				'iddpto'        => (string) $datosDireccion['IDDepartamento'],
    				'idprovincia'   => (string) $datosDireccion['IDProvincia'],
    				'iddistrito'    => (string) $datosDireccion['id_distrito']
    			);
    		} 
    		else 
    		{
    			$resultado = array(
    				'descripcion' => 0
    			);
    		}
    
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado);
    	}
    	else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}
	
	public function actualizarDireccion($idDireccion)
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $nombre = ucfirst(mb_strtolower($this->request->getPost('txtNombreDireccion_i')));
        $direccion = $this->request->getPost('txtDireccion_i') ;
        $sunat = $this->request->getPost('txtCodigoSunat_i');
        $distrito = $this->request->getPost('txtDistritoDireccion_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($nombre, 'required|trim|minlength[1]|maxlength[200]', 'Nombre');
        $error .= $this->complementos->validaCampo($direccion, 'required|trim|minlength[1]|maxlength[255]', 'Dirección');
        $error .= $this->complementos->validaCampo($sunat, 'required|trim|numeric', 'Código Sunat');
        $error .= $this->complementos->validaCampo($distrito, 'required|trim|numeric', 'Distrito');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'Nombre'                => $nombre,
            'Direccion'             => $direccion,
            'id_distrito'           => $distrito,
            'fechahorareg'          => $fechaActual, 
            'codigoSunat'           => $sunat
        );

        $lastId = $this->direccion->update([$idDireccion], $data);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg503, $direccion);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }		
	}
	
    public function modificarEstadoDireccion()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idDireccion = $this->request->getPost('idDireccion');
        $estado = $this->request->getPost('estado');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idDireccion, 'required|trim|numeric', 'ID Direccion');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|numeric|minlength[1]|maxlength[1]', 'Estado');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'eliminacion_logica'    => $estado
        );
        
        $lastId = $this->direccion->update([$idDireccion], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idDireccion);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function listarUbicacionesAcceso($idDireccion)
    {
        if(isset($this->items['id']))
        {
			$listaUbicaciones = $this->ubicacionAcceso->where("IDDireccion", $idDireccion)->findAll();
			$direccion = $this->direccion->where("id_direccion", $idDireccion)->first();
            
			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Ubicaciones de Acceso | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Ubicaciones de Acceso',
                'previo'                    => 'listar-direcciones',
				'elementoSeleccionadoModulo'=> "Ubicaciones de Acceso",
				'subtitulo'                 => 'Ubicaciones de Acceso',
				'direccion'                 => $direccion,
				'listaUbicaciones'          => $listaUbicaciones,
				'idDireccion'               => $idDireccion
			);
			
			$data = array_merge($data, $this->items);
			
			return view('administracion/listar_ubicaciones_acceso',$data);			
		} 
		else 
		{
			return view('errors/500');	
		}
    }
    
    public function registrarUbicacionAcceso($idDireccion)
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $ubicacion = ucwords(mb_strtolower($this->request->getPost('txtUbicacionAcceso')));
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($ubicacion, 'required|trim|minlength[1]|maxlength[200]', 'Ubicación');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $whereUbicacion = array("IDDireccion" => $idDireccion, 'Ubicacion', $ubicacion);
		$ubicacionExistente = $this->ubicacionAcceso->where($whereUbicacion)->findAll();
        
        if(count($ubicacionExistente)>0)
        {
            $msgExistencia .= "<li>La ubicación ya fue registrada. [CAMPO] <small>UBICACIÓN</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }


        $data = array (
            'IDDireccion'   => $idDireccion, 
            'Ubicacion'     => $ubicacion,
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,
            'Estado'        => 'A'
        );

        $lastId = $this->ubicacionAcceso->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $ubicacion);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

	/**************************************************************************/
	
    /********************************* PAISES *********************************/
    
    public function listarRegionPaises()
    {
        if(isset($this->items['id']))
        {
			/* ACCIONES */
			$listadoPais = $this->regionPais->findAll();
			
			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Países | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Países',
				'elementoSeleccionadoModulo'=> "Listado de Países",
				'subtitulo'                 => 'Países',
				'listadoPais'           => $listadoPais
			);
			
			$data = array_merge($data, $this->items);
			
			return view('administracion/listar_region_pais',$data);			
		} 
		else 
		{
			return view('errors/500');
		}
    }
    
	public function registrarRegionPais()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $pais           = ucwords(mb_strtolower($this->request->getPost('txtRegionPais_i'))) ;
        $internacional  = $this->request->getPost('txtCodigoInternacionalPais_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($pais, 'required|trim|minlength[1]|maxlength[100]', 'País');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
		$paisExistente = $this->regionPais->where('Pais', $pais)->findAll();
        
        if(count($paisExistente)>0)
        {
            $msgExistencia .= "<li>El país ya fue registrada. [CAMPO] <small>PAÍS</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'Pais'                  => $pais,
            'CodigoInternacional'   => $internacional,
            'UsuarioCrea'           => $this->items['id'],
            'FechaCrea'             => $fechaActual,    
            'Localhost'             => $this->request->getIPAddress(),
            'UsuarioEstado'         => $this->items['id'],
            'FechaEstado'           => $fechaActual,    
            'MotivoEstado'          => "Creación de país.",    
            'Estado'                => 'A'
        );

        $lastId = $this->regionPais->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $pais);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
	
	public function obtenerDatosRegionPais()
	{
	    if (isset($this->items['id'])) 
    	{
    		/*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
    		*/
    
    		$msjError = TRUE;
    		$idPais = $this->request->getPost('idPais');
    
    		/*
            * ----------------------------
            * VALIDACIÓN DE REQUERIMIENTOS
            * ----------------------------
            */
    
    		$error = '';
    		$error .= $this->complementos->validaCampo($idPais, 'trim', 'ID');
    
    		if ($error != '') {
    			$message = sprintf($this->mensajeError->msg201, $error);
    			echo $this->alertas->alertaError($message);
    			exit;
    		}
    
    		/*
            * -------------
            * BASE DE DATOS
            * -------------
            */
    		
    		$datosPais = $this->regionPais->where('IDPais', $idPais)->first();
    
    		if(!empty($datosPais))
    		{
    			$resultado = array(
    				'idpais'        => (string) $idPais,
    				'pais'          => (string) $datosPais['Pais'],
    				'internacional' => (string) $datosPais['CodigoInternacional']
    			);
    		} 
    		else 
    		{
    			$resultado = array(
    				'descripcion' => 0
    			);
    		}
    
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado);
	    }
    	else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}
	
	public function modificarRegionPais($idRegionPais)
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $pais           = ucwords(mb_strtolower($this->request->getPost('txtRegionPais_i'))) ;
        $internacional  = $this->request->getPost('txtCodigoInternacionalPais_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($pais, 'required|trim|minlength[1]|maxlength[100]', 'País');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'Pais'                  => $pais,
            'CodigoInternacional'   => $internacional,
            'UsuarioModifica'       => $this->items['id'],
            'FechaModifica'         => $fechaActual,    
            'Localhost'             => $this->request->getIPAddress()
        );

        $lastId = $this->regionPais->update([$idRegionPais], $data);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg503, $pais);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }		
	}
	
    public function modificarEstadoRegionPais()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idPais = $this->request->getPost('idPais');
        $estado = $this->request->getPost('estado');
        $motivo = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idPais, 'required|trim|numeric', 'ID País');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,
            'MotivoEstado'      => $motivo,
            'Estado'            => $estado
        );
        
        $lastId = $this->regionPais->update([$idPais], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idPais);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
        
	public function listadoRegionPais()
	{
	    if (isset($this->items['id'])) 
	    {
        	/*
            * ----------------------
            * OBTIENE Y VALIDA DATOS
            * ----------------------
            */
            $listadoPaises = $this->regionPais->where("Estado", "A")->findAll();
            
            $paises=array();
    
    		if (!empty($listadoPaises)) {
                foreach ($listadoPaises as $items) {
                    $paises[] = array(
    					'id'    => (string) $items['IDPais'],
             	        'text'  => (string) $items['Pais'],
                    );
                }
    
                $resultado = array(
    				'listadoPaises' => json_encode($paises)
    			);
            } else {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
    
            /*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
            echo json_encode($resultado, JSON_NUMERIC_CHECK);
	    }
        else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}

	/**************************************************************************/
	
    /***************************** DEPARTAMENTOS ******************************/
    
    public function listarRegionDepartamentos($idPais)
    {
		if(isset($this->items['id']))
        {
            if($idPais != "TOTAL")
			{
			    $pais = $this->regionPais->where('IDPais', $idPais)->first();
			}
			else
			{
			    $pais = array();
			}
            
			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Departamentos | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Departamentos',
                'previo'                    => 'listar-region-paises',
				'elementoSeleccionadoModulo'=> "Listado de Departamentos",
				'subtitulo'                 => 'Departamentos',
				'pais'                      => $pais,
				'idPais'                    => $idPais
			);
			
			$data = array_merge($data, $this->items);
			
			return view('administracion/listar_region_departamentos',$data);			
		} 
		else 
		{
			return view('errors/500');
		}
    }
    
    public function regionDepartamentoServerside()
    {
        if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"  => $this->items['idPerfil'],
                "IDUsuario" => $this->items['id'],
                "IDPais"    => $this->request->getPost('idPais')
            );
            
            /* LISTAR DEPARTAMENTOS */
            $dataServerside = $this->regionDepartamento->listaGeneralRegionDepartamento($this->request->getPost(), $adicionales);
            
            foreach($dataServerside["data"] as $key=>$value)
            {
    			if(in_array("ESREDE", $this->items['permisos']))
    			{
        			$dataServerside["data"][$key]['EstadoDepartamento'] = '<button class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0 cambiar-estado-region-departamento" data-estado="'.$value['Estado'].'" data-id="'.$value['IDDepartamento'].'">'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</button>';
    			}
    			else
    			{
    			    $dataServerside["data"][$key]['EstadoDepartamento'] = '<span class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0" >'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</span>';
    			}
    			
                $acciones = '';
                
                $acciones .= '<button class="badge bg-info border-0 p-2 mx-1 datos-region-departamento" data-bs-target="#informacionRegionDepartamento" data-form="#formInformacionRegionDepartamento" data-id="'.$value['IDDepartamento'].'" data-accion="ver" id="ver-departamento" data-tooltip="tooltip" title="Ver Departamento">
    				<i class="mdi mdi-eye align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
    			if(in_array("UPREDE", $this->items['permisos']))
    			{
    			$acciones .= '<button class="badge bg-warning border-0 p-2 mx-1 datos-region-departamento" data-bs-target="#informacionRegionDepartamento" data-form="#formInformacionRegionDepartamento" data-id="'.$value['IDDepartamento'].'" data-accion="editar" id="editar-departamento" data-tooltip="tooltip" title="Editar Departamento">
    				<i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			}
    			
    			if (in_array("ADREPR", $this->items['permisos'])) 
    			{
    			$acciones .= '<a href="'.$this->items['baseUrl'].'/listar-region-provincias/'.$value['IDDepartamento'].'" class="badge bg-sistema border-0 p-2 mx-1" data-tooltip="tooltip" title="Ver Provincias">
    				<i class="mdi mdi-earth align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</a>';
    			}
    			
                $dataServerside["data"][$key]['acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    	else
    	{
    	    $datos = [
                'draw'              => 1,
                'data'              => array(),
                'recordsTotal'      => 0,
                'recordsFiltered'   => (int) 0
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    }
    
    public function registrarRegionDepartamento()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError       = TRUE;
        $idPais         = $this->request->getPost('txtIDRegionPais_i');
        $departamento   = mb_strtoupper(mb_strtolower($this->request->getPost('txtRegionDepartamento_i')));
        $inei           = $this->request->getPost('txtCodigoINEIRegionDepartamento_i');
        $reniec         = $this->request->getPost('txtCodigoRENIECRegionDepartamento_i');
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idPais, 'required|trim|number', 'ID País');
        $error .= $this->complementos->validaCampo($departamento, 'required|trim|minlength[1]|maxlength[200]', 'Departamento');
        $error .= $this->complementos->validaCampo($inei, 'trim|numeric|minlength[1]|maxlength[7]', 'Código INEI');
        $error .= $this->complementos->validaCampo($reniec, 'trim|numeric|minlength[1]|maxlength[3]', 'Código RENIEC');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $whereDepartamento = array(
            'IDPais'        => $idPais,
            'Departamento'  => $departamento
        );
        
		$departamentoExistente = $this->regionDepartamento->where($whereDepartamento)->findAll();
        
        if(count($departamentoExistente)>0)
        {
            $msgExistencia .= "<li>El departamento fue registrado. [CAMPO] <small>DEPARTAMENTO</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'IDPais'            => $idPais,
            'Departamento'      => $departamento,
            'CodigoINEI'        => $inei,
            'CodUbigeoReniec'   => $reniec,
            'UsuarioCrea'       => $this->items['id'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'Estado'            => 'A',
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,    
            'MotivoEstado'      => 'Creación de departamento.'
        );

        $lastId = $this->regionDepartamento->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $departamento);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

	public function obtenerDatosRegionDepartamento() 
	{
	    if (isset($this->items['id'])) 
	    {
    		/*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
    		*/
    
    		$msjError = TRUE;
    		$idDepartamento = $this->request->getPost('idDepartamento');
    
    		/*
            * ----------------------------
            * VALIDACIÓN DE REQUERIMIENTOS
            * ----------------------------
            */
    
    		$error = '';
    		$error .= $this->complementos->validaCampo($idDepartamento, 'trim', 'ID');
    
    		if ($error != '') {
    			$message = sprintf($this->mensajeError->msg201, $error);
    			echo $this->alertas->alertaError($message);
    			exit;
    		}
    
    		/*
            * -------------
            * BASE DE DATOS
            * -------------
            */
    		
    		$datosDepartamento = $this->regionDepartamento->where('IDDepartamento', $idDepartamento)->first();
    
    		if(!empty($datosDepartamento))
    		{
    			$resultado = array(
    				'idpais'            => (string) $datosDepartamento['IDPais'],
    				'iddepartamento'    => (string) $idDepartamento,
    				'departamento'      => (string) $datosDepartamento['Departamento'],
    				'inei'              => (string) $datosDepartamento['CodigoINEI'],
    				'reniec'            => (string) $datosDepartamento['CodUbigeoReniec']
    			);
    		} 
    		else 
    		{
    			$resultado = array(
    				'descripcion' => 0
    			);
    		}
    
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado);
	    }
	    else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}
	
    public function modificarRegionDepartamento($idDepartamento)
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError       = TRUE;
        $idPais         = $this->request->getPost('txtIDRegionPais_i');
        $departamento   = mb_strtoupper(mb_strtolower($this->request->getPost('txtRegionDepartamento_i')));
        $inei           = $this->request->getPost('txtCodigoINEIRegionDepartamento_i');
        $reniec         = $this->request->getPost('txtCodigoRENIECRegionDepartamento_i');
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idPais, 'required|trim|number', 'ID País');
        $error .= $this->complementos->validaCampo($departamento, 'required|trim|minlength[1]|maxlength[200]', 'Departamento');
        $error .= $this->complementos->validaCampo($inei, 'trim|numeric|minlength[1]|maxlength[7]', 'Código INEI');
        $error .= $this->complementos->validaCampo($reniec, 'trim|numeric|minlength[1]|maxlength[3]', 'Código RENIEC');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */
        
        $data = array (
            'IDPais'            => $idPais,
            'Departamento'      => $departamento,
            'CodigoINEI'        => $inei,
            'CodUbigeoReniec'   => $reniec,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->regionDepartamento->update([$idDepartamento], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idDepartamento);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function modificarEstadoRegionDepartamento()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idDepartamento = $this->request->getPost('idDepartamento');
        $estado         = $this->request->getPost('estado');
        $motivo         = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idDepartamento, 'required|trim|numeric', 'ID Departamento');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'Estado'            => $estado,
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,    
            'MotivoEstado'      => $motivo
        );
        
        $lastId = $this->regionDepartamento->update([$idDepartamento], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idDepartamento);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
	public function listadoRegionDepartamento()
	{
	    if (isset($this->items['id'])) 
	    {
        	/*
            * ----------------------
            * OBTIENE Y VALIDA DATOS
            * ----------------------
            */
            
    		$idPais = $this->request->getPost('idPais');
    
            if($idPais == 'TOTAL')
            {
                $listadoDepartamentos = $this->regionDepartamento->where("Estado", "A")->findAll();
            }
            else
            {
                $whereDepartamentos = array(
                    'IDPais' => $idPais,
                    'Estado' => "A"
                );
                $listadoDepartamentos = $this->regionDepartamento->where($whereDepartamentos)->findAll();
            }
            
            $departamentos=array();
    
    		if (!empty($listadoDepartamentos)) 
    		{
                foreach ($listadoDepartamentos as $items) 
                {
                    $departamentos[] = array(
    					'id'    => (string) $items['IDDepartamento'],
             	        'text'  => (string) $items['Departamento'],
                    );
                }
    
                $resultado = array(
    				'listadoDepartamentos' => json_encode($departamentos)
    			);
            } 
            else 
            {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
    
            /*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
            echo json_encode($resultado, JSON_NUMERIC_CHECK);
	    }
	    else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}

	/**************************************************************************/
	
    /******************************* PROVINCIAS *******************************/
    
    public function listarRegionProvincias($idDepartamento)
    {
        if(isset($this->items['id']))
        {
			if($idDepartamento != "TOTAL")
			{
			    $departamento = $this->regionDepartamento->obtenerDepartamento($idDepartamento);
			}
			else
			{
			    $departamento = array();
			}
            
			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Provincias | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Provincias',
                'previo'                    => 'listar-region-departamentos/'.$idDepartamento,
				'elementoSeleccionadoModulo'=> "Listado de Provincias",
				'subtitulo'                 => 'Provincias',
				'departamento'              => $departamento,
				'idDepartamento'            => $idDepartamento
			);
			
			$data = array_merge($data, $this->items);
			
			return view('administracion/listar_region_provincias',$data);			
		} 
		else 
		{
			return view('errors/500');
		}
    }
    
    public function regionProvinciaServerside()
    {
        if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"          => $this->items['idPerfil'],
                "IDUsuario"         => $this->items['id'],
                "IDDepartamento"    => $this->request->getPost('idDepartamento')
            );
            
            /* LISTAR DEPARTAMENTOS */
            $dataServerside = $this->regionProvincia->listaGeneralRegionProvincia($this->request->getPost(), $adicionales);
            
            foreach($dataServerside["data"] as $key=>$value)
            {
    			if(in_array("ESREPR", $this->items['permisos']))
    			{
        			$dataServerside["data"][$key]['EstadoProvincia'] = '<button class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0 cambiar-estado-region-provincia" data-estado="'.$value['Estado'].'" data-id="'.$value['IDProvincia'].'">'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</button>';
    			}
    			else
    			{
    			    $dataServerside["data"][$key]['EstadoProvincia'] = '<span class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0" >'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</span>';
    			}
    			
                $acciones = '';
                
                $acciones .= '<button class="badge bg-info border-0 p-2 mx-1 datos-region-provincia" data-bs-target="#informacionRegionProvincia" data-form="#formInformacionRegionProvincia" data-id="'.$value['IDProvincia'].'" data-accion="ver" id="ver-provincia" data-tooltip="tooltip" title="Ver Provincia">
    				<i class="mdi mdi-eye align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
    			if(in_array("UPREPR", $this->items['permisos']))
    			{
    			$acciones .= '<button class="badge bg-warning border-0 p-2 mx-1 datos-region-provincia" data-bs-target="#informacionRegionProvincia" data-form="#formInformacionRegionProvincia" data-id="'.$value['IDProvincia'].'" data-accion="editar" id="editar-provincia" data-tooltip="tooltip" title="Editar Provincia">
    				<i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			}
    			
    			if (in_array("ADREDI", $this->items['permisos'])) 
    			{
    			$acciones .= '<a href="'.$this->items['baseUrl'].'/listar-region-distritos/'.$value['IDProvincia'].'" class="badge bg-sistema border-0 p-2 mx-1" data-tooltip="tooltip" title="Ver Distritos">
    				<i class="mdi mdi-earth align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</a>';
    			}
    			
                $dataServerside["data"][$key]['acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    	else
    	{
    	    $datos = [
                'draw'              => 1,
                'data'              => array(),
                'recordsTotal'      => 0,
                'recordsFiltered'   => (int) 0
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    }
    
    public function registrarRegionProvincia()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError       = TRUE;
        $idDepartamento = $this->request->getPost('txtIDRegionDepartamento_i');
        $provincia      = mb_strtoupper(mb_strtolower($this->request->getPost('txtRegionProvincia_i')));
        $inei           = $this->request->getPost('txtCodigoINEIRegionProvincia_i');
        $reniec         = $this->request->getPost('txtCodigoRENIECRegionProvincia_i');
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idDepartamento, 'required|trim|number', 'ID Departamento');
        $error .= $this->complementos->validaCampo($provincia, 'required|trim|minlength[1]|maxlength[200]', 'Provincia');
        $error .= $this->complementos->validaCampo($inei, 'trim|numeric|minlength[1]|maxlength[7]', 'Código INEI');
        $error .= $this->complementos->validaCampo($reniec, 'trim|numeric|minlength[1]|maxlength[6]', 'Código RENIEC');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $whereProvincia = array(
            'IDDepartamento'    => $idDepartamento,
            'Provincia'         => $provincia
        );
        
		$provinciaExistente = $this->regionProvincia->where($whereProvincia)->findAll();
        
        if(count($provinciaExistente)>0)
        {
            $msgExistencia .= "<li>La provincia fue registrada. [CAMPO] <small>PROVINCIA</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'IDDepartamento'    => $idDepartamento,
            'Provincia'         => $provincia,
            'CodigoINEI'        => $inei,
            'CodUbigeoReniec'   => $reniec,
            'UsuarioCrea'       => $this->items['id'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'Estado'            => 'A',
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,    
            'MotivoEstado'      => 'Creación de provincia.'
        );

        $lastId = $this->regionProvincia->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $provincia);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

	public function obtenerDatosRegionProvincia() 
	{
	    if (isset($this->items['id']))
	    {
    		/*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
    		*/
    
    		$msjError = TRUE;
    		$idProvincia = $this->request->getPost('idProvincia');
    
    		/*
            * ----------------------------
            * VALIDACIÓN DE REQUERIMIENTOS
            * ----------------------------
            */
    
    		$error = '';
    		$error .= $this->complementos->validaCampo($idProvincia, 'trim', 'ID');
    
    		if ($error != '') {
    			$message = sprintf($this->mensajeError->msg201, $error);
    			echo $this->alertas->alertaError($message);
    			exit;
    		}
    
    		/*
            * -------------
            * BASE DE DATOS
            * -------------
            */
    		
    		$datosProvincia = $this->regionProvincia->where('IDProvincia', $idProvincia)->first();
    
    		if(!empty($datosProvincia))
    		{
    			$resultado = array(
    				'iddepartamento'    => (string) $datosProvincia['IDDepartamento'],
    				'idprovincia'       => (string) $idProvincia,
    				'provincia'         => (string) $datosProvincia['Provincia'],
    				'inei'              => (string) $datosProvincia['CodigoINEI'],
    				'reniec'            => (string) $datosProvincia['CodUbigeoReniec']
    			);
    		} 
    		else 
    		{
    			$resultado = array(
    				'descripcion' => 0
    			);
    		}
    
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado);
	    }
	    else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}
	
    public function modificarRegionProvincia($idProvincia)
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError       = TRUE;
        $idDepartamento = $this->request->getPost('txtIDRegionDepartamento_i');
        $provincia      = mb_strtoupper(mb_strtolower($this->request->getPost('txtRegionProvincia_i')));
        $inei           = $this->request->getPost('txtCodigoINEIRegionProvincia_i');
        $reniec         = $this->request->getPost('txtCodigoRENIECRegionProvincia_i');
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idDepartamento, 'required|trim|number', 'ID Departamento');
        $error .= $this->complementos->validaCampo($provincia, 'required|trim|minlength[1]|maxlength[200]', 'Provincia');
        $error .= $this->complementos->validaCampo($inei, 'trim|numeric|minlength[1]|maxlength[7]', 'Código INEI');
        $error .= $this->complementos->validaCampo($reniec, 'trim|numeric|minlength[1]|maxlength[6]', 'Código RENIEC');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */
        
        $data = array (
            'IDDepartamento'    => $idDepartamento,
            'Provincia'         => $provincia,
            'CodigoINEI'        => $inei,
            'CodUbigeoReniec'   => $reniec,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->regionProvincia->update([$idProvincia], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idProvincia);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function modificarEstadoRegionProvincia()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idProvincia    = $this->request->getPost('idProvincia');
        $estado         = $this->request->getPost('estado');
        $motivo         = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idProvincia, 'required|trim|numeric', 'ID Provincia');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'Estado'            => $estado,
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,    
            'MotivoEstado'      => $motivo
        );
        
        $lastId = $this->regionProvincia->update([$idProvincia], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idProvincia);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
	public function listadoRegionProvincia()
	{
	    if (isset($this->items['id'])) 
	    {
        	/*
            * ----------------------
            * OBTIENE Y VALIDA DATOS
            * ----------------------
            */
            
    		$idDepartamento = $this->request->getPost('idDepartamento');
    
            if($idDepartamento == 'TOTAL')
            {
                $listadoProvincias = $this->regionProvincia->where("Estado", "A")->findAll();
            }
            else
            {
                $whereProvincias = array(
                    'IDDepartamento' => $idDepartamento,
                    'Estado' => "A"
                );
                $listadoProvincias = $this->regionProvincia->where($whereProvincias)->findAll();
            }
            
            $provincias = array();
    
    		if (!empty($listadoProvincias)) 
    		{
                foreach ($listadoProvincias as $items) {
                    $provincias[] = array(
    					'id'    => (string) $items['IDProvincia'],
             	        'text'  => (string) $items['Provincia'],
                    );
                }
    
                $resultado = array(
    				'listadoProvincias' => json_encode($provincias)
    			);
            } 
            else 
            {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
    
            /*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
            echo json_encode($resultado, JSON_NUMERIC_CHECK);
	    }
	    else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}

	/**************************************************************************/
	
    /******************************** DISTRITOS *******************************/
    
    public function listarRegionDistritos($idProvincia)
    {
        if(isset($this->items['id']))
        {
			if($idProvincia != "TOTAL")
			{
			    $provincia = $this->regionProvincia->obtenerProvincia($idProvincia);
			}
			else
			{
			    $provincia = array();
			}
            
			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Distritos | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Distritos',
                'previo'                    => 'listar-region-provincias/'.$idProvincia,
				'elementoSeleccionadoModulo'=> "Listado de Distritos",
				'subtitulo'                 => 'Distritos',
				'provincia'                 => $provincia,
				'idProvincia'               => $idProvincia
			);
			
			$data = array_merge($data, $this->items);
			
			return view('administracion/listar_region_distritos',$data);			
		} 
		else 
		{
			return view('errors/500');
		}
    }
    
    public function regionDistritoServerside()
    {
        if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"      => $this->items['idPerfil'],
                "IDUsuario"     => $this->items['id'],
                "IDProvincia"   => $this->request->getPost('idProvincia')
            );
            
            /* LISTAR DEPARTAMENTOS */
            $dataServerside = $this->regionDistrito->listaGeneralRegionDistrito($this->request->getPost(), $adicionales);
            
            foreach($dataServerside["data"] as $key=>$value)
            {
    			if(in_array("ESREDI", $this->items['permisos']))
    			{
        			$dataServerside["data"][$key]['EstadoDistrito'] = '<button class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0 cambiar-estado-region-distrito" data-estado="'.$value['Estado'].'" data-id="'.$value['IDDistrito'].'">'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</button>';
    			}
    			else
    			{
    			    $dataServerside["data"][$key]['EstadoDistrito'] = '<span class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0" >'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</span>';
    			}
    			
                $acciones = '';
                
                $acciones .= '<button class="badge bg-info border-0 p-2 mx-1 datos-region-distrito" data-bs-target="#informacionRegionDistrito" data-form="#formInformacionRegionDistrito" data-id="'.$value['IDDistrito'].'" data-accion="ver" id="ver-distrito" data-tooltip="tooltip" title="Ver Distrito">
    				<i class="mdi mdi-eye align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
    			if(in_array("UPREDI", $this->items['permisos']))
    			{
    			$acciones .= '<button class="badge bg-warning border-0 p-2 mx-1 datos-region-distrito" data-bs-target="#informacionRegionDistrito" data-form="#formInformacionRegionDistrito" data-id="'.$value['IDDistrito'].'" data-accion="editar" id="editar-distrito" data-tooltip="tooltip" title="Editar Distrito">
    				<i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			}
    			
                $dataServerside["data"][$key]['acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    	else
    	{
    	    $datos = [
                'draw'              => 1,
                'data'              => array(),
                'recordsTotal'      => 0,
                'recordsFiltered'   => (int) 0
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    }
    
    public function registrarRegionDistrito()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError       = TRUE;
        $idProvincia    = $this->request->getPost('txtIDRegionProvincia_i');
        $distrito       = mb_strtoupper(mb_strtolower($this->request->getPost('txtRegionDistrito_i')));
        $inei           = $this->request->getPost('txtCodigoINEIRegionDistrito_i');
        $reniec         = $this->request->getPost('txtCodigoRENIECRegionDistrito_i');
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idProvincia, 'required|trim|number', 'ID Provincia');
        $error .= $this->complementos->validaCampo($distrito, 'required|trim|minlength[1]|maxlength[200]', 'Distrito');
        $error .= $this->complementos->validaCampo($inei, 'trim|numeric|minlength[1]|maxlength[10]', 'Código INEI');
        $error .= $this->complementos->validaCampo($reniec, 'trim|numeric|minlength[1]|maxlength[10]', 'Código RENIEC');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $whereDistrito = array(
            'IDProvincia'   => $idProvincia,
            'Distrito'      => $distrito
        );
        
		$distritoExistente = $this->regionDistrito->where($whereDistrito)->findAll();
        
        if(count($distritoExistente)>0)
        {
            $msgExistencia .= "<li>El distrito fue registrada. [CAMPO] <small>DISTRITO</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'IDProvincia'       => $idProvincia,
            'Distrito'          => $distrito,
            'CodigoINEI'        => $inei,
            'CodUbigeoReniec'   => $reniec,
            'UsuarioCrea'       => $this->items['id'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'Estado'            => 'A',
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,    
            'MotivoEstado'      => 'Creación de distrito.'
        );

        $lastId = $this->regionDistrito->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $distrito);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

	public function obtenerDatosRegionDistrito() 
	{
	    if (isset($this->items['id']))
	    {
    		/*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
    		*/
    
    		$msjError = TRUE;
    		$idDistrito = $this->request->getPost('idDistrito');
    
    		/*
            * ----------------------------
            * VALIDACIÓN DE REQUERIMIENTOS
            * ----------------------------
            */
    
    		$error = '';
    		$error .= $this->complementos->validaCampo($idDistrito, 'trim', 'ID');
    
    		if ($error != '') {
    			$message = sprintf($this->mensajeError->msg201, $error);
    			echo $this->alertas->alertaError($message);
    			exit;
    		}
    
    		/*
            * -------------
            * BASE DE DATOS
            * -------------
            */
    		
    		$datosDistrito = $this->regionDistrito->where('IDDistrito', $idDistrito)->first();
    
    		if(!empty($datosDistrito))
    		{
    			$resultado = array(
    				'idprovincia'   => (string) $datosDistrito['IDProvincia'],
    				'iddistrito'    => (string) $idDistrito,
    				'distrito'      => (string) $datosDistrito['Distrito'],
    				'inei'          => (string) $datosDistrito['CodigoINEI'],
    				'reniec'        => (string) $datosDistrito['CodUbigeoReniec']
    			);
    		} 
    		else 
    		{
    			$resultado = array(
    				'descripcion' => 0
    			);
    		}
    
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */

		    echo json_encode($resultado);
	    }
	    else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}
	
    public function modificarRegionDistrito($idDistrito)
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError       = TRUE;
        $idProvincia    = $this->request->getPost('txtIDRegionProvincia_i');
        $distrito       = mb_strtoupper(mb_strtolower($this->request->getPost('txtRegionDistrito_i')));
        $inei           = $this->request->getPost('txtCodigoINEIRegionDistrito_i');
        $reniec         = $this->request->getPost('txtCodigoRENIECRegionDistrito_i');
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idProvincia, 'required|trim|number', 'ID Provincia');
        $error .= $this->complementos->validaCampo($distrito, 'required|trim|minlength[1]|maxlength[200]', 'Distrito');
        $error .= $this->complementos->validaCampo($inei, 'trim|numeric|minlength[1]|maxlength[10]', 'Código INEI');
        $error .= $this->complementos->validaCampo($reniec, 'trim|numeric|minlength[1]|maxlength[10]', 'Código RENIEC');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */
        
        $data = array (
            'IDProvincia'       => $idProvincia,
            'Distrito'          => $distrito,
            'CodigoINEI'        => $inei,
            'CodUbigeoReniec'   => $reniec,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->regionDistrito->update([$idDistrito], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idDistrito);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function modificarEstadoRegionDistrito()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idDistrito     = $this->request->getPost('idDistrito');
        $estado         = $this->request->getPost('estado');
        $motivo         = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idDistrito, 'required|trim|numeric', 'ID Distrito');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'Estado'            => $estado,
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,    
            'MotivoEstado'      => $motivo
        );
        
        $lastId = $this->regionDistrito->update([$idDistrito], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idDistrito);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
	public function listadoRegionDistrito()
	{
	    if (isset($this->items['id'])) 
	    {
        	/*
            * ----------------------
            * OBTIENE Y VALIDA DATOS
            * ----------------------
            */
            
    		$idProvincia = $this->request->getPost('idProvincia');
    
            if($idProvincia == 'TOTAL')
            {
                $listadoDistritos = $this->regionDistrito->where("Estado", "A")->findAll();
            }
            else
            {
                $whereDistritos = array(
                    'IDProvincia' => $idProvincia,
                    'Estado' => "A"
                );
                $listadoDistritos = $this->regionDistrito->where($whereDistritos)->findAll();
            }
            
            $distritos = array();
    
    		if (!empty($listadoDistritos)) {
                foreach ($listadoDistritos as $items) {
                    $distritos[] = array(
    					'id'    => (string) $items['IDDistrito'],
             	        'text'  => (string) $items['Distrito'],
                    );
                }
    
                $resultado = array(
    				'listadoDistritos' => json_encode($distritos)
    			);
            } else {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
    
            /*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
            echo json_encode($resultado, JSON_NUMERIC_CHECK);
	    }
	    else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}

	/**************************************************************************/
	
    /************************* ESTRUCTURA - DIRECCIÓN *************************/
    
    public function listarDireccionesEstructura()
    {
        if(isset($this->items['id']))
        {
			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Estructura - Direcciones | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Direcciones',
				'elementoSeleccionadoModulo'=> "Listado de Direcciones",
				'subtitulo'                 => 'Direcciones'
			);
			
			$data = array_merge($data, $this->items);
			
			return view('administracion/listar_estructura_direcciones',$data);			
		} 
		else 
		{
			return view('errors/500');
		}
    }
    
    public function direccionEstructuraServerside()
    {
        if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"      => $this->items['idPerfil'],
                "IDUsuario"     => $this->items['id']
            );
            
            /* LISTAR DIRECCION */
            $dataServerside = $this->estructuraDirecciones->listaGeneralEstructuraDireccion($this->request->getPost(), $adicionales);
            
            foreach($dataServerside["data"] as $key=>$value)
            {
    			if(in_array("ESDIES", $this->items['permisos']))
    			{
        			$dataServerside["data"][$key]['EstadoDireccion'] = '<button class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0 cambiar-estado-direccion-estructura" data-estado="'.$value['Estado'].'" data-id="'.$value['IDDireccion'].'">'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</button>';
    			}
    			else
    			{
    			    $dataServerside["data"][$key]['EstadoDireccion'] = '<span class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0" >'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</span>';
    			}
    			
    			$dataServerside["data"][$key]['ResponsableDireccion'] = $value['MatriculaResponsablePrincipal']." | ".ucwords(mb_strtolower($value['NombreResponsablePrincipal']))." ".ucwords(mb_strtolower($value['ApellidoResponsablePrincipal']));
    			
                $acciones = '';
                
                $acciones .= '<button class="badge bg-info border-0 p-2 mx-1 datos-direccion-estructura" data-bs-target="#informacionDireccionEstructura" data-form="#formInformacionDireccionEstructura" data-id="'.$value['IDDireccion'].'" data-accion="ver" id="ver-direccion" data-tooltip="tooltip" title="Ver Dirección">
    				<i class="mdi mdi-eye align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
    			if(in_array("UPDIES", $this->items['permisos']))
    			{
    			$acciones .= '<button class="badge bg-warning border-0 p-2 mx-1 datos-direccion-estructura" data-bs-target="#informacionDireccionEstructura" data-form="#formInformacionDireccionEstructura" data-id="'.$value['IDDireccion'].'" data-accion="editar" id="editar-direccion" data-tooltip="tooltip" title="Editar Dirección">
    				<i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			}
    			
    			if (in_array("ADARES", $this->items['permisos'])) 
    			{
    			$acciones .= '<a href="'.$this->items['baseUrl'].'/listar-areas-estructura/'.$value['IDDireccion'].'" class="badge bg-sistema border-0 p-2 mx-1" data-tooltip="tooltip" title="Ver Áreas">
    				<i class="mdi mdi-graph align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</a>';
    			}
    			
                $acciones .= '<button class="badge bg-rosa border-0 p-2 mx-1 responsablesDireccionEstructura" data-bs-target="#usuariosResponsablesDireccionEstructura" data-id="'.$value['IDDireccion'].'" data-tooltip="tooltip" title="Ver Responsables de Dirección">
    				<i class="mdi mdi-account-supervisor align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
    			
    			
                $dataServerside["data"][$key]['acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    	else
    	{
    	    $datos = [
                'draw'              => 1,
                'data'              => array(),
                'recordsTotal'      => 0,
                'recordsFiltered'   => (int) 0
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    }
    
	public function registrarDireccionEstructura()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $direccion = ucwords(mb_strtolower($this->request->getPost('txtDireccionEstructura_i'))) ;
        $observacion = $this->request->getPost('txtObservacionDireccionEstructura_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($direccion, 'required|trim|minlength[1]|maxlength[100]', 'Dirección');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
		$direccionExistente = $this->estructuraDirecciones->where('Direccion', $direccion)->findAll();
        
        if(count($direccionExistente)>0)
        {
            $msgExistencia .= "<li>La dirección ya fue registrada. [CAMPO] <small>DIRECCIÓN</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }


        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'Direccion'     => $direccion,
            'Observacion'   => $observacion,
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress(),
            'UsuarioEstado' => $this->items['id'],
            'FechaEstado'   => $fechaActual,    
            'MotivoEstado'  => "Creación de dirección.",    
            'Estado'        => 'A'
        );

        $lastId = $this->estructuraDirecciones->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $direccion);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
	
	public function obtenerDatosDireccionEstructura()
	{
	    if (isset($this->items['id']))
	    {
    		/*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
    		*/
    
    		$msjError = TRUE;
    		$idDireccion = $this->request->getPost('idDireccion');
    
    		/*
            * ----------------------------
            * VALIDACIÓN DE REQUERIMIENTOS
            * ----------------------------
            */
    
    		$error = '';
    		$error .= $this->complementos->validaCampo($idDireccion, 'trim', 'ID');
    
    		if ($error != '') {
    			$message = sprintf($this->mensajeError->msg201, $error);
    			echo $this->alertas->alertaError($message);
    			exit;
    		}
    
    		/*
            * -------------
            * BASE DE DATOS
            * -------------
            */
    		
    		$datosDireccion = $this->estructuraDirecciones->where('IDDireccion', $idDireccion)->first();
    
    		if(!empty($datosDireccion))
    		{
    			$resultado = array(
    				'iddireccion'   => (string) $idDireccion,
    				'direccion'     => (string) $datosDireccion['Direccion'],
    				'observacion'   => (string) $datosDireccion['Observacion']
    			);
    		} 
    		else 
    		{
    			$resultado = array(
    				'descripcion' => 0
    			);
    		}
    
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado);
	    }
	    else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}
	
	public function modificarDireccionEstructura($idDireccion)
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $direccion = ucwords(mb_strtolower($this->request->getPost('txtDireccionEstructura_i'))) ;
        $observacion = $this->request->getPost('txtObservacionDireccionEstructura_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($direccion, 'required|trim|minlength[1]|maxlength[100]', 'Dirección');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'Direccion'         => $direccion,
            'Observacion'       => $observacion,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->estructuraDirecciones->update([$idDireccion], $data);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg503, $direccion);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }		
	}
	
    public function modificarEstadoDireccionEstructura()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idDireccion = $this->request->getPost('idDireccion');
        $estado = $this->request->getPost('estado');
        $motivo = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idDireccion, 'required|trim|numeric', 'ID Cargo');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,
            'MotivoEstado'      => $motivo,
            'Estado'            => $estado
        );
        
        $lastId = $this->estructuraDirecciones->update([$idDireccion], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idDireccion);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
        
	public function listadoDireccionesEstructura()
	{
	    if (isset($this->items['id'])) 
	    {
        	/*
            * ----------------------
            * OBTIENE Y VALIDA DATOS
            * ----------------------
            */
            $listadoDirecciones = $this->estructuraDirecciones->findAll();
            
            $direcciones=array();
    
    		if (!empty($listadoDirecciones)) 
    		{
                foreach ($listadoDirecciones as $items) {
                    $direcciones[] = array(
    					'id' => (string) $items['IDDireccion'],
             	        'text' => (string) $items['Direccion'],
                    );
                }
    
                $resultado = array(
    				'listadoDirecciones' => json_encode($direcciones)
    			);
            } 
            else 
            {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
    
            /*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
            echo json_encode($resultado, JSON_NUMERIC_CHECK);
	    }
	    else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}
	
	/**************************************************************************/
	
    /****************** ESTRUCTURA - DIRECCIÓN - RESPONSABLE ******************/
    
	public function registrarResponsableDireccionEstructura()
	{
	    $fechaActual = date("Y-m-d H:i:s");
        
        $resultado = array(
			'insert'    => (string) false,
			'mensaje'   => (string) "Error"
		);

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $idDireccion = $this->request->getPost('txtIDDireccionEstructuraRD') ;
        $idResponsable = $this->request->getPost('txtResponsableDireccionEstructura');
        $principal = $this->request->getPost('txtPrincipalRD');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idDireccion, 'required|trim|numeric', 'ID Dirección');
        $error .= $this->complementos->validaCampo($idResponsable, 'required|trim|numeric', 'ID Responsable');
        $error .= $this->complementos->validaCampo($principal, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Principal');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaError($message)
			);
			echo json_encode($resultado);
			EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $whereExistencia = array(
            "IDDireccion"   => $idDireccion,
            "IDResponsable" => $idResponsable
        );
        
		$responsableExistente = $this->estructuraDireccionesResponsable->where($whereExistencia)->findAll();
        
        if(count($responsableExistente)>0)
        {
            $msgExistencia .= "<li>El usuario ya fue registrado para la dirección. [CAMPO] <small>USUARIO RESPONSABLE</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaPeligro($message)
			);
			echo json_encode($resultado);
			EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */
        
        if($principal == "Y")
        {
            $dataUpdate = array (
                'Principal'         => "N",
                'UsuarioModifica'   => $this->items['id'],
                'FechaModifica'     => $fechaActual,    
                'Localhost'         => $this->request->getIPAddress()
            );
    
            $this->estructuraDireccionesResponsable->update([$idDireccion], $dataUpdate);
        }

        $data = array (
            'IDDireccion'   => $idDireccion,
            'IDResponsable' => $idResponsable,
            'Principal'     => $principal,
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $lastId = $this->estructuraDireccionesResponsable->insert($data, TRUE);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg201, "<li>Se registró al responsable exitosamente.</li>");
            
            $resultado = array(
				'insert'    => (string) true,
				'mensaje'   => (string) $this->alertas->alertaExito($message)
			);
			
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar al responsable de la dirección. Inténtelo luego.</li>");
            
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaError($message)
			);
			
        }
        
        echo json_encode($resultado);
	}

    public function recargarResponsableDireccionEstructura()
    {
        $idDireccion = $this->request->getPost('idDireccion');
        
        $listadoResponsables = $this->estructuraDireccionesResponsable->listadoResponsablesDireccion($idDireccion);
        // var_dump($listadoResponsables);exit;
	    $html = '';
	    
	    if(empty($listadoResponsables))
	    {
            $aleatorio = $this->complementos->generar_string_aleatorio(5);
    	        
	        $html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3">
	            <div class="col-12">
        	        <div class="alert alert-warning alert-border-left alert-dismissible fade show mb-xl-0" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SIN INFORMACIÓN</strong> - No se encontró responsables para la dirección seleccionada.
                    </div>
                </div>
        	</div>';
	    }
	    else
	    {
    	    foreach($listadoResponsables as $responsable)
    	    {
                $aleatorio = $this->complementos->generar_string_aleatorio(5);
    	        
    	        $html.='<div class="row col-xxl-4 col-md-4 col-12 m-0 mb-2 py-3">
    	            <div class="card border-sistema-2px" style="border-radius: 15px;">
                        <div class="card-header">
                            <button type="button" class="btn-close float-end fs-11 d-none" aria-label="Close"></button>
                            <h6 class="card-title mb-0">'.ucwords(mb_strtolower($responsable['NombreResponsable'])).'</h6>
                        </div>
                        <div class="card-body p-4 text-center">
                            <div class="mx-auto avatar-md mb-3">
                                <img src="'.base_url().'/public/images/users/user-dummy-img.jpg" alt="" class="img-fluid rounded-circle">
                            </div>
                            <h5 class="card-title mb-1">'.ucwords(mb_strtolower($responsable['CargoResponsable'])).'</h5>
                            <p class="text-muted mb-0">'.$responsable['MatriculaResponsable'].'</p>
                            <p class="text-muted mb-0">'.$responsable['UsuarioResponsable'].'</p>
                            <p class="text-muted mb-0">'.$responsable['CorreoResponsable'].'</p>
                        </div>
                        <div class="card-footer text-center d-flex justify-content-between align-items-center">
                            <button type="button" onclick="cambiarPrincipalResponsableDireccionEstructura(\''.$responsable['Principal'].'\', \''.$responsable['IDDireccion'].'\', \''.$responsable['IDResponsable'].'\')" class="px-2 py-1 d-flex justify-content-center align-items-center" style="background-color: transparent; border: none;">
                                <i class="'.($responsable['Principal'] == 'Y' ? "mdi mdi-bookmark" : "mdi mdi-bookmark-outline").'" style="font-size: 24px; color: #00913F"></i>
                            </button>
                            <button type="button" onclick="eliminarResponsableDireccionEstructura(\''.$responsable['Principal'].'\', \''.$responsable['IDDireccion'].'\', \''.$responsable['IDResponsable'].'\')" class="px-2 py-1 d-flex justify-content-center align-items-center" style="background-color: transparent; border: none;">
                                <i class="mdi mdi-delete" style="font-size: 24px; color: #C81D11"></i>
                            </button>
                        </div>
                    </div>
            	</div>';
    	    }
	    }
	    
	    echo $html;
    }
    
    public function modificarResponsableDireccionEstructura()
    {
	    $fechaActual = date("Y-m-d H:i:s");
        
        $resultado = array(
			'insert'    => (string) false,
			'mensaje'   => (string) "Error"
		);

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $idDireccion = $this->request->getPost('idDireccion') ;
        $idResponsable = $this->request->getPost('idResponsable');
        $principal = $this->request->getPost('principal');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idDireccion, 'required|trim|numeric', 'ID Dirección');
        $error .= $this->complementos->validaCampo($idResponsable, 'required|trim|numeric', 'ID Responsable');
        $error .= $this->complementos->validaCampo($principal, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Principal');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaError($message)
			);
			echo json_encode($resultado);
			EXIT;
        }
        
        /*
        * ----------------------------
        * COLOCAR A TODOS LOS USUARIOS COMO NO PRINCIPALES
        * ----------------------------
        */

        if($principal == "Y")
        {
            $dataUpdate = array (
                'Principal'         => "N",
                'UsuarioModifica'   => $this->items['id'],
                'FechaModifica'     => $fechaActual,    
                'Localhost'         => $this->request->getIPAddress()
            );
    
            $this->estructuraDireccionesResponsable->update([$idDireccion], $dataUpdate);
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */
        
        $whereUpdate = array(
            'IDDireccion'   => $idDireccion,
            'IDResponsable' => $idResponsable
        );
        
        $updatePrincipal = array (
            'Principal'     => $principal,
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $lastId = $this->estructuraDireccionesResponsable->where($whereUpdate)->set($updatePrincipal)->update();

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg201, "<li>Se modificó al responsable principal exitosamente.</li>");
            
            $resultado = array(
				'insert'    => (string) true,
				'mensaje'   => (string) $this->alertas->alertaExito($message)
			);
			
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al modificar al principal responsable de la dirección. Inténtelo luego.</li>");
            
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaError($message)
			);
			
        }
        
        echo json_encode($resultado);
    }
    
    public function eliminarResponsableDireccionEstructura()
    {
	    $fechaActual = date("Y-m-d H:i:s");
        
        $resultado = array(
			'insert'    => (string) false,
			'mensaje'   => (string) "Error"
		);

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $idDireccion = $this->request->getPost('idDireccion') ;
        $idResponsable = $this->request->getPost('idResponsable');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idDireccion, 'required|trim|numeric', 'ID Dirección');
        $error .= $this->complementos->validaCampo($idResponsable, 'required|trim|numeric', 'ID Responsable');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaError($message)
			);
			echo json_encode($resultado);
			EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */
        
        $whereUpdate = array(
            'IDDireccion'   => $idDireccion,
            'IDResponsable' => $idResponsable
        );
        
        $lastId = $this->estructuraDireccionesResponsable->where($whereUpdate)->delete();

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg201, "<li>Se eliminó al responsable exitosamente.</li>");
            
            $resultado = array(
				'insert'    => (string) true,
				'mensaje'   => (string) $this->alertas->alertaExito($message)
			);
			
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al eliminar al responsable de la dirección. Inténtelo luego.</li>");
            
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaError($message)
			);
			
        }
        
        echo json_encode($resultado);
    }

	/**************************************************************************/
	
    /**************************** ESTRUCTURA - ÁREA ***************************/
    
    public function listarAreasEstructura($idDireccion)
    {
        if(isset($this->items['id']))
        {
			if($idDireccion != "TOTAL")
			{
			    $direccion = $this->estructuraDirecciones->where('IDDireccion', $idDireccion)->first();
			}
			else
			{
			    $direccion = array();
			}
            
			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Estructura - Áreas | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Áreas',
                'previo'                    => 'listar-direcciones-estructura',
				'elementoSeleccionadoModulo'=> "Listado de Áreas",
				'subtitulo'                 => 'Áreas',
				'direccion'                 => $direccion,
				'idDireccion'               => $idDireccion
			);
			
			$data = array_merge($data, $this->items);
			
			return view('administracion/listar_estructura_areas',$data);			
		} 
		else 
		{
			return view('errors/500');
		}
    }
    
    public function areaEstructuraServerside()
    {
        if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"      => $this->items['idPerfil'],
                "IDUsuario"     => $this->items['id'],
                "IDDireccion"   => $this->request->getPost('idDireccion')
            );
            
            /* LISTAR DIRECCION */
            $dataServerside = $this->estructuraAreas->listaGeneralEstructuraArea($this->request->getPost(), $adicionales);
            
            foreach($dataServerside["data"] as $key=>$value)
            {
    			if(in_array("ESARES", $this->items['permisos']))
    			{
        			$dataServerside["data"][$key]['EstadoArea'] = '<button class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0 cambiar-estado-area-estructura" data-estado="'.$value['Estado'].'" data-id="'.$value['IDArea'].'">'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</button>';
    			}
    			else
    			{
    			    $dataServerside["data"][$key]['EstadoArea'] = '<span class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0" >'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</span>';
    			}
    			
    			$dataServerside["data"][$key]['ResponsableArea'] = $value['MatriculaResponsablePrincipal']." | ".ucwords(mb_strtolower($value['NombreResponsablePrincipal']))." ".ucwords(mb_strtolower($value['ApellidoResponsablePrincipal']));
    			
                $acciones = '';
                
                $acciones .= '<button class="badge bg-info border-0 p-2 mx-1 datos-area-estructura" data-bs-target="#informacionAreaEstructura" data-form="#formInformacionAreaEstructura" data-id="'.$value['IDArea'].'" data-accion="ver" id="ver-area" data-tooltip="tooltip" title="Ver Área">
    				<i class="mdi mdi-eye align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
    			if(in_array("UPARES", $this->items['permisos']))
    			{
    			$acciones .= '<button class="badge bg-warning border-0 p-2 mx-1 datos-area-estructura" data-bs-target="#informacionAreaEstructura" data-form="#formInformacionAreaEstructura" data-id="'.$value['IDArea'].'" data-accion="editar" id="editar-area" data-tooltip="tooltip" title="Editar Área">
    				<i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			}
    			
    			if (in_array("ADSUES", $this->items['permisos'])) 
    			{
    			$acciones .= '<a href="'.$this->items['baseUrl'].'/listar-subareas-estructura/'.$value['IDArea'].'" class="badge bg-sistema border-0 p-2 mx-1" data-tooltip="tooltip" title="Ver Subáreas">
    				<i class="mdi mdi-graph align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</a>';
    			}
    			
                $acciones .= '<button class="badge bg-rosa border-0 p-2 mx-1 responsablesAreaEstructura" data-bs-target="#usuariosResponsablesAreaEstructura" data-id="'.$value['IDArea'].'" data-tooltip="tooltip" title="Ver Responsables de Área">
    				<i class="mdi mdi-account-supervisor align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
    			
    			
                $dataServerside["data"][$key]['acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    	else
    	{
    	    $datos = [
                'draw'              => 1,
                'data'              => array(),
                'recordsTotal'      => 0,
                'recordsFiltered'   => (int) 0
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    }
    
    public function registrarAreaEstructura()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError       = TRUE;
        $direccion      = $this->request->getPost('txtIDDireccionEstructura_i');
        $area           = ucwords(mb_strtolower($this->request->getPost('txtAreaEstructura_i')));
        $observacion    = $this->request->getPost('txtObservacionAreaEstructura_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($direccion, 'required|trim|number', 'ID Dirección');
        $error .= $this->complementos->validaCampo($area, 'required|trim|minlength[1]|maxlength[100]', 'Área');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $whereArea = array(
            'IDDireccion'  => $direccion,
            'Area'   => $area
        );
        
		$areaExistente = $this->estructuraAreas->where($whereArea)->findAll();
        
        if(count($areaExistente)>0)
        {
            $msgExistencia .= "<li>El área fue registrado. [CAMPO] <small>ÁREA</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'IDDireccion'       => $direccion,
            'Area'              => $area,
            'Observacion'       => $observacion,
            'UsuarioCrea'       => $this->items['id'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'Estado'            => 'A',
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,    
            'MotivoEstado'      => 'Área creada.'
        );

        $lastId = $this->estructuraAreas->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $area);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

	public function obtenerDatosAreaEstructura() 
	{
	    if (isset($this->items['id']))
	    {
    		/*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
    		*/
    
    		$msjError = TRUE;
    		$idArea = $this->request->getPost('idArea');
    
    		/*
            * ----------------------------
            * VALIDACIÓN DE REQUERIMIENTOS
            * ----------------------------
            */
    
    		$error = '';
    		$error .= $this->complementos->validaCampo($idArea, 'trim', 'ID');
    
    		if ($error != '') {
    			$message = sprintf($this->mensajeError->msg201, $error);
    			echo $this->alertas->alertaError($message);
    			exit;
    		}
    
    		/*
            * -------------
            * BASE DE DATOS
            * -------------
            */
    		
    		$datosArea = $this->estructuraAreas->where('IDArea', $idArea)->first();
    
    		if(!empty($datosArea))
    		{
    			$resultado = array(
    				'idarea'        => (string) $idArea,
    				'area'          => (string) $datosArea['Area'],
    				'observacion'   => (string) $datosArea['Observacion']
    			);
    		} 
    		else 
    		{
    			$resultado = array(
    				'descripcion' => 0
    			);
    		}
    
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado);
	    }
	    else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}
	
    public function modificarAreaEstructura($idArea)
    {

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError       = TRUE;
        $area           = ucwords(mb_strtolower($this->request->getPost('txtAreaEstructura_i')));
        $observacion    = $this->request->getPost('txtObservacionAreaEstructura_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($area, 'required|trim|minlength[1]|maxlength[50]', 'Área');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */
        
        $data = array (
            'Area'              => $area,
            'Observacion'       => $observacion,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->estructuraAreas->update([$idArea], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idArea);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function modificarEstadoAreaEstructura()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idArea = $this->request->getPost('idArea');
        $estado = $this->request->getPost('estado');
        $motivo = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idArea, 'required|trim|numeric', 'ID Area');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'Estado'            => $estado,
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,    
            'MotivoEstado'      => $motivo
        );
        
        $lastId = $this->estructuraAreas->update([$idArea], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idArea);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
	public function listadoAreasEstructura()
	{
	    if (isset($this->items['id']))
	    {
        	/*
            * ----------------------
            * OBTIENE Y VALIDA DATOS
            * ----------------------
            */
            
    		$idDireccion = $this->request->getPost('idDireccion');
    
            if($idDireccion == 'TOTAL')
            {
                $listadoAreas = $this->estructuraAreas->findAll();
            }
            else
            {
                $whereAreas = array('IDDireccion' => $idDireccion);
                $listadoAreas = $this->estructuraAreas->where($whereAreas)->findAll();
            }
            
            $areas=array();
    
    		if (!empty($listadoAreas)) {
                foreach ($listadoAreas as $items) {
                    $areas[] = array(
    					'id' => (string) $items['IDArea'],
             	        'text' => (string) $items['Area'],
                    );
                }
    
                $resultado = array(
    				'listadoAreas' => json_encode($areas)
    			);
            } else {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
    
            /*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
            echo json_encode($resultado, JSON_NUMERIC_CHECK);
	    }
	    else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}
	
	/**************************************************************************/
	
    /********************* ESTRUCTURA - ÁREA - RESPONSABLE ********************/
    	
	public function registrarResponsableAreaEstructura()
	{
	    $fechaActual = date("Y-m-d H:i:s");
        
        $resultado = array(
			'insert'    => (string) false,
			'mensaje'   => (string) "Error"
		);

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $idArea         = $this->request->getPost('txtIDAreaEstructuraRA') ;
        $idResponsable  = $this->request->getPost('txtResponsableAreaEstructura');
        $principal      = $this->request->getPost('txtPrincipalRA');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idArea, 'required|trim|numeric', 'ID Área');
        $error .= $this->complementos->validaCampo($idResponsable, 'required|trim|numeric', 'ID Responsable');
        $error .= $this->complementos->validaCampo($principal, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Principal');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaError($message)
			);
			echo json_encode($resultado);
			EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $whereExistencia = array(
            "IDArea"        => $idArea,
            "IDResponsable" => $idResponsable
        );
        
		$responsableExistente = $this->estructuraAreasResponsable->where($whereExistencia)->findAll();
        
        if(count($responsableExistente)>0)
        {
            $msgExistencia .= "<li>El usuario ya fue registrado para el área. [CAMPO] <small>USUARIO RESPONSABLE</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaPeligro($message)
			);
			echo json_encode($resultado);
			EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */
        
        if($principal == "Y")
        {
            $dataUpdate = array (
                'Principal'         => "N",
                'UsuarioModifica'   => $this->items['id'],
                'FechaModifica'     => $fechaActual,    
                'Localhost'         => $this->request->getIPAddress()
            );
    
            $this->estructuraAreasResponsable->update([$idArea], $dataUpdate);
        }

        $data = array (
            'IDArea'        => $idArea,
            'IDResponsable' => $idResponsable,
            'Principal'     => $principal,
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $lastId = $this->estructuraAreasResponsable->insert($data, TRUE);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg201, "<li>Se registró al responsable exitosamente.</li>");
            
            $resultado = array(
				'insert'    => (string) true,
				'mensaje'   => (string) $this->alertas->alertaExito($message)
			);
			
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar al responsable del área. Inténtelo luego.</li>");
            
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaError($message)
			);
			
        }
        
        echo json_encode($resultado);
	}

    public function recargarResponsableAreaEstructura()
    {
        $idArea = $this->request->getPost('idArea');
        
        $listadoResponsables = $this->estructuraAreasResponsable->listadoResponsablesArea($idArea);
        
	    $html = '';
	    
	    if(empty($listadoResponsables))
	    {
            $aleatorio = $this->complementos->generar_string_aleatorio(5);
    	        
	        $html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3">
	            <div class="col-12">
        	        <div class="alert alert-warning alert-border-left alert-dismissible fade show mb-xl-0" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SIN INFORMACIÓN</strong> - No se encontró responsables para el área seleccionada.
                    </div>
                </div>
        	</div>';
	    }
	    else
	    {
    	    foreach($listadoResponsables as $responsable)
    	    {
                $aleatorio = $this->complementos->generar_string_aleatorio(5);
    	        
    	        $html.='<div class="row col-xxl-4 col-md-4 col-12 m-0 mb-2 py-3">
    	            <div class="card border-sistema-2px" style="border-radius: 15px;">
                        <div class="card-header">
                            <button type="button" class="btn-close float-end fs-11 d-none" aria-label="Close"></button>
                            <h6 class="card-title mb-0">'.ucwords(mb_strtolower($responsable['NombreResponsable'])).'</h6>
                        </div>
                        <div class="card-body p-4 text-center">
                            <div class="mx-auto avatar-md mb-3">
                                <img src="'.base_url().'/public/images/users/user-dummy-img.jpg" alt="" class="img-fluid rounded-circle">
                            </div>
                            <h5 class="card-title mb-1">'.ucwords(mb_strtolower($responsable['CargoResponsable'])).'</h5>
                            <p class="text-muted mb-0">'.$responsable['MatriculaResponsable'].'</p>
                            <p class="text-muted mb-0">'.$responsable['UsuarioResponsable'].'</p>
                            <p class="text-muted mb-0">'.$responsable['CorreoResponsable'].'</p>
                        </div>
                        <div class="card-footer text-center d-flex justify-content-between align-items-center">
                            <button type="button" onclick="cambiarPrincipalResponsableAreaEstructura(\''.$responsable['Principal'].'\', \''.$responsable['IDArea'].'\', \''.$responsable['IDResponsable'].'\')" class="px-2 py-1 d-flex justify-content-center align-items-center" style="background-color: transparent; border: none;">
                                <i class="'.($responsable['Principal'] == 'Y' ? "mdi mdi-bookmark" : "mdi mdi-bookmark-outline").'" style="font-size: 24px; color: #00913F"></i>
                            </button>
                            <button type="button" onclick="eliminarResponsableAreaEstructura(\''.$responsable['Principal'].'\', \''.$responsable['IDArea'].'\', \''.$responsable['IDResponsable'].'\')" class="px-2 py-1 d-flex justify-content-center align-items-center" style="background-color: transparent; border: none;">
                                <i class="mdi mdi-delete" style="font-size: 24px; color: #C81D11"></i>
                            </button>
                        </div>
                    </div>
            	</div>';
    	    }
	    }
	    
	    echo $html;
    }
    
    public function modificarResponsableAreaEstructura()
    {
	    $fechaActual = date("Y-m-d H:i:s");
        
        $resultado = array(
			'insert'    => (string) false,
			'mensaje'   => (string) "Error"
		);

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $idArea         = $this->request->getPost('idArea') ;
        $idResponsable  = $this->request->getPost('idResponsable');
        $principal      = $this->request->getPost('principal');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idArea, 'required|trim|numeric', 'ID Área');
        $error .= $this->complementos->validaCampo($idResponsable, 'required|trim|numeric', 'ID Responsable');
        $error .= $this->complementos->validaCampo($principal, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Principal');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaError($message)
			);
			echo json_encode($resultado);
			EXIT;
        }
        
        /*
        * ----------------------------
        * COLOCAR A TODOS LOS USUARIOS COMO NO PRINCIPALES
        * ----------------------------
        */

        if($principal == "Y")
        {
            $dataUpdate = array (
                'Principal'         => "N",
                'UsuarioModifica'   => $this->items['id'],
                'FechaModifica'     => $fechaActual,    
                'Localhost'         => $this->request->getIPAddress()
            );
    
            $this->estructuraAreasResponsable->update([$idArea], $dataUpdate);
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */
        
        $whereUpdate = array(
            'IDArea'        => $idArea,
            'IDResponsable' => $idResponsable
        );
        
        $updatePrincipal = array (
            'Principal'     => $principal,
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $lastId = $this->estructuraAreasResponsable->where($whereUpdate)->set($updatePrincipal)->update();

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg201, "<li>Se modificó al responsable principal exitosamente.</li>");
            
            $resultado = array(
				'insert'    => (string) true,
				'mensaje'   => (string) $this->alertas->alertaExito($message)
			);
			
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al modificar al principal responsable del área. Inténtelo luego.</li>");
            
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaError($message)
			);
			
        }
        
        echo json_encode($resultado);
    }
    
    public function eliminarResponsableAreaEstructura()
    {
	    $fechaActual = date("Y-m-d H:i:s");
        
        $resultado = array(
			'insert'    => (string) false,
			'mensaje'   => (string) "Error"
		);

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $idArea = $this->request->getPost('idArea') ;
        $idResponsable = $this->request->getPost('idResponsable');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idArea, 'required|trim|numeric', 'ID Área');
        $error .= $this->complementos->validaCampo($idResponsable, 'required|trim|numeric', 'ID Responsable');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaError($message)
			);
			echo json_encode($resultado);
			EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */
        
        $whereUpdate = array(
            'IDArea'        => $idArea,
            'IDResponsable' => $idResponsable
        );
        
        $lastId = $this->estructuraAreasResponsable->where($whereUpdate)->delete();

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg201, "<li>Se eliminó al responsable exitosamente.</li>");
            
            $resultado = array(
				'insert'    => (string) true,
				'mensaje'   => (string) $this->alertas->alertaExito($message)
			);
			
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al eliminar al responsable del área. Inténtelo luego.</li>");
            
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaError($message)
			);
			
        }
        
        echo json_encode($resultado);
    }

	/**************************************************************************/
	
    /************************** ESTRUCTURA - SUBÁREA **************************/
    
    public function listarSubareasEstructura($idArea)
    {
        if(isset($this->items['id']))
        {
			if($idArea != "TOTAL")
			{
			    $area = $this->estructuraAreas->obtenerArea($idArea);
			    $idDireccion = $area["IDDireccion"];
			}
			else
			{
			    $area = array();
			    $idDireccion = "TOTAL";
			}
            
			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Estructura - Subáreas | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Subáreas',
                'previo'                    => 'listar-areas-estructura/'.$idDireccion,
				'elementoSeleccionadoModulo'=> "Listado de Subáreas",
				'subtitulo'                 => 'Subáreas',
				'area'                      => $area,
				'idArea'                    => $idArea
			);
			
			$data = array_merge($data, $this->items);
			
			return view('administracion/listar_estructura_subareas',$data);			
		} 
		else 
		{
			return view('errors/500');
		}
    }
    
    public function subareaEstructuraServerside()
    {
        if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"      => $this->items['idPerfil'],
                "IDUsuario"     => $this->items['id'],
                "IDArea"        => $this->request->getPost('idArea')
            );
            
            /* LISTAR DIRECCION */
            $dataServerside = $this->estructuraSubareas->listaGeneralEstructuraSubarea($this->request->getPost(), $adicionales);
            
            foreach($dataServerside["data"] as $key=>$value)
            {
    			if(in_array("ESSUES", $this->items['permisos']))
    			{
        			$dataServerside["data"][$key]['EstadoSubarea'] = '<button class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0 cambiar-estado-subarea-estructura" data-estado="'.$value['Estado'].'" data-id="'.$value['IDSubarea'].'">'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</button>';
    			}
    			else
    			{
    			    $dataServerside["data"][$key]['EstadoSubarea'] = '<span class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0" >'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</span>';
    			}
    			
    			$dataServerside["data"][$key]['ResponsableSubarea'] = $value['MatriculaResponsablePrincipal']." | ".ucwords(mb_strtolower($value['NombreResponsablePrincipal']))." ".ucwords(mb_strtolower($value['ApellidoResponsablePrincipal']));
    			
                $acciones = '';
                
                $acciones .= '<button class="badge bg-info border-0 p-2 mx-1 datos-subarea-estructura" data-bs-target="#informacionSubareaEstructura" data-form="#formInformacionSubareaEstructura" data-id="'.$value['IDSubarea'].'" data-accion="ver" id="ver-subarea" data-tooltip="tooltip" title="Ver Subárea">
    				<i class="mdi mdi-eye align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
    			if(in_array("UPSUES", $this->items['permisos']))
    			{
    			$acciones .= '<button class="badge bg-warning border-0 p-2 mx-1 datos-subarea-estructura" data-bs-target="#informacionSubareaEstructura" data-form="#formInformacionSubareaEstructura" data-id="'.$value['IDSubarea'].'" data-accion="editar" id="editar-subarea" data-tooltip="tooltip" title="Editar Subárea">
    				<i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			}
    			
    			if (in_array("ASDESU", $this->items['permisos'])) 
    			{
    			$acciones .= '<a href="'.$this->items['baseUrl'].'/listar-delegaciones-subarea-estructura/'.$value['IDSubarea'].'" class="badge bg-sistema border-0 p-2 mx-1" data-tooltip="tooltip" title="Ver Delegaciones">
    				<i class="mdi mdi-domain align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</a>';
    			}
    			
                $acciones .= '<button class="badge bg-rosa border-0 p-2 mx-1 responsablesSubareaEstructura" data-bs-target="#usuariosResponsablesSubareaEstructura" data-id="'.$value['IDSubarea'].'" data-tooltip="tooltip" title="Ver Responsables de Subárea">
    				<i class="mdi mdi-account-supervisor align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
                $dataServerside["data"][$key]['acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    	else
    	{
    	    $datos = [
                'draw'              => 1,
                'data'              => array(),
                'recordsTotal'      => 0,
                'recordsFiltered'   => (int) 0
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    }
    
    public function registrarSubareaEstructura()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError       = TRUE;
        $area           = $this->request->getPost('txtIDAreaEstructura_i');
        $subarea        = ucwords(mb_strtolower($this->request->getPost('txtSubareaEstructura_i')));
        $correo    = $this->request->getPost('txtCorreoSubareaEstructura_i');
        $observacion    = $this->request->getPost('txtObservacionSubareaEstructura_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($area, 'required|trim|number', 'ID Área');
        $error .= $this->complementos->validaCampo($subarea, 'required|trim|minlength[1]|maxlength[100]', 'Subárea');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $whereSubarea = array(
            'IDArea'    => $area,
            'Subarea'   => $subarea
        );
        
		$subareaExistente = $this->estructuraSubareas->where($whereSubarea)->findAll();
        
        if(count($subareaExistente)>0)
        {
            $msgExistencia .= "<li>La subárea fue registrada. [CAMPO] <small>SUBÁREA</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'IDArea'            => $area,
            'Subarea'           => $subarea,
            'Correo'            => $correo,
            'Observacion'       => $observacion,
            'UsuarioCrea'       => $this->items['id'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'Estado'            => 'A',
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,    
            'MotivoEstado'      => 'Subárea creada.'
        );

        $lastId = $this->estructuraSubareas->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $subarea);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

	public function obtenerDatosSubareaEstructura() 
	{
	    if (isset($this->items['id']))
	    {
    		/*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
    		*/
    
    		$msjError = TRUE;
    		$idSubarea = $this->request->getPost('idSubarea');
    
    		/*
            * ----------------------------
            * VALIDACIÓN DE REQUERIMIENTOS
            * ----------------------------
            */
    
    		$error = '';
    		$error .= $this->complementos->validaCampo($idSubarea, 'trim', 'ID');
    
    		if ($error != '') {
    			$message = sprintf($this->mensajeError->msg201, $error);
    			echo $this->alertas->alertaError($message);
    			exit;
    		}
    
    		/*
            * -------------
            * BASE DE DATOS
            * -------------
            */
    		
    		$datosSubarea = $this->estructuraSubareas->where('IDSubarea', $idSubarea)->first();
    
    		if(!empty($datosSubarea))
    		{
    			$resultado = array(
    				'idsubarea'     => (string) $idSubarea,
    				'subarea'       => (string) $datosSubarea['Subarea'],
    				'correo'        => (string) $datosSubarea['Correo'],
    				'observacion'   => (string) $datosSubarea['Observacion']
    			);
    		} 
    		else 
    		{
    			$resultado = array(
    				'descripcion' => 0
    			);
    		}
    
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado);
	    }
	    else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
	}
	
    public function modificarSubareaEstructura($idSubarea)
    {

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError       = TRUE;
        $subarea        = ucwords(mb_strtolower($this->request->getPost('txtSubareaEstructura_i')));
        $observacion    = $this->request->getPost('txtObservacionSubareaEstructura_i');
        $correo         = $this->request->getPost('txtCorreoSubareaEstructura_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($subarea, 'required|trim|minlength[1]|maxlength[100]', 'Subárea');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */
        
        $data = array (
            'Subarea'           => $subarea,
            'Correo'            => $correo,
            'Observacion'       => $observacion,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->estructuraSubareas->update([$idSubarea], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idSubarea);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function modificarEstadoSubareaEstructura()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idSubarea = $this->request->getPost('idSubarea');
        $estado = $this->request->getPost('estado');
        $motivo = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idSubarea, 'required|trim|numeric', 'ID Subárea');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'Estado'            => $estado,
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,    
            'MotivoEstado'      => $motivo
        );
        
        $lastId = $this->estructuraSubareas->update([$idSubarea], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idSubarea);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function listadoSubareasEstructura()
    {
        if (isset($this->items['id']))
	    {
            /*
            * ----------------------
            * OBTIENE Y VALIDA DATOS
            * ----------------------
            */
            
    		$idArea = $this->request->getPost('idArea');
    
            if($idArea == 'TOTAL')
            {
                $listadoSubareas = $this->estructuraSubareas->findAll();
            }
            else
            {
                $whereSubareas = array('IDArea' => $idArea);
                $listadoSubareas = $this->estructuraSubareas->where($whereSubareas)->findAll();
            }
            
            $subareas=array();
    
    		if (!empty($listadoSubareas)) {
                foreach ($listadoSubareas as $items) {
                    $subareas[] = array(
    					'id' => (string) $items['IDSubarea'],
             	        'text' => (string) $items['Subarea'],
                    );
                }
    
                $resultado = array(
    				'listadoSubareas' => json_encode($subareas)
    			);
            } else {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
    
            /*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
            echo json_encode($resultado, JSON_NUMERIC_CHECK);
        }
	    else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
    }
    
	/**************************************************************************/
	
    /******************* ESTRUCTURA - SUBÁREA - RESPONSABLE *******************/
    	
	public function registrarResponsableSubareaEstructura()
	{
	    $fechaActual = date("Y-m-d H:i:s");
        
        $resultado = array(
			'insert'    => (string) false,
			'mensaje'   => (string) "Error"
		);

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $idSubarea      = $this->request->getPost('txtIDSubareaEstructuraRA') ;
        $idResponsable  = $this->request->getPost('txtResponsableSubareaEstructura');
        $principal      = $this->request->getPost('txtPrincipalRS');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idSubarea, 'required|trim|numeric', 'ID Subárea');
        $error .= $this->complementos->validaCampo($idResponsable, 'required|trim|numeric', 'ID Responsable');
        $error .= $this->complementos->validaCampo($principal, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Principal');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaError($message)
			);
			echo json_encode($resultado);
			EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $whereExistencia = array(
            "IDSubarea"     => $idSubarea,
            "IDResponsable" => $idResponsable
        );
        
		$responsableExistente = $this->estructuraSubareasResponsable->where($whereExistencia)->findAll();
        
        if(count($responsableExistente)>0)
        {
            $msgExistencia .= "<li>El usuario ya fue registrado para la subárea. [CAMPO] <small>USUARIO RESPONSABLE</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaPeligro($message)
			);
			echo json_encode($resultado);
			EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */
        
        if($principal == "Y")
        {
            $dataUpdate = array (
                'Principal'         => "N",
                'UsuarioModifica'   => $this->items['id'],
                'FechaModifica'     => $fechaActual,    
                'Localhost'         => $this->request->getIPAddress()
            );
    
            $this->estructuraSubareasResponsable->update([$idSubarea], $dataUpdate);
        }

        $data = array (
            'IDSubarea'     => $idSubarea,
            'IDResponsable' => $idResponsable,
            'Principal'     => $principal,
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $lastId = $this->estructuraSubareasResponsable->insert($data, TRUE);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg201, "<li>Se registró al responsable exitosamente.</li>");
            
            $resultado = array(
				'insert'    => (string) true,
				'mensaje'   => (string) $this->alertas->alertaExito($message)
			);
			
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar al responsable de la subárea. Inténtelo luego.</li>");
            
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaError($message)
			);
			
        }
        
        echo json_encode($resultado);
	}

    public function recargarResponsableSubareaEstructura()
    {
        $idSubarea = $this->request->getPost('idSubarea');
        
        $listadoResponsables = $this->estructuraSubareasResponsable->listadoResponsablesSubarea($idSubarea);
        
	    $html = '';
	    
	    if(empty($listadoResponsables))
	    {
            $aleatorio = $this->complementos->generar_string_aleatorio(5);
    	        
	        $html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3">
	            <div class="col-12">
        	        <div class="alert alert-warning alert-border-left alert-dismissible fade show mb-xl-0" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SIN INFORMACIÓN</strong> - No se encontró responsables para la subárea seleccionada.
                    </div>
                </div>
        	</div>';
	    }
	    else
	    {
    	    foreach($listadoResponsables as $responsable)
    	    {
                $aleatorio = $this->complementos->generar_string_aleatorio(5);
    	        
    	        $html.='<div class="row col-xxl-4 col-md-4 col-12 m-0 mb-2 py-3">
    	            <div class="card border-sistema-2px" style="border-radius: 15px;">
                        <div class="card-header">
                            <button type="button" class="btn-close float-end fs-11 d-none" aria-label="Close"></button>
                            <h6 class="card-title mb-0">'.ucwords(mb_strtolower($responsable['NombreResponsable'])).'</h6>
                        </div>
                        <div class="card-body p-4 text-center">
                            <div class="mx-auto avatar-md mb-3">
                                <img src="'.base_url().'/public/images/users/user-dummy-img.jpg" alt="" class="img-fluid rounded-circle">
                            </div>
                            <h5 class="card-title mb-1">'.ucwords(mb_strtolower($responsable['CargoResponsable'])).'</h5>
                            <p class="text-muted mb-0">'.$responsable['MatriculaResponsable'].'</p>
                            <p class="text-muted mb-0">'.$responsable['UsuarioResponsable'].'</p>
                            <p class="text-muted mb-0">'.$responsable['CorreoResponsable'].'</p>
                        </div>
                        <div class="card-footer text-center d-flex justify-content-between align-items-center">
                            <button type="button" onclick="cambiarPrincipalResponsableSubareaEstructura(\''.$responsable['Principal'].'\', \''.$responsable['IDSubarea'].'\', \''.$responsable['IDResponsable'].'\')" class="px-2 py-1 d-flex justify-content-center align-items-center" style="background-color: transparent; border: none;">
                                <i class="'.($responsable['Principal'] == 'Y' ? "mdi mdi-bookmark" : "mdi mdi-bookmark-outline").'" style="font-size: 24px; color: #00913F"></i>
                            </button>
                            <button type="button" onclick="eliminarResponsableSubareaEstructura(\''.$responsable['Principal'].'\', \''.$responsable['IDSubarea'].'\', \''.$responsable['IDResponsable'].'\')" class="px-2 py-1 d-flex justify-content-center align-items-center" style="background-color: transparent; border: none;">
                                <i class="mdi mdi-delete" style="font-size: 24px; color: #C81D11"></i>
                            </button>
                        </div>
                    </div>
            	</div>';
    	    }
	    }
	    
	    echo $html;
    }
    
    public function modificarResponsableSubareaEstructura()
    {
	    $fechaActual = date("Y-m-d H:i:s");
        
        $resultado = array(
			'insert'    => (string) false,
			'mensaje'   => (string) "Error"
		);

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $idSubarea      = $this->request->getPost('idSubarea') ;
        $idResponsable  = $this->request->getPost('idResponsable');
        $principal      = $this->request->getPost('principal');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idSubarea, 'required|trim|numeric', 'ID Subárea');
        $error .= $this->complementos->validaCampo($idResponsable, 'required|trim|numeric', 'ID Responsable');
        $error .= $this->complementos->validaCampo($principal, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Principal');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaError($message)
			);
			echo json_encode($resultado);
			EXIT;
        }
        
        /*
        * ----------------------------
        * COLOCAR A TODOS LOS USUARIOS COMO NO PRINCIPALES
        * ----------------------------
        */

        if($principal == "Y")
        {
            $dataUpdate = array (
                'Principal'         => "N",
                'UsuarioModifica'   => $this->items['id'],
                'FechaModifica'     => $fechaActual,    
                'Localhost'         => $this->request->getIPAddress()
            );
    
            $this->estructuraSubareasResponsable->update([$idSubarea], $dataUpdate);
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */
        
        $whereUpdate = array(
            'IDSubarea'     => $idSubarea,
            'IDResponsable' => $idResponsable
        );
        
        $updatePrincipal = array (
            'Principal'     => $principal,
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $lastId = $this->estructuraSubareasResponsable->where($whereUpdate)->set($updatePrincipal)->update();

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg201, "<li>Se modificó al responsable principal exitosamente.</li>");
            
            $resultado = array(
				'insert'    => (string) true,
				'mensaje'   => (string) $this->alertas->alertaExito($message)
			);
			
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al modificar al principal responsable de la subárea. Inténtelo luego.</li>");
            
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaError($message)
			);
			
        }
        
        echo json_encode($resultado);
    }
    
    public function eliminarResponsableSubareareaEstructura()
    {
	    $fechaActual = date("Y-m-d H:i:s");
        
        $resultado = array(
			'insert'    => (string) false,
			'mensaje'   => (string) "Error"
		);

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $idSubarea = $this->request->getPost('idSubarea') ;
        $idResponsable = $this->request->getPost('idResponsable');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idSubarea, 'required|trim|numeric', 'ID Subárea');
        $error .= $this->complementos->validaCampo($idResponsable, 'required|trim|numeric', 'ID Responsable');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaError($message)
			);
			echo json_encode($resultado);
			EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */
        
        $whereUpdate = array(
            'IDSubarea'     => $idSubarea,
            'IDResponsable' => $idResponsable
        );
        
        $lastId = $this->estructuraSubareasResponsable->where($whereUpdate)->delete();

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg201, "<li>Se eliminó al responsable exitosamente.</li>");
            
            $resultado = array(
				'insert'    => (string) true,
				'mensaje'   => (string) $this->alertas->alertaExito($message)
			);
			
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al eliminar al responsable de la subárea. Inténtelo luego.</li>");
            
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaError($message)
			);
			
        }
        
        echo json_encode($resultado);
    }

	/**************************************************************************/
	
    /******************* ESTRUCTURA - SUBÁREA - DELEGACIONES ******************/
    
    public function listarDelegacionesSubareaEstructura($idSubarea)
    {
        if(isset($this->items['id']))
        {
			/* BUSCAR ACCIONES */
			$subarea            = $this->estructuraSubareas->obtenerSubarea($idSubarea);
			$listaDelegaciones  = $this->estructuraSubareaDelegaciones->listarDelegacionesXSubarea($idSubarea);
            
			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Estructura - Subáreas - Delegaciones | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Delegaciones asociadas',
                'previo'                    => 'listar-subareas-estructura/'.$subarea['IDArea'],
				'elementoSeleccionadoModulo'=> "Listado de Delegaciones",
				'subtitulo'                 => 'Delegaciones',
				'subarea'                   => $subarea,
				'idSubareaDel'              => $idSubarea,
				'listaDelegaciones'         => $listaDelegaciones
			);
			
			$data = array_merge($data, $this->items);
			
			return view('administracion/listar_estructura_subarea_delegaciones',$data);			
		} 
		else 
		{
			return view('errors/500');	
		}
    }
    
    public function asociarDelegacionSubareaEstructura()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $idDelegacion = $this->request->getPost('idDelegacion');
        $idSubarea = $this->request->getPost('idSubarea');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idDelegacion, 'required|trim|number', 'ID Delegación');
        $error .= $this->complementos->validaCampo($idSubarea, 'required|trim|number', 'ID Subárea');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $whereCC = array(
            'IDSubarea'     => $idSubarea,
            'IDDelegacion'  => $idDelegacion
        );
        
		$combinacionExistente = $this->estructuraSubareaDelegaciones->where($whereCC)->findAll();
		
        if(count($combinacionExistente)>0)
        {
            $msgExistencia .= "<li>La delegación ya fue agregada a la subárea. [CAMPO] <small>DELEGACIÓN</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'IDSubarea'         => $idSubarea, 
            'IDDelegacion'      => $idDelegacion,
            'UsuarioRegistra'   => $this->items['id'],
            'FechaRegistra'     => $fechaActual,
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->estructuraSubareaDelegaciones->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $idDelegacion);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function eliminarDelegacionSubareaEstructura()
    {
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $idSubarea = $this->request->getPost('idSubarea') ;
        $idDelegacion = $this->request->getPost('idDelegacion');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idSubarea, 'required|trim|number', 'ID Subárea');
        $error .= $this->complementos->validaCampo($idDelegacion, 'required|trim|number', 'ID Delegación');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $whereDelete = array (
            'IDSubarea'     => $idSubarea, 
            'IDDelegacion'  => $idDelegacion
        );

        $lastId = $this->estructuraSubareaDelegaciones->where($whereDelete)->delete();

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg504, $idDelegacion);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

    public function listadoDelegacionSubareaEstructura()
    {
        /*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        
		$idSubarea = $this->request->getPost('idSubarea');

        if($idSubarea == 'TOTAL')
        {
            $listadoDelegaciones = $this->estructuraDelegaciones->findAll();
        }
        else
        {
            $listadoDelegaciones = $this->estructuraSubareaDelegaciones->listarDelegacionesXSubarea($idSubarea);
        }
        
        $delegaciones=array();

		if (!empty($listadoDelegaciones)) {
            foreach ($listadoDelegaciones as $items) {
                $delegaciones[] = array(
					'id' => (string) $items['IDDelegacion'],
         	        'text' => (string) $items['CC'].'-'.$items['LN'].' | '.$items['Delegacion'],
                );
            }

            $resultado = array(
				'listadoDelegaciones' => json_encode($delegaciones)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}
		
        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);
    }
    
	/**************************************************************************/
	
    /******************************** GRUPO TRABAJO ********************************/
    
    public function listadoUsuarioSubareasEstructura()
    {
        /*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        
		$idSubArea = $this->request->getPost('idSubArea'); 

        if($idSubArea == 'TOTAL')
        {
            $listadoUsuariosSubareas = $this->usuarioModelo->findAll();
        }
        else
        {
            $whereSubareas = array('IDSubarea' => $idSubArea);
            $listadoUsuariosSubareas = $this->usuarioModelo->where($whereSubareas)->findAll();
        }
        
        $usuariosSubareas=array();

		if (!empty($listadoUsuariosSubareas)) {
            foreach ($listadoUsuariosSubareas as $items) {
                $usuariosSubareas[] = array(
					'id' => (string) $items['IdUsuario'],
         	        'text' => (string) $items['Matricula'].' | '.$items['Nombres'].' '.$items['Apellidos'],
                );
            }

            $resultado = array(
				'listadoUsuariosSubareas' => json_encode($usuariosSubareas)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);
    }
	
}