<?php

use CodeIgniter\Router\RouteCollection;
$routes->get('test-controller', 'TestController::index');
// $routes->add('test', function() {
//     return 'Ruta de prueba funcionando';
// });
/**
 * @var RouteCollection $routes
 */
// $routes->get('/', 'Home::index');
$routes->set404Override(function()
{
    echo view('errors/404');
});
/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.
$routes->get('/', 'Acceso::login');

/* ACCESO */
$routes->add('entrar', 'Acceso::entrar');
$routes->add('salir','Acceso::salir');
$routes->add('iniciar-sesion','Acceso::login');
$routes->add('cambiar-password', 'Acceso::cambiarPasswordUsuario');

/* ADMINISTRACIÓN */
$routes->add('descargatxt/(:any)','Administracion::descargatxt/$1');/* NUEVO */

$routes->add('listar-perfiles','Administracion::listarPerfiles');/* NUEVO */
$routes->add('registrar-perfil','Administracion::registrarPerfil');/* NUEVO */
$routes->add('listado-perfil-select','Administracion::listadoPerfilesSelect');/* NUEVO */
$routes->add('obtener-datos-perfil','Administracion::obtenerDatosPerfil');/* NUEVO */
$routes->add('actualizar-perfil/(:any)','Administracion::actualizarPerfil/$1');/* NUEVO */
$routes->add('cambiar-estado-perfil','Administracion::modificarEstadoPerfil');/* NUEVO */
$routes->add('listado-perfiles','Administracion::listadoPerfiles');/* NUEVO */

$routes->add('listar-permisos-perfil/(:any)','Administracion::listarPermisosPerfil/$1');/* NUEVO */
$routes->add('grabar-permisos-perfil/(:any)','Administracion::guardarPermisosPerfil/$1');/* NUEVO */
$routes->add('listar-rutas-perfil/(:any)','Administracion::listarRutasPerfil/$1');/* NUEVO */
$routes->add('grabar-rutas-perfil/(:any)','Administracion::guardarRutasPerfil/$1');/* NUEVO */

$routes->add('obtener-cabecera','Administracion::obtenerCabecera');/* NUEVO */
$routes->add('listar-modulos','Administracion::listarModulos');/* NUEVO */
$routes->add('registrar-modulo','Administracion::registrarModulo');/* NUEVO */
$routes->add('cambiar-estado-modulo','Administracion::modificarEstadoModulo');/* NUEVO */
$routes->add('obtener-datos-modulo','Administracion::obtenerDatosModulo');/* NUEVO */
$routes->add('actualizar-modulo/(:any)','Administracion::modificarModulo/$1');/* NUEVO */
$routes->add('listar-rutas-modulo/(:any)','Administracion::listarRutasModulo/$1');/* NUEVO */
$routes->add('grabar-ruta/(:any)','Administracion::guardarRutaModulo/$1');/* NUEVO */
$routes->add('obtener-datos-ruta-modulo','Administracion::obtenerDatosRutaModulo');/* NUEVO */
$routes->add('actualizar-ruta-modulo/(:any)','Administracion::modificarRutaModulo/$1');/* NUEVO */
$routes->add('cambiar-estado-ruta-modulo','Administracion::modificarEstadoRutaModulo');/* NUEVO */
$routes->add('listar-acciones-modulo/(:any)','Administracion::listarAccionesModulo/$1');/* NUEVO */
$routes->add('grabar-accion/(:any)','Administracion::guardarAccionModulo/$1');/* NUEVO */

$routes->add('listar-sistemas','Administracion::listarSistemas');/* NUEVO */
$routes->add('registrar-sistema','Administracion::registrarSistema');/* NUEVO */
$routes->add('obtener-datos-sistema','Administracion::obtenerDatosSistema');/* NUEVO */
$routes->add('actualizar-sistema/(:any)','Administracion::actualizarSistema/$1');/* NUEVO */
$routes->add('cambiar-estado-sistema','Administracion::modificarEstadoSistema');/* NUEVO */

$routes->add('listar-cargos','Administracion::listarCargos');/* NUEVO */
$routes->add('cargos-serverside','Administracion::cargosServerside');/* NUEVO */
$routes->add('registrar-cargo','Administracion::registrarCargo'); /* NUEVO */
$routes->add('obtener-datos-cargo','Administracion::obtenerDatosCargo');/* NUEVO */
$routes->add('actualizar-cargo/(:any)','Administracion::actualizarCargo/$1');/* NUEVO */
$routes->add('cambiar-estado-cargo','Administracion::modificarEstadoCargo');/* NUEVO */
$routes->add('listado-cargos','Administracion::listadoCargos');/* NUEVO */

$routes->add('listar-delegaciones-estructura','Administracion::listarDelegacionessEstructura');/* NUEVO */
$routes->add('delegaciones-serverside','Administracion::delegacionEstructuraServerside');/* NUEVO */
$routes->add('registrar-delegacion-estructura','Administracion::registrarDelegacionEstructura');/* NUEVO */
$routes->add('obtener-datos-delegacion-estructura','Administracion::obtenerDatosDelegacionEstructura');/* NUEVO */
$routes->add('actualizar-delegacion-estructura/(:any)','Administracion::modificarDelegacionEstructura/$1');/* NUEVO */
$routes->add('cambiar-estado-delegacion-estructura','Administracion::modificarEstadoDelegacionEstructura');/* NUEVO */
$routes->add('listado-delegacion-estructura','Administracion::listadoDelegacionesEstructura');/* NUEVO */
$routes->add('listado-delegacion-estructura-busqueda','Administracion::busquedaDelegacionesEstructura');/* NUEVO */

$routes->add('listar-direcciones','Administracion::listarDirecciones');/* NUEVO */
$routes->add('direcciones-sunat-serverside','Administracion::direccionServerside');/* NUEVO */
$routes->add('registrar-direccion','Administracion::registrarDireccion'); /* NUEVO */
$routes->add('obtener-datos-direccion','Administracion::obtenerDatosDireccion');/* NUEVO */
$routes->add('actualizar-direccion/(:any)','Administracion::actualizarDireccion/$1');/* NUEVO */
$routes->add('cambiar-estado-direccion','Administracion::modificarEstadoDireccion');/* NUEVO */
$routes->add('listado-direccion','Administracion::listadoDireccion'); /* NUEVO */
$routes->add('listar-ubicaciones-acceso/(:any)','Administracion::listarUbicacionesAcceso/$1');/* NUEVO */
$routes->add('registrar-ubicacion-acceso/(:any)','Administracion::registrarUbicacionAcceso/$1');/* NUEVO */

$routes->add('listar-region-paises','Administracion::listarRegionPaises');/* NUEVO */
$routes->add('registrar-region-pais','Administracion::registrarRegionPais');/* NUEVO */
$routes->add('obtener-datos-region-pais','Administracion::obtenerDatosRegionPais');/* NUEVO */
$routes->add('actualizar-region-pais/(:any)','Administracion::modificarRegionPais/$1');/* NUEVO */
$routes->add('cambiar-estado-region-pais','Administracion::modificarEstadoRegionPais');/* NUEVO */
$routes->add('listado-region-pais','Administracion::listadoRegionPais');/* NUEVO */

$routes->add('listar-region-departamentos/(:any)','Administracion::listarRegionDepartamentos/$1');/* NUEVO */
$routes->add('region-departamento-serverside','Administracion::regionDepartamentoServerside');/* NUEVO */
$routes->add('registrar-region-departamento','Administracion::registrarRegionDepartamento');/* NUEVO */
$routes->add('obtener-datos-region-departamento','Administracion::obtenerDatosRegionDepartamento');/* NUEVO */
$routes->add('actualizar-region-departamento/(:any)','Administracion::modificarRegionDepartamento/$1');/* NUEVO */
$routes->add('cambiar-estado-region-departamento','Administracion::modificarEstadoRegionDepartamento');/* NUEVO */
$routes->add('listado-region-departamentos','Administracion::listadoRegionDepartamento');/* NUEVO */

$routes->add('listar-region-provincias/(:any)','Administracion::listarRegionProvincias/$1');/* NUEVO */
$routes->add('region-provincia-serverside','Administracion::regionProvinciaServerside');/* NUEVO */
$routes->add('registrar-region-provincia','Administracion::registrarRegionProvincia');/* NUEVO */
$routes->add('obtener-datos-region-provincia','Administracion::obtenerDatosRegionProvincia');/* NUEVO */
$routes->add('actualizar-region-provincia/(:any)','Administracion::modificarRegionProvincia/$1');/* NUEVO */
$routes->add('cambiar-estado-region-provincia','Administracion::modificarEstadoRegionProvincia');/* NUEVO */
$routes->add('listado-region-provincias','Administracion::listadoRegionProvincia');/* NUEVO */

$routes->add('listar-region-distritos/(:any)','Administracion::listarRegionDistritos/$1');/* NUEVO */
$routes->add('region-distrito-serverside','Administracion::regionDistritoServerside');/* NUEVO */
$routes->add('registrar-region-distrito','Administracion::registrarRegionDistrito');/* NUEVO */
$routes->add('obtener-datos-region-distrito','Administracion::obtenerDatosRegionDistrito');/* NUEVO */
$routes->add('actualizar-region-distrito/(:any)','Administracion::modificarRegionDistrito/$1');/* NUEVO */
$routes->add('cambiar-estado-region-distrito','Administracion::modificarEstadoRegionDistrito');/* NUEVO */
$routes->add('listado-region-distritos','Administracion::listadoRegionDistrito');/* NUEVO */

$routes->add('listar-direcciones-estructura','Administracion::listarDireccionesEstructura');/* NUEVO */
$routes->add('direccion-estructura-serverside','Administracion::direccionEstructuraServerside');/* NUEVO */
$routes->add('registrar-direccion-estructura','Administracion::registrarDireccionEstructura');/* NUEVO */
$routes->add('obtener-datos-direccion-estructura','Administracion::obtenerDatosDireccionEstructura');/* NUEVO */
$routes->add('actualizar-direccion-estructura/(:any)','Administracion::modificarDireccionEstructura/$1');/* NUEVO */
$routes->add('cambiar-estado-direccion-estructura','Administracion::modificarEstadoDireccionEstructura');/* NUEVO */
$routes->add('listado-direccion-estructura','Administracion::listadoDireccionesEstructura');/* NUEVO */

$routes->add('registrar-responsable-direccion-estructura','Administracion::registrarResponsableDireccionEstructura');/* NUEVO */
$routes->add('recargar-responsable-direccion-estructura','Administracion::recargarResponsableDireccionEstructura');/* NUEVO */
$routes->add('actualizar-responsable-direccion-estructura','Administracion::modificarResponsableDireccionEstructura');/* NUEVO */
$routes->add('eliminar-responsable-direccion-estructura','Administracion::eliminarResponsableDireccionEstructura');/* NUEVO */

$routes->add('listar-areas-estructura/(:any)','Administracion::listarAreasEstructura/$1');/* NUEVO */
$routes->add('area-estructura-serverside','Administracion::areaEstructuraServerside');/* NUEVO */
$routes->add('registrar-area-estructura','Administracion::registrarAreaEstructura');/* NUEVO */
$routes->add('obtener-datos-area-estructura','Administracion::obtenerDatosAreaEstructura');/* NUEVO */
$routes->add('actualizar-area-estructura/(:any)','Administracion::modificarAreaEstructura/$1');/* NUEVO */
$routes->add('cambiar-estado-area-estructura','Administracion::modificarEstadoAreaEstructura');/* NUEVO */
$routes->add('listado-area-estructura','Administracion::listadoAreasEstructura');/* NUEVO */

$routes->add('registrar-responsable-area-estructura','Administracion::registrarResponsableAreaEstructura');/* NUEVO */
$routes->add('recargar-responsable-area-estructura','Administracion::recargarResponsableAreaEstructura');/* NUEVO */
$routes->add('actualizar-responsable-area-estructura','Administracion::modificarResponsableAreaEstructura');/* NUEVO */
$routes->add('eliminar-responsable-area-estructura','Administracion::eliminarResponsableAreaEstructura');/* NUEVO */

$routes->add('listar-subareas-estructura/(:any)','Administracion::listarSubareasEstructura/$1');/* NUEVO */
$routes->add('subarea-estructura-serverside','Administracion::subareaEstructuraServerside');/* NUEVO */
$routes->add('registrar-subarea-estructura','Administracion::registrarSubareaEstructura');/* NUEVO */
$routes->add('obtener-datos-subarea-estructura','Administracion::obtenerDatosSubareaEstructura');/* NUEVO */
$routes->add('actualizar-subarea-estructura/(:any)','Administracion::modificarSubareaEstructura/$1');/* NUEVO */
$routes->add('cambiar-estado-subarea-estructura','Administracion::modificarEstadoSubareaEstructura');/* NUEVO */
$routes->add('listado-subarea-estructura','Administracion::listadoSubareasEstructura');/* NUEVO */

$routes->add('registrar-responsable-subarea-estructura','Administracion::registrarResponsableSubareaEstructura');/* NUEVO */
$routes->add('recargar-responsable-subarea-estructura','Administracion::recargarResponsableSubareaEstructura');/* NUEVO */
$routes->add('actualizar-responsable-subarea-estructura','Administracion::modificarResponsableSubareaEstructura');/* NUEVO */
$routes->add('eliminar-responsable-subarea-estructura','Administracion::eliminarResponsableSubareaEstructura');/* NUEVO */

$routes->add('listar-delegaciones-subarea-estructura/(:any)','Administracion::listarDelegacionesSubareaEstructura/$1');/* NUEVO */
$routes->add('asociar-delegacion-subarea-estructura','Administracion::asociarDelegacionSubareaEstructura/$1');/* NUEVO */
$routes->add('eliminar-delegacion-subarea-estructura','Administracion::eliminarDelegacionSubareaEstructura');/* NUEVO */
$routes->add('listado-delegacion-subarea-estructura','Administracion::listadoDelegacionSubareaEstructura');/* NUEVO */

/******************************************************************************/

/* USUARIOS */

$routes->add('listar-usuarios','Usuarios::listarUsuarios');/* NUEVO */
$routes->add('usuarios-serverside','Usuarios::usuariosServerside');/* NUEVO */
$routes->add('registrar-usuario','Usuarios::registrarUsuario'); /* NUEVO */
$routes->add('informacion-usuario/(:any)','Usuarios::informacionUsuario/$1');
$routes->add('obtener-datos-usuario','Usuarios::obtenerDatosUsuario');
$routes->add('actualizar-usuario/(:any)','Usuarios::modificarUsuario/$1');/* NUEVO */
$routes->add('cambiar-password-usuario','Usuarios::modificarPasswordUsuario');/* NUEVO */
$routes->add('modificar-perfil-usuario','Usuarios::modificarPerfilUsuario');/* NUEVO */
$routes->add('cambiar-estado-usuario','Usuarios::modificarEstadoUsuario');/* NUEVO */
$routes->add('actualizar-cese-usuario','Usuarios::actualizarCeseUsuario');/* NUEVO */
$routes->add('listado-usuarios','Usuarios::listadoUsuarios');/* NUEVO */

// $routes->add('modificar-usuario/(:any)','Usuarios::modificarUsuario/$1');/* NUEVO */
$routes->add('listado-usuarios-select','Usuarios::listadoUsuariosSelect');
$routes->add('listado-usuarios-comprador','Usuarios::listadoUsuariosComprador');

$routes->add('listar-permisos-usuario','Usuarios::listarPermisosUsuario');/* NUEVO */
$routes->add('grabar-permisos-usuario/(:any)','Usuarios::guardarPermisosUsuario/$1');/* NUEVO */

$routes->add('listar-rutas-usuario','Usuarios::listarRutasUsuario');/* NUEVO */
$routes->add('grabar-rutas-usuario/(:any)','Usuarios::guardarRutasUsuario/$1');/* NUEVO */

$routes->add('listar-delegaciones-usuario','Usuarios::listarDelegacionesUsuario');/* NUEVO */
$routes->add('asociar-delegacion-usuario','Usuarios::asociarDelegacionUsuario');/* NUEVO */
$routes->add('eliminar-delegacion-usuario','Usuarios::eliminarDelegacionUsuario');/* NUEVO */

$routes->add('listar-sistemas-usuario','Usuarios::listarSistemasUsuario');/* NUEVO */
$routes->add('grabar-sistemas-usuario/(:any)','Usuarios::guardarSistemasUsuario/$1');/* NUEVO */

$routes->add('exportar-total-usuarios','Usuarios::exportarTotalUsuarios');/* NUEVO */
$routes->add('exportar-usuarios-sin-correo','Usuarios::exportarUsuariosSinCorreo');/* NUEVO */
$routes->add('importar-csv-usuario','Usuarios::importarCSVUsuario');/* NUEVO */
$routes->add('importar-csv-usuario-it','Usuarios::importarCSVUsuarioIT');/* NUEVO */
$routes->add('importar-csv-usuario-flota','Usuarios::importarCSVUsuarioFlota');/* NUEVO */
$routes->add('importar-csv-cambio-estado-usuario','Usuarios::importarCSVCambioEstadoUsuarios');/* NUEVO */

/******************************************************************************/

/*************************** NOTIFICACIONES ***********************************/
$routes->add('cargar-notificaciones-header','Notificaciones::cargarNotificacionesHeader');/* NUEVO */
$routes->add('cantidad-notificaciones-header','Notificaciones::cantidadNotificacionesHeader');/* NUEVO */
$routes->add('registrar-vista-notificacion','Notificaciones::registrarVisualizacionNotificacion');/* NUEVO */

/******************************************************************************/
	
/*************************** REFERIDOS ************************************/

/******************************************************************************/
	
/********************************** PROCESOS **********************************/ 

/******************************************************************************/
	
/*************************** LANDING PERSONALIZADOS ***************************/


/******************************************************************************/
	
/****************************** REMOTOS **************************************/


/******************************************************************************/

/****************************** PLANIFICACION *********************************/
$routes->add('listar-planificacion','Planificacion::listarPlanificacion');/* NUEVO */
$routes->add('registrar-planificacion','Planificacion::registrarPlanificacion');/* NUEVO */
$routes->add('obtener-datos-planificacion','Planificacion::obtenerDatosPlanificacion');/* NUEVO */
$routes->add('actualizar-planificacion/(:any)','Planificacion::modificarPlanificacion/$1');/* NUEVO */
$routes->add('cambiar-estado-planificacion','Planificacion::modificarEstadoPlanificacion');/* NUEVO */
$routes->add('listado-planificacion','Planificacion::listadoPlanificacion');/* NUEVO */
$routes->add('listado-planificacion-busqueda','Planificacion::busquedaPlanificacion');/* NUEVO */

$routes->add('listado-grupo-trabajo-estructura','Planificacion::listadoGrupoTrabajoEstructuraPlanificacion');/* NUEVO */
$routes->add('listado-usuaios-grupo-trabajo-estructura','Planificacion::listadoUsuariosGrupoTrabajoEstructuraPlanificacion');/* NUEVO */

$routes->add('listado-usuario-subarea-estructura','Administracion::listadoUsuarioSubareasEstructura');/* NUEVO */

$routes->add('horarioDataTableModal','Planificacion::listarHorarioDataTableModal');/* NUEVO */
$routes->add('importar-csv-planificacion','Planificacion::importarPlanificacion');/* NUEVO */
$routes->add('importar-csv-desempeno','Planificacion::importarDesempeno');/* NUEVO */
$routes->add('planificacion-data-table','Planificacion::listarPlanificacionDataTable');/* NUEVO */

$routes->add('listar-planificacion-usuario/(:any)','Planificacion::listarPlanificacionUsuario/$1');/* NUEVO */
$routes->add('calendario-planificacion','Planificacion::CalendarioPlanificacion');/* NUEVO */
$routes->add('listado-detalle-horarios-calendario','Planificacion::listadoDetalleHorariosCalendario');/* NUEVO */
$routes->add('actualizar-planificacion-horaria','Planificacion::actualizarPlanificacionHoraria');/* NUEVO */
$routes->add('calendario-planificacion-crear','Planificacion::calendarioPlanificacionCrear');/* NUEVO */
$routes->add('calendario-planificacion-actualizar','Planificacion::calendarioPlanificacionActualizar');/* NUEVO */
$routes->add('registrar-hora-trabajo','Planificacion::registrartHoraTrabajo');/* NUEVO */
$routes->add('borrar-evento','Planificacion::borrarEvento');/* NUEVO */
$routes->add('ver-planificacion-horaria/(:any)','Planificacion::verPlanificacionHoraria/$1');/* NUEVO */
$routes->add('calendario-general-planificacion','Planificacion::CalendarioGeneralPlanificacion');/* NUEVO */
$routes->add('listar-matriculas','Planificacion::ListarMatriculas');/* NUEVO */
$routes->add('actualizar-planificacion-general','Planificacion::ActualizarPlanificacionGeneral');/* NUEVO */
$routes->add('actualizar-hora-ingreso','Planificacion::ActualizarHoraIngreso');/* NUEVO */
/******************************************************************************/


/****************************** METRICAS **************************************/
$routes->add('listar-metricas','Metricas::listarMetrcias');/* NUEVO */
$routes->add('exportar-metricas','Metricas::exportarMetricas');/* NUEVO */
/******************************************************************************/

/**************************** REPORTE NOVEDADES ********************************/
$routes->add('listar-reporte-novedades','ReporteNovedades::listarreporteNovedades');/* NUEVO */
$routes->add('reporte-novedades-data-table','ReporteNovedades::reporteNovedadesDataTable');/* NUEVO */
$routes->add('importar-csv-metricas-complementarias','ReporteNovedades::importarMetricasComplementarias');/* NUEVO */
$routes->add('exportar-reporte-novedades','ReporteNovedades::exportarReporteNovedades');/* NUEVO */
$routes->add('grabar-reporte-novedades/(:any)','ReporteNovedades::guardarReporteNovedades/$1');/* NUEVO */
$routes->add('exportar-datos-reporte-novedades/(:any)','ReporteNovedades::exportarDatosReporteNovedades/$1');/* NUEVO */
$routes->add('metricas-complementarias-data-table','ReporteNovedades::metricasComplementariasDataTable');/* NUEVO */
$routes->add('metricas-calculadas-data-table','ReporteNovedades::metricasCalculadasDataTable');/* NUEVO */
$routes->add('listado-reporte-novedades-select','ReporteNovedades::listadoReporteNovedadesSelect');/* NUEVO */
$routes->add('obtener-reporte-novedades-seleccionada','ReporteNovedades::obtenerReporteNovedadesSeleccionada');/* NUEVO */
$routes->add('borrar-data-importada','ReporteNovedades::borrarDataImportada');/* NUEVO */
/******************************************************************************/

/************************* CONTROL DE INDICADORES *****************************/
$routes->add('listar-control-de-indicadores','ControlDeIndicadores::listarControlDeIndicadores');/* NUEVO */
$routes->add('indicadores-data-table','ControlDeIndicadores::indicadoresDataTable');/* NUEVO */
$routes->add('guardar-indicador','ControlDeIndicadores::guardarIndicador');/* NUEVO */ 
/******************************************************************************/

/****************************** CONFIGURACION***********************************/
$routes->add('listar-grupos-trabajo','Configuracion::listarGruposTrabajo');/* NUEVO */
$routes->add('registrar-grupo-trabajo','Configuracion::registrarGrupoTrabajo');/* NUEVO */
$routes->add('obtener-datos-grupo-trabajo','Configuracion::obtenerDatosGrupoTrabajo');/* NUEVO */
$routes->add('actualizar-grupo-trabajo/(:any)','Configuracion::modificarGrupoTrabajo/$1');/* NUEVO */
$routes->add('cambiar-estado-grupo-trabajo','Configuracion::modificarEstadoGrupoTrabajo');/* NUEVO */
$routes->add('listado-grupos-trabajo','Configuracion::listadoGruposTrabajo');/* NUEVO */

$routes->add('listar-usuarios-grupo-trabajo/(:any)','Configuracion::listarUsuariosGrupoTrabajo/$1');/* NUEVO */
$routes->add('asociar-usuario-grupo-trabajo','Configuracion::asociarUsuarioGrupoTrabajo');/* NUEVO */
$routes->add('eliminar-usuario-grupo-trabajo','Configuracion::eliminarUsuarioGrupoTrabajo');/* NUEVO */
$routes->add('listado-usuarios-grupotrabajo-select','Configuracion::listarUsuariosGrupoTrabajoSelect');/* NUEVO */
$routes->add('listado-horarios-asociados','Configuracion::listadoHorariosAsociados');/* NUEVO */
$routes->add('guardar-horarios-asociados','Configuracion::guardarHorariosAsociados');/* NUEVO */
$routes->add('listar-usuario-grupo-data-table','Configuracion::listarUsuarioGrupoDataTable');/* NUEVO */
/******************************************************************************/

/****************************** HORARIOS **************************************/
$routes->add('listar-horarios','Horarios::listarHorario');/* NUEVO */
$routes->add('listado-horarios','Horarios::listadoHorariosEstructura');/* NUEVO */
$routes->add('listar-horario-datatable','Horarios::listarHorarioDataTable');/* NUEVO */
$routes->add('obtener-detalles-horario','Horarios::obtenerDetallesHorario');/* NUEVO */
$routes->add('actualizar-horario/(:any)','Horarios::actualizarHorario/$1');/* NUEVO */
$routes->add('eliminar-horario','Horarios::eliminarHorario');/* NUEVO */
$routes->add('registrar-horario','Horarios::registrarHorario');/* NUEVO */
/******************************************************************************/

