<?php

require_once 'config/db.php';
require_once 'config/conexion.php';
include 'helper/helper_validacion.php';

date_default_timezone_set('America/Lima');
$fechahoy=date("d/m/Y");

$fecha_actual = date("d-m-Y");
//sumo 1 día
$promocion= date("d/m/Y",strtotime($fecha_actual."+ 7 days")); 

$htmltextarea=null;
$htmlco=null;
$idAmp = sanitizaCampo($_GET['idAmpl'],'sanitizeint|scapestring|htmlspecialchars',$con);
$idAmp=htmlspecialchars($idAmp);

    try{

        $stmt = $con->prepare( "SELECT 
C.IdCliente,
C.IdGeografico,
G.Distrito,
G.Provincia,
C.NombApellido,
C.Telefonouno,
C.Telefonodos,
C.Correo,
C.Direccion,
C.NCliente,
C.Correodos,
A.NAviso,
C.Segmento,
agen.NMantenimiento,
A.GestorUpselling,
Concat(t.Nombres,' ',t.Apellidos) NombreGestor,
t.Correo CorreoGestor,
A.Tecnico,
Concat(t2.Nombres,' ',t2.Apellidos) NombreTecnico,
t2.Correo CorreoTecnico,
t2.Telefono TelefonoTecnico,
A.Canal,
A.TipoCanal,
A.EstadoAmp,
A.Campana,
A.ComentarioAmp,
A.MesAmp,
CTZ.IdCotizacion,
CTZ.FormaPago,
CTZ.PAI,
CTZ.ExtraAutorizado,
CTZ.MesesAutorizado,
CTZ.TotalUnidad,
CTZ.TotalPrecio,
CTZ.TotalCuota,
A.ObjCotizacion,
A.TotalExtra,
A.CantidadExtras,
DATE_FORMAT(A.FechaPosibleVisita, '%d/%m/%Y') FechaPosibleVisita
FROM tblampliacion A
INNER JOIN tblcliente C ON A.IdCliente = C.IdCliente
INNER JOIN tblgeografico G ON C.IdGeografico = G.IdGeografico
LEFT JOIN tblcotizacion CTZ ON A.IdCotizacion = CTZ.IdCotizacion
INNER JOIN dbVENTAS.tblagenda agen on agen.IdAmp=A.IdAmp
INNER JOIN dbVENTAS.tblfacturacion f on f.IdAmp=A.IdAmp
LEFT JOIN dbUSUARIO.tblusuario t on t.Matricula=A.GestorUpselling
LEFT JOIN dbUSUARIO.tblusuario t2 on t2.Matricula=A.Tecnico
WHERE A.IdAmp = ?");

        $stmt->bind_param('i', $idAmp);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($IdCliente,
        $IdGeografico,
        $Distrito,
        $Provincia,
        $NombApellido,
        $Telefonouno,
        $Telefonodos,
        $Correo,
        $Direccion,
        $NCliente,
        $Correodos,
        $NAviso,
        $Segmento,
        $NMantenimiento,
        $GestorUpselling,
        $nombreGestorUpselling,
        $CorreoGestor,
        $GestorUpsellingT,
        $nombreGestorUpsellingT,
        $CorreoGestorT,
        $TelefonoGestorT,
        $Canal,
        $TipoCanal,
        $EstadoAmp,
        $Campana,
        $ComentarioAmp,
        $MesAmp,
        $IdCotizacion,
        $FormaPago,
        $PAI,
        $ExtraAutorizado,
        $MesesAutorizado,
        $TotalUnidad,
        $TotalPrecio,
        $TotalCuota,
        $ObjCotizacion,
        $TotalExtra,
        $CantidadExtras,
        $FechaPosibleVisita
        );
        $stmt->fetch();
        
        $ObjCotizacion=json_decode($ObjCotizacion, true);


    if(($TipoCanal=="PostMantos" && $Canal=="Field") || $Canal=="Cotizacion"){

    $GestorUpselling=$GestorUpsellingT;
    $nombreGestorUpselling=$nombreGestorUpsellingT;
    $CorreoGestor=$CorreoGestorT;
    // $TelefonoGestor=$TelefonoGestorT;
    $TelefonoGestor="514-7320";
    $auximagen="elementos.png";
    $auxnom2="Sub Precio";
    $auxnom3="Precio Total (incl. IGV)";
    $axmensaje='Para brindarle mayor detalle con respecto a su cotización, comuniquese al <strong>514-7320</strong> o vía correo electrónico a <strong>'.$CorreoGestor.'</strong>';
    $tituloPrecioDetalleItem="Precio por Unidad";
    $tituloTotalxPrecioDetalleItem="Precio Total por Unidad";
    $tituloTotalxPrecioDescuentoDetalleItem="Cuota por Unidad";
    }else{
    $GestorUpselling = $GestorUpselling;
    $nombreGestorUpselling=$nombreGestorUpselling;
    $CorreoGestor=$CorreoGestor;
    $TelefonoGestor="514-7320";
    $auximagen="extras.png";
    $auxnom2="Elementos";
    $auxnom3="Total Elementos";
    $auxmensaje='';
    $tituloPrecioDetalleItem="Precio S/IGV";
    $tituloTotalxPrecioDetalleItem="Total";
    $tituloTotalxPrecioDescuentoDetalleItem="Cuota";    
    }
    
    $TotalPrecioIGV=round($TotalPrecio*0.18, 2);
    $SumaTotalCoti=number_format(round($TotalPrecio+$TotalPrecioIGV, 2), 2, '.', '');
    
    $TotalCuotaIGV=round($TotalCuota*0.18, 2);
    $SumaTotalCuota=number_format(round($TotalCuota+$TotalCuotaIGV, 2), 2, '.', '');    
        

    if($Segmento=="NEG"){
        $tiposeg="Negocio";
    }else{
        $tiposeg="Residencial";
    }
        

    $numrows=$stmt->num_rows;
          
    $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
    
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
    <meta http-equiv="Content-Type" content="text/html charset=utf-8" />
    <meta name="viewport" content="width=480, user-scalable=1" />
    <title>Verisure Perú</title>
    <link href="https://fonts.googleapis.com/css?family=Fira+Sans:400,700" rel="stylesheet">
</head>

<body style="margin-left: 0px; margin-top: 0px; margin-right: 0px; margin-bottom: 0px; background-color:#f4f4f4">

    <table width="600" align="center" border="0" cellspacing="0" cellpadding="0" bgcolor="#f4f4f4">
        <tr>
            <td align="center">
                <table width="600" height="0" bgcolor="#ffffff" border="0" cellspacing="0" cellpadding="0">
                    <tr>
                        <td width="600"><img src="https://www.verismart.com.pe/verismart/img/cotizacion/alarmas-verisure.png" alt="Alarmas para tu Hogar" width="430" border="0" style="display:block; padding:0; border:0" /></td>
                        <td width="600"><a href="https://clientesverisure.com/"><img src="https://www.verismart.com.pe/verismart/img/cotizacion/web-clientes.png" alt="Alarmas para tu Hogar" width="170" border="0" style="display:block; padding:0; border:0" /></a></td>
                    </tr>
                </table>

                <table width="600" height="0" bgcolor="#ffffff" border="0" cellspacing="0" cellpadding="0">
                    <tr>

                        <td width="600"><img src="https://www.verismart.com.pe/verismart/img/cotizacion/top.png" alt="Alarmas para tu Hogar" width="600" border="0" style="display:block; padding:0; border:0" /></td>

                    </tr>
                </table>

                <table style="background-color: #ffffff;" width="550" cellspacing="0" cellpadding="0" border="0">
                    <tr>
                        <td width="500">
                            <p style="text-align: left;font-size: 16px;font-family:  'Fira Sans', Arial;color: #757575; padding:0px 15px;"><strong>Estimado <?=$NombApellido;?>,</strong> <br><br>
                                A continuación, encontrará el presupuesto para mejorar la seguridad de su hogar. Esperamos que sea de su agrado.
                            </p>
                        </td>
                    </tr>
                </table>

                <table style="background-color: #ffffff; " width="550" cellspacing="0" cellpadding="0" border="0">
                    <tr>
                        <td style="border-top: solid #f4f4f4 6px;border-right: solid #f4f4f4 6px;"><img src="https://www.verismart.com.pe/verismart/img/cotizacion/datos-cliente.png" alt="Alarmas para tu Hogar" style="display:block; padding-top:10px; border:0;margin: 0px auto;" width="178" border="0">
                            <p style="text-align: center;font-size: 16px;font-family:  'Fira Sans', Arial;color: #757575; padding:0px 15px;"><strong>Código Cliente:</strong> <?=$NCliente;?> <br><strong>Teléfono:</strong> <?=$Telefonouno;?></p>
                        </td>
                        <td style="border-top: solid #f4f4f4 6px;"><img src="https://www.verismart.com.pe/verismart/img/cotizacion/datos-presupuesto.png" alt="Alarmas para tu Hogar" style="display:block; padding-top:10px; border:0;margin: 0px auto;" width="205" border="0">
                            <p style="text-align: center;font-size: 16px;font-family:  'Fira Sans', Arial;color: #757575; padding:0px 15px;"><strong>No. Presu:</strong> <?=$idAmp;?> <br><strong>Fecha:</strong> <?=date('d/m/Y');?> <br><strong>Válido hasta:</strong> <?=date("d/m/Y",strtotime(date("d-m-Y")."+ 7 days"));?></p>
                        </td>
                    </tr>
                    <tr>
                        <td></td>
                        <td></td>
                    </tr>
                </table>

                <table width="600" height="0" bgcolor="#ffffff" border="0" cellspacing="0" cellpadding="0">
                    <tr>

                        <td width="600"><img src="https://www.verismart.com.pe/verismart/img/cotizacion/presupuesto-.png" alt="Alarmas para tu Hogar" width="600" border="0" style="display:block; padding:0; border:0" /></td>

                    </tr>
                </table>

                <table width="550">
                    <tr>
                        <td>
                            <p style="text-align: center;font-size: 16px;font-family:  'Fira Sans', Arial;color: #757575; padding:0px 15px; font-weight: bold;margin:0px;">Producto</p>
                        </td>
                        <td>
                            <p style="text-align: center;font-size: 16px;font-family:  'Fira Sans', Arial;color: #757575; padding:0px 15px;font-weight: bold;margin:0px;">Cant.</p>
                        </td>
                        <td>
                            <p style="text-align: center;font-size: 16px;font-family:  'Fira Sans', Arial;color: #757575; padding:0px 15px;font-weight: bold;margin:0px;">Precio</p>
                        </td>
                        <td>
                            <p style="text-align: center;font-size: 16px;font-family:  'Fira Sans', Arial;color: #757575; padding:0px 15px;font-weight: bold;margin:0px;">Total</p>
                        </td>
                        <td>
                            <p style="text-align: center;font-size: 16px;font-family:  'Fira Sans', Arial;color: #757575; padding:0px 15px;font-weight: bold;margin:0px;">Cuota*</p>
                        </td>
                    </tr>
<?php
$totalObjCotizacion=count($ObjCotizacion);
$ObjTotalCuota=0;
$ObjTotalPrecio=0.00;
$contadorC=0;

    foreach ($ObjCotizacion as $items) {
    	$contadorC++;
    	
?>
                    <tr style="background-color:#ffffff;">
                        <td><img src="https://www.verismart.com.pe/verismart/img/cotizacion/img-zerovision.png" alt="Alarmas para tu Hogar" style="display:block; padding:0; border:0;margin: 0px auto;" width="131" border="0"></td>
                        <td>
                            <p style="text-align: center;font-size: 16px;font-family:  'Fira Sans', Arial;color: #757575; padding:0px 15px;"><?=$items['Cantidad'];?></p>
                        </td>
                        <td>
                            <p style="text-align: center;font-size: 16px;font-family:  'Fira Sans', Arial;color: #757575; padding:0px 15px;">S/.<?=$items['PrecioAdicional'];?></p>
                        </td>
                        <td>
                            <p style="text-align: center;font-size: 16px;font-family:  'Fira Sans', Arial;color: #757575; padding:0px 15px;">S/.<?=$items['PrecioSubTotal'];?></p>
                        </td>
                        <td>
                            <p style="text-align: center;font-size: 16px;font-family:  'Fira Sans', Arial;color: #757575; padding:0px 15px;">S/.<?=$items['CuotaMensual'];?></p>
                        </td>
                    </tr>

<?php       
       
        
    	$ObjTotalPrecio+=$items['PrecioSubTotal'];
    	$ObjTotalCuota+=$items['CuotaMensual'];
    }
    

$TotalPrecioIGV=round(($ObjTotalPrecio*0.18),2);
$TotalCuotaIGV=round(($ObjTotalCuota*0.18),2);

$TotalPrecioSubTotal=round(($ObjTotalPrecio*0.72),2);
$TotalCuotaSubTotal=round(($ObjTotalCuota*0.72),2); 

$TotalPrecioTOTAL=round($ObjTotalPrecio,2);
$TotalCuotaTOTAL=round($ObjTotalCuota,2); 
    

?>                    

                </table>


                <table width="550">
                    <thead>
                        <tr>
                            <td rowspan="2" style="background-color: #e5dbd3;">
                                <p style="text-align: center;font-size: 14px;font-family:  'Fira Sans', Arial;color: #757575; padding:0px 15px;"><?=$axmensaje;?></p>
                            </td>
                            <td style="background-color: #898c8e;">
                                <p style="text-align: center;font-size: 16px;font-family:  'Fira Sans', Arial;color: #ffffff; padding:0px 15px;font-weight: bold;">Cuota Mensual*</p>
                            </td>
                            <td style="background-color: #898c8e;">
                                <p style="text-align: center;font-size: 16px;font-family:  'Fira Sans', Arial;color: #ffffff; padding:0px 15px;font-weight: bold;">S/.<?=$TotalCuotaTOTAL;?></p>
                            </td>
                        </tr>
                        <tr>
                            <td style="background-color: #ff0000;">
                                <p style="text-align: center;font-size: 16px;font-family:  'Fira Sans', Arial;color: #ffffff; padding:0px 15px;font-weight: bold;">Total</p>
                            </td>
                            <td style="background-color: #ff0000;">
                                <p style="text-align: center;font-size: 16px;font-family:  'Fira Sans', Arial;color: #ffffff; padding:0px 15px;font-weight: bold;">S/.<?=$TotalPrecioTOTAL;?></p>
                            </td>
                        </tr>
                    </thead>
                </table>
                <table width="600" height="0" bgcolor="#ffffff" border="0" cellspacing="0" cellpadding="0">
                    <tr>

                        <td width="600"><img src="https://www.verismart.com.pe/verismart/img/cotizacion/cuentas-pago.png" alt="Alarmas para tu Hogar" width="600" border="0" style="display:block; padding:0; border:0" /></td>

                    </tr>
                </table>
                <table width="600" height="0" bgcolor="#ffffff" border="0" cellspacing="0" cellpadding="0">
                    <tr>

                        <td width="600"><img src="https://www.verismart.com.pe/verismart/img/cotizacion/bancos.png" alt="Alarmas para tu Hogar" width="600" border="0" style="display:block; padding:0; border:0" /></td>

                    </tr>
                </table>
                <table width="600" height="0" bgcolor="#ffffff" border="0" cellspacing="0" cellpadding="0">
                    <tr>

                        <td width="600"><img src="https://www.verismart.com.pe/verismart/img/cotizacion/como-pago.png" alt="Alarmas para tu Hogar" width="600" border="0" style="display:block; padding:0; border:0" /></td>

                    </tr>
                </table>
                <table width="600" height="0" bgcolor="#ffffff" border="0" cellspacing="0" cellpadding="0">
                    <tr>

                        <td width="600"><a href="https://www.visanetlink.pe/pagoseguro/null/70785"><img src="https://www.verismart.com.pe/verismart/img/cotizacion/tarjetas1.png" alt="Alarmas para tu Hogar" width="600" border="0" style="display:block; padding:0; border:0" /></a></td>

                    </tr>
                </table>
                <table width="600" height="0" bgcolor="#ffffff" border="0" cellspacing="0" cellpadding="0">
                    <tr>

                        <td width="600"><a href="https://pagolink.niubiz.com.pe/pagoseguro/MONTO/1066005"><img src="https://www.verismart.com.pe/verismart/img/cotizacion/tarjetas2.png" alt="Alarmas para tu Hogar" width="600" border="0" style="display:block; padding:0; border:0" /></a></td>

                    </tr>
                </table>
                <br>

                <table width="550" height="0" border="0" cellspacing="0" cellpadding="0">
                    <tr>
                        <td align="left" style="font-size: 14px; line-height: 1px; font-family: Fira Sans, sans-serif; color: #747474; text-align: left;"><img alt="-------" src="https://www.verisure.co.uk/alarms/customers/emails/html/img/line_dotted.gif" style="display: block; margin: 0 auto; display: inline-block; max-width: 100%; height: auto;" width="118" height="1" border="0" /><img alt="-------" src="https://www.verisure.co.uk/alarms/customers/emails/html/img/line_dotted.gif" style="display: block; margin: 0 auto; display: inline-block; max-width: 100%; height: auto;" width="118" height="1" border="0" /></td>
                        <td style="padding: 0 8px; font-size: 14px; line-height: 50px; font-family: 'Lucida Grande', 'Lucida Sans Unicode', 'Lucida Sans', 'DejaVu Sans', Verdana, sans-serif; color: #333333; text-align: center;" align="-">
                            <img alt="Canal Cliente: siempre a su servicio" src="https://www.verismart.com.pe/verismart/img/cotizacion/ico-contacto.png" style="display: block; margin: 0 auto; display: inline-block; max-width: 100%; height: auto;" width="50" height="50" border="0">
                        </td>
                        <td align="right" style="font-size: 14px; line-height: 1px; font-family: Fira Sans, sans-serif; color: #747474; text-align: right;">
                            <img alt="-------" src="https://www.verisure.co.uk/alarms/customers/emails/html/img/line_dotted.gif" style="display: block; margin: 0 auto; display: inline-block; max-width: 100%; height: auto;" width="118" height="1" border="0"><img alt="-------" src="https://www.verisure.co.uk/alarms/customers/emails/html/img/line_dotted.gif" style="display: block; margin: 0 auto; display: inline-block; max-width: 100%; height: auto;" width="118" height="1" border="0" />
                        </td>
                    </tr>
                </table>


                <table width="550" height="0" border="0" cellspacing="0" cellpadding="0">
                    <tr>
                        <td style="padding-left: 5px; padding-right: 5px; padding-top: 16px; font-size: 13px; line-height: 15px; font-family: 'Fira Sans', Arial, sans-serif; color: #737373; text-align: center;" width="33.333%" align="center">
                            <p>E-mail</p>
                        </td>

                        <td style="padding-left: 5px; padding-right: 5px; padding-top: 16px; font-size: 13px; line-height: 15px; font-family: 'Fira Sans', Arial, sans-serif; color: #737373; text-align: center;" width="33.333%" align="center">
                            <p>Teléfono</p>
                        </td>

                        <td style="padding-left: 5px; padding-right: 5px; padding-top: 16px; font-size: 13px; line-height: 15px; font-family: 'Fira Sans', Arial, sans-serif; color: #737373; text-align: center;" width="33.333%" align="center">
                            <p>Chat App MyVerisure</p>

                    </tr>

                    <tr>
                        <td style="padding-left: 5px; padding-right: 5px; font-size: 14px; line-height: 42px; font-family: Arial, sans-serif; color: #333333; text-align: center; border-right: 0px solid #979797" width="33.333%" align="center">
                            <img alt="•" src="https://www.verismart.com.pe/verismart/img/cotizacion/ico-m.png" style="display: inline-block;" width="34" height="42" border="0">
                        </td>



                        <td style="padding-left: 5px; padding-right: 5px; font-size: 14px; line-height: 42px; font-family: Arial, sans-serif; color: #333333; text-align: center;border-left: solid 1px;border-right: solid 1px;">
                            <img alt="•" src="https://www.verismart.com.pe/verismart/img/cotizacion/ico-telefono.png" style="display: inline-block;" width="45" height="42" border="0">
                        </td>


                        <td style="padding-left: 5px; padding-right: 5px; font-size: 14px; line-height: 42px; font-family: Arial, sans-serif; color: #333333; text-align: center;" width="33.333%" align="center">
                            <img alt="•" src="https://www.verismart.com.pe/verismart/img/cotizacion/ic-chat.png" style="display: inline-block;" width="45" height="42" border="0">
                        </td>


                    </tr>

                    <tr>
                        <td style="padding-left: 5px; padding-right: 5px; padding-top: 16px; font-size: 13px; line-height: 15px; font-family: Arial, sans-serif; color: #737373; text-align: center;" width="33.333%" align="center">
                            <a href="mailto:clientes@verisure.pe" style="color: #737373; text-decoration: none; display: block; font-family: 'Fira Sans', 'Lucida Sans Unicode', 'Lucida Sans', 'DejaVu Sans', Verdana, sans-serif; font-size: 14px;"><span>clientes@verisure.pe</span><br><span style="color: #a9a9a9; display: block; font-family: 'Lucida Grande', 'Lucida Sans Unicode', 'Lucida Sans', 'DejaVu Sans', Verdana, sans-serif; font-size: 14px; padding-top: 4px;">24h</span></a>
                        </td>



                        <td style="padding-left: 5px; padding-right: 5px; padding-top: 16px; font-size: 13px; line-height: 15px; font-family: Arial, sans-serif; color: #737373; text-align: center;" width="33.333%" align="center">
                            <a href="tel:0 800 2 12 12" style="color: #737373; text-decoration: none; display: block; font-family: 'Fira Sans', 'Lucida Sans Unicode', 'Lucida Sans', 'DejaVu Sans', Verdana, sans-serif; font-size: 14px;"><span>0 800 2 12 12</span><br><span style="color: #a9a9a9; display: block; font-family: 'Fira Sans', 'Lucida Sans Unicode', 'Lucida Sans', 'DejaVu Sans', Verdana, sans-serif; font-size: 14px; padding-top: 4px;">24h</span></a>
                        </td>


                        <td style="padding-left: 5px; padding-right: 5px; padding-top: 16px; font-size: 13px; line-height: 15px; font-family: Arial, sans-serif; color: #737373; text-align: center;" width="33.333%" align="center">
                            <a href="" style="color: #737373; text-decoration: none; display: block; font-family: 'Fira Sans', 'Lucida Sans Unicode', 'Lucida Sans', 'DejaVu Sans', Verdana, sans-serif; font-size: 14px;"><span>Lunes a Viernes</span><br><span style="color: #a9a9a9; display: block; font-family: 'Lucida Grande', 'Lucida Sans Unicode', 'Lucida Sans', 'DejaVu Sans', Verdana, sans-serif; font-size: 14px; padding-top: 4px;">9:00 a.m. - 6:00 p.m.</span></a>

                    </tr>
                </table>
                <br><br>


                <table style="border-radius: 0px 0px 45px 45px;" width="550" cellspacing="0" cellpadding="0" border="0" bgcolor="#ffffff" align="center">
                    <tbody>
                        <tr>

                            <td width="600">
                                <p style="text-align: center;  font-size: 16px;font-family:  'Fira Sans', Arial;color: #ff0033; margin-top: 20px;">Personas que protegen a personas</p>
                                <p style="text-align: center;font-size: 12px;font-family:  'Fira Sans', Arial;color: #606060;margin-bottom: 5px;">S&iacute;guenos en redes sociales</p>
                            </td>
                        </tr>

                        <tr>
                            <td width="600">
                                <p style="text-align: center;font-size: 12px;font-family:'Fira Sans', Arial;color: #606060;"><a href="https://www.facebook.com/AlarmasVerisurePeru/" style="color:#ff0033">Facebook</a>&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;&nbsp;<a href="https://www.youtube.com/channel/UCsC7LzKdqytaOQ58IL011eQ" style="color:#ff0033">Youtube</a>&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;&nbsp;<a href="https://www.instagram.com/verisurepe/" style="color:#ff0033">Instagram</a></p>
                            </td>

                        </tr>

                    </tbody>
                </table>

                <table width="600" align="center" border="0" cellspacing="0" cellpadding="0" bgcolor="#f4f4f4">
                    <tbody>
                        <tr>
                            <td width="550">
                                <p style="color: #c1c1c1;text-align: center;font-size: 10px;font-family:  'Fira Sans', Arial;padding-bottom: 10px; padding-top: 15px;"> Copyright © 2023 Verisure Peru, All rights reserved. Nuestra dirección es: Av. Primavera 1050 Oficina 501 – Santiago de Surco.
                            </td>
                        </tr>

                    </tbody>
                </table>
            </td>
        </tr>
    </table>
</body>
</html>

