<?php
    session_start();
    if (!isset($_SESSION['user_login_status'])) {
            header("location: ./login/index.php");
    		exit;
            }
    
    if ($_SESSION['pzforconsulta']==0) {
         header("location: ./denegado.php");
    		exit;
            }


    date_default_timezone_set('America/Lima');
    function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
    }
    function format_date_dd_mm_Y($date)
    {
        return date('d/m/Y', strtotime($date));
    }
    function format_date_Y_mm_dd($date)
    {
        return date('Y-m-d', strtotime($date));
    }
    
    
    include 'config/db.php';
    include 'config/conexion.php';
    /*
    include 'config/dbsec.php';
    include 'config/conexionsec.php';
    */
    
    if (isset($_GET['telefonouno'])) {
        $telefonouno=$_GET['telefonouno'];
        $telefonouno = htmlspecialchars($telefonouno);
    
    }else{
        $telefonouno="";
    }

?>


<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title>Verisure | VeriSmart</title>
        <!-- Tell the browser to be responsive to screen width -->
        <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
        <link rel="icon" type="image/png" href="admin/dist/img/-apple-touch-icon-144x144.png" >
        <!-- Bootstrap 3.3.7 -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css">
        <!-- Font Awesome -->
        <link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
        <!-- Ionicons -->
        <link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">
       <!-- Theme style -->
        <link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
        <!-- AdminLTE Skins. Choose a skin from the css/skins
             folder instead of downloading all of them to reduce the load. -->
        <link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">
 

        <!-- bootstrap datepicker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
        <!-- iCheck for checkboxes and radio inputs -->
        <link rel="stylesheet" href="admin/plugins/iCheck/all.css">
        <!-- Bootstrap time Picker -->
        <link rel="stylesheet" href="admin/plugins/timepicker/bootstrap-timepicker.min.css">
        <!-- Select2 -->
        <link rel="stylesheet" href="admin/bower_components/select2/dist/css/select2.min.css">
        <!-- Bootstrap toogle-->
        <link href="admin/plugins/bootstrap-toggle-master/css/bootstrap-toggle.min.css" rel="stylesheet" type="text/css"/>
      
        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->

        <!-- Google Font -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
        <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">
 
        <link href="admin/bower_components/bootstrap-datetimepicker/build/css/bootstrap-datetimepicker.min.css" rel="stylesheet" type="text/css"/>
        <!-- Alertifyjs -->
        <link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css"/>
        <link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css"/>
  
 
        <style>
        
            .ocultar{
                display:none;
            }

            .modal-header-danger {
                color:#fff;
                background-color: #e4002b;              
            }

            .ocultarcliente{
                display:none;
            }
            .ocultarcolaborador{
                display:none;
            }
            .preloader{
                background-color:#FFF;
                width: 100%;
                height: 100%;
                position: absolute;
                z-index: 1;
            }

            .dataTables_wrapper .myfilter .dataTables_filter{float:left}
            .dataTables_wrapper .mylength .dataTables_length{float:right}
            div.dataTables_scrollBody thead th {
                vertical-align: top;
            } 
            td {
                max-width: 250px;
                overflow: hidden;
                white-space: nowrap;
                text-overflow: ellipsis;

            }
            .espacio{
                height:10px;
            }
            
           .espacio2{
                height:15px;
            }

            .thumbnail_style{
                text-align:center;
                border:none;
            }


            .caption h4{
                margin-top: -10px;
                font-size:13px;
                font-weight:  bold;
            }

            .caption p{
                color:#777;
                font-size:13px;
            }

            .caption a{
                color:#777;
                font-size:10px;
            }


            #frmEditarVenta .form-control{
                border-radius: 4px
            }

            #c-slider{
                margin: auto;
                width: 100%;
                max-width: 900px;
                position: relative;
                overflow: hidden;

            }
            #slider{
                display: flex;
                width: 200%;

            }
            #slider section{
                width: 100%;
            }


            .select2-container--default .select2-selection--single {

                border: 1px solid #d2d6de;
                border-radius: 4px;font-size: 12px;
                padding:4px 6px;
            }

            .btn-nuevo { 
                color: #FFFFFF; 
                background-color: #444444; 
                border-color: #444444; 
            } 

            .btn-nuevo:hover, 
            .btn-nuevo:focus, 
            .btn-nuevo:active, 
            .btn-nuevo.active, 
            .open .dropdown-toggle.btn-nuevo { 
                color: #FFFFFF; 
                background-color: #616161;  
                border-color: #444444; 
            } 

            .btn-nuevo:active, 
            .btn-nuevo.active, 
            .open .dropdown-toggle.btn-nuevo { 
                background-image: none; 
            } 

            .btn-nuevo.disabled, 
            .btn-nuevo[disabled], 
            fieldset[disabled] .btn-nuevo, 
            .btn-nuevo.disabled:hover, 
            .btn-nuevo[disabled]:hover, 
            fieldset[disabled] .btn-nuevo:hover, 
            .btn-nuevo.disabled:focus, 
            .btn-nuevo[disabled]:focus, 
            fieldset[disabled] .btn-nuevo:focus, 
            .btn-nuevo.disabled:active, 
            .btn-nuevo[disabled]:active, 
            fieldset[disabled] .btn-nuevo:active, 
            .btn-nuevo.disabled.active, 
            .btn-nuevo[disabled].active, 
            fieldset[disabled] .btn-nuevo.active { 
                background-color: #444444; 
                border-color: #444444; 
            } 
            

            input[type=number]::-webkit-outer-spin-button,
            
            input[type=number]::-webkit-inner-spin-button {
            
                -webkit-appearance: none;
            
                margin: 0;
            
            }

 

            input[type=number] {
            
                -moz-appearance:textfield;
            
            }
        </style>
        
        <style>
            .main-header,.main-sidebar,.left-side{position:fixed}
           
            .main-header {
                top: 0;
                right: 0;
                left: 0
            }
             .content-wrapper,
             .right-side {
                padding-top: 50px
            }
            
            @media (max-width:767px) {
                 .content-wrapper,
                 .right-side {
                    padding-top: 100px
                }
            }
            
            .layout-boxed .wrapper {
                max-width: 100%
            }
            
            .wrapper {
                overflow: hidden
            
             .control-sidebar {
                position: fixed;
                height: 100%;
                overflow-y: auto;
                padding-bottom: 50px
            }       
        
        

  </style>

        <style>
            

            .ui-autocomplete {
                position: absolute;
                z-index: 1000;
                cursor: default;
                padding: 0;
                margin-top: 2px;
                list-style: none;
                font-size: 11px;
                font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
                background-color: #ffffff;
                border: 1px solid #ccc;
                -webkit-border-radius: 5px;
                   -moz-border-radius: 5px;
                        border-radius: 5px;
                -webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                   -moz-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                        box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                        
                    z-index: 1051 !important;    
                        
            }
            
            
            
            
            
               hr {
              height: 4px;
              width: 100%;
              background-color: #ecf0f5;
            
            }
            
            
            
            hr {
                /* margin-top: 20px; */
                margin-bottom: 20px;
                border: 0;
                /* border-top: 1px solid #eee; */
            }
            
            
            hr {
                display: block;
                unicode-bidi: isolate;
                -webkit-margin-before: 0.5em;
                -webkit-margin-after: 0.5em;
                -webkit-margin-start: auto;
                -webkit-margin-end: auto;
                overflow: hidden;
                border-style: inset;
               
            }
            
            .box.box-custom {
                border-top-color: #ffffff;
            }
            
            .box {
                position: relative;
                border-radius: 3px;
                background: #ffffff;
                border-top: 3px solid #d2d6de;
                margin-bottom: 5px;
                width: 100%;
                box-shadow: 0 1px 1px rgba(0,0,0,0.1);
            }
            
                    </style>
        
        <style>
            #divLoading {
                  background: rgba(66,118,164,0.4);
                  width: 100%;
                  height: 100%;
                  min-height: 100%;
                  position: absolute;
                  top: 0;
                  left: 0;
                  z-index: 10000;
                  display:none;
                }
            
            .spinner {
              margin: 300px auto 0;
              width: 70px;
              text-align: center;
            }
            
            .spinner > div {
              background-color: #E30613;
              width: 18px;
              height: 18px;
              border-radius: 100%;
              display: inline-block;
              -webkit-animation: sk-bouncedelay 1.4s infinite ease-in-out both;
              animation: sk-bouncedelay 1.4s infinite ease-in-out both;
            }
            
            .spinner .bounce1 {
              -webkit-animation-delay: -0.32s;
              animation-delay: -0.32s;
            }
            
            .spinner .bounce2 {
              -webkit-animation-delay: -0.16s;
              animation-delay: -0.16s;
            }
            
            @-webkit-keyframes sk-bouncedelay {
              0%, 80%, 100% { -webkit-transform: scale(0) }
              40% { -webkit-transform: scale(1.0) }
            }
            
            @keyframes sk-bouncedelay {
              0%, 80%, 100% { 
                -webkit-transform: scale(0);
                transform: scale(0);
              } 40% { 
                -webkit-transform: scale(1.0);
                transform: scale(1.0);
              }
            }

</style>

    </head>
    <body class="sidebar-collapse skin-red sidebar-mini">
        <div id="divLoading" style="display: none;">
            <div class="spinner">
              <div class="bounce1"></div>
              <div class="bounce2"></div>
              <div class="bounce3"></div>
            </div>
        </div>
        <div class="wrapper">
            <!-- Header -->
            <?php include 'admin/header.php'; ?>
            <!-- Left side column. contains the logo and sidebar -->
            <?php


            $consultaventa="active";
            include 'admin/main-sidebar.php';

            ?>


            <!-- Content Wrapper. Contains page content -->
            <div class="content-wrapper">
                <!-- Content Header (Page header) -->
                <!-- Main content -->
                <section class="content">
                    <div class="row">
                        <div class="col-md-2"></div>
                        <div class="col-md-8">
                            <!-- /.box-header -->
                            <div class="box box-danger">
                                <div class="box-header">
                                    <h3 class="box-title">NUEVO PROSPECTO RP </h3>
                                    <input id="lblcat" name="lblcat" hidden="">
                                    <div class="box-tools pull-right">
                                         <?php if($nombacceso=='test'){ } else{ ?>
                                         <a class="btn btn-nuevo btn-sm" id="btnGuardarEditarVenta" href="#"><i class="fa fa-save"></i></a>
                                          <?php } ?>
                                         <a href="consultaformador.php" class="btn btn-danger btn-sm" ><i class="fa fa-reply"></i></a>
                                    </div>
                                </div>
                                <div class="espacio"></div>
                            </div>
                            <form id="frmEditarVenta" method="POST">
                                <div class="box box-custom">
                                    <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                       <h5>INFORMACION DEL COMERCIAL</h5>
                        
                                      <div class="box-tools pull-right">
                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                        </button>
                                        
                                      </div>
                                    </div>
                                    <!-- /.box-header -->
                                    <div class="box-body table-responsive">
                                        <table  cellspacing="0"  style="width:100%;padding: 15px;" >
                                           <tr>
                                                <td style="width:15%;font-size: 12px">MATRICULA: <span style="color:red"> * </span></td>
                                                <td style="width:25%;">
                                                    <input type="text" name="lblmatricula" id="lblmatricula" value="<?php echo $matriculausuario;?>" class="form-control input-sm" style="width: 100%;" readonly="readonly"> 
                                                    <input id="lblidusuario" name="lblidusuario" value="<?php echo $id_usuario;?>" hidden="">
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                              <tr>
                                             <td style="width:15%;font-size: 12px">COMERCIAL: <span style="color:red"> * </span></td>
                                            <td style="width:25%;"><input name="lblnombcomercial" id="lblnombcomercial" value="<?php echo $nombreusuario;?>" class="form-control input-sm" style="width: 100%;" readonly="readonly" required /></td>
                                                </tr>
                                            <tr class="espacio"></tr>
                                              <tr>
                                             <td style="width:15%;font-size: 12px">DC: <span style="color:red"> * </span></td>
                                            <td style="width:25%;">
                                                <select class="form-control input-sm" name="lbldc" id="lbldc" style="width: 100%;">
                                                    <option value="">Seleccione</option>
                                                        <?php if ($ccusuario == "150") { ?>
                                                    <option value="150">150</option>
                                                        <?php }else if($ccusuario == "151") { ?>
                                                    <option value="151">151</option>
                                                        <?php }else if ($ccusuario == "152") { ?>
                                                    <option value="152">152</option>
                                                        <?php }else if($ccusuario == "153") { ?>
                                                    <option value="153">153</option>
                                                        <?php }else if ($ccusuario == "154") { ?>
                                                    <option value="154">154</option>
                                                        <?php }else if($ccusuario == "155") { ?>
                                                    <option value="155">155</option>
                                                        <?php }else if($ccusuario == "156") { ?>
                                                    <option value="156">156</option>
                                                    
                                                                <?php }else if($ccusuario == "157") { ?>
                                                    <option value="157">157</option>
                                                    
                                                                <?php }else if($ccusuario == "158") { ?>
                                                    <option value="158">158</option>
                                                    
                                                                <?php }else if($ccusuario == "159") { ?>
                                                    <option value="159">159</option>
                                                                <?php }else if($ccusuario == "140") { ?>
                                                    <option value="140">140</option>                                                    
                                                    
                                                        <?php }else if ($ccusuario == "200") { ?>
                                                    <option value="200">200</option>
                                                        <?php }else if ($ccusuario == "120") { ?>
                                                    <option value="120">120</option>
                                                        <?php }else if ($ccusuario == "100") { ?>
                                                    <option value="100">100</option>                                                    
                                                        <?php }else if ($ccusuario == "40") { ?>
                                                    <option value="40">40</option>
                                                        <?php }else if ($ccusuario == "41") { ?>
                                                    <option value="41">41</option>
                                                        <?php }else if ($ccusuario == "500") { ?>
                                                    <option value="500">500</option>
                                                                <?php }else if ($ccusuario == "599") { ?>
                                                    <option value="599">599</option>
                                                        <?php }else { ?>
                                                    <option value="150">150</option>
                                                    <option value="511"></option>
                                                    <?php }?>
                                                                                                                          
                                                                                                                    </select></td>
                                                </tr>
                                            <tr class="espacio"></tr>
                                              <tr>
                                             <td style="width:15%;font-size: 12px">JEFE VENTA: <span style="color:red"> * </span></td>
                                            <td style="width:25%;"><select class="form-control input-sm" name="lbljefeventa" id="lbljefeventa" style="width: 100%;">
                                                                                                                        <option value="">Seleccione</option>
                                                                                                                    </select></td>
                                                </tr>
                                        </table>
                                    </div>
                                    <!-- /.box-body -->
                                </div>
                                <div class="box box-custom">
                                    <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                       <h5>INFORMACION DEL CLIENTE</h5>
                        
                                      <div class="box-tools pull-right">
                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                        </button>
                                        
                                      </div>
                                    </div>
                                    <!-- /.box-header -->
                                    <div class="box-body table-responsive">
                        
                        <table  cellspacing="0"  style="width:100%;padding: 15px;" >
                          
                          <tr>
                         <td style="width:15%;font-size: 12px">CLIENTE: <span style="color:red"> * </span></td>
                        <td style="width:25%;"><input name="lblnombcliente" class="form-control input-sm" id="lblnombcliente" style="width: 100%;"/></td>
                            </tr>
                        <tr class="espacio"></tr>
                          <tr>
                         <td style="width:15%;font-size: 12px">CORREO: <span style="color:red"> * </span></td>
                        <td style="width:25%;"><input type="email"  class="form-control input-sm" name="lblcorreo" id="lblcorreo" required="required"></td>
                            </tr>
                        <tr class="espacio"></tr>
                          <tr>
                         <td style="width:15%;font-size: 12px">DIRECCIÓN: <span style="color:red"> * </span></td>
                        <td style="width:25%;"><textarea class="form-control input-sm" name="lbldireccion" rows="1" style="resize:none" id="lbldireccion" placeholder="Ingresar..."></textarea></td>
                            </tr>
                        <tr class="espacio"></tr>
                          <tr>
                         <td style="width:15%;font-size: 12px">DISTRITO: <span style="color:red"> * </span></td>
                        <td style="width:25%;">
                        
                        <select class="form-control selectdistrito input-sm" name="lbldistrito" id="lbldistrito" style="width: 100%;">
                         <option value="">Seleccione</option>
                         </select></td>
                            </tr>
                        <tr class="espacio"></tr>
                          <tr>
                         <td style="width:15%;font-size: 12px">TELEFONO UNO: <span style="color:red"> * </span></td>
                        <td style="width:25%;"><input type="tel" class="form-control input-sm" name="lblmovil" id="lblmovil" value='<?php echo $telefonouno;?>' readonly="readonly"></td>
                            </tr>
                        <tr class="espacio"></tr>
                          <tr>
                         <td style="width:15%;font-size: 12px">TELEFONO DOS:</td>
                        <td style="width:25%;"><input type="tel" class="form-control input-sm" name="lblfijo" id="lblfijo" onkeypress="return event.charCode >= 48 && event.charCode <= 57" maxlength="9"></td>
                            </tr>
                        </table>
                        
                                       
                                    </div>
                                    <!-- /.box-body -->
                        
                                  </div>
                                <div class="box box-custom">
                                    <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                        <h5>INFORMACION DE LA VISITA</h5>  
                                        <div class="box-tools pull-right">
                                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                                        </div>
                                    </div>
                                    <div class="box-body">
                                        <div class="form-group">
                                            <label for="" class="">VISITA CONCERTADA:</label>
                                            <div class="input-group">
                                                <input type="checkbox" name="visitaConcertada" id="visitaConcertada" data-size="small"/>
                                                <input type="hidden" name="hidVisitaConcertada" id="hidVisitaConcertada" value="NO"/>
                                            </div>
                                        </div>
                                        <div class="form-group datosVisitaConcertada ocultar">
                                            <label for="" class="">FECHA VISITA:</label>
                                            <div class="input-group">
                                                <input type="text" class="form-control" id="fechaVisitaConcertada" name="fechaVisitaConcertada" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask="">
                            
                                                <div class="input-group-addon">
                                                  <i class="fa fa-calendar"></i>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group datosVisitaConcertada ocultar">
                                            <label>HORA VISITA:</label>
                        
                                            <div class="input-group">
                                                <input type="text" id="horaVisitaConcertada" name="horaVisitaConcertada" class="form-control timepicker">
                            
                                                <div class="input-group-addon">
                                                  <i class="fa fa-clock-o"></i>
                                                </div>
                                            </div>
                                            <!-- /.input group -->
                                        </div>
                                    </div>
                                </div>
                                <div class="box box-custom">
                                    <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                       <h5>INFORMACION DE LA OFERTA</h5>
                        
                                      <div class="box-tools pull-right">
                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                                      </div>
                                    </div>
                                    <!-- /.box-header -->
                                    <div class="box-body table-responsive">
                        
                        <table  cellspacing="0"  style="width:100%;padding: 15px;" >
                          <tr class="espacio"></tr>
                          <tr>
                         <td style="width:15%;font-size: 12px">ESTADO:</td>
                        <td style="width:25%;"><input type="text" name="lblestadoventa" id="lblestadoventa" class="form-control input-sm" style="width: 100%;" readonly="readonly" value="ProspectoRP"/>
                        <input id="lblestventa" name="lblestventa" hidden="" value="ProspectoRP" /></td>
                            </tr>
                         <tr class="espacio"></tr>
                            <tr>
                                 <td style="width:15%;font-size: 12px">RECURSO:</td>
                                <td style="width:25%;">
                                 <select class="form-control input-sm" name="lbltipoventa" id="lbltipoventa">>
                                        <option value="RP">RP</option>
                                        <option value="RPPR">RPPR</option>
                                        <option value="RPPA">RPPA</option>
                                    </select>
                                <input id="lbltiventa" name="lbltiventa" hidden="" /></td>
                            </tr>
                        <tr class="espacio"></tr>
                            <tr>
                                <td style="width:15%;font-size: 12px">SEGMENTO: <span style="color:red"> * </span></td>
                                <td style="width:25%;">
                                    <select class="form-control input-sm" name="lblsegmento" id="lblsegmento">
                                        <option value="">Seleccione</option>
                                        <option value="RES">RES</option>
                                        <option value="NEG">NEG</option>
                                    </select>
                                </td>
                            </tr>
                        <tr class="espacio"></tr>
                          <tr>
                             <td style="width:15%;font-size: 12px">MESES AUTORIZADOS:</td>
                            <td style="width:25%;">
                                <input type="number" maxlength="3" class="form-control input-sm" name="lblmesesautorizados" id="lblmesesautorizados" onkeypress="return filterFloat(event, this);"></td>
                        </tr>
                        <tr class="espacio"></tr>
                          <tr>
                         <td style="width:15%;font-size: 12px">PRECIO KIT:</td>
                        <td style="width:25%;"><div class="input-group">
                                                                                                    <div class="input-group-addon input-sm">
                                                                                                        <i class="">S/.</i>
                                                                                                    </div>
                                                                                                    <input type="number" class="form-control input-sm" name="lblpreciokit" id="lblpreciokit" onkeypress="return filterFloat(event, this);">
                                                                                                </div>
                        </td>
                            </tr>
                        
                        <tr class="espacio"></tr>
                          <tr>
                         <td style="width:15%;font-size: 12px">TOTAL EXTRA:</td>
                        <td style="width:25%;"><div class="input-group">
                                                                                                    <div class="input-group-addon input-sm">
                                                                                                        <i class="">S/.</i>
                                                                                                    </div>
                                                                                                    <input type="number" class="form-control input-sm" name="lbltotalextra" id="lbltotalextra" onkeypress="return filterFloat(event, this);">
                                                                                                </div></td>
                            </tr>
                        <tr class="espacio"></tr>
                          <tr>
                         <td style="width:15%;font-size: 12px">RESUMEN INST.:</td>
                        <td style="width:25%;"><textarea class="form-control input-sm" name="lblresumenventa" id="lblresumenventa" rows="1" style="resize:none" placeholder="Ingresar..."></textarea></td>
                            </tr>
                        <tr class="espacio"></tr>
                          <tr>
                         <td style="width:15%;font-size: 12px">REGALO AUTORIZADO:</td>
                        <td style="width:25%;"><select class="form-control input-sm" name="lblextraautorizado" id="lblextraautorizado">
                                                                                                    <option value="">Seleccione</option>
                                                                                                    <option value="Ninguno">Ninguno</option>
                                                                                                    <option value="Mando a distancia">Mando a distancia</option>
                                                                                                    <option value="Magnetico">Magnetico</option>
                                                                                                    <option value="Pulsador">Pulsador</option>
                        
                                                                                                </select></td>
                            </tr>
                        <tr class="espacio"></tr>
                          <tr>
                         <td style="width:15%;font-size: 12px">FORMA DE PAGO:</td>
                        <td style="width:25%;"><select class="form-control input-sm" name="lblformadepago" id="lblformadepago">
                                                                                                    <option value="">Seleccione</option>
                                                                                                    <option value="Cheque">Cheque</option>
                                                                                                    <option value="Deposito">Depósito</option>
                                                                                                    <option value="Transferencia">Transferencia</option>
                                                                                                    <option value="TransferenciaInterbancaria">Transferencia Interbancaria</option>
                                                                                                    <option value="PagoPOSVisa">Pago POSVisa</option>
                                                                                                    <option value="PagoPOSMC">Pago POSMC</option>
                                                                                                    <option value="TarjetadeCredito">Tarjeta de Crédito</option>
                                                                                                    <option value="PagoPasarella">Pago Pasarella</option>
                        
                                                                                                </select></td>
                            </tr>
                        
                        <tr class="espacio"></tr>
                          <tr>
                         <td style="width:15%;font-size: 12px">PAI:</td>
                        <td style="width:25%;"><select class="form-control input-sm" name="lblPAI" id="lblPAI">
                                                                                                    <option value="">Seleccione</option>
                                                                                                    <option value="BBVA-DIN">BBVA-DIN</option>
                                                                                                    <option value="PAI 30x36">PAI 30x36</option>
                                                                                                    <option value="NO">NO</option>
                                                                                                </select></td>
                            </tr>
                        
                        <tr class="espacio"></tr>
                                                                                            <tr>
                                                                                                <td style="width:15%;font-size: 12px">COMENTARIO PROSPECTO:</td>
                        
                                                                                                <td  style="width:50%"><textarea class="form-control input-sm" name="lblcomentarioprospecto" id="lblcomentarioprospecto" rows="2" style="resize:none" placeholder="Ingresar..."></textarea></td>
                        
                                                                                                   </tr>
                                                                                                   
                        <tr class="espacio cliente ocultarcliente"></tr>
                          <tr class="cliente ocultarcliente">
                             <td style="width:15%;font-size: 12px">CLIENTE REF:<span style="color:red"> * </span></td>
                            <td style="width:25%;">
                                <input type="number" maxlength="7" class="form-control input-sm" name="lblclienteref" id="lblclienteref" onkeypress="return filterFloat(event, this);"></td>
                        </tr>
                        <tr class="espacio colaborador ocultarcolaborador"></tr>
                          <tr class="colaborador ocultarcolaborador">
                             <td style="width:15%;font-size: 12px">TIPO DOCUMENTO COLABORADOR:<span style="color:red"> * </span></td>
                            <td style="width:25%;">
                                    <select class="form-control input-sm" name="lbltipodoc" id="lbltipodoc">
                                                                <option value="">Seleccione</option>
                                                                <option value="DNI">DNI</option>
                                                                <option value="EXTRANJERIA">EXTRANJERIA</option>
                                                            </select></td>
                        </tr>
                        <tr class="espacio colaborador ocultarcolaborador"></tr>
                          <tr class="colaborador ocultarcolaborador">
                             <td style="width:15%;font-size: 12px">DOCUMENTO COLABORADOR:<span style="color:red"> * </span></td>
                            <td style="width:25%;">
                                 <input type="text" class="form-control input-sm" name="lbldocumento" id="lbldocumento" maxlength="12" onkeypress="return filterFloat(event, this);"></td>
                        </tr>
                                                                                                
                        
                        </table>
                        
                                       
                                    </div>
                                    <!-- /.box-body -->

          </div>
                                                                                       
                            </form>
                            </div>
                         <div class="col-md-2"></div>
                    </div>
                    
                      
                    
         
                </section>
                <!-- /.content -->






            </div>
            <!-- /.content-wrapper -->
           


            <div class="control-sidebar-bg"></div>
        </div>
        <!-- ./wrapper -->
        
        
                
                
                
        <!-- jQuery v1.11 -->
  
        <script src="admin/bower_components/jquery/dist/jquery_v1.11.js" type="text/javascript"></script>

        <!-- jQuery UI 1.11.4 -->
        <script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
        <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
        <script>
        $.widget.bridge('uibutton', $.ui.button);</script>
        <!-- Bootstrap 3.3.7 -->
        <script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
        <!-- Select2 -->
        <script src="admin/bower_components/select2/dist/js/select2.full.min.js"></script>
        <!-- Sparkline -->
        <script src="admin/bower_components/jquery-sparkline/dist/jquery.sparkline.min.js"></script>
       <!-- Slimscroll -->
        <script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
        <!-- FastClick -->
        <script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
        <!-- AdminLTE App -->
        <script src="admin/dist/js/adminlte.min.js"></script>
        <!-- InputMask -->
        <script src="admin/plugins/input-mask/jquery.inputmask.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.date.extensions.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.extensions.js"></script>
        <!-- bootstrap datepicker -->
        <script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
        <script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>
       <!-- bootstrap time picker -->
       <script src="admin/plugins/timepicker/bootstrap-timepicker.min.js" type="text/javascript"></script>
     
         <!-- Alertify -->
        <script src="admin/bower_components/alertifyjs/alertify.min.js" type="text/javascript"></script>
        <!-- SweetAlert -->
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@8"></script>
        <!-- Bootstrap toogle -->
        <script src="admin/plugins/bootstrap-toggle-master/js/bootstrap-toggle.min.js"></script>

        <script>
                $("#lbltipodoc").change(function () {
                    var tipodoc = $("#lbltipodoc").val();
                   if(tipodoc=="DNI"){
                       $('#lbldocumento').attr('maxlength', 8);
                   }else{
                       $('#lbldocumento').attr('maxlength', 10);
                   }
                });  
                
                $("#lbldc").change(function () {
                    $("#lbldc option:selected").each(function () {
                       var lbldc = $(this).val();
                        $.post("./ajax/selectJefeVenta.php", { lbldc: lbldc }, function(data){
                            $("#lbljefeventa").html(data);
                        });            
                    });
                });

                $("#lblestadoventa").change(function () {
                    var condiciones = $("#lblestadoventa").val();
                    $("#lblestventa").val(condiciones);
                });


                $("#lbltipoventa").change(function () {
                   var tps= $("#lbltipoventa").val();
                    $("#lbltiventa").val(tps);
                    if(tps=="RPPR"){
                        $('.colaborador').removeClass('ocultarcolaborador');
                        $('.cliente').addClass('ocultarcliente');
                        
                    }else if(tps=="RPPA"){
                        $('.colaborador').addClass('ocultarcolaborador');
                        $('.cliente').removeClass('ocultarcliente');
                    }else{
                        $('.cliente').addClass('ocultarcliente');
                        $('.colaborador').addClass('ocultarcolaborador');
                    }
                
                });
   
                $('#lblmatricula').on('keyup', function () {
                    var dato = $('#lblmatricula').val();
                    var url = 'ajax/findMatricula.php';
                    $.ajax({
                        type: 'POST',
                        url: url,
                        data: 'dato=' + dato,
                        success: function (datos) {
                            $('.mensajematricula').html(datos);
                            
                        }
                    });
                    return false;
                });
               
                $("#lblmatricula").autocomplete({
                    source: "./ajax/selectMatricula.php",
                    minLength: 2,
                    select: function (event, ui) {
                        event.preventDefault();
                        $('#lblidusuario').val(ui.item.idusuario);
                        $('#lblmatricula').val(ui.item.matricula);
                        $('#lblnombcomercial').val(ui.item.comercial);
//                        $('#lbldc').val(ui.item.dc);
//                        $('#lbljefeventa').val(ui.item.jefe);
                     
                    }
                });

                $("#lblmatricula").on("keydown", function (event) {
                    if (event.keyCode == $.ui.keyCode.LEFT || event.keyCode == $.ui.keyCode.RIGHT || event.keyCode == $.ui.keyCode.UP || event.keyCode == $.ui.keyCode.DOWN || event.keyCode == $.ui.keyCode.DELETE || event.keyCode == $.ui.keyCode.BACKSPACE)
                    {
                        $('#lblidusuario').val("");
                        $('#lblmatricula').val("");
                        $('#lblnombcomercial').val("");
//                        $('#lbldc').val("");
//                        $('#lbljefeventa').val("");

                    }
                    if (event.keyCode == $.ui.keyCode.DELETE) {
                        $('#lblmatricula').val("");
                        $('#lblidusuario').val("");
                        $('#lblnombcomercial').val("");
//                        $('#lbldc').val("");
//                        $('#lbljefeventa').val("");
                    }
                });

        </script>
        
        <script>
            $('#visitaConcertada').bootstrapToggle({
                on:'SI',
                off:'NO',
                onstyle:'success',
                offstyle:'danger'
            });
            
            $('#visitaConcertada').change(function(){
                if($(this).prop('checked')){
                    $('#hidVisitaConcertada').val('SI');
                    $('.datosVisitaConcertada').removeClass('ocultar');
                    //.classList().remove('ocultar');
                }else{
                    $('#hidVisitaConcertada').val('NO');
                    $('.datosVisitaConcertada').addClass('ocultar');
                    //.classList().add('ocultar');
                }    
            });
            
            //Date picker
            $('#fechaVisitaConcertada').datepicker({
                autoclose: true,
                language: 'es',
                firstDay: 1,
                todayHighlight: true,
                format: 'dd/mm/yyyy',
                startDate: new Date(),
            });
                //Date picker
            $('#horaVisitaConcertada').timepicker({
                defaultTime:false,                                                                                    
                showInputs: true,
                minuteStep: 1
            });

        </script>

        <script>
            $(document).ready(function () {

                var alterClass = function () {
                    var ww = document.body.clientWidth;
                    if (ww < 767) {
                        $('body').removeClass('sidebar-collapse');
                    } else if (ww >= 768) {
                        $('body').addClass('sidebar-collapse');
                    }
                    ;
                };
    
                $(window).resize(function () {
                    alterClass();
                });
                //Fire it when the page first loads:
                alterClass();

                $('#btnGuardarEditarVenta').click(function () {
                var gestorcoordinadora='<?php echo $matriculausuario; ?>';
                var catgventa='ProspectoRP';
                
                                                                                                    
                 //Algunas variables por default de alertify
                alertify.defaults.theme.ok = "btn btn-nuevo";
                alertify.defaults.theme.cancel = "btn btn-danger";
                
                var lastX,lastY;
                    alertify.confirm('<span style="color:red"><i class="fa fa-warning"></i></span><strong> ADVERTENCIA</strong>', '¿Desea guardar los cambios que ha realizado?', function(){ if (validaForm()) {
                                        // Primero validará el formulario.
                var datos = $('#frmEditarVenta').serialize();
                var divLoading = $('#divLoading');
                        
                console.log(datos);
                        
                    $.ajax({
                        type: 'POST',
                        url: 'ajax/insertProspectorp.php',
                        data: "lblcategoria=" + catgventa + "&gestorcoordinadora="+gestorcoordinadora+"&"+datos,
                        dataType: "Json",
                        success: function (r) {
                                
                            console.log(r);
                            
                            
                            var resultado = r;
                            
                            if (resultado.respuesta == 'exito'){
                                Swal.fire({
                                  title: "Se generó Prospecto RP N°" + resultado.id_registro,
                                  text: '',
                                  type: 'success',
                                  confirmButtonColor: '#e4002b',
                                  confirmButtonText: 'Ok',
                                  allowOutsideClick: false
                                }).then((result) => {
                                  if (result.value) {
                                       location.href = 'editarconsultaformador.php?idprospectorp='+resultado.id_registro;
                                  }
                                })
                            } else {
                                Swal.fire({
                                    title: "Error",
                                    text: "Comuniquese con soporte en soporteit@verisure.pe",
                                    type: 'error'
                                });
                                alertify.error("No se han guardado los cambios"); 
                            }
                        }
                    });
                        
                    } }
                , function(){ alertify.error('No se han guardado los cambios')}).set({transition:'zoom','labels': {ok:'<i class="fa fa-check"></i> Aceptar', cancel:'<i class="fa fa-remove"></i> Cancelar'},'onshow':function(){
        
            lastX = window.scrollX;
        lastY = window.scrollY;
      },
      'onfocus':function(){
        window.scrollTo(lastX, lastY);
      }  }).show(); 
                                                                                    
                                                
                                                                                
                                                                                });
                                                                                
                $('.selectdistrito').select2({
                    placeholder: 'Seleccione Distrito - Provincia',
                    allowClear: true,
                    language: {
                        errorLoading: function () {
                            return "La carga falló";
                        },
                        noResults: function () {
                            return "No hay resultado";
                        },
                        searching: function () {

                            return "Buscando..";
                        }
                    },
                    ajax: {
                        url: 'ajax/selectDistrito.php',
                        dataType: 'json',
                        delay: 250,
                        processResults: function (data) {
                            return {
                                results: data
                            };
                        },
                        cache: true
                    }
                });

                $('.cbxtecnico').select2({
                    placeholder: 'Seleccione',
                    allowClear: true,
                    language: {
                        errorLoading: function () {
                            return "La carga falló";
                        },
                        noResults: function () {
                            return "No hay resultado";
                        },
                        searching: function () {
        
                            return "Buscando..";
                        }
                    }
                });
                                                                              
                $('#datemask').inputmask('dd/mm/yyyy', {'placeholder': 'dd/mm/yyyy'});

                $('#lblfecharecpciondoc').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });
                
                $('#lblfechafacturacion').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });
                
                //Money Euro
                $('[data-mask]').inputmask();
                //Date picker
                $('#fechainst').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });
                //Date picker
                $('#horainst').timepicker({
                     defaultTime:false,
                    showInputs: true,
                     minuteStep: 1
              });
              
                $('#mesano').datepicker({
                    autoclose: true,
                    language: 'en',
                    firstDay: 1, format: 'M-yyyy',
                    viewMode: "years",
                    minViewMode: "months"

                }).datepicker("setDate", new Date());

                $('#logcambios').click(function () {
                    refresh();
                });               
                                        
            });
                                                                            
            var  bloquear = function (condiciones){
                                                                           
                       $('#tinviable').hide();
                        $('#lblinviable').hide();
                         $('#lblinviable').disabled=true;
                        $('#tinviableespacio').hide();
                        
                        $('#tcancelado').hide();
                        $('#lblcancelado').hide();
                         $('#lblcancelado').disabled=true;
                        $('#tcanceladoespacio').hide();
                        
                                                                           
                    if (condiciones == "Inviable") {
                        $('#tinviable').show();
                        $('#lblinviable').show();
                        $('#lblinviable').show();
                        $('#lblinviable').disabled=false;
                        $('#tinviableespacio').show();
                        
                    }else if(condiciones=="Cancelado"){
                        $('#tcancelado').show();
                        $('#lblcancelado').show();
                        $('#lblcancelado').disabled=false;
                        $('#tcanceladoespacio').show();
                    
                    } 
                    else {
                        $('#tinviable').hide();
                        $('#lblinviable').hide();
                         $('#lblinviable').disabled=true;
                        $('#tinviableespacio').hide();
                        
                        $('#tcancelado').hide();
                        $('#lblcancelado').hide();
                         $('#lblcancelado').disabled=true;
                        $('#tcanceladoespacio').hide();
                       
                    }
    
    }
                                                    
            function validaForm() {
                // Campos de texto
                if ($("#frmEditarVenta #lblmatricula").val() == "") {
                    alertify.warning("Por favor ingresar la Matricula correspondiente");
                    $("#frmEditarVenta #lblmatricula").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }
                if ($("#frmEditarVenta #lblnombcomercial").val() == "") {
                    alertify.warning("Por favor ingresar la Matricula valida");
                    $("#frmEditarVenta #lblmatricula").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }
                 if ($("#frmEditarVenta #lbldc").val() == "" || $("#frmEditarVenta #lbldc").val() == "Seleccione" ) {
                    alertify.warning("Por favor ingresar CC correcto");
                    $("#frmEditarVenta #lbldc").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }
 
                if ($("#frmEditarVenta #lbljefeventa").val() == "" || $("#frmEditarVenta #lbljefeventa").val() == "No se encontraron resultado" || $("#frmEditarVenta #lbljefeventa").val() == "Seleccione") {
                    alertify.warning("Por favor revisar Jefe de Estructura Comercial");
                    $("#frmEditarVenta #lbljefeventa").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }

                
                if ($("#frmEditarVenta #lblestadoventa").val() == "Seleccione" || $("#frmEditarVenta #lblestadoventa").val() == "") {
                    alertify.warning("Por favor ingresar Estado de Venta correcto");
                    $("#frmEditarVenta #lblestadoventa").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lbltipoventa").val() == "Seleccione" || $("#frmEditarVenta #lbltipoventa").val() == "") {
                    alertify.warning("Por favor ingresar Recurso correcto");
                    $("#frmEditarVenta #lbltipoventa").focus();
                    return false;
                }

                if ($("#frmEditarVenta #lblnombcliente").val() == "") {
                    alertify.warning("Por favor ingresar Nombre del Cliente");
                    $("#frmEditarVenta #lblnombcliente").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lblcorreo").val() == "" || !/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test($("#frmEditarVenta #lblcorreo").val())) {
                    alertify.warning("Por favor ingresar correo válido");
                    $("#frmEditarVenta #lblcorreo").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lbldireccion").val() == "") {
                    alertify.warning("Por favor ingresar la Direccion del Cliente");
                    $("#frmEditarVenta #lbldireccion").focus();
                    return false;
                }

                if ($("#frmEditarVenta #lbldistrito").val() =="" || $("#frmEditarVenta #lbldistrito").val() =="Seleccione") {
                    alertify.warning("Por favor ingresar Distrito correcto");
                 
                    $("#frmEditarVenta #lbldistrito").select2('open');
                    return false;
                }
                
                 
                if ($("#frmEditarVenta #lblmovil").val() == "") {
                    alertify.warning("Por favor ingresar Teléfono Uno");
                    $("#frmEditarVenta #lblmovil").focus();
                    return false;
                }
                
                if (!/^([0-9])*$/.test($("#frmEditarVenta #lblfijo").val()) ) {
                    alertify.warning("El valor de Teléfono Dos no es un número");
                    $("#frmEditarVenta #lblfijo").focus();
                    return false;
                }
                
                if ($("#frmEditarVenta #lblsegmento").val() == "") {
                    alertify.warning("Por favor ingresar Segmento");
                    $("#frmEditarVenta #lblsegmento").focus();
                    return false;
                }

                if ($("#frmEditarVenta #lbltipoventa").val() == "RPPR") {
                    
                        if ($("#frmEditarVenta #lbltipodoc").val() == "") {
                           alertify.warning("Por favor Seleccionar Tipo Documento Colaborador");
                           $("#frmEditarVenta #lbltipodoc").focus();
                           return false;
                        }
                        
                        if ($("#frmEditarVenta #lbldocumento").val() == "") {
                           alertify.warning("Por favor ingresar Documento Colaborador");
                           $("#frmEditarVenta #lbldocumento").focus();
                           return false;
                        }
                        

                        if ($("#frmEditarVenta #lbltipodoc").val() == "DNI") {
                            if ($("#frmEditarVenta #lbldocumento").val().length!=8) {
                               alertify.warning("Por favor ingresar los 8 digitos del DNI del Colaborador");
                               $("#frmEditarVenta #lbldocumento").focus();
                               return false;
                            }
                        }
                        if ($("#frmEditarVenta #lbltipodoc").val() == "EXTRANJERIA") {
                            if ($("#frmEditarVenta #lbldocumento").val().length!=10) {
                               alertify.warning("Por favor ingresar los 10 digitos de EXTRANJERIA del Colaborador");
                               $("#frmEditarVenta #lbldocumento").focus();
                               return false;
                            }
                        } 
                       
                   
                }
                
                if ($("#frmEditarVenta #lbltipoventa").val() == "RPPA") {
                  if ($("#frmEditarVenta #lblclienteref").val() == "") {
                               alertify.warning("Por favor rellenar el campo Cliente Referido");
                               $("#frmEditarVenta #lblclienteref").focus();
                               return false;
                            }
                        if ($("#frmEditarVenta #lblclienteref").val().length!=7) {
                               alertify.warning("Por favor completar los 7 digitos del Cliente Referido");
                               $("#frmEditarVenta #lblclienteref").focus();
                               return false;
                            }            
                            
                }

                return true; 
            }

            var calcDataTableHeight = function () {
                return $(window).height() * 65 / 100;
            };

            function filterFloat(evt, input) {
                // Backspace = 8, Enter = 13, ‘0′ = 48, ‘9′ = 57, ‘.’ = 46, ‘-’ = 43
                var key = window.Event ? evt.which : evt.keyCode;
                var chark = String.fromCharCode(key);
                var tempValue = input.value + chark;
                if (key >= 48 && key <= 57) {
                    if (filter(tempValue) === false) {
                        return false;
                    } else {
                        return true;
                    }
                } else {
                    if (key == 8 || key == 13 || key == 0) {
                        return true;
                    } else if (key == 46) {
                        if (filter(tempValue) === false) {
                            return false;
                        } else {
                            return true;
                        }
                    } else {
                        return false;
                    }
                }
            }

            function filter(__val__) {
                var preg = /^([0-9]+\.?[0-9]{0,2})$/;
                if (preg.test(__val__) === true) {
                    return true;
                } else {
                    return false;
                }

            }


        </script>






    </body>
</html>
