<?php
ini_set("session.cookie_lifetime","7200");
ini_set("session.gc_maxlifetime","7200");
session_start();

date_default_timezone_set('America/Lima');
include 'config/db.php';
include 'config/conexion.php';
/*
include 'config/dbsec.php';
include 'config/conexionsec.php';
*/
if (!isset($_SESSION['user_login_status'])) {
        header("location: ./login/index.php");
		exit;
        }


if ($_SESSION['pzmdptransaccion']==0) {
     header("location: ./denegado.php");
		exit;
        }
?>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title>Verisure | VeriSmart</title>
        <!-- Tell the browser to be responsive to screen width -->
        <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
        <link rel="icon" type="image/png" href="admin/dist/img/-apple-touch-icon-144x144.png" >
        <!-- Bootstrap 3.3.7 -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css">
        <!-- Font Awesome -->
        <link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
        <!-- Ionicons -->
        <link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">
        <!-- Select2 -->
        <link rel="stylesheet" href="admin/bower_components/select2/dist/css/select2.min.css">
        <!-- Theme style -->
        <link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
        <!-- AdminLTE Skins. Choose a skin from the css/skins
             folder instead of downloading all of them to reduce the load. -->
        <link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">
        
        
        <link rel="stylesheet" href="admin/bower_components/datatables.net-bs/css/dataTables.bootstrap.min.css">
        
        <!-- daterange picker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-daterangepicker/daterangepicker.css">
        <!-- bootstrap datepicker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
        <!-- iCheck for checkboxes and radio inputs -->
        <link rel="stylesheet" href="admin/plugins/iCheck/all.css">
        <!-- Bootstrap Color Picker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-colorpicker/dist/css/bootstrap-colorpicker.min.css">
        <!-- Bootstrap time Picker -->
        <link rel="stylesheet" href="admin/plugins/timepicker/bootstrap-timepicker.min.css">
        

        <link href="admin/bower_components/bootstrap-table/dist/bootstrap-table.min.css" rel="stylesheet" type="text/css"/>
        <!-- bootstrap wysihtml5 - text editor -->
        <link rel="stylesheet" href="admin/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css">

        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->

        <link href="admin/bower_components/bootstrap-table/dist/bootstrap-table.min.css" rel="stylesheet" type="text/css"/>

        <!-- Google Font -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">

        <!-- Alertifyjs -->
        <link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css"/>
        <link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css"/>
        
        <!-- EMU - ESTILOS PERSONALES -->
        <link rel="stylesheet" href="css/main.css">

        <style>

            .modal-header-danger {
                color:#fff;
                background-color: #fb1e1e;              
            }

            @media (min-height: 500px) {
                .modal-body { height: 400px; }
            }

            @media (min-height: 800px) {
                .modal-body { height: 400px; }
            }
            .modal-body {width: 100%;height:400px;
            }

            .espacio{
                height:10px;
            }

            .espacio2{
                height:15px;
            }

            .thumbnail_style{
                text-align:center;
                border:none;
            }


            .caption h4{
                margin-top: -10px;
                font-size:13px;
                font-weight:  bold;
            }

            .caption p{
                color:#777;
                font-size:13px;
            }

            .caption a{
                color:#777;
                font-size:10px;
            }


            #myWizard2 .form-control{
                border-radius: 4px
            }

            #c-slider{
                margin: auto;
                width: 100%;
                max-width: 900px;
                position: relative;
                overflow: hidden;

            }
            #slider{
                display: flex;
                width: 200%;

            }
            #slider section{
                width: 100%;
            }
            
            .select2-container--default .select2-selection--single {
                border: 1px solid #d2d6de;
                border-radius: 4px;
                font-size: 16x;
            }
            
            .select2-selection__rendered {
                font-size: 16px;
            }
            
            .select2-selection__rendered span{
                font-size: 18px;
                color: #e4002b;
                font-wight: bold;
            }

            .btn-nuevo { 
                color: #FFFFFF; 
                background-color: #444444; 
                border-color: #444444; 
            } 

            .btn-nuevo:hover, 
            .btn-nuevo:focus, 
            .btn-nuevo:active, 
            .btn-nuevo.active, 
            .open .dropdown-toggle.btn-nuevo { 
                color: #FFFFFF; 
                background-color: #616161;  
                border-color: #444444; 
            } 

            .btn-nuevo:active, 
            .btn-nuevo.active, 
            .open .dropdown-toggle.btn-nuevo { 
                background-image: none; 
            } 

            .btn-nuevo.disabled, 
            .btn-nuevo[disabled], 
            fieldset[disabled] .btn-nuevo, 
            .btn-nuevo.disabled:hover, 
            .btn-nuevo[disabled]:hover, 
            fieldset[disabled] .btn-nuevo:hover, 
            .btn-nuevo.disabled:focus, 
            .btn-nuevo[disabled]:focus, 
            fieldset[disabled] .btn-nuevo:focus, 
            .btn-nuevo.disabled:active, 
            .btn-nuevo[disabled]:active, 
            fieldset[disabled] .btn-nuevo:active, 
            .btn-nuevo.disabled.active, 
            .btn-nuevo[disabled].active, 
            fieldset[disabled] .btn-nuevo.active { 
                background-color: #444444; 
                border-color: #444444; 
            } 

        </style>
        <!-- ESTILO DIV CARGANDO -->
        <style>
            #divLoading {
                height: 100%;
                position: relative;
                display: none;
            }
            
            #divLoading {
                text-align:center;
            }
            
            
        </style>
        <!-- FIN ESTILO DIV CARGANDO -->
        <style>
       .main-header,.main-sidebar,.left-side{position:fixed}
       
      .main-header {
    top: 0;
    right: 0;
    left: 0
}
 .content-wrapper,
 .right-side {
    padding-top: 50px
}

@media (max-width:767px) {
     .content-wrapper,
     .right-side {
        padding-top: 100px
    }
}

.layout-boxed .wrapper {
    max-width: 100%
}

.wrapper {
    overflow: hidden

 .control-sidebar {
    position: fixed;
    height: 100%;
    overflow-y: auto;
    padding-bottom: 50px
}       
        
        

  </style>
        <style> html, body { margin: 0; padding: 0; height: 100%; } </style>

        <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">
        <style>


            .ui-autocomplete {
                position: absolute;
                z-index: 1000;
                cursor: default;
                padding: 0;
                margin-top: 2px;
                list-style: none;
                font-size: 11px;
                font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
                background-color: #ffffff;
                border: 1px solid #ccc;
                -webkit-border-radius: 5px;
                -moz-border-radius: 5px;
                border-radius: 5px;
                -webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                -moz-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);

                z-index: 1051 !important;    

            }

  input[type="search"]::-webkit-search-cancel-button {
    -webkit-appearance: searchfield-cancel-button;
  }
  
  
  
  .pie-title-center {
                display: inline-block;
                position: relative;
                text-align: center;
            }

            .pie-value {
                display: block;
                position: absolute;
                font-size: 25px;
                height: 40px;
                top: 50%;
                left: 0;
                right: 0;
                margin-top: -20px;
                line-height: 40px;
            }
            
                        .label-ico{
                background:#e30613;
                color:#fff;
                padding: 6px 6px 6px;
                font-size:14px;

            }
            .offer-radius{
                border-radius:7px;
            }

        </style>






    </head>


    <body class="sidebar-collapse skin-red sidebar-mini">

        <div class="wrapper">
            <!-- Header -->
            <?php include 'admin/header.php'; ?>
            <!-- Left side column. contains the logo and sidebar -->
            <?php
 
            
            $mediodepagos="active";
            $mdptransaccion="active";

            include 'admin/main-sidebar.php';
            ?>


            <!-- Content Wrapper. Contains page content -->
            <div class="content-wrapper">
                <!-- Content Header (Page header) -->
                <section class="content-header">
                    <div style="font-size:180%;"> MEDIO DE PAGOS &nbsp <span style="font-size:80%;color:#DAD8D4"> | &nbsp <span style="font-size:80%;color:#8D8A80"> TRANSACCIONES VENTA</span></span> </div> 
                    <ol class="breadcrumb">
                        <li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
                        <li><a href="mediosdepagos.php">MDP</a></li>
                        <li class="active">Registro</li>
                    </ol>
    
    
                </section>
    
                <!-- Main content -->
                <section class="content">
                    
                    
                    <div class="row">
                        
                        <div class="col-md-12">
                            <div class="box box-danger">
                                <div class="box-header">
                                    <div class="col-md-12">
                                        </br>
                                        </br>
                                    </div>
                                    <!-- TOTAL TRANSACCIONES -->
                                    <div class="col-md-12">
                                    
                                            <div class="col-md-2" id="totalRefresh">
                                                <a href="#" style="color:black">
                                                <div class="info-box caja-total">
                                                <span class="info-box-icon bg-red"><i class="fa fa-exchange"></i></span>
                                    
                                                <div class="info-box-content">
                                                  <span class="info-box-text">Transacciones: </span>
                                                  <?php
                                                        $sqltotalcantidad = "SELECT COUNT(*) AS Total FROM tbltransaccion";
                                                        $resultadocantidad = $con->query($sqltotalcantidad);
                                                        $totaltransacciones = $resultadocantidad->fetch_assoc();
                                                  ?>
                                                  <span class="info-box-number"><?php echo $totaltransacciones['Total']; ?></span>
                                                </div>
                                                <!-- /.info-box-content -->
                                              </div>
                                              </a>
                                            </div>
                                    
                                            <div class="col-md-10">
                                                <div class="box-body no-padding">
                                                    <div class="row">
                                    
                                                        <div class="col-md-3" id="visa-refresh">
                                    
                                                            <?php
                                                                $sqltotalcantidadvisa = "SELECT COUNT(*) AS Total FROM tbltransaccion WHERE TarjetaMarca = 'VISA' ";
                                                                $resultadocantidadvisa = $con->query($sqltotalcantidadvisa);
                                                                $totalvisa = $resultadocantidadvisa->fetch_assoc();
                                    
                                                                if ($totaltransacciones['Total'] == '0'){
                                                                    $porcentajeTotalTransacciones = 0;
                                                                } else {
                                                                    $porcentajeTotalTransacciones = round(($totalvisa['Total']/$totaltransacciones['Total'])*100);
                                                                }
                                                            ?>
                                                                <a href="#" style="color:black">
                                                                <div class="small-box" style="background: #fff;">
                                                                    <div class="inner">
                                                                      <h3><?php echo $totalvisa['Total']; ?></h3>
                                        
                                                                      <p>Transacciones</p>
                                                                      
                                                                    </div>
                                                                    <div class="logoTarjetaCredito">
                                                                        <img src="img/credit/Visa3.png">
                                                                    </div>
                                                                    <div class="info-box-content" style="margin:0">
                                                                        <div class="progress" style="margin:0">
                                                                        <div class="progress-bar" style="width: <?php echo $porcentajeTotalTransacciones; ?>%"></div>
                                                                        </div>
                                                                        <span>
                                                                            <?php echo $porcentajeTotalTransacciones; ?>%
                                                                         </span>
                                                                    </div>
                                        
                                                                  </div>
                                                                  </a>
                                                        </div>
                                                        <div class="col-md-3" id="MC-refresh">
                                    
                                                            <?php
                                                                $sqltotalcantidadMC = "SELECT COUNT(*) AS Total FROM tbltransaccion WHERE TarjetaMarca = 'MASTERCARD' ";
                                                                $resultadocantidadMC = $con->query($sqltotalcantidadMC);
                                                                $totalmarcaMC = $resultadocantidadMC->fetch_assoc();
                                    
                                                                if ($totaltransacciones['Total'] == '0'){
                                                                    $porcentajeTotalTransacciones = 0;
                                                                } else {
                                                                    $porcentajeTotalTransacciones = round(($totalmarcaMC['Total']/$totaltransacciones['Total'])*100);
                                                                }
                                                            ?>
                                                            <a href="#" style="color:black">
                                                                <div class="small-box">
                                                                    <div class="inner">
                                                                      <h3><?php echo $totalmarcaMC['Total']; ?></h3>
                                        
                                                                      <p>Transacciones</p>
                                                                    </div>
                                                                    <div class="logoTarjetaCredito">
                                                                        <img src="img/credit/MasterCard3.png">
                                                                    </div>
                                                                    <div class="info-box-content" style="margin:0">
                                                                        <div class="progress" style="margin:0">
                                                                        <div class="progress-bar" style="width: <?php echo $porcentajeTotalTransacciones; ?>%"></div>
                                                                        </div>
                                                                        <span>
                                                                            <?php echo $porcentajeTotalTransacciones; ?>%
                                                                         </span>
                                                                    </div>
                                        
                                                                  </div>
                                                                  </a>
                                                        </div>
                                                        <div class="col-md-3" id="dinners-refresh">
                                    
                                                            <?php
                                                                $sqltotalcantidadDINNERS = "SELECT COUNT(*) AS Total FROM tbltransaccion WHERE TarjetaMarca = 'DINNERS' ";
                                                                $resultadocantidadDINNERS = $con->query($sqltotalcantidadDINNERS);
                                                                $totalmarcaDINNERS = $resultadocantidadDINNERS->fetch_assoc();
                                    
                                                                if ($totaltransacciones['Total'] == '0'){
                                                                    $porcentajeTotalTransacciones = 0;
                                                                } else {
                                                                    $porcentajeTotalTransacciones = round(($totalmarcaDINNERS['Total']/$totaltransacciones['Total'])*100);
                                                                }
                                                            ?>
                                                            <a href="#" style="color:black">
                                                                <div class="small-box">
                                                                    <div class="inner">
                                                                      <h3><?php echo $totalmarcaDINNERS['Total']; ?></h3>
                                        
                                                                      <p>Transacciones</p>
                                                                    </div>
                                                                    <div class="logoTarjetaCredito">
                                                                        <img src="img/credit/diners3.png">
                                                                    </div>
                                                                    <div class="info-box-content" style="margin:0">
                                                                        <div class="progress" style="margin:0">
                                                                        <div class="progress-bar" style="width: <?php echo $porcentajeTotalTransacciones; ?>%"></div>
                                                                        </div>
                                                                        <span>
                                                                            <?php echo $porcentajeTotalTransacciones; ?>%
                                                                         </span>
                                                                    </div>
                                        
                                                                  </div>
                                                                  </a>
                                                        </div>
                                                        <div class="col-md-3" id="amex-refresh">
                                                            <?php
                                                                $sqltotalcantidadAMEX = "SELECT COUNT(*) AS Total FROM tbltransaccion WHERE TarjetaMarca = 'AMEX' ";
                                                                $resultadocantidadAMEX = $con->query($sqltotalcantidadAMEX);
                                                                $totalmarcaAMEX = $resultadocantidadAMEX->fetch_assoc();
                                    
                                                                if ($totaltransacciones['Total'] == '0'){
                                                                    $porcentajeTotalTransacciones = 0;
                                                                } else {
                                                                    $porcentajeTotalTransacciones = round(($totalmarcaAMEX['Total']/$totaltransacciones['Total'])*100);
                                                                }
                                    
                                                            ?>
                                                            <a href="#" style="color:black">
                                                                <div class="small-box">
                                                                    <div class="inner">
                                                                      <h3><?php echo $totalmarcaAMEX['Total']; ?></h3>
                                        
                                                                      <p>Transacciones</p>
                                                                    </div>
                                                                    <div class="logoTarjetaCredito">
                                                                        <img src="img/credit/american3.png">
                                                                    </div>
                                                                    <div class="info-box-content" style="margin:0">
                                                                        <div class="progress" style="margin:0">
                                                                        <div class="progress-bar" style="width: <?php echo $porcentajeTotalTransacciones; ?>%"></div>
                                                                        </div>
                                                                        <span>
                                                                            <?php echo $porcentajeTotalTransacciones; ?>%
                                                                         </span>
                                                                    </div>
                                        
                                                                </div>
                                                                </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                    
                                    </div> <!-- FIN TOTAL TRANSACCIONES -->
                                    <!-- TOTAL URL ACTIVA -->
                                    <div class="col-md-12">
                                            <div class="col-md-2">
                                                <div class="info-box caja-total">
                                                <span class="info-box-icon bg-red"><i class="fa  fa-arrow-circle-right"></i></span>
                                    
                                                <div class="info-box-content">
                                                  <span class="info-box-text" id="lblCodigoMDP">
                                                      <?php $sqlURL = "select m.URL,m.CodigoMDP FROM tblmdp m where m.estadoURL = 'ACTIVO' and m.Area='Venta'";
                                                            $resultadoURL = $con->query($sqlURL);
                                                            $nombreURL= $resultadoURL->fetch_assoc();
                                                            $CodigoUrl = $nombreURL['CodigoMDP'];
                                    
                                                            echo $CodigoUrl;
                                    
                                                        ?>
                                                  </span>
                                                  <input type="hidden" id="val_CodigoMDP" value="<?php echo $CodigoUrl; ?>">
                                                  <span class="info-box-number" id="lblTotalUrlActivo">
                                                  <?php
                                                  $sqlCantidadUrlActiva = "SELECT COUNT(*) as TOTAL_TRANSACCIONES_ACTIVA from tbltransaccion t JOIN tblmdp m on t.IdMdp = m.IdMdp where m.CodigoMDP= '".$CodigoUrl."' and m.Area='Venta'";
                                                         $resultadoCantidadUrlActiva = $con->query($sqlCantidadUrlActiva);
                                                         $CantidadUrlActiva= $resultadoCantidadUrlActiva->fetch_assoc();
                                                         $TotalUrlActivo = $CantidadUrlActiva['TOTAL_TRANSACCIONES_ACTIVA'];
                                    
                                                  echo $TotalUrlActivo; ?>
                                                  </span>
                                                  <input type="hidden" id="val_TotalUrlActivo" value="<?php echo $TotalUrlActivo?>">
                                                </div>
                                                <!-- /.info-box-content -->
                                              </div>
                                            </div>
                                    
                                            <div class="col-md-10">
                                    
                                                <?php $sqlUrlActiva = "SELECT t.TarjetaMarca,COUNT(*) AS Total FROM tbltransaccion t inner join tblmdp m on t.IdMdp = m.IdMdp WHERE m.estadoURL= 'activo' and m.Area='Venta' GROUP by TarjetaMarca ";
                                                      $resultadoUrlActiva = $con->query($sqlUrlActiva);
                                    
                                                      $arreglo_registros = array();
                                    
                                    
                                    
                                                      while($registro_Url = $resultadoUrlActiva->fetch_assoc()){
                                                          $registro['marca'] = $registro_Url['TarjetaMarca'];
                                                          $registro['total'] = $registro_Url['Total'];
                                    
                                                          $arreglo_registros[] = $registro;
                                                       }
                                    
                                    
                                                    $encode= json_encode($arreglo_registros);
                                                    $array = json_decode($encode);
                                    
                                    
                                                ?>
                                    
                                                <div class="box-body no-padding">
                                                    <div class = "row">
                                                        <div class="col-md-3">
                                                            <?php
                                    
                                                                if (!empty($array)) {
                                    
                                                                    foreach($array as $obj){
                                                                        if ($obj->marca == 'VISA'){
                                                                        $TotalVisa = $obj->total;
                                                                        $porcentajeVisa = round(($TotalVisa/$TotalUrlActivo)*100);
                                                                        break;
                                                                    } else {
                                                                            $TotalVisa = 0;
                                                                            $porcentajeVisa = 0;
                                                                        }
                                                                    }
                                                                } else {
                                                                    $TotalVisa = 0;
                                                                    $porcentajeVisa= 0;
                                    
                                                                }
                                                            ?>
                                    
                                                        <div class="small-box">
                                                                <div class="inner">
                                                                  <h3  id="Total_URL_VISA"><?php echo $TotalVisa; ?></h3>
                                                                  <input type="hidden" id="val_Total_URL_VISA" value="<?php echo $TotalVisa?>">
                                                                  <p>Transacciones</p>
                                                                </div>
                                                                <div class="logoTarjetaCredito">
                                                                    <img src="img/credit/Visa3.png">
                                                                </div>
                                                                <div class="info-box-content" style="margin:0">
                                                                    <div class="progress" style="margin:0">
                                                                    <div class="progress-bar" id="PorcentajeTotalVisa" style="width: <?php echo $porcentajeVisa; ?>%">
                                                                    </div>
                                                                    </div>
                                                                    <span id="lblPorcentajeTotalVisa">
                                                                        <?php echo $porcentajeVisa; ?>%
                                                                     </span>
                                                                    <input type="hidden" id="val_Porcentaje_Total_Visa" value="<?php echo $porcentajeVisa?>">
                                                                </div>
                                    
                                                        </div>
                                    
                                                        </div>
                                                        <div class="col-md-3">
                                                            <?php
                                                                    if (!empty($array)) {
                                                                        foreach($array as $obj){
                                    
                                                                        if ($obj->marca == 'MASTERCARD'){
                                                                            $TotalMC = $obj->total;
                                                                            $porcentajeMC = round(($TotalMC/$TotalUrlActivo)*100);
                                                                            break;
                                                                        } else {
                                                                            $TotalMC = 0;
                                                                            $porcentajeMC = 0;
                                                                        }
                                                                        } /* END FOR EACH */
                                                                    } else {
                                                                        $TotalMC = 0;
                                                                        $porcentajeMC = 0;
                                                                    }
                                    
                                                                ?>
                                    
                                                            <div class="small-box">
                                    
                                                                <div class="inner">
                                                                  <h3 id="Total_URL_MC"><?php echo $TotalMC; ?></h3>
                                                                  <input type="hidden" id="val_Total_URL_MC" value="<?php echo $TotalMC?>">
                                                                  <p>Transacciones</p>
                                                                </div>
                                                                <div class="logoTarjetaCredito">
                                                                    <img src="img/credit/MasterCard3.png">
                                                                </div>
                                                                <div class="info-box-content" style="margin:0">
                                                                    <div class="progress" style="margin:0">
                                                                    <div class="progress-bar" id="PorcentajeTotalMC" style="width: <?php echo $porcentajeMC; ?>%"></div>
                                                                    </div>
                                                                    <span id="lblPorcentajeTotalMC">
                                                                        <?php echo $porcentajeMC; ?>%
                                                                     </span>
                                                                    <input type="hidden" id="val_Porcentaje_Total_MC" value="<?php echo $porcentajeMC?>">
                                                                </div>
                                                              </div>
                                    
                                                        </div>
                                                        <div class="col-md-3" >
                                    
                                                            <div class="small-box">
                                                                <?php
                                                                    if (!empty($array)) {
                                                                        foreach($array as $obj){
                                                                        if ($obj->marca == 'DINNERS'){
                                                                            $Totaldiners = $obj->total;
                                                                            $porcentajediners = round(($Totaldiners/$TotalUrlActivo)*100);
                                                                            break;
                                                                        } else {
                                                                            $Totaldiners = 0;
                                                                            $porcentajediners = 0;
                                                                        }
                                                                        }
                                                                    } else {
                                                                        $Totaldiners = 0;
                                                                        $porcentajediners = 0;
                                                                    }
                                                                ?>
                                                                <div class="inner">
                                                                  <h3 id="Total_URL_DINERS"><?php echo $Totaldiners; ?></h3>
                                                                  <input type="hidden" id="val_Total_URL_DINERS" value="<?php echo $Totaldiners?>">
                                                                  <p>Transacciones</p>
                                                                </div>
                                                                <div class="logoTarjetaCredito">
                                                                    <img src="img/credit/diners3.png">
                                                                </div>
                                                                <div class="info-box-content" style="margin:0">
                                                                    <div class="progress" style="margin:0">
                                                                    <div class="progress-bar" id="PorcentajeTotaldiners" style="width: <?php echo $porcentajediners; ?>%"></div>
                                                                    </div>
                                                                    <span id="lblPorcentajeTotaldiners">
                                                                        <?php echo $porcentajediners; ?>%
                                                                     </span>
                                                                     <input type="hidden" id="val_Porcentaje_Total_DINERS" value="<?php echo $porcentajediners?>">
                                                                </div>
                                    
                                                              </div>
                                                        </div>
                                                        <div class="col-md-3">
                                                            <div class="small-box">
                                                                <?php
                                                                    if (!empty($array)) {
                                                                        foreach($array as $obj){
                                    
                                                                        if ($obj->marca == 'AMEX'){
                                                                            $TotalAMEX = $obj->total;
                                                                            $porcentajeAMEX = round(($TotalAMEX/$TotalUrlActivo)*100);
                                                                            break;
                                                                        } else {
                                                                            $TotalAMEX = 0;
                                                                            $porcentajeAMEX = 0;
                                                                        }
                                                                        }
                                                                    } else {
                                                                        $TotalAMEX = 0;
                                                                        $porcentajeAMEX = 0;
                                                                    }
                                                                ?>
                                                                <div class="inner">
                                                                  <h3 id="Total_URL_AMEX"><?php echo $TotalAMEX; ?></h3>
                                                                  <input type="hidden" id="val_Total_URL_AMEX" value="<?php echo $TotalAMEX?>">
                                                                  <p>Transacciones</p>
                                                                </div>
                                                                <div class="logoTarjetaCredito">
                                                                    <img src="img/credit/american3.png">
                                                                </div>
                                                                <div class="info-box-content" style="margin:0">
                                                                    <div class="progress" style="margin:0">
                                                                    <div class="progress-bar" id="PorcentajeTotalAMEX" style="width:  <?php echo $porcentajeAMEX; ?>%"></div>
                                                                    </div>
                                                                    <span id="lblPorcentajeTotalAMEX">
                                                                         <?php echo $porcentajeAMEX; ?>%
                                                                     </span>
                                                                     <input type="hidden" id="val_Porcentaje_Total_AMEX" value="<?php echo $porcentajeAMEX; ?>">
                                                                </div>
                                    
                                                              </div>
                                    
                                                        </div>
                                    
                                                    </div>
                                                </div>
                                                <div class="box-footer"></div>
                                            </div>
                                    
                                    </div> <!-- FIN TOTAL URL ACTIVAS -->

                                    <!-- FILTROS COMBO BOX -->        
                                    <div class="col-md-9">
                                                <form name="form_buscar" action="">
                                                <!-- <div class="form-group" > -->
                                                <div class="col-md-3">
                                                    <select class="form-control filtro_url"
                                                            style="width: 100%; font-size: 18px;" name="CodigoMdp" id="CodigoMdp" onchange="fun_buscar_url_2(this.form)">
                                                         <option selected="selected" value="0">--SELECCIONAR URL--</option>
                                                        <?php
                                                                        try{
                                                                            $sqlURL = "SELECT IdMdp, CodigoMDP FROM tblmdp where Area='Venta' order by estadoURL";
                                                                            $resultadoURL = $con->query($sqlURL);
                                                                            while ($codigoMDP = $resultadoURL->fetch_assoc()){ ?>
                                                                            <option value="<?php echo $codigoMDP['IdMdp']; ?>"><?php echo $codigoMDP['CodigoMDP']; ?></option>
                                                                        <?php }
                                                                        } catch (\Exception $e) {
                                                                            echo "Error: " . $e.getMessage();
                                                                        }
                                                                    ?>
                                                    </select>
                                                </div>
                                                  <!--  </div> -->
                                                  <!--  
                                                 <div class="col-md-2">
                                                    <select name="MarcaTarjeta" id="MarcaTarjeta" class="form-control filtro_marca_tarjeta" style="font-size: 18px; width: 100%;"
                                                            onchange="fun_buscar_MarcaTarjeta(this.form)">
                                                        <option selected="selected" value="0">--SELECCIONAR MARCA TARJETA--</option>
                                                        <option value="VISA">VISA</option>
                                                        <option value="MASTERCARD">MASTERCARD</option>
                                                        <option value="DINNERS">DINNERS</option>
                                                        <option value="AMEX">AMERICAN EXPRESS</option>
                                                    </select>
                                                 </div>
                                                 -->
                                                 <div class="col-md-5">
                                                     <select class="form-control select2" multiple="multiple" data-placeholder="Seleccione Marca de Tarjeta" name="MarcaTarjeta2" id="MarcaTarjeta2"
                                                            style="width: 100%;" onchange="fun_buscar_url_3(this.form)">
                                                        <option value="VISA">VISA</option>
                                                        <option value="MASTERCARD">MASTERCARD</option>
                                                        <option value="DINNERS">DINNERS</option>
                                                        <option value="AMEX">AMERICAN EXPRESS</option>
                                                    </select>
                                                 </div>
                                                  <div class="col-md-4">
                                                     <select class="form-control select2" multiple="multiple" data-placeholder="Seleccione CC" name="DCBiling" id="DCBiling"
                                                            style="width: 100%;" onchange="fun_buscar_url_3(this.form)">
                                                        <option value="150">150</option>
                                                        <option value="151">151</option>
                                                        <option value="152">152</option>
                                                        <option value="153">153</option>
                                                        <option value="154">154</option>
                                                        <option value="155">155</option>
                                                        <option value="120">120</option>
                                                        <option value="40">40</option>
                                                        <option value="41">41</option>
                                                        <option value="511">511</option>
                                                        <option value="512">512</option>
                                                        <option value="910">910</option>
                                                    </select>
                                                 </div>
                                                 </form>
                                            </div> <!-- FIN FILTROS COMBO BOX -->
                                    <!-- BOTON REFRESH -->
                                    <div class="box-tools pull-right">
                                        <?php if($nombacceso=='test'){ }else { ?>
                                         <a class="btn btn-success btn-sm"  href="#" style="border-radius: 0px;" onclick="Export()"><i class="fa  fa-download"></i></a>
                                        <?php } ?>
                                         <a class="btn btn-nuevo btn-sm"  href="#" style="border-radius: 0px;" onclick="javascript:window.location.reload();"><i class="fa fa-refresh"></i></a>
                                    </div>
                                </div>
                                <!-- /.box-header -->
    
                                <div class="box-body" id="vistaboy">
                                                                        <!-- DIV CARGANDO -->
                                    <div id="divLoading" class="overlay">
                                          <i class="fa fa-refresh fa-spin"></i>
                                    </div>
                                    <!--FIN DIV CARGANDO -->  
                                    <div id="myGrid"  style="height: 100%" class="ag-theme-fresh"></div>
                                    <div id="ningunresultado"></div>

                                </div>
                                <!-- /.box-body -->
    
                            </div>
                            <!-- /.box -->
                        </div>
    
                        <div class="col-md-1">
    
                        </div>
                    </div>
    
                </section>
                <!-- /.content -->
    
            </div>
             <!-- /.content-wrapper -->
        </div>
       
        <div class="control-sidebar-bg"></div>
        
        <!-- jQuery 3.2.1 -->
        <script src="https://code.jquery.com/jquery-3.2.1.js"></script>

        <!-- jQuery v1.11 -->

        <script src="admin/bower_components/jquery/dist/jquery_v1.11.js" type="text/javascript"></script>

        <!-- jQuery UI 1.11.4 -->
        <script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
        <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
        <script>$.widget.bridge('uibutton', $.ui.button);</script>
        <!-- Bootstrap 3.3.7 -->
        <script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
        <!-- Select2 -->
        <script src="admin/bower_components/select2/dist/js/select2.full.min.js"></script>
        <!-- Sparkline -->
        <script src="admin/bower_components/jquery-sparkline/dist/jquery.sparkline.min.js"></script>

        <!-- jQuery Knob Chart -->
        <script src="admin/bower_components/jquery-knob/dist/jquery.knob.min.js"></script> 
        <!-- Bootstrap WYSIHTML5 -->
        <script src="admin/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js"></script>
        <!-- Slimscroll -->
        <script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
        <!-- FastClick -->
        <script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
        <!-- AdminLTE App -->
        <script src="admin/dist/js/adminlte.min.js"></script>


        <script src="admin/bower_components/bootstrap-table/dist/bootstrap-table.min.js" type="text/javascript"></script>
        <script src="admin/bower_components/ag-grid-master/dist/ag-grid.min.js" type="text/javascript"></script>
        <!-- InputMask -->
        <script src="admin/plugins/input-mask/jquery.inputmask.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.date.extensions.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.extensions.js"></script>

        <!-- date-range-picker -->
        <script src="admin/bower_components/moment/min/moment.min.js"></script>
        <script src="admin/bower_components/bootstrap-daterangepicker/daterangepicker.js"></script>
        <!-- bootstrap datepicker -->
        <script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
        <script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>
        <!-- bootstrap color picker -->
        <script src="admin/bower_components/bootstrap-colorpicker/dist/js/bootstrap-colorpicker.min.js"></script>
        <!-- bootstrap time picker -->
        <script src="admin/plugins/timepicker/bootstrap-timepicker.min.js"></script>

        <!-- Alertify -->
        <script src="admin/bower_components/alertifyjs/alertify.min.js" type="text/javascript"></script>
        <script src="admin/dist/js/pie-chart.js" type="text/javascript"></script>
        
        <!-- MAIN -->
        <script src="js/main.js?v=1" type="text/javascript"></script>

        <script>


var columnDefs = [
        
        {headerName: 'CODIGOMDP', field: 'CodigoMDP', width: 150, cellRenderer: function (params) {
                
        return "<div style='text-align: center; font-size: 1.5rem;'>" + params.value + "</div>";
                
        }},
        {headerName: 'URL', field: 'URL', width: 500, cellRenderer: function (params) {
                
        return "<div style='text-align: left; font-size: 1.5rem;'>" + params.value + "</div>";
                
        }},
        {headerName: 'DC', field: 'CC', width: 70, cellRenderer: function (params) {
                
        return "<div style='text-align: center; font-size: 1.5rem;'>" + params.value + "</div>";
                
        }},
        {headerName: 'FECHA REGISTRO', field: 'FechaHoraREG', width: 180, cellRenderer: function (params) {
                
        return "<div style='text-align: center; font-size: 1.5rem;'>" + params.value + "</div>";
                
        }},
        {headerName: 'GESTOR ORIGEN', field: 'GestorOrigen', width: 120, cellRenderer: function (params) {
                
        return "<div style='text-align: center; font-size: 1.5rem;'>" + params.value + "</div>";
                
        }},
        {headerName: 'CORREO BILLING', field: 'CorreoBilling', width: 200, cellRenderer: function (params) {
                
        return "<div style='text-align: left; font-size: 1.5rem;'>" + params.value + "</div>";
                
        }},
        {headerName: 'MODO DE PAGO', field: 'TipoPago', width: 150, cellRenderer: function (params) {
                
        return "<div style='text-align: center; font-size: 1.5rem;'>" + params.value + "</div>";
                
        }},
        {headerName: 'MARCA DE TARJETA', field: 'TarjetaMarca', width: 150, cellRenderer: function (params) {
            
            /*
            switch (params.value) {
                    case 'VISA' :
                        return "<div style='text-align: center; font-size: 18px;'><span class='label label-success'>" + params.value + "</span></div>";
                    break;
                    case 'MASTERCARD' :
                        return "<div style='text-align: center; font-size: 18px;'><span class='label label-success'>" + params.value + "</span></div>";
                    break;
                    case 'DINNERS' :
                        return "<div style='text-align: center; font-size: 18px;'><span class='label label-default'>" + params.value + "</span></div>";
                    break;
                    case 'AMEX' :
                        return "<div style='text-align: center; font-size: 18px;'><span class='label label-danger'>" + params.value + "</span></div>";
                    break;
               }
               
              */ 
            
                
               return "<div style='text-align: center; font-size: 1.5rem;'>" + params.value + "</div>";
              
                
        }},
        {headerName: 'N. CONTRATO', field: 'NContrato', width: 200, cellRenderer: function (params) {
                
        return "<div style='text-align: center; font-size: 1.5rem'>" + params.value + "</div>";
                
        }},
        {headerName: 'N. PROSPECTO', field: 'NProspecto', width: 200, cellRenderer: function (params) {
                
        return "<div style='text-align: center; font-size: 1.5rem'>" + params.value + "</div>";
                
        }},
        {headerName: 'N. MONTO TOTAL', field: 'MontoTotal', width: 200, cellRenderer: function (params) {
                
        return "<div style='text-align: center; font-size: 1.5rem'>" + params.value + "</div>";
                
        }}
        /*,
        {headerName: 'ESTADO URL', field: 'EstadoURL', width: 180,
            cellRenderer: function (params) {
                if (params.value == 'Activo') {
                    return "<div style='text-align: center; font-size: 18px;'><span class='label label-success'>" + params.value + "</span></div>";
                } else {
                    return "<div style='text-align: center; font-size: 18px;'><span class='label label-danger'>" + params.value + "</span></div>";
                }
        }}*/
    ];


    var gridOptions = {
        columnDefs: columnDefs,
        onPaginationChanged: onPaginationChanged,
        rowData: null,
        enableFilter: true,
        enableColResize: true,
        localeText: {
            // for filter panel
            page: 'página',
            more: 'Más',
            to: 'a',
            of: 'de',
            next: 'Siguiente',
            last: 'Último',
            first: 'Primero',
            previous: 'Anterior',
            loadingOoo: 'Cargando...',
            // for set filter
            selectAll: 'Seleccionar todo',
            searchOoo: 'Buscando...',
            blanks: 'Espacios en blanco',
            // for number filter and text filter
            filterOoo: 'Filtrar...',
            applyFilter: 'Aplicar Filtro',
            // for number filter
            equals: 'Igual',
            notEqual: 'No es igual',
            lessThanOrEqual: 'Menor o igual',
            greaterThanOrEqual: 'Mayor que o igual',
            inRange: 'En el rango',
            lessThan: 'Menos que',
            greaterThan: 'Mas grande que',
            // for text filter
            contains: 'Contiene',
            startsWith: 'Comienza con',
            endsWith: 'Termina con',
            notContains:'No contiene',
            // the header of the default group column
            group: 'Grupo',
            // tool panel
            columns: 'columnas',
            rowGroupColumns: 'Grupo columnas',
            rowGroupColumnsEmptyMessage: 'No hay resultado',
            valueColumns: 'Columna de valor',
            pivotMode: 'Modo pivote',
            groups: 'grupos',
            values: 'valor',
            pivots: 'pivote',
            valueColumnsEmptyMessage: 'No hay resultado',
            pivotColumnsEmptyMessage: 'No hay resultado',
            // other
            noRowsToShow: '<div class="callout callout-danger">\n\
<span class="pull-left">\n\
<img src="admin/dist/img/noresults-img.png" style="width: 70%">\n\
</span>\n\<h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>\n\
<strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>\n\
<p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>\n\
<br></div>'


            ,
            // enterprise menu
            pinColumn: 'Aclar columna',
            valueAggregation: 'Agregar valor',
            autosizeThiscolumn: 'Auto tamaño esta columna ',
            autosizeAllColumns: 'Auto tamaño todas columnas',
            groupBy: 'Agrupar',
            ungroupBy: 'Agrupar uno',
            resetColumns: 'Restaurar Columnas',
            expandAll: 'expandir todo',
            collapseAll: 'desplegar todo',
            toolPanel: 'Panel de Heramientas',
            export: 'Exportar',
            csvExport: 'Exportar CSV',
            excelExport: 'Exportar Excel',
            // enterprise menu pinning
            pinLeft: 'Anclar a derecha',
            pinRight: 'Anclar a izquierda',
            noPin: 'Desanclar',
            // enterprise menu aggregation and status panel
            sum: 'Sumar',
            min: 'Minimo',
            max: 'Maximo',
            first: 'Primero',
                    last: 'Ultimo',
                    none: 'Nada',
            count: 'Contador',
            average: 'Promedio',
            // standard menu
            copy: 'Copiar',
            copyWithHeaders: 'Copiar Cabecera',
            ctrlC: 'Ctrl+C',
            paste: 'Pegar',
            ctrlV: 'Ctrl+V'
        },
        enableSorting: true
    };
 function onPaginationChanged(params) {
    
    this.gridRowCount = params.api.paginationGetRowCount();
$("#count").html(this.gridRowCount);
   
  }


    function onFilterChanged(value) {
        gridOptions.api.setQuickFilter(value);
    }
    function listar() {
       
        $.ajax({
            url: 'ajax/findDataMdp.php',
            success: function (data) {

                if (data == 1) {
                    var gridDiv = document.querySelector('#myGrid');
                    new agGrid.Grid(gridDiv, gridOptions);

                    agGrid.simpleHttpRequest({url: 'ajax/selectListarMdpTransaccion.php'}).then(function (data) {

                        gridOptions.api.setRowData(data);
                    });
                    $('#vistaboy').height(function (index, height) {
                        return $(window).height() * 55 / 100;
                    });
                    $('#divLoading').hide();
                    $('#myGrid').show(200);
                } else {

                    $("#ningunresultado").html(data);

                    var gridDiv = document.querySelector('#myGrid');
                    new agGrid.Grid(gridDiv, gridOptions);

                    agGrid.simpleHttpRequest({url: 'ajax/selectListarMdpTransaccion.php'}).then(function (data) {

                        gridOptions.api.setRowData(data);
                    });

                    $('#myGrid').hide("fast");
                    $('#divLoading').hide();
                }
            }
        });
        
        
    }
    
    var refreshGridxMarcaUrl = function (Marca, Url) {

        cargarDatos ();
        
        marca=arrayToString(Marca);
        url = Url;

        $.ajax({
            url: "ajax/findDataxMarcaUrl.php",
            method: "POST",
            data: {marca:marca, url:url},
            success:function(data){
                if (data == 1) {
                   var gridDiv = document.querySelector('#myGrid');
                  
                   $.ajax({
                       url: "ajax/selectListarxMarcaUrl.php",
                       method: "POST",
                       data: {marca:marca, url:url},
                       dataType: "json",
                       success:function(data){
                           gridOptions.api.setRowData(data);
                       }
                   });
                   
                   
                   /*
                   agGrid.simpleHttpRequest({url: 'ajax/selectListarXURL.php?URL='+ URL}).then(function (data) {
                        gridOptions.api.setRowData(data);
                    });*/
                    $("#ningunresultado").hide("fast");
                    $('#myGrid').show(200);
                    $('#divLoading').hide();
               } else {
                   $('#ningunresultado').show(200);
                    $("#ningunresultado").html(data);
                    $('#myGrid').hide("fast");
                    $('#divLoading').hide();
               }
            }
        });
    }
    
      var refreshGridxMarcaUrlCC = function (Marca, Url,CCmdp) {

        cargarDatos ();
        if(Marca===null){
        marca="";    
        }else{
        marca=arrayToString(Marca);
        }
        if(CCmdp===null){
        ccmdp="";    
        }else{
        ccmdp=arrayToString(CCmdp);
        }
       if(Url===null || Url==="0"){
        url="";    
        }else{
        url = Url;
        }

                           var gridDiv = document.querySelector('#myGrid');
                  
                   $.ajax({
                       url: "ajax/selectListarMdpTransaccion_v2.php",
                       method: "POST",
                       data: {marca:marca, url:url,ccmdp:ccmdp},
                       dataType: "json",
                       success:function(data){
                           gridOptions.api.setRowData(data);
                       }
                   });
                   
                   
                   /*
                   agGrid.simpleHttpRequest({url: 'ajax/selectListarXURL.php?URL='+ URL}).then(function (data) {
                        gridOptions.api.setRowData(data);
                    });*/
                    $("#ningunresultado").hide("fast");
                    $('#myGrid').show(200);
                    $('#divLoading').hide();
    }
      
    var refreshGridxUrl = function (value){
        var URL= value;
        cargarDatos ();
        
        $.ajax({
           url: 'ajax/findDataxURL.php?URL=' + URL,
           success: function (data) {
               if (data == 1) {
                   var gridDiv = document.querySelector('#myGrid');
                   
                   agGrid.simpleHttpRequest({url: 'ajax/selectListarXURL.php?URL='+ URL}).then(function (data) {
                    gridOptions.api.setRowData(data);
                    });
                    $("#ningunresultado").hide("fast");
                    $('#myGrid').show(200);
                    $('#divLoading').hide();
               } else {
                   $('#ningunresultado').show(200);
                    $("#ningunresultado").html(data);
                    $('#myGrid').hide("fast");
                    $('#divLoading').hide();
               }
           }
        });
        
    }
    
    var refreshGridxMarca = function(value){
        cargarDatos();
        var marca = value;
        
        $.ajax({
           url: 'ajax/findDataxMarca.php?marca=' + marca,
           success: function (data) {
               if (data == 1) {
                  var gridDiv = document.querySelector('#myGrid');
                    
                    agGrid.simpleHttpRequest({url: 'ajax/selectListarXMarca.php?marca='+ marca}).then(function (data) {
                        gridOptions.api.setRowData(data);
                    });
                    /*$('#vistaboy9').height(function (index, height) {
                        return $(window).height() * 35 / 100;
                    });*/
                    $("#ningunresultado").hide("fast");
                    $('#myGrid').show(200);
                    $('#divLoading').hide();
               } else {
                   $('#ningunresultado').show(200);
                    $("#ningunresultado").html(data);
                    $('#myGrid').hide("fast");
                    $('#divLoading').hide();
               }
           }
        });
        
    }
  
    
    var refreshMarcaVisa = function () {
        marca = 'VISA';
        $.ajax({
            url: 'ajax/findDataxMarca.php?marca=' + marca,
            success: function (data) {

                if (data == 1) {

                    var gridDiv = document.querySelector('#myGrid');
                    
                    agGrid.simpleHttpRequest({url: 'ajax/selectListarXMarca.php?marca='+ marca}).then(function (data) {
                        gridOptions.api.setRowData(data);
                    });
                    /*$('#vistaboy9').height(function (index, height) {
                        return $(window).height() * 35 / 100;
                    });*/
                    $("#ningunresultado").hide("fast");
                    $('#myGrid').show(200);
                    
                } else {
                    $('#ningunresultado').show(200);
                    $("#ningunresultado").html(data);
                    $('#myGrid').hide("fast");
                }
            }
        });
        
    }
    
    var refreshMarcaMC = function () {
        marca = 'MASTERCARD';
        $.ajax({
            url: 'ajax/findDataxMarca.php?marca=' + marca,
            success: function (data) {

                if (data == 1) {

                    var gridDiv = document.querySelector('#myGrid');
                    
                    agGrid.simpleHttpRequest({url: 'ajax/selectListarXMarca.php?marca='+ marca}).then(function (data) {
                        gridOptions.api.setRowData(data);
                    });
                    /*$('#vistaboy9').height(function (index, height) {
                        return $(window).height() * 35 / 100;
                    });*/
                    $("#ningunresultado").hide("fast");
                    $('#myGrid').show(200);
                } else {
                    $('#ningunresultado').show(200);
                    $("#ningunresultado").html(data);
                    $('#myGrid').hide("fast");
                }
            }
        });
        
    }
    
    var refreshMarcaDinners = function () {
        marca = 'DINNERS';
        $.ajax({
            url: 'ajax/findDataxMarca.php?marca=' + marca,
            success: function (data) {

                if (data == 1) {

                    var gridDiv = document.querySelector('#myGrid');
                    
                    agGrid.simpleHttpRequest({url: 'ajax/selectListarXMarca.php?marca='+ marca}).then(function (data) {
                        gridOptions.api.setRowData(data);
                    });
                    /*$('#vistaboy9').height(function (index, height) {
                        return $(window).height() * 35 / 100;
                    });*/
                    $("#ningunresultado").hide("fast");
                    $('#myGrid').show(200);
                } else {
                    $('#ningunresultado').show(200);
                    $("#ningunresultado").html(data);
                    $('#myGrid').hide("fast");
                }
            }
        });
    }
    
    var refreshMarcaAmex = function () {
        marca = 'AMEX';
        $.ajax({
            url: 'ajax/findDataxMarca.php?marca=' + marca,
            success: function (data) {

                if (data == 1) {

                    var gridDiv = document.querySelector('#myGrid');
                    
                    agGrid.simpleHttpRequest({url: 'ajax/selectListarXMarca.php?marca='+ marca}).then(function (data) {
                        gridOptions.api.setRowData(data);
                    });
                    /*$('#vistaboy9').height(function (index, height) {
                        return $(window).height() * 35 / 100;
                    });*/
                    $("#ningunresultado").hide("fast");
                    $('#myGrid').show(200);
                } else {
                    $('#ningunresultado').show(200);
                    $("#ningunresultado").html(data);
                    $('#myGrid').hide("fast");
                }
            }
        });
    }
    
    var refreshGridxMarca2 = function(value){
        cargarDatos();
        
        marca=arrayToString(value);
        
        $.ajax({
           url: 'ajax/findDataxMarca2.php?marca=' + marca,
           success: function (data) {
               if (data == 1) {
                  var gridDiv = document.querySelector('#myGrid');
                    
                    agGrid.simpleHttpRequest({url: 'ajax/selectListarXMarca2.php?marca='+ marca}).then(function (data) {
                        gridOptions.api.setRowData(data);
                    });
                    /*$('#vistaboy9').height(function (index, height) {
                        return $(window).height() * 35 / 100;
                    });*/
                    $("#ningunresultado").hide("fast");
                    $('#myGrid').show(200);
                    $('#divLoading').hide();
               } else {
                   $('#ningunresultado').show(200);
                    $("#ningunresultado").html(data);
                    $('#myGrid').hide("fast");
                    $('#divLoading').hide();
               }
           }
        });
}
    
     var refresh = function () {
         
         cargarDatos();
 
        $.ajax({
            url: 'ajax/findDataMdp.php',
            success: function (data) {

                if (data == 1) {

                    var gridDiv = document.querySelector('#myGrid');
                    agGrid.simpleHttpRequest({url: 'ajax/selectListarMdpTransaccion.php'}).then(function (data) {
                        gridOptions.api.setRowData(data);
                    });
                    $('#vistaboy').height(function (index, height) {

                        return $(window).height() * 55 / 100;
                    });
                    $("#ningunresultado").hide("fast");
                    $('#myGrid').show(200);
                    $('#divLoading').hide();
                } else {
                    $('#divLoading').hide();
                    $("#ningunresultado").html(data);
                    $('#myGrid').hide("fast");
                    
                }
            }
        });
        
        
    }

// setup the grid after the page has finished loading
    document.addEventListener('DOMContentLoaded', function () {
        
        listar();

    });
    
    function cargarDatos () {
        var divLoading = $('#divLoading');
        $('#myGrid').hide("fast");
        $("#ningunresultado").hide("fast");
        divLoading.show();
    }

   


    </script>

    <script>
        $(function () {

            $("#lbldc").change(function () {
                $("#lbldc option:selected").each(function () {
                    var lbldc = $(this).val();
                    $.post("./ajax/selectJefeVenta.php", {lbldc: lbldc}, function (data) {
                        $("#lbljefeventa").html(data);
                    });
                });
            });

            $('#lblmatricula').on('keyup', function () {
                var dato = $('#lblmatricula').val();
                var url = 'ajax/findMatricula.php';
                $.ajax({
                    type: 'POST',
                    url: url,
                    data: 'dato=' + dato,
                    success: function (datos) {
                        $('.mensajematricula').html(datos);
                    }
                });
                return false;
            });

            $("#lblmatricula").autocomplete({
                source: "./ajax/selectMatricula.php",
                minLength: 2,
                select: function (event, ui) {
                    event.preventDefault();
                    $('#lblidusuario').val(ui.item.idusuario);
                    $('#lblmatricula').val(ui.item.matricula);
                    $('#lblnombcomercial').val(ui.item.comercial);

                }
            });

            $("#lblmatricula").on("keydown", function (event) {
                if (event.keyCode == $.ui.keyCode.LEFT || event.keyCode == $.ui.keyCode.RIGHT || event.keyCode == $.ui.keyCode.UP || event.keyCode == $.ui.keyCode.DOWN || event.keyCode == $.ui.keyCode.DELETE || event.keyCode == $.ui.keyCode.BACKSPACE)
                {
                    $('#lblidusuario').val("");
                    $('#lblmatricula').val("");
                    $('#lblnombcomercial').val("");

                }
                if (event.keyCode == $.ui.keyCode.DELETE) {
                    $('#lblmatricula').val("");
                    $('#lblidusuario').val("");
                    $('#lblnombcomercial').val("");  
                }
            });

        });


    </script>

    <script>
        $(document).ready(function () {

            var alterClass = function () {
                var ww = document.body.clientWidth;
                if (ww < 767) {
                    $('body').removeClass('sidebar-collapse');

                } else if (ww >= 768) {
                    $('body').addClass('sidebar-collapse');

                }


            };
            
            $('#totalRefresh').click(function () {
                  //var TarjetaM=$('#lblTarjetaAmex').va();
                    refresh();
             });
            
            $('#visa-refresh').click(function () {
                  //var TarjetaM=$('#lblTarjetaAmex').va();
                    refreshMarcaVisa();
             });
             $('#MC-refresh').click(function () {
                  //var TarjetaM=$('#lblTarjetaAmex').va();
                    refreshMarcaMC();
             });
             $('#dinners-refresh').click(function () {
                  //var TarjetaM=$('#lblTarjetaAmex').va();
                    refreshMarcaDinners();
             });
            $('#amex-refresh').click(function () {
                  //var TarjetaM=$('#lblTarjetaAmex').va();
                    refreshMarcaAmex();
             });
             
            $(window).resize(function () {
                alterClass();
                //refresh();
            });
            //Fire it when the page first loads:
            alterClass();

          
            //Initialize Select2 Elements
                                
            $('.select2').select2();
            
            $(".filtro_url").select2({
                placeholder: 'Seleccione URL',
				allowClear: true
			});
     
            $('#datemask').inputmask('dd/mm/yyyy', {'placeholder': 'dd/mm/yyyy'});

            $('#bodyprincipal').slimScroll({
                height: '250px'
            });
            $('#bodyventaoline').slimScroll({
                height: '230px'
            });

            $('#bodyeditarventa').slimScroll({
                height: '500px'
            });

            $('#slider').css('margin-left', '-' + 100 + '%');
            $('.step3').click(function () {
                var div = document.getElementById("titulomediodepago");

                div.textContent = "VISA";

                $('#lblfvencimiento').val("");
                $('#lblmediopago').val("VISA");
                $('#ncontrato').hide().val("");
                $('#lblestadourl').val("");
                $('#lblurl').val("");
               
                $('#slider').animate({
                    marginLeft: '-' + 100 + '%'}, 200, function () {
                    $('#slider').css('margin-left', '-' + 100 + '%');
                });
            });
            $('.step2').click(function () {
                 var div = document.getElementById("titulomediodepago");

                div.textContent = "MASTERCARD";

                $('#lblfvencimiento').val("");
                $('#lblmediopago').val("MASTERCARD");
                $('#ncontrato').hide().val("");
                $('#lblestadourl').val("");
                $('#lblurl').val("");
               
                $('#slider').animate({
                    marginLeft: '-' + 100 + '%'}, 200, function () {
                    $('#slider').css('margin-left', '-' + 100 + '%');
                });
            });

            $('.regresarvtaonline').click(function () {
                $('#slider').animate({
                    marginLeft: 0}, 200);
            });
            $('#d').click(function () {
                $('#slider').css('margin-left', 0);
            });
            //Money Euro
            $('[data-mask]').inputmask();
            
            //Date picker
            $('#lblfvencimiento').datepicker({
                autoclose: true,
                language: 'es',
                firstDay: 1
            }).datepicker("setDate", new Date());
            //Date picker

        });




        function validaForm() {
            // Campos de texto
            if ($("#frmMDP #lblurl").val() == "") {
                alertify.warning("Por favor ingresar la URL correspondiente");
                $("#frmMDP #lblurl").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                return false;
            }
            if ($("#frmMDP #lblfvencimiento").val() == "") {
                alertify.warning("Por favor ingresar la Fecha de Vencimiento valida");
                $("#frmMDP #lblfvencimiento").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                return false;
            }
            if ($("#frmMDP #lblestadourl").val() == "" || $("#frmMDP #lblestadourl").val() == "Seleccione") {
                alertify.warning("Por favor ingresar EstadoURL correcto");
                $("#frmMDP #lblestadourl").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                return false;
            }

            return true;
        }



        var regre = function () {
            $('#slider').animate({
                    marginLeft: 0}, 200);
        };
        function filterFloat(evt, input) {
            // Backspace = 8, Enter = 13, ‘0′ = 48, ‘9′ = 57, ‘.’ = 46, ‘-’ = 43
            var key = window.Event ? evt.which : evt.keyCode;
            var chark = String.fromCharCode(key);
            var tempValue = input.value + chark;
            if (key >= 48 && key <= 57) {
                if (filter(tempValue) === false) {
                    return false;
                } else {
                    return true;
                }
            } else {
                if (key == 8 || key == 13 || key == 0) {
                    return true;
                } else if (key == 46) {
                    if (filter(tempValue) === false) {
                        return false;
                    } else {
                        return true;
                    }
                } else {
                    return false;
                }
            }
        }

        function filter(__val__) {
            var preg = /^([0-9]+\.?[0-9]{0,2})$/;
            if (preg.test(__val__) === true) {
                return true;
            } else {
                return false;
            }
        }
        
        function Export()
        {
            var conf = confirm("¿Desea Exportar a CSV?");
            if(conf == true)
            {
                window.open("./ajax/exportarTransaccionesMDP.php", '_blank');
            }
        }

</script>

    </script>


    </body>
</html>

<?php 

$resultadocantidad->close();
$resultadocantidadvisa->close();
$resultadocantidadMC->close();
$resultadocantidadDINNERS->close();
$resultadocantidadAMEX->close();
$resultadoURL->close();
$resultadoCantidadUrlActiva->close();
$resultadoUrlActiva->close();
$con->close();