<!DOCTYPE html>
<html lang="en" dir="ltr">
  <head>
    <meta charset="utf-8">
    <title></title>

    <!-- DataTables -->
    <link rel="stylesheet" href="admin/bower_components/datatables.net-bs/css/dataTables.bootstrap.min.css">
    <!-- Alertifyjs -->
    <link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css"/>
    <link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css"/>

  </head>
  <body>
      <textarea id="textarea" name="textarea" rows="8" cols="80"></textarea>
      <input type="button" name="btn_validar" value="Validar" id="btn_validar">

      <div class="">
          <table  id="example" class="table table-hover table-bordered compact" style="width:100%">
              <thead style="background-color: #e0e0e0; color: black;">
                <tr>
                  <th>NContrato</th>
                  <th>Pago</th>
                  <th>Verificación</th>
                  <th>Observación</th>
                </tr>
              </thead>
          </table>
      </div>
  </body>

  <script src="admin/bower_components/jquery/dist/jquery_v1.11.js" type="text/javascript"></script>

  <!-- jQuery UI 1.11.4 -->
  <script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
  <!-- Bootstrap 3.3.7 -->
  <script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
  <!-- AdminLTE App -->
  <script src="admin/dist/js/adminlte.min.js"></script>
  <!-- Alertify -->
  <script src="admin/bower_components/alertifyjs/alertify.min.js" type="text/javascript"></script>
  <!-- SweetAlert -->
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@8"></script>
  <!-- DataTables -->
  <script src="admin/bower_components/datatables.net/js/jquery.dataTables.min.js"></script>
  <script src="admin/bower_components/datatables.net-bs/js/dataTables.bootstrap.min.js"></script>

  <script type="text/javascript">

  </script>

  <script type="text/javascript">
    var t = $('#example').DataTable({
                'searching'   : false,
                'ordering' : false,
                'paging' : false,
                'info' : false,
                'autoWidth' : false,
                'language' : {
                    'emptyTable': ''
                }
    });

    $('#btn_validar').on('click', function(){
      var lines = $('textarea').val().split('\n');
      console.log(lines);
      for(var i = 0;i < lines.length;i++){
        var row = lines[i];
        var primero = row.split(",")[0];
        var segundo = row.split(",")[1];
        var verificacion='Ok';
        var observaciones='Funciona';

        //console.log(parseFloat(primero));

        if(primero.length == 0 || primero.length > 7 || primero.length < 7){
          verificacion = 'NOk';
          observaciones = "El número de contrato debe tener 7 caracteres";
        }
        else if(isNaN(primero)){
          verificacion = 'NOk';
          observaciones = "El número de contrato debe ser numérico";
        }
        
        if (verificacion == 'Ok'){
            $.ajax({
                type: 'Post',
                url: 'ajax/cobranzaMasivo.php',
                data: {tipo: 'buscar', ncliente: primero},
                dataType: 'Json',
                success: function(data){
                    console.log(data);
                }
            })    
        }
        
        

        t.row.add([
          primero,
          segundo,
          verificacion,
          observaciones
        ]).draw(false);
      }
    })
  </script>



</html>
