document.addEventListener('DOMContentLoaded', function() {

    var url ='./';


    var queryString = window.location.search;
    var urlParams = new URLSearchParams(queryString);
    var zona = urlParams.get('zona');
    var dataprueba=[];
    
    if(zona=== undefined || zona===null || zona==='' || zona==7){
       zona=15;
    }

    $('body').on('click', '.datetimepicker', function() {
        $(this).not('.hasDateTimePicker').datetimepicker({
            controlType: 'select',
            changeMonth: true,
            changeYear: true,
            dateFormat: "dd-mm-yy",
            timeFormat: 'HH:mm:ss',
            yearRange: "1900:+10",
            showOn:'focus',
            firstDay: 1
        }).focus();
    });


    // $(".colorpicker").colorpicker();
    
    var calendarEl = document.getElementById('calendar');
    
    const fecha = new Date();

     var calendar = new FullCalendar.Calendar(calendarEl, {
         defaultView: 'timeGridWeek',
         plugins: ['interaction', 'dayGrid', 'timeGrid', 'list'],
         header: {
             left: 'prev,next today',
             center: 'title',
              //right: 'dayGridMonth,timeGridWeek,timeGridDay,listMonth'
             right: 'timeGridDay,timeGridWeek',
         },
         minTime: '8:00:00',
  		 maxTime: '20:00:00',
  		 contentHeight:'auto',
         slotDuration: '01:00:00',  //intervalos de tiempo por hora
         locale: 'es',
         navLinks: true,  //can click day/week names to navigate views
         businessHours: true,  //display business hours
         editable: true,
         //uncomment to have a default date
         defaultDate: fecha,
         allDaySlot: false,
         slotLabelFormat:
         {
           hour: 'numeric',
           minute: '2-digit',
           omitZeroMinute: false,
           hour12: false
         },         

         //events: url+'Controller/load.php',

        events: function(fetchInfo, successCallback, failureCallback) {
            // console.log(fetchInfo);

            var datos={
                    array:'array1',
                    start:fetchInfo.startStr.valueOf(),
                    zona:zona
            };
            console.log(datos);
            
            $.ajax({
                url: "./Controller/ControllerCalendarioDavid.php",
                type: "POST",
                dataType: "json",
                data:{function: JSON.stringify(datos)},
                success: function(res) {
                  var events = [];
                          res.forEach(function (evt) {
                            events.push({
                              id: evt.id,
                              backgroundColor: evt.backgroundColor,
                              textColor : evt.textColor,                               
                              title: evt.title,
                              start: evt.start,
                              end: evt.end,
                              borderColor:evt.borderColor
                            });
                          });
                    successCallback(events);
                }
            });
        },

         
         eventDrop: function(arg) {
             /*
             var start = arg.event.start.toDateString()+' '+arg.event.start.getHours()+':'+arg.event.start.getMinutes()+':'+arg.event.start.getSeconds();
             if (arg.event.end == null) {
                 end = start;
             } else {
                 var end = arg.event.end.toDateString()+' '+arg.event.end.getHours()+':'+arg.event.end.getMinutes()+':'+arg.event.end.getSeconds();
             }
             */
        /*
             $.ajax({
               url:url+"Controller/update.php",
               type:"POST",
               data:{id:arg.event.id, start:start, end:end},
             });
        */   
             
         },
         eventResize: function(arg) {
             var start = arg.event.start.toDateString()+' '+arg.event.start.getHours()+':'+arg.event.start.getMinutes()+':'+arg.event.start.getSeconds();
             var end = arg.event.end.toDateString()+' '+arg.event.end.getHours()+':'+arg.event.end.getMinutes()+':'+arg.event.end.getSeconds();

             $.ajax({
               url:url+"Controller/update.php",
               type:"POST",
               data:{id:arg.event.id, start:start, end:end},
             });
         },
         eventClick: function(arg) {
             
            var id = arg.event.id;
            var startDate=dateConverter(arg.event.start);
            var endDate=dateConverter(arg.event.end);
            console.log(id);
           
            $('#startDate').val(dateConverter( arg.event.start).substr(0,10));
            // console.log(dateConverter( arg.event.start));rangoHora
            var horas = arg.event.start.getHours()== 8?'0'+arg.event.start.getHours()+':00':arg.event.start.getHours()+':00';
            var horafin = arg.event.end.getHours()+':00';
            var rangoHora = 'Información Agenda       '+horas + ' - ' + horafin; console.log(rangoHora);
            $("#rangoHora").text(rangoHora);
            $("#inicial").val(arg.event.start.getHours());
            $("#final").val(arg.event.end.getHours());
            
            console.log(horas);
            $("#horaInstalacion").val(horas);
            $('#horaInstalacion').timepicker('destroy');
            $('#horaInstalacion').timepicker({
                timeFormat: 'HH:mm',
                // timeFormat: 'HH',
                interval: 30,
                dynamic: true,
                dropdown: true,
                scrollbar: false,
                controlType: 'select',
            	hourMin: arg.event.start.getHours(),
            	hourMax: arg.event.end.getHours()-1,
            	stepMinute: 5,
                //zindex: 99,
                change: function(time) {
                            // the input field
                            var element = $(this), text;
                            // get access to this Timepicker instance
                            var timepicker = element.timepicker();
                            text = 'Selected time is: ' + timepicker.format(time);
                            console.log(element);
                        }                
              });
            
            
            
             $('#editEventId').val(id);
             $('#deleteEvent').attr('data-id', id);
             
            var datos={
                    array:'array3',
                    zona:zona
            };             
            if(id==1){
                
            $('#editeventmodal').modal();
            ListaTecnicos(startDate,endDate,startDate);
            console.log(ListaTecnicos(startDate,endDate,startDate));
            
            ListarVisitasTecnicas();
                /*
             $.ajax({
               //url:url+"Controller/getevent.php",
               url: "./Controller/ControllerCalendario.php",               
               type:"POST",
               dataType: 'json',
               data:{function: JSON.stringify(datos)},
               success: function(data) {
                   console.log(data);
                     $('#editEventTitle').val(data.title);
                     $('#editStartDate').val(data.start);
                     $('#editEndDate').val(data.end);
                     $('#editColor').val(data.color);
                     $('#editTextColor').val(data.textColor);
                     
                     $('#editeventmodal').modal();
                     
                 }
             });
                */

            //calendar.refetchEvents();
            
            }
/*
             $('body').on('click', '#deleteEvent', function() {
                 if(confirm("Are you sure you want to remove it?")) {
                     $.ajax({
                         url:url+"Controller/delete.php",
                         type:"POST",
                         data:{id:arg.event.id},
                     }); 

                     //close model
                     $('#editeventmodal').modal('hide');

                     //refresh calendar
                     calendar.refetchEvents();         
                 }
             });
*/            
             
         }
     });

     calendar.render();

    // $('#createEvent').submit(function(event) {

    //     // stop the form refreshing the page
    //     event.preventDefault();

    //     $('.form-group').removeClass('has-error'); // remove the error class
    //     $('.help-block').remove(); // remove the error text

    //     // process the form
    //     $.ajax({
    //         type        : "POST",
    //         url         : url+'Controller/insert.php',
    //         data        : $(this).serialize(),
    //         dataType    : 'json',
    //         encode      : true
    //     }).done(function(data) {

    //         // insert worked
    //         if (data.success) {
                
    //             //remove any form data
    //             $('#createEvent').trigger("reset");

    //             //close model
    //             $('#addeventmodal').modal('hide');

    //             //refresh calendar
    //             calendar.refetchEvents();

    //         } else {

    //             //if error exists update html
    //             if (data.errors.date) {
    //                 $('#date-group').addClass('has-error');
    //                 $('#date-group').append('<div class="help-block">' + data.errors.date + '</div>');
    //             }

    //             if (data.errors.title) {
    //                 $('#title-group').addClass('has-error');
    //                 $('#title-group').append('<div class="help-block">' + data.errors.title + '</div>');
    //             }

    //         }

    //     });
    // });

    // $('#editEvent').submit(function(event) {

    //     // stop the form refreshing the page
    //     event.preventDefault();

    //     $('.form-group').removeClass('has-error'); // remove the error class
    //     $('.help-block').remove(); // remove the error text

    //     //form data
    //     var id = $('#editEventId').val();
    //     var title = $('#editEventTitle').val();
    //     var start = $('#editStartDate').val();
    //     var end = $('#editEndDate').val();
    //     var color = $('#editColor').val();
    //     var textColor = $('#editTextColor').val();

    //     // process the form
    //     $.ajax({
    //         type        : "POST",
    //         url         : url+'Controller/update.php',
    //         data        : {
    //             id:id, 
    //             title:title, 
    //             start:start,
    //             end:end,
    //             color:color,
    //             text_color:textColor
    //         },
    //         dataType    : 'json',
    //         encode      : true
    //     }).done(function(data) {

    //         // insert worked
    //         if (data.success) {
                
    //             //remove any form data
    //             $('#editEvent').trigger("reset");

    //             //close model
    //             $('#editeventmodal').modal('hide');

    //             //refresh calendar
    //             calendar.refetchEvents();

    //         } else {

    //             //if error exists update html
    //             if (data.errors.date) {
    //                 $('#date-group').addClass('has-error');
    //                 $('#date-group').append('<div class="help-block">' + data.errors.date + '</div>');
    //             }

    //             if (data.errors.title) {
    //                 $('#title-group').addClass('has-error');
    //                 $('#title-group').append('<div class="help-block">' + data.errors.title + '</div>');
    //             }

    //         }

    //     });
    // });
    
    
    /*LISTA VISITA TECNICA*/
    
    
    function ListarVisitasTecnicas(){
    var provincia = $('#provinciaCalendario').val();
    var mesano590 = $('#mesano590').val();
    var horafecha = $('#startDate').val();
    var zona = $("#zona").val();
    console.log(provincia);
    console.log(mesano590);
    console.log(horafecha);
        var array = { 'array': 'array4', 'provincia': provincia, 'mesano590': mesano590, 'horafecha': horafecha, 'zona': zona };
        
        $.ajax({
            method: "POST",
            dataType: 'json',
            url: "./Controller/ControllerCalendarioDavid.php",
            data: { function: JSON.stringify(array) },
            beforeSend: function () {
    
            },
            success: function (data) {
                console.log(data.ListaVisitaTecnica.length);
                if(data.ListaVisitaTecnica.length >0){
                    
                    createTable(data.ListaVisitaTecnica);
                    
                    // $("#visitasAsignadas>thead").empty();
                    // $("#visitasAsignadas>thead").append("<tr><th class='text-center align-middle' style='font-size: .8rem;'><div>Rango Horario </div></th></tr>");
                    // $.each(data.totalTecnicos, function (key, value) {      
                    //     // console.log(value)
                    //     // console.log(key);
                         
                                    
                    //     $("#visitasAsignadas>thead").append("<tr><th class='text-center align-middle' style='font-size: .8rem;'><div>Tecnico "+ (key+1) +
                                    
                    //                 "</div></th></tr>");
                    // });
                    
                    // $.each(data.ListaVisitaTecnica, function (key, value) {                         
                    //     $("#visitasAsignadas > tbody").append("<tr><td>" + value.HoraInst +" - " + (value.HoraInst + 3)+
                    //                 "</td><td>" + value.Provincia +" - " +value.HoraInst +
                                    
                    //                 "</td></tr>");
                    // });
                }else{
                    $('#tabla-body').text('NO HAY VISITAS TECNICAS REGISTRADAS');
                }
                
                console.log(data);
                // if (data) {
                //     alert("Dato guardado con exito");
                // }else{
                //     alert("No se guardo el dato, comuniquese con el administrador");
                // }
            },
            error: function () {
    
            }
    
        });
    }
    
/***/
function createTable(data) {
    
  // Inicializar la tabla
  var table = $('<table></table>');
  
  // Obtener la lista de tcnicos
  var techList = [];
  var tech2List = [];
  for (var i = 0; i < data.length; i++) {
    var tech = data[i].Tecnico;
    var tech2 = data[i].MatriculaTec;
    if (techList.indexOf(tech) === -1) {
      techList.push(tech);
    }
    
    if (tech2List.indexOf(tech2) === -1) {
      tech2List.push(tech2);
    }
  }
  
  // Crear la fila de encabezado
  var headerRow = $('<tr></tr>');
  headerRow.append($('<th>Rango_Horario</th>'));
  for (var j = 0; j < tech2List.length; j++) {
    headerRow.append($('<th>' + tech2List[j] + '</th>'));
    // headerRow.append($('<th class="text-center">' + 'Tecnico' +(j+1)+ '</th>'));
  }
  table.append(headerRow);
  
  // Crear las filas de datos
  var startHour = 8;
  var endHour = 20;
  var step = 3;
  for (var h = startHour; h < endHour; h += step) {
    var timeRange = h.toString().padStart(2, '0') + ':00 - ' + (h + step).toString().padStart(2, '0') + ':00';
    var dataRow = $('<tr></tr>');
    dataRow.append($('<td>' + timeRange + '</td>'));
    for (var k = 0; k < techList.length; k++) {
      var tech = techList[k];
      var techCell = $('<td></td>');
      for (var m = 0; m < data.length; m++) {
        var row = data[m];
        if (row.Tecnico === tech && parseInt(row.HoraInst.slice(0, 2)) >= h && parseInt(row.HoraInst.slice(0, 2)) < h + step) {
          techCell.text(row.Distrito + ' - ' +row.HoraInst);
          break;
        }
      }
      dataRow.append(techCell);
    }
    table.append(dataRow);
  }
  
  // Agregar la tabla al documento
  $('#tabla-body').empty();
  $('#tabla-body').append(table);
}
/***/
/*FIN - LISTA VISITA TECNICA*/

    // LISTA DE TECNICOS //
    //ListaTecnicos();

    function ListaTecnicos(startDate,endDate,horafija) {
    // var id_usuario = $("#valor_id").val();
    var array = { 'array': 'array2',startDate:startDate,endDate:endDate,zona:zona,horafija:horafija};
    // alert(usuario);
    
        $.ajax({
            method: "POST",
            url: "./Controller/ControllerCalendarioDavid.php",
            dataType: "json",
            data: { function: JSON.stringify(array) },
            beforeSend: function () {

            },
            success: function (data) { 
                
                console.log(data);

                $("#listaTecnicos").empty(); //limpia para iniciar una nueva busqueda
                $.each(data, function (key, value) {
                    // console.log(value);
                // console.log(data.ot[0].otc);
                    // if($.trim(data.ot[0].otc).length >0){ 
                    $("#listaTecnicos").prepend(
                                            // "<option selected name='ordentrabajo' data-ordenT='" + value.otc + "' value='"+value.otc+"' >"+value.otc+"</option>"
                                            "<option selected value='"+value.Matricula+"' >"+value.Matricula+"</option>"
                                            );
                    // }
                });
                $("#listaTecnicos").prepend("<option selected value = ''>Seleccione Tecnico</option>");
                
                if(data.length===0){
                    var respuestaData = 0;
                    Swal.fire('No se encuentra tecnicos a la '+startDate, '', 'warning');
                    $('#horaInstalacion').timepicker('hide');
                    // preventDefault();
                    return;
                }
                // //  console.log(data);
                // return data;
                
            },
            error: function () {

            }
        });
        
    }
    
    function dateConverter(str){
       var date = new Date(str),
       mnth = ("0" + (date.getMonth()+1)).slice(-2),
       day  = ("0" + date.getDate()).slice(-2);
       hours  = ("0" + date.getHours()).slice(-2);
       minutes = ("0" + date.getMinutes()).slice(-2);
       seconds  = ("0" + date.getSeconds()).slice(-2);
       year = date.getFullYear();
       return `${year}-${mnth}-${day} ${hours}:${minutes}:${seconds}`
    }



    $("#horaInstalacion").on("change",function(event){
  //alert("This input field has lost its focus.");
        // if (event.which === 13) {
            var horafija='';
            var inicio = $("#inicial").val(); console.log(inicio);
            var fin = $("#final").val(); console.log(fin);
            var hora = parseInt($("#horaInstalacion").val().slice(0,2)); console.log(hora);
            
            var fechainicio= $("#startDate").val();
            var horainst = $("#horaInstalacion").val()+':00'; console.log(horainst);
            var fechahoraconcatenada=fechainicio+' '+horainst;

  
            
            
             
            if(hora>=inicio && hora<fin){
                if(inicio==8){
                    horafija=fechainicio+'08:00:00';
                }else if(inicio==11){
                    horafija=fechainicio+'11:00:00';
                }else if(inicio==14){
                    horafija=fechainicio+'14:00:00';
                }else{    
                    horafija=fechainicio+'17:00:00';
                }
                
               ListaTecnicos(fechahoraconcatenada,'',horafija);
           
                
                // var dataArray = ValidarDisponibilidadRango(zona,horainst); 
                // if (dataArray.length === 0){
                //         Swal.fire('Ingrese la hora dentro del rango '+inicio+':00-'+(fin-1)+':59', '', 'warning');    
                // }
                // return;
            }else{
                 //$(this).timepicker('hideWidget');
                 $('#horaInstalacion').timepicker('hide');
                 $("#horaInstalacion").val(inicio+':00');
                 //$("#horaInstalacion").timepicker('option', 'minTime', inicio+':00');
                //  $('#horaInstalacion').timepicker('setTime', inicio+':00');
                $('#horaInstalacion').timepicker({ defaultValue: inicio+':00' });
                 Swal.fire('Ingrese la hora dentro del rango '+inicio+':00-'+(fin-1)+':59', '', 'warning');
            }
        // }    
    });
    


    

});




                            
function ValidarDisponibilidadRango(zona,fechaInicio){
        console.log(zona);
        var array = { 'array': 'array3', 'zona':zona, 'fechaInicio':fechaInicio};

        $.ajax({
            method: "POST",
            url: "Controller/ControllerCalendarioDavid.php",
            dataType: "json",
            data: { function: JSON.stringify(array) },
            beforeSend: function () {

            },
            success: function (data) {
        
                console.log(data);
                

                // $("#listaDepartamento").empty(); //limpia para iniciar una nueva busqueda
                
                // $.each(data, function (key, value) {

                //     $("#listaDepartamento").prepend(
                //                             "<option selected value='"+value.IdDepartamental+"' >"+value.Departamento+"</option>"
                //                             );
                // });
                // $("#listaDepartamento").prepend("<option selected value = ''>Seleccione Departamento</option>");
                
                
                // // ********************listaPorDepartamento
                
                // $("#listaPorDepartamento").empty(); //limpia para iniciar una nueva busqueda
                
                // $.each(data, function (key, value) {

                //     $("#listaPorDepartamento").prepend(
                //                             "<option selected value='"+value.IdDepartamental+"' >"+value.Departamento+"</option>"
                //                             );
                // });
                // $("#listaPorDepartamento").prepend("<option selected value = ''>Seleccione Departamento</option>");
                
            },
            error: function () {

            }
        });
}

// $(function(){

//   $('#inicial').timepicker({
//     timeFormat: 'HH:mm',
//     interval: 30,
//     minTime: '00:00',
//     maxTime: '23:00',
//     startTime: '12:00',
//     dynamic: true,
//     dropdown: true,
//     scrollbar: true,
//     zindex: 9999999,
//     change: function(time){

//       $('#horaInstalacion').val('');

//       $('#horaInstalacion').timepicker({
//         timeFormat: 'HH:mm',
//         interval: 30,
//         dynamic: true,
//         dropdown: true,
//         scrollbar: true,
//         zindex: 9999999
//       });

//       var inicialTime = time.getTime();
//       var minTime = new Date(time.getTime() + (.5*60*60*1000));
//       var maxTime = new Date(time.getTime() + (2*60*60*1000));
//       $('#horaInstalacion').timepicker('option','minTime', minTime);
//       $('#horaInstalacion').timepicker('option','maxTime', maxTime);
  
//     }
//   });
// });