<?php
    
    session_start();
    if (!isset($_SESSION['user_login_status'])) {
        header("location: ./login/index.php");
		exit;
    }
    
    date_default_timezone_set('America/Lima');
    function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
    }
    function format_date_dd_mm_Y($date){
        return date('d/m/Y', strtotime($date));
    }
    function format_date_Y_mm_dd($date){
        return date('Y-m-d', strtotime($date));
    }
    
    include 'config/db.php';
    include 'config/conexion.php';
    
?>

<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title>Verisure | VeriSmart</title>
        <!-- Tell the browser to be responsive to screen width -->
        <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
        <link rel="icon" type="image/png" href="admin/dist/img/-apple-touch-icon-144x144.png" >
        <!-- Bootstrap 3.3.7 -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css">
        <!-- Font Awesome -->
        <link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
        <!-- Ionicons -->
        <link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">
       <!-- Theme style -->
        <link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
        <!-- AdminLTE Skins. Choose a skin from the css/skins folder instead of downloading all of them to reduce the load. -->
        <link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">
        <!-- bootstrap datepicker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
        <link href="//cdnjs.cloudflare.com/ajax/libs/bootstrap-datetimepicker/4.17.37/css/bootstrap-datetimepicker.css" rel="stylesheet"/>
        <!-- iCheck for checkboxes and radio inputs -->
        <link rel="stylesheet" href="admin/plugins/iCheck/all.css">
        <!-- Bootstrap time Picker -->
        <link rel="stylesheet" href="admin/plugins/timepicker/bootstrap-timepicker.min.css">
        <!-- Select2 -->
        <link rel="stylesheet" href="admin/bower_components/select2/dist/css/select2.min.css">
        <!-- DataTables -->
        <link rel="stylesheet" href="admin/bower_components/datatables.net-bs/css/dataTables.bootstrap.min.css">
        <link href="admin/plugins/bootstrap-toggle-master/css/bootstrap-toggle.min.css" rel="stylesheet" type="text/css"/>
        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->
        <!-- Google Font -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
        <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">
        <link href="admin/bower_components/bootstrap-datetimepicker/build/css/bootstrap-datetimepicker.min.css" rel="stylesheet" type="text/css"/>
        <!-- Alertifyjs -->
        <link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css"/>
        <link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css"/>

        <style>

            .tbinput {
                background: none!important;
                border: none;
                -webkit-appearance: none;
            }

            .classMantenimiento, .ClsLlamada, .clsInfoCTz, .clsNInt, .clsNIntMot, .clsNProc{
                display: none;
            }

            .ocultar {
                display: none;
            }

            .selected{
                background-color: #e0e0e0;
            }

            .subtitulo{
                text-decoration: underline;
                font-weight: bold;
            }

            label{
                font-weight: normal;
                font-size: 12px;
                text-align: left!important;
            }

            .botonTabla{
                background:none;
                border:none;
                display: none;
            }

            .swal2-popup{
                font-size: 1.5rem!important;
            }

            .swal2-styled.swal2-confirm{
                background-color: #e4002b!important;
            }

            .bordeRojo{
                border: 1px solid #e4002b;
            }

            .obligatorio{
                display: none;
                color: red;
            }

            .derecha{
                text-align: right;
            }

            #tinviable, #tinviableespacio, #tcanceladoespacio, #tcancelado{
                display: none;
            }

            .modal-header-danger {
                color:#fff;
                background-color: #e4002b;
            }


            .preloader{
                background-color:#FFF;
                width: 100%;
                height: 100%;
                position: absolute;
                z-index: 1;
            }

            .dataTables_wrapper .myfilter .dataTables_filter{float:left}
            .dataTables_wrapper .mylength .dataTables_length{float:right}
            div.dataTables_scrollBody thead th {
                vertical-align: top;
            }
            td {
                max-width: 250px;
                overflow: hidden;
                white-space: nowrap;
                text-overflow: ellipsis;

            }
            .espacio{
                height:10px;
            }

           .espacio2{
                height:15px;
            }

            .thumbnail_style{
                text-align:center;
                border:none;
            }


            .caption h4{
                margin-top: -10px;
                font-size:13px;
                font-weight:  bold;
            }

            .caption p{
                color:#777;
                font-size:13px;
            }

            .caption a{
                color:#777;
                font-size:10px;
            }


            #frmEditarVenta .form-control{
                border-radius: 4px
            }

            #c-slider{
                margin: auto;
                width: 100%;
                max-width: 900px;
                position: relative;
                overflow: hidden;

            }
            #slider{
                display: flex;
                width: 200%;

            }
            #slider section{
                width: 100%;
            }


            .select2-container--default .select2-selection--single {

                border: 1px solid #d2d6de;
                border-radius: 4px;font-size: 12px;
                padding:4px 6px;
            }

            .btn-nuevo {
                color: #FFFFFF;
                background-color: #444444;
                border-color: #444444;
            }

            .btn-nuevo:hover,
            .btn-nuevo:focus,
            .btn-nuevo:active,
            .btn-nuevo.active,
            .open .dropdown-toggle.btn-nuevo {
                color: #FFFFFF;
                background-color: #616161;
                border-color: #444444;
            }

            .btn-nuevo:active,
            .btn-nuevo.active,
            .open .dropdown-toggle.btn-nuevo {
                background-image: none;
            }

            .btn-nuevo.disabled,
            .btn-nuevo[disabled],
            fieldset[disabled] .btn-nuevo,
            .btn-nuevo.disabled:hover,
            .btn-nuevo[disabled]:hover,
            fieldset[disabled] .btn-nuevo:hover,
            .btn-nuevo.disabled:focus,
            .btn-nuevo[disabled]:focus,
            fieldset[disabled] .btn-nuevo:focus,
            .btn-nuevo.disabled:active,
            .btn-nuevo[disabled]:active,
            fieldset[disabled] .btn-nuevo:active,
            .btn-nuevo.disabled.active,
            .btn-nuevo[disabled].active,
            fieldset[disabled] .btn-nuevo.active {
                background-color: #444444;
                border-color: #444444;
            }

        </style>

        <style>
            .main-header,.main-sidebar,.left-side{
                position:fixed
            }
            
            .main-header {
                top: 0;
                right: 0;
                left: 0
            }
            
            .content-wrapper,
            .right-side {
                padding-top: 50px
            }
            
            @media (max-width:767px) {
                 .content-wrapper,
                 .right-side {
                    padding-top: 100px
                }
            }
            
            .layout-boxed .wrapper {
                max-width: 100%
            }
            
            .wrapper {
                overflow: hidden
            }
            
            .control-sidebar {
                position: fixed;
                height: 100%;
                overflow-y: auto;
                padding-bottom: 50px
            }
        </style>

        <style>
            .ui-autocomplete {
                position: absolute;
                z-index: 1000;
                cursor: default;
                padding: 0;
                margin-top: 2px;
                list-style: none;
                font-size: 11px;
                font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
                background-color: #ffffff;
                border: 1px solid #ccc;
                -webkit-border-radius: 5px;
                   -moz-border-radius: 5px;
                        border-radius: 5px;
                -webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                   -moz-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                        box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
            
                    z-index: 1051 !important;
            
            }
            
            hr {
              height: 4px;
              width: 100%;
              background-color: #ecf0f5;
            
            }

            hr {
                /* margin-top: 20px; */
                margin-bottom: 20px;
                border: 0;
                /* border-top: 1px solid #eee; */
            }
            
            hr {
                display: block;
                unicode-bidi: isolate;
                -webkit-margin-before: 0.5em;
                -webkit-margin-after: 0.5em;
                -webkit-margin-start: auto;
                -webkit-margin-end: auto;
                overflow: hidden;
                border-style: inset;
            
            }

            .box.box-custom {
                border-top-color: #ffffff;
            }
            
            .box {
                position: relative;
                border-radius: 3px;
                background: #ffffff;
                border-top: 3px solid #d2d6de;
                margin-bottom: 5px;
                width: 100%;
                box-shadow: 0 1px 1px rgba(0,0,0,0.1);
            }

        </style>
                
        <style>
            .btn-blanco {
              background-color: white;
            }
    
            .btn-blanco{
              border: none;
            }
    
            .btn-blanco i{
              color: #E4002B;
            }
    
            .blanco-sinborde{
              background: white!important;
              border: none;
            }
            
            .info-tec label{
                text-align:left; 
                padding: 8px 15px;    
            }
            
            .info-tec button{
                padding: 4px 10px; 
                font-size: 16px;    
            }
            
            .info-tec p{
                padding: 4px 10px; 
                font-size: 16px; 
                font-weight: 600;
                display: inline-block;
            }
            
            
            .texto-derecha{
                text-align: right;
            }
    
        </style>
        
        <style>
            .red{
                color: #E4002B;
            }
            .green{
                color: green;
            }
            .orange{
                color: orange;
            }
            
            select + span.select2:focus, select + span.select2 *:focus { 	outline-color: #7d3c8c; 	outline-width: 1px; }
            .select2-container--default.select2-container--focus, .select2-selection.select2-container--focus, .select2-container--default:focus, .select2-selection:focus, .select2-container--default:active, .select2-selection:active {
                outline: none;
                border: 1px solid #3c8dbc;
                border-radius: 4px;
            }
            
            .btn-verisure { 
                color: #ffffff; 
                background-color: #FF0033; 
                border-color: #FF0033; 
            } 
             
            .btn-verisure:hover, 
            .btn-verisure:focus, 
            .btn-verisure:active, 
            .btn-verisure.active, 
            .open .dropdown-toggle.btn-verisure { 
                color: #ffffff; 
                background-color: #a62828; 
                border-color: #a62828; 
            } 
             
            .btn-verisure:active, 
            .btn-verisure.active, 
            .open .dropdown-toggle.btn-verisure { 
                background-image: none; 
            } 
             
            .btn-verisure.disabled, 
            .btn-verisure[disabled], 
            fieldset[disabled] .btn-verisure, 
            .btn-verisure.disabled:hover, 
            .btn-verisure[disabled]:hover, 
            fieldset[disabled] .btn-verisure:hover, 
            .btn-verisure.disabled:focus, 
            .btn-verisure[disabled]:focus, 
            fieldset[disabled] .btn-verisure:focus, 
            .btn-verisure.disabled:active, 
            .btn-verisure[disabled]:active, 
            fieldset[disabled] .btn-verisure:active, 
            .btn-verisure.disabled.active, 
            .btn-verisure[disabled].active, 
            fieldset[disabled] .btn-verisure.active { 
              background-color: #555758; 
              border-color: #555758; 
            } 
        </style>
        
        <style>
            #divLoading {
                  background: rgba(66,118,164,0.4);
                  width: 100%;
                  height: 100%;
                  min-height: 100%;
                  position: absolute;
                  top: 0;
                  left: 0;
                  z-index: 999999999;
                  display:none;
                }
            
            .spinner {
              margin: 300px auto 0;
              width: 70px;
              text-align: center;
            }
            
            .spinner > div {
              background-color: #e4002b;
              width: 18px;
              height: 18px;
              border-radius: 100%;
              display: inline-block;
              -webkit-animation: sk-bouncedelay 1.4s infinite ease-in-out both;
              animation: sk-bouncedelay 1.4s infinite ease-in-out both;
            }
            
            .spinner .bounce1 {
              -webkit-animation-delay: -0.32s;
              animation-delay: -0.32s;
            }
            
            .spinner .bounce2 {
              -webkit-animation-delay: -0.16s;
              animation-delay: -0.16s;
            }
            
            @-webkit-keyframes sk-bouncedelay {
              0%, 80%, 100% { -webkit-transform: scale(0) }
              40% { -webkit-transform: scale(1.0) }
            }
            
            @keyframes sk-bouncedelay {
              0%, 80%, 100% {
                -webkit-transform: scale(0);
                transform: scale(0);
              } 40% {
                -webkit-transform: scale(1.0);
                transform: scale(1.0);
              }
            }
            
            .centrar-texto {
                text-align: center;
            }
            
            .m_get_started.fix {
                height: 100%;
                padding: 0;
                text-align: center;
                opacity: 1;
            }
            
            .callout {
                border-radius: 3px;
                margin: 0 0 20px 0;
                padding: 15px 30px 15px 15px;
                border-left: 5px solid #f03;
                -webkit-box-shadow: 10px 10px 5px -9px rgba(0,0,0,0.75);
                -moz-box-shadow: 10px 10px 5px -9px rgba(0,0,0,0.75);
                box-shadow: 10px 10px 5px -9px rgba(0,0,0,0.75);
            }
            .bg-deuda{
                color: #000;
                background-color: #ffffff !important;
            }
            
            .bg-visita{
                color: #fff;
                background-color: #008000 !important;
            }
            .bg-gestion{
             color: #fff;
            background-color: #6a6659 !important;   
            }
            .bg-televenta{
                color: #fff;
                background-color: #f39c12 !important;
                cursor: pointer;
            }
            
            input#nombres { text-transform: uppercase; }
            input#apellido_p { text-transform: uppercase; }
            input#apellido_m { text-transform: uppercase; }
            input#leadid { text-transform: uppercase; }
        </style>

    </head>

    <body class="sidebar-collapse skin-red sidebar-mini">
        
        <div id="divLoading" style="display: none;height: auto; min-height: 100%;">
            <div class="spinner">
              <div class="bounce1"></div>
              <div class="bounce2"></div>
              <div class="bounce3"></div>
            </div>
        </div>

        <div class="wrapper">
            <!-- Header -->
            <?php include 'admin/header.php'; ?>
            <!-- Left side column. contains the logo and sidebar -->
            <?php include 'admin/main-sidebar.php'; ?>

            <div class="content-wrapper">
                <!-- Content Header (Page header) -->
                <section class="content-header">
                    <h1>
                        Lead
                    </h1>
                    <ol class="breadcrumb">
                        <li><a href="dashboard1.php"><i class="fa fa-dashboard"></i> Home</a></li>
                        <li class="active">Registrar Leads</li>
                    </ol>
                </section>
                <!-- Main content -->
                <section class="content">
                    <div class="row">
                        <div class="col-md-2"></div>
                        <div class="col-md-8">
                            <div class="box box-danger">
                                <div class="box-header">
                                    <h3 class="box-title">LEAD N° - </h3>
                                    <div class="box-tools pull-right">
                                        <button class="btn btn-nuevo btn-sm" id="btnGuardar"><i class="fa fa-save"></i></button>
                                        <a href="tvasignacionlead.php" class="btn btn-danger btn-sm"><i class="fa fa-reply"></i></a>
                                    </div>
                                    <div class="infoLead">
                                        <input type="hidden" id="fechaUltimaGestion" name="fechaUltimaGestion" value="">
                                        <input type="hidden" id="ultimaGestion" name="ultimaGestion">
                                    </div>
                                </div>
                                <div class="espacio"></div>
                            </div>
                            <div id="frmRegistrarLead" method="post">
                                <div class="box box-custom">
                                    <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                        <h5>INFORMACION DE LA GESTIÓN</h5>
                                        <div class="box-tools pull-aca right">
                                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="box-body">
                                        <!-- DATOS DE LA GESTIÓN -->
                                        <div class="form-horizontal" style="padding: 10px 20px 0">
                                            <div>
                                                <h5 class="subtitulo">DETALLE DE LA TRANSFERENCIA</h5>
                                            </div>
                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">TIPO CONTACTO:</label>
                                                <div class="col-lg-3">
                                                    <input type="text"  class="form-control input-sm" id="contacto" name="contacto" value="" readonly>
                                                </div>
                                                <div class="col-lg-2"></div>
                                            </div>
                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">TIPIFICACIÓN: <span style="color:red"> * </span></label>
                                                <div class="col-lg-3">
                                                    <input type="text"  class="form-control input-sm" id="tipificacion" name="tipificacion" value="" readonly>
                                                </div>
                                                <div class="col-lg-2">&nbsp</div>
                                                <label class="col-lg-2 control-label subtipificacion" style="padding-left: 35px;">SUB-TIPIFICACIÓN: <span style="color:red"> * </span></label>   
                                                <div class="col-lg-3 subtipificacion">
                                                    <input type="text"  class="form-control input-sm" id="motivo" name="motivo" value="" readonly>
                                                </div>
                                            </div>
                                            
                                            <div class="form-group rellamada ocultar">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">FECHA HORA RELLAMADA: <span style="color:red"> * </span></label>
                                                <div class="col-lg-3">
                                                    <div class='input-group'>
                                                        <input type='text' class="form-control input-sm datetimepicker" id="fechahoraRellamada" name="fechahoraRellamada" />
                                                        <span class="input-group-addon">
                                                            <span class="glyphicon glyphicon-calendar"></span>
                                                        </span>
                                                    </div>
                                                </div>
                                                <div class="col-lg-2">&nbsp</div>
                                            </div>
                                            
                                            <div class="form-group transferencia">
                                                <label class="col-lg-2 control-label" style="text-align: left; padding-left: 35px;">TIPO TRANSF: <span style="color:red"> * </span></label>
                                                <div class="col-lg-3">
                                                    <select class="form-control input-sm" name="lbltipotransf" id="lbltipotransf" style="width: 100%;">
                                                        <option value="">Seleccione</option>
                                                        <option value="EnLinea">En Linea</option>
                                                        <option value="BD">BD</option>
                                                        <option value="BD48horas">BD - 48 horas</option>
                                                    </select>
                                                </div>
                                                <div class="col-lg-2">&nbsp;</div>
                                                <label class="col-lg-2 control-label gestortv" style="padding-left: 35px;">GESTOR TV: <span style="color:red"> * </span></label>
                                                <div class="col-lg-3 gestortv">
                                                    <select class="form-control input-sm cbxtelecierre" name="lblgestortv" id="lblgestortv" style="width: 100%;">
                                                        <option value="" selected disabled>Seleccione</option>
                                                    </select>
                                                </div>
                                            </div>
                                            
                                            
                                            <br>
                                            <div class="form-horizontal" style="display:none">
                                                <div>
                                                    <h5 class="subtitulo">HISTORICO GESTIÓN</h5>
                                                </div>
                                                <div class="col-md-3"></div>
                                                <div class="col-md-6 table-responsive">
                                                    <table class="table table-hover" id="historicoGestion">
                                                        <thead>
                                                            <tr>
                                                                <th>#</th>
                                                                <th>Resultado</th>
                                                                <th>Gestor</th>
                                                                <th>FechaGestion</th>
                                                                <!-- <th>FechaCotizacion</th> -->
                                                                <th>FechaRellamada</th>
                                                                <th>Observaciones</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>                                        
                                        <!-- DATOS DEL AGENTE -->
                                        <div class="form-horizontal" style="padding: 10px 20px 0">
                                            <div>
                                                <h5 class="subtitulo">DATOS GENERALES DEL AGENTE</h5>
                                            </div>
                                            
                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">MATRICULA:</label>
                                                <div class="col-lg-3">
                                                  <input type="text" class="form-control input-sm" name="matriculaAgente" id="matriculaAgente" value="" disabled>
                                                </div>
                                                <div class="col-lg-2">&nbsp</div>
                                                <label class="col-lg-2 control-label">AGENTE:</label>
                                                <div class="col-lg-3">
                                                    <input type="text" class="form-control input-sm" name="Agente" id="Agente" value="" style="width: 100%;" disabled />
                                                </div>
                                            </div>
                                        </div>
                                        <!-- DATOS DE LA GESTIÓN -->
                                        <div class="form-horizontal" style="padding: 10px 20px 0">
                                            <div>
                                                <h5 class="subtitulo">DATOS GENERALES DE LA GESTIÓN</h5>
                                            </div>
                                            
                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">GESTIÓN: <span style="color:red"> * </span></label>
                                                <div class="col-lg-3">
                                                    <select class="form-control select2" id="gestion">
                                                        <option value="" selected disabled>SELECCIONE</option>
                                                        <option value="inbound">INBOUND</option>
                                                        <option value="internet">INTERNET</option>
                                                        <option value="correo">CORREO</option>
                                                    </select>
                                                </div>
                                                <div class="col-lg-2"></div>
                                                <label class="col-lg-2 control-label">CAMPAÑA:</label>
                                                <div class="col-lg-3">
                                                    <input type="text" class="form-control input-sm" name="campaña" id="campaña" value="Primer intento" disabled>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">NOMBRES: </label>
                                                <div class="col-lg-3">
                                                    <input type="text" class="form-control input-sm" id="nombres"  name="nombres" value="" maxlength="50">
                                                </div>
                                                <div class="col-lg-2"></div>
                                                <label class="col-lg-2 control-label">APELLIDOS:</label>
                                                <div class="col-lg-3">
                                                    <input type="text" class="form-control input-sm" name="apellidos" id="apellidos" value=""  >
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">TELÉFONO: <span style="color:red"> * </span></label>
                                                <div class="col-lg-3">
                                                    <input type="text" class="form-control pull-right input-sm" name="telefono" id="telefono" value="" maxlength="9" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');" >
                                                </div>
                                                <div class="col-lg-2"></div>
                                                <label class="col-lg-2 control-label">TELÉFONO 2: </label>
                                                <div class="col-lg-3">
                                                    <input type="text" class="form-control input-sm"  name="telefono2" id="telefono2" value=""  maxlength="9" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');">
                                                </div>
                                            </div>
                                            
                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">ORIGEN: </label>
                                                <div class="col-lg-3">
                                                    <input type="text" class="form-control pull-right input-sm" id="origen"  name="origen" value="">
                                                </div>
                                                <div class="col-lg-2"></div>
                                                <label class="col-lg-2 control-label">LEAD ID: <span style="color:red"> * </span></label>
                                                <div class="col-lg-3">
                                                    <input type="text" class="form-control input-sm"  name="leadid" id="leadid" value="" maxlength="16">
                                                </div>
                                            </div>
                                            
                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">DIRECCIÓN: </label>
                                                <div class="col-lg-10">
                                                    <div class="input-group" style="width: 100%">
                                                        <input type="text" class="form-control input-sm" id="direccion" name="direccion" placeholder="" value="" readonly>
                                                        <div class="input-group-addon btn" id="setDireccion">
                                                            <i class="fa fa-map-marker"></i>
                                                        </div>
                                                        <input type="hidden" id="IdDireccion" name="IdDireccion">
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">DEPARTAMENTO: </label>
                                                <div class="col-lg-3">
                                                    <select class="form-control input-sm select2full" name="Departamental" id="Departamental" style="width: 100%">
                                                        <option value="" selected>Seleccione</option>
                                                    </select>
                                                </div>
                                                <div class="col-lg-2"></div>
                                                <label class="col-lg-2 control-label">PROVINCIA:</label>
                                                <div class="col-lg-3">
                                                    <select class="form-control input-sm select2full" name="Provincial" id="Provincial" style="width: 100%">
                                                        <option value="">Seleccione</option>
                                                    </select>
                                                </div>
                                            </div>
                                            
                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">DISTRITO: </label>
                                                <div class="col-lg-3">
                                                    <select class="form-control input-sm select2full" name="Distrital" id="Distrital" style="width: 100%">
                                                        <option value="">Seleccione</option>
                                                    </select>
                                                </div>
                                                <div class="col-lg-2"></div>
                                            </div>
                                            
                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">OBSERVACIONES: </label>
                                                <div class="col-lg-10">
                                                    <textarea class="form-control input-sm" name="observaciones" id="observaciones" rows="3" style="resize:none" placeholder="Ingresar..."></textarea>
                                                </div>
                                            </div>
                                            
                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">SEGMENTO: </label>
                                                <div class="col-lg-3">
                                                    <select class="form-control input-sm" name="segmento" id="segmento" style="width: 100%">
                                                        <option value="">Seleccione</option>
                                                        <option value="RES">RES</option>
                                                        <option value="NEG">NEG</option>
                                                    </select>
                                                </div>
                                                <div class="col-lg-2"></div>
                                                <div class="Lead__nlocales ocultar">
                                                    <label class="col-lg-2 control-label" style="padding-left: 35px;">NLOCALES: </label>
                                                    <div class="col-lg-3">
                                                        <input type="number" class="form-control input-sm" name="nlocales" id="nlocales" value="" max="99"  min="0">
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">NDOCUMENTO: </label>
                                                <div class="col-lg-3">
                                                    <input type="text" class="form-control input-sm" name="ndocumento" id="ndocumento" value="" maxlength="11" disabled>
                                                    <input type="hidden" id="tipoDocumentoLead" name="tipoDocumentoLead">
                                                </div>
                                                <div class="col-lg-2"></div>
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">RESULTADO SCORING: </label>
                                                <div class="col-lg-3">
                                                    <div class="input-group" style="width: 100%">
                                                        <input type="text" class="form-control input-sm" id="resultadoScoring" name="resultadoScoring" value="" disabled>
                                                        <input type="hidden" id="idResultadoScoring"  name="idResultadoScoring">
                                                        <div class="input-group-addon btn" id="setScoring" data-toggle="modal" data-target="#modal-consultascoring">
                                                            <i class="fa fa-map-marker"></i>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;"></label>
                                                <div class="col-lg-3">
                                                    
                                                </div>
                                                <div class="col-lg-2"></div>
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">FECHA CONSULTA SCORING: </label>
                                                <div class="col-lg-3">
                                                    <div class="input-group" style="width: 100%">
                                                        <input type="text" class="form-control input-sm" id="fechaConsultaScoring" name="fechaConsultaScoring" value="" disabled>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="form-group">
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">FECHA HORA COTIZACION: <span style="color:red"> * </span></label>
                                                <div class="col-lg-3">
                                                    <div class='input-group'>
                                                        <input type='text' class="form-control input-sm datetimepicker" id="fechahoraCotizacion" name="fechahoraCotizacion" />
                                                        <span class="input-group-addon">
                                                            <span class="glyphicon glyphicon-calendar"></span>
                                                        </span>
                                                    </div>
                                                </div>
                                                <div class="col-lg-2">&nbsp</div>
                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">VUELTAS:</label>
                                                <div class="col-lg-3">
                                                    <input type="number" class="form-control input-sm" id="vueltas" name="vueltas" min="0" value="0" disabled>
                                                </div>
                                            </div>
                                            
                                        </div>
                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2">

                        </div>
                    </div>
                </section>
            </div>
            
            <div class="modal fade" id="mapgeofinder">
                <div class="modal-dialog modal-lg" style="width: 80%">
                    <div class="modal-content">
                        <div class="modal-header modal-header-danger">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                            <h4 class="modal-title">DIRECCION</h4>
                        </div>
                        <div class="modal-body" style="width: 100%;height:100%;">
                            <div class="row">
                                <div class="col-md-2"></div>
                                <div class="form-horizontal col-md-8">
                                    <div class="form-group">
                                        <label for="microzona" class="col-md-2 control-label">DIRECCION:</label>
                
                                        <div class="col-md-4">
                                            <input type="text" class="form-control input-sm" id="GeofinderDireccion" name="GeofinderDireccion" placeholder="Ingresar dirección ..." readonly>
                                            <input type="hidden" id="objGeofinder" name="objGeofinder">
                                            <input type="hidden" id="microzona" name="microzona">
                                        </div>
                                        
                                        <label for="lbltelefono" class="col-md-2 control-label">TELÉFONO:</label>
                
                                        <div class="col-md-4">
                                            <input type="text" class="form-control input-sm" id="GeofinderTelefono" name="GeofinderTelefono" placeholder="Ingresar telefono ..." disabled>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="Tipo" class="col-md-2 control-label">Tipo:</label>
                                        <div class="col-md-4">
                                            <div class="radio">
                                                <label>
                                                    <input type="radio" name="GeofinderTipoDireccion" id="Exacta" value="Exacta" checked="">
                                                    Exacta
                                                </label>
                                            </div>
                                            <div class="radio">
                                                <label>
                                                    <input type="radio" name="GeofinderTipoDireccion" id="Aproximada" value="Aproximada">
                                                    Aproximada
                                                </label>
                                            </div>
                                        </div>
                                        <label for="Busqueda" class="col-md-2 control-label">Busqueda:</label>
                                        <div class="col-md-4">
                                            <div class="Busqueda">
                                                <label>
                                                    <input class"" type="radio" name="Busqueda" id="Online" value="En Linea" checked="">
                                                    En Linea
                                                </label>
                                            </div>
                                            <div class="Busqueda">
                                                <label>
                                                    <input class"Busqueda" type="radio" name="Busqueda" id="Offline" value="Fuera de la llamada">
                                                    Fuera de la llamada
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="ocultar" id="Asignacion">
                                        
                                    </div>
                                    <div class="form-group">
                                        <div class="col-md-4"></div>
                                        <div class="col-md-2"><button class="btn btn-danger" id="btnGuardarGeofinderDireccion"><i class="fa fa-save"></i> Guardar</button></div>
                                        <div class="col-md-2"><button class="btn btn-default" id="btnNuevaDireccion"><i class="fa fa-plus"></i> Nueva Consulta</button></div>
                                        <div class="col-md-4"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-1"></div>
                                <div class="col-md-10">
                                    <iframe id="map" height="550"  allowTransparency="true" frameborder="0" scrolling="yes" style="width:100%;" src="GFWIDGET-PE/index.html" type= "text/javascript"></iframe>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <!--<button type="button" class="btn btn-danger pull-irght" id="btnDireccionManual">MANUAL</button> -->
                            <button type="button" class="btn btn-default pull-right" data-dismiss="modal">CERRAR</button>
                        </div>
                    </div>
                    <!-- /.modal-content -->

                </div>
                <!-- /.modal-dialog -->
            </div>
            
            <!-- MODAL SCORING -->
            <div class="modal fade" id="modal-consultascoring">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header modal-header-danger">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                            <h4>CONSULTAR SCORING</h4>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-horizontal" style="padding: 10px 20px 0">
                                        <div class="form-group">
                                            <label style="text-align: left;">TIPO DOCUMENTO:</label>
                                            <select class="form-control input-sm" name="EquifaxTipoDocumento" id="EquifaxTipoDocumento">
                                                <option value="">Seleccione</option>
                                                <option value="1">DNI</option>
                                                <option value="3">Carnet Extranjeria</option>
                                                <option value="6">RUC</option>
                                            </select>
                                            <a href="https://soluciones.equifax.com.pe/efx-portal-web/" target="_blank" title="Modal de Busqueda de Documento" id="btnBusquedaDocumento">(No tengo el Número de Documento)</a>
                                        </div>
                                        <div class="form-group">
                                            <label id="labeltelefono">DOCUMENTO: </label>
                                            <input type="text" class="form-control input-sm" name="EquifaxDocumento" id="EquifaxDocumento" maxlength="12" onkeypress="return event.charCode >= 48 && event.charCode <= 57">
                                        </div>
                                        <div class="form-group">
                                        <label>DEPARTAMENTO: </label>
                                            <select class="form-control input-sm select2full" name="EquifaxDepartamental" id="EquifaxDepartamental" style="width: 100%">
                                                    <option value="" selected>Seleccione</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                        <label>PROVINCIA: </label>
                                             <select class="form-control input-sm select2full" name="EquifaxProvincial" id="EquifaxProvincial" style="width: 100%">
                                                    <option value="">Seleccione</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                        <label>DISTRITO: </label>
                                            <select class="form-control input-sm select2full" name="EquifaxDistrital" id="EquifaxDistrital" style="width: 100%">
                                                    <option value="">Seleccione</option>
                                            </select>
                                         </div>
                                        <div class="form-group" style="margin-top:40px;">
                                            <button class="btn  btn-block btn-verisure" id="btnScoring">Consultar Scoring</button>
                                            <button class="btn  btn-block btn-verisure" style="display:none" id="btnNuevaScoring">Nueva Consulta</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <main class="contenedor ocultar box box-danger" id="ResultadoEquifax">
                                        <div id="resultado">
                                            <div class="callout bg-deuda">
                                                <h4><i class="fa fa-bullhorn"></i> Resultado de la Consulta:</h4>
                                                <h2 style="text-align: center;"><small class="label bg-visita"><span class="TextoAccion"></span></small><small class="label bg-televenta"><span class="TextoAccion"></span></small><small class="label bg-gestion"><span class="TextoAccion"></span></small></h2>
                                                <input type="hidden" id="idscoring">
                                                <!--<strong>N°Operación: </strong><span id="NOperacion">S32012280000162</span><br>-->
                                                <strong>Fecha Consulta: </strong><span id="FechaConsulta">13/11/2019 12:24:34</span><br><br>
                                                <div class="row">
                                                    <div class="col-xs-12">
                                                        <strong><i class="fa fa-user text-danger"></i> Nombre del Solicitante:</strong><br><span id="NombreCompleto">DUBOIS DORIBAL DUBOIS DORIBAL GLADYS ELVIRA</span><br>
                                                        <strong><i class="fa fa-folder-open text-danger"></i> <span id="TDocumento">DNI:</span></strong><br><span id="NumeroDocumento">00007039332</span><br>
                                                    </div>
                                       
                                                    <div class="col-xs-12">
                                                        <div class="contenido-score">
                                                            <div class="score-info">
                                                                <div>
                                                                    <strong>SCORE - RIESGO</strong>
                                                                    <br>
                                                
                                                                    <span id="Riesgo">Bajo</span>
                                                                </div>
                                                                <div>
                                                                    <strong>SCORE - VALOR</strong>
                                                                    <br>
                                                                    <div id="ValorScoring">952</div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                  </main>    
                                </div>
                             </div> 
                        </div>

                    </div>
                </div>
            </div>
            
            <!-- MODAL BUSQUEDA POR NOMBRE -->
            <div class="modal fade" id="modal-consultaScoringNombre">
    
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header modal-header-danger">
                            <input type="hidden" id="matriculausuario" value="<?php echo $matriculausuario;?>">
                            <input type="hidden" id="nombreusuario" value="<?php echo $nombreusuario;?>">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                            <h3 id="myModalLabel">Búsqueda por nombre</h3>
                        </div>
                    <div class="modal-body">
                        <div class="row">
                                <div class="form-group">
                                        <div class="col-xs-12 col-sm-4">
                                        <input type="hidden" value="8NFm8U48Px2TLc1sVJu0mmtZoli2wKJbRARvSKxJ" name="_token" id="_token">
                                        <input type="text" class="form-control input-sm" id="EquifaxNombres" name="EquifaxNombres" maxlength="100" placeholder="Nombres">
                                        </div>
                                        <div class="col-xs-12 col-sm-4">
                                        <input type="text" class="form-control input-sm" id="EquifaxApellidoPaterno" name="EquifaxApellidoPaterno" maxlength="100" placeholder="Apellido Paterno">
                                        </div>
                                        <div class="col-xs-12 col-sm-4">
                                        <input type="text" class="form-control input-sm" id="EquifaxApellidoMaterno" name="EquifaxApellidoMaterno" maxlength="100" placeholder="Apellido Materno">
                                        </div>                                        
                                </div>
                        </div>
                            <div class="col-xs-12 col-sm-12 table-responsive no-padding">
                                    <table class="table table-bordered" id="tblClientesEquifax" style="display:none;">
                                        <thead>
                                            <tr style="height:0.8vw">
                                                <td class="text-center">DNI</td>
                                                <td class="text-center">NOMBRES</td>
                                                <td class="text-center">APELLIDO PATERNO</td>
                                                <td class="text-center">APELLIDO MATERNO</td>
                                                <td class="text-center">ACCION</td>
                                            </tr>
                                        </thead>
                                        <tbody></tbody>
                                    </table>
                                </div>
                                        <div class="modal-footer">
                                            <a class="btn btn-link mensajematricula pull-left"  href="#"></a>
                                            <button type="button" class="btn btn-nuevo" id="Cerrarmodal" data-dismiss="modal">Cerrar</button>
                                            <button type="button" class="btn btn-danger" id="btnBuscar">Buscar</button>
                                        </div>
                        </div>
                    </div>
                    <!-- /.modal-content -->
                </div>
                <!-- /.modal-dialog -->
            </div>

            <div class="control-sidebar-bg"></div>
            
        </div><!-- ./wrapper -->
        
        <!-- jQuery v1.11 -->
        <script src="admin/bower_components/jquery/dist/jquery_v1.11.js" type="text/javascript"></script>
        <!-- jQuery UI 1.11.4 -->
        <script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
        <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
        <script>$.widget.bridge('uibutton', $.ui.button);</script>
        <!-- Bootstrap 3.3.7 -->
        <script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
        <!-- Select2 -->
        <script src="admin/bower_components/select2/dist/js/select2.full.min.js"></script>
        <!-- Sparkline -->
        <script src="admin/bower_components/jquery-sparkline/dist/jquery.sparkline.min.js"></script>
        <!-- Slimscroll -->
        <script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
        <!-- FastClick -->
        <script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
        <!-- AdminLTE App -->
        <script src="admin/dist/js/adminlte.min.js"></script>
        <script src="admin/bower_components/ag-grid-master/dist/ag-grid.min.js" type="text/javascript"></script>
        <!-- InputMask -->
        <script src="admin/plugins/input-mask/jquery.inputmask.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.date.extensions.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.extensions.js"></script>
        <!-- momentjs -->
        <script src="//cdnjs.cloudflare.com/ajax/libs/moment.js/2.15.2/moment.min.js"></script>
        <!-- bootstrap datepicker -->
        <script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
        <script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>
        <script src="//cdnjs.cloudflare.com/ajax/libs/bootstrap-datetimepicker/4.17.37/js/bootstrap-datetimepicker.min.js"></script>
        <!-- bottstrap toogle -->
        <script src="admin/plugins/bootstrap-toggle-master/js/bootstrap-toggle.min.js"></script>
        <!-- bootstrap time picker -->
        <script src="admin/plugins/timepicker/bootstrap-timepicker.min.js" type="text/javascript"></script>
        <!-- Alertify -->
        <script src="admin/bower_components/alertifyjs/alertify.min.js" type="text/javascript"></script>
        <!-- SweetAlert -->
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
        <!-- DataTables -->
        <script src="admin/bower_components/datatables.net/js/jquery.dataTables.min.js"></script>
        <script src="admin/bower_components/datatables.net-bs/js/dataTables.bootstrap.min.js"></script>
        <!-- iCheck 1.0.1 -->
        <script src="admin//plugins/iCheck/icheck.min.js"></script>
        
        <!-- CONSTANTES GLOBALES -->
        <script>
            const queryString = window.location.search;
            const urlParams = new URLSearchParams(queryString);
            const accion = urlParams.get('accion');
            const IdLeadCC = urlParams.get('IdLeadCC');
            const PerfilUsuario = $('#headerPerfilUsuario').val();
            const contenedorTablaHistoricoGestion = document.querySelector('#historicoGestion tbody');
            //Fecha y hora del momento
            const FechaActual = moment().format('DD/MM/YYYY hh:mm');

        </script>
        <!-- INICIALIZADORES -->
        <script>
            $('.select2').select2();
            
            $('.select2full').select2({
              selectOnClose: true
            });
            
            /*
            $('#mesGestion').datepicker({
                autoclose: true,
                language: 'en',
                firstDay: 1, format: 'M-yyyy',
                viewMode: "years",
                minViewMode: "months"

            }).datepicker("setDate", new Date());
            */
            
            $('#fechahoraCotizacion').datetimepicker().data("DateTimePicker").options({
                format: 'DD/MM/YYYY HH:mm'
            });
            
            /*
            $('#fechahoraUltLlamada').datetimepicker().data("DateTimePicker").options({
                format: 'DD/MM/YYYY HH:mm'   
            });
            */
            
            $('#fechahoraRellamada').datetimepicker().data("DateTimePicker").options({
                format: 'DD/MM/YYYY HH:mm'
                
            });
            
            $('#express').bootstrapToggle({
                on:'SI',
                off:'NO',
                onstyle:'success',
                offstyle:'danger'
            });
        
            
            
        </script>
        <!-- DOM -->
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                
                $('#fechahoraCotizacion').val(FechaActual);
                
                
                
                if(accion == 'actualizar'){
                    //CARGAR DATOS DEL LEAD ACTUALIZAR
                    cargarDatos(IdLeadCC);
                    //BLOQUEAR CAMPOS DE ACUERDO AL PERFIL
                    bloquearCampos();
                } else {
                    $('#matriculaAgente').val($('#headerMatriculaUsuario').val());
                    $('#Agente').val($('#headerNombreUsuario').val());
                
                    cargardepartamento();
                }
                
                
            });
        </script>
        <!-- EVENTOS -->
        <script>
            
            $("#Departamental").change(function () {
                $("#Departamental option:selected").each(function () {
                    var Provincial = $(this).val();
                    var datos={
                        Provincial:Provincial
                    };
                    var provincia= $("#Provincial");
                    var distrito= $("#Distrital");
                    
                     $.ajax({
                        data:datos,
                        url:   './ajax/selectProvincial.php',
                        type:  'POST',
                        dataType: 'json',
                        beforeSend: function () {
                            //provincia.prop('disabled', true);
                            //distrito.prop('disabled', true);
                        },
                        success:  function (r) {
                            provincia.prop('disabled', false);
                            distrito.prop('disabled', false);
                            
                            // Limpiamos el select de Provincia
                            provincia.find('option').remove();
                            provincia.append('<option value="">Seleccione</option>');
                            // Limpiamos el select de Distrito
                            distrito.find('option').remove();
                            distrito.append('<option value="">Seleccione</option>');
                            
                            $(r).each(function(i, v){ // indice, valor
                                provincia.append('<option value="' + v.id + '">' + v.text + '</option>');
                            })
                            
                            provincia.prop('disabled', false);
                            distrito.prop('disabled', false);
                        },
                        error: function(){
                            //alert('Ocurrio un error en el servidor ..');
                            provincia.prop('disabled', false);
                            distrito.prop('disabled', false);
                        }
                    });

                });
            });
            
            $('#EquifaxDepartamental').change(() => {
                $("#EquifaxDepartamental option:selected").each(function () {
                    //Obtener valor del Departamento y asignarlo a la variable provincia (mala definicion de la funcion)
                    const Provincial = $(this).val();
                    //Genera un objeto provincia (departamento) para traer los datos de la provincia
                    const datos={
                        Provincial:Provincial
                    };
                    //Definir las variables del select de provincia y distrito. Se modifica a const por se constantes
                    const provincia= $("#EquifaxProvincial");
                    const distrito= $("#EquifaxDistrital");
                    //Ajax para traer los datos de la base de datos. //CONSULTAR PROVINCIA
                    $.ajax({
                        data:datos,
                        url:   './ajax/selectProvincial.php',
                        type:  'POST',
                        dataType: 'json',
                        success:  function (r) {
                            provincia.prop('disabled', false);
                            distrito.prop('disabled', false);
                            
                            // Limpiamos el select de Provincia
                            provincia.find('option').remove();
                            provincia.append('<option value="">Seleccione</option>');
                            // Limpiamos el select de Distrito
                            distrito.find('option').remove();
                            distrito.append('<option value="">Seleccione</option>');
                            
                            $(r).each(function(i, v){ // indice, valor
                                provincia.append('<option value="' + v.id + '">' + v.text + '</option>');
                            })
                            
                            provincia.prop('disabled', false);
                            distrito.prop('disabled', false);
                        },
                        error: function()
                        {
                            //alert('Ocurrio un error en el servidor ..');
                            provincia.prop('disabled', false);
                            distrito.prop('disabled', false);
                        }
                    });
                })      
            })
                
            $("#Provincial").change(function () {
                    $("#Provincial option:selected").each(function () {
                        var Provincial = $(this).val();
                        var datos={
                            Provincial:Provincial
                        };
                        var provincia= $("#Distrital");
                         $.ajax({
                        data:datos,
                        url:   './ajax/selectDistrital.php',
                        type:  'POST',
                        dataType: 'json',
                        beforeSend: function () 
                        {
                           //provincia.prop('disabled', true);
                        },
                        success:  function (r) 
                        {
                            provincia.prop('disabled', false);
                            
                            // Limpiamos el select
                            provincia.find('option').remove();
                            provincia.append('<option value="">Seleccione</option>');
                            
                            $(r).each(function(i, v){ // indice, valor
                                provincia.append('<option value="' + v.id + '">' + v.text + '</option>');
                            })
                            
                            provincia.prop('disabled', false);
                        },
                        error: function()
                        {
                            //alert('Ocurrio un error en el servidor ..');
                            provincia.find('option').remove();
                            provincia.append('<option value="">Seleccione</option>');
                            provincia.prop('disabled', false);
                        }
                    });
    
                    });
                });
                
            $("#EquifaxProvincial").change(function () {
                $("#EquifaxProvincial option:selected").each(function () {
                    var Provincial = $(this).val();
                    var datos={
                        Provincial:Provincial
                    };
                    var provincia= $("#EquifaxDistrital");
                     $.ajax({
                        data:datos,
                        url:   './ajax/selectDistrital.php',
                        type:  'POST',
                        dataType: 'json',
                        success:  function (r) {
                            provincia.prop('disabled', false);
                            
                            // Limpiamos el select
                            provincia.find('option').remove();
                            provincia.append('<option value="">Seleccione</option>');
                            
                            $(r).each(function(i, v){ // indice, valor
                                provincia.append('<option value="' + v.id + '">' + v.text + '</option>');
                            })
                            
                            provincia.prop('disabled', false);
                        },
                        error: function(){
                            //alert('Ocurrio un error en el servidor ..');
                            provincia.find('option').remove();
                            provincia.append('<option value="">Seleccione</option>');
                            provincia.prop('disabled', false);
                        } //END ERROR
                    }); //END AJAX
                }); //END OPTION SELECTED
            });
            
            $("#gestion").change(function(){
                $("#gestion option:selected").each(function () {
                    
                    cargarResultados();
                    
                })
            })
            
            $('#segmento').change(function(){
                if($('#segmento').val() == 'NEG'){
                    $('.Lead__nlocales').removeClass('ocultar');
                } else{
                    $('.Lead__nlocales').addClass('ocultar');
                }
            })
            
            $("#tipificacion").change(function(){
                const tipificacion = $('#tipificacion').val();
                
                
                const motivo = $('#motivo');
                motivo.find('option').remove();
                motivo.append('<option value="" disabled selected>Seleccione</option>');


                if(tipificacion == 'apagado' || tipificacion == 'contestaCorta' || tipificacion == 'noContacto' || tipificacion == 'telefonoError' ||
                   tipificacion == 'visitaReconfirmar' || tipificacion == 'clienteError' || tipificacion == 'noCotizó' || tipificacion == 'prov' || tipificacion == 'zscc' || 
                   tipificacion == 'backoffice' || tipificacion == 'upselling' || tipificacion == 'RP' || tipificacion == 'prueba'){

                    $('.subtipificacion').addClass('ocultar');
                }else{
                    $('.subtipificacion').removeClass('ocultar');
                }


                if(tipificacion == 'atc'){
                    motivos = {
                        inconvenienteAlarma: 'Inconvenientes con alarma',
                        consultaFactura: 'Consulta de facturacion',
                        trasladoDispositivos: 'Traslado de dispositivos',
                        suspensionBajaServicio: 'Suspension/baja de servicio'
                    }
                    
                    for (let [llave, valor] of Object.entries(motivos)){
                        motivo.append(`<option value="${llave}">${valor}</option>`);
                    }
                }
                
                if(tipificacion == 'noAceptaVisita'){
                    motivos = {
                        camaras: 'Cámaras',
                        noPagoMensual: 'No desea pago mensual',
                        yaEncontroAlarma: 'Ya encontró alarma'
                    }
                    
                    for (let [llave, valor] of Object.entries(motivos)){
                        motivo.append(`<option value="${llave}">${valor}</option>`);
                    }
                }
                
                if(tipificacion == 'televenta'){
                    motivos = {
                        televenta: 'Televenta',
                        televentaCovid: 'Televenta - Covid',
                        televentaPrecio: 'Televenta - Precio',
                        televentaScoring: 'Scoring - TV'
                    }
                    
                    for (let [llave, valor] of Object.entries(motivos)){
                        motivo.append(`<option value="${llave}">${valor}</option>`);
                    }
                    
                    $('.transferencia').removeClass('ocultar');
                } else{
                    $('.transferencia').addClass('ocultar');
                }
                
                if(tipificacion === 'devolverLlamada'){
                    $('.rellamada').removeClass('ocultar');
                    
                    $('#fechahoraRellamada').val(FechaActual);
                    $('.subtipificacion').addClass('ocultar');
                } else {
                    $('.rellamada').addClass('ocultar');
                    $('#fechahoraRellamada').val('');
                }
                
                if(tipificacion === 'otros'){
                    motivos = {
                        rrhh: 'RRHH',
                        repeccion: 'Recepción',
                        facturacion: 'Facturación',
                        cobranzas: 'Cobranzas'
                    }
                    
                    for (let [llave, valor] of Object.entries(motivos)){
                        motivo.append(`<option value="${llave}">${valor}</option>`);
                    }
                }
                
                if(tipificacion === 'visitaAceptada'){
                    motivos = {
                        visitaAceptada: 'Visita aceptada',
                        visitaAceptadaCamara: 'Visita aceptada por cámaras'
                    }
                    
                    for (let [llave, valor] of Object.entries(motivos)){
                        motivo.append(`<option value="${llave}">${valor}</option>`);
                    }
                }
            })
            
            $(document).on('keydown', '.select2', function(e) {
                if (e.originalEvent && e.which == 40) {
                    e.preventDefault();
                    $(this).siblings('select').select2('open');
                } 
            });
            
            $(document).on("select2:close", '.select2-hidden-accessible', function () { $(this).focus(); });
            
            $('#contacto').change(function(){
                cargarResultados();
            });
            
            $('#setDireccion').on('click', function(e){
                e.preventDefault();
                if($('#telefono').val() === ''){
                    Swal.fire('Ingresar el ntelefono para georeferenciar', '', 'warning')
                }else{
                    $('#mapgeofinder').modal('show');
                }
                
            })
            
            $('#mapgeofinder').on('shown.bs.modal', function(){

                buscarDireccionLocalStorage();
                
                $('#GeofinderTelefono').val($('#telefono').val());
            })
            
            $('#btnScoring').on('click', function(){
                $('#btnScoring').prop('disabled', true);
                
                $('#divLoading').show();
                
                var matriculausuario=$('#matriculausuario').val(); 
                var nombreusuario=$('#nombreusuario').val();
                var TipoDocumento = $('#EquifaxTipoDocumento').val();
                var Documento = $('#EquifaxDocumento').val();
                var Departamental=$("#EquifaxDepartamental option:selected").text();
                var Provincial=$("#EquifaxProvincial option:selected").text();
                var Distrital=$("#EquifaxDistrital option:selected").text();
                var Ubigeo=$("#EquifaxDistrital").val();
                
                var datos = {
                    matriculausuario:matriculausuario,
                    nombreusuario:nombreusuario,
                    TipoDocumento: TipoDocumento,
                    Documento: Documento,
                    Departamental:Departamental,
                    Provincial:Provincial,
                    Distrital:Distrital,
                    Ubigeo:Ubigeo
                }
                
                if(validaFormEquifax(datos)){
                    
                    $.ajax({
                        type: "Post",
                        data: datos,
                        url: "ajax/funciones/soap2_pre.php",
                        dataType: "Json",
                        success: function (data){
                            
                            if (data.tipo == 'exito'){
                                
                                //AGREGA EL NDOCUMENTO AL INPUT
                                $('#ndocumento').val($('#EquifaxDocumento').val());
                                //GENERAR RESULTADO PARA EL MODAL
                                $('#FechaConsulta').html(data.fecha);
                                //AGREGAR FECHA SCORING AL CAMPO FECHA ULTIMA CONSULTA
                                $('#fechaConsultaScoring').val(data.fecha);
                                //ARREGLO DE DATOS DEL RESULTADO
                                var resultado = data.datos;
                                //RESULTADO DE SCORING
                                var resultadooperacion=resultado.respuestaSVC11Type.GrupoCampos.Campo[1].Valor;
                                //PEGAR RESULTADO DE SCORING Y ID EN LOS CAMPOS
                                $('#resultadoScoring').val(resultadooperacion);
                                $('#idResultadoScoring').val(data.id_scoring);
                                $('#tipoDocumentoLead').val($('#EquifaxTipoDocumento').val());
                                
                                if(resultadooperacion == 'Pasar a Televenta'){
                                    $('#contacto').val('SI').trigger('change');
                                    $('#tipificacion').val('televenta').trigger('change');
                                }
                                
                                
                                $('.TextoAccion').html(resultadooperacion);
                                
                                if(resultadooperacion=="Generar Visita"){
                                    $('.bg-visita').show();
                                    $('.bg-televenta').hide();
                                    $('.bg-gestion').hide();
                                }else if(resultadooperacion=="Pasar a base de datos-48 horas" || resultadooperacion=="Pasar a Televenta"){
                                    $('.bg-visita').hide();
                                    $('.bg-televenta').show();
                                    $('.bg-gestion').hide();
                                }else{
                                    $('.bg-visita').hide();
                                    $('.bg-televenta').hide();
                                    $('.bg-gestion').show();
                                }
                                
                                $('#idscoring').val(data.id_scoring);
                                //$('#ResultadoOperacion').html(resultado.respuestaSVC11Type.GrupoCampos.Campo[1].Valor);
                               //$('#NOperacion').html(resultado.respuestaSVC11Type.Header.NumeroOperacion);
                                $('#Riesgo').html(resultado.respuestaSVC11Type.Scores.Score.Riesgo + ' Riesgo');
                                if (resultado.respuestaSVC11Type.Integrante.TipoDocumento == 1){
                                    $('#NombreCompleto').html(resultado.respuestaSVC11Type.Integrante.ApellidoPaterno +' '+resultado.respuestaSVC11Type.Integrante.ApellidoMaterno +' '+resultado.respuestaSVC11Type.Integrante.Nombres);
                                    $('#TDocumento').html("DNI:");
                                }
                                else if (resultado.respuestaSVC11Type.Integrante.TipoDocumento == 6){
                                    if(resultado.respuestaSVC11Type.Integrante.NumeroDocumento.substr(0,2)==10 || resultado.respuestaSVC11Type.Integrante.NumeroDocumento.substr(0,2)==15 || resultado.respuestaSVC11Type.Integrante.NumeroDocumento.substr(0,2)==17){
                                        $('#NombreCompleto').html(resultado.respuestaSVC11Type.Integrante.ApellidoPaterno +' '+resultado.respuestaSVC11Type.Integrante.ApellidoMaterno +' '+resultado.respuestaSVC11Type.Integrante.Nombres);
                                    }else{
                                        $('#NombreCompleto').html(resultado.respuestaSVC11Type.Integrante.RazonSocial);
                                    }
                                    $('#TDocumento').html("RUC:");
                                }else{
                                    $('#NombreCompleto').html(resultado.respuestaSVC11Type.Integrante.ApellidoPaterno +' '+resultado.respuestaSVC11Type.Integrante.ApellidoMaterno +' '+resultado.respuestaSVC11Type.Integrante.Nombres);
                                    $('#TDocumento').html("CE:");
                                }
            
                                $('#NumeroDocumento').html(resultado.respuestaSVC11Type.Integrante.NumeroDocumento);
            
                                $('#ValorScoring').html(resultado.respuestaSVC11Type.Scores.Score.Valor);
                                
                                if(resultadooperacion=="Pasar a base de datos-48 horas"){
                                      $('#lbltipotransf').val('BD48horas');
                                 }else{
                                      $('#lbltipotransf').val('');
                                  }
                                            
                                $('#divLoading').hide();

                                $('#ResultadoEquifax').show();
                                $('#EquifaxTipoDocumento').prop('disabled', true); 
                                $('#EquifaxDocumento').prop('disabled', true);
                                
                                $("#EquifaxDepartamental").prop('disabled', true); 
                                $("#EquifaxProvincial").prop('disabled', true); 
                                $("#EquifaxDistrital").prop('disabled', true);
                                //$('#btnScoring').hide();
                                //$('#btnScoring').prop('disabled', false);
                                $('#btnNuevaScoring').show();
                            } else {
                                $('#divLoading').hide();
                                alert(data.mensaje);
                                $('#btnScoring').show();
                                $('#btnScoring').prop('disabled', false);
                                $('#btnNuevaScoring').hide();
                            }
                        } //END SUCCESS
                    }) //END AJAX
                } else{
                    
                    $('#divLoading').hide();
                    $('#btnScoring').prop('disabled', false);
                }
                
            })
            
            $('#btnNuevaScoring').on('click',function(){
                    $('#ResultadoEquifax').hide();
                    $('#EquifaxTipoDocumento').prop('disabled', false); 
                    $('#EquifaxDocumento').prop('disabled', false);
                    
                    $("#EquifaxDepartamental").prop('disabled', false); 
                    $("#EquifaxProvincial").prop('disabled', false); 
                    $("#EquifaxDistrital").prop('disabled', false);
                    
                    $('#btnNuevaScoring').hide();
                    $('#btnScoring').show();
                    $('#btnScoring').prop('disabled', false);
                    
                    $('#idscoring').val("");
                    
                    $('#EquifaxTipoDocumento').val("1"); 
                    $('#EquifaxDocumento').val("");
                    
                    $("#EquifaxDepartamental").val("");
                    $("#EquifaxProvincial").find('option').remove();
                    $("#EquifaxProvincial").append('<option value="">Seleccione</option>');
                    $("#EquifaxDistrital").find('option').remove();
                    $("#EquifaxDistrital").append('<option value="">Seleccione</option>');
                    
                    cargardepartamentoEquifax();
                    
          });
            
        </script>
        <!-- BTN GUARDAR -->
        <script>
            $('#btnGuardar').on('click', function(){
                
                if(accion == 'registrar'){
                    //AGENTE
                    const matriculaAgente = $('#matriculaAgente').val();
                    //TIPO DE GESTION
                    const gestion = $('#gestion').val();
                    const campaña = $('#campaña').val();
                    //DATOS DEL CLIENTE
                    const nombres = $('#nombres').val();
                    const apellidos = $('#apellidos').val();
                    const telefono = $('#telefono').val();
                    const telefono2 = $('#telefono2').val();
                    const origen = $('#origen').val();
                    const leadid = $('#leadid').val();
                    //GEOREFERENCIACION
                    const IdDireccion = $('#IdDireccion').val();
                    //DATOS EXTRA DEL CLIENTE    
                    const Departamental = $("#Departamental option:selected").text();
                    const Provincial = $('#Provincial option:selected').text();
                    const Distrital = $('#Distrital option:selected').text();
                    const observaciones = $('#observaciones').val();
                    const segmento = $('#segmento').val();
                    const nlocales = $('#nlocales').val();
                    //SCORING
                    const ndocumento = $('#ndocumento').val();
                    const idResultadoScoring = $('#idResultadoScoring').val();
                    //CAMPOS GESTION
                    const contacto = $('#contacto').val();
                    const tipificacion = $('#tipificacion').val();
                    const motivo = $('#motivo').val();
                    const fechahoraCotizacion = $('#fechahoraCotizacion').val();
                    const vueltas = $('#vueltas').val();
                    const fechahoraRellamada = $('#fechahoraRellamada').val();
                    //const fechahoraUltLlamada = $('#fechahoraUltLlamada').val();
                    //const Valexpress = $('#Valexpress').val();
                    
                    //TELEVENTA
                    const tipotransf = $('#lbltipotransf option:selected').val();
                    //MATRICULA DEL GESTOR
                    const gestorTV = $('#lblgestortv option:selected').val();
                    const tipoDocumentoLead = $('#tipoDocumentoLead').val();
  
                    const datos = {
                        accion,
                        matriculaAgente,
                        gestion,
                        campaña,
                        nombres,
                        apellidos,
                        telefono,
                        telefono2,
                        origen,
                        leadid,
                        IdDireccion,
                        Departamental,
                        Provincial,
                        Distrital,
                        observaciones,
                        segmento,
                        nlocales,
                        ndocumento,
                        idResultadoScoring,
                        tipificacion,
                        fechahoraCotizacion,
                        vueltas,
                        fechahoraRellamada,
                        motivo,
                        tipotransf,
                        gestorTV,
                        tipoDocumentoLead,
                        contacto
                    }
                    
                    
                    if(validarDatos(datos)){
                        
                        Swal.fire({
                          title: '¿Desea guardar los cambios?',
                          showCancelButton: true,
                          confirmButtonText: `Guardar`,
                          icon: 'info',
                        }).then((result) => {
                            /* Read more about isConfirmed, isDenied below */
                            if (result.isConfirmed) {
                                $.ajax({
                                    type: 'POST',
                                    url: 'ajax/insertLeadCC.php',
                                    data: datos,
                                    dataType: 'json',
                                    success: function (data) {
                                        
                                        console.log(data);
                                        
                                        const respuesta = data.respuesta;
                                        
                                        if(respuesta == 'exito'){
                                            let text;
                                            
                                            if(tipificacion == "televenta"){
                                                text = 'Lead trasnferido a TELEVENTA';
                                            } else {
                                                text = '';
                                            }
                                            
                                            Swal.fire({
                                                title: 'Lead generado correctamente',
                                                text: text,
                                                showCancelButton: true,
                                                confirmButtonText: `Ok`,
                                                icon: 'success',
                                            }).then((result) => {
                                                if (result.isConfirmed) {
                                                    const resultadoGestion = data.datosResultadoGestion;
                                                    const {Vueltas} = resultadoGestion;
                                                    const tipificacion = data.tipificacion;
                                                    const idLeadCC = data.idLeadCC;
                                                    
                                                    if(tipificacion == "visitaAceptada"){
                                                        Swal.fire({
                                                            title: 'GENERAR VISITA',
                                                            icon: 'success',
                                                            showCancelButton: true,
                                                            confirmButtonText: 'GENERAR'
                                                        }).then((result) => {
                                                            /* Read more about isConfirmed, isDenied below */
                                                            if (result.isConfirmed) {
                                                                window.location.href =  `generarVisita.php?IdLeadCC=${idLeadCC}`;
                                                            } else if (result.isDenied) {
                                                                Swal.fire('No se genero la visita', '', 'info')
                                                            }
                                                        })
                                                    } else {
                                                    
                                                        $('#vueltas').val(Vueltas);
                                                        
                                                        const idLeadCC = data.idLeadCC;
                                                        
                                                         window.location.href =  `editarLead.php?accion=actualizar&IdLeadCC=${idLeadCC}`;
                                                    }
                                                }
                                            })
                                            
                                            
                                        } else{
                                            
                                            if(data.detalle == "Duplicate entry '3123123123123' for key 'LeadID'"){
                                                Swal.fire('Error al guardar el lead', 'LeadID DUPLICADO', 'error')
                                            } else {
                                                Swal.fire('Error al guardar el lead', '', 'error')
                                            }
                                        }
                                        
                                    }
                                })
                          } 
                        })
                    }
                }
                
                if(accion == 'actualizar'){
                    
                    Swal.fire({
                        title: '¿Deseas guardar los cambios generados?',
                        showDenyButton: false,
                        showCancelButton: true,
                        confirmButtonText: `Asignar`,
                        icon: 'info',
                    }).then((result) => {
                      /* Read more about isConfirmed, isDenied below */
                        let datos;
                        let tipo;
                        //INFORMACION
                        if (result.isConfirmed) {
                            
                            const gestion = $('#gestion').val();
                            
                            const nombres = $('#nombres').val();
                            const apellidos = $('#apellidos').val();
                            const telefono = $('#telefono').val();
                            const telefono2 = $('#telefono2').val();
                            const Departamental = $("#Departamental option:selected").text();
                            const Provincial = $('#Provincial option:selected').text();
                            const Distrital = $('#Distrital option:selected').text();
                            const segmento = $('#segmento').val();
                            const nlocales = $('#nlocales').val();
                            const ndocumento = $('#ndocumento').val();
                            //GEOFINDER
                            const IdDireccion = $('#IdDireccion').val();
                            //EQUIFAX
                            const idResultadoScoring = $('#idResultadoScoring').val();
                            //OTROS DATOS
                            const origen = $('#origen').val();
                            const leadid = $('#leadid').val();
                            const observaciones = $('#observaciones').val();
                            const fechahoraCotizacion = $('#fechahoraCotizacion').val();
                            
                            tipo = 'informacion';
                            
                            datos = {
                                gestion,
                                tipo,
                                IdLeadCC,
                                nombres,
                                apellidos,
                                telefono,
                                telefono2,
                                Departamental,
                                Provincial,
                                Distrital,
                                segmento,
                                nlocales,
                                ndocumento,
                                IdDireccion,
                                idResultadoScoring,
                                origen,
                                leadid,
                                observaciones,
                                fechahoraCotizacion
                            }
                            
                            console.log(datos);
                            
                            if(gestion == 'inbound' || gestion == 'internet'){
                                if(origen == '' || origen == null){
                                    Swal.fire('Por favor, ingresar el ORIGEN', '', 'warning')
                                    return false;
                                }
                            }
                            
                            
                            if(PerfilUsuario == 55){
                                if($('#headerMatriculaUsuario').val() != $('#matriculaAgente').val()){
                                    Swal.fire('Solo puede modificar información el mismo gestor asignado', '', 'warning')
                                    return false;
                                }
                            }
                            
                            
                            $.ajax({
                                type: 'POST',
                                url: 'ajax/updateLeadCC.php',
                                data: datos,
                                dataType: 'json',
                                success: function (data) {
                                    console.log(data);
                                    
                                    const respuesta = data.respuesta;
                                    
                                    if(respuesta == 'exito'){
                                        
                                        Swal.fire('Información actualizada', '', 'success');
                                    
                                        const resultadoGestion = data.datosResultadoGestion;
                                        //const {Vueltas} = resultadoGestion;
                                        
                                        //$('#vueltas').val(Vueltas);
                                        
                                        //const idLeadCC = data.idLeadCC;
                                        
                                         //window.location.href =  `editarLead.php?accion=actualizar&IdLeadCC=${idLeadCC}`;
                                        cargarDatos(IdLeadCC);
                                        
                                    } else{
                                        Swal.fire('Error en el registro', '', 'error');
                                    }
                                    
                                }
                            })                         
                        
                        } 
                        //INFORMACION
                        else {
                            return;
                        }
                    })

                    
                }
                
            })
        </script>
        <!-- FUNCIONES -->
        <script>
            function validaFormEquifax(datos){
                const {TipoDocumento, Documento, Departamental, Provincial, Distrital} = datos;
                
                if (TipoDocumento == "") {
                    alertify.warning("Por favor ingresar Tipo de Documento");
                    return false;
                }
                
                if (Documento == "") {
                   alertify.warning("Por favor ingresar Número de Documento");
                   return false;
                }
                
                if (TipoDocumento == "6") {
                    if (Documento.length!=11) {
                       alertify.warning("Por favor ingresar los 11 digitos del RUC");
                       $("#EquifaxDocumento").focus();
                       return false;
                    }
                    
                    if (Documento.substr(0,2)==10 || Documento.substr(0,2)==20 || Documento.substr(0,2)==15 || Documento.substr(0,2)==17) {
                              
                    }else{
                        alertify.warning("Por favor ingresar correctamente el RUC debe comenzar 10 o 20");
                        $("#EquifaxDocumento").focus();
                        return false;
                    }
                }
                
                if (TipoDocumento == "1") {
                    if (Documento.length!=8) {
                        alertify.warning("Por favor ingresar los 8 digitos del DNI");
                        $("#EquifaxDocumento").focus();
                        return false;
                    }
                }
                
                if (TipoDocumento == "3") {
                    if (Documento.length==0) {
                       alertify.warning("Por favor ingresar CE");
                       $("#EquifaxDocumento").focus();
                       return false;
                    }
                }
                
                if (Departamental == "") {
                    alertify.warning("Por favor ingresar Departamento correspondiente");
                    $("#EquifaxDepartamental").focus();
                    return false;
                }
                if (Provincial == "") {
                    alertify.warning("Por favor ingresar Pronvincia correspondiente");
                    $("#EquifaxProvincial").focus();
                    return false;
                }
                if (Distrital == "") {
                    alertify.warning("Por favor ingresar Distrito correspondiente");
                    $("#EquifaxDistrital").focus();
                    return false;
                }
                
                return true;
            }
            
            function validarDatos(datos){
                
                const {gestion, leadid, telefono, tipificacion, fechahoraCotizacion, Distrital, fechahoraRellamada, IdDireccion, motivo, tipotransf, origen} = datos;
                
                if(gestion == '' || gestion == null){
                    Swal.fire('Indicar Gestión a realizar', '', 'warning')
                    return false;
                } else {
                    if(telefono == '' || telefono == null){
                        Swal.fire('Ingresar TELEFONO', '', 'warning')
                        return false;
                    }
                    
                    if (gestion == 'inbound'){
                        if (leadid == ''){
                            Swal.fire('Ingresar LEAD ID', '', 'warning')
                            return false;
                        }
                        
                        if(origen == ''){
                            Swal.fire('Ingresar ORIGEN', '', 'warning')
                            return false;
                        }
                    }
                    
                    if (gestion == 'internet'){
                        if (leadid == ''){
                            Swal.fire('Ingresar LEAD ID', '', 'warning')
                            return false;
                        }
                        
                        if(origen == ''){
                            Swal.fire('Ingresar ORIGEN', '', 'warning')
                            return false;
                        }
                    }
                    
                    if(tipificacion == '' || tipificacion == null){
                        Swal.fire('Ingresar TIPIFICACION', '', 'warning')
                        return false;
                    } else {
                        if(tipificacion == 'devolverLlamada'){
                            if(fechahoraRellamada == '' || fechahoraRellamada == null){
                                Swal.fire('Ingresar fechahoraRellamada', '', 'warning')
                                return false;
                            }
                        }
                        
                        if(tipificacion == 'visitaAceptada'){
                            
                            
                            if($('#resultadoScoring').val() == '' || $('#resultadoScoring').val() == null){
                                //Swal.fire('DEBES SCOREAR', '', 'warning')
                                //return false;
                            } else {
                                if($('#resultadoScoring').val() == 'Pasar a Televenta'){
                                    Swal.fire('No se puede generar visita por scoring', '', 'warning')
                                    return;
                                }
                            }
                            
                            
                            if(motivo == '' || motivo == null){
                                Swal.fire('Ingresar sub-tipificacion', '', 'warning')
                                return false;
                            }
                            
                            if($('#IdDireccion').val() == '' || $('#IdDireccion').val() == null){
                                //Swal.fire('DEBES GEOREFERENCIAR', '', 'warning')
                                //return false;
                            }
                            
                            if(Distrital == '' || Distrital =='Seleccione'){
                                Swal.fire('Ingresar Distrito', '', 'warning')
                                return false;
                            }
                            
                        }
                        
                        if(tipificacion == 'noAceptaVisita'){
                            if(motivo == '' || motivo == null){
                                Swal.fire('Ingresar sub-tipificacion', '', 'warning')
                                return false;
                            }
                        }
                        
                        if(tipificacion == 'televenta'){
                            
                            if(motivo == 'televenta'){
                                
                            } else {
                            
                                if($('#resultadoScoring').val() == '' || $('#resultadoScoring').val() == null){
                                    //Swal.fire('DEBES SCOREAR', '', 'warning')
                                    //return false;
                                } else {
                                    if($('#resultadoScoring').val() == 'Generar Visita'){
                                        if(motivo == 'televenta' || motivo == 'televentaScoring'){
                                            Swal.fire('Debes elegir otra subtipificacion', '', 'warning')
                                            return false;
                                        }
                                    }
                                    
                                    if($('#resultadoScoring').val() == 'Pasar a Televenta'){
                                        if(motivo == 'televentaCovid' || motivo == 'televentaPrecio'){
                                            Swal.fire('Debes elegir otra subtipificacion', '', 'warning')
                                            return false;
                                        }
                                    }
                                }
                            
                            }
                            
                            if(tipotransf == '' || tipotransf == null){
                                Swal.fire('Debes elegir el tipo de transferencia', '', 'warning')
                                return false;
                            } else {
                                if(tipotransf == 'EnLinea'){
                                    if($('#lblgestortv').val() == '' || $('#lblgestortv').val() == null){
                                        Swal.fire('Debes elegir el gestor de televenta', '', 'warning');
                                        return false;
                                    }
                                }
                            }
                            
                            if(Distrital == '' || Distrital =='Seleccione'){
                                Swal.fire('Ingresar Distrito', '', 'warning')
                                return false;
                            }
                            
                            
                        }
                        
                        if(tipificacion == 'atc'){
                            if(motivo == '' || motivo == null){
                                Swal.fire('Ingresar sub-tipificacion', '', 'warning')
                                return false;
                            } 
                        }
                        
                        if(tipificacion == 'otros'){
                            if(motivo == '' || motivo == null){
                                
                                return false;
                            } 
                        }
                    }
                    
                    if(fechahoraCotizacion == ''){
                        Swal.fire('Ingresar FECHA Y HORA COTIZACIÓN', '', 'warning')
                        return false;
                    }
                    
                    
                }
                return true;
            }
            
            function validarGestion(datos){
                
                const ultimaGestion = $('#ultimaGestion').val();
            
                const {tipificacion, motivo, idResultadoScoring, fechaConsultaScoring} = datos;
                
                if(tipificacion == '' || tipificacion == null){
                    Swal.fire('Seleccionar tipificacion', '', 'warning')
                    return false;
                } else {
                    
                    if(tipificacion == 'visitaAceptada'){
                        
                        if($('#resultadoScoring').val() == '' || $('#resultadoScoring').val() == null){
                            Swal.fire('DEBES SCOREAR', '', 'warning')
                            //return false;
                        }
                        
                        if($('#IdDireccion').val() == '' || $('#IdDireccion').val() == null){
                            //Swal.fire('DEBES GEOREFERENCIAR', '', 'warning')
                            //return false;
                        }
                        
                        if(fechaScoringValidar(fechaConsultaScoring)){
                            //Swal.fire('SCORE VENCIDO, DEBES VOLVER A SCOREAR', '', 'warning')
                            //return false;
                        }
                        
                        if(motivo == '' || motivo == null){
                            Swal.fire('Debes elegir la subtipificacion', '', 'warning')
                            return false;
                        }
                    } else if(tipificacion == 'televenta'){
                        if(motivo == 'televenta'){
                            if($('#lbltipotransf').val() == ''  || $('#lbltipotransf').val() == null){
                                Swal.fire('Debes elegir el tipo de transferencia', '', 'warning')
                                return false;
                            }
                            
                            if($('#resultadoScoring').val() == '' || $('#resultadoScoring').val() == null){
                                //NO REQUIERE SCOREAR
                            } else {
                                if(fechaScoringValidar(fechaConsultaScoring)){
                                    //Swal.fire('SCORE VENCIDO, DEBES VOLVER A SCOREAR', '', 'warning')
                                }
                            
                                if($('#resultadoScoring').val() == 'Generar Visita'){
                                    Swal.fire('Debes elegir otra subtipificacion', '', 'warning')
                                    return false;
                                }
                            }
                            
                        } else if (motivo == 'televentaScoring'){
                            if($('#resultadoScoring').val() == '' || $('#resultadoScoring').val() == null){
                                Swal.fire('DEBES SCOREAR', '', 'warning')
                                //return false;
                            } else {
                                if(fechaScoringValidar(fechaConsultaScoring)){
                                    //Swal.fire('SCORE VENCIDO, DEBES VOLVER A SCOREAR', '', 'warning')
                                }
                            
                                if($('#resultadoScoring').val() == 'Generar Visita'){
                                    Swal.fire('Debes elegir otra subtipificacion', '', 'warning')
                                    return false;
                                }
                                
                            }
                        } else {
                            
                            if($('#resultadoScoring').val() == '' || $('#resultadoScoring').val() == null){
                                Swal.fire('DEBES SCOREAR', '', 'warning')
                                //return false;
                            } else {
                                if(fechaScoringValidar(fechaConsultaScoring)){
                                    //Swal.fire('SCORE VENCIDO, DEBES VOLVER A SCOREAR', '', 'warning')
                                }
                            
                                if($('#resultadoScoring').val() == 'Pasar a Televenta' || $('#resultadoScoring').val() == 'Pasar a base de datos-48 horas'){
                                    Swal.fire('Debes elegir otra subtipificacion', '', 'warning')
                                    return false;
                                }
                            }
                        } 
                    } else if(tipificacion == 'devolverLlamada'){
                        if(fechahoraRellamada == '' || fechahoraRellamada == null){
                            Swal.fire('Ingresar fechahoraRellamada', '', 'warning')
                            return false;
                        }
                        
                        if(ultimaGestion == 'visitaAceptada' || ultimaGestion == 'televenta'){
                            Swal.fire('No se pueden realizar más gestiones', '', 'warning')
                            return false;
                        }
                    } else {
                        if(ultimaGestion == 'visitaAceptada' || ultimaGestion == 'televenta'){
                            Swal.fire('No se pueden realizar más gestiones', '', 'warning')
                            return false;
                        }
                    }
                    
                }
            
                return true;
            }
            
            function cargarDatos(IdLeadCC){
                
                datos ={IdLeadCC: IdLeadCC, 
                        tipo: 'formularioTV'};
                        
                console.log(datos);
                
                $.ajax({
                    type: 'POST',
                    url: 'ajax/selectListarLeadsCC.php',
                    data: datos,
                    dataType: 'json',
                    success: function (data) {
                        
                        console.log(data);
                        
                        if(data.resultado == 'exito'){
                            
                            const datosLead = data.lead;
                            
                            completarFormulario(datosLead);
                            
                            if(data.detalleLead != null){
                            
                            const datosdetalleLead = data.detalleLead;
                            
                            generarHistoricoGestion(datosdetalleLead);
                            }
                        }
                        
                    }
                })
            }
            
            function completarFormulario(datosLead){
                
                console.log(datosLead);

                const {ResultadoGestion, FechaUltimaGestion,Contacto,SubTipificacion,TipoTransferencia,GestorTV, Gestion, Nombres, Apellidos, Telefono, Telefono2, Origen, LeadID, IdDepartamental, Departamento, CodUbigeoReniec, Observaciones, Segmento, NLocales, FechaHoraCotizacion, Campaña, IdProvincial, Provincia, NDocumento, Direccion, Accion, FechaConsultaScoring, IdDireccion, IdScoring, Matricula, GestorNombreApellido} = datosLead;
                
                $('#matriculaAgente').val(Matricula);
                $('#Agente').val(GestorNombreApellido);
                
                $('#ultimaGestion').val(ResultadoGestion);
                $('#fechaUltimaGestion').val(FechaUltimaGestion);
                $('#gestion').val(Gestion).trigger('change');
                $('#nombres').val(Nombres);
                $('#apellidos').val(Apellidos);
                $('#telefono').val(Telefono);
                $('#telefono2').val(Telefono2);
                $('#origen').val(Origen);
                $('#leadid').val(LeadID);
                $('#observaciones').html(Observaciones);
                $('#segmento').val(Segmento);
                $('#nlocales').val(NLocales);
                $('#campaña').val(Campaña);
                
                $('#ndocumento').val(NDocumento);
                $('#idResultadoScoring').val(IdScoring);
                $('#IdDireccion').val(IdDireccion);
                $('#direccion').val(Direccion);
                $('#resultadoScoring').val(Accion);
                $('#fechaConsultaScoring').val(FechaConsultaScoring);
                $('#lbltipotransf').val(TipoTransferencia);
                $('#lblgestortv').val(GestorTV);
                $('#tipificacion').val(ResultadoGestion);
                $('#motivo').val(SubTipificacion);
                $('#contacto').val(Contacto);
                
                
                cargardepartamento(IdDepartamental, IdProvincial, CodUbigeoReniec);
                //$('#Departamental').val(IdDepartamental).trigger('change');
                //$('#Provincial').val(IdProvincial).trigger('change');
                //$('#Distrital').val(CodUbigeoReniec).trigger('change');
                
                $('#fechahoraCotizacion').val(FechaHoraCotizacion);
                
            }
            
            function bloquearCampos(){
                
                if(PerfilUsuario == '55' ){
                    $('#gestion').prop("disabled", true);
                    $('#telefono').prop("disabled", true);
                    $('#origen').prop("disabled", true);
                    $('#leadid').prop("disabled", true);
                    
                    $('#fechahoraCotizacion').prop('disabled', true);
                } else {
                    //$('#setScoring').prop("disabled", true);
                    //ACTIVAR FUNCION
                    $('#fechahoraCotizacion').prop("disabled", false);
                }
            }
            
            function generarHistoricoGestion(datosdetalleLead){
                
                limpiarHTML(contenedorTablaHistoricoGestion);
                
                datosdetalleLead.forEach(elemento => {
                    
                    const {Vueltas, ResultadoGestion, FechaHoraReg, FechaHoraRellamada, Matricula, Observaciones, Apellidos, Nombres} = elemento;
                    
                    const row = document.createElement('tr');
                    
                    $('#vueltas').val(Vueltas);
                    
                    let TextFechaHoraRellamada = '';
                    
                    if(FechaHoraRellamada == '0000-00-00 00:00:00' || FechaHoraRellamada == null){
                        TextFechaHoraRellamada = '';
                    } else {
                        TextFechaHoraRellamada = FechaHoraRellamada;
                    }
                    
                    row.innerHTML = `
                                <td>${Vueltas}</td>
                                <td>${ResultadoGestion}</td>
                                <td>${Matricula}</td>
                                <td>${FechaHoraReg}</td>
                                <td>${TextFechaHoraRellamada}</td>
                                <td>${Observaciones}</td>
                            `
                    contenedorTablaHistoricoGestion.appendChild(row);
                })
                
            }
            
            function limpiarHTML(cont) {
                //forma recomendada
                while (cont.firstChild) {
                    cont.removeChild(cont.firstChild);
                }
            }
            
            function cargardepartamentoEquifax(departamento, provincia, distrito){
                const EquifaxDepartamental = $('#EquifaxDepartamental');
                
                $.ajax({
                    url:   './ajax/selectDepartamental.php',
                    type:  'POST',
                    dataType: 'json',
                    success:  function (datos) {
                        //Departamento equifax
                        EquifaxDepartamental.find('option').remove();
                        EquifaxDepartamental.append('<option value="">Seleccione</option>');
                        //LLENAR LOS CAMPOS DEPARTAMENTO 
                        $(datos).each(function(i, v){ // indice, valor
                            if(v.id == departamento ){
                                EquifaxDepartamental.append('<option value="' + v.id + '">' + v.text + '</option>');
                            } else {
                                EquifaxDepartamental.append('<option value="' + v.id + '">' + v.text + '</option>');
                            }
                            
                            //Seleccionar al departamento de Lima si es un nuevo registro
                            if(departamento == '' || departamento == null){
                                $("#Departamental option[value='15']").attr("selected",true);
                            }
                            
                            $("#EquifaxDepartamental option[value='15']").attr("selected",true);
                        
                            $("#EquifaxDepartamental option:selected").each(function () {

                            const datos={
                                Provincial: $(this).val()
                            };
                            
                            const EquifaxProvincial= $("#EquifaxProvincial");
                            const EquifaxDistrital= $("#EquifaxDistrital");
                            
                            $.ajax({
                                data:datos,
                                url:   './ajax/selectProvincial.php',
                                type:  'POST',
                                dataType: 'json',
                                success:  function (data) {
                                    // Limpiamos el select de Provincia
                                    EquifaxProvincial.find('option').remove();
                                    EquifaxProvincial.append('<option value="">Seleccione</option>');
                                    // Limpiamos el select de Distrito
                                    EquifaxDistrital.find('option').remove();
                                    EquifaxDistrital.append('<option value="">Seleccione</option>');
                                    
                                    $(data).each(function(i, v){ // indice, valor
                                        EquifaxProvincial.append('<option value="' + v.id + '">' + v.text + '</option>');
                                    })
                                    
                                    $("#EquifaxProvincial option[value='128']").attr("selected",true);
                                    
                                    $("#EquifaxProvincial option:selected").each(function () {
                                        
                                        const datos={
                                            Provincial: $(this).val()
                                        };
                                    
                                        $.ajax({
                                            data:datos,
                                            url:   './ajax/selectDistrital.php',
                                            type:  'POST',
                                            dataType: 'json',
                                            success:  function (data) {
                                                // Limpiamos el select
                                                EquifaxDistrital.find('option').remove();
                                                EquifaxDistrital.append('<option value="">Seleccione</option>');
                                                
                                                $(data).each(function(i, v){ // indice, valor
                                                    EquifaxDistrital.append('<option value="' + v.id + '">' + v.text + '</option>');
                                                })
                                                EquifaxDistrital.trigger('change');
                                                
                                                EquifaxDistrital.prop('disabled', false);
                                            }
                                        });

                                    });
                            
                                }
                            });

                        });
                        })
                    }
                })
            }
            
            function cargardepartamento(departamento, provincia, distrito){

                const Departamental = $("#Departamental");
                const EquifaxDepartamental = $('#EquifaxDepartamental');
                
                 $.ajax({
                    url:   './ajax/selectDepartamental.php',
                    type:  'POST',
                    dataType: 'json',
                    success:  function (datos) {
                        
                        // Limpiamos el select de Departamento 
                        Departamental.find('option').remove();
                        Departamental.append('<option value="">Seleccione</option>');
                        //Departamento equifax
                        EquifaxDepartamental.find('option').remove();
                        EquifaxDepartamental.append('<option value="">Seleccione</option>');
                        //LLENAR LOS CAMPOS DEPARTAMENTO 
                        $(datos).each(function(i, v){ // indice, valor
                            if(v.id == departamento ){
                                Departamental.append('<option value="' + v.id + '" selected>' + v.text + '</option>');
                                EquifaxDepartamental.append('<option value="' + v.id + '">' + v.text + '</option>');
                            } else {
                                Departamental.append('<option value="' + v.id + '">' + v.text + '</option>');
                                EquifaxDepartamental.append('<option value="' + v.id + '">' + v.text + '</option>');
                            }
                        })
                        
                        //Seleccionar al departamento de Lima si es un nuevo registro
                        if(departamento == '' || departamento == null){
                            $("#Departamental option[value='15']").attr("selected",true);
                        }
                        
                        $("#Departamental option:selected").each(function () {
                            
                            const datos={
                                Provincial: $(this).val()
                            };
                            
                            const Provincial= $("#Provincial");
                            const Distrital= $("#Distrital");
                            
                            $.ajax({
                                data:datos,
                                url:   './ajax/selectProvincial.php',
                                type:  'POST',
                                dataType: 'json',
                                success:  function (data) {
                                    Provincial.prop('disabled', false);
                                    Distrital.prop('disabled', false);    
                                    // Limpiamos el select de Provincia
                                    Provincial.find('option').remove();
                                    Provincial.append('<option value="">Seleccione</option>');
                                    // Limpiamos el select de Distrito
                                    Distrital.find('option').remove();
                                    Distrital.append('<option value="">Seleccione</option>');
                                    
                                    $(data).each(function(i, v){ // indice, valor
                                        if(v.id == provincia ){
                                            Provincial.append('<option value="' + v.id + '" selected>' + v.text + '</option>');
                                        } else {
                                            Provincial.append('<option value="' + v.id + '">' + v.text + '</option>');
                                        }
                                    })
                                    
                                    if(departamento == '' || departamento == null){
                                        $("#Provincial option[value='128']").attr("selected",true);
                                    }
                                    
                                    $("#Provincial option:selected").each(function () {
                                        const datos={
                                            Provincial: $(this).val()
                                        };
                                        
                                        const Distrital= $("#Distrital");
                                        
                                        $.ajax({
                                            data:datos,
                                            url:   './ajax/selectDistrital.php',
                                            type:  'POST',
                                            dataType: 'json',
                                            success:  function (data) {
                                                
                                                // Limpiamos el select
                                                Distrital.find('option').remove();
                                                Distrital.append('<option value="">Seleccione</option>');
                                                
                                                $(data).each(function(i, v){ // indice, valor

                                                    if(v.id == distrito ){
                                                        Distrital.append('<option value="' + v.id + '" selected>' + v.text + '</option>');
                                                    } else {
                                                        Distrital.append('<option value="' + v.id + '">' + v.text + '</option>');
                                                    }
                                                    
                                                }) //END EACH
                                            } //END SUCCESS
                                        }); //END AJAX SELECT DISTRITAL
                                    }) //END EACH PROVINCIAL
                                } //END SUCCESS AJAX SELECT PROVINCIAL
                            })
                            
                        }) //END DEPARTAMENTAL SELECTED
                        
                        $("#EquifaxDepartamental option[value='15']").attr("selected",true);
                        
                        $("#EquifaxDepartamental option:selected").each(function () {

                            const datos={
                                Provincial: $(this).val()
                            };
                            
                            const EquifaxProvincial= $("#EquifaxProvincial");
                            const EquifaxDistrital= $("#EquifaxDistrital");
                            
                            $.ajax({
                                data:datos,
                                url:   './ajax/selectProvincial.php',
                                type:  'POST',
                                dataType: 'json',
                                success:  function (data) {
                                    // Limpiamos el select de Provincia
                                    EquifaxProvincial.find('option').remove();
                                    EquifaxProvincial.append('<option value="">Seleccione</option>');
                                    // Limpiamos el select de Distrito
                                    EquifaxDistrital.find('option').remove();
                                    EquifaxDistrital.append('<option value="">Seleccione</option>');
                                    
                                    $(data).each(function(i, v){ // indice, valor
                                        EquifaxProvincial.append('<option value="' + v.id + '">' + v.text + '</option>');
                                    })
                                    
                                    $("#EquifaxProvincial option[value='128']").attr("selected",true);
                                    
                                    $("#EquifaxProvincial option:selected").each(function () {
                                        
                                        const datos={
                                            Provincial: $(this).val()
                                        };
                                    
                                        $.ajax({
                                            data:datos,
                                            url:   './ajax/selectDistrital.php',
                                            type:  'POST',
                                            dataType: 'json',
                                            success:  function (data) {
                                                // Limpiamos el select
                                                EquifaxDistrital.find('option').remove();
                                                EquifaxDistrital.append('<option value="">Seleccione</option>');
                                                
                                                $(data).each(function(i, v){ // indice, valor
                                                    EquifaxDistrital.append('<option value="' + v.id + '">' + v.text + '</option>');
                                                })
                                                EquifaxDistrital.trigger('change');
                                                
                                                EquifaxDistrital.prop('disabled', false);
                                            }
                                        });

                                    });
                            
                                }
                            });

                        });
                    }
                 })
                
            }
            
            function cargarResultados(){
                const resultado = $('#tipificacion');
                const gestion = $("#gestion option:selected");
                
                resultado.find('option').remove();
                resultado.append('<option value="" disabled selected>SELECCIONE</option>');
                
                let Resultados;
                
                const contacto = $('#contacto').val();
                    
                if(gestion.val() === 'inbound'){
                    
                    if(contacto == 'SI'){
                        Resultados = {
                            devolverLlamada: 'Devolver llamada',
                            noAceptaVisita: 'No acepta visita',
                            visitaAceptada : 'Visita Aceptada',
                            clienteError: 'Cliente Error',
                            inviable: 'Inviable', 
                            prov: 'Prov',
                            televenta: 'Televenta', 
                            visitaReconfirmar: 'Visita por reconfirmar',
                            zscc: 'ZSCC - zona sin cobertura comercial', 
                            atc: 'ATC',
                            backoffice: 'BackOffice',
                            upselling: 'Upselling',
                            RP: 'RP',
                            otros: 'Otros',
                            prueba: 'Prueba',
                            duplicado: 'Duplicado'
                        }
                    } else if(contacto == 'NO') {
                        Resultados = {
                            contestaCorta: 'Contesta y corta',
                            duplicado: 'Duplicado'
                        }
                    }
                    
                } else {
                    if(contacto == 'SI'){
                        
                        Resultados = {
                            devolverLlamada: 'Devolver llamada',
                            noAceptaVisita: 'No acepta visita',
                            visitaAceptada : 'Visita Aceptada',
                            visitaReconfirmar: 'Visita por reconfirmar',
                            clienteError: 'Cliente Error',
                            inviable: 'Inviable', 
                            noCotizó: 'No Cotizó', 
                            prov: 'Prov',
                            televenta: 'Televenta', 
                            zscc: 'ZSCC - zona sin cobertura comercial',
                            duplicado: 'Duplicado'
                        }
                        
                    } else if(contacto == 'NO') {
                        Resultados = {
                            apagado: 'Apagado', 
                            contestaCorta: 'Contesta y corta',
                            noContacto: 'No Contacto',
                            telefonoError: 'Telefono Error ',
                            duplicado: 'Duplicado'
                        }
                    }
                }
                    
                
                if(Resultados != undefined){
                
                    if(gestion.val() === 'inbound'){
                        for (let [llave, valor] of Object.entries(Resultados)){
                            resultado.append(`<option value="${llave}">${valor}</option>`);
                        }
                    } else if (gestion.val() === 'internet'){
                        for (let [llave, valor] of Object.entries(Resultados)){
                            resultado.append(`<option value="${llave}">${valor}</option>`);
                        }
                    }else if (gestion.val() === 'correo'){
                        for (let [llave, valor] of Object.entries(Resultados)){
                            resultado.append(`<option value="${llave}">${valor}</option>`);
                        }
                    }
                    else if (gestion.val() === 'recovery'){
                        for (let [llave, valor] of Object.entries(Resultados)){
                            resultado.append(`<option value="${llave}">${valor}</option>`);
                        }
                    }
                }
            }
            
            function fechaScoringValidar(fechaConsultaScoring){
                var fechaInicio = new Date(fechaConsultaScoring).getTime();
                var fechaFin = new Date().getTime();
                var diff = (fechaFin - fechaInicio)/(1000*60*60*24);
                console.log('Diferencia de fecha scoring');
                console.log(diff)
                if(diff > 3){
                    return true;
                } else {
                    return false;
                }
            }
            
            function fechadiferencia(){
            
                var fechaUltGestion = $('#fechaUltimaGestion').val();
                
                var fechaInicio = new Date(fechaUltGestion).getTime();
                var fechaFin = new Date().getTime();
                var diff = (fechaFin - fechaInicio)/(1000*60);
                
                //MODIFICADO DE 5 a 1 minuto 3.11.2021
                if(diff < 1){
                    return false;
                } else {
                    return true;
                }
    
            }
        </script>
        <!-- FUNCIONES DIRECCIONES -->
        <script>
            function buscarDireccionLocalStorage(){
                if($('#GeofinderDireccion').val() == ''){
                    
                    localStorage.setItem('intervalBusquedaDireccion', true);
                    
                    let interval = setInterval(() => {
                        if(localStorage.getItem("ObjGeofinder") !== null){
                            const ObjGeofinder = JSON.parse(localStorage.getItem("ObjGeofinder"));
                            
                            //LLENA EL CAMPO OCULTAR CON EL OBJGEOFINDER EN FORMATO JSON
                            $('#objGeofinder').val(JSON.stringify(ObjGeofinder));
                            //CREA LA VARIABLE DIRECCION PARA OBTENER LA DIRECCION COMPLETA
                            let direccion = ObjGeofinder.fulladdress;
                            //GENERAR ZONAS
                            let zonas = ObjGeofinder.zonas;
                            let microzona = zonas[1].valor;
                            //Funcion para convertir la microzona al valor antiguo
                            microzona = convertirMicrozona(microzona);
                            //LLENA LA MICROZONA CON LA INFORMACION DEL OBJGEOFINDER
                            $('#microzona').val(microzona);
                            //LLENA EL PUNTO DIRECCION CON LA INFORMACION DEL OBJGEOFINDER
                            $('#GeofinderDireccion').val(direccion);
                            //LIMPIA EL INTERVALO DE BUSUQEDA
                            clearInterval(interval);
                            //BORRA EL OBJGEOFINDER DEL LOCALSTORAGE
                            localStorage.removeItem("ObjGeofinder");
                            //INTERVALO DE BUSUQEDA DE DIRECCION
                            localStorage.setItem('intervalBusquedaDireccion', false);
                        }
                    }, 2000); 
                }
                
            }
            
            function convertirMicrozona(microzona){
                let nuevaMicrozona = '';
                
                if(microzona.includes('-')){
                
                arraymicrozona = microzona.split("-");
                
                const ubigeo = arraymicrozona[0];
                
                let correlativo = '';
                
                //LISTA DE UBIGEOS CON 3 CARACTERES DE CORRELATIVOS
                
                const arregloUbigeos = ['150132',
                                        '150133',
                                        '130101',
                                        '130104',
                                        '130105',
                                        '130111',
                                        '130103',
                                        '130106',
                                        '130107',
                                        '130109',
                                        '130102',
                                        '200101',
                                        '200104',
                                        '200105',
                                        '200107',
                                        '200108',
                                        '200109',
                                        '200110',
                                        '200111',
                                        '200114',
                                        '200115',
                                        '040122',
                                        '040117',
                                        '040112',
                                        '040129',
                                        '040128',
                                        '040104',
                                        '040103',
                                        '040126',
                                        '040101',
                                        '040111',
                                        '040116',
                                        '040107',
                                        '040109',
                                        '040110',
                                        '040123',
                                        '040124',
                                        '040102',
                                        '040120',
                                        '040118',
                                        '040108',
                                        '040125',
                                        '040121',
                                        '040114',
                                        '040113',
                                        '040119',
                                        '040105',
                                        '040106'];

                if(arregloUbigeos.includes(ubigeo)){
                    correlativo = arraymicrozona[1];
                    correlativo = correlativo.slice(1, 4)
                    
                    nuevaMicrozona = `${ubigeo}${correlativo}`;
                } else {
                    correlativo = arraymicrozona[1];
                    correlativo = correlativo.slice(2, 4);
                    
                    nuevaMicrozona = `${ubigeo}${correlativo}`;
                }
                
                } else {
                    nuevaMicrozona = microzona;
                }
                
                return nuevaMicrozona;
                
            }
            
            $('#Offline').on('click', () => {
                $("#Offline").prop('checked', true);
                $('#Online').prop('checked', false);
            })
            
            $('#Online').on('click', () => {
                $("#Offline").prop('checked', false);
                $('#Online').prop('checked', true);
            })
            
            $('#btnNuevaDireccion').on('click', () => {
                $('#map').attr("src", $('#map').attr("src"));
                limpiarFormulario();
                buscarDireccionLocalStorage();
            })
            
            function limpiarFormulario(){
                $('#GeofinderDireccion').val('');
                $('#objGeofinder').val('');
                $('#microzona').val('');
            }
            
            $('#btnGuardarGeofinderDireccion').on('click', (e) => {
                
                e.preventDefault();
                
                if($('#GeofinderDireccion').val() === '' || $('#GeofinderTelefono').val() ==='' || $('#objGeofinder').val() === ''){
                    Swal.fire(
                      'Alerta!',
                      'Por favor, completar los datos.',
                      'warning'
                    )
                    return;
                }
                    
                let datos = {
                    direccion: $('#GeofinderDireccion').val(),
                    telefono: $('#GeofinderTelefono').val(),
                    objGeofinder: $('#objGeofinder').val(),
                    microzona: $('#microzona').val(),
                    tipo: $('input:radio[name=GeofinderTipoDireccion]:checked').val(),
                    Busqueda: $('input:radio[name=Busqueda]:checked').val()
                };
                
                $.ajax({
                    type: 'POST',
                    url: 'ajax/insertDireccion.php',
                    data: datos,
                    dataType: 'Json',
                    success: function (data) {
                        if(data.respuesta == 'Exito'){
                            
                            let MatriculaUsuario = $('#headerMatriculaUsuario').val();
                            
                            const usuariosPermitos = ['RO8382', 'EU8028', 'Q07435', 'Q09668', 'CI9479', 'OR1248', 'EX3980', 'Q02527', 'AW8955', 'CI9479', 'RO8382', 'EX3980', 'LD8209', 'MM8655', 'Q09668', 'Q13523', 'Q10823', 'Q11124', 'JU9001', 'Q24466', 'Q25649', 'Q25648', 'Q28362'];
                            
                            if((data.asignacion !== null || data.asignacion !== '') && (usuariosPermitos.includes(MatriculaUsuario))){
                                
                                let mensaje;
                                
                                if(data.asignacion == 'Field'){
                                    mensaje = "Se registro la dirección correctamente, GENERAR VISITA";
                                }
                                else if (data.asignacion == 'TV'){
                                    mensaje = "Se registro la dirección correctamente, <span style='color: red; font-weight: bold'>ENVIAR A TELEVENTA</span>";
                                }
                                else {
                                    mensaje = "Se registro la dirección correctamente";
                                }
                                
                                
                                Swal.fire(
                                    'Registro Exitoso!',
                                    mensaje,
                                    'success'
                                )
                                
                            } else {
                                Swal.fire(
                                  'Registro Exitoso!',
                                  'Se registro la dirección correctamente',
                                  'success'
                                )
                            }
                            
                            $('#direccion').val($('#GeofinderDireccion').val());
                            
                            const idDireccion = data.idDireccion;
                            $('#IdDireccion').val(idDireccion);
                            
                            
                            limpiarFormulario();
                            buscarDireccionLocalStorage();
                            $('#map').attr("src", $('#map').attr("src"));
                            
                            $('#mapgeofinder').modal('hide');
                            
                        } else {
                            Swal.fire(
                              'Error!',
                              'Ocurrio un error, por favor verificar.',
                              'error'
                            )
                        }
                        
                    }
                })
            })
        </script>
        <!-- FUNCIONES DE TELEVENTA-->
        <script>
            $("#lbltipotransf").change(function () {
                $("#lbltipotransf option:selected").each(function () {
                    var lbltipotransf = $(this).val();
                    if(lbltipotransf=="EnLinea"){
                        //$(".gestortv").removeClass("ocultar");
                    }else{
                       //$(".gestortv").addClass("ocultar");
                        $('.cbxtelecierre').val('').trigger('change');
                    }
                });
            });
            
            $('.cbxtelecierre').select2({
                placeholder: 'Seleccione Gestor TV',
                allowClear: true,
                language: {
                    errorLoading: function () {
                        return "La carga falló";
                    },
                    noResults: function () {
                        return "No hay resultado";
                    },
                    searching: function () {

                        return "Buscando..";
                    }
                },
                ajax: {
                    url: 'ajax/selectMatriculaTV_v2.php',
                    dataType: 'json',
                    delay: 250,
                    processResults: function (data) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                }
            });            
        </script>
        
        <script>
            // FUNCION PARA REFRESCAR LA PAGINA CADA 3 MINUTOS Y ESTAR ACTIVA
            document.addEventListener("DOMContentLoaded", function(){
                // Invocamos cada 3 minutos ;)
                const milisegundos = 3 *60000;
                
                setInterval(function(){
                    // No esperamos la respuesta de la peticion porque no nos importa
                    fetch("./ajax/refrescar.php");
                },milisegundos);
            });
        </script> 

    </body>

</html>