<?php
    session_start();
    if (!isset($_SESSION['user_login_status'])) {
        header("location: ./login/index.php");
		exit;
    }

    date_default_timezone_set('America/Lima');
    
    include 'config/db.php';
    include 'config/conexion.php';

    $fechadiahoy=date("d/m/Y");
    $fechconvercion=date('Y-m-d', strtotime($fechadiahoy));

    $dias=date("d");
    $mes=date("m");
    $ano=date("Y");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verisure | VeriSmart</title>
    
    <link rel="icon" type="image/png" href="admin/dist/img/-apple-touch-icon-144x144.png" />
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css">
    <!-- Select2 -->
    <link rel="stylesheet" href="admin/bower_components/select2/dist/css/select2.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
    <!-- Ionicons -->
    <link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
    <!-- AdminLTE Skins. Choose a skin from the css/skins
            folder instead of downloading all of them to reduce the load. -->
    <link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">
    <!-- daterange picker -->
    <link rel="stylesheet" href="admin/bower_components/bootstrap-daterangepicker/daterangepicker.css">
    <!-- Date Picker -->
    <link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
    <link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css"/>
    <!-- Alertifyjs -->
    <link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css"/>
    <!-- Google Font -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
    <!--Hoja de estilos de la pagina dashboard visita *No usuar stilos en la misma pagina-->
    <link rel="stylesheet" href="css/dashboardvisita.css">
    
    <link rel="stylesheet" href="admin/bower_components/datatables.net-bs/css/dataTables.bootstrap.min.css">
    
    <style>

        table tbody tr th{
            text-align: center;
        }
        .tblSubHeader, .Row__titulo{
            text-transform: uppercase;
        }
        
        .block{
            display: block!important;
        }
        
        .ocultar{
            display: none;
        }
        
        .bajo{
            background-color: #e4002b;
            color: white;
        }
        
        .medio{
            background-color: orange;
            color: white;
        }
        
        .alto{
            background-color: green;
            color: white;
        }
        
        .tblfooter{
            background-color: gray;
            color: white;
        }
        
        .big{
            width: 20%;
        }
        
        .mid{
            width: 15%;
        }
        
        .small{
            width: 8%;
        }
        
        .tblheadValue{
            background-color: gray;
            text-align: center;
            color: white;
        }
    </style>
    
    <style>
        .table-sortable th {
          cursor: pointer;
        }
        
        .table-sortable .th-sort-asc::after {
          content: "\25b4";
        }
        
        .table-sortable .th-sort-desc::after {
          content: "\25be";
        }
        
        .table-sortable .th-sort-asc::after,
        .table-sortable .th-sort-desc::after {
          margin-left: 5px;
        }
        
        .table-sortable .th-sort-asc,
        .table-sortable .th-sort-desc {
          background: #A62828;
        }
        
        .sizetr{
            height:3vw!important;
        }

    </style>
</head>
<body class="skin-red sidebar-mini sidebar-collapse">
    <div id="divLoading" class="ocultar">
        <div class="spinner">
            <div class="bounce1"></div>
            <div class="bounce2"></div>
            <div class="bounce3"></div>
        </div>
    </div>
    <div class="wrapper">
        <!-- Header -->
        <?php include 'admin/header.php'; ?>
        <!-- Left side column. contains the logo and sidebar -->
        <?php
            $inicio = "active";
            $dashboardvisitas= "active";
            include 'admin/main-sidebar.php';
        ?>
        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <div style="font-size:180%;"> DASHBOARD&nbsp <span style="font-size:80%;color:#DAD8D4"> | &nbsp <span style="font-size:80%;color:#8D8A80">LEADS</span></span> </div>              
                <ol class="breadcrumb">
                    <li><a class="text-left"><font color="red">Día: <?php echo $dias."/".$mes."/".$ano;?></font></a></li>
                </ol>
            </section>
            <!-- Main content -->
            <section class="content">
                <div class="box box-danger" >
                    <div class="box-header"> 
                        <i class="fa fa-bar-chart-o"></i> 
                        <h3 class="box-title">Fecha Cotizacion - 
                            <input type="text" style="font-size:100%;color:#444; background-color: #fff;border: 0; font-weight: bold;" id="fechaCotizacion" name="fechaCotizacion" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask="" value="<?php echo $fechadiahoy; ?>">
                        </h3>
                        <div class="box-tools pull-right">
                            <!--<a class="btn btn-nuevo btn-sm"  href="#" style="border-radius: 0px;" onclick="javascript:window.location.reload();" title="Actualizar"><i class="fa fa-refresh"></i></a> -->
                            <button class="btn btn-success btn-sm" name="btnExportarDashboardLeads" id="btnExportarDashboardLeads" title="Exportar">Exportar Excel</button>
                        </div>
                    </div>
                    
                    <div class="box-body">
                        <div class="ocultar" style="height: 700px; overflow: auto" id="divTable">
                            <table class="table table-hover table-striped" id="generalLeadsDIA">
                                <thead>
                                        
                                </thead>
                                <tbody>
                                    
                                </tbody>
                            </table>
                        </div>
                        
                    </div>
                    
                </div>
                
            </section>
            <?php include 'modalpassword.php';?>
            
        </div>
    </div>
    <!-- jQuery 3 -->
    <script src="admin/bower_components/jquery/dist/jquery.min.js"></script>
    <!-- jQuery UI 1.11.4 -->
    <script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
    <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>
    <!-- Bootstrap 3.3.7 -->
    <script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
    <!-- SELECT 2 -->
    <script src="admin/bower_components/select2/dist/js/select2.full.min.js"></script>
    <!-- date-range-picker -->
    <script src="admin/bower_components/moment/min/moment.min.js"></script>
    <script src="admin/bower_components/bootstrap-daterangepicker/daterangepicker.js"></script>
    <!-- datepicker -->
    <script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
    <script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>

    <!-- Bootstrap WYSIHTML5 -->
    <script src="admin/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js"></script>
    <!-- Slimscroll -->
    <script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
    <!-- FastClick -->
    <script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
    <!-- AdminLTE App -->
    <script src="admin/dist/js/adminlte.min.js"></script>
    <!-- SWEET ALERT -->
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!-- CHARTS -->
    <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
    
    <script src="admin/bower_components/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="admin/bower_components/datatables.net-bs/js/dataTables.bootstrap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/gh/linways/table-to-excel@v1.0.4/dist/tableToExcel.js"></script>
    <script>
        $(document).ready(function () {
            $("#btnExportarDashboardLeads").click(function () {
                let table = document.getElementsByTagName("table");
                TableToExcel.convert(table[0], {
                    name: `DashboardLeads.xlsx`,
                    sheet: {
                        name: 'DashboardLeads'
                    }
                });
            });
        });
    </script>
    
    <!-- INICIALIZADORES -->
    <script>
        var fechaCotizacion = moment($('#fechaCotizacion').val(), "DD/MM/YYYY").format("YYYY-MM-DD");
        var fechaFin = moment($('#fechaCotizacion').val(), "DD/MM/YYYY").format("YYYY-MM-DD");
        
        $(function() {
            $('#fechaCotizacion').daterangepicker({
                autoclose: true,
                language: 'es',
                firstDay: 1,
                "locale": {
                    "format": "DD-MM-YYYY",
                    "separator": " - ",
                    "applyLabel": "Filtrar",
                    "cancelLabel": "Cancelar",
                    "fromLabel": "Desde",
                    "toLabel": "Hasta",
                    "customRangeLabel": "Custom",
                    "daysOfWeek": [
                        "Dom",
                        "Lun",
                        "Mar",
                        "Mie",
                        "Jue",
                        "Vie",
                        "Sab"
                    ],
                    "monthNames": [
                        "Enero",
                        "Febrero",
                        "Marzo",
                        "Abril",
                        "Mayo",
                        "Junio",
                        "Julio",
                        "Agosto",
                        "Septiembre",
                        "Octubre",
                        "Noviembre",
                        "Diciembre"
                    ],
                    "firstDay": 1
                }
            }, function(start, end, label) {
                fechaCotizacion = start.format('YYYY-MM-DD');
                fechaFin = end.format('YYYY-MM-DD');
                //console.log("A new date selection was made: " + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD'));
                Swal.fire({
                    html: 'Obteniendo información...',
                    heightAuto: true,
                    showConfirmButton: false
                });
                generarTablaDiaHead();
                generarTablaDiaBody();
            });
        });
        
    </script>
    <!-- EVENTOS -->
    <script>
        $('#fechaCotizacion').on('change', function(){
            generarTablaDiaHead();
            //generarTablaDiaBody();
        })
    </script>
    <!-- document ready -->
    <script>
        $(document).ready(() => {
            $('#divLoading').removeClass('ocultar');
            $('#divLoading').addClass('block');
            //GENERAR TABLA DEL DIA
            generarTablaDiaHead();
            generarTablaDiaBody();
            
            setTimeout(function(){
                $('#divLoading').addClass('ocultar');
                $('#divLoading').removeClass('block');
                
                $('#divTable').removeClass('ocultar');
            }, 4200);

        })
    </script>
    <!-- Funciones -->
    <script>
        function generarTablaDiaHead(){
            const contenedorLeadsDiaHead = document.querySelector('#generalLeadsDIA thead');
            limpiarHTML(contenedorLeadsDiaHead);
            //CABECERA DE HORAS
            const row = document.createElement('tr');
            row.innerHTML += '<th style="position: sticky; top: 0; z-index: 1;"></th>';
            
            for (var i = 0; i < 24; i++) {
               if(i >= 0 && i<10){
                   row.innerHTML += `<th class="tblSubHeader text-center" style="position: sticky; top: 0; z-index: 1;">0${i}</th>`;
               } else {
                   row.innerHTML += `<th class="tblSubHeader text-center" style="position: sticky; top: 0; z-index: 1;">${i}</th>`;
               }
            }
            
            row.innerHTML += '<th class="tblSubHeader text-center" style="position: sticky; top: 0; z-index: 1;">TOTAL</th><th class="tblSubHeader text-center" style="position: sticky; top: 0; z-index: 1;">%</th><th class="tblSubHeader text-center" style="position: sticky; top: 0; z-index: 1;">Vueltas</th>';
            contenedorLeadsDiaHead.appendChild(row);

        }
        
        function generarTablaDiaBody(){
            const contenedorLeadsDiaHead = document.querySelector('#generalLeadsDIA tbody');
            limpiarHTML(contenedorLeadsDiaHead);
            
            //LEADS
            const row = document.createElement('tr');
            row.innerHTML += '<th class="tblSubHeader">LEADS</th>';
            
            const rowInternet = document.createElement('tr');
            const rowInbound = document.createElement('tr');
            const rowCorreo = document.createElement('tr');
            rowInternet.innerHTML += '<th class="tblSubHeader">Internet</th>';
            rowInbound.innerHTML += '<th class="tblSubHeader">Inbound</th>';
            rowCorreo.innerHTML += '<th class="tblSubHeader">Correo</th>';
            
            const rowEspacio4 = document.createElement('tr');
            rowEspacio4.innerHTML += '<th class=""></th>';
            
            //LEAD TO BOAKING
            const rowLTB = document.createElement('tr');
            rowLTB.innerHTML += '<th class="tblSubHeader">%LTB</th>';
            const rowLTB_Internet= document.createElement('tr');
            rowLTB_Internet.innerHTML += '<th class="tblSubHeader">%LTB Internet</th>';
            const rowLTB_Inbound= document.createElement('tr');
            rowLTB_Inbound.innerHTML += '<th class="tblSubHeader">%LTB Inbound</th>';
            const rowLTB_Correo= document.createElement('tr');
            rowLTB_Correo.innerHTML += '<th class="tblSubHeader">%LTB Correo</th>';
            
            const rowEspacio5 = document.createElement('tr');
            rowEspacio5.innerHTML += '<th class=""></th>';
            
            const rowVisitasExpress = document.createElement('tr');
            const rowVisitasTotales = document.createElement('tr');
            rowVisitasExpress.innerHTML += '<th class="tblSubHeader">Visitas Express</th>';
            rowVisitasTotales.innerHTML += '<th class="tblSubHeader">Visitas Totales</th>';
            
            const rowVisitasTotalesInternet = document.createElement('tr');
            rowVisitasTotalesInternet.innerHTML += '<th class="tblSubHeader">Internet</th>';
            
            const rowVisitasTotalesInternetPrimerIntento = document.createElement('tr');
            rowVisitasTotalesInternetPrimerIntento.innerHTML += '<th class="tblSubHeader">Primer intento</th>';
            const rowVisitasTotalesInternetRecovery = document.createElement('tr');
            rowVisitasTotalesInternetRecovery.innerHTML += '<th class="tblSubHeader">Recovery</th>';
            //INBOUND
            const rowVisitasTotalesInbound = document.createElement('tr');
            rowVisitasTotalesInbound.innerHTML += '<th class="tblSubHeader">Inbound</th>';
            
            const rowVisitasTotalesInboundPrimerIntento = document.createElement('tr');
            rowVisitasTotalesInboundPrimerIntento.innerHTML += '<th class="tblSubHeader">Primer intento</th>';
            const rowVisitasTotalesInboundRecovery = document.createElement('tr');
            rowVisitasTotalesInboundRecovery.innerHTML += '<th class="tblSubHeader">Recovery</th>';
            //CORREO
            const rowVisitasTotalesCorreo = document.createElement('tr');
            rowVisitasTotalesCorreo.innerHTML += '<th class="tblSubHeader">Correo</th>';
            
            const rowVisitasTotalesCorreoPrimerIntento = document.createElement('tr');
            rowVisitasTotalesCorreoPrimerIntento.innerHTML += '<th class="tblSubHeader">Primer intento</th>';
            const rowVisitasTotalesCorreoRecovery = document.createElement('tr');
            rowVisitasTotalesCorreoRecovery.innerHTML += '<th class="tblSubHeader">Recovery</th>';
            //VISITAS RELACIONADAS
            const rowVisitasRelacionadas = document.createElement('tr');
            rowVisitasRelacionadas.innerHTML += '<th class="tblSubHeader">Visitas Relacionadas</th>';
            
            //row en blanco
            const rowEspacio = document.createElement('tr');
            rowEspacio.innerHTML += '<th class=""></th>';
            
            const rowPorcNoContacto = document.createElement('tr');
            rowPorcNoContacto.innerHTML += '<th class="tblSubHeader">% No Contacto</th>';
            const rowPorcNoGestionable = document.createElement('tr');
            rowPorcNoGestionable.innerHTML += '<th class="tblSubHeader">% No Gestionable</th>';
            const rowPorcGestionable = document.createElement('tr');
            rowPorcGestionable.innerHTML += '<th class="tblSubHeader">% Gestionable</th>';
            
            //row en blanco
            const rowEspacio2 = document.createElement('tr');
            rowEspacio2.innerHTML += '<th class=""></th>';
            
            const rowTrasnferenciasTV = document.createElement('tr');
            rowTrasnferenciasTV.innerHTML += '<th class="">Trasnferencias a TV</th>';
            const rowVueltasNoContacto = document.createElement('tr');
            rowVueltasNoContacto.innerHTML += '<th class="">Vueltas No Contacto</th>';
            
            const rowNoContacto = document.createElement('tr');
            rowNoContacto.innerHTML += '<th class="tblSubHeader">No Contacto</th>';
            
            //APAGADO
            const rowNoContactoApagado = document.createElement('tr');
            rowNoContactoApagado.innerHTML += '<th class="">Apagado</th>';
            //contestaCorta
            const rowNoContactoContestaCorta = document.createElement('tr');
            rowNoContactoContestaCorta.innerHTML += '<th class="">ContestaCorta</th>';
            //NOCONTACTO
            const rowNoContactoNoContacto = document.createElement('tr');
            rowNoContactoNoContacto.innerHTML += '<th class="">NoContacto</th>';
            
            
            const rowNoGestionable = document.createElement('tr');
            rowNoGestionable.innerHTML += '<th class="tblSubHeader">No Gestionable</th>';
            //TIPIFICACIONES NO GESTIONABLE
            //APAGADO
            const rowNoGestionableTeleventa = document.createElement('tr');
            rowNoGestionableTeleventa.innerHTML += '<th class="">Televenta</th>';
            //clienteError
            const rowNoGestionableClienteError = document.createElement('tr');
            rowNoGestionableClienteError.innerHTML += '<th class="">ClienteError</th>';
            //Duplicado
            const rowNoGestionableDuplicado = document.createElement('tr');
            rowNoGestionableDuplicado.innerHTML += '<th class="">Duplicado</th>';
            //Inviable
            const rowNoGestionableInviable = document.createElement('tr');
            rowNoGestionableInviable.innerHTML += '<th class="">Inviable</th>';
            //PROV
            const rowNoGestionablePROV = document.createElement('tr');
            rowNoGestionablePROV.innerHTML += '<th class="">PROV</th>';
            //ZSCC
            const rowNoGestionableZSCC = document.createElement('tr');
            rowNoGestionableZSCC.innerHTML += '<th class="">ZSCC</th>';
            //TelefonoError
            const rowNoGestionableTelefonoError = document.createElement('tr');
            rowNoGestionableTelefonoError.innerHTML += '<th class="">TelefonoError</th>';
            //NoCotizo
            const rowNoGestionableNoCotizo = document.createElement('tr');
            rowNoGestionableNoCotizo.innerHTML += '<th class="">NoCotizo</th>';
            //ATC
            const rowNoGestionableATC = document.createElement('tr');
            rowNoGestionableATC.innerHTML += '<th class="">ATC</th>';
            //Otros
            const rowNoGestionableOtros = document.createElement('tr');
            rowNoGestionableOtros.innerHTML += '<th class="">Otros</th>';
            //Backoffice
            const rowNoGestionableBackoffice = document.createElement('tr');
            rowNoGestionableBackoffice.innerHTML += '<th class="">Backoffice</th>';
            
            //GESTIONABLE
            const rowGestionable = document.createElement('tr');
            rowGestionable.innerHTML += '<th class="tblSubHeader">Gestionable</th>';
            
            //GESTIONABLE
            const rowGestionableDevolverLlamada = document.createElement('tr');
            rowGestionableDevolverLlamada.innerHTML += '<th class="">DevolverLlamada</th>';
            //GESTIONABLE
            const rowGestionableNoAceptaVisita = document.createElement('tr');
            rowGestionableNoAceptaVisita.innerHTML += '<th class="">NoAceptaVisita</th>';
            //GESTIONABLE
            const rowGestionableVisitaAceptada = document.createElement('tr');
            rowGestionableVisitaAceptada.innerHTML += '<th class="">VisitaAceptada</th>';
            //GESTIONABLE -- VISITA RECONFIRMAR
            const rowGestionableVisitaReconfirmar = document.createElement('tr');
            rowGestionableVisitaReconfirmar.innerHTML += '<th class="">VisitaReconfirmar</th>';
            
            const rowEspacio3 = document.createElement('tr');
            rowEspacio3.innerHTML += '<th class=""></th>';
            //CANAL
            const rowCanal = document.createElement('tr');
            rowCanal.innerHTML += '<th class="tblSubHeader">Canal</th>';
            
            const rowCanalFacebook = document.createElement('tr');
            rowCanalFacebook.innerHTML += '<th class="">Facebook</th>';
            const rowCanalFacebook_LN = document.createElement('tr');
            rowCanalFacebook_LN.innerHTML += '<th class="">FacebookLN</th>';
            const rowCanalAfiliados = document.createElement('tr');
            rowCanalAfiliados.innerHTML += '<th class="">Afiliados</th>';
            const rowCanalDisplay = document.createElement('tr');
            rowCanalDisplay.innerHTML += '<th class="">Display</th>';
            const rowCanalEmail = document.createElement('tr');
            rowCanalEmail.innerHTML += '<th class="">Email</th>';
            const rowCanalGDN = document.createElement('tr');
            rowCanalGDN.innerHTML += '<th class="">GDN</th>';
            const rowCanalSEMMARCA = document.createElement('tr');
            rowCanalSEMMARCA.innerHTML += '<th class="">SEM MARCA</th>';
            const rowCanalSEMGENERICO = document.createElement('tr');
            rowCanalSEMGENERICO.innerHTML += '<th class="">SEM GENERICO</th>';
            const rowCanalSEO = document.createElement('tr');
            rowCanalSEO.innerHTML += '<th class="">SEO</th>';
            const rowCanalINBOUND = document.createElement('tr');
            rowCanalINBOUND.innerHTML += '<th class="">INBOUND</th>';
            const rowCanalTiktok = document.createElement('tr');
            rowCanalTiktok.innerHTML += '<th class="">Tiktok</th>';
            
            
            $.ajax({
                type: 'Post',
                url: 'ajax/dataDashboardLeadDia.php',
                data: {
                    fechaCotizacion: fechaCotizacion,
                    fechaFin: fechaFin
                },
                dataType: 'json',
                success: function(data){
                    //console.log(data);
                    Swal.close();                    
                    let arreglo = data.Leads;
                    let totalDia = 0;
                    
                    let arregloInternet = data.LeadsInternet;
                    let totalDiaInternet = 0;
                    
                    let arregloInbound = data.LeadsInbound;
                    let totalDiaInbound = 0;
                    
                    let arregloCorreo = data.LeadsCorreo;
                    let totalDiaCorreo = 0;
                    
                    let arregloVA = data.LeadsVisitaAceptada;
                    let totalDiaVA = 0;
                    
                    let arregloVAInternet = data.LeadsVisitaAceptadaInternet;
                    let totalDiaVAInternet = 0;
                    
                    let arregloVAInternetPrimerIntento = data.LeadsVisitaAceptadaInternetPrimerIntento;
                    let totalDiaVAInternetPrimerIntento = 0;
                    
                    let arregloVAInternetRecovery = data.LeadsVisitaAceptadaInternetRecovery;
                    let totalDiaVAInternetRecovery = 0;
                    
                    //INBOUND VA
                    let arregloVAInbound = data.LeadsVisitaAceptadaInbound;
                    let totalDiaVAInbound = 0;
                    
                    let arregloVAInboundPrimerIntento = data.LeadsVisitaAceptadaInboundPrimerIntento;
                    let totalDiaVAInboundPrimerIntento = 0;
                    
                    let arregloVAInboundRecovery = data.LeadsVisitaAceptadaInboundRecovery;
                    let totalDiaVAInboundRecovery = 0;
                    
                    //Correo VA
                    let arregloVACorreo = data.LeadsVisitaAceptadaCorreo;
                    let totalDiaVACorreo = 0;
                    
                    let arregloVACorreoPrimerIntento = data.LeadsVisitaAceptadaCorreoPrimerIntento;
                    let totalDiaVACorreoPrimerIntento = 0;
                    
                    let arregloVACorreoRecovery = data.LeadsVisitaAceptadaCorreoRecovery;
                    let totalDiaVACorreoRecovery = 0;
                    
                    let arregloVR = data.LeadsVisitaRelacionada;
                    let totalDiaVR = 0;
                    
                    
                    //TRANSFERENCIA A TELEVENTA
                    let arregloTransferenciaTeleventa = data.LeadsTrasnferenciaTeleventa;
                    let totalDiaTransferenciaTeleventa = 0;
                    let contadorPromediosHora = 0;
                    
                    //VUELTAS NO CONTACTO
                    let arregloVueltasNoContacto = data.LeadsVueltasNoContacto;
                    let promedioDiaVueltasNoContacto = 0;
                    
                    //NO CONTACTO
                    let arregloNoContacto = data.LeadsNoContacto;
                    let totalDiaNC = 0;
                    
                    let arregloNCApagado = data.LeadsNoContactoApagado;
                    let totalDiaNCApagado = 0;
                    let arregloNCContestaCorta = data.LeadsNoContactoContestaCorta;
                    let totalDiaNCContestaCorta = 0;
                    let arregloNCNoContacto = data.LeadsNoContactoNoContacto;
                    let totalDiaNCNoContacto = 0;
 
                    let arregloNoGestionable = data.LeadsNoGestionable;
                    let totalDiaNG = 0;
                    
                    let arregloNoGestionableTeleventa = data.LeadsNoGestionableTeleventa;
                    let totalDiaNGTeleventa = 0;
                    let arregloNoGestionableClienteError = data.LeadsNoGestionableClienteError;
                    let totalDiaNGClienteError = 0;
                    let arregloNoGestionableDuplicado = data.LeadsNoGestionableDuplicado;
                    let totalDiaNGDuplicado = 0;
                    let arregloNoGestionableInviable = data.LeadsNoGestionableInviable;
                    let totalDiaNGInviable = 0;
                    let arregloNoGestionablePROV = data.LeadsNoGestionablePROV;
                    let totalDiaNGPROV = 0;
                    let arregloNoGestionableZSCC = data.LeadsNoGestionableZSCC;
                    let totalDiaNGZSCC = 0;
                    let arregloNoGestionableTelefonoError = data.LeadsNoGestionableTelefonoError;
                    let totalDiaNGTelefonoError = 0;
                    let arregloNoGestionableNoCotizo = data.LeadsNoGestionableNoCotizo;
                    let totalDiaNGNoCotizo = 0;
                    let arregloNoGestionableATC = data.LeadsNoGestionableATC;
                    let totalDiaNGATC = 0;
                    let arregloNoGestionableOtros = data.LeadsNoGestionableOtros;
                    let totalDiaNGOtros = 0;
                    let arregloNoGestionableBackoffice = data.LeadsNoGestionableBackoffice;
                    let totalDiaNGBackoffice = 0;
                 
                    let arregloGestionable = data.LeadsGestionable;
                    let totalDiaGestionable = 0;
                    let arregloGestionableDevolverLlamada = data.LeadsGestionableDevolverLlamada;
                    let totalDiaGestionableDevolverLlamada = 0;
                    let arregloGestionableNoAceptaVisita = data.LeadsGestionableNoAceptaVisita;
                    let totalDiaGestionableNoAceptaVisita = 0;
                    let arregloGestionableVisitaAceptada = data.LeadsGestionableVisitaAceptada;
                    let totalDiaGestionableVisitaAceptada = 0;
                    let arregloGestionableVisitaReconfirmar = data.LeadsGestionableVisitaReconfirmar;
                    let totalDiaGestionableVisitaReconfirmar = 0;
                    
                    let arregloCanal = data.LeadsCanal;
                    let totalDiaCanal = 0;
                    let arregloCanalFacebook = data.LeadsCanalFacebook;
                    let totalDiaCanalFacebook = 0;
                    let arregloCanalFacebook_LN = data.LeadsCanalFacebook_LN;
                    let totalDiaCanalFacebook_LN = 0;
                    let arregloCanalAfiliados = data.LeadsCanalAfiliados;
                    let totalDiaCanalAfiliados = 0;
                    let arregloCanalDisplay = data.LeadsCanalDisplay;
                    let totalDiaCanalDisplay = 0;
                    let arregloCanalEmail = data.LeadsCanalEmail;
                    let totalDiaCanalEmail = 0;
                    let arregloCanalGDN = data.LeadsCanalGDN;
                    let totalDiaCanalGDN = 0;
                    let arregloCanalSEMMARCA = data.LeadsCanalSEMMARCA;
                    let totalDiaCanalSEMMARCA = 0;
                    let arregloCanalSEMGENERICO = data.LeadsCanalSEMGENERICO;
                    let totalDiaCanalSEMGENERICO = 0;
                    let arregloCanalSEO = data.LeadsCanalSEO;
                    let totalDiaCanalSEO = 0;
                    let arregloCanalINBOUND = data.LeadsCanalINBOUND;
                    let totalDiaCanalINBOUND = 0;
                    let arregloCanalTiktok = data.LeadsCanalTiktok;
                    let totalDiaCanalTiktok = 0;        
                    
                    //console.log(data.LeadsCanalTiktok);

                    for (var i = 0; i < 24; i++) {
                        let resultado = arreglo.find( elemento => elemento.hora == i);
                        
                        if(resultado){
                            row.innerHTML += `<th class="tblheadValue">${resultado.Total}</th>`;
                            
                            totalDia += parseInt(resultado.Total);
                            
                        } else {
                            
                            row.innerHTML += `<th class="tblheadValue">0</th>`;
                        }

                        
                        let resultadoInternet = arregloInternet.find( elemento => elemento.hora == i);
                        
                        if(resultadoInternet){
                            rowInternet.innerHTML += `<th>${resultadoInternet.Total}</th>`;
                            
                            totalDiaInternet += parseInt(resultadoInternet.Total);
                            
                        } else {
                            rowInternet.innerHTML += `<th>0</th>`;
                        }
                        
                        let resultadoInbound = arregloInbound.find( elemento => elemento.hora == i);
                        
                        if(resultadoInbound){
                            rowInbound.innerHTML += `<th>${resultadoInbound.Total}</th>`;
                            
                            totalDiaInbound += parseInt(resultadoInbound.Total);
                            
                        } else {
                            rowInbound.innerHTML += `<th>0</th>`;
                        }
                        //FILA CORREO
                        let resultadoCorreo = arregloCorreo.find(elemento => elemento.hora == i);
                        
                        if(resultadoCorreo){
                            rowCorreo.innerHTML += `<th>${resultadoCorreo.Total}</th>`;
                            
                            totalDiaCorreo += parseInt(resultadoCorreo.Total);
                            
                        } else {
                            rowCorreo.innerHTML += `<th>0</th>`;
                        }
                        
                        
                        //FILA VISITA ACEPTADA
                        let resultadoVA = arregloVA.find(elemento => elemento.hora == i);
                        
                        if(resultadoVA){
                            rowVisitasTotales.innerHTML += `<th class="tblheadValue">${resultadoVA.Total}</th>`;
                            
                            totalDiaVA += parseInt(resultadoVA.Total);
                            
                        } else {
                            rowVisitasTotales.innerHTML += `<th class="tblheadValue">0</th>`;
                        }
                        
                        
                        //FILA VISITA ACEPTADA INTERNET
                        
                        let resultadoVAInternet = arregloVAInternet.find(elemento => elemento.hora == i);
                        
                        if(resultadoVAInternet){
                            rowVisitasTotalesInternet.innerHTML += `<td class="tblBody text-center">${resultadoVAInternet.Total}</td>`;
                            
                            totalDiaVAInternet += parseInt(resultadoVAInternet.Total);
                            
                        } else {
                            rowVisitasTotalesInternet.innerHTML += `<th class="tblBody text-center">0</th>`;
                        }
                        
                        
                        //FILA VISITA ACEPTADA INTERNET PRIMER INTENTO
                        
                        let resultadoVAInternetPrimerIntento = arregloVAInternetPrimerIntento.find(elemento => elemento.hora == i);
                        
                        if(resultadoVAInternetPrimerIntento){
                            rowVisitasTotalesInternetPrimerIntento.innerHTML += `<td class="text-center">${resultadoVAInternetPrimerIntento.Total}</td>`;
                            
                            totalDiaVAInternetPrimerIntento += parseInt(resultadoVAInternetPrimerIntento.Total);
                            
                        } else {
                            rowVisitasTotalesInternetPrimerIntento.innerHTML += `<th class="text-center">0</th>`;
                        }

                        //FILA VISITA ACEPTADA INTERNET RECOVERY
                        
                        let resultadoVAInternetRecovery = arregloVAInternetRecovery.find(elemento => elemento.hora == i);
                        
                        if(resultadoVAInternetRecovery){
                            rowVisitasTotalesInternetRecovery.innerHTML += `<td class="text-center">${resultadoVAInternetRecovery.Total}</td>`;
                            
                            totalDiaVAInternetRecovery += parseInt(resultadoVAInternetRecovery.Total);
                            
                        } else {
                            rowVisitasTotalesInternetRecovery.innerHTML += `<th class="text-center">0</th>`;
                        }
                        
                        //FILA VISITA ACEPTADA Inbound
                        
                        let resultadoVAInbound = arregloVAInbound.find(elemento => elemento.hora == i);
                        
                        if(resultadoVAInbound){
                            rowVisitasTotalesInbound.innerHTML += `<td class="tblBody text-center">${resultadoVAInbound.Total}</td>`;
                            
                            totalDiaVAInbound += parseInt(resultadoVAInbound.Total);
                            
                        } else {
                            rowVisitasTotalesInbound.innerHTML += `<th class="tblBody text-center">0</th>`;
                        }
                        
                        //FILA VISITA ACEPTADA Inbound PRIMER INTENTO
                        
                        let resultadoVAInboundPrimerIntento = arregloVAInboundPrimerIntento.find(elemento => elemento.hora == i);
                        
                        if(resultadoVAInboundPrimerIntento){
                            rowVisitasTotalesInboundPrimerIntento.innerHTML += `<td class="text-center">${resultadoVAInboundPrimerIntento.Total}</td>`;
                            
                            totalDiaVAInboundPrimerIntento += parseInt(resultadoVAInboundPrimerIntento.Total);
                            
                        } else {
                            rowVisitasTotalesInboundPrimerIntento.innerHTML += `<th class="text-center">0</th>`;
                        }
                        
                        //FILA VISITA ACEPTADA Inbound RECOVERY
                        
                        let resultadoVAInboundRecovery = arregloVAInboundRecovery.find(elemento => elemento.hora == i);
                        
                        if(resultadoVAInboundRecovery){
                            rowVisitasTotalesInboundRecovery.innerHTML += `<td class="text-center">${resultadoVAInboundRecovery.Total}</td>`;
                            
                            totalDiaVAInboundRecovery += parseInt(resultadoVAInboundRecovery.Total);
                            
                        } else {
                            rowVisitasTotalesInboundRecovery.innerHTML += `<th class="text-center">0</th>`;
                        }
                        
                        //FILA VISITA ACEPTADA Correo
                        
                        let resultadoVACorreo = arregloVACorreo.find(elemento => elemento.hora == i);
                        
                        if(resultadoVACorreo){
                            rowVisitasTotalesCorreo.innerHTML += `<td class="tblBody text-center">${resultadoVACorreo.Total}</td>`;
                            
                            totalDiaVACorreo += parseInt(resultadoVACorreo.Total);
                            
                        } else {
                            rowVisitasTotalesCorreo.innerHTML += `<th class="tblBody text-center">0</th>`;
                        }
                        
                        //FILA VISITA ACEPTADA Correo PRIMER INTENTO
                        
                        let resultadoVACorreoPrimerIntento = arregloVACorreoPrimerIntento.find(elemento => elemento.hora == i);
                        
                        if(resultadoVACorreoPrimerIntento){
                            rowVisitasTotalesCorreoPrimerIntento.innerHTML += `<td class="text-center">${resultadoVACorreoPrimerIntento.Total}</td>`;
                            
                            totalDiaVACorreoPrimerIntento += parseInt(resultadoVACorreoPrimerIntento.Total);
                            
                        } else {
                            rowVisitasTotalesCorreoPrimerIntento.innerHTML += `<th class="text-center">0</th>`;
                        }
                        
                        //FILA VISITA ACEPTADA Correo RECOVERY
                        let resultadoVACorreoRecovery = arregloVACorreoRecovery.find(elemento => elemento.hora == i);
                        
                        if(resultadoVACorreoRecovery){
                            rowVisitasTotalesCorreoRecovery.innerHTML += `<td class="text-center">${resultadoVACorreoRecovery.Total}</td>`;
                            
                            totalDiaVACorreoRecovery += parseInt(resultadoVACorreoRecovery.Total);
                            
                        } else {
                            rowVisitasTotalesCorreoRecovery.innerHTML += `<th class="text-center">0</th>`;
                        }
                        
                        //FILA VISITA ACEPTADA Correo RECOVERY
                        let resultadoVR = arregloVR.find(elemento => elemento.hora == i);
                        
                        if(resultadoVR){
                            rowVisitasRelacionadas.innerHTML += `<td class="tblBody text-center">${resultadoVR.Total}</td>`;
                            
                            totalDiaVR += parseInt(resultadoVR.Total);
                            
                        } else {
                            rowVisitasRelacionadas.innerHTML += `<th class="tblBody text-center">0</th>`;
                        }
                        
                        

                        
                        //FILA TRANSFERENCIA A TELEVENTA
                        let resultadoTrasnferenciaTeleventa = arregloTransferenciaTeleventa.find(elemento => elemento.hora == i);
                        
                        if(resultadoTrasnferenciaTeleventa){
                            rowTrasnferenciasTV.innerHTML += `<td class="text-center">${resultadoTrasnferenciaTeleventa.Total}</td>`;
                            
                            totalDiaTransferenciaTeleventa += parseInt(resultadoTrasnferenciaTeleventa.Total);
                            
                        } else {
                            rowTrasnferenciasTV.innerHTML += `<th class="text-center">0</th>`;
                        }
                        
                        //FILA VUELTAS NO CONTACTO
                        let resultadoVueltasNoContacto = arregloVueltasNoContacto.find(elemento => elemento.hora == i);
                        
                        
                        if(resultadoVueltasNoContacto){
                            let promedioVuelta = parseFloat(resultadoVueltasNoContacto.Promedio).toFixed(1);
                            rowVueltasNoContacto.innerHTML += `<td class="text-center">${promedioVuelta}</td>`;
                            
                            promedioDiaVueltasNoContacto += parseFloat(resultadoVueltasNoContacto.Promedio);
                            contadorPromediosHora++;
                            
                        } else {
                            rowVueltasNoContacto.innerHTML += `<th class="text-center">0</th>`;
                        }
                        
                        //FILA PORCENTAJe NO CONTACTO, GESTIONABLE, NO GESTIONABLE
                        
                        let resultadoNoContacto = arregloNoContacto.find(elemento => elemento.hora == i);
                        
                        if(resultadoNoContacto){
                            rowPorcNoContacto.innerHTML += `<td class="text-center">${parseFloat((resultadoNoContacto.Total/resultado.Total)*100).toFixed(0)}%</td>`;
                            
                        } else {
                            rowPorcNoContacto.innerHTML += `<th class="text-center">0 %</th>`;
                        }
                        
                        //
                        
                        let resultadoNoGestionable = arregloNoGestionable.find(elemento => elemento.hora == i);
                        
                        if(resultadoNoGestionable){
                            rowPorcNoGestionable.innerHTML += `<td class="text-center">${parseFloat((resultadoNoGestionable.Total/resultado.Total)*100).toFixed(0)}%</td>`;
                            
                        } else {
                            rowPorcNoGestionable.innerHTML += `<th class="text-center">0 %</th>`;
                        }
                        
                        let resultadoGestionable = arregloGestionable.find(elemento => elemento.hora == i);
                        
                        if(resultadoGestionable){
                            rowPorcGestionable.innerHTML += `<td class="text-center">${parseFloat((resultadoGestionable.Total/resultado.Total)*100).toFixed(0)}%</td>`;
                            
                        } else {
                            rowPorcGestionable.innerHTML += `<th class="text-center">0 %</th>`;
                        }
                        
                        //RESULTADOS 
                        
                        if(resultadoNoContacto){
                            rowNoContacto.innerHTML += `<td class="tblBody text-center">${resultadoNoContacto.Total}</td>`;
                            totalDiaNC += parseInt(resultadoNoContacto.Total);
                            
                        } else {
                            rowNoContacto.innerHTML += `<th class="tblBody  text-center">0 </th>`;
                        }
                        
                        //APAGADO
                        let resultadoNCApagado = arregloNCApagado.find(elemento => elemento.hora == i);
                        
                        if(resultadoNCApagado){
                            rowNoContactoApagado.innerHTML += `<td class="text-center">${resultadoNCApagado.Total}</td>`;
                            totalDiaNCApagado += parseInt(resultadoNCApagado.Total);
                            
                        } else {
                            rowNoContactoApagado.innerHTML += `<th class="text-center">0</th>`;
                        }
                        
                        //ContestaCorta
                        let resultadoNCContestaCorta = arregloNCContestaCorta.find(elemento => elemento.hora == i);
                        
                        if(resultadoNCContestaCorta){
                            rowNoContactoContestaCorta.innerHTML += `<td class="text-center">${resultadoNCContestaCorta.Total}</td>`;
                            totalDiaNCContestaCorta += parseInt(resultadoNCContestaCorta.Total);
                            
                        } else {
                            rowNoContactoContestaCorta.innerHTML += `<th class="text-center">0</th>`;
                        }
                        
                        //NoContacto
                        let resultadoNCNoContacto = arregloNCNoContacto.find(elemento => elemento.hora == i);
                        
                        if(resultadoNCNoContacto){
                            rowNoContactoNoContacto.innerHTML += `<td class="text-center">${resultadoNCNoContacto.Total}</td>`;
                            totalDiaNCNoContacto += parseInt(resultadoNCNoContacto.Total);
                            
                        } else {
                            rowNoContactoNoContacto.innerHTML += `<th class="text-center">0</th>`;
                        }
                        
                        //NO GESTIONABLE
                        if(resultadoNoGestionable){
                            rowNoGestionable.innerHTML += `<td class="text-center tblBody ">${resultadoNoGestionable.Total}</td>`;
                            totalDiaNG += parseInt(resultadoNoGestionable.Total);
                            
                        } else {
                            rowNoGestionable.innerHTML += `<th class="text-center tblBody ">0 </th>`;
                        }
                        
                        let resultadoNGTeleventa = arregloNoGestionableTeleventa.find(elemento => elemento.hora == i);
                        if(resultadoNGTeleventa){
                            rowNoGestionableTeleventa.innerHTML += `<td class="text-center">${resultadoNGTeleventa.Total}</td>`;
                            totalDiaNGTeleventa += parseInt(resultadoNGTeleventa.Total);
                            
                        } else {
                            rowNoGestionableTeleventa.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        let resultadoNGClienteError = arregloNoGestionableClienteError.find(elemento => elemento.hora == i);
                        if(resultadoNGClienteError){
                            rowNoGestionableClienteError.innerHTML += `<td class="text-center">${resultadoNGClienteError.Total}</td>`;
                            totalDiaNGClienteError += parseInt(resultadoNGClienteError.Total);
                            
                        } else {
                            rowNoGestionableClienteError.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        let resultadoNGDuplicado = arregloNoGestionableDuplicado.find(elemento => elemento.hora == i);
                        if(resultadoNGDuplicado){
                            rowNoGestionableDuplicado.innerHTML += `<td class="text-center">${resultadoNGDuplicado.Total}</td>`;
                            totalDiaNGDuplicado += parseInt(resultadoNGDuplicado.Total);
                            
                        } else {
                            rowNoGestionableDuplicado.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        let resultadoNGInviable = arregloNoGestionableInviable.find(elemento => elemento.hora == i);
                        if(resultadoNGInviable){
                            rowNoGestionableInviable.innerHTML += `<td class="text-center">${resultadoNGInviable.Total}</td>`;
                            totalDiaNGInviable += parseInt(resultadoNGInviable.Total);
                            
                        } else {
                            rowNoGestionableInviable.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        let resultadoNGPROV = arregloNoGestionablePROV.find(elemento => elemento.hora == i);
                        if(resultadoNGPROV){
                            rowNoGestionablePROV.innerHTML += `<td class="text-center">${resultadoNGPROV.Total}</td>`;
                            totalDiaNGPROV += parseInt(resultadoNGPROV.Total);
                            
                        } else {
                            rowNoGestionablePROV.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        let resultadoNGZSCC = arregloNoGestionableZSCC.find(elemento => elemento.hora == i);
                        if(resultadoNGZSCC){
                            rowNoGestionableZSCC.innerHTML += `<td class="text-center">${resultadoNGZSCC.Total}</td>`;
                            totalDiaNGZSCC += parseInt(resultadoNGZSCC.Total);
                        } else {
                            rowNoGestionableZSCC.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        let resultadoNGTelefonoError = arregloNoGestionableTelefonoError.find(elemento => elemento.hora == i);
                        if(resultadoNGTelefonoError){
                            rowNoGestionableTelefonoError.innerHTML += `<td class="text-center">${resultadoNGTelefonoError.Total}</td>`;
                            totalDiaNGTelefonoError += parseInt(resultadoNGTelefonoError.Total);
                        } else {
                            rowNoGestionableTelefonoError.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        let resultadoNGNoCotizo = arregloNoGestionableNoCotizo.find(elemento => elemento.hora == i);
                        if(resultadoNGNoCotizo){
                            rowNoGestionableNoCotizo.innerHTML += `<td class="text-center">${resultadoNGNoCotizo.Total}</td>`;
                            totalDiaNGNoCotizo += parseInt(resultadoNGNoCotizo.Total);
                        } else {
                            rowNoGestionableNoCotizo.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        let resultadoNGATC = arregloNoGestionableATC.find(elemento => elemento.hora == i);
                        if(resultadoNGATC){
                            rowNoGestionableATC.innerHTML += `<td class="text-center">${resultadoNGATC.Total}</td>`;
                            totalDiaNGATC += parseInt(resultadoNGATC.Total);
                        } else {
                            rowNoGestionableATC.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        let resultadoNGOtros = arregloNoGestionableOtros.find(elemento => elemento.hora == i);
                        if(resultadoNGOtros){
                            rowNoGestionableOtros.innerHTML += `<td class="text-center">${resultadoNGOtros.Total}</td>`;
                            totalDiaNGOtros += parseInt(resultadoNGOtros.Total);
                        } else {
                            rowNoGestionableOtros.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        let resultadoNGBackoffice = arregloNoGestionableBackoffice.find(elemento => elemento.hora == i);
                        if(resultadoNGBackoffice){
                            rowNoGestionableBackoffice.innerHTML += `<td class="text-center">${resultadoNGBackoffice.Total}</td>`;
                            totalDiaNGBackoffice += parseInt(resultadoNGBackoffice.Total);
                        } else {
                            rowNoGestionableBackoffice.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        //GESTIONABLE
                        if(resultadoGestionable){
                            rowGestionable.innerHTML += `<td class="text-center tblBody ">${resultadoGestionable.Total}</td>`;
                            totalDiaGestionable += parseInt(resultadoGestionable.Total);
                        } else {
                            rowGestionable.innerHTML += `<th class="text-center tblBody ">0 </th>`;
                        }
                        
                        let resultadoGestionableDevolverLlamada = arregloGestionableDevolverLlamada.find(elemento => elemento.hora == i);
                        if(resultadoGestionableDevolverLlamada){
                            rowGestionableDevolverLlamada.innerHTML += `<td class="text-center">${resultadoGestionableDevolverLlamada.Total}</td>`;
                            totalDiaGestionableDevolverLlamada += parseInt(resultadoGestionableDevolverLlamada.Total);
                        } else {
                            rowGestionableDevolverLlamada.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        let resultadoGestionableNoAceptaVisita = arregloGestionableNoAceptaVisita.find(elemento => elemento.hora == i);
                        if(resultadoGestionableNoAceptaVisita){
                            rowGestionableNoAceptaVisita.innerHTML += `<td class="text-center">${resultadoGestionableNoAceptaVisita.Total}</td>`;
                            totalDiaGestionableNoAceptaVisita += parseInt(resultadoGestionableNoAceptaVisita.Total);
                        } else {
                            rowGestionableNoAceptaVisita.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        let resultadoGestionableVisitaAceptada = arregloGestionableVisitaAceptada.find(elemento => elemento.hora == i);
                        if(resultadoGestionableVisitaAceptada){
                            rowGestionableVisitaAceptada.innerHTML += `<td class="text-center">${resultadoGestionableVisitaAceptada.Total}</td>`;
                            totalDiaGestionableVisitaAceptada += parseInt(resultadoGestionableVisitaAceptada.Total);
                        } else {
                            rowGestionableVisitaAceptada.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        let resultadoGestionableVisitaReconfirmar = arregloGestionableVisitaReconfirmar.find(elemento => elemento.hora == i);
                        if(resultadoGestionableVisitaReconfirmar){
                            rowGestionableVisitaReconfirmar.innerHTML += `<td class="text-center">${resultadoGestionableVisitaReconfirmar.Total}</td>`;
                            totalDiaGestionableVisitaReconfirmar += parseInt(resultadoGestionableVisitaReconfirmar.Total);
                        } else {
                            rowGestionableVisitaReconfirmar.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        //CANAL
                        let resultadoCanal = arregloCanal.find(elemento => elemento.hora == i);
                        if(resultadoCanal){
                            rowCanal.innerHTML += `<td class="tblBody text-center">${resultadoCanal.Total}</td>`;
                            totalDiaCanal += parseInt(resultadoCanal.Total);
                        } else {
                            rowCanal.innerHTML += `<th class="tblBody text-center">0 </th>`;
                        }
                        
                        //CANAL
                        let resultadoCanalFacebook = arregloCanalFacebook.find(elemento => elemento.hora == i);
                        if(resultadoCanalFacebook){
                            rowCanalFacebook.innerHTML += `<td class="text-center">${resultadoCanalFacebook.Total}</td>`;
                            totalDiaCanalFacebook += parseInt(resultadoCanalFacebook.Total);
                        } else {
                            rowCanalFacebook.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        //CANAL
                        let resultadoCanalFacebook_LN= arregloCanalFacebook_LN.find(elemento => elemento.hora == i);
                        if(resultadoCanalFacebook_LN){
                            rowCanalFacebook_LN.innerHTML += `<td class="text-center">${resultadoCanalFacebook_LN.Total}</td>`;
                            totalDiaCanalFacebook_LN += parseInt(resultadoCanalFacebook_LN.Total);
                        } else {
                            rowCanalFacebook_LN.innerHTML += `<th class="text-center">0 </th>`;
                        }

                        let resultadoCanalAfiliados = arregloCanalAfiliados.find(elemento => elemento.hora == i);
                        if(resultadoCanalAfiliados){
                            rowCanalAfiliados.innerHTML += `<td class="text-center">${resultadoCanalAfiliados.Total}</td>`;
                            totalDiaCanalAfiliados += parseInt(resultadoCanalAfiliados.Total);
                        } else {
                            rowCanalAfiliados.innerHTML += `<th class="text-center">0 </th>`;
                        }

                        let resultadoCanalDisplay = arregloCanalDisplay.find(elemento => elemento.hora == i);
                        if(resultadoCanalDisplay){
                            rowCanalDisplay.innerHTML += `<td class="text-center">${resultadoCanalDisplay.Total}</td>`;
                            totalDiaCanalDisplay += parseInt(resultadoCanalDisplay.Total);
                        } else {
                            rowCanalDisplay.innerHTML += `<th class="text-center">0 </th>`;
                        }

                        let resultadoCanalEmail = arregloCanalEmail.find(elemento => elemento.hora == i);
                        if(resultadoCanalEmail){
                            rowCanalEmail.innerHTML += `<td class="text-center">${resultadoCanalEmail.Total}</td>`;
                            totalDiaCanalEmail += parseInt(resultadoCanalEmail.Total);
                        } else {
                            rowCanalEmail.innerHTML += `<th class="text-center">0 </th>`;
                        }

                        let resultadoCanalGDN = arregloCanalGDN.find(elemento => elemento.hora == i);
                        if(resultadoCanalGDN){
                            rowCanalGDN.innerHTML += `<td class="text-center">${resultadoCanalGDN.Total}</td>`;
                            totalDiaCanalGDN += parseInt(resultadoCanalGDN.Total);
                        } else {
                            rowCanalGDN.innerHTML += `<th class="text-center">0 </th>`;
                        }

                        let resultadoCanalSEMMARCA = arregloCanalSEMMARCA.find(elemento => elemento.hora == i);
                        if(resultadoCanalSEMMARCA){
                            rowCanalSEMMARCA.innerHTML += `<td class="text-center">${resultadoCanalSEMMARCA.Total}</td>`;
                            totalDiaCanalSEMMARCA += parseInt(resultadoCanalSEMMARCA.Total);
                        } else {
                            rowCanalSEMMARCA.innerHTML += `<th class="text-center">0 </th>`;
                        }

                        let resultadoCanalSEMGENERICO = arregloCanalSEMGENERICO.find(elemento => elemento.hora == i);
                        if(resultadoCanalSEMGENERICO){
                            rowCanalSEMGENERICO.innerHTML += `<td class="text-center">${resultadoCanalSEMGENERICO.Total}</td>`;
                            totalDiaCanalSEMGENERICO += parseInt(resultadoCanalSEMGENERICO.Total);
                        } else {
                            rowCanalSEMGENERICO.innerHTML += `<th class="text-center">0 </th>`;
                        }

                        let resultadoCanalSEO = arregloCanalSEO.find(elemento => elemento.hora == i);
                        if(resultadoCanalSEO){
                            rowCanalSEO.innerHTML += `<td class="text-center">${resultadoCanalSEO.Total}</td>`;
                            totalDiaCanalSEO += parseInt(resultadoCanalSEO.Total);
                        } else {
                            rowCanalSEO.innerHTML += `<th class="text-center">0 </th>`;
                        }

                        let resultadoCanalINBOUND = arregloCanalINBOUND.find(elemento => elemento.hora == i);
                        if(resultadoCanalINBOUND){
                            rowCanalINBOUND.innerHTML += `<td class="text-center">${resultadoCanalINBOUND.Total}</td>`;
                            totalDiaCanalINBOUND += parseInt(resultadoCanalINBOUND.Total);
                        } else {
                            rowCanalINBOUND.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        let resultadoCanalTiktok = arregloCanalTiktok.find(elemento => elemento.hora == i);
                        if(resultadoCanalTiktok){
                            rowCanalTiktok.innerHTML += `<td class="text-center">${resultadoCanalTiktok.Total}</td>`;
                            totalDiaCanalTiktok += parseInt(resultadoCanalTiktok.Total);
                        } else {
                            rowCanalTiktok.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        //LEAD TO BOAKING
                        //console.log(resultadoVA);
                        //console.log(resultado);
                        //console.log(resultadoInternet);
                        if(resultadoVA && resultado){
                            const porcLTB = parseFloat((resultadoVA.Total/resultado.Total)*100).toFixed(0);
                            
                            rowLTB.innerHTML += `<td class="text-center">${porcLTB}%</td>`;
                        } else{
                            rowLTB.innerHTML += `<td class="text-center">${0}</td>`;
                        }
                        
                        //LEAD TO BOAKING INTERNET
                        if(resultadoVAInternet && resultadoInternet){
                            const porcLTB = parseFloat((resultadoVAInternet.Total/resultadoInternet.Total)*100).toFixed(0);
                            
                            rowLTB_Internet.innerHTML += `<td class="text-center">${porcLTB}%</td>`;
                        } else{
                            rowLTB_Internet.innerHTML += `<td class="text-center">${0}</td>`;
                        }
                        
                        //LEAD TO BOAKING INBOUND
                        if(resultadoVAInbound && resultadoInbound){
                            const porcLTB = parseFloat((resultadoVAInbound.Total/resultadoInbound.Total)*100).toFixed(0);
                            
                            rowLTB_Inbound.innerHTML += `<td class="text-center">${porcLTB}%</td>`;
                        } else{

                            rowLTB_Inbound.innerHTML += `<td class="text-center">${0}</td>`;
                        }
                        
                        //LEAD TO BOAKING CORREO
                        if(resultadoVACorreo && resultadoCorreo){
                            const porcLTB = parseFloat((resultadoVACorreo.Total/resultadoCorreo.Total)*100).toFixed(0);
                            
                            rowLTB_Correo.innerHTML += `<td class="text-center">${porcLTB}%</td>`;
                        } else{
                            rowLTB_Correo.innerHTML += `<td class="text-center">${0}</td>`;
                        }
                        
                    }
                    
                    //AGREGAR TOTALES Y PORCENTAJES
                    row.innerHTML += `<th class="tblheadValue">${totalDia}</th>`;
                    
                    rowInternet.innerHTML += `<th>${totalDiaInternet}</th>`;
                    if(totalDia > 0){
                        rowInternet.innerHTML += `<th>${parseFloat((totalDiaInternet/totalDia)*100).toFixed(2)}</th>`;
                    } else {
                        rowInternet.innerHTML += `<th>0.00</th>`;
                    }
                    
                    rowInbound.innerHTML += `<th>${totalDiaInbound}</th>`;
                    if(totalDia > 0){
                        rowInbound.innerHTML += `<th>${parseFloat((totalDiaInbound/totalDia)*100).toFixed(2)}</th>`;
                    } else {
                        rowInbound.innerHTML += `<th>0.00</th>`;
                    }
                    rowCorreo.innerHTML += `<th>${totalDiaCorreo}</th>`;
                    if(totalDia > 0){
                        rowCorreo.innerHTML += `<th>${parseFloat((totalDiaCorreo/totalDia)*100).toFixed(2)}</th>`;
                    } else {
                        rowCorreo.innerHTML += `<th>0.00</th>`;
                    }
                    
                    rowVisitasTotales.innerHTML += `<th class="tblheadValue">${totalDiaVA}</th>`;
                    
                    rowVisitasTotalesInternet.innerHTML += `<th class="tblBody text-center">${totalDiaVAInternet}</th>`;
                    if(totalDiaVA > 0){
                        rowVisitasTotalesInternet.innerHTML += `<th class="tblBody text-center">${parseFloat((totalDiaVAInternet/totalDiaVA)*100).toFixed(2)}</th>`;
                    } else{
                        rowVisitasTotalesInternet.innerHTML += `<th class="tblBody text-center">0.00</th>`;
                    }
                    rowVisitasTotalesInternetPrimerIntento.innerHTML += `<th class="text-center">${totalDiaVAInternetPrimerIntento}</th>`;
                    if(totalDiaVAInternet>0){
                        rowVisitasTotalesInternetPrimerIntento.innerHTML += `<th class="text-center">${parseFloat((totalDiaVAInternetPrimerIntento/totalDiaVAInternet)*100).toFixed(2)}</th>`;
                    } else{
                        rowVisitasTotalesInternetPrimerIntento.innerHTML += `<th class="text-center">0.00</th>`;
                    }
                    rowVisitasTotalesInternetRecovery.innerHTML += `<th class="text-center">${totalDiaVAInternetRecovery}</th>`;
                    if(totalDiaVAInternet>0){
                        rowVisitasTotalesInternetRecovery.innerHTML += `<th class="text-center">${parseFloat((totalDiaVAInternetRecovery/totalDiaVAInternet)*100).toFixed(2)}</th>`;
                    }else {
                        rowVisitasTotalesInternetRecovery.innerHTML += `<th class="text-center">0.00</th>`;
                    }
                    //INBOUND
                    rowVisitasTotalesInbound.innerHTML += `<th class="tblBody text-center">${totalDiaVAInbound}</th>`;
                    if(totalDiaVA > 0){
                        rowVisitasTotalesInbound.innerHTML += `<th class="tblBody text-center">${parseFloat((totalDiaVAInbound/totalDiaVA)*100).toFixed(2)}</th>`;
                    } else {
                        rowVisitasTotalesInbound.innerHTML += `<th class="tblBody text-center">0.00</th>`;
                        
                    }
                    rowVisitasTotalesInboundPrimerIntento.innerHTML += `<th>${totalDiaVAInboundPrimerIntento}</th>`;
                    if(totalDiaVAInbound>0){
                        rowVisitasTotalesInboundPrimerIntento.innerHTML += `<th>${parseFloat((totalDiaVAInboundPrimerIntento/totalDiaVAInbound)*100).toFixed(2)}</th>`;
                    } else {
                        rowVisitasTotalesInboundPrimerIntento.innerHTML += `<th>0.00</th>`;
                        
                    }
                    rowVisitasTotalesInboundRecovery.innerHTML += `<th>${totalDiaVAInboundRecovery}</th>`;
                    if(totalDiaVAInbound>0){
                        rowVisitasTotalesInboundRecovery.innerHTML += `<th>${parseFloat((totalDiaVAInboundRecovery/totalDiaVAInbound)*100).toFixed(2)}</th>`;
                    } else {
                        rowVisitasTotalesInboundRecovery.innerHTML += `<th>0.00</th>`;
                        
                    }
                    //Correo
                    rowVisitasTotalesCorreo.innerHTML += `<th class="tblBody text-center">${totalDiaVACorreo}</th>`;
                    if(totalDiaVA > 0){
                        rowVisitasTotalesCorreo.innerHTML += `<th class="tblBody text-center">${parseFloat((totalDiaVACorreo/totalDiaVA)*100).toFixed(2)}</th>`;
                    } else {
                        rowVisitasTotalesCorreo.innerHTML += `<th class="tblBody text-center">0.00</th>`;
                    }
                    rowVisitasTotalesCorreoPrimerIntento.innerHTML += `<th>${totalDiaVACorreoPrimerIntento}</th>`;
                    if(totalDiaVACorreo > 0){
                        rowVisitasTotalesCorreoPrimerIntento.innerHTML += `<th>${parseFloat((totalDiaVACorreoPrimerIntento/totalDiaVACorreo)*100).toFixed(2)}</th>`;
                    } else {
                        rowVisitasTotalesCorreoPrimerIntento.innerHTML += `<th>0.00</th>`;
                    }
                    rowVisitasTotalesCorreoRecovery.innerHTML += `<th>${totalDiaVACorreoRecovery}</th>`;
                    
                    if(totalDiaVACorreo > 0){
                        rowVisitasTotalesCorreoRecovery.innerHTML += `<th>${parseFloat((totalDiaVACorreoRecovery/totalDiaVACorreo)*100).toFixed(2)}</th>`;
                    } else {
                        rowVisitasTotalesCorreoRecovery.innerHTML += `<th>0.00</th>`;
                    }
                    
                    rowVisitasRelacionadas.innerHTML += `<th class="tblBody text-center">${totalDiaVR}</th>`;
                    
                    //TOTAL TRANSFERENCIA A TELEVENTA
                    rowTrasnferenciasTV.innerHTML += `<th class="tblBody text-center">${totalDiaTransferenciaTeleventa}</th>`;
                    
                    //PROMEDIO VUELTAS NO CONTACTO
                    rowVueltasNoContacto.innerHTML += `<th class="tblBody text-center">${(promedioDiaVueltasNoContacto/contadorPromediosHora).toFixed(1)}</th>`;
                    
                    
                    //NO CONTACTO
                    rowNoContacto.innerHTML += `<th class="tblBody text-center">${totalDiaNC}</th>`;
                    if(totalDia > 0){
                        rowNoContacto.innerHTML += `<th class="tblBody text-center">${parseFloat((totalDiaNC/totalDia)*100).toFixed(2)}</th>`;
                        rowPorcNoContacto.innerHTML += `<th class="tblBody text-center">${parseFloat((totalDiaNC/totalDia)*100).toFixed(2)}</th>`;
                    } else {
                        rowNoContacto.innerHTML += `<th class="tblBody text-center">0.00</th>`;
                        rowPorcNoContacto.innerHTML += `<th class="tblBody text-center">0.00</th>`;
                    }
                    
                    //NO CONTACTO - APAGADO
                    rowNoContactoApagado.innerHTML += `<th class="text-center">${totalDiaNCApagado}</th>`;
                    if(totalDiaNC > 0){
                        rowNoContactoApagado.innerHTML += `<th>${parseFloat((totalDiaNCApagado/totalDiaNC)*100).toFixed(2)}</th>`;
                    } else {
                        rowNoContactoApagado.innerHTML += `<th>0.00</th>`;
                    }
                    
                    //NO CONTACTO - ContestaCorta
                    rowNoContactoContestaCorta.innerHTML += `<th class="text-center">${totalDiaNCContestaCorta}</th>`;
                    if(totalDiaNC > 0){
                        rowNoContactoContestaCorta.innerHTML += `<th>${parseFloat((totalDiaNCContestaCorta/totalDiaNC)*100).toFixed(2)}</th>`;
                    } else {
                        rowNoContactoContestaCorta.innerHTML += `<th>0.00</th>`;
                    }
                    //NO CONTACTO - NoContacto
                    rowNoContactoNoContacto.innerHTML += `<th class="text-center">${totalDiaNCNoContacto}</th>`;
                    if(totalDiaNC > 0){
                        rowNoContactoNoContacto.innerHTML += `<th>${parseFloat((totalDiaNCNoContacto/totalDiaNC)*100).toFixed(2)}</th>`;
                    } else {
                        rowNoContactoNoContacto.innerHTML += `<th>0.00</th>`;
                    }
                    
                    //NOGESTIONABLE
                    rowNoGestionable.innerHTML += `<th class="tblBody text-center">${totalDiaNG}</th>`;
                    if(totalDia > 0){
                        rowNoGestionable.innerHTML += `<th class="tblBody text-center">${parseFloat((totalDiaNG/totalDia)*100).toFixed(2)}</th>`;
                        rowPorcNoGestionable.innerHTML += `<th class="tblBody text-center">${parseFloat((totalDiaNG/totalDia)*100).toFixed(2)}</th>`;
                    } else {
                        rowNoGestionable.innerHTML += `<th class="tblBody text-center">0.00</th>`;
                        rowPorcNoGestionable.innerHTML += `<th class="tblBody text-center">0.00</th>`;
                    }
                    
                    //NOGESTIONABLE - Televenta
                    rowNoGestionableTeleventa.innerHTML += `<th class=" text-center">${totalDiaNGTeleventa}</th>`;
                    if(totalDiaNG > 0){
                        rowNoGestionableTeleventa.innerHTML += `<th>${parseFloat((totalDiaNGTeleventa/totalDiaNG)*100).toFixed(2)}</th>`;
                    } else {
                        rowNoGestionableTeleventa.innerHTML += `<th>0.00</th>`;
                    }
                    //NOGESTIONABLE - ClienteError
                    rowNoGestionableClienteError.innerHTML += `<th class=" text-center">${totalDiaNGClienteError}</th>`;
                    if(totalDiaNG > 0){
                        rowNoGestionableClienteError.innerHTML += `<th>${parseFloat((totalDiaNGClienteError/totalDiaNG)*100).toFixed(2)}</th>`;
                    } else {
                        rowNoGestionableClienteError.innerHTML += `<th>0.00</th>`;
                    }
                    //NOGESTIONABLE - Duplicado
                    rowNoGestionableDuplicado.innerHTML += `<th class=" text-center">${totalDiaNGDuplicado}</th>`;
                    if(totalDiaNG > 0){
                        rowNoGestionableDuplicado.innerHTML += `<th>${parseFloat((totalDiaNGDuplicado/totalDiaNG)*100).toFixed(2)}</th>`;
                    } else {
                        rowNoGestionableDuplicado.innerHTML += `<th>0.00</th>`;
                    }
                    //NOGESTIONABLE - Inviable
                    rowNoGestionableInviable.innerHTML += `<th class=" text-center">${totalDiaNGInviable}</th>`;
                    if(totalDiaNG > 0){
                        rowNoGestionableInviable.innerHTML += `<th>${parseFloat((totalDiaNGInviable/totalDiaNG)*100).toFixed(2)}</th>`;
                    } else {
                        rowNoGestionableInviable.innerHTML += `<th>0.00</th>`;
                    }
                    //NOGESTIONABLE - PROV
                    rowNoGestionablePROV.innerHTML += `<th class=" text-center">${totalDiaNGPROV}</th>`;
                    if(totalDiaNG > 0){
                        rowNoGestionablePROV.innerHTML += `<th>${parseFloat((totalDiaNGPROV/totalDiaNG)*100).toFixed(2)}</th>`;
                    } else {
                        rowNoGestionablePROV.innerHTML += `<th>0.00</th>`;
                    }
                    //NOGESTIONABLE - ZSCC
                    rowNoGestionableZSCC.innerHTML += `<th class=" text-center">${totalDiaNGZSCC}</th>`;
                    if(totalDiaNG > 0){
                        rowNoGestionableZSCC.innerHTML += `<th>${parseFloat((totalDiaNGZSCC/totalDiaNG)*100).toFixed(2)}</th>`;
                    } else {
                        rowNoGestionableZSCC.innerHTML += `<th>0.00</th>`;
                    }
                    //NOGESTIONABLE - TelefonoError
                    rowNoGestionableTelefonoError.innerHTML += `<th class=" text-center">${totalDiaNGTelefonoError}</th>`;
                    if(totalDiaNG > 0){
                        rowNoGestionableTelefonoError.innerHTML += `<th>${parseFloat((totalDiaNGTelefonoError/totalDiaNG)*100).toFixed(2)}</th>`;
                    } else {
                        rowNoGestionableTelefonoError.innerHTML += `<th>0.00</th>`;
                    }
                    //NOGESTIONABLE - NoCotizo
                    rowNoGestionableNoCotizo.innerHTML += `<th class=" text-center">${totalDiaNGNoCotizo}</th>`;
                    if(totalDiaNG > 0){
                        rowNoGestionableNoCotizo.innerHTML += `<th>${parseFloat((totalDiaNGNoCotizo/totalDiaNG)*100).toFixed(2)}</th>`;
                    } else {
                        rowNoGestionableNoCotizo.innerHTML += `<th>0.00</th>`;
                    }
                    //NOGESTIONABLE - ATC
                    rowNoGestionableATC.innerHTML += `<th class=" text-center">${totalDiaNGATC}</th>`;
                    if(totalDiaNG > 0){
                        rowNoGestionableATC.innerHTML += `<th>${parseFloat((totalDiaNGATC/totalDiaNG)*100).toFixed(2)}</th>`;
                    } else {
                        rowNoGestionableATC.innerHTML += `<th>0.00</th>`;
                    }
                    //NOGESTIONABLE - Otros
                    rowNoGestionableOtros.innerHTML += `<th class=" text-center">${totalDiaNGOtros}</th>`;
                    if(totalDiaNG > 0){
                        rowNoGestionableOtros.innerHTML += `<th>${parseFloat((totalDiaNGOtros/totalDiaNG)*100).toFixed(2)}</th>`;
                    } else {
                        rowNoGestionableOtros.innerHTML += `<th>0.00</th>`;
                    }
                    //NOGESTIONABLE - Backoffice
                    rowNoGestionableBackoffice.innerHTML += `<th class=" text-center">${totalDiaNGBackoffice}</th>`;
                    if(totalDiaNG > 0){
                        rowNoGestionableBackoffice.innerHTML += `<th>${parseFloat((totalDiaNGBackoffice/totalDiaNG)*100).toFixed(2)}</th>`;
                    } else {
                        rowNoGestionableBackoffice.innerHTML += `<th>0.00</th>`;
                    }
                    
                    //GESTIONABLE
                    rowGestionable.innerHTML += `<th class="tblBody text-center">${totalDiaGestionable}</th>`;
                    if(totalDia > 0){
                        rowGestionable.innerHTML += `<th class="tblBody text-center">${parseFloat((totalDiaGestionable/totalDia)*100).toFixed(2)}</th>`;
                        rowPorcGestionable.innerHTML += `<th class="tblBody text-center">${parseFloat((totalDiaGestionable/totalDia)*100).toFixed(2)}</th>`;
                    } else {
                        rowGestionable.innerHTML += `<th class="tblBody text-center">0.00</th>`;
                        rowPorcGestionable.innerHTML += `<th class="tblBody text-center">0.00</th>`;
                    }
                    //GESTIONABLE - NoCotizo
                    rowGestionableDevolverLlamada.innerHTML += `<th class=" text-center">${totalDiaGestionableDevolverLlamada}</th>`;
                    if(totalDiaGestionable > 0){
                        rowGestionableDevolverLlamada.innerHTML += `<th>${parseFloat((totalDiaGestionableDevolverLlamada/totalDiaGestionable)*100).toFixed(2)}</th>`;
                    } else {
                        rowGestionableDevolverLlamada.innerHTML += `<th>0.00</th>`;
                    }
                    //GESTIONABLE - ATC
                    rowGestionableNoAceptaVisita.innerHTML += `<th class=" text-center">${totalDiaGestionableNoAceptaVisita}</th>`;
                    if(totalDiaGestionable > 0){
                        rowGestionableNoAceptaVisita.innerHTML += `<th>${parseFloat((totalDiaGestionableNoAceptaVisita/totalDiaGestionable)*100).toFixed(2)}</th>`;
                    } else {
                        rowGestionableNoAceptaVisita.innerHTML += `<th>0.00</th>`;
                    }
                    //GESTIONABLE - Otros
                    rowGestionableVisitaAceptada.innerHTML += `<th class=" text-center">${totalDiaGestionableVisitaAceptada}</th>`;
                    if(totalDiaGestionable > 0){
                        rowGestionableVisitaAceptada.innerHTML += `<th>${parseFloat((totalDiaGestionableVisitaAceptada/totalDiaGestionable)*100).toFixed(2)}</th>`;
                    } else {
                        rowGestionableVisitaAceptada.innerHTML += `<th>0.00</th>`;
                    }
                    //GESTIONABLE - Backoffice
                    rowGestionableVisitaReconfirmar.innerHTML += `<th class=" text-center">${totalDiaGestionableVisitaReconfirmar}</th>`;
                    if(totalDiaGestionable > 0){
                        rowGestionableVisitaReconfirmar.innerHTML += `<th>${parseFloat((totalDiaGestionableVisitaReconfirmar/totalDiaGestionable)*100).toFixed(2)}</th>`;
                    } else {
                        rowGestionableVisitaReconfirmar.innerHTML += `<th>0.00</th>`;
                    }
                    
                    
                    //CANAL
                    rowCanal.innerHTML += `<th class="tblBody text-center">${totalDiaCanal}</th>`; 
                    //CANAL FACEBOOK
                    rowCanalFacebook.innerHTML += `<th class=" text-center">${totalDiaCanalFacebook}</th>`;
                    if(totalDiaCanalFacebook > 0){
                        rowCanalFacebook.innerHTML += `<th>${parseFloat((totalDiaCanalFacebook/totalDiaCanal)*100).toFixed(2)}</th>`;
                    } else {
                        rowCanalFacebook.innerHTML += `<th>0.00</th>`;
                    }
                    
                    //CANAL rowCanalFacebook_LN
                    rowCanalFacebook_LN.innerHTML += `<th class=" text-center">${totalDiaCanalFacebook_LN}</th>`;
                    if(totalDiaCanalFacebook_LN > 0){
                        rowCanalFacebook_LN.innerHTML += `<th>${parseFloat((totalDiaCanalFacebook_LN/totalDiaCanal)*100).toFixed(2)}</th>`;
                    } else {
                        rowCanalFacebook_LN.innerHTML += `<th>0.00</th>`;
                    }
                    //CANAL rowCanalAfiliados
                    rowCanalAfiliados.innerHTML += `<th class=" text-center">${totalDiaCanalAfiliados}</th>`;
                    if(totalDiaCanalAfiliados > 0){
                        rowCanalAfiliados.innerHTML += `<th>${parseFloat((totalDiaCanalAfiliados/totalDiaCanal)*100).toFixed(2)}</th>`;
                    } else {
                        rowCanalAfiliados.innerHTML += `<th>0.00</th>`;
                    }
                    //CANAL rowCanalDisplay
                    rowCanalDisplay.innerHTML += `<th class=" text-center">${totalDiaCanalDisplay}</th>`;
                    if(totalDiaCanalDisplay > 0){
                        rowCanalDisplay.innerHTML += `<th>${parseFloat((totalDiaCanalDisplay/totalDiaCanal)*100).toFixed(2)}</th>`;
                    } else {
                        rowCanalDisplay.innerHTML += `<th>0.00</th>`;
                    }
                    //CANAL rowCanalEmail
                    rowCanalEmail.innerHTML += `<th class=" text-center">${totalDiaCanalEmail}</th>`;
                    if(totalDiaCanalEmail > 0){
                        rowCanalEmail.innerHTML += `<th>${parseFloat((totalDiaCanalEmail/totalDiaCanal)*100).toFixed(2)}</th>`;
                    } else {
                        rowCanalEmail.innerHTML += `<th>0.00</th>`;
                    }
                    //CANAL rowCanalGDN
                    rowCanalGDN.innerHTML += `<th class=" text-center">${totalDiaCanalGDN}</th>`;
                    if(totalDiaCanalGDN > 0){
                        rowCanalGDN.innerHTML += `<th>${parseFloat((totalDiaCanalGDN/totalDiaCanal)*100).toFixed(2)}</th>`;
                    } else {
                        rowCanalGDN.innerHTML += `<th>0.00</th>`;
                    }
                    //CANAL rowCanalSEMMARCA
                    rowCanalSEMMARCA.innerHTML += `<th class=" text-center">${totalDiaCanalSEMMARCA}</th>`;
                    if(totalDiaCanalSEMMARCA > 0){
                        rowCanalSEMMARCA.innerHTML += `<th>${parseFloat((totalDiaCanalSEMMARCA/totalDiaCanal)*100).toFixed(2)}</th>`;
                    } else {
                        rowCanalSEMMARCA.innerHTML += `<th>0.00</th>`;
                    }
                    //CANAL rowCanalSEMGENERICO
                    rowCanalSEMGENERICO.innerHTML += `<th class=" text-center">${totalDiaCanalSEMGENERICO}</th>`;
                    if(totalDiaCanalSEMGENERICO > 0){
                        rowCanalSEMGENERICO.innerHTML += `<th>${parseFloat((totalDiaCanalSEMGENERICO/totalDiaCanal)*100).toFixed(2)}</th>`;
                    } else {
                        rowCanalSEMGENERICO.innerHTML += `<th>0.00</th>`;
                    }
                    //CANAL SEO
                    rowCanalSEO.innerHTML += `<th class=" text-center">${totalDiaCanalSEO}</th>`;
                    if(totalDiaCanalSEO > 0){
                        rowCanalSEO.innerHTML += `<th>${parseFloat((totalDiaCanalSEO/totalDiaCanal)*100).toFixed(2)}</th>`;
                    } else {
                        rowCanalSEO.innerHTML += `<th>0.00</th>`;
                    }
                    //CANAL INBOUND
                    rowCanalINBOUND.innerHTML += `<th class=" text-center">${totalDiaCanalINBOUND}</th>`;
                    if(totalDiaCanalINBOUND > 0){
                        rowCanalINBOUND.innerHTML += `<th>${parseFloat((totalDiaCanalINBOUND/totalDiaCanal)*100).toFixed(2)}</th>`;
                    } else {
                        rowCanalINBOUND.innerHTML += `<th>0.00</th>`;
                    }

                    //CANAL Tiktok
                    rowCanalTiktok.innerHTML += `<th class=" text-center">${totalDiaCanalTiktok}</th>`;
                    if(totalDiaCanalTiktok > 0){
                        rowCanalTiktok.innerHTML += `<th>${parseFloat((totalDiaCanalTiktok/totalDiaCanal)*100).toFixed(2)}</th>`;
                    } else {
                        rowCanalTiktok.innerHTML += `<th>0.00</th>`;
                    }
                    //VUELTAS
                    let arregloPromVueltas = data.LeadsPromVueltas;
                    
                    //APAGADO
                    const objApagado = arregloPromVueltas.find(elemento => elemento.ResultadoGestion == 'apagado');
                    if(objApagado){
                        rowNoContactoApagado.innerHTML += `<th class=" text-center">${parseFloat(objApagado.PromVueltas).toFixed(2)}</th>`;
                    } else {
                        rowNoContactoApagado.innerHTML += `<th class=" text-center">0.00</th>`;
                    }
                    //CONTESTA Y CORTA
                    const objcontestaCorta = arregloPromVueltas.find(elemento => elemento.ResultadoGestion == 'contestaCorta');
                    if(objcontestaCorta){
                        rowNoContactoContestaCorta.innerHTML += `<th class=" text-center">${parseFloat(objcontestaCorta.PromVueltas).toFixed(2)}</th>`;
                    } else {
                        rowNoContactoContestaCorta.innerHTML += `<th class=" text-center">0.00</th>`;
                    }
                    //NoContacto
                    const objNoContacto = arregloPromVueltas.find(elemento => elemento.ResultadoGestion == "noContacto");
                    if(objNoContacto){
                        rowNoContactoNoContacto.innerHTML += `<th class=" text-center">${parseFloat(objNoContacto.PromVueltas).toFixed(2)}</th>`;
                    } else {
                        rowNoContactoNoContacto.innerHTML += `<th class=" text-center">0.00</th>`;
                    }
                    //Televenta
                    const objTeleventa = arregloPromVueltas.find(elemento => elemento.ResultadoGestion == "televenta");
                    if(objTeleventa){
                        rowNoGestionableTeleventa.innerHTML += `<th class=" text-center">${parseFloat(objTeleventa.PromVueltas).toFixed(2)}</th>`;
                    } else {
                        rowNoGestionableTeleventa.innerHTML += `<th class=" text-center">0.00</th>`;
                    }
                    //ClienteError
                    const objClienteError = arregloPromVueltas.find(elemento => elemento.ResultadoGestion == "clienteError");
                    if(objClienteError){
                        rowNoGestionableClienteError.innerHTML += `<th class=" text-center">${parseFloat(objClienteError.PromVueltas).toFixed(2)}</th>`;
                    } else {
                        rowNoGestionableClienteError.innerHTML += `<th class=" text-center">0.00</th>`;
                    }
                    //Duplicado
                    const objDuplicado = arregloPromVueltas.find(elemento => elemento.ResultadoGestion == "duplicado");
                    if(objDuplicado){
                        rowNoGestionableDuplicado.innerHTML += `<th class=" text-center">${parseFloat(objDuplicado.PromVueltas).toFixed(2)}</th>`;
                    } else {
                        rowNoGestionableDuplicado.innerHTML += `<th class=" text-center">0.00</th>`;
                    }
                    //Inviable
                    const objInviable = arregloPromVueltas.find(elemento => elemento.ResultadoGestion == "inviable");
                    if(objDuplicado){
                        rowNoGestionableInviable.innerHTML += `<th class=" text-center">${parseFloat(objInviable.PromVueltas).toFixed(2)}</th>`;
                    } else {
                        rowNoGestionableInviable.innerHTML += `<th class=" text-center">0.00</th>`;
                    }
                    //PROV
                    const objPROV = arregloPromVueltas.find(elemento => elemento.ResultadoGestion == "prov");
                    if(objDuplicado){
                        rowNoGestionablePROV.innerHTML += `<th class=" text-center">${parseFloat(objPROV.PromVueltas).toFixed(2)}</th>`;
                    } else {
                        rowNoGestionablePROV.innerHTML += `<th class=" text-center">0.00</th>`;
                    }
                    //ZSCC
                    const objZSCC = arregloPromVueltas.find(elemento => elemento.ResultadoGestion == "zscc");
                    if(objDuplicado){
                        rowNoGestionableZSCC.innerHTML += `<th class=" text-center">${parseFloat(objZSCC.PromVueltas).toFixed(2)}</th>`;
                    } else {
                        rowNoGestionableZSCC.innerHTML += `<th class=" text-center">0.00</th>`;
                    }
                    //TelefonoError
                    const objTelefonoError = arregloPromVueltas.find(elemento => elemento.ResultadoGestion == "telefonoError");
                    if(objDuplicado){
                        rowNoGestionableTelefonoError.innerHTML += `<th class=" text-center">${parseFloat(objTelefonoError.PromVueltas).toFixed(2)}</th>`;
                    } else {
                        rowNoGestionableTelefonoError.innerHTML += `<th class=" text-center">0.00</th>`;
                    }
                    //NoCotizo
                    const objnoCotizo = arregloPromVueltas.find(elemento => elemento.ResultadoGestion == 'noCotizo');
                    if(objnoCotizo){
                        rowNoGestionableNoCotizo.innerHTML += `<th class=" text-center">${parseFloat(objnoCotizo.PromVueltas).toFixed(2)}</th>`;
                    } else {
                        rowNoGestionableNoCotizo.innerHTML += `<th class=" text-center">0.00</th>`;
                    }
                    //ATC
                    const objATC = arregloPromVueltas.find(elemento => elemento.ResultadoGestion == "atc");
                    if(objATC){
                        rowNoGestionableATC.innerHTML += `<th class=" text-center">${parseFloat(objATC.PromVueltas).toFixed(2)}</th>`;
                    } else {
                        rowNoGestionableATC.innerHTML += `<th class=" text-center">0.00</th>`;
                    }
                    //Otros
                    const objOtros = arregloPromVueltas.find(elemento => elemento.ResultadoGestion == "otros");
                    if(objOtros){
                        rowNoGestionableOtros.innerHTML += `<th class=" text-center">${parseFloat(objOtros.PromVueltas).toFixed(2)}</th>`;
                    } else {
                        rowNoGestionableOtros.innerHTML += `<th class=" text-center">0.00</th>`;
                    }
                    //Backoffice
                    const objBackoffice = arregloPromVueltas.find(elemento => elemento.ResultadoGestion == "backoffice");
                    if(objBackoffice){
                        rowNoGestionableBackoffice.innerHTML += `<th class=" text-center">${parseFloat(objBackoffice.PromVueltas).toFixed(2)}</th>`;
                    } else {
                        rowNoGestionableBackoffice.innerHTML += `<th class=" text-center">0.00</th>`;
                    }
                    
                    //DevolverLlamada
                    const objDevolverLlamada = arregloPromVueltas.find(elemento => elemento.ResultadoGestion == "devolverLlamada");
                    if(objDevolverLlamada){
                        rowGestionableDevolverLlamada.innerHTML += `<th class=" text-center">${parseFloat(objDevolverLlamada.PromVueltas).toFixed(2)}</th>`;
                    } else {
                        rowGestionableDevolverLlamada.innerHTML += `<th class=" text-center">0.00</th>`;
                    }
                    //NoAceptaVisita
                    const objNoAceptaVisita = arregloPromVueltas.find(elemento => elemento.ResultadoGestion == "noAceptaVisita");
                    if(objNoAceptaVisita){
                        rowGestionableNoAceptaVisita.innerHTML += `<th class=" text-center">${parseFloat(objNoAceptaVisita.PromVueltas).toFixed(2)}</th>`;
                    } else {
                        rowGestionableNoAceptaVisita.innerHTML += `<th class=" text-center">0.00</th>`;
                    }
                    //VisitaAceptada
                    const objVisitaAceptada = arregloPromVueltas.find(elemento => elemento.ResultadoGestion == "visitaAceptada");
                    if(objVisitaAceptada){
                        rowGestionableVisitaAceptada.innerHTML += `<th class=" text-center">${parseFloat(objVisitaAceptada.PromVueltas).toFixed(2)}</th>`;
                    } else {
                        rowGestionableVisitaAceptada.innerHTML += `<th class=" text-center">0.00</th>`;
                    }
                    //VisitaReconfirmar
                    const objVisitaReconfirmar = arregloPromVueltas.find(elemento => elemento.ResultadoGestion == "visitaReconfirmar");
                    if(objVisitaReconfirmar){
                        rowGestionableVisitaReconfirmar.innerHTML += `<th class=" text-center">${parseFloat(objVisitaReconfirmar.PromVueltas).toFixed(2)}</th>`;
                    } else {
                        rowGestionableVisitaReconfirmar.innerHTML += `<th class=" text-center">0.00</th>`;
                    }
                    
                    //TOTALE LEAD TO BOOKING
                    
                    if(totalDia > 0){
                        rowLTB.innerHTML += `<td class="text-center">${parseFloat((totalDiaVA/totalDia)*100).toFixed(0)}%</td>`;
                    } else {
                        rowLTB.innerHTML += `<td class="text-center">0%</td>`;
                    }                    
                    
                    if(totalDiaInternet > 0){
                        rowLTB_Internet.innerHTML += `<td class="text-center">${parseFloat((totalDiaVAInternet/totalDiaInternet)*100).toFixed(0)}%</td>`;
                    } else {
                        rowLTB_Internet.innerHTML += `<td class="text-center">0%</td>`;
                    }
                    
                    if(totalDiaInbound > 0){
                        rowLTB_Inbound.innerHTML += `<td class="text-center">${parseFloat((totalDiaVAInbound/totalDiaInbound)*100).toFixed(0)}%</td>`;
                    } else {
                        rowLTB_Inbound.innerHTML += `<td class="text-center">0%</td>`;
                    }
                    if(totalDiaCorreo > 0){
                        rowLTB_Correo.innerHTML += `<td class="text-center">${parseFloat((totalDiaVACorreo/totalDiaCorreo)*100).toFixed(0)}%</td>`;
                    } else {
                        rowLTB_Correo.innerHTML += `<td class="text-center">0%</td>`;
                    }                     

                    
                    
                    

                       
                }
            })
            
            
            
            contenedorLeadsDiaHead.appendChild(row);
            contenedorLeadsDiaHead.appendChild(rowInternet);
            contenedorLeadsDiaHead.appendChild(rowInbound);
            contenedorLeadsDiaHead.appendChild(rowCorreo);
            contenedorLeadsDiaHead.appendChild(rowEspacio4);
            contenedorLeadsDiaHead.appendChild(rowLTB);
            contenedorLeadsDiaHead.appendChild(rowLTB_Internet);
            contenedorLeadsDiaHead.appendChild(rowLTB_Inbound);
            contenedorLeadsDiaHead.appendChild(rowLTB_Correo);
            contenedorLeadsDiaHead.appendChild(rowEspacio5);
            contenedorLeadsDiaHead.appendChild(rowVisitasExpress);
            contenedorLeadsDiaHead.appendChild(rowVisitasTotales);
            contenedorLeadsDiaHead.appendChild(rowVisitasTotalesInternet);
            contenedorLeadsDiaHead.appendChild(rowVisitasTotalesInternetPrimerIntento);
            contenedorLeadsDiaHead.appendChild(rowVisitasTotalesInternetRecovery);
            contenedorLeadsDiaHead.appendChild(rowVisitasTotalesInbound);
            contenedorLeadsDiaHead.appendChild(rowVisitasTotalesInboundPrimerIntento);
            contenedorLeadsDiaHead.appendChild(rowVisitasTotalesInboundRecovery);
            contenedorLeadsDiaHead.appendChild(rowVisitasTotalesCorreo);
            contenedorLeadsDiaHead.appendChild(rowVisitasTotalesCorreoPrimerIntento);
            contenedorLeadsDiaHead.appendChild(rowVisitasTotalesCorreoRecovery);
            contenedorLeadsDiaHead.appendChild(rowVisitasRelacionadas);
            contenedorLeadsDiaHead.appendChild(rowEspacio);
            contenedorLeadsDiaHead.appendChild(rowPorcNoContacto);
            contenedorLeadsDiaHead.appendChild(rowPorcNoGestionable);
            contenedorLeadsDiaHead.appendChild(rowPorcGestionable);
            contenedorLeadsDiaHead.appendChild(rowEspacio2);
            contenedorLeadsDiaHead.appendChild(rowTrasnferenciasTV);
            contenedorLeadsDiaHead.appendChild(rowVueltasNoContacto);
            contenedorLeadsDiaHead.appendChild(rowNoContacto);
            contenedorLeadsDiaHead.appendChild(rowNoContactoApagado);
            contenedorLeadsDiaHead.appendChild(rowNoContactoContestaCorta);
            contenedorLeadsDiaHead.appendChild(rowNoContactoNoContacto);
            contenedorLeadsDiaHead.appendChild(rowNoGestionable);
            contenedorLeadsDiaHead.appendChild(rowNoGestionableTeleventa);
            contenedorLeadsDiaHead.appendChild(rowNoGestionableClienteError);
            contenedorLeadsDiaHead.appendChild(rowNoGestionableDuplicado);
            contenedorLeadsDiaHead.appendChild(rowNoGestionableInviable);
            contenedorLeadsDiaHead.appendChild(rowNoGestionablePROV);
            contenedorLeadsDiaHead.appendChild(rowNoGestionableZSCC);
            contenedorLeadsDiaHead.appendChild(rowNoGestionableTelefonoError);
            contenedorLeadsDiaHead.appendChild(rowNoGestionableNoCotizo);
            contenedorLeadsDiaHead.appendChild(rowNoGestionableATC);
            contenedorLeadsDiaHead.appendChild(rowNoGestionableOtros);
            contenedorLeadsDiaHead.appendChild(rowNoGestionableBackoffice);
            contenedorLeadsDiaHead.appendChild(rowGestionable);
            contenedorLeadsDiaHead.appendChild(rowGestionableDevolverLlamada);
            contenedorLeadsDiaHead.appendChild(rowGestionableNoAceptaVisita);
            contenedorLeadsDiaHead.appendChild(rowGestionableVisitaAceptada);
            contenedorLeadsDiaHead.appendChild(rowGestionableVisitaReconfirmar);
            contenedorLeadsDiaHead.appendChild(rowEspacio3);
            contenedorLeadsDiaHead.appendChild(rowCanal);
            contenedorLeadsDiaHead.appendChild(rowCanalFacebook);
            contenedorLeadsDiaHead.appendChild(rowCanalFacebook_LN);
            contenedorLeadsDiaHead.appendChild(rowCanalAfiliados);
            contenedorLeadsDiaHead.appendChild(rowCanalDisplay);
            contenedorLeadsDiaHead.appendChild(rowCanalEmail);
            contenedorLeadsDiaHead.appendChild(rowCanalGDN);
            contenedorLeadsDiaHead.appendChild(rowCanalSEMMARCA);
            contenedorLeadsDiaHead.appendChild(rowCanalSEMGENERICO);
            contenedorLeadsDiaHead.appendChild(rowCanalSEO);
            contenedorLeadsDiaHead.appendChild(rowCanalINBOUND);
            contenedorLeadsDiaHead.appendChild(rowCanalTiktok);
            
        }
        
        function limpiarHTML(cont) {
            //forma recomendada
            while (cont.firstChild) {
                cont.removeChild(cont.firstChild);
            }
        }
    </script>
    
    <script>

    </script>
    
</body>
</html>