<?php
session_start();

date_default_timezone_set('America/Lima');
include 'config/db.php';
include 'config/conexion.php';

if (!isset($_SESSION['user_login_status'])) {
        header("location: ./login/index.php");
		exit;
}

if ($_SESSION['pzvtaconsulta']==0) {
         header("location: ./denegado.php");
		exit;
}


?>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title>Verisure | VeriSmart</title>
        <!-- Tell the browser to be responsive to screen width -->
        <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
        <link rel="icon" type="image/png" sizes="32x32" href="admin/dist/img/-apple-touch-icon-144x144.png" >
       <!-- Bootstrap 3.3.7 -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css">
        <!-- Font Awesome -->
        <link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
        <!-- Ionicons -->
        <link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">

        <!-- Theme style -->
        <link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
        <!-- AdminLTE Skins. Choose a skin from the css/skins
             folder instead of downloading all of them to reduce the load. -->
        <link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">

        <!-- daterange picker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-daterangepicker/daterangepicker.css">
        <!-- bootstrap datepicker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
        <!-- iCheck for checkboxes and radio inputs -->
        <link rel="stylesheet" href="admin/plugins/iCheck/all.css">
        <!-- Bootstrap Color Picker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-colorpicker/dist/css/bootstrap-colorpicker.min.css">
        <!-- Bootstrap time Picker -->
        <link rel="stylesheet" href="admin/plugins/timepicker/bootstrap-timepicker.min.css">
        <!-- Select2 -->
        <link rel="stylesheet" href="admin/bower_components/select2/dist/css/select2.min.css">
        <!-- Bootsrap Toogle -->
        <link href="admin/plugins/bootstrap-toggle-master/css/bootstrap-toggle.min.css" rel="stylesheet" type="text/css"/>

        <link href="admin/bower_components/bootstrap-table/dist/bootstrap-table.min.css" rel="stylesheet" type="text/css"/>
        <!-- bootstrap wysihtml5 - text editor -->
        <link rel="stylesheet" href="admin/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css">

        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->

        <link href="admin/bower_components/bootstrap-table/dist/bootstrap-table.min.css" rel="stylesheet" type="text/css"/>

        <!-- Google Font -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">

        <!-- Alertifyjs -->
        <link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css"/>
        <link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css"/>
        
        <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">

        <style>

            .callout {
                border-radius: 3px;
                margin: 0 0 20px 0;
                padding: 15px;
                border-left: 0px solid #eee;
            }


            @font-face {
                font-family: 'fontello';
                src: url('./font/fontello.eot?11113651');
                src: url('./font/fontello.eot?11113651#iefix') format('embedded-opentype'),
                url('./font/fontello.woff?11113651') format('woff'),
                url('./font/fontello.ttf?11113651') format('truetype'),
                url('./font/fontello.svg?11113651#fontello') format('svg');
                font-weight: normal;
                font-style: normal;
            }

            .demo-icon {
                font-family: "fontello";
                font-style: normal;
                font-weight: normal;
                /* speak: none; */
                display: inline-block;
                text-decoration: inherit;
                width: 1em;
                margin-right: .1em;
                text-align: center;
                /* opacity: .8; */
                font-variant: normal;
                text-transform: none;
                line-height: 1.7em;
                margin-left: .1em;
                /* font-size: 120%; */
                -webkit-font-smoothing: antialiased;
                -moz-osx-font-smoothing: grayscale;
                /* text-shadow: 1px 1px 1px rgba(127, 127, 127, 0.3); */
            }

        
            .thumbnail .caption {
                padding: 0px;
                color: #333;
                margin-bottom: 0px; 
            }

            .modal-header-success {
                color:#fff;
                background-color: #008d4c;              
            }
            .modal-header-danger {
                color:#fff;
                background-color: #fb1e1e;              
            }

            @media (min-height: 500px) {
              /*  .modal-body { height: 550px; }*/
            }

            @media (min-height: 800px) {
               /*  .modal-body { height: 550px; }*/
            }
            

            .espacio{
                height:10px;
            }

            .espacio2{
                height:15px;
            }

            .thumbnail_style{
                text-align:center;
                border:none;
            }
            .bg-gray {
                color: #666;
                background-color: #eeeeee !important;
            }

            .caption h4{
                margin-top: -10px;
                font-size:13px;
                font-weight:  bold;
            }

            .caption p{
                color:#777;
                font-size:13px;
            }

            .caption a{
                color:#777;
                font-size:10px;
            }


            #myWizard2 .form-control{
                border-radius: 4px
            }

            #c-slider{
                margin: 0;
                width: 100%;
                max-width: 900px;
                position: relative;
                overflow: hidden;

            }
            #slider{
                display: flex;
                width: 200%;

            }


            #slider section{
                width: 100%;
            }


            .select2-container--default .select2-selection--single {

                border: 1px solid #d2d6de;
                border-radius: 4px;font-size: 12px;
                padding:4px 6px;
            }

            .btn-nuevo { 
                color: #FFFFFF; 
                background-color: #444444; 
                border-color: #444444; 
            } 

            .btn-nuevo:hover, 
            .btn-nuevo:focus, 
            .btn-nuevo:active, 
            .btn-nuevo.active, 
            .open .dropdown-toggle.btn-nuevo { 
                color: #FFFFFF; 
                background-color: #616161;  
                border-color: #444444; 
            } 

            .btn-nuevo:active, 
            .btn-nuevo.active, 
            .open .dropdown-toggle.btn-nuevo { 
                background-image: none; 
            } 

            .btn-nuevo.disabled, 
            .btn-nuevo[disabled], 
            fieldset[disabled] .btn-nuevo, 
            .btn-nuevo.disabled:hover, 
            .btn-nuevo[disabled]:hover, 
            fieldset[disabled] .btn-nuevo:hover, 
            .btn-nuevo.disabled:focus, 
            .btn-nuevo[disabled]:focus, 
            fieldset[disabled] .btn-nuevo:focus, 
            .btn-nuevo.disabled:active, 
            .btn-nuevo[disabled]:active, 
            fieldset[disabled] .btn-nuevo:active, 
            .btn-nuevo.disabled.active, 
            .btn-nuevo[disabled].active, 
            fieldset[disabled] .btn-nuevo.active { 
                background-color: #444444; 
                border-color: #444444; 
            } 
            
            .btn-nuevo2 { 
                color: #444444;
                background-color: #eeeeee;
                border-color: #d2d6de;
            } 


            .btn-nuevo2:hover, 
            .btn-nuevo2:focus, 
            .btn-nuevo2:active, 
            .btn-nuevo2.active, 
            .open .dropdown-toggle.btn-nuevo2 { 
              color: #FFFFFF; 
              background-color: #616161; 
              border-color: #444444; 
            } 
 
            .btn-nuevo2:active, 
            .btn-nuevo2.active, 
            .open .dropdown-toggle.btn-nuevo2 { 
              background-image: none; 
            } 
             
            .btn-nuevo2.disabled, 
            .btn-nuevo2[disabled], 
            fieldset[disabled] .btn-nuevo2, 
            .btn-nuevo2.disabled:hover, 
            .btn-nuevo2[disabled]:hover, 
            fieldset[disabled] .btn-nuevo2:hover, 
            .btn-nuevo2.disabled:focus, 
            .btn-nuevo2[disabled]:focus, 
            fieldset[disabled] .btn-nuevo2:focus, 
            .btn-nuevo2.disabled:active, 
            .btn-nuevo2[disabled]:active, 
            fieldset[disabled] .btn-nuevo2:active, 
            .btn-nuevo2.disabled.active, 
            .btn-nuevo2[disabled].active, 
            fieldset[disabled] .btn-nuevo2.active { 
              background-color: #444444; 
              border-color: #444444; 
            } 
 
            .btn-nuevo2 .badge { 
              color: #444444; 
              background-color: #FFFFFF; 
            }
            
             .btn-nuevo3 {
                color: #fb1e1e;
                background-color: #ffffff;
                border-color: #d2d6de;
            }
            
            .btn-nuevo3:hover, 
            .btn-nuevo3:focus, 
            .btn-nuevo3:active, 
            .btn-nuevo3.active, 
            .open .dropdown-toggle.btn-nuevo3 { 
              color: #FFFFFF; 
              background-color: #dddddd; 
              border-color: #dddddd; 
              
            } 
             
            .btn-nuevo3:active, 
            .btn-nuevo3.active, 
            .open .dropdown-toggle.btn-nuevo3 { 
              background-image: none; 
            } 
             
            .btn-nuevo3.disabled, 
            .btn-nuevo3[disabled], 
            fieldset[disabled] .btn-nuevo3, 
            .btn-nuevo3.disabled:hover, 
            .btn-nuevo3[disabled]:hover, 
            fieldset[disabled] .btn-nuevo3:hover, 
            .btn-nuevo3.disabled:focus, 
            .btn-nuevo3[disabled]:focus, 
            fieldset[disabled] .btn-nuevo3:focus, 
            .btn-nuevo3.disabled:active, 
            .btn-nuevo3[disabled]:active, 
            fieldset[disabled] .btn-nuevo3:active, 
            .btn-nuevo3.disabled.active, 
            .btn-nuevo3[disabled].active, 
            fieldset[disabled] .btn-nuevo3.active { 
              background-color: #444444; 
              border-color: #444444; 
            } 
 


        </style>
        <style>
            .main-header,.main-sidebar,.left-side{position:fixed}
       
            .main-header {
            top: 0;
            right: 0;
            left: 0
            }
            .content-wrapper,
            .right-side {
            padding-top: 50px
            }
            
            @media (max-width:767px) {
            .content-wrapper,
            .right-side {
            padding-top: 100px
            }
            }
            
            .layout-boxed .wrapper {
            max-width: 100%
            }
            
            .wrapper {
            overflow: hidden
            
            .control-sidebar {
            position: fixed;
            height: 100%;
            overflow-y: auto;
            padding-bottom: 50px
            }       
        </style>
        <style> html, body { margin: 0; padding: 0; height: 100%; } </style>
        <style>

            .ui-autocomplete {
                position: absolute;
                z-index: 1000;
                cursor: default;
                padding: 0;
                margin-top: 2px;
                list-style: none;
                font-size: 11px;
                font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
                background-color: #ffffff;
                border: 1px solid #ccc;
                -webkit-border-radius: 5px;
                -moz-border-radius: 5px;
                border-radius: 5px;
                -webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                -moz-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);

                z-index: 1051 !important;    

            }

            input[type="search"]::-webkit-search-cancel-button {
                -webkit-appearance: searchfield-cancel-button;
            }

        </style>
    <style>
        .modal-header-danger{color:#fff;background-color:#e4002b}.modal-header-success{color:#fff;background-color:#008d4c}@media (min-height:500px){.modal-body .regtv{height:500px}}@media (min-height:800px){.modal-body .regtv{height:500px}}.modal-body .regtv{width:100%;height:500px}.espacio{height:10px}.espacio2{height:15px}.thumbnail_style{text-align:center;border:none}.caption h3{margin-top:-10px;font-size:24px}.caption p{color:#777;font-size:13px;padding:0px 25px 0px 25px}.caption a{color:#777;font-size:10px}#myWizard2 .form-control{border-radius:4px}#c-slider{margin:auto;width:100%;max-width:900px;position:relative;overflow:hidden}#slider{display:flex;width:300%}#slider section{width:100%}.btn-nuevo{color:#fff;background-color:#444;border-color:#444}.btn-nuevo.active,.btn-nuevo:active,.btn-nuevo:focus,.btn-nuevo:hover,.open .dropdown-toggle.btn-nuevo{color:#fff;background-color:#616161;border-color:#444}.btn-nuevo.active,.btn-nuevo:active,.open .dropdown-toggle.btn-nuevo{background-image:none}.btn-nuevo.disabled,.btn-nuevo.disabled.active,.btn-nuevo.disabled:active,.btn-nuevo.disabled:focus,.btn-nuevo.disabled:hover,.btn-nuevo[disabled],.btn-nuevo[disabled].active,.btn-nuevo[disabled]:active,.btn-nuevo[disabled]:focus,.btn-nuevo[disabled]:hover,fieldset[disabled] .btn-nuevo,fieldset[disabled] .btn-nuevo.active,fieldset[disabled] .btn-nuevo:active,fieldset[disabled] .btn-nuevo:focus,fieldset[disabled] .btn-nuevo:hover{background-color:#444;border-color:#444}
        .left-side,.main-header,.main-sidebar{position:fixed}.main-header{top:0;right:0;left:0;z-index:1000}.content-wrapper,.right-side{padding-top:50px;}@media (max-width:767px){.content-wrapper,.right-side{padding-top:100px;}}.layout-boxed .wrapper{max-width:100%}.wrapper{overflow:hidden;height:100%;overflow-y:auto;}
        html,body{margin:0;padding:0;height:100%}
        .ui-autocomplete{position:absolute;z-index:1000;cursor:default;padding:0;margin-top:2px;list-style:none;font-size:11px;font-family:"Helvetica Neue",Helvetica,Arial,sans-serif;background-color:#fff;border:1px solid #ccc;-webkit-border-radius:5px;-moz-border-radius:5px;border-radius:5px;-webkit-box-shadow:0 5px 10px rgba(0,0,0,.2);-moz-box-shadow:0 5px 10px rgba(0,0,0,.2);box-shadow:0 5px 10px rgba(0,0,0,.2);z-index:1051!important}input[type=search]::-webkit-search-cancel-button{-webkit-appearance:searchfield-cancel-button}.pagination>.active>a,.pagination>.active>a:focus,.pagination>.active>a:hover,.pagination>.active>span,.pagination>.active>span:focus,.pagination>.active>span:hover{z-index:3;color:#222d32;cursor:default;background-color:#c1c1c1;border-color:#ddd}.backpack-filter label{color:#868686;font-weight:600;text-transform:uppercase}.navbar-filters{min-height:25px;border-radius:0;margin-bottom:6px;margin-top:0;background:0 0;border-color:#f4f4f4;border:none}.navbar-filters .navbar-collapse{padding:0;border:0}.navbar-filters .navbar-toggle{padding:10px 15px;border-radius:0}.navbar-filters .navbar-brand{height:25px;padding:5px 15px;font-size:14px;text-transform:uppercase}@media (min-width:768px){.navbar-filters .navbar-nav>li>a{padding-top:5px;padding-bottom:5px}}@media (max-width:768px){.navbar-filters .navbar-nav{margin:0}}.navbar-filters .navbar-nav>.active>a,.navbar-filters .navbar-nav>.active>a:focus,.navbar-filters .navbar-nav>.active>a:hover,.navbar-filters .navbar-nav>.open>a,.navbar-filters .navbar-nav>.open>a:focus,.navbar-filters .navbar-nav>.open>a:hover,.navbar-filters li>a:active{background-color:#e4e7ea;border-radius:3px}.navbar-filters li{margin:0 2px}.navbar-filters li>a{border-radius:2px}.navbar-filters .nav.navbar-nav{float:none}.pb-0,.py-0{padding-bottom:0!important}.pt-0,.py-0{padding-top:0!important}.mb-0,.my-0{margin-bottom:0!important}.p-0{padding:0!important}.m-b-0{margin-bottom:0!important}.select2-container--default .select2-selection--single{border:1px solid #d2d6de;font-size:12px;padding:4px 6px}.select2-container--default .select2-selection--multiple .select2-selection__choice{color:#333}.input-group.date{width:320px;max-width:100%}.daterangepicker .dropdown-menu{z-index:3001!important}.select2-container--default .select2-search--dropdown .select2-search__field,.select2-container--default.select2-container--focus .select2-selection--multiple{border-color:#aaa!important}.form-inline .select2-container{display:inline-block}.select2-drop-active{border:none}.select2-container .select2-choice,.select2-container .select2-choices,.select2-container .select2-choices .select2-search-field input{border:none}.select2-container-active .select2-choice{border:none;box-shadow:none}.select2-container--default .select2-dropdown{margin-top:-2px;margin-left:-1px}.navbar-collapse.in{overflow-y:visible}.d-none{display:none!important}@media (min-width:992px){.d-lg-block{display:block!important}}@media (min-width:992px){.navbar-expand-lg .navbar-toggler{display:none}}.navbar-toggler{padding:.25rem .75rem;font-size:1.25rem;background-color:transparent;border:1px solid transparent;}.whiteinput{background-color:#fff!important;}
        .callout{border-radius:3px;margin:0 0 20px 0;padding:15px;border-left:0px solid #eee}.swal2-popup{font-size:1.5rem!important}.swal2-styled.swal2-confirm{background-color:#e4002b!important}
        .ocultar {display: none;}
    </style>
    
    <style>
        .swal2-html-container{
            text-align: justify!important;
        }
    </style>      
    </head>
    <body class="sidebar-collapse  skin-red sidebar-mini">

        <div class="wrapper">
            <!-- Header -->
            <?php include 'admin/header.php'; ?>
            <!-- Left side column. contains the logo and sidebar -->
           
            <?php

            $marketing="active";
            $tvreferidos= "active";
          
            include 'admin/main-sidebar.php';
            ?>
          


            <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">


                <div style="font-size:180%;"> COLABORADORES RPPR &nbsp <span style="font-size:80%;color:#DAD8D4"> | &nbsp <span style="font-size:80%;color:#8D8A80"> GENERAL </span></span> </div> 

                    <ol class="breadcrumb">
                        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
                        <li><a href="">Colaboradores</a></li>
                        <li class="active">RPPR</li>
                    </ol>


            </section>
            
            <!-- Main content -->
                <section class="content">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="box box-danger">
                                <div class="box-header">
                                    <table  style="width:90%;">
                                        <tr>
                                            <td style="width: 7%;"><h3 class="box-title">TELEFONO:</h3></td>
                                            <td style="width: 83%;">
                                                <div filter-name="BUSCAR" filter-type="text" class="input-group input-group-sm" style="width: 200px;">
                                                    <input type="text" name="lblmatriculausuario" value="<?php echo $matriculausuario;?>" hidden="" id="lblmatriculausuario" >
                                                    <input type="text" name="lblperfilusuario" value="<?php echo $nombacceso;?>" hidden="" id="lblperfilusuario" >
                                                    <input type="text" name="lblnombreusuario" value="<?php echo $nombreusuario;?>" hidden="" id="lblnombreusuario" >
                                                    
                                                    <input type="search" name="input_buscar" id="text-filter-BUSCAR" type="text"  value="" class="form-control" placeholder="">
    
                                                    <div class="input-group-btn">
                                                         <button type="button" id="btn-buscar" class="btn btn-default"><i class="fa fa-search"></i></button>
                                                    </div>
                                                </div>
                                            </td>
                                            
                                        </tr>
                                        <tr><td colspan="2">Total Registros: <span id="counttotal"></span></td></tr> 
                                        <tr><td colspan="2">Registros por página: <span id="count"></span></td></tr>
                                        <tr class="selectrow"><td colspan="2">N° Seleccionados: <span id="countselectedRows">0</span></td></tr>
                                    </table>
                                    <div class="box-tools pull-right">
                                        <button class="btn btn-success btn-sm ocultar" name="btnExportarLeads_v2" id="btnExportarLeads_v2" data-toggle="modal" data-target="#export_data" title="Exportar">Exportar Leads</button>
                                    </div>
                                </div>
                                <!-- /.box-header -->
    
                                <div class="box-body" id="vistaboy">
                                 <nav class="navbar navbar-default navbar-filters">
                                    <div class="container-fluid">
                                      <!-- Brand and toggle get grouped for better mobile display -->
                                
                                      
                                      <div class="navbar-header navbar-expand-lg">
                                          
                                            <a class="nav-item d-none d-lg-block navbar-brand"><span class="fa fa-filter"></span></a>
                                          <button class="navbar-toggler navbar-brand" type="button" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1" aria-controls="bs-example-navbar-collapse-1" aria-expanded="false" aria-label="Toggle filters">
                                            <span class="fa fa-filter"></span> Filtros
                                          </button>
                                
                                    </div>
                                
                                      <!-- Collect the nav links, forms, and other content for toggling -->
                                      <div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">
                                        <ul class="nav navbar-nav">
                                          <!-- THE ACTUAL FILTERS -->
                                        <li filter-name="ID" filter-type="text" class="dropdown">
                                        	<a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">ID <span class="caret"></span></a>
                                        	<div class="dropdown-menu p-0">
                                        		<div class="form-group backpack-filter m-b-0">
                                        			<div class="input-group">
                                        		        <input class="form-control pull-right" id="text-filter-ID" type="text" value="">
                                        		        <div class="input-group-addon text-filter-ID-clear-button">
                                        		          <a class="" href="#"><i class="fa fa-times"></i></a>
                                        		        </div>
                                        		    </div>
                                        		</div>
                                        	</div>
                                        </li>                                          
                                        <li filter-name="FECHAREGISTRO" filter-type="date_range" class="dropdown navocultar" style="display:none">
                                        	<a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">FECHAREGISTRO <span class="caret"></span></a>
                                        	<div class="dropdown-menu p-0">
                                        		<div class="form-group backpack-filter m-b-0">
                                        			<div class="input-group date">
                                        		        <div class="input-group-addon">
                                        		          <i class="fa fa-calendar"></i>
                                        		        </div>
                                        		        <input class="form-control pull-left whiteinput" id="daterangepicker-FECHAREGISTRO" type="text" readonly>
                                        		        <div class="input-group-addon daterangepicker-FECHAREGISTRO-clear-button">
                                        		          <a class="" href=""><i class="fa fa-times"></i></a>
                                        		        </div>
                                        		    </div>
                                        		</div>
                                        	</div>
                                        </li>
                                        <li filter-name="NOMBRES" filter-type="text" class="dropdown navocultar" style="display:none">
                                        	<a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">NOMBRES <span class="caret"></span></a>
                                        	<div class="dropdown-menu p-0">
                                        		<div class="form-group backpack-filter m-b-0">
                                        			<div class="input-group">
                                        		        <input class="form-control pull-right" id="text-filter-NOMBRES" type="text" value="">
                                        		        <div class="input-group-addon text-filter-NOMBRES-clear-button">
                                        		          <a class="" href="#"><i class="fa fa-times"></i></a>
                                        		        </div>
                                        		    </div>
                                        		</div>
                                        	</div>
                                        </li>
                                        <li filter-name="TELEFONO" filter-type="text" class="dropdown">
                                        	<a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">TELEFONO <span class="caret"></span></a>
                                        	<div class="dropdown-menu p-0">
                                        		<div class="form-group backpack-filter m-b-0">
                                        			<div class="input-group">
                                        		        <input class="form-control pull-right" id="text-filter-TELEFONO" type="text" value="">
                                        		        <div class="input-group-addon text-filter-TELEFONO-clear-button">
                                        		          <a class="" href="#"><i class="fa fa-times"></i></a>
                                        		        </div>
                                        		    </div>
                                        		</div>
                                        	</div>
                                        </li>
                                        <li filter-name="PRUEBA" filter-type="text" class="dropdown"></li>                                          
                                        <li><a href="#" id="remove_filters_button" class="hidden"><i class="fa fa-eraser"></i> Remover Filtros</a></li>
                                        </ul>
                                      </div><!-- /.navbar-collapse -->
                                    </div><!-- /.container-fluid -->
                                  </nav>                                    
                                    <div id="myGrid" style="height: 480px" class="ag-theme-fresh"></div>
                                    <div  id="ningunresultado"></div>
                                </div>
                                <!-- /.box-body -->
                                <div class="box-footer clearfix">
                                    <ul class="pagination pagination-sm no-margin pull-right" id="paginador"></ul>
                                </div>                                
                            </div>
                            <!-- /.box -->
                        </div>
                    </div>
                    <div class="test-header" style="display:none"><span id="selectedRows"></span></div>
                </section>
            <!-- /.content -->

            

            
        </div>
        <!-- /.content-wrapper -->
            <div class="control-sidebar-bg"></div>
        </div>
        <!-- ./wrapper -->
        
        <!-- jQuery v1.11 -->

        <script src="admin/bower_components/jquery/dist/jquery_v1.11.js" type="text/javascript"></script>
        <!-- jQuery UI 1.11.4 -->
        <script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
        <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
        <script>$.widget.bridge('uibutton', $.ui.button);</script>
        <!-- Bootstrap 3.3.7 -->
        <script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
        <!-- Select2 -->
        <script src="admin/bower_components/select2/dist/js/select2.full.min.js"></script>
        <!-- Sparkline -->
        <script src="admin/bower_components/jquery-sparkline/dist/jquery.sparkline.min.js"></script>

        <!-- jQuery Knob Chart -->
        <script src="admin/bower_components/jquery-knob/dist/jquery.knob.min.js"></script> 
        <!-- Bootstrap WYSIHTML5 -->
        <script src="admin/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js"></script>
        <!-- Slimscroll -->
        <script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
        <!-- FastClick -->
        <script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
        <!-- AdminLTE App -->
        <script src="admin/dist/js/adminlte.min.js"></script>


        <script src="admin/bower_components/bootstrap-table/dist/bootstrap-table.min.js" type="text/javascript"></script>
        <script src="admin/bower_components/ag-grid-master/dist/ag-grid.min.js" type="text/javascript"></script>
        <!-- InputMask -->
        <script src="admin/plugins/input-mask/jquery.inputmask.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.date.extensions.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.extensions.js"></script>

        <!-- date-range-picker -->
        <script src="admin/bower_components/moment/min/moment.min.js"></script>
        <script src="admin/bower_components/bootstrap-daterangepicker/daterangepicker.js"></script>
        <!-- bootstrap datepicker -->
        <script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
        <script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>
        <!-- bootstrap color picker -->
        <script src="admin/bower_components/bootstrap-colorpicker/dist/js/bootstrap-colorpicker.min.js"></script>
        <!-- bootstrap time picker -->
        <script src="admin/plugins/timepicker/bootstrap-timepicker.min.js"></script>
        <!-- Alertify -->
        <script src="admin/bower_components/alertifyjs/alertify.min.js" type="text/javascript"></script>
        <!-- SweetAlert -->
        <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <!-- GLOBALES -->
        <script>
            const perfilUsuario = $('#headerPerfilUsuario').val();
            
            let arregloGestoresCC;
        </script>
        <script>
        
            $('#cboGestorCALLMultiple').select2({
                placeholder: "Seleccionar Gestor",
                multiple: true,
                ajax: {
                    url: "ajax/selectGestor.php",
                    dataType: 'json',
                    delay: 250,
                    processResults: function (data, params) {
                        arregloGestoresCC = data;
                        
                        return {
                            results: data
                        };
                    },
                    cache: true
                }
            });
            
            $('#cbotipoAsignacion').on('change', function(){
                if($(this).val() == 'manual'){
                    $('.selectManual').removeClass('ocultar');
                    $('.selectAuto').addClass('ocultar');
                } else {
                    $('.selectManual').addClass('ocultar');
                    $('.selectAuto').removeClass('ocultar');
                }
            })
            /*
            $('#cboGestorCALLMultiple').select2({
                	allowClear: true,
					closeOnSelect: false,
					width: "100%",
					dropdownParent: $(this).parent('.form-group'),
	        	    placeholder: $(this).attr('placeholder'),
	        	                    language: {
                    errorLoading: function () {
                        return "La carga falló";
                    },
                    noResults: function () {
                        return "No hay resultado";
                    },
                    searching: function () {

                        return "Buscando..";
                    }
                },
                ajax: {
                    url: 'ajax/selectGestor.php',
                    dataType: 'json',
                    delay: 250,
                    processResults: function (data) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                }
            });
            */
        </script>
        <!--GRID GESTOR Y SUPERVISOR-->
        <script>
        var paginador;
		var totalPaginas;
		var itemsPorPagina = 50;
		var numerosPorPagina = 8;
		var filterscount=0;
	    var cadena='';
	    
            var columnDefs = [
                {
                    headerName: '',
                    field: 'Id',
                    width: 39,
                    pinned: 'left',
                    cellRenderer: function (params) {

                        if(params.data.Visibilidad=='NO'){
                             return '';
                        }else{
                             return '<a class="fa fa-edit edit_data" href="referidoRPPR.php?accion=actualizar&Id=' + params.value +'&rc=colaborador" title="Editar Solicitud" style="text-decoration:none;color:#4c4c4c" target="_blank"></a>';
                        }
                        
                        
                    }
                },
                {headerName: 'PRIMERNOMBRE', field: 'PrimerNombre', width: 150}, 
                {headerName: 'SEGUNDONOMBRE', field: 'SegundoNombre', width: 150}, 
                {headerName: 'APELLIDOPATERNO', field: 'ApellidoPaterno', width: 150}, 
                {headerName: 'APELLIDOMATERNO', field: 'ApellidoMaterno', width: 150}, 
                {headerName: 'TIPODOCUMENTO', field: 'TipoDocumento', width: 100}, 
                {headerName: 'DOCUMENTO', field: 'Documento', width: 100}, 
                {headerName: 'TELEFONO', field: 'Telefono', width: 100}, 
                {headerName: 'CORREO', field: 'Correo', width: 180}, 
                {headerName: 'FECHANACIMIENTO', field: 'FechaNacimiento', width: 150}, 
                {headerName: 'DIRECCION', field: 'Direccion', width: 200}, 
                {headerName: 'DISTRITO', field: 'Distrito', width: 100}, 
                {headerName: 'PROVINCIA', field: 'Provincia', width: 100}, 
                {headerName: 'DEPARTAMENTO', field: 'Departamento', width: 100}, 
                {headerName: 'CODUBIGEORENIEC', field: 'CodUbigeoReniec', width: 100}, 
                {headerName: 'FECHAHORAREG', field: 'FechaHoraREG', width: 160}, 
                {headerName: 'MATRICULAREG', field: 'MatriculaREG', width: 100}, 
                {headerName: 'ESTADOREFERIDO', field: 'EstadoReferido', width: 140}

            ];
            
            var gridOptions = {
                columnDefs: columnDefs,
                onPaginationChanged: onPaginationChanged,
                rowData: null,
                enableFilter: true,
                rowSelection: 'multiple',
                enableColResize: true,
                localeText: {
                    // for filter panel
                    page: 'página',
                    more: 'Más',
                    to: 'a',
                    of: 'de',
                    next: 'Siguiente',
                    last: 'Último',
                    first: 'Primero',
                    previous: 'Anterior',
                    loadingOoo: 'Cargando...',
                    // for set filter
                    selectAll: 'Seleccionar todo',
                    searchOoo: 'Buscando...',
                    blanks: 'Espacios en blanco',
                    // for number filter and text filter
                    filterOoo: 'Filtrar...',
                    applyFilter: 'Aplicar Filtro',
                    // for number filter
                    equals: 'Igual',
                    notEqual: 'No es igual',
                    lessThanOrEqual: 'Menor o igual',
                    greaterThanOrEqual: 'Mayor que o igual',
                    inRange: 'En el rango',
                    lessThan: 'Menos que',
                    greaterThan: 'Mas grande que',
                    // for text filter
                    contains: 'Contiene',
                    startsWith: 'Comienza con',
                    endsWith: 'Termina con',
                    notContains:'No contiene',
                    // the header of the default group column
                    group: 'Grupo',
                    // tool panel
                    columns: 'columnas',
                    rowGroupColumns: 'Grupo columnas',
                    rowGroupColumnsEmptyMessage: 'No hay resultado',
                    valueColumns: 'Columna de valor',
                    pivotMode: 'Modo pivote',
                    groups: 'grupos',
                    values: 'valor',
                    pivots: 'pivote',
                    valueColumnsEmptyMessage: 'No hay resultado',
                    pivotColumnsEmptyMessage: 'No hay resultado',
                    // other
                    noRowsToShow: '<div class="callout callout-danger">\n\
                                    <span class="pull-left">\n\
                                    <img src="admin/dist/img/noresults-img.png" style="width: 70%">\n\
                                    </span>\n\<h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>\n\
                                    <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>\n\
                                    <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>\n\
                                    <br></div>',
                    // enterprise menu
                    pinColumn: 'Aclar columna',
                    valueAggregation: 'Agregar valor',
                    autosizeThiscolumn: 'Auto tamaño esta columna ',
                    autosizeAllColumns: 'Auto tamaño todas columnas',
                    groupBy: 'Agrupar',
                    ungroupBy: 'Agrupar uno',
                    resetColumns: 'Restaurar Columnas',
                    expandAll: 'expandir todo',
                    collapseAll: 'desplegar todo',
                    toolPanel: 'Panel de Heramientas',
                    export: 'Exportar',
                    csvExport: 'Exportar CSV',
                    excelExport: 'Exportar Excel',
                    // enterprise menu pinning
                    pinLeft: 'Anclar a derecha',
                    pinRight: 'Anclar a izquierda',
                    noPin: 'Desanclar',
                    // enterprise menu aggregation and status panel
                    sum: 'Sumar',
                    min: 'Minimo',
                    max: 'Maximo',
                    first: 'Primero',
                            last: 'Ultimo',
                            none: 'Nada',
                    count: 'Contador',
                    average: 'Promedio',
                    // standard menu
                    copy: 'Copiar',
                    copyWithHeaders: 'Copiar Cabecera',
                    ctrlC: 'Ctrl+C',
                    paste: 'Pegar',
                    ctrlV: 'Ctrl+V'
                },
                enableSorting: true
            };
            
            function onPaginationChanged(params) {
                this.gridRowCount = params.api.paginationGetRowCount();
                $("#count").html(this.gridRowCount);
            }
            
            function onFilterChanged(value) {
               
                gridOptions.api.setQuickFilter(value);
                
                
            }

            function onSelectionChanged() {
                var selectedRows = gridOptionsSupervisor.api.getSelectedRows();
                var selectedRowsString = '';
                var countselectedRows=0;
                selectedRows.forEach(function(selectedRow, index) {
                    if (index!==0) {
                        selectedRowsString += ', ';
                        countselectedRows +=0;
                    }
                        selectedRowsString += selectedRow.Id;
                        countselectedRows +=1;
                });
                
                document.querySelector('#selectedRows').innerHTML = selectedRowsString;
                document.querySelector('#countselectedRows').innerHTML = countselectedRows;
            }            

            function listar(pagenum) {
                var cadena=Urlcadena();
			    var gridDiv = document.querySelector('#myGrid');
           
                new agGrid.Grid(gridDiv, gridOptions);
                
                ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
            }
            
            function refresh(){
                var pagenum= $(".pagination").find("li.active .page_link").html().valueOf()-1;
			    var cadena=Urlcadena();
			    var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,false);
            }          
            
            function creaPaginador(totalItems){
            	$(".pagination li").remove();
    			paginador = $(".pagination");
    			totalPaginas = Math.ceil(totalItems/itemsPorPagina);
    			$('<li><a href="#" class="first_link"><i class="fa fa-angle-double-left"></i></a></li>').appendTo(paginador);
    			if(totalPaginas>1){
    			$('<li><a href="#" class="prev_link"><i class="fa fa-angle-left"></i></a></li>').appendTo(paginador);
    			}
    			var pag = 0;
    			while(totalPaginas > pag){
    				$('<li><a href="#" class="page_link">'+(pag+1)+'</a></li>').appendTo(paginador);
    				pag++;
    			}
    
    			if(numerosPorPagina > 1){
    				$(".page_link").hide();
    				$(".page_link").slice(0,numerosPorPagina).show();
    			}
    			if(totalPaginas>1){
    				$('<li><a href="#" class="next_link"><i class="fa fa-angle-right"></i></a></li>').appendTo(paginador);
    			}
    			$('<li><a href="#" class="last_link"><i class="fa fa-angle-double-right"></i></a></li>').appendTo(paginador);
    
    			paginador.find(".page_link:first").addClass("active");
    			paginador.find(".page_link:first").parents("li").addClass("active");
    
    			paginador.find(".prev_link").hide();
    
    			paginador.find("li .page_link").click(function()
    			{
    				var irpagina =$(this).html().valueOf()-1;
    				cargaPagina(irpagina);
    				return false;
    			});
    
    			paginador.find("li .first_link").click(function()
    			{
    				var irpagina=0;
    				cargaPagina(irpagina);
    				return false;
    			});
    
    			paginador.find("li .prev_link").click(function()
    			{
    				var irpagina =parseInt(paginador.data("pag")) -1;
    				cargaPagina(irpagina);
    				return false;
    			});
    
    			paginador.find("li .next_link").click(function()
    			{
    				var irpagina =parseInt(paginador.data("pag")) +1;
    				cargaPagina(irpagina);
    				return false;
    			});
    
    			paginador.find("li .last_link").click(function()
    			{
    				var irpagina =totalPaginas -1;
    				cargaPagina(irpagina);
    				return false;
    			});
    
    			//cargaPagina(0);

		    }
		    
	        function cargaPagina(pagina){
	    
	            var cadena=Urlcadena();
			    var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagina,cadena,false);
               
    			if(pagina>= 1){
    				paginador.find(".prev_link").show();
    			}else{
    				paginador.find(".prev_link").hide();
    			}
    			if(pagina <(totalPaginas- numerosPorPagina)){
    				paginador.find(".next_link").show();
    			}else{
    				paginador.find(".next_link").hide();
    			}
    			paginador.data("pag",pagina);
    
    			if(numerosPorPagina>1){
    				$(".page_link").hide();
    				if(pagina < (totalPaginas- numerosPorPagina)){
    					$(".page_link").slice(pagina,numerosPorPagina + pagina).show();
    				}else{
    					if(totalPaginas > numerosPorPagina){
    						$(".page_link").slice(totalPaginas- numerosPorPagina).show();
    					}else{
    						$(".page_link").slice(0).show();
    					}
    
    				}
    			}
    			paginador.children().removeClass("active");
    			paginador.children().eq(pagina+2).addClass("active");


		    }
		
            function cambio(){
                $('#vistaboy').height(function (index, height) {
                return $(window).height() * 65 / 100;
                });
            
            }
        </script>
        <!--FILTROS Y CONFIGURACION GRID-->
        <script>
        $(document).ready(function () {
            var alterClass = function () {
                var ww = document.body.clientWidth;
                if (ww < 767) {
                    $('body').removeClass('sidebar-collapse');
                } else if (ww >= 768) {
                    $('body').addClass('sidebar-collapse');
                }
            };

            $(window).resize(function () {
                alterClass();
                //cambio();
            });
            //Fire it when the page first loads:
            alterClass();
            
        });    
    </script>
    <script>
      function normalizeAmpersand(string) {
        return string.replace(/&amp;/g, "&").replace(/amp%3B/g, "");
      }
      function Urlcadena(){
                var cadena='';
                var cadena2=new Object();
			    var filterscount=0;
                var registro=[];
                var valueFECHAREGISTRO=$("#daterangepicker-FECHAREGISTRO").val();
           
                var valueID=$("#text-filter-ID").val();
              
                var valueNOMBRES=$("#text-filter-NOMBRES").val();
              
                var valueTELEFONO=$("#text-filter-TELEFONO").val();
             
                cadena+='sortdatafield=FechaHoraCotizacion&sortorder=desc&';
                cadena2['sortdatafield']='FechaHoraREG';
                cadena2['sortorder']='desc';
                
                var valueMATRICULAREG=null;


                var valueBUSCAR=$("#text-filter-BUSCAR").val();
                cadena+='sortdatafield=FechaHoraREG&sortorder=desc&';

			     if(perfilUsuario == 17){
			        valueMATRICULAREG=$("#lblmatriculausuario").val();
			     } 

                if(valueID!==''){
                    registro.push({nombrecampo:'Id',valor:valueID,condicion:'CONTAINS',operador:0});
                }
                
                if(valueFECHAREGISTRO!==''){
                    var separador = " - ",
                    arrFechaRegistro = valueFECHAREGISTRO.split(separador);
                    registro.push({nombrecampo:'FechaHoraREG',valor:arrFechaRegistro[0].replace(new RegExp("/","g"),"-"),condicion:'GREATER_THAN_OR_EQUAL_TIME',operador:0});
                    registro.push({nombrecampo:'FechaHoraREG',valor:arrFechaRegistro[1].replace(new RegExp("/","g"),"-"),condicion:'LESS_THAN_OR_EQUAL_TIME',operador:0});
                }

                if(valueNOMBRES!==''){
                    registro.push({nombrecampo:'PrimerNombre',valor:valueNOMBRES,condicion:'CONTAINS',operador:0});
                }
                


                if(valueTELEFONO!==''){
                    registro.push({nombrecampo:'Telefono',valor:valueTELEFONO,condicion:'EQUAL',operador:0});
                }


                
                if(valueBUSCAR!==''){
                    registro.push({nombrecampo:'Telefono',valor:valueBUSCAR,condicion:'CONTAINS',operador:2});
                }


			     if(perfilUsuario == 17){
			      registro.push({nombrecampo:'MatriculaREG',valor:valueMATRICULAREG,condicion:'EQUAL',operador:1});
			     }                 
                
                
                console.log(registro);
                if(registro.length>0){
                    for(i=0;i<registro.length;i++){
                    cadena+='filtervalue'+i+'='+registro[i].valor+'&';
                    cadena+='filtercondition'+i+'='+registro[i].condicion+'&';
                    cadena+='filterdatafield'+i+'='+registro[i].nombrecampo+'&';
                    cadena+='filteroperator'+i+'='+registro[i].operador+'&'; 
                    
                    cadena2['filtervalue'+i]=registro[i].valor;
                    cadena2['filtercondition'+i]=registro[i].condicion;
                    cadena2['filterdatafield'+i]=registro[i].nombrecampo;
                    cadena2['filteroperator'+i]=registro[i].operador;
                    
                    } 

			        if(perfilUsuario == 17){
			             if(registro.length!=1){
			             $('#remove_filters_button').removeClass('hidden');
			             }
			        } else {
			            $('#remove_filters_button').removeClass('hidden');  
			        }                    
                    

                    
                }
                cadena+='filterscount='+registro.length;
                cadena2['filterscount']=registro.length;
                
                
                console.log(cadena);
                
                console.log(cadena2);
                
                 return cadena2;
      }
      function ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,activoPaginador){
                gridOptions.api.showLoadingOverlay();
                
                var objpagina={
                    array:'array3',
                    pagesize:itemsPorPagina,
                    pagenum:pagenum
                }
                
                var datos = {...objpagina, ...cadena};
                console.log(datos);
                
                 $.ajax({
                    type: 'POST',
                    dataType: 'json',
                    url: 'Controller/ControllerReferidoRPPR.php',
                    data:{function: JSON.stringify(datos)},
                    success: function (r) {
                        console.log(r);
                        
                    if (r[0].tipo == 0){
                          $("#ningunresultado").html(r[0].mensaje);
                          $("#ningunresultado").show("200");
                          $('#myGrid').hide("fast");
                         $("#counttotal").html(r[0].TotalRows);
                          $('#paginador').hide("fast");
                            gridOptions.api.hideOverlay();  
                    } else {
                        $('#myGrid').show(200);
                        $('#paginador').show(200);
                        $("#ningunresultado").hide("fast");
                           gridOptions.api.setRowData(r[0].Rows);
                          if(activoPaginador==true){
                          creaPaginador(r[0].TotalRows);
                          paginador.data("pag",pagenum);
                          }
                          $("#counttotal").html(r[0].TotalRows);
                    }
                       
                   }
                   
               });
            }
      // botón para eliminar todos los filtros
      jQuery(document).ready(function($) {
      	$("#remove_filters_button").click(function(e) {
      		e.preventDefault();
		    	// comportamiento por ajax
            	var pagenum=0;
            	var registro=[];
            	var cadena='';
            	var filterscount=0;
            	cadena='sortdatafield=FechaHoraCotizacion&sortorder=desc&';
            	cadena+='filterscount=0';
            	var valueMATRICULAREG=$("#lblmatriculausuario").val();

                var cadena2=new Object();
                
                // cadena2['sortdatafield']='FechaHoraREG';
                // cadena2['sortorder']='desc';
                // cadena2['filterscount']=0;
                
                if(perfilUsuario == 17){
                    
                    cadena2['filtervalue0']=valueMATRICULAREG;
                    cadena2['filtercondition0']='EQUAL';
                    cadena2['filterdatafield0']='MatriculaREG';
                    cadena2['filteroperator0']=1;
                    
                    cadena2['sortdatafield']='FechaHoraREG';
                    cadena2['sortorder']='desc';
                    cadena2['filterscount']=1;
                    
                    
                }else{
                    
                    cadena2['sortdatafield']='FechaHoraREG';
                    cadena2['sortorder']='desc';
                    cadena2['filterscount']=0;
                    
                }
                
			    var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena2,true);
  				// borrar todos los filtros
  				$(".navbar-filters li[filter-name]").trigger('filter:clear');
      	    });

        // hide the Remove filters button when no filter is active
        $(".navbar-filters li[filter-name]").on('filter:clear', function() {
          var anyActiveFilters = false;
          $(".navbar-filters li[filter-name]").each(function () {
            if ($(this).hasClass('active')) {
              anyActiveFilters = true;
              console.log('ACTIVE FILTER');
            }
          });

          if (anyActiveFilters == false) {
            $('#remove_filters_button').addClass('hidden');
          }
        });
      

 //Filtro ID
			$('#text-filter-ID').on('change', function(e) {
			    var pagenum=0;
			    var value = $(this).val();
			    var cadena=Urlcadena();
			    var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
            
				// marque este filtro como activo en los filtros en navbar-filters
				if (value!='') {
					$('li[filter-name=ID]').removeClass('active').addClass('active');
				} else {
					$('li[filter-name=ID]').trigger('filter:clear');
				}
		
			});
			$('li[filter-name=ID]').on('filter:clear', function(e) {
				$('li[filter-name=ID]').removeClass('active');
				$('#text-filter-ID').val('');
			});
			// Limpiar button ID
			$(".text-filter-ID-clear-button").click(function(e) {
				e.preventDefault();
				$('li[filter-name=ID]').trigger('filter:clear');
				$('#text-filter-ID').val('');
				$('#text-filter-ID').trigger('change');
			});	
				
				


			    //Filtro NOMBRES
			$('#text-filter-NOMBRES').on('change', function(e) {
			    var pagenum=0;
			    var value = $(this).val();
			    var cadena=Urlcadena();
			    var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
            
				// marque este filtro como activo en los filtros en navbar-filters
				if (value!='') {
					$('li[filter-name=NOMBRES]').removeClass('active').addClass('active');
				} else {
					$('li[filter-name=NOMBRES]').trigger('filter:clear');
				}
		
			});
			$('li[filter-name=NOMBRES]').on('filter:clear', function(e) {
				$('li[filter-name=NOMBRES]').removeClass('active');
				$('#text-filter-NOMBRES').val('');
			});
			// Limpiar button NOMBRES
			$(".text-filter-NOMBRES-clear-button").click(function(e) {
				e.preventDefault();
				$('li[filter-name=NOMBRES]').trigger('filter:clear');
				$('#text-filter-NOMBRES').val('');
				$('#text-filter-NOMBRES').trigger('change');
			});				


			    //Filtro TELEFONO
			$('#text-filter-TELEFONO').on('change', function(e) {
			    var pagenum=0;
			    var value = $(this).val();
			    var cadena=Urlcadena();
			    var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
            
				// marque este filtro como activo en los filtros en navbar-filters
				if (value!='') {
					$('li[filter-name=TELEFONO]').removeClass('active').addClass('active');
				} else {
					$('li[filter-name=TELEFONO]').trigger('filter:clear');
				}
		
			});
			$('li[filter-name=TELEFONO]').on('filter:clear', function(e) {
				$('li[filter-name=TELEFONO]').removeClass('active');
				$('#text-filter-TELEFONO').val('');
			});
			// Limpiar button TELEFONO
			$(".text-filter-TELEFONO-clear-button").click(function(e) {
				e.preventDefault();
				$('li[filter-name=TELEFONO]').trigger('filter:clear');
				$('#text-filter-TELEFONO').val('');
				$('#text-filter-TELEFONO').trigger('change');
			});


	

          //Filtro FECHAREGISTRO
        	function applyDateRangeFilterFECHAREGISTRO(start, end) {
          			if (start && end) {
          				var dates = {
        					'from': start.format('YYYY-MM-DD'),
        					'to': end.format('YYYY-MM-DD')
        				};
        				var value = JSON.stringify(dates);
          			} else {
          				//this change to empty string,because addOrUpdateUriParameter method just judgment string
          				var value = '';
          			}
        
        			// mark this filter as active in the navbar-filters
        			if (value!=='') {
        				$('li[filter-name=FECHAREGISTRO]').removeClass('active').addClass('active');
        			}
        			else
        			{
        				$('li[filter-name=FECHAREGISTRO]').trigger('filter:clear');
        			}
        			
        			
          		}

			var dateRangeInput = $('#daterangepicker-FECHAREGISTRO').daterangepicker({
				timePicker: false,
		        ranges: {
		            'Today': [moment().startOf('day'), moment().endOf('day')],
		            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
		            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
		            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
		            'This Month': [moment().startOf('month'), moment().endOf('month')],
		            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
		        },
				alwaysShowCalendars: true,
				autoUpdateInput: false
			});

			dateRangeInput.on('apply.daterangepicker', function(ev, picker) {
			applyDateRangeFilterFECHAREGISTRO(picker.startDate, picker.endDate);
			$(this).val(picker.startDate.format('YYYY/MM/DD') + ' - ' + picker.endDate.format('YYYY/MM/DD'));
				var pagenum=0;
			    var cadena=Urlcadena();
			    var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
			});
			/*
            dateRangeInput.on('cancel.daterangepicker', function(ev, picker) {
                $(this).val('');
            });
            */
			
			$('li[filter-name=FECHAREGISTRO]').on('hide.bs.dropdown', function () {
				if($('.daterangepicker').is(':visible'))
			    return false;
			});

			$('li[filter-name=FECHAREGISTRO]').on('filter:clear', function(e) {
				// console.log('daterangepicker filter cleared');
				//if triggered by remove filters click just remove active class,no need to send ajax
				$('li[filter-name=FECHAREGISTRO]').removeClass('active');
				$(this).val('');
				$('#daterangepicker-FECHAREGISTRO').val('');
			});

			// datepicker clear button
			$(".daterangepicker-FECHAREGISTRO-clear-button").click(function(e) {
				e.preventDefault();
				applyDateRangeFilterFECHAREGISTRO(null, null);
				$('li[filter-name=FECHAREGISTRO]').trigger('filter:clear');
				var pagenum=0;
			    var cadena=Urlcadena();
			    var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
			})



				
			//Filtro BUSCAR
			$('#text-filter-BUSCAR').on('change', function(e) {
			    var pagenum=0;
			    var value = $(this).val();
			    var cadena=Urlcadena();
			    var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
            
				// marque este filtro como activo en los filtros en navbar-filters
				/*
				if (value!='') {
					$('li[filter-name=CLIENTE]').removeClass('active').addClass('active');
				} else {
					$('li[filter-name=CLIENTE]').trigger('filter:clear');
				}
				*/
		
			});
			$('div[filter-name=BUSCAR]').on('filter:clear', function(e) {
				//$('li[filter-name=CLIENTE]').removeClass('active');
				$('#text-filter-BUSCAR').val('');
			});
			// Limpiar button BUSCAR				

          
      });
    </script>
    
  
        <!-- DOCUMENT READY -->
        <script>
            $(document).ready(function () {
                
                listar(0);

                $(window).resize(() => { alterClass(); });
                
                //Fire it when the page first loads:
                alterClass();
            });
    
        </script>
      
        <script>
            function alterClass() {
                var ww = document.body.clientWidth;
                if (ww < 767) {
                    $('body').removeClass('sidebar-collapse');

                } else if (ww >= 768) {
                    $('body').addClass('sidebar-collapse');

                }
            };
        </script>
        
        <script>
        // FUNCION PARA REFRESCAR LA PAGINA CADA 3 MINUTOS Y ESTAR ACTIVA
            document.addEventListener("DOMContentLoaded", function(){
            // Invocamos cada 3 minutos ;)
            const milisegundos = 3 *60000;
            setInterval(function(){
                // No esperamos la respuesta de la peticion porque no nos importa
                fetch("./ajax/refrescar.php");
            },milisegundos);
        });
        </script>

    </body>
</html>
