<?php
include('is_logged.php');
date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date){
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date){
    return date('Y-m-d', strtotime($date));
}

$ingresokit=0;
$ingresoextras=0;
$ingresototal=0;

require '../config/db.php';
require '../config/conexion.php';
require_once '../helper/helper_validacion.php';

//LOGS TRANSACCCIONALES
include 'log/insertLog.php'; //LOG TRANSAC
include 'log/insertLogCliente.php'; //LOG CLIENTE
include 'log/insertLogProsectoRP.php'; //LOG PROSPECTORP
include 'log/insertLogFacturacion.php'; //LOG FACTURACION
include 'log/insertLogAgenda.php'; //LOG AGENDA
include 'log/insertLogVenta.php'; //LOG VENTA

//include_once '../config/dbsec.php';
//include_once '../config/conexionsec.php';

$categoria=htmlspecialchars($_POST['lblcategoria']); //listo
$idprospectorp=htmlspecialchars(filter_var($_POST['lblidprospectorp'], FILTER_SANITIZE_NUMBER_INT));//listo
$gestor=htmlspecialchars($_POST['gestor']);//listo

$matricula=htmlspecialchars($_POST['lblmatricula']);//listo
$idusuario=htmlspecialchars(filter_var($_POST['lblidusuario'], FILTER_SANITIZE_NUMBER_INT));//listo
$nombcomercial=htmlspecialchars($_POST['lblnombcomercial']);//listo
$dc=htmlspecialchars($_POST['lbldc']);//listo
$jefeventa=htmlspecialchars($_POST['lbljefeventa']);//listo
$estadoprospecto=htmlspecialchars($_POST['lblestadoprospecto']);
$estadoventa=htmlspecialchars($_POST['lblestventa']);
$tipoventa=htmlspecialchars($_POST['lbltiventa']);
$segmento=htmlspecialchars($_POST['lblsegmento']);

$mesesautorizados=htmlspecialchars($_POST['lblmesesautorizados']);
$preciokit=htmlspecialchars($_POST['lblpreciokit']);
$totalextra=htmlspecialchars($_POST['lbltotalextra']);
$resumenventa=htmlspecialchars($_POST['lblresumenventa']);
$extraautorizado=htmlspecialchars($_POST['lblextraautorizado']);
$formadepago=htmlspecialchars($_POST['lblformadepago']);
//INFORMACION ADICIONAL DE LA VENTA AGREGADA POR PILOTO ZEROVISION
$lbltipokit=htmlspecialchars($_POST['lbltipokit']);
$lblclosingpack=htmlspecialchars($_POST['lblclosingpack']);
if(isset($_POST['lblprecioEspecial'])){
    $lblprecioEspecial=htmlspecialchars($_POST['lblprecioEspecial']);
} else {
    $lblprecioEspecial = null;
}
$lblCantExtras=htmlspecialchars($_POST['lblCantExtras']);
$lblresultadoScoring=htmlspecialchars($_POST['lblresultadoScoring']);
//INFORMACION ADICIONAL POR PILOTO CHECKIN;
//Nuevos campos VISITA CONCERTADA 18.02
//VISITA CONCERTADA - VALOR(SI O NO)
if(isset($_POST['hidVisitaConcertada'])){
    if($_POST['hidVisitaConcertada']=='' || empty($_POST['hidVisitaConcertada'])){
        $hidVisitaConcertada=NULL;   
    } else {
        $hidVisitaConcertada=htmlspecialchars($_POST['hidVisitaConcertada']);
    }
} else {
    $hidVisitaConcertada=NULL;   
}

//FECHA Y HORA VISITA CONCERTADA
if(isset($_POST['fechaVisitaConcertada'])){
    if($_POST['fechaVisitaConcertada']=='' || empty($_POST['fechaVisitaConcertada'])){
        $fechaVisitaConcertadaFinal=NULL;
    } else{
        $fechaVisitaConcertadaOriginal= htmlspecialchars($_POST['fechaVisitaConcertada']);
        $fechaVisitaConcertadaFinal= myUrlEncode($fechaVisitaConcertadaOriginal);
        $fechaVisitaConcertadaFinal= format_date_Y_mm_dd(str_replace('/', '-', $fechaVisitaConcertadaFinal));
    }
} else {
    $fechaVisitaConcertadaFinal=NULL;
}

if(isset($_POST['horaVisitaConcertada'])){
    if($_POST['horaVisitaConcertada']=='' || empty($_POST['horaVisitaConcertada'])){
        $horaVisitaConcertada=NULL;
    } else{
        $horaVisitaConcertada=htmlspecialchars($_POST['horaVisitaConcertada']);
    }
} else {
    $horaVisitaConcertada=NULL;
}


//FIN INFORMACION ADICIONAL

//CODIGO SCORING
if(isset($_POST['valcodigoOperacionScoring'])){
    if($_POST['valcodigoOperacionScoring']=='' || empty($_POST['valcodigoOperacionScoring'])){
        $valcodigoOperacionScoring=NULL;   
    } else {
        $valcodigoOperacionScoring=htmlspecialchars($_POST['valcodigoOperacionScoring']);
    }
} else {
    $valcodigoOperacionScoring=NULL;   
}

//FIN CODIGO SCORING
$hidGGCC=htmlspecialchars($_POST['hidGGCC']);
$hidden_HCertificacion=htmlspecialchars($_POST['hidden_HCertificacion']);
$lblformapagocuota=htmlspecialchars($_POST['lblformapagocuota']);

$PAI=htmlspecialchars($_POST['lblPAI']);
    if($PAI=="PAI 30x36"){
    
    $ingresokit=round((($preciokit+(1080*0.729))/1.18),2);
    $ingresoextras=round(($totalextra/1.18),2);
    $ingresototal=($ingresokit+$ingresoextras);
    
    }
    else if($PAI=="PAI 30x48"){
    $ingresokit=round((($preciokit+(1440*0.663))/1.18),2);
    $ingresoextras=round(($totalextra/1.18),2);
    $ingresototal=($ingresokit+$ingresoextras);
    
    }     
    else{
    
    $ingresokit=round((($preciokit)/1.18),2);
    $ingresoextras=round(($totalextra/1.18),2);
    $ingresototal=($ingresokit+$ingresoextras);
    }

$comentarioprospecto=htmlspecialchars($_POST['lblcomentarioprospecto']);
//---Fechas_de_registros--
$GestionOrigen = 'VENTA';
$fecharegistro = date("Y-m-d H:i:s");
$fechaventa=date("Y-m-d");
//ARRAY DATOS DEL PROSPECTO A MODIFICAR
$arrayProspectoRP = consultaProspectoRP($idprospectorp);
//

if(isset($_POST['lbltipocamarakit'])){
    if($_POST['lbltipocamarakit']=='' || empty($_POST['lbltipocamarakit'])){
        $lbltipocamarakit=NULL;
    } else{
        $lbltipocamarakit=htmlspecialchars($_POST['lbltipocamarakit']);
    }
} else {
    $lbltipocamarakit=NULL;
}

if(isset($_POST['lblsegundaalarma'])){
    if($_POST['lblsegundaalarma']=='' || empty($_POST['lblsegundaalarma'])){
        $lblsegundaalarma=NULL;
    } else{
        $lblsegundaalarma=htmlspecialchars($_POST['lblsegundaalarma']);
    }
} else {
    $lblsegundaalarma=NULL;
}

//INTERACCIONES DE AUDITORIA
$lblIteraccionAttec=htmlspecialchars($_POST['lblIteraccionAttec']);

if(isset($_POST['lblcomentario_comercial'])){
    $lblcomentario_comercial=htmlspecialchars($_POST['lblcomentario_comercial']);
} else {
    $lblcomentario_comercial = null;
}

if(isset($_POST['lblhorariosugerido2'])){
    $lblhorariosugerido2=htmlspecialchars($_POST['lblhorariosugerido2']);
} else {
    $lblhorariosugerido2 = null;
}



if($categoria=='ProspectoRP'){
    
    //---Cliente--
    $idcliente=$_POST['lblidcliente'];
    $nombcliente=$_POST['lblnombcliente'];
    $correo=$_POST['lblcorreo'];
    $direccion=$_POST['lbldireccion'];
    $distrito=$_POST['lbldistrito'];
    $telefonouno=$_POST['lblmovil'];
    $telefonodos=$_POST['lblfijo'];
    //---Termina Cliente---
    
    //CREACION DEL ARRAY QUE TRAE DATOS DEL CLIENTE
    $arrayCliente = consultaCliente($idcliente);
    
    //ACTUALIZA DATOS DEL CLIENTE RP
    if($telefonodos=="" || empty($telefonodos)){
        $affectedrowCliente=registrarCliente($distrito,$nombcliente,$telefonouno,NULL,$correo,$direccion,NULL,$segmento,$idcliente,NULL);
    } else {
        $affectedrowCliente=registrarCliente($distrito,$nombcliente,$telefonouno,$telefonodos,$correo,$direccion,NULL,$segmento,$idcliente,NULL);
    }
    

    $affectedrowProspectoRP=updateProspectoRP($idusuario,$idcliente,$matricula,$nombcomercial,$dc,$jefeventa,$categoria,$tipoventa,$segmento,$preciokit,$totalextra,$estadoprospecto,NULL,$extraautorizado,$mesesautorizados,NULL,$formadepago,$PAI,$resumenventa,$comentarioprospecto,$lbltipokit,$lblclosingpack,$lblprecioEspecial,$lblCantExtras,$lblresultadoScoring,$valcodigoOperacionScoring,$hidGGCC,$hidden_HCertificacion,NULL,$lblformapagocuota,$hidVisitaConcertada,$fechaVisitaConcertadaFinal,$horaVisitaConcertada,$idprospectorp);    
    
    
    
    //INSERTA LOG DE SEGURIDA POR TRANSACCION (MODIFICAR)
    
    if($affectedrowCliente > 0 || $affectedrowProspectoRP > 0 ){

        $REMOTE_ADDR=$_SERVER['REMOTE_ADDR'];
        $usuariosesion=$_SESSION['usuariosesion'];
        $REQUEST_URI=$_SERVER['REQUEST_URI'].'=>IdProspectoRP='.$idprospectorp;
        $Acceso='Modificar';
        $HTTP_USER_AGENT=$_SERVER['HTTP_USER_AGENT'];
        
        try {
                
          $stmt = $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
          $stmt->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistro, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
          $stmt->execute();
          
          $idLogSeg = $con->insert_id;
          
          $stmt->close();
          
        } catch (\Exception $e) {
          echo $e->getMessage();
        }

        if($affectedrowCliente > 0){
            insertarLog($idLogSeg, $arrayCliente);
        }
        if($affectedrowProspectoRP > 0){
            insertLogProspectoRP($idLogSeg, $arrayProspectoRP);
        }
        echo 5;
    }else{
     echo 20; 
    }
}
else if($categoria=='Ficha'){
    $n590=$_POST['lbl590'];
    //---Cliente--
    $idcliente=$_POST['lblidcliente'];
    $nombcliente=$_POST['lblnombcliente'];
    $correo=$_POST['lblcorreo'];
    $direccion=$_POST['lbldireccion'];
    $distrito=$_POST['lbldistrito'];
    $telefonouno=$_POST['lblmovil'];
    $telefonodos=$_POST['lblfijo'];
    //---Termina Cliente---
    
    //NUEVOS DATOS PARA EL DETALLE EXTRAS Y REGALOS
    $lblCantRegalos = $_POST['lblCantRegalos'];
    $lbltotalcuota = $_POST['lbltotalcuota'];
    $lblDescuentoCuota = $_POST['lblDescuentoCuota'];
    //NUEVAS DATOS PARA LA INFORMACION DE LA VENTA PILOTO NUEVO CARRITO DE COMPRA KIT, EXTRA Y REGALO (26.10.2021)
    $lblcategoriaprecio = $_POST['lblcategoriaprecio'];

    if(isset($_POST['lblRenove'])){
        if($_POST['lblRenove']=='' || empty($_POST['lblRenove'])){
            $lblRenove=NULL;
        } else{
            $lblRenove=htmlspecialchars($_POST['lblRenove']);
        }
    } else {
        $lblRenove=NULL;
    }
    
    if(isset($_POST['lblRcompetencia'])){
        if($_POST['lblRcompetencia']=='' || empty($_POST['lblRcompetencia'])){
            $lblRcompetencia=NULL;
        } else{
            $lblRcompetencia=htmlspecialchars($_POST['lblRcompetencia']);
        }
    } else {
        $lblRcompetencia=NULL;
    }
    
    if(isset($_POST['lblRvencimiento'])){
        if($_POST['lblRvencimiento']=='' || empty($_POST['lblRvencimiento'])){
            $lblRvencimiento=NULL;
        } else{
            $lblRvencimiento=htmlspecialchars($_POST['lblRvencimiento']);
        }
    } else {
        $lblRvencimiento=NULL;
    }
    
    
    
    //CREACION DEL ARRAY QUE TRAE DATOS DEL CLIENTE
    $arrayCliente = consultaCliente($idcliente);
    

    try{
        $stmtSco = $con->prepare( "SELECT t.FechaHoraReg,t.Servicio,t.NumeroOperacion,t.CodigoModelo,t.TipoDocumento,t.NumeroDocumento,t.ApellidoPaterno,t.ApellidoMaterno,t.Nombres,t.RazonSocial,t.Explicacion,t.Accion,t.Score,t.Riesgo,t.Conclusion,t.ultPeriodo,t.TotalultPeriodo,t.DeudaSoles,t.DeudaDolares,t.TotalDeudaSoles,t.TotalDeudaDolares,t.CodigoOficina,t.GestorOrigen,t.NombreGestorOrigen,t.Integrante,t.TipoPersona,t.CantidadDocumentosMorosos,t.ScoreRiesgo_PN,t.PredictorIngresos_IP,t.ScoreRiesgo_PJ,t.MontoMorosoSoles,t.MontoMorosoDolares,t.PerfilScoring,t.CodGenVen,t.Departamental,t.Provincial,t.Distrital,t.Ubigeo,t.Area,t.Segmento,t.NodoDescripcion,t.NodoAccion FROM dbVENTAS.tbltmpscoringRP t WHERE t.NumeroOperacion= ?");
        $stmtSco->bind_param('s', $valcodigoOperacionScoring);
        $stmtSco->execute();
        $stmtSco->store_result();
        $stmtSco->bind_result($FechaHoraReg,
                $Servicio,
                $NumeroOperacion,
                $CodigoModelo,
                $TipoDocumento,
                $NumeroDocumento,
                $ApellidoPaterno,
                $ApellidoMaterno,
                $Nombres,
                $RazonSocial,
                $Explicacion,
                $Accion,
                $Score,
                $Riesgo,
                $Conclusion,
                $ultPeriodo,
                $TotalultPeriodo,
                $DeudaSoles,
                $DeudaDolares,
                $TotalDeudaSoles,
                $TotalDeudaDolares,
                $CodigoOficina,
                $GestorOrigen,
                $NombreGestorOrigen,
                $Integrante,
                $TipoPersona,
                $CantidadDocumentosMorosos,
                $ScoreRiesgo_PN,
                $PredictorIngresos_IP,
                $ScoreRiesgo_PJ,
                $MontoMorosoSoles,
                $MontoMorosoDolares,
                $PerfilScoring,
                $CodGenVen,
                $Departamental,
                $Provincial,
                $Distrital,
                $Ubigeo,
                $Area,
                $SegmentoI,
                $NodoDescripcion,
                $NodoAccion);
        $numrowsScoring=$stmtSco->num_rows;        
        $stmtSco->fetch();
        $stmtSco->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
    

   try{
        $stmtValP = $con->prepare( "SELECT 1 FROM dbVENTAS.tblventa v WHERE v.IdProspectoRP= ?");
        $stmtValP->bind_param('i', $idprospectorp);
        $stmtValP->execute();
        $stmtValP->store_result();
        $stmtValP->bind_result($num);
        $numrows=$stmtValP->num_rows;
        $stmtValP->fetch();       
        $stmtValP->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }    
    
    
    //VERIFICA QUE EXISTA EL ID PROSPECTO EN LA TABLA VENTA
    if($numrowsScoring>0){
        if($numrows>0){
          echo 2;
        }else{

            $IdConsultaScoring=insertarScoring($FechaHoraReg,$Servicio,$NumeroOperacion,$CodigoModelo,$TipoDocumento,$NumeroDocumento,$ApellidoPaterno,$ApellidoMaterno,$Nombres,$RazonSocial,$Explicacion,$Accion,$Score,$Riesgo,$Conclusion,$ultPeriodo,$TotalultPeriodo,$DeudaSoles,$DeudaDolares,$TotalDeudaSoles,$TotalDeudaDolares,$CodigoOficina,$GestorOrigen,$NombreGestorOrigen,$Integrante,$TipoPersona,$CantidadDocumentosMorosos,$ScoreRiesgo_PN,$PredictorIngresos_IP,$ScoreRiesgo_PJ,$MontoMorosoSoles,$MontoMorosoDolares,$PerfilScoring,$CodGenVen,$Departamental,$Provincial,$Distrital,$Ubigeo,$Area,$SegmentoI,$NodoDescripcion,$NodoAccion);
            $IdDocRP=insertarDocumento($TipoDocumento,$NumeroDocumento,$fecharegistro);
            
             
            //ACTUALIZA DATOS DEL CLIENTE RP
            if($telefonodos=="" || empty($telefonodos)){

                //VALIDA QUE HUBO UNA ACTUALIZACION EN LA TABLA CLIENTES
                $affectedrowCliente=registrarCliente($distrito,$nombcliente,$telefonouno,NULL,$correo,$direccion,$IdDocRP,$segmento,$idcliente,NULL);
                
            }
            else{
                //VALIDA QUE HUBO UNA ACTUALIZACION EN LA TABLA CLIENTES
                $affectedrowCliente=registrarCliente($distrito,$nombcliente,$telefonouno,$telefonodos,$correo,$direccion,$IdDocRP,$segmento,$idcliente,NULL);

            }  
            
            $affectedrowProspectoRP=updateProspectoRP($idusuario,$idcliente,$matricula,$nombcomercial,$dc,$jefeventa,$categoria,$tipoventa,$segmento,$preciokit,$totalextra,$estadoprospecto,$estadoventa,$extraautorizado,$mesesautorizados,$n590,$formadepago,$PAI,$resumenventa,$comentarioprospecto,$lbltipokit,$lblclosingpack,$lblprecioEspecial,$lblCantExtras,$lblresultadoScoring,$valcodigoOperacionScoring,$hidGGCC,$hidden_HCertificacion,$IdConsultaScoring,$lblformapagocuota,$hidVisitaConcertada,$fechaVisitaConcertadaFinal,$horaVisitaConcertada,$idprospectorp);
            

            //INSERTA DATOS DEL PROSPECTORP EN LA TABLA VENTAS
            $arrayVenta = consultaVentaIProspecto();
            $idVen= insertarVenta();
            
            if($idVen == 'error'){
                die('error');
            }
            
            //PROCECSAR LA INFORMACION DEL DETALLE EXTRA Y REGALOS
            $detalleExtras = $_POST['detalleExtras'];
            $detalleRegalos = $_POST['detalleRegalos'];
            $detalleGeneral = $_POST['detalleGeneral'];
            
            $resultadoRegistroRegalos = registrarExtrasRegalos($detalleExtras, $detalleRegalos, $detalleGeneral);
            
            $arrayAgenda=consultaAgendaI();
            //INSERTA DATOS DEL PROSPECTORP EN LA TABLA AGENDA
           try{
                $stmtAgenda = $con->prepare( "INSERT INTO dbVENTAS.tblagenda(IdVenta,FechaHoraREG, GestionOrigen) VALUES (?,?, ?)");
                $stmtAgenda->bind_param('iss', $idVen,$fecharegistro,$GestionOrigen);
                $stmtAgenda->execute();
                $stmtAgenda->close();
        
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            }             
            
            $arrayFactu=consultaFacturacionI();
            //INSERTA DATOS DEL PROSPECTORP EN LA TABLA FACTURACION
           try{
                $stmtFact = $con->prepare( "INSERT INTO dbVENTAS.tblfacturacion(IdVenta, FechaHoraREG, GestionOrigen) VALUES (?,?,?)");
                $stmtFact->bind_param('iss', $idVen,$fecharegistro,$GestionOrigen);
                $stmtFact->execute();
                $stmtFact->close();
        
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            }
            
          
           //ACTUALIZAR IDVENTA EN CERTIFICACION
            registrarCertificacion($idVen,$fecharegistro,$lblcomentario_comercial,$lblhorariosugerido2,$gestor);
            
            
            //ACTUALIZAR IDVENTA EN SCORING
           try{
                $stmtIDSco = $con->prepare( "UPDATE dbVENTAS.tbltmpscoring t SET t.IdVenta=? WHERE t.IdConsultaScoring=?");
                $stmtIDSco->bind_param('ii', $idVen,$IdConsultaScoring);
                $stmtIDSco->execute();
                $stmtIDSco->close();
        
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            }             
            
            if($affectedrowCliente > 0 || $affectedrowProspectoRP > 0 ){
            //GENERA LOG DE PROSPECTO HISTORICO
           try{
                $stmtProshist = $con->prepare( "INSERT INTO dbVENTAS.tblprospectorphist(IdProspectoRP,FechaHoraREG,EstadoProspecto,TipoVenta,CategoriaVenta,Gestor) values(?,?,?,?,?,?)");
                $stmtProshist->bind_param('isssss', $idprospectorp,$fecharegistro,$estadoprospecto,$tipoventa,$categoria,$gestor);
                $stmtProshist->execute();
                $stmtProshist->close();
        
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            }            
            
            //GENERA LOG DE SEGURIDAD
            $REMOTE_ADDR=$_SERVER['REMOTE_ADDR'];
            $usuariosesion=$_SESSION['usuariosesion'];
            $REQUEST_URI=$_SERVER['REQUEST_URI'].'=>IdVenta='.$idVen;
            $Acceso='Registrar';
            $HTTP_USER_AGENT=$_SERVER['HTTP_USER_AGENT'];
            
            try {
                    
              $stmt = $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
              $stmt->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistro, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
              $stmt->execute();
              
              $idLogSeg = $con->insert_id;
              
              $stmt->close();
              
            } catch (\Exception $e) {
              echo $e->getMessage();
            }            
           
            //ENVIA RESULTADO    
            echo 6;
            
            if($affectedrowCliente > 0){
                insertarLog($idLogSeg, $arrayCliente);
            }
            if($affectedrowProspectoRP > 0){
                insertLogProspectoRP($idLogSeg, $arrayProspectoRP);
            }
            
            insertLogVentaIProspecto($idLogSeg, $arrayVenta);
    
            insertLogAgendaI($idLogSeg, $arrayAgenda);
            insertLogFacutracionI($idLogSeg, $arrayFactu);
            
            }
    
        }
    
    }else{
        echo 4;
    }
}
else if($categoria=='Delegacion'){
    $n590=$_POST['lbl590'];
    //---Cliente--
    $idcliente=$_POST['lblidcliente'];
    $nombcliente=$_POST['lblnombcliente'];
    $correo=$_POST['lblcorreo'];
    $direccion=$_POST['lbldireccion'];
    $distrito=$_POST['lbldistrito'];
    $telefonouno=$_POST['lblmovil'];
    $telefonodos=$_POST['lblfijo'];
    //---Termina Cliente---    
    
    //---Agenda--
    $instaladox=$_POST['lblinstaladox'];
    $tecnico=$_POST['lbltecnico'];
    $finstalacion=$_POST['lblfinstalacion'];
    $hinstalacion=$_POST['lblhinstalacion'];
    $fechaconvert=  myUrlEncode($finstalacion);
    $fechagrabar=  format_date_Y_mm_dd(str_replace('/', '-', $fechaconvert));
    $horaconvert=  myUrlEncode($hinstalacion);
    $horagrabar=  date("H:i", strtotime(str_replace("+"," ",$horaconvert)));
    $horagrabarcomparar=  date("H:i:s", strtotime(str_replace("+"," ",$horaconvert)));
    $comentarioagenda=$_POST['lblcomentarioagenda'];
    //---Termina Agenda---
    
    //NUEVO
    $ncontrato=$_POST['lblncontrato'];
    
    if($estadoventa=="InstaladaDEL" && isset($ncontrato)){
       if(validarNContrato($ncontrato) > 0){
            die('9');
        }
    }
    //NUEVOS DATOS PARA EL DETALLE EXTRAS Y REGALOS
    $lblCantRegalos = $_POST['lblCantRegalos'];
    $lbltotalcuota = $_POST['lbltotalcuota'];
    $lblDescuentoCuota = $_POST['lblDescuentoCuota'];
    //NUEVAS DATOS PARA LA INFORMACION DE LA VENTA PILOTO NUEVO CARRITO DE COMPRA KIT, EXTRA Y REGALO (26.10.2021)
    $lblcategoriaprecio = $_POST['lblcategoriaprecio'];
    
    if(isset($_POST['lblRenove'])){
        if($_POST['lblRenove']=='' || empty($_POST['lblRenove'])){
            $lblRenove=NULL;
        } else{
            $lblRenove=htmlspecialchars($_POST['lblRenove']);
        }
    } else {
        $lblRenove=NULL;
    }
    
    if(isset($_POST['lblRcompetencia'])){
        if($_POST['lblRcompetencia']=='' || empty($_POST['lblRcompetencia'])){
            $lblRcompetencia=NULL;
        } else{
            $lblRcompetencia=htmlspecialchars($_POST['lblRcompetencia']);
        }
    } else {
        $lblRcompetencia=NULL;
    }
    
    if(isset($_POST['lblRvencimiento'])){
        if($_POST['lblRvencimiento']=='' || empty($_POST['lblRvencimiento'])){
            $lblRvencimiento=NULL;
        } else{
            $lblRvencimiento=htmlspecialchars($_POST['lblRvencimiento']);
        }
    } else {
        $lblRvencimiento=NULL;
    }
    
    
    //CREACION DEL ARRAY QUE TRAE DATOS DEL CLIENTE
    $arrayCliente = consultaCliente($idcliente);
    
    //VERIFICA QUE EXISTA EN EL SCORING TEMPORAL
   try{
        $stmtSco = $con->prepare( "SELECT t.FechaHoraReg,t.Servicio,t.NumeroOperacion,t.CodigoModelo,t.TipoDocumento,t.NumeroDocumento,t.ApellidoPaterno,t.ApellidoMaterno,t.Nombres,t.RazonSocial,t.Explicacion,t.Accion,t.Score,t.Riesgo,t.Conclusion,t.ultPeriodo,t.TotalultPeriodo,t.DeudaSoles,t.DeudaDolares,t.TotalDeudaSoles,t.TotalDeudaDolares,t.CodigoOficina,t.GestorOrigen,t.NombreGestorOrigen,t.Integrante,t.TipoPersona,t.CantidadDocumentosMorosos,t.ScoreRiesgo_PN,t.PredictorIngresos_IP,t.ScoreRiesgo_PJ,t.MontoMorosoSoles,t.MontoMorosoDolares,t.PerfilScoring,t.CodGenVen,t.Departamental,t.Provincial,t.Distrital,t.Ubigeo,t.Area,t.Segmento,t.NodoDescripcion,t.NodoAccion FROM dbVENTAS.tbltmpscoringRP t WHERE t.NumeroOperacion= ?");
        $stmtSco->bind_param('s', $valcodigoOperacionScoring);
        $stmtSco->execute();
        $stmtSco->store_result();
        $stmtSco->bind_result($FechaHoraReg,
                $Servicio,
                $NumeroOperacion,
                $CodigoModelo,
                $TipoDocumento,
                $NumeroDocumento,
                $ApellidoPaterno,
                $ApellidoMaterno,
                $Nombres,
                $RazonSocial,
                $Explicacion,
                $Accion,
                $Score,
                $Riesgo,
                $Conclusion,
                $ultPeriodo,
                $TotalultPeriodo,
                $DeudaSoles,
                $DeudaDolares,
                $TotalDeudaSoles,
                $TotalDeudaDolares,
                $CodigoOficina,
                $GestorOrigen,
                $NombreGestorOrigen,
                $Integrante,
                $TipoPersona,
                $CantidadDocumentosMorosos,
                $ScoreRiesgo_PN,
                $PredictorIngresos_IP,
                $ScoreRiesgo_PJ,
                $MontoMorosoSoles,
                $MontoMorosoDolares,
                $PerfilScoring,
                $CodGenVen,
                $Departamental,
                $Provincial,
                $Distrital,
                $Ubigeo,
                $Area,
                $SegmentoI,
                $NodoDescripcion,
                $NodoAccion);
        $numrowsScoring=$stmtSco->num_rows;        
        $stmtSco->fetch();
        $stmtSco->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
    
    
    
    //VERIFICA QUE EXISTA EL ID PROSPECTO EN LA TABLA VENTA
   try{
        $stmtValP = $con->prepare( "SELECT 1 FROM dbVENTAS.tblventa v WHERE v.IdProspectoRP= ?");
        $stmtValP->bind_param('i', $idprospectorp);
        $stmtValP->execute();
        $stmtValP->store_result();
        $stmtValP->bind_result($num);
        $numrows=$stmtValP->num_rows;
        $stmtValP->fetch();       
        $stmtValP->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }      

if($numrowsScoring>0){
    if($numrows>0){
      echo 2;
    }else{

            $IdConsultaScoring=insertarScoring($FechaHoraReg,$Servicio,$NumeroOperacion,$CodigoModelo,$TipoDocumento,$NumeroDocumento,$ApellidoPaterno,$ApellidoMaterno,$Nombres,$RazonSocial,$Explicacion,$Accion,$Score,$Riesgo,$Conclusion,$ultPeriodo,$TotalultPeriodo,$DeudaSoles,$DeudaDolares,$TotalDeudaSoles,$TotalDeudaDolares,$CodigoOficina,$GestorOrigen,$NombreGestorOrigen,$Integrante,$TipoPersona,$CantidadDocumentosMorosos,$ScoreRiesgo_PN,$PredictorIngresos_IP,$ScoreRiesgo_PJ,$MontoMorosoSoles,$MontoMorosoDolares,$PerfilScoring,$CodGenVen,$Departamental,$Provincial,$Distrital,$Ubigeo,$Area,$SegmentoI,$NodoDescripcion,$NodoAccion);
            $IdDocRP=insertarDocumento($TipoDocumento,$NumeroDocumento,$fecharegistro);
           
            //ACTUALIZA DATOS DEL PROSPECTORP EN LA TABLA PROSPECTORP
            $affectedrowProspectoRP=updateProspectoRP($idusuario,$idcliente,$matricula,$nombcomercial,$dc,$jefeventa,$categoria,$tipoventa,$segmento,$preciokit,$totalextra,$estadoprospecto,$estadoventa,$extraautorizado,$mesesautorizados,$n590,$formadepago,$PAI,$resumenventa,$comentarioprospecto,$lbltipokit,$lblclosingpack,$lblprecioEspecial,$lblCantExtras,$lblresultadoScoring,$valcodigoOperacionScoring,$hidGGCC,$hidden_HCertificacion,$IdConsultaScoring,$lblformapagocuota,$hidVisitaConcertada,$fechaVisitaConcertadaFinal,$horaVisitaConcertada,$idprospectorp);    


        
        //ACTUALIZA DATOS DEL CLIENTE
        if($telefonodos=="" || empty($telefonodos)){
            //VALIDA QUE HUBO UNA ACTUALIZACION EN LA TABLA CLIENTES
            $affectedrowCliente=registrarCliente($distrito,$nombcliente,$telefonouno,NULL,$correo,$direccion,$IdDocRP,$segmento,$idcliente,$ncontrato);
            
        }
        else{
            
            //VALIDA QUE HUBO UNA ACTUALIZACION EN LA TABLA CLIENTES
            $affectedrowCliente=registrarCliente($distrito,$nombcliente,$telefonouno,$telefonodos,$correo,$direccion,$IdDocRP,$segmento,$idcliente,$ncontrato);
            
        }


        
        //INSERTA DATOS DEL PROSPECTORP EN LA TABLA VENTAS
        $arrayVenta = consultaVentaIProspecto();
        $idVen= insertarVenta();
        
        if($idVen == 'error'){
            die('error');
        }
        
        //PROCECSAR LA INFORMACION DEL DETALLE EXTRA Y REGALOS
        $detalleExtras = $_POST['detalleExtras'];
        $detalleRegalos = $_POST['detalleRegalos'];
        $detalleGeneral = $_POST['detalleGeneral'];
        
        $resultadoRegistroRegalos = registrarExtrasRegalos($detalleExtras, $detalleRegalos, $detalleGeneral);
        
        //INSERTA DATOS EN LA TABLA AGENDA (NUEVO REGISTRO)
        if(empty($finstalacion) && empty($hinstalacion) ){
            //INSERTA DATOS DEL PROSPECTORP EN LA TABLA AGENDA
            $arrayAgenda=consultaAgendaProspectoRP();
            
            $idagendahis=registrarAgenda($idVen,NULL,NULL,$instaladox,$tecnico,$comentarioagenda,$fecharegistro,$gestor,$estadoventa, $GestionOrigen);
            $sqlagendahist=registrarAgendaHistorico($idagendahis,$idVen,NULL,NULL,$instaladox,$tecnico,$comentarioagenda,$fecharegistro,$gestor,$estadoventa);

        
            
        }else if(empty($finstalacion)){
            //INSERTA DATOS DEL PROSPECTORP EN LA TABLA AGENDA
            $arrayAgenda=consultaAgendaProspectoRP();
            $idagendahis=registrarAgenda($idVen,$fechagrabar,NULL,$instaladox,$tecnico,$comentarioagenda,$fecharegistro,$gestor,$estadoventa, $GestionOrigen);
            $sqlagendahist=registrarAgendaHistorico($idagendahis,$idVen,$fechagrabar,NULL,$instaladox,$tecnico,$comentarioagenda,$fecharegistro,$gestor,$estadoventa);

                
        }else if(empty($hinstalacion)){
            //INSERTA DATOS DEL PROSPECTORP EN LA TABLA AGENDA
            $arrayAgenda=consultaAgendaProspectoRP();

            $idagendahis=registrarAgenda($idVen,NULL,$horagrabar,$instaladox,$tecnico,$comentarioagenda,$fecharegistro,$gestor,$estadoventa, $GestionOrigen);
            $sqlagendahist=registrarAgendaHistorico($idagendahis,$idVen,NULL,$horagrabar,$instaladox,$tecnico,$comentarioagenda,$fecharegistro,$gestor,$estadoventa);        
        
            
        }else{
            //INSERTA DATOS DEL PROSPECTORP EN LA TABLA AGENDA
            $arrayAgenda=consultaAgendaProspectoRP();

            $idagendahis=registrarAgenda($idVen,$fechagrabar,$horagrabar,$instaladox,$tecnico,$comentarioagenda,$fecharegistro,$gestor,$estadoventa, $GestionOrigen);
            $sqlagendahist=registrarAgendaHistorico($idagendahis,$idVen,$fechagrabar,$horagrabar,$instaladox,$tecnico,$comentarioagenda,$fecharegistro,$gestor,$estadoventa);  
        
        }

        //ACTUALIZAR IDVENTA EN CERTIFICACION
        registrarCertificacion($idVen,$fecharegistro,$lblcomentario_comercial,$lblhorariosugerido2,$gestor);
        
        //INSERTA DATOS DEL PROSECTORP EN LA TABLA FACTURACION
        $arrayFactu=consultaFacturacionI();
           try{
                $stmtFact = $con->prepare( "INSERT INTO dbVENTAS.tblfacturacion(IdVenta, FechaHoraREG, GestionOrigen) VALUES (?,?,?)");
                $stmtFact->bind_param('iss', $idVen,$fecharegistro,$GestionOrigen);
                $stmtFact->execute();
                $stmtFact->close();
        
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            }
        
        //ACTUALIZAR IDVENTA EN SCORING
           try{
                $stmtIDSco = $con->prepare( "UPDATE dbVENTAS.tbltmpscoring t SET t.IdVenta=? WHERE t.IdConsultaScoring=?");
                $stmtIDSco->bind_param('ii', $idVen,$IdConsultaScoring);
                $stmtIDSco->execute();
                $stmtIDSco->close();
        
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            }
        //GENERA LOG DE HISTORICO DE PROSPECTORP
           try{
                $stmtProshist = $con->prepare( "INSERT INTO dbVENTAS.tblprospectorphist(IdProspectoRP,FechaHoraREG,EstadoProspecto,TipoVenta,CategoriaVenta,Gestor) values(?,?,?,?,?,?)");
                $stmtProshist->bind_param('isssss', $idprospectorp,$fecharegistro,$estadoprospecto,$tipoventa,$categoria,$gestor);
                $stmtProshist->execute();
                $stmtProshist->close();
        
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            }
        //INSERTA EN ATTEC REPORTE
        if($estadoventa=='InstaladaDEL' || $estadoventa=='AgendadaDEL'){
            $lblIteraccionAttec++;
            $resultadoRegistroAttecReporte = registrarAttecReporte($idVen,$fecharegistro,$fechagrabar,$horagrabar,$lblIteraccionAttec);

           try{
                $stmtATT = $con->prepare( "UPDATE dbVENTAS.tblventa t SET t.IteraccionAttec=?,t.FechaVenta=? WHERE t.IdVenta=?");
                $stmtATT->bind_param('isi', $lblIteraccionAttec,$fechaventa,$idVen);
                $stmtATT->execute();
                $stmtATT->close();
        
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            }            
            
        }
        
        //GENERA LOG DE SEGURIDAD
            $REMOTE_ADDR=$_SERVER['REMOTE_ADDR'];
            $usuariosesion=$_SESSION['usuariosesion'];
            $REQUEST_URI=$_SERVER['REQUEST_URI'].'=>IdVenta='.$idVen;
            $Acceso='Registrar';
            $HTTP_USER_AGENT=$_SERVER['HTTP_USER_AGENT'];
            
            try {
                    
              $stmt = $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
              $stmt->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistro, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
              $stmt->execute();
              
              $idLogSeg = $con->insert_id;
              
              $stmt->close();
              
            } catch (\Exception $e) {
              echo $e->getMessage();
            }  


        //ENVIA RESPUESTA
        echo 7;
    
    if($affectedrowProspectoRP > 0){
        insertLogProspectoRP($idLogSeg, $arrayProspectoRP);
    }    
    if($affectedrowCliente > 0){
        insertarLog($idLogSeg, $arrayCliente);
    }
    
        insertLogVentaIProspecto($idLogSeg, $arrayVenta);
        insertLogAgendaProspectoRP($idLogSeg, $arrayAgenda);
        insertLogFacutracionI($idLogSeg, $arrayFactu);
    }
    
}else{
    echo 4;
}



    //CIERRA CONSULTA
}
else if($categoria=='NoVendida'){
    
    //---Cliente--
    $idcliente=$_POST['lblidcliente'];
    $nombcliente=$_POST['lblnombcliente'];
    $correo=$_POST['lblcorreo'];
    $direccion=$_POST['lbldireccion'];
    $distrito=$_POST['lbldistrito'];
    $telefonouno=$_POST['lblmovil'];
    $telefonodos=$_POST['lblfijo'];
    //---Termina Cliente---
    
    //CREACION DEL ARRAY QUE TRAE DATOS DEL CLIENTE
    $arrayCliente = consultaCliente($idcliente);
    
    //ACTUALIZA DATOS DEL PROSPECTORP EN LA TABLA CLIENTE
    if($telefonodos=="" || empty($telefonodos)){
        //VALIDA QUE HUBO UNA ACTUALIZACION EN LA TABLA CLIENTES
        $affectedrowCliente=registrarCliente($distrito,$nombcliente,$telefonouno,NULL,$correo,$direccion,NULL,$segmento,$idcliente,NULL);

    }else{
        //VALIDA QUE HUBO UNA ACTUALIZACION EN LA TABLA CLIENTES
        $affectedrowCliente=registrarCliente($distrito,$nombcliente,$telefonouno,$telefonodos,$correo,$direccion,NULL,$segmento,$idcliente,NULL);
        
    }
    

    $affectedrowProspectoRP=updateProspectoRP($idusuario,$idcliente,$matricula,$nombcomercial,$dc,$jefeventa,$categoria,$tipoventa,$segmento,$preciokit,$totalextra,$estadoprospecto,NULL,$extraautorizado,$mesesautorizados,NULL,$formadepago,$PAI,$resumenventa,$comentarioprospecto,$lbltipokit,$lblclosingpack,$lblprecioEspecial,$lblCantExtras,$lblresultadoScoring,$valcodigoOperacionScoring,$hidGGCC,$hidden_HCertificacion,NULL,$lblformapagocuota,NULL,NULL,NULL,$idprospectorp);    
    
    
    //GENERA LOG DE SEGURIDAD
    if($affectedrowCliente > 0 || $affectedrowProspectoRP > 0 ){
    //GENERA HISTORICO DEL PROSPECTORP
           try{
                $stmtProshist = $con->prepare( "INSERT INTO dbVENTAS.tblprospectorphist(IdProspectoRP,FechaHoraREG,EstadoProspecto,TipoVenta,CategoriaVenta,Gestor) values(?,?,?,?,?,?)");
                $stmtProshist->bind_param('isssss', $idprospectorp,$fecharegistro,$estadoprospecto,$tipoventa,$categoria,$gestor);
                $stmtProshist->execute();
                $stmtProshist->close();
        
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            }
    

            $REMOTE_ADDR=$_SERVER['REMOTE_ADDR'];
            $usuariosesion=$_SESSION['usuariosesion'];
            $REQUEST_URI=$_SERVER['REQUEST_URI'].'=>IdVenta='.$idVen;
            $Acceso='Modificar';
            $HTTP_USER_AGENT=$_SERVER['HTTP_USER_AGENT'];
            
            try {
                    
              $stmt = $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
              $stmt->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistro, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
              $stmt->execute();
              
              $idLogSeg = $con->insert_id;
              
              $stmt->close();
              
            } catch (\Exception $e) {
              echo $e->getMessage();
            }      
    
    
    if($affectedrowCliente > 0){
    insertarLog($idLogSeg, $arrayCliente);
    }
    if($affectedrowProspectoRP > 0){
        insertLogProspectoRP($idLogSeg, $arrayProspectoRP);
    }
    
     echo 5;
    }else{
     echo 20; 
    }
}

function insertarScoring($FechaHoraReg,$Servicio,$NumeroOperacion,$CodigoModelo,$TipoDocumento,$NumeroDocumento,$ApellidoPaterno,$ApellidoMaterno,$Nombres,$RazonSocial,$Explicacion,$Accion,$Score,$Riesgo,$Conclusion,$ultPeriodo,$TotalultPeriodo,$DeudaSoles,$DeudaDolares,$TotalDeudaSoles,$TotalDeudaDolares,$CodigoOficina,$GestorOrigen,$NombreGestorOrigen,$Integrante,$TipoPersona,$CantidadDocumentosMorosos,$ScoreRiesgo_PN,$PredictorIngresos_IP,$ScoreRiesgo_PJ,$MontoMorosoSoles,$MontoMorosoDolares,$PerfilScoring,$CodGenVen,$Departamental,$Provincial,$Distrital,$Ubigeo,$Area,$SegmentoI,$NodoDescripcion,$NodoAccion){
    global $con;
        try {
    
          $stmt = $con->prepare("INSERT INTO dbVENTAS.tbltmpscoring(FechaHoraReg,Servicio,NumeroOperacion,CodigoModelo,TipoDocumento,NumeroDocumento,ApellidoPaterno,ApellidoMaterno,Nombres,RazonSocial,Explicacion,Accion,Score,Riesgo,Conclusion,ultPeriodo,TotalultPeriodo,DeudaSoles,DeudaDolares,TotalDeudaSoles,TotalDeudaDolares,CodigoOficina,GestorOrigen,NombreGestorOrigen,Integrante,TipoPersona,CantidadDocumentosMorosos,ScoreRiesgo_PN,PredictorIngresos_IP,ScoreRiesgo_PJ,MontoMorosoSoles,MontoMorosoDolares,PerfilScoring,CodGenVen,Departamental,Provincial,Distrital,Ubigeo,Area,Segmento,NodoDescripcion,NodoAccion) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
          $stmt->bind_param('ssssisssssssisssdssddsssisiididdssssssssss', $FechaHoraReg,$Servicio,$NumeroOperacion,$CodigoModelo,$TipoDocumento,$NumeroDocumento,$ApellidoPaterno,$ApellidoMaterno,$Nombres,$RazonSocial,$Explicacion,$Accion,$Score,$Riesgo,$Conclusion,$ultPeriodo,$TotalultPeriodo,$DeudaSoles,$DeudaDolares,$TotalDeudaSoles,$TotalDeudaDolares,$CodigoOficina,$GestorOrigen,$NombreGestorOrigen,$Integrante,$TipoPersona,$CantidadDocumentosMorosos,$ScoreRiesgo_PN,$PredictorIngresos_IP,$ScoreRiesgo_PJ,$MontoMorosoSoles,$MontoMorosoDolares,$PerfilScoring,$CodGenVen,$Departamental,$Provincial,$Distrital,$Ubigeo,$Area,$SegmentoI,$NodoDescripcion,$NodoAccion);
            $stmt->execute();
            $respuesta = $con->insert_id;
            $stmt->close();
        } catch (\Exception $e) {
            $respuesta = array(
                'respuesta' => 'error'
            );
        }
        return $respuesta;
}

function insertarDocumento($tipodoc,$documento,$fecharegistro){
    global $con;
    $tipodocnuevo="";
    if($tipodoc==1){
        $tipodocnuevo="DNI";
    }else if($tipodoc==6){
       $tipodocnuevo="RUC"; 
    }else{
       $tipodocnuevo="CE"; 
    }
        try {
    
          $stmt = $con->prepare("INSERT INTO dbVENTAS.tbldocumento(TipoDocumento, Documento, FechaHoraREG) VALUES(?, ?, ?)");
          $stmt->bind_param('sss', $tipodocnuevo,$documento,$fecharegistro);
            $stmt->execute();
            $respuesta = $con->insert_id;
            $stmt->close();
        } catch (\Exception $e) {
            $respuesta = array(
                'respuesta' => 'error'
            );
        }
    
        return $respuesta;
    

}

function validarNContrato($val){
    global $con;
    
    $sql = "SELECT * FROM tblcliente WHERE NCliente =".$val;
    $resultado = $con->query($sql);
    $row_cnt = $resultado->num_rows;
    
    return $row_cnt;
    
}

function insertarVenta(){
    global $con;
    
    global $idusuario;
    global $idcliente;
    global $matricula;
    global $nombcomercial;
    global $dc;
    global $jefeventa;
    global $categoria;
    global $tipoventa;
    global $segmento;
    global $preciokit;
    global $totalextra;
    global $ingresokit;
    global $ingresoextras;
    global $ingresototal;
    global $estadoventa;
    global $extraautorizado;
    global $mesesautorizados;
    global $n590;
    global $formadepago;
    global $PAI;
    global $resumenventa;
    global $fecharegistro;
    global $gestor;
    global $dc;
    global $preciokit;
    global $totalextra;
    global $extraautorizado;
    global $mesesautorizados;
    global $formadepago;
    global $PAI;
    global $resumenventa;
    global $idprospectorp;
    global $lbltipokit;
    global $lblCantExtras;
    global $lbltipokit;
    global $lblclosingpack;
    global $lblprecioEspecial;
    global $lblCantExtras;
    global $lblresultadoScoring;
    global $hidGGCC;
    global $hidden_HCertificacion;
    global $Accion;
    global $PerfilScoring;
    global $IdConsultaScoring;
    global $lblformapagocuota;
    global $IdConsultaScoring;
    global $ncontrato;
    $RegalosAutorizados = 'NO';
    
    global $lblcategoriaprecio;
    global $lblDescuentoCuota;
    global $lbltotalcuota;
    global $lblCantRegalos;
    
    global $lbltipocamarakit;
    global $lblsegundaalarma;
    
    global $lblRenove,$lblRcompetencia,$lblRvencimiento;
    
    try{
        $stmt = $con->prepare("INSERT INTO dbVENTAS.tblventa    (IdUsuario,
                                                                IdCliente,
                                                                Matricula,
                                                                Comercial,
                                                                CC,
                                                                JefeVenta,
                                                                CategoriaVenta,
                                                                TipoVenta,
                                                                Segmento,
                                                                PrecioKit,
                                                                TotalExtra,
                                                                IngresoKIT,
                                                                IngresoExtras,
                                                                IngresoTotal,
                                                                EstadoVenta,
                                                                ExtraAutorizado,
                                                                MesesAutorizado,
                                                                N590,
                                                                FormaPago,
                                                                PAI,
                                                                ResumenVenta,
                                                                FechaHoraREG,
                                                                GestorOrigen,
                                                                CCOriginal,
                                                                PrecioKITOriginal,
                                                                TotalExtraOriginal,
                                                                ExtraAutorizadoOriginal,
                                                                MesesAutorizadoOriginal,
                                                                FormaPagoOriginal,
                                                                PAIOriginal,
                                                                ResumenVentaOriginal,
                                                                IdProspectoRP, 
                                                                TipoKIT, 
                                                                CantidadExtras, 
                                                                TipoKITOriginal, 
                                                                ClosingPack, 
                                                                PrecioEspecial, 
                                                                CantidadExtrasOriginal, 
                                                                ScoringRP,
                                                                GGCC,
                                                                HojaCertificacion,
                                                                Accion,
                                                                PerfilScoring,
                                                                IdConsultaScoring,
                                                                FormaPagoCuota,
                                                                IdConsultaScoringRP,
                                                                NContrato,
                                                                CantidadRegalo,
                                                                CantidadRegaloOriginal,
                                                                TotalCuotaMonitoreo,
                                                                RegalosAutorizados,
                                                                CategoriaPrecio,
                                                                dsctCuota,
                                                                TipoCamaraKit,
                                                                SegundaAlarma,
                                                                Renove,
                                                                RCompetencia,
                                                                RVencimiento
                                                                ) 
                                    VALUES  (?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?, 
                                    ?,
                                    ?,
                                    ?,
                                    ?,
                                    ?,
                                    ?)");
        $stmt->bind_param("iisssssssdddddssdsssssssddsdsssisisssisssssisisiidssssssss", $idusuario, 
                            $idcliente, 
                            $matricula, 
                            $nombcomercial, 
                            $dc, 
                            $jefeventa, 
                            $categoria, 
                            $tipoventa, 
                            $segmento, 
                            $preciokit, 
                            $totalextra, 
                            $ingresokit, 
                            $ingresoextras, 
                            $ingresototal, 
                            $estadoventa, 
                            $extraautorizado, 
                            $mesesautorizados, 
                            $n590, 
                            $formadepago, 
                            $PAI, 
                            $resumenventa, 
                            $fecharegistro, 
                            $gestor, 
                            $dc, 
                            $preciokit, 
                            $totalextra, 
                            $extraautorizado, 
                            $mesesautorizados, 
                            $formadepago, 
                            $PAI, 
                            $resumenventa, 
                            $idprospectorp, 
                            $lbltipokit, 
                            $lblCantExtras, 
                            $lbltipokit, 
                            $lblclosingpack, 
                            $lblprecioEspecial, 
                            $lblCantExtras, 
                            $lblresultadoScoring, 
                            $hidGGCC, 
                            $hidden_HCertificacion, 
                            $Accion, 
                            $PerfilScoring, 
                            $IdConsultaScoring, 
                            $lblformapagocuota, 
                            $IdConsultaScoring, 
                            $ncontrato, 
                            $lblCantRegalos, 
                            $lblCantRegalos, 
                            $lbltotalcuota, 
                            $RegalosAutorizados, 
                            $lblcategoriaprecio, 
                            $lblDescuentoCuota,
                            $lbltipocamarakit,
                            $lblsegundaalarma,
                            $lblRenove,
                            $lblRcompetencia,
                            $lblRvencimiento);
        $stmt->execute();
        $respuesta = $con->insert_id;
        $stmt->close();
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }

    return $respuesta;
    
}

function registrarExtrasRegalos($detalleExtras, $detalleRegalos, $detalleGeneral){
        global $con;
        global $idVen;
        $fecharegistro = date("Y-m-d H:i:s");
        
        $sql = "SELECT DetalleExtras, DetalleRegalos FROM tblventacotizacion WHERE IdVenta =".$idVen;
        $resultado = $con->query($sql);
        
        $row_cnt = $resultado->num_rows;
        
        while($data = $resultado->fetch_assoc()){
            $DetalleExtras__BD = $data['DetalleExtras'];
            $DetalleRegalos__BD = $data['DetalleRegalos'];
        }
        
        if($row_cnt > 0){

            try{
                $stmt = $con->prepare("UPDATE tblventacotizacion SET DetalleExtras=?, DetalleRegalos=?, DetalleGeneral=? WHERE IdVenta = ?");
                $stmt->bind_param("sssi", $detalleExtras, $detalleRegalos, $detalleGeneral, $idVen);
                $stmt->execute();
                
                $stmt->close();
                
            }catch (\Exception $e) {
                $respuesta = 'error';
            }
            
        } else {
        
            try{
                $stmt = $con->prepare("INSERT INTO tblventacotizacion (IdVenta, FechaHoraREG, DetalleExtras, DetalleRegalos, DetalleGeneral) VALUES (?, ?, ?, ?, ?)");
                $stmt->bind_param("issss", $idVen, $fecharegistro, $detalleExtras, $detalleRegalos, $detalleGeneral);
                $stmt->execute();
    
                $respuesta = $con->insert_id;
                
                $stmt->close();
                
            }catch (\Exception $e) {
                $respuesta = 'error';
            }
        }
    }

function registrarAttecReporte($idventa,$fecharegistro,$fechagrabar,$horagrabar,$lblIteraccionAttec){
    global $con;
        if ($fechagrabar == '' || empty($fechagrabar)){
            $FechaProgramacion = NULL;
        } else {
            $FechaProgramacion=$fechagrabar.' '.$horagrabar;
        }

    try {

      $stmt = $con->prepare("INSERT INTO tblattecreporte(IdVenta, FechaInstaladaDEL, FechaProgramacion, Vueltas,FechaHoraREG) VALUES (?,?,?,?,?)");
      $stmt->bind_param('issss', $idventa, $fecharegistro, $FechaProgramacion,$lblIteraccionAttec, $fecharegistro);
      $stmt->execute();

      $respuesta = array(
            'respuesta' => 'exito',
          );

      $stmt->close();
    } catch (\Exception $e) {
        $respuesta = array(
          'respuesta' => 'error',
          'mensaje' => $e->getMessage()
        );
    }

    return $respuesta;
}


function registrarCliente($distrito,$nombcliente,$telefonouno,$telefonodos=NULL,$correo,$direccion,$IdDocRP=NULL,$segmento,$idcliente,$ncontrato=NULL){
global $con;
  try{
        $stmt = $con->prepare("UPDATE dbVENTAS.tblcliente c SET c.IdGeografico=?,c.NombApellido=?,c.Telefonouno=?,c.Telefonodos=?,c.Correo=?,c.Direccion=?,c.IdDocRP=?,c.Segmento=?,c.NCliente=? WHERE c.IdCliente=?");
        $stmt->bind_param('isssssissi', $distrito,$nombcliente,$telefonouno,$telefonodos,$correo,$direccion,$IdDocRP,$segmento,$ncontrato,$idcliente);
        
        $stmt->execute();

        $respuesta = $stmt->affected_rows;
        
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 0;
    }
    return $respuesta;

}

function updateProspectoRP($idusuario,$idcliente,$matricula,$nombcomercial,$dc,$jefeventa,$categoria,$tipoventa,$segmento,$preciokit,$totalextra,$estadoprospecto,$estadoventa=NULL,$extraautorizado,$mesesautorizados,$n590=NULL,$formadepago,$PAI,$resumenventa,$comentarioprospecto,$lbltipokit,$lblclosingpack,$lblprecioEspecial,$lblCantExtras,$lblresultadoScoring,$valcodigoOperacionScoring,$hidGGCC,$hidden_HCertificacion,$IdConsultaScoring=NULL,$lblformapagocuota,$hidVisitaConcertada=NULL,$fechaVisitaConcertadaFinal=NULL,$horaVisitaConcertada=NULL,$idprospectorp){
global $con;
  try{
        $stmt = $con->prepare("UPDATE dbVENTAS.tblprospectorp p SET p.IdUsuario=?,p.IdCliente=?,p.Matricula=?,p.Comercial=?,p.CC=?,p.JefeVenta=?,p.CategoriaVenta=?,p.TipoVenta=?,p.Segmento=?,p.PrecioKit=?,p.TotalExtra=?,p.EstadoProspecto=?,p.EstadoVenta=?,p.ExtraAutorizado=?,p.MesesAutorizado=?,p.N590=?,p.FormaPago=?,p.PAI=?,p.ResumenProspecto=?,p.ComentarioProspectoRP=?,p.TipoKIT=?,p.ClosingPack=?,p.PrecioEspecial=?,p.CantidadExtras=?,p.ScoringRP=?,p.CodigoOperacionScoring=?,p.GGCC=?,p.HojaCertificacion=?,p.IdConsultaScoring=?,p.FormaPagoCuota=?,p.VisitaConcertada=?,p.FechaVisitaRP=?,p.HoraVisitaRP=? WHERE p.IdProspectoRP=?");
        $stmt->bind_param('iississssddsssdssssssssissssissssi', $idusuario,$idcliente,$matricula,$nombcomercial,$dc,$jefeventa,$categoria,$tipoventa,$segmento,$preciokit,$totalextra,$estadoprospecto,$estadoventa,$extraautorizado,$mesesautorizados,$n590,$formadepago,$PAI,$resumenventa,$comentarioprospecto,$lbltipokit,$lblclosingpack,$lblprecioEspecial,$lblCantExtras,$lblresultadoScoring,$valcodigoOperacionScoring,$hidGGCC,$hidden_HCertificacion,$IdConsultaScoring,$lblformapagocuota,$hidVisitaConcertada,$fechaVisitaConcertadaFinal,$horaVisitaConcertada,$idprospectorp);
        
        $stmt->execute();

        $respuesta = $stmt->affected_rows;
        
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 0;
    }
    return $respuesta;

}


function registrarAgenda($idVen,$fechagrabar=NULL,$horagrabar=NULL,$instaladox,$tecnico,$comentarioagenda,$fecharegistro,$gestor,$estadoventa, $GestionOrigen){
global $con;
  try{
        $stmt = $con->prepare("INSERT INTO dbVENTAS.tblagenda(IdVenta,FechaInst,HoraInst, InstaladoX, MatriculaTec, Comentario, FechaHoraREG,GestorAgenda,EstadoVenta,GestionOrigen) VALUES (?,?,?,?,?,?,?,?,?, ?)");
        $stmt->bind_param('isssssssss', $idVen,$fechagrabar,$horagrabar,$instaladox,$tecnico,$comentarioagenda,$fecharegistro,$gestor,$estadoventa, $GestionOrigen);
        
        $stmt->execute();

        $respuesta = $con->insert_id;
        
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 0;
    }
    return $respuesta;

}

function registrarAgendaHistorico($idagendahis,$idVen,$fechagrabar=NULL,$horagrabar=NULL,$instaladox,$tecnico,$comentarioagenda,$fecharegistro,$gestor,$estadoventa){
global $con;
  try{
        $stmt = $con->prepare("INSERT INTO dbVENTAS.tblagendahist(IdAgenda, IdVenta,FechaInst,HoraInst, InstaladoX, MatriculaTec, Comentario, FechaHoraREG,GestorAgenda,EstadoVenta) VALUES (?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('iissssssss', $idagendahis,$idVen,$fechagrabar,$horagrabar,$instaladox,$tecnico,$comentarioagenda,$fecharegistro,$gestor,$estadoventa);
        
        $stmt->execute();

        $respuesta = $con->insert_id;
        
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 0;
    }
    return $respuesta;

}


function registrarCertificacion($idVen,$fechagrabar,$lblcomentario_comercial=NULL,$lblhorariosugerido2=NULL,$Matricula=NULL){
global $con;

$TipoGestion='';

  try{
        $stmt = $con->prepare("INSERT INTO dbVENTAS.tblcertificacionventa(FechaHoraREG,ComentarioComercial,nuevohorarioSugerido) VALUES (?,?,?)");
        $stmt->bind_param('sss', $fechagrabar,$lblcomentario_comercial,$lblhorariosugerido2);
        
        $stmt->execute();

        $respuesta = $con->insert_id;
        
        $stmt->close();

        
    } catch (\Exception $e) {
        $respuesta = 0;
    }
    
    
    if($respuesta>0){
           try{
                $stmtVenta = $con->prepare( "UPDATE dbVENTAS.tblventa set IdCertVenta=? where IdVenta=?");
                $stmtVenta->bind_param('ii',$respuesta, $idVen);
                $stmtVenta->execute();
                $stmtVenta->close();
        
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            }
            
           try{
                $stmtHist = $con->prepare( "INSERT INTO dbVENTAS.tblcertificacioncomertario(IdVenta, HorarioSugerido, Comentario, TipoGestion, FechaHoraREG, Matricula) VALUES(?,?,?,?,?,?)");
                $stmtHist->bind_param('isssss',$idVen,$lblhorariosugerido2, $lblcomentario_comercial,$TipoGestion,$fechagrabar,$Matricula);
                $stmtHist->execute();
                $stmtHist->close();
        
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            }            
            
            
    }
  

}







