<?php
header("Content-Type: text/html;charset=utf-8");
include('is_logged.php');
date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}

require '../config/db.php';
require '../config/conexion.php';
require_once '../helper/helper_validacion.php';

$fecharegistro = date("Y-m-d H:i:s");

$usuarioreg = sanitizaCampo($_SESSION['usuariosesion'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$usuarioreg = htmlspecialchars($usuarioreg);

//VALIDAR

$cboGestorCEVent = sanitizaCampo($_POST['cboGestorCEVent'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$cboGestorCEVent = htmlspecialchars($cboGestorCEVent);

$arraySelect = array();

$selectrows = sanitizaCampo($_POST['selectrows'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$selectrows = htmlspecialchars($selectrows);

$arraySelect = explode ( ',', $selectrows );
                                          

if($cboGestorCEVent=='NSP'){
    
}else{
    
    if(!empty($arraySelect)){

        foreach ($arraySelect as $key => $value) {

            updatetblVenta($cboGestorCEVent,$fecharegistro,$value);    
                
        }
            
        die(json_encode(array('respuesta' => 'exito', 'id_registro' => '')));    
    }else{
        die(json_encode(array('respuesta' => 'error')));
    }
}
    
function updatetblVenta($cboGestorCEVent,$fecharegistro,$selectrows){
    global $con;    
            $resultadoventa=$con->prepare("UPDATE tblventa v SET v.GestorCertVenta=? ,v.FechaApertura=? WHERE v.IdVenta=? "); 
            $resultadoventa->bind_param('ssi',$cboGestorCEVent,$fecharegistro,$selectrows);
            $resultadoventa->execute();
            $resultadoventa->close();
    
}
