<?php
include('is_logged.php');
date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}

require '../config/db.php';
require '../config/conexion.php';
require_once '../helper/helper_validacion.php';

//AGREGAR FUNCIONES LOG
include 'log/insertLog.php';
include 'log/insertLogAgenda.php';
include 'log/insertLogAgendaVenta.php';
include 'Correo/correoNotificacionAgenda.php';


//include_once '../config/dbsec.php';
//include_once '../config/conexionsec.php';

$gestor=htmlspecialchars($_POST['gestor']);

$finstalacion=htmlspecialchars($_POST['lblfinstalacion']);
$hinstalacion=htmlspecialchars($_POST['lblhinstalacion']);

if ($finstalacion == '' || empty($finstalacion)){
    $fechagrabar = NULL;
} else {
    $fechaconvert=  myUrlEncode($finstalacion);
    $fechagrabar=  format_date_Y_mm_dd(str_replace('/', '-', $fechaconvert));
}

if ($hinstalacion == '' || empty($hinstalacion)){
    $horagrabarcomparar = NULL;
} else {
    $horaconvert=  myUrlEncode($hinstalacion);
    $horagrabar=  date("H:i", strtotime(str_replace("+"," ",$horaconvert)));
    $horagrabarcomparar=  date("H:i:s", strtotime(str_replace("+"," ",$horaconvert)));
}



if ($_POST['FechaGestion'] == ''){
    $FechaGestion = NULL;
} else {
    $FechaGestion=htmlspecialchars($_POST['FechaGestion']);
}

if ($_POST['FechaAgendamiento'] == ''){
    $FechaAgendamiento = NULL;
} else {
    $FechaAgendamiento=$_POST['FechaAgendamiento'];
}

if ($_POST['FechaInstalacion'] == ''){
    $FechaInstalacion = NULL;
} else {
    $FechaInstalacion=$_POST['FechaInstalacion'];
}

if ($_POST['FechaTCFI'] == ''){
    $FechaTCFI = NULL;
} else {
    $FechaTCFI=htmlspecialchars($_POST['FechaTCFI']);
}

if ($_POST['lblIdAgenRepor'] == ''){
    $lblIdAgenRepor = NULL;
} else {
    $lblIdAgenRepor=htmlspecialchars($_POST['lblIdAgenRepor']);
}

if ($_POST['FechaCancelada'] == ''){
    $FechaCancelada = NULL;
} else {
    $FechaCancelada=htmlspecialchars($_POST['FechaCancelada']);
}

if ($_POST['FechaInviable'] == ''){
    $FechaInviable = NULL;
} else {
    $FechaInviable=htmlspecialchars($_POST['FechaInviable']);
}

if ($_POST['FechaIlocalizable'] == ''){
    $FechaIlocalizable = NULL;
} else {
    $FechaIlocalizable=htmlspecialchars($_POST['FechaIlocalizable']);
}

if ($_POST['FechaNoAgendada'] == ''){
    $FechaNoAgendada = NULL;
} else {
    $FechaNoAgendada=htmlspecialchars($_POST['FechaNoAgendada']);
}

if ($_POST['FechaAnuladaAgenda'] == ''){
    $FechaAnuladaAgenda = NULL;
} else {
    $FechaAnuladaAgenda=htmlspecialchars($_POST['FechaAnuladaAgenda']);
}

if ($_POST['FechaPostergada'] == ''){
    $FechaPostergada = NULL;
} else {
    $FechaPostergada=htmlspecialchars($_POST['FechaPostergada']);
}


$categoria=htmlspecialchars($_POST['lblcategoria']);
$matricula=htmlspecialchars($_POST['lblmatricula']);
$nombcomercial=htmlspecialchars($_POST['lblnombcomercial']);
//$dc=$_POST['lbldc'];
//$jefeventa=$_POST['lbljefeventa'];
//$tipoventa=$_POST['lbltipoventa'];
//$segmento=$_POST['lblsegmento'];
$estadoventa=stringtonull($_POST['lblestadoventa']);
$direccion=htmlspecialchars($_POST['lbldireccion']);
//$distrito=$_POST['lbldistrito'];
$nprospecto=htmlspecialchars($_POST['lblnprospecto']);
$ncontrato=stringtonull($_POST['lblncontrato']);


$instaladox=htmlspecialchars($_POST['lblinstaladox']);
$tecnico=htmlspecialchars($_POST['lbltecnico']);
$comentarioagenda=htmlspecialchars(ltrim($_POST['lblcomentarioagenda']));
$fecharegistroagenda = date("Y-m-d H:i:s");

$fecharegistroventa = date("Y-m-d H:i:s");

$nombcliente=htmlspecialchars($_POST['lblnombcliente']);
$telefonouno=htmlspecialchars($_POST['lblmovil']);
$telefonodos=htmlspecialchars($_POST['lblfijo']);
$correo=htmlspecialchars($_POST['lblcorreo']);
$idusuario=htmlspecialchars($_POST['lblidusuario']);
$resumenventa=$_POST['lblresumenventa'];


$cccomercial=$_POST['cccomercial'];

if($cccomercial=='511' || $cccomercial=='512'){
$matriculacomercial=htmlspecialchars($_POST['tcgestor']);
$matriculajefe=NULL;
}else{
$matriculacomercial=htmlspecialchars($_POST['matriculacomercial']);
$matriculajefe=htmlspecialchars($_POST['matriculajefe']);
}

$idcliente=htmlspecialchars($_POST['lblidcliente']);
$idventa=htmlspecialchars($_POST['lblidventa']);
$idagenda=htmlspecialchars($_POST['lblidagenda']);

if ($_POST['lblrepercucion'] == ''){
    $repercucion = NULL;
} else {
    $repercucion=$_POST['lblrepercucion'];
}

$inviable=utf8_decode($_POST['lblinviable']);
$cancelado=htmlspecialchars($_POST['lblcancelado']);

if ($_POST['lblcosto'] == ''){
    $costo=NULL;
}else {
    $costo=htmlspecialchars($_POST['lblcosto']);
}

if ($_POST['lbldesplazamientotecnico'] == ''){
    $desplazamientotecnico=NULL;
} else {
    $desplazamientotecnico=htmlspecialchars($_POST['lbldesplazamientotecnico']);
}

$validarfechainst="";

//FALTA LOG CLIENTE ... ACTUALIZAR NCONTRATO

//ARRAY DE DATOS DE LA TABLA AGENDA
$resultadoAgenda = consultaAgenda($idventa);
//ARRAY DE DATOS DE LA TABLA VENTA
$resultadoAgendaVenta = consultaAgendaVenta($idventa);

//VALIDA NCONTRATO ANTES DE REGISTRAR
if(isset($ncontrato) && $ncontrato <> $resultadoAgendaVenta['NContrato']){
   if(validarNContrato($ncontrato) > 0){
        die('2');
    }
} 





//ACTUALIZA AGENDA Y RETORNA EL NUMERO DE FILAS AFECTADAS
$resultadoagenda = actualizarAgenda($idventa);
//ACTUALIZA VENTA Y RETORNA EL NUMERO DE FILAS AFECTADAS

if(($estadoventa=='Cancelada' or $estadoventa=='Ilocalizable') and $cccomercial=='512'){
    $resultadoventa = actualizarVentaconPrioridad($idventa);
}else{
    $resultadoventa = actualizarVenta($idventa);    
}


if ($resultadoagenda > 0 && $resultadoventa>0) {

    try{
        $sqlclientecontrato = $con->prepare( "UPDATE dbVENTAS.tblcliente c SET c.NCliente=? WHERE c.IdCliente=?");
        $sqlclientecontrato->bind_param('si', $ncontrato,$idcliente);
        $sqlclientecontrato->execute();
        $sqlclientecontrato->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
    //INSERTA LOG HISTORIO DE AGENDA
    $sqlagendahist=insertarAgendaHist($idagenda);
    
    //INSERTA LOG DE SEGURIDAD

    $REMOTE_ADDR=$_SERVER['REMOTE_ADDR'];
    $usuariosesion=$_SESSION['usuariosesion'];
    $REQUEST_URI=$_SERVER['REQUEST_URI'].'=>IdVenta='.$idventa;
    $Acceso='Modificar';
    $HTTP_USER_AGENT=$_SERVER['HTTP_USER_AGENT'];
    try {
            
      $result_exec = $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
      $result_exec->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistro, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
      $result_exec->execute();
      
      $idLogSeg = $con->insert_id;
      
      $result_exec->close();
      
    } catch (\Exception $e) {
      echo $e->getMessage();
    } 

    //INSERTA LOG TRANSACCIONAL DE TABLA VENTA
    insertLogAgendaVenta($idLogSeg, $resultadoAgendaVenta);
    //INSERTA LOG TRANSACCIONAL DE TABLA AGENDA
    insertLogAgenda($idLogSeg, $resultadoAgenda);
    
    if($cccomercial=='511' && $cccomercial=='512' && isset($comentarioagenda) && $comentarioagenda <> $resultadoAgenda['Comentario']){
        enviarNotifiacionCorreo_test($idventa,$comentarioagenda,$cccomercial);
    }
    
    if($cccomercial=='601' && $cccomercial=='602' && isset($comentarioagenda) && $comentarioagenda <> $resultadoAgenda['Comentario']){
        enviarNotifiacionCorreo_test($idventa,$comentarioagenda,$cccomercial);
    }
    
    
    
    if($cccomercial=='511' && $estadoventa=="AgendadaTEC"){
       //enviarNotifiacionCorreo_Telecierre($idventa,$comentarioagenda,$cccomercial);
    }
    
    echo 1;
    
}
else if ($resultadoagenda == 0 && $resultadoventa>0){
    try{
        $sqlclientecontrato = $con->prepare( "UPDATE dbVENTAS.tblcliente c SET c.NCliente=? WHERE c.IdCliente=?");
        $sqlclientecontrato->bind_param('si', $ncontrato,$idcliente);
        $sqlclientecontrato->execute();
        $sqlclientecontrato->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }    
    //INSERTA LOG DE SEGURIDAD
    $REMOTE_ADDR=$_SERVER['REMOTE_ADDR'];
    $usuariosesion=$_SESSION['usuariosesion'];
    $REQUEST_URI=$_SERVER['REQUEST_URI'].'=>IdVenta='.$idventa;
    $Acceso='Modificar';
    $HTTP_USER_AGENT=$_SERVER['HTTP_USER_AGENT'];
    try {
            
      $result_exec = $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
      $result_exec->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistro, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
      $result_exec->execute();
      
      $idLogSeg = $con->insert_id;
      
      $result_exec->close();
      
    } catch (\Exception $e) {
      echo $e->getMessage();
    } 
    
    //INSERTA LOG TRANSACCIONAL DE TABLA VENTA
    insertLogAgendaVenta($idLogSeg, $resultadoAgendaVenta);
    
    echo 1;
}
else if ($resultadoagenda >0 && $resultadoventa==0){
    
        //INSERTA LOG HISTORIO DE AGENDA
    $sqlagendahist=insertarAgendaHist($idagenda);
    //INSERTA LOG DE SEGURIDAD
    $REMOTE_ADDR=$_SERVER['REMOTE_ADDR'];
    $usuariosesion=$_SESSION['usuariosesion'];
    $REQUEST_URI=$_SERVER['REQUEST_URI'].'=>IdVenta='.$idventa;
    $Acceso='Modificar';
    $HTTP_USER_AGENT=$_SERVER['HTTP_USER_AGENT'];
    try {
            
      $result_exec = $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
      $result_exec->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistro, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
      $result_exec->execute();
      
      $idLogSeg = $con->insert_id;
      
      $result_exec->close();
      
    } catch (\Exception $e) {
      echo $e->getMessage();
    } 
    //INSERTA LOG TRANSACCIONAL DE TABLA AGENDA
    insertLogAgenda($idLogSeg, $resultadoAgenda);
    if($cccomercial=='511' && $cccomercial=='512' && isset($comentarioagenda) && $comentarioagenda <> $resultadoAgenda['Comentario']){
       enviarNotifiacionCorreo_test($idventa,$comentarioagenda,$cccomercial);
    }

    if($cccomercial=='601' && $cccomercial=='602' && isset($comentarioagenda) && $comentarioagenda <> $resultadoAgenda['Comentario']){
        enviarNotifiacionCorreo_test($idventa,$comentarioagenda,$cccomercial);
    }
    
    
    if($cccomercial=='511' && $estadoventa=="AgendadaTEC"){
       //enviarNotifiacionCorreo_Telecierre($idventa,$comentarioagenda,$cccomercial);
    }
    
        
    echo 1;
}
else if ($resultadoagenda==0 && $resultadoventa==0){
    echo 0;
}
else {
    echo -1;
}



function actualizarVenta($idventa){
    
    global $con;
    
    global $estadoventa;
    global $ncontrato;

    if($estadoventa=='Cancelada' || $estadoventa=='Ilocalizable' || $estadoventa=='Inviable' || $estadoventa=='NoAgendada' || $estadoventa=='AnuladaAgenda' || $estadoventa=='Postergada'){
        $FechaTCFI = NULL;
    }

    try{
        
        $stmt = $con->prepare("UPDATE dbVENTAS.tblventa SET EstadoVenta= ?, NContrato=?,FechaTCFI=? WHERE IdVenta=?");
        $stmt->bind_param('sssi', $estadoventa, $ncontrato, $FechaTCFI,$idventa);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}

function actualizarVentaconPrioridad($idventa){
    
    global $con;
    
    global $estadoventa;
    global $ncontrato;
    global $prioridad;
    $prioridad='Alta';
    
    try{
        
        $stmt = $con->prepare("UPDATE dbVENTAS.tblventa SET EstadoVenta= ?, NContrato=?,Prioridad=? WHERE IdVenta=?");
        $stmt->bind_param('sssi', $estadoventa, $ncontrato,$prioridad, $idventa);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}


function actualizarAgenda($idventa){
    
    global $con;
    
    global $fechagrabar;
    global $horagrabar;
    global $instaladox;
    global $tecnico;
    global $comentarioagenda;
    global $fecharegistroagenda;
    global $inviable;
    global $cancelado;
    global $repercucion;
    global $costo;
    global $gestor;
    global $estadoventa;
    global $FechaGestion;
    global $FechaAgendamiento;
    global $FechaInstalacion;
    global $lblIdAgenRepor;
    global $FechaCancelada;
    global $FechaInviable;
    global $FechaIlocalizable;
    global $desplazamientotecnico;
    
    
    if($fechagrabar!="" && $horagrabar!="" && $instaladox!="" && $tecnico!="" && $comentarioagenda!=""){
        if ($FechaGestion == ''){
            $FechaGestion=date("Y-m-d H:i:s");
        }else{
            $FechaGestion=$FechaGestion;
        }
    }
    if($estadoventa=='AgendadaTEC'){
        if ($FechaAgendamiento == ''){
            $FechaAgendamiento=date("Y-m-d H:i:s");
        }else{
            $FechaAgendamiento=$FechaAgendamiento;
            
        }
    }    
    if($estadoventa=='Instalada'){
        if ($FechaInstalacion == ''){
            $FechaInstalacion=date("Y-m-d H:i:s");
        }else{
            $FechaInstalacion=$FechaInstalacion;
            
        }
        
    }
    
    if($estadoventa=='Cancelada'){
        if ($FechaCancelada == ''){
            $FechaCancelada=date("Y-m-d H:i:s");
        }else{
            $FechaCancelada=$FechaCancelada;
            
        }
    }    
    if($estadoventa=='Inviable'){
        if ($FechaInviable == ''){
            $FechaInviable=date("Y-m-d H:i:s");
        }else{
            $FechaInviable=$FechaInviable;
            
        }
    }  
    
    if($estadoventa=='Ilocalizable'){
        if ($FechaIlocalizable == ''){
            $FechaIlocalizable=date("Y-m-d H:i:s");
        }else{
            $FechaIlocalizable=$FechaIlocalizable;
            
        }
    }  



    if($estadoventa=='NoAgendada'){
        if ($FechaNoAgendada == ''){
            $FechaNoAgendada=date("Y-m-d H:i:s");
        }else{
            $FechaNoAgendada=$FechaNoAgendada;
            
        }
    } 

    if($estadoventa=='AnuladaAgenda'){
        if ($FechaAnuladaAgenda == ''){
            $FechaAnuladaAgenda=date("Y-m-d H:i:s");
        }else{
            $FechaAnuladaAgenda=$FechaAnuladaAgenda;
            
        }
    } 

    if($estadoventa=='Postergada'){
        if ($FechaPostergada == ''){
            $FechaPostergada=date("Y-m-d H:i:s");
        }else{
            $FechaPostergada=$FechaPostergada;
            
        }
    }     
    
    

    if($lblIdAgenRepor>0){
        $actualiaragendareporte=actualizarAgendaReporte($lblIdAgenRepor,$FechaGestion,$FechaAgendamiento,$FechaInstalacion,$fechagrabar,$horagrabar,$instaladox,$tecnico,$FechaCancelada,$FechaInviable,$FechaIlocalizable,$FechaNoAgendada,$FechaAnuladaAgenda,$FechaPostergada);
        
    }
    
    
    try{
        
        $stmt = $con->prepare("UPDATE dbVENTAS.tblagenda SET FechaInst=?, HoraInst=?, InstaladoX=?, MatriculaTec=?, Comentario=?, MotivoInviable=?, MotivoCancelada=?, Repercusion=?, RepercusionCosto=?, GestorAgenda=?, EstadoVenta=?,FechaGestion=?,FechaAgendamiento=?,FechaInstalacion=?,Desplazamiento=? WHERE IdVenta=?");
        $stmt->bind_param('sssssssssssssssi', $fechagrabar, $horagrabar, $instaladox, $tecnico, $comentarioagenda, $inviable, $cancelado, $repercucion, $costo, $gestor, $estadoventa,$FechaGestion,$FechaAgendamiento,$FechaInstalacion,$desplazamientotecnico, $idventa);
        $stmt->execute();
        $respuesta = $stmt->affected_rows;
        $stmt->close();
        
        
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}

function insertarAgendaHist($idagenda){
    global $con;
    
    global $idventa;
    global $fechagrabar;
    global $horagrabar;
    global $instaladox;
    global $tecnico;
    global $comentarioagenda;
    global $fecharegistroagenda;
    global $inviable;
    global $cancelado;
    global $repercucion;
    global $costo;
    global $gestor;
    global $estadoventa;
    global $matriculacomercial;
    global $cccomercial;
    global $matriculajefe;
    global $desplazamientotecnico;
    
    
    try{
        
        $stmt = $con->prepare("INSERT INTO dbVENTAS.tblagendahist(IdAgenda, IdVenta, FechaInst,HoraInst,InstaladoX, MatriculaTec, Comentario, FechaHoraREG,Repercusion,RepercusionCosto, MotivoInviable, MotivoCancelada,GestorAgenda,EstadoVenta,Matricula,CC,JefeVenta,Desplazamiento) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('iissssssssssssssss',$idagenda,$idventa, $fechagrabar, $horagrabar, $instaladox, $tecnico, $comentarioagenda, $fecharegistroagenda, $repercucion, $costo,$inviable, $cancelado, $gestor, $estadoventa,$matriculacomercial,$cccomercial,$matriculajefe,$desplazamientotecnico);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}

function validarNContrato($val){
    global $con;
    
    $sql = "SELECT * FROM tblcliente WHERE NCliente =".$val;
    $resultado = $con->query($sql);
    $row_cnt = $resultado->num_rows;
    
    return $row_cnt;
    
}


function stringtonull($val){
    
    if ($val == '' || empty($val)){
        $resultado = NULL;
    }
    else if(!isset($val)){
        $resultado = NULL;
    }
    else {
        $resultado = $val;
    }
    
    return $resultado;
}

function actualizarAgendaReporte($idagendarorte,$FechaGestion,$FechaAgendamiento,$FechaInstalacion,$fechagrabar,$horagrabar,$instaladox,$tecnico,$FechaCancelada,$FechaInviable,$FechaIlocalizable,$FechaNoAgendada,$FechaAnuladaAgenda,$FechaPostergada){
    
    global $con;
    /*
    global $FechaGestion;
    global $FechaAgendamiento;
    global $FechaInstalacion;
    global $fechagrabar;
    global $horagrabar;
    */
        if ($fechagrabar == '' || empty($fechagrabar)){
            $FechaProgramacion = NULL;
        } else {
            $FechaProgramacion=$fechagrabar.' '.$horagrabar;
        }
    
    try{
        
        $stmt = $con->prepare("UPDATE dbVENTAS.tblagendareporte SET FechaPrimeraGestion=?,FechaProgramacion=?,FechaAgedamiento= ?,FechaInstalada= ?,InstaladoX=?,MatriculaTec=?,FechaCancelada=?,FechaInviable=?,FechaIlocalizable=?,FechaNoAgendada=?,FechaAnuladaAgenda=?,FechaPostergada=? WHERE IdAgenRepor=?");
        $stmt->bind_param('ssssssssssssi', $FechaGestion,$FechaProgramacion,$FechaAgendamiento,$FechaInstalacion,$instaladox,$tecnico,$FechaCancelada,$FechaInviable,$FechaIlocalizable,$FechaNoAgendada,$FechaAnuladaAgenda,$FechaPostergada, $idagendarorte);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}


$con->close();

