<?php

require_once 'vendor/autoload.php';
include('../is_logged.php');

require_once '../../config/db.php';
require_once '../../config/conexion.php';

set_time_limit(0);

$dbConf = new \SpoutExample\DBConf();
$reportCreator = new \SpoutExample\ReportCreator($dbConf);

    function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
    }
    function format_date_dd_mm_Y($date){
        return date('d/m/Y', strtotime($date));
    }
    function format_date_Y_mm_dd($date){
        return date('Y-m-d', strtotime($date));
    }
    //LIBRERIA DE EXPORTACION
    $lblfinicial=$_GET['lblfinicial'];
    $lblffinal=$_GET['lblffinal'];

    $fechaconvertfinicial=  myUrlEncode($lblfinicial);
    $fechagrabarfinicial=  format_date_Y_mm_dd(str_replace('/', '-', $fechaconvertfinicial));
    $fechaconvertffinal=  myUrlEncode($lblffinal);
    $fechagrabarffinal=  format_date_Y_mm_dd(str_replace('/', '-', $fechaconvertffinal));


$outputPath = 'out/LeadsReferidos.csv';
//$outputPath = 'VisitasRE_Scoring.csv';
// Create output folder if needed
$outputFolder = dirname($outputPath);
if (!file_exists($outputFolder)) {
   mkdir($outputFolder);
}

$startTime = microtime(true);

// Generate the report from the data present in the DB
$reportCreator
//    ->setFetchRowsInBatch(500)
    ->setFetchRowsOneByOne()
//    ->setFetchAllRowsAtOnce()
    ->setWriterType(\SpoutExample\ReportWriter\WriterType::SPOUT)
//    ->setWriterType(\SpoutExample\ReportWriter\WriterType::PHP_EXCEL)
    ->fetchDataAndCreateReport_LEADREF($outputPath,$fechagrabarfinicial,$fechagrabarffinal);

// Display some stats
$timeElapsed = round(microtime(true) - $startTime, 2);
$memoryPeak = round(memory_get_peak_usage(true) / 1024 / 1024, 2);

//echo $reportCreator->getFetchMethodName() . "\n";
//echo "Elapsed time: {$timeElapsed}s\n";
//echo "Memory peak: {$memoryPeak}MB\n";
//echo '<a style="color: #e30613" href="'.$outputPath.'" target="_blank" >Descargar</a>';
if(!empty($reportCreator->getFetchMethodName())){
   $fileName = basename('LeadsReferidos.csv');
    $filePath = $outputPath;
    if(!empty($fileName) && file_exists($filePath)){
        // Define headers
        header("Cache-Control: public");
        header("Content-Description: File Transfer");
        header("Content-Disposition: attachment; filename=$fileName");
        header("Content-Type: application/csv");
        header("Content-Transfer-Encoding: binary");
        
        // Read the file
        readfile($filePath);
        exit;
    }else{
        echo 'The file does not exist.';
    } 
}


