<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';

require_once '../helper/helper_validacion.php';

$sql = "SELECT
            v.IdVenta,
            v.EstadoVisita,
            v.EstadoVenta,
            v.TipoVenta,
            DATE_FORMAT(v.FechaHoraREG, '%Y-%m-%d %r') FechaHoraREG,
            v.GestorMKT,
            v.Segmento,
            c.NombApellido Cliente,
            g.Distrito,
            g.Provincia,
            v.FechaVisita,
            v.FObras,
            v.FVisitaObras,
            v.HoraVisita,
            v.OrigenVisita,
            v.LeadID,
            v.NProspecto
        FROM dbVENTAS.tblventa v
        INNER JOIN dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente
        INNER JOIN dbVENTAS.tblgeografico g on g.IdGeografico=c.IdGeografico
        WHERE (v.TipoVenta =  'RE' OR v.TipoVenta = 'RPMKT' OR v.TipoVenta =  'REGGCC' ) AND v.EstadoVisita = 'VGenerada'
        ORDER BY  v.FechaHoraREG DESC";


    try{
        $stmt = $con->prepare($sql);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($IdVenta,
        $EstadoVisita,
        $EstadoVenta,
        $TipoVenta,
        $FechaHoraREG,
        $GestorMKT,
        $Segmento,
        $Cliente,
        $Distrito,
        $Provincia,
        $FechaVisita,
        $FObras,
        $FVisitaObras,
        $HoraVisita,
        $OrigenVisita,
        $LeadID,
        $NProspecto
        );
        $arreglo = [];  
        while ($stmt->fetch()){
        $arreglo[] = array_map("utf8_encode",
            ['IdVenta'=>$IdVenta,
            'EstadoVisita'=>$EstadoVisita,
            'EstadoVenta'=>$EstadoVenta,
            'TipoVenta'=>$TipoVenta,
            'FechaHoraREG'=>$FechaHoraREG,
            'GestorMKT'=>$GestorMKT,
            'Segmento'=>$Segmento,
            'Cliente'=>$Cliente,
            'Distrito'=>$Distrito,
            'Provincia'=>$Provincia,
            'FechaVisita'=>$FechaVisita,
            'FObras'=>$FObras,
            'FVisitaObras'=>$FVisitaObras,
            'HoraVisita'=>$HoraVisita,
            'OrigenVisita'=>$OrigenVisita,
            'LeadID'=>$LeadID,
            'NProspecto'=>$NProspecto
            ]);       
	    }
	    
        $stmt->close();

    } catch(PDOException $e) {
         $arreglo = ['error'];
    }

    echo json_encode($arreglo);