<?php

include('is_logged.php');
require_once '../config/db.php';
require_once '../config/conexion.php';
require_once '../helper/helper_validacion.php';

$arreglo=NULL;

if (isset($_GET['URL'])) {
    $buscarURL = sanitizaCampo($_GET['URL'], 'sanitizeint|scapestring|htmlspecialchars', $con);
}else{
    $buscarURL = "NSP";
}

$query="SELECT m.IdMdp,m.URL,m.FechaHoraREG,m.FechaVencimiento,m.EstadoURL, m.CodigoMDP,m.CantidadTransaccion,
m.HoraVencimiento,m.GestorOrigen, COUNT(t.IdMdp) CantTransaccion, 
CONCAT_WS('-', COUNT(t.IdMdp), (CASE WHEN m.CantidadTransaccion-COUNT(t.IdMdp)>2 
THEN 'Minimo' WHEN COUNT(t.IdMdp)>=m.CantidadTransaccion 
THEN 'Maximo' WHEN m.CantidadTransaccion-COUNT(t.IdMdp)<=2 
THEN 'Medio' ELSE 'Vacio' END)) AS Cant_adv_transaccion
FROM dbVENTAS.tblmdp m LEFT JOIN dbVENTAS.tbltransaccion t on t.IdMdp=m.IdMdp WHERE m.CodigoMDP = ? GROUP BY m.IdMdp ORDER BY m.EstadoURL asc
";

    	try{       
            $stmt = $con->prepare($query);
            $stmt->bind_param('s', $buscarURL);
            $stmt->execute();
            $stmt->store_result();
            $stmt->bind_result($IdMdp, $URL, $FechaHoraREG, $FechaVencimiento, $EstadoURL, $CodigoMDP, $CantidadTransaccion, $HoraVencimiento, $GestorOrigen, $CantTransaccion, 
            $Cant_adv_transaccion);
            
            if($stmt->num_rows > 0){
                while($stmt->fetch()){
                    $arreglo[] = array_map("utf8_encode",['IdMdp' => $IdMdp, 'URL' => $URL, 'FechaHoraREG' => $FechaHoraREG, 'FechaVencimiento' => $FechaVencimiento, 'EstadoURL' => $EstadoURL,
                    'CodigoMDP' => $CodigoMDP, 'CantidadTransaccion' => $CantidadTransaccion, 'HoraVencimiento' => $HoraVencimiento, 'GestorOrigen' => $GestorOrigen, 'CantTransaccion' => $CantTransaccion, 
                    'Cant_adv_transaccion' => $Cant_adv_transaccion]); 
                    unset($data);   
                }
            }
    
        } catch(PDOException $e) {
            echo "Error: " . $e->getMessage();
        }

echo json_encode($arreglo);
