<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
include '../helper/helper_validacion.php';

if (isset($_POST['ncliente']) && $_POST['ncliente']<>'') {
    
$ncliente=sanitizaCampo($_POST['ncliente'],'sanitizestring|scapestring|htmlspecialchars',$con);
$ncliente = htmlspecialchars($ncliente);

$matricula=htmlspecialchars($_SESSION['matriculausuario']);

$json = [];

$query=$con->prepare("SELECT 
c.IdCliente,
c.NCliente,
c.NombApellido Cliente,
c.Telefonouno,
c.Telefonodos,
c.Correo,
c.Direccion,
d.condicionAmpliar,
d.formaPago,
d.fechaUltimaModificacion,
d.montoDeuda,
c.Segmento,
g.Provincia
FROM tblcliente c 
LEFT JOIN tblgeografico g on g.IdGeografico=c.IdGeografico
LEFT JOIN tbldeudas d on c.NCliente=d.contrato
WHERE c.NCliente=?");     
$query->bind_param('s',$ncliente);
$query->execute();
$query->store_result();
$query->bind_result(
    $IdClienteRow,
    $NClienteRow,
    $ClienteRow,
    $TelefonounoRow,
    $TelefonodosRow,
    $CorreoRow,
    $DireccionRow,
    $condicionAmpliarRow,
    $formaPagoRow,
    $fechaUltimaModificacionRow,
    $montoDeudaRow,
    $SegmentoRow,
    $ProvinciaRow
);

$row_cnt = $query->num_rows; // print_r($row_cnt); exit();

if ($row_cnt > 0){
  while($query->fetch()){
      $Cliente=$ClienteRow;
      $Contrato=$NClienteRow;
      $Condición=$condicionAmpliarRow;
      $FormaPago=$formaPagoRow;
      $TotalDeudaAMP=$montoDeudaRow;
      $FechaUltimaModif=$fechaUltimaModificacionRow;
      $Correo=$CorreoRow;
      $Segmento=$SegmentoRow;
      $Provincia=$ProvinciaRow;
  }




  
    $mensaje='<div class="callout bg-deuda">
                <h4><strong><i class="fa fa-bullhorn"></i> INFORMACIÓN GENERAL</strong>
              <small class="label bg-red verspeach">SPEACH</small>
            </h4>
                <strong>Cliente: </strong>'.$Cliente.'<br>
                <strong>Contrato: </strong>'.$Contrato.'<br>
                <strong>Condición: </strong>'.$Condición.'<br>
                <strong>Forma de Pago: </strong>'.$FormaPago.'<br>
                <strong>Total Deuda: </strong>'.$TotalDeudaAMP.'<br>
                <strong>Fecha Ultima Modif: </strong>'.$FechaUltimaModif.'<br>
                <br>';
                
    $mensaje.='<div style="text-align: center;"><img src="https://www.verismart.com.pe/verismart/img/btn_ticket3.png" class="irurl imagendv"></div>
                                        	 <div class="input-group hidden">
                                                            <input type="text" class="form-control hidden" id="urlreferidoHabilitado" name="urlreferidoHabilitado" value="https://www.verismart.com.pe/apps/referidostec/create/184/MGR511/RETEC/'.rawurlencode(explode( '/', htmlspecialchars($Cliente))[0]).'/511/'.$Correo.'/Referido Tecnico/'.$matricula.'/'.$Contrato.'" readonly>
                                                                <div class="input-group-addon copiarurl" style="cursor: pointer;">
                                                                  <i class="fa fa-copy"></i> Copiar URL
                                                                </div>
                                                                <div class="input-group-addon irurl" style="cursor: pointer;">
                                                                  <i class="fa fa-external-link"></i> Ir URL
                                                                </div>
                                            </div>
            <br>';

/*
if($Provincia=='Lima' || $Provincia=='Callao'){
    if($matricula=='M82699' || $matricula=='Q61370' || $matricula=='Q73540' || $matricula=='VE3110' || $matricula=='HN3456' || $matricula=='Q54094' || $matricula=='Q78916' || $matricula=='Q10683' || $matricula=='Q78917' || $matricula=='JR3452' || $matricula=='L93030' || $matricula=='P92250' || $matricula=='Q38659' || $matricula=='CZ2465' || $matricula=='CA7799' || $matricula=='L51482' || $matricula=='Q67644' || $matricula=='Q79911'){
        // if($Segmento=='RES'){
            $mensaje.='<div style="text-align: center;"><img src="https://www.verismart.com.pe/verismart/img/btn_ticket3.png" class="irurl imagendv"></div>                      	
                        
                                    	
                                        	 <div class="input-group hidden">
                                                            <input type="text" class="form-control hidden" id="urlreferidoHabilitado" name="urlreferidoHabilitado" value="https://www.verismart.com.pe/apps/referidostec/create/184/MGR511/RETEC/'.rawurlencode(explode( '/', htmlspecialchars($Cliente))[0]).'/511/'.$Correo.'/Referido Tecnico/'.$matricula.'/'.$Contrato.'" readonly>
                                                                <div class="input-group-addon copiarurl" style="cursor: pointer;">
                                                                  <i class="fa fa-copy"></i> Copiar URL
                                                                </div>
                                                                <div class="input-group-addon irurl" style="cursor: pointer;">
                                                                  <i class="fa fa-external-link"></i> Ir URL
                                                                </div>
                                            </div>                
                <br>';
        // }
        
    }else if($matricula=='Q12117' || $matricula=='Q60678' || $matricula=='PY3867' || $matricula=='Q21231' || $matricula=='Q64077' || $matricula=='Q64078' || $matricula=='Q68864' || $matricula=='Q67642' || $matricula=='Q70883' || $matricula=='Q71669' || $matricula=='ER6494' || $matricula=='JB4716' || $matricula=='D39502' || $matricula=='Q56436'){
            $mensaje.='<div style="text-align: center;"><img src="https://www.verismart.com.pe/verismart/img/btn_ticket3.png" class="irurl imagendv"></div>                      	
                        
                                    	
                                        	 <div class="input-group hidden">
                                                            <input type="text" class="form-control hidden" id="urlreferidoHabilitado" name="urlreferidoHabilitado" value="https://www.verismart.com.pe/apps/referidostec/create/184/MGR511/RETEC/'.rawurlencode(explode( '/', htmlspecialchars($Cliente))[0]).'/511/'.$Correo.'/Referido Tecnico/'.$matricula.'/'.$Contrato.'" readonly>
                                                                <div class="input-group-addon copiarurl" style="cursor: pointer;">
                                                                  <i class="fa fa-copy"></i> Copiar URL
                                                                </div>
                                                                <div class="input-group-addon irurl" style="cursor: pointer;">
                                                                  <i class="fa fa-external-link"></i> Ir URL
                                                                </div>
                                            </div>                
                <br>';        
    }
}else{
    if($matricula=='Q12117' || $matricula=='Q60678' || $matricula=='PY3867' || $matricula=='Q21231' || $matricula=='Q64077' || $matricula=='Q64078' || $matricula=='Q68864' || $matricula=='Q67642' || $matricula=='Q70883' || $matricula=='Q71669' || $matricula=='ER6494' || $matricula=='JB4716' || $matricula=='D39502' || $matricula=='Q56436'){
            $mensaje.='<div style="text-align: center;"><img src="https://www.verismart.com.pe/verismart/img/btn_ticket3.png" class="irurl imagendv"></div>                      	
                        
                                    	
                                        	 <div class="input-group hidden">
                                                            <input type="text" class="form-control hidden" id="urlreferidoHabilitado" name="urlreferidoHabilitado" value="https://www.verismart.com.pe/apps/referidostec/create/184/MGR511/RETEC/'.rawurlencode(explode( '/', htmlspecialchars($Cliente))[0]).'/511/'.$Correo.'/Referido Tecnico/'.$matricula.'/'.$Contrato.'" readonly>
                                                                <div class="input-group-addon copiarurl" style="cursor: pointer;">
                                                                  <i class="fa fa-copy"></i> Copiar URL
                                                                </div>
                                                                <div class="input-group-addon irurl" style="cursor: pointer;">
                                                                  <i class="fa fa-external-link"></i> Ir URL
                                                                </div>
                                            </div>                
                <br>';        
    }
}
*/
 
    $mensaje.='</div>
                <strong> Seleccione tipo de canal de la Ampliación:</strong> <br>
                <div class="col-xs-3">
                                                        <div class="thumbnail thumbnail_style" style="margin-bottom: 0px;">
                                                                <button class="postmantos btn btn-nuevo3" style="
     font-size: 40px;
     -moz-border-radius: 50%;
     -webkit-border-radius: 50%;
     border-radius: 50%;
     width: 90px;
     height: 90px;
                                              "><i class="fa fa-wrench"></i></button>
                                                                <div class="caption">
                                                                    <h3 style="
    font-size: 1em;
    font-weight: bold;">POSTMANTOS</h3>
                                                                </div>

                                                            </div>
                                                        
                </div>
                <div class="col-xs-3">
                                                        <div class="thumbnail thumbnail_style" style="margin-bottom: 0px;">
                                                                <button class="postmantoscamaraexterna btn btn-nuevo3" style="
     font-size: 40px;
     -moz-border-radius: 50%;
     -webkit-border-radius: 50%;
     border-radius: 50%;
     width: 90px;
     height: 90px;
                                              "><i class="fa fa-wrench"></i></button>
                                                                <div class="caption">
                                                                    <h3 style="
    font-size: 1em;
    font-weight: bold;">POSTMANTOS-CAMARA EXTERNA</h3>
                                                                </div>

                                                            </div>
                                                        
                </div>                
                                <div class="col-xs-3">
                                                        <div class="thumbnail thumbnail_style" style="margin-bottom: 0px;">
                                                                <button class="field btn btn-nuevo3" style="
     font-size: 40px;
     -moz-border-radius: 50%;
     -webkit-border-radius: 50%;
     border-radius: 50%;
     width: 90px;
     height: 90px;
                                              "><i class="fa fa-wrench"></i></button>
                                                                <div class="caption">
                                                                    <h3 style="
    font-size: 1em;
    font-weight: bold;">FIELD</h3>
                                                                </div>

                                                            </div>
                                                            
                                                        
                </div>
                                <div class="col-xs-3">
                                                        <div class="thumbnail thumbnail_style" style="margin-bottom: 0px;">
                                                                <button class="postmantosfield btn btn-nuevo3" style="
     font-size: 40px;
     -moz-border-radius: 50%;
     -webkit-border-radius: 50%;
     border-radius: 50%;
     width: 90px;
     height: 90px;
                                              "><i class="fa fa-wrench"></i></button>
                                                                <div class="caption">
                                                                    <h3 style="
    font-size: 1em;
    font-weight: bold;">POSTMANTOS-FIELD</h3>
                                                                </div>

                                                            </div>
                                                            
                                                        
                </div>
                ';
                
    $queryAmpliacion=$con->prepare("SELECT c.NCliente,a.FechaHoraREG,a.TipoCanal,a.Canal,a.GestorUpselling,a.Tecnico FROM tblampliacion a INNER JOIN tblcliente c on c.IdCliente=a.IdCliente WHERE c.NCliente=? and a.FechaHoraREG >= DATE_SUB(CURDATE(), INTERVAL 6 MONTH)");
    $queryAmpliacion->bind_param('s',$ncliente);
    $queryAmpliacion->execute();
    $queryAmpliacion->store_result();
    $queryAmpliacion->bind_result(
        $NClienteRow,
        $FechaHoraREGRow,
        $TipoCanalRow,
        $CanalRow,
        $GestorUpsellingRow,
        $TecnicoRow
        );
    
    $numrowsAmpliacion=  $queryAmpliacion->num_rows;
    if($numrowsAmpliacion>0){
        while($queryAmpliacion->fetch()){
        $json[] = array_map("utf8_encode",[
        'NCliente'=>$NClienteRow, 
        'FechaHoraREG'=>$FechaHoraREGRow,
        'TipoCanal'=>$TipoCanalRow,
        'Canal'=>$CanalRow,
        'Gestor'=>$GestorUpsellingRow,
        'Tecnico'=>$TecnicoRow
        ]);
        }
    }else{
        
    }

                
    $respuestaFinal = array(
            'tipo' => 1,
            'mensaje' => $mensaje,
            'data'=>$json
        );                
} else {
//   $mensaje = '  <div class="callout bg-deuda">
//                 <h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>
//               <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>
//                 <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>
//                 <br>
    // </div>';
    $mensaje = '<div class="callout bg-deuda">
                      <h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4><input type="hidden" value='.$ncliente.' id="numeroCliente">
                  <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado con el N° de cliente: '.$ncliente.'</strong><br>
                  </div><br><strong> Seleccione tipo de canal de la Ampliación:</strong> <br>
    <div class="col-xs-3">
    <div class="thumbnail thumbnail_style" style="margin-bottom: 0px;">
            <button class="postmantos btn btn-nuevo3" style="
font-size: 40px;
-moz-border-radius: 50%;
-webkit-border-radius: 50%;
border-radius: 50%;
width: 90px;
height: 90px;
"><i class="fa fa-wrench"></i></button>
            <div class="caption">
                <h3 style="
font-size: 1em;
font-weight: bold;">POSTMANTOS</h3>
            </div>

        </div>
    
</div>
<div class="col-xs-3">
    <div class="thumbnail thumbnail_style" style="margin-bottom: 0px;">
            <button class="postmantoscamaraexterna btn btn-nuevo3" style="
font-size: 40px;
-moz-border-radius: 50%;
-webkit-border-radius: 50%;
border-radius: 50%;
width: 90px;
height: 90px;
"><i class="fa fa-wrench"></i></button>
            <div class="caption">
                <h3 style="
font-size: 1em;
font-weight: bold;">POSTMANTOS-CAMARA EXTERNA</h3>
            </div>

        </div>
    
</div>                
<div class="col-xs-3">
    <div class="thumbnail thumbnail_style" style="margin-bottom: 0px;">
            <button class="field btn btn-nuevo3" style="
font-size: 40px;
-moz-border-radius: 50%;
-webkit-border-radius: 50%;
border-radius: 50%;
width: 90px;
height: 90px;
"><i class="fa fa-wrench"></i></button>
            <div class="caption">
                <h3 style="
font-size: 1em;
font-weight: bold;">FIELD</h3>
            </div>

        </div>
        
    
</div>
<div class="col-xs-3">
    <div class="thumbnail thumbnail_style" style="margin-bottom: 0px;">
            <button class="postmantosfield btn btn-nuevo3" style="
font-size: 40px;
-moz-border-radius: 50%;
-webkit-border-radius: 50%;
border-radius: 50%;
width: 90px;
height: 90px;
"><i class="fa fa-wrench"></i></button>
            <div class="caption">
                <h3 style="
font-size: 1em;
font-weight: bold;">POSTMANTOS-FIELD</h3>
            </div>

        </div>
        
    
</div>
';
    $respuestaFinal = array(
            'tipo' => 2,
            'mensaje' => $mensaje
        );
    
}

}else{
    $mensaje = '  	<div class="callout bg-deuda">
                    <h4><i class="fa fa-bullhorn"></i> ¡IMPORTANTE!</h4>
                    <strong>Ingrese N° Cliente para comenzar a realizar la busqueda.</strong><br>
                    <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>
                    <br>
                    </div>';
    $respuestaFinal = array(
            'tipo' => 3,
            'mensaje' => $mensaje
        );
}


echo json_encode($respuestaFinal);

// $query->close();
// $queryAmpliacion->close();
