<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
include '../helper/helper_validacion.php';

$q=NULL;

if (isset($_GET['q'])) {
    $q=sanitizaCampo($_GET['q'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $q = htmlspecialchars($q);
}

$q = "%{$q}%";
$sql = $con->prepare("SELECT IdUsuario, Matricula, concat(Matricula, ' - ', Nombres, ' ', Apellidos) as MatriculaNombreCompleto FROM dbUSUARIO.tblusuario WHERE IdPerfil IN (35,36) and Estado = 'Activo' and Matricula LIKE ?");
$sql->bind_param('s',$q);
$sql->execute();
$sql->store_result();
$sql->bind_result(
    $IdUsuarioRow,
    $MatriculaRow,
    $MatriculaNombreCompletoRow
    );
    

$json = [];

while($sql->fetch()){
    $IdUsuario = $IdUsuarioRow;
    $Matricula = $MatriculaRow;
    $MatriculaNombreCompleto = $MatriculaNombreCompletoRow;    
    $json[] = array_map("utf8_encode",['id'=>$Matricula, 'text'=>$MatriculaNombreCompleto]);
}

echo json_encode($json);

$sql->close();
