<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
include '../helper/helper_validacion.php';

$q=NULL;

if (isset($_POST['idArea'])) {
    $q=sanitizaCampo($_POST['idArea'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $q = htmlspecialchars($q);
}

//$q = "%{$q}%";
$sql = $con->prepare("SELECT S.IDSubarea, S.Subarea FROM dbMASTERUSUARIO.estructura_subarea S
		WHERE S.IDArea = ?"); 
$sql->bind_param('i',$q);
$sql->execute();
$sql->store_result();
$sql->bind_result(
    $IDSubarea,
    $Subarea
    );


$json = [];
while($sql->fetch()){
    $IDSubarea = $IDSubarea;
    $Subarea = $Subarea;
$json[] = array_map("utf8_encode",['id'=>$IDSubarea, 'text'=>$Subarea]);

}


echo json_encode($json);

$sql->close();
