<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
include '../helper/helper_validacion.php';

$q=NULL;

if (isset($_GET['q'])) {
    $q=sanitizaCampo($_GET['q'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $q = htmlspecialchars($q);
}

$q = "%{$q}%";
$sql = $con->prepare("SELECT D.IDDireccion, D.Direccion FROM dbMASTERUSUARIO.estructura_direccion D
		WHERE D.Direccion LIKE ?"); 
$sql->bind_param('s',$q);
$sql->execute();
$sql->store_result();
$sql->bind_result(
    $IDDireccion,
    $Direccion
    );


$json = [];
while($sql->fetch()){
    $IDDireccion = $IDDireccion;
    $Direccion = $Direccion;
$json[] = array_map("utf8_encode",['id'=>$IDDireccion, 'text'=>$Direccion]);

}


echo json_encode($json);

$sql->close();
