<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
include '../helper/helper_validacion.php';

$q=NULL;

if (isset($_POST['idSubarea'])) {
    $q=sanitizaCampo($_POST['idSubarea'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $q = htmlspecialchars($q);
}

// $q = "%{$q}%";
$sql = $con->prepare("SELECT ED.IDDelegacion, ED.Delegacion, ED.CC, ED.LN FROM dbMASTERUSUARIO.estructura_subarea_delegacion ESD INNER JOIN dbMASTERUSUARIO.estructura_delegacion ED ON ESD.IDDelegacion = ED.IDDelegacion 
        WHERE ESD.IDSubarea = ?"); 
$sql->bind_param('i',$q);
$sql->execute();
$sql->store_result();
$sql->bind_result(
    $IDDelegacion,
    $Delegacion,
    $CC,
    $LN
    );


$json = [];
while($sql->fetch()){
    $IDDelegacion = $IDDelegacion;
    $Delegacion = $Delegacion;
    $CC = $CC;
    $LN = $LN;
$json[] = array_map("utf8_encode",['id'=>$IDDelegacion, 'text'=>$CC.'-'.$LN.'|'.$Delegacion]);

}


echo json_encode($json);

$sql->close();
