<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
include '../helper/helper_validacion.php';

$q=NULL;

if (isset($_GET['q'])) {
    $q=sanitizaCampo($_GET['q'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $q = htmlspecialchars($q);
}

$q = "%{$q}%";
$sql = $con->prepare("SELECT a.IdArea,a.NombreArea FROM dbUSUARIO.tblarea a 
		WHERE a.NombreArea LIKE ?"); 
$sql->bind_param('s',$q);
$sql->execute();
$sql->store_result();
$sql->bind_result(
    $IdAreaRow,
    $NombreAreaRow
    );


$json = [];
while($sql->fetch()){
    $IdArea = $IdAreaRow;
    $NombreArea = $NombreAreaRow;
$json[] = array_map("utf8_encode",['id'=>$IdArea, 'text'=>$NombreArea]);

}


echo json_encode($json);

$sql->close();
