<?php
include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
require_once '../helper/helper_validacion.php';

$tipodocumento=NULL;
$documento=NULL;
$newdocumento=NULL;
$mesvisita=NULL;
$mesvisitadoc=NULL;
$mesvisitadocposterior=NULL;
$mesvisitadocanterior=NULL;

if (isset($_POST['tipodoc'])) {
    $tipodocumento = sanitizaCampo($_POST['tipodoc'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $documento = sanitizaCampo($_POST['documento'], 'sanitizeint|scapestring|htmlspecialchars',$con);
    $mesvisita = sanitizaCampo($_POST['mesvisit'], 'sanitizestring|scapestring|htmlspecialchars',$con);

    /*
    if($tipodocumento=="DNI"){
       if(strlen($documento)==8){
          $newdocumento='000'.$documento; 
       }
    }else{
       $newdocumento= $documento;
    }
    */
    $number = $documento;
    $length = 11;
    $newdocumento = substr(str_repeat(0, $length).$number, - $length);    
    $mesvisitadoc=round((strtotime($mesvisita)/86400 +25569-0.193056)).$newdocumento;
    $mesvisitadocposterior=round((strtotime($mesvisita."+ 1 month")/86400 +25569-0.193056)).$newdocumento;
    $mesvisitadocanterior=round((strtotime($mesvisita."- 1 month")/86400 +25569-0.193056)).$newdocumento;
}

$sql = $con->prepare("SELECT AccionMKT as Accion,PerfilScoring,IdConsultaScoring,FechaHoraReg FROM tbltmpscoring WHERE Area='Marketing' and CodGenVen in (?,?,?) order by IdConsultaScoring desc limit 1"); 
$sql->bind_param('sss',$mesvisitadoc,$mesvisitadocposterior,$mesvisitadocanterior);
$sql->execute();
$sql->store_result();
$sql->bind_result(
        $AccionRow,
        $PerfilScoringRow,
        $IdConsultaScoringRow,
        $FechaHoraRegRow
    );

$json = array();
if($sql->num_rows > 0){
    while($sql->fetch()){
    $json[] = array_map("utf8_encode",[
        'Accion'=>$AccionRow, 
        'PerfilScoring'=>$PerfilScoringRow,
        'IdConsultaScoring'=>$IdConsultaScoringRow,
        'FechaHoraReg'=>$FechaHoraRegRow
        ]);
    unset($row);
    }
}


echo json_encode($json);